/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble.quantile;

import cern.colt.PersistentObject;
import java.util.Arrays;

public class DoubleEquiDepthHistogram
extends PersistentObject {
    protected double[] binBoundaries;

    public DoubleEquiDepthHistogram(double[] dArray) {
        this.binBoundaries = dArray;
    }

    public int binOfElement(double d) {
        int n = Arrays.binarySearch(this.binBoundaries, d);
        if (n >= 0) {
            if (n == this.binBoundaries.length - 1) {
                --n;
            }
        } else {
            if (++n == 0 || n == this.binBoundaries.length) {
                throw new IllegalArgumentException("Element=" + d + " not contained in any bin.");
            }
            --n;
        }
        return n;
    }

    public int bins() {
        return this.binBoundaries.length - 1;
    }

    public double endOfBin(int n) {
        return this.binBoundaries[n + 1];
    }

    public double percentFromTo(double d, double d2) {
        return this.phi(d2) - this.phi(d);
    }

    public double phi(double d) {
        int n = this.binBoundaries.length;
        if (d <= this.binBoundaries[0]) {
            return 0.0;
        }
        if (d >= this.binBoundaries[n - 1]) {
            return 1.0;
        }
        double d2 = 1.0 / (double)(n - 1);
        int n2 = Arrays.binarySearch(this.binBoundaries, d);
        if (n2 >= 0) {
            return d2 * (double)n2;
        }
        int n3 = -n2 - 1;
        double d3 = this.binBoundaries[n3 - 1];
        double d4 = this.binBoundaries[n3] - d3;
        double d5 = (d - d3) / d4;
        return d2 * (d5 + (double)(n3 - 1));
    }

    public int size() {
        return this.binBoundaries.length;
    }

    public double startOfBin(int n) {
        return this.binBoundaries[n];
    }

    public static void test(double d) {
        double[] dArray = new double[]{50.0, 100.0, 200.0, 300.0, 1400.0, 1500.0, 1600.0, 1700.0, 1800.0, 1900.0, 2000.0};
        DoubleEquiDepthHistogram doubleEquiDepthHistogram = new DoubleEquiDepthHistogram(dArray);
        System.out.println("elem=" + d + ", phi=" + doubleEquiDepthHistogram.phi(d));
    }
}

