/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.tfloat.FloatDescriptive;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinder;

class ExactFloatQuantileFinder
extends PersistentObject
implements FloatQuantileFinder {
    protected FloatArrayList buffer = new FloatArrayList(0);
    protected boolean isSorted;

    public ExactFloatQuantileFinder() {
        this.clear();
    }

    public void add(float f) {
        this.buffer.add(f);
        this.isSorted = false;
    }

    public void addAllOf(FloatArrayList floatArrayList) {
        this.addAllOfFromTo(floatArrayList, 0, floatArrayList.size() - 1);
    }

    public void addAllOfFromTo(FloatArrayList floatArrayList, int n, int n2) {
        this.buffer.addAllOfFromTo(floatArrayList, n, n2);
        this.isSorted = false;
    }

    public void clear() {
        this.buffer.clear();
        this.buffer.trimToSize();
        this.isSorted = false;
    }

    public Object clone() {
        ExactFloatQuantileFinder exactFloatQuantileFinder = (ExactFloatQuantileFinder)super.clone();
        if (this.buffer != null) {
            exactFloatQuantileFinder.buffer = exactFloatQuantileFinder.buffer.copy();
        }
        return exactFloatQuantileFinder;
    }

    public boolean contains(float f) {
        this.sort();
        return this.buffer.binarySearch(f) >= 0;
    }

    public boolean forEach(FloatProcedure floatProcedure) {
        float[] fArray = this.buffer.elements();
        int n = (int)this.size();
        int n2 = 0;
        while (n2 < n) {
            if (floatProcedure.apply(fArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public long memory() {
        return this.buffer.elements().length;
    }

    public float phi(float f) {
        this.sort();
        return FloatDescriptive.rankInterpolated(this.buffer, f) / (float)this.size();
    }

    public FloatArrayList quantileElements(FloatArrayList floatArrayList) {
        this.sort();
        return FloatDescriptive.quantiles(this.buffer, floatArrayList);
    }

    public long size() {
        return this.buffer.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            this.buffer.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "(mem=" + this.memory() + ", size=" + this.size() + ")";
    }

    public long totalMemory() {
        return this.memory();
    }
}

