/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.jet.stat.Utils;
import cern.jet.stat.tfloat.quantile.FloatBuffer;
import cern.jet.stat.tfloat.quantile.FloatBufferSet;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinder;

abstract class FloatQuantileEstimator
extends PersistentObject
implements FloatQuantileFinder {
    protected FloatBufferSet bufferSet;
    protected FloatBuffer currentBufferToFill;
    protected int totalElementsFilled;

    protected FloatQuantileEstimator() {
    }

    public void add(float f) {
        ++this.totalElementsFilled;
        if (!this.sampleNextElement()) {
            return;
        }
        if (this.currentBufferToFill == null) {
            if (this.bufferSet._getFirstEmptyBuffer() == null) {
                this.collapse();
            }
            this.newBuffer();
        }
        this.currentBufferToFill.add(f);
        if (this.currentBufferToFill.isFull()) {
            this.currentBufferToFill = null;
        }
    }

    public void addAllOf(FloatArrayList floatArrayList) {
        this.addAllOfFromTo(floatArrayList, 0, floatArrayList.size() - 1);
    }

    public void addAllOfFromTo(FloatArrayList floatArrayList, int n, int n2) {
        int n3;
        float[] fArray = floatArrayList.elements();
        int n4 = n3 = this.bufferSet.k();
        float[] fArray2 = null;
        if (this.currentBufferToFill != null) {
            fArray2 = this.currentBufferToFill.values.elements();
            n4 = this.currentBufferToFill.size();
        }
        int n5 = n - 1;
        while (++n5 <= n2) {
            if (!this.sampleNextElement()) continue;
            if (n4 == n3) {
                if (this.bufferSet._getFirstEmptyBuffer() == null) {
                    this.collapse();
                }
                this.newBuffer();
                if (!this.currentBufferToFill.isAllocated) {
                    this.currentBufferToFill.allocate();
                }
                this.currentBufferToFill.isSorted = false;
                fArray2 = this.currentBufferToFill.values.elements();
                n4 = 0;
            }
            fArray2[n4++] = fArray[n5];
            if (n4 != n3) continue;
            this.currentBufferToFill.values.setSize(n4);
            this.currentBufferToFill = null;
        }
        if (this.currentBufferToFill != null) {
            this.currentBufferToFill.values.setSize(n4);
        }
        this.totalElementsFilled += n2 - n + 1;
    }

    protected FloatBuffer[] buffersToCollapse() {
        int n = this.bufferSet._getMinLevelOfFullOrPartialBuffers();
        return this.bufferSet._getFullOrPartialBuffersWithLevel(n);
    }

    public void clear() {
        this.totalElementsFilled = 0;
        this.currentBufferToFill = null;
        this.bufferSet.clear();
    }

    public Object clone() {
        FloatQuantileEstimator floatQuantileEstimator = (FloatQuantileEstimator)super.clone();
        if (this.bufferSet != null) {
            floatQuantileEstimator.bufferSet = (FloatBufferSet)floatQuantileEstimator.bufferSet.clone();
            if (this.currentBufferToFill != null) {
                int n = new ObjectArrayList(this.bufferSet.buffers).indexOf(this.currentBufferToFill, true);
                floatQuantileEstimator.currentBufferToFill = floatQuantileEstimator.bufferSet.buffers[n];
            }
        }
        return floatQuantileEstimator;
    }

    protected void collapse() {
        FloatBuffer[] floatBufferArray = this.buffersToCollapse();
        FloatBuffer floatBuffer = this.bufferSet.collapse(floatBufferArray);
        int n = floatBufferArray[0].level();
        floatBuffer.level(n + 1);
        this.postCollapse(floatBufferArray);
    }

    public boolean contains(float f) {
        return this.bufferSet.contains(f);
    }

    public boolean forEach(FloatProcedure floatProcedure) {
        return this.bufferSet.forEach(floatProcedure);
    }

    public long memory() {
        return this.bufferSet.memory();
    }

    protected abstract void newBuffer();

    public float phi(float f) {
        return this.bufferSet.phi(f);
    }

    protected abstract void postCollapse(FloatBuffer[] var1);

    protected FloatArrayList preProcessPhis(FloatArrayList floatArrayList) {
        return floatArrayList;
    }

    public FloatArrayList quantileElements(FloatArrayList floatArrayList) {
        floatArrayList = this.preProcessPhis(floatArrayList);
        long[] lArray = new long[floatArrayList.size()];
        long l = this.bufferSet.totalSize();
        int n = floatArrayList.size();
        while (--n >= 0) {
            lArray[n] = Utils.epsilonCeiling(floatArrayList.get(n) * (float)l) - 1L;
        }
        FloatBuffer[] floatBufferArray = this.bufferSet._getFullOrPartialBuffers();
        float[] fArray = new float[floatArrayList.size()];
        return new FloatArrayList(this.bufferSet.getValuesAtPositions(floatBufferArray, lArray));
    }

    protected abstract boolean sampleNextElement();

    protected void setUp(int n, int n2) {
        if (n < 2 || n2 < 1) {
            throw new IllegalArgumentException("Assertion: b>=2 && k>=1");
        }
        this.bufferSet = new FloatBufferSet(n, n2);
        this.clear();
    }

    public long size() {
        return this.totalElementsFilled;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        int n = this.bufferSet.b();
        int n2 = this.bufferSet.k();
        return string + "(mem=" + this.memory() + ", b=" + n + ", k=" + n2 + ", size=" + this.size() + ", totalSize=" + this.bufferSet.totalSize() + ")";
    }

    public long totalMemory() {
        return this.bufferSet.b() * this.bufferSet.k();
    }
}

