/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.utils;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import jcuda.jcublas.JCublas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrencyUtils {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(new CustomThreadFactory(new CustomExceptionHandler()));
    private static int NTHREADS = ConcurrencyUtils.getNumberOfProcessors();
    private static boolean USE_JCUBLAS = ConcurrencyUtils.checkJCublas();
    private static int THREADS_BEGIN_N_1D_FFT_2THREADS = 8192;
    private static int THREADS_BEGIN_N_1D_FFT_4THREADS = 65536;
    private static int THREADS_BEGIN_N_1D = 32768;
    private static int THREADS_BEGIN_N_2D = 65536;
    private static int THREADS_BEGIN_N_3D = 65536;

    public static void sleep(long l) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return THREAD_POOL.submit(callable);
    }

    public static Future<?> submit(Runnable runnable) {
        return THREAD_POOL.submit(runnable);
    }

    public static int getNumberOfProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static boolean checkJCublas() {
        int n;
        try {
            n = JCublas.cublasInit(false);
        }
        catch (Throwable throwable) {
            return false;
        }
        return n == 0;
    }

    public static int getNumberOfThreads() {
        return NTHREADS;
    }

    public static void waitForCompletion(Future<?>[] futureArray) {
        int n = futureArray.length;
        try {
            for (int i = 0; i < n; ++i) {
                futureArray[i].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static double waitForCompletion(Future<?>[] futureArray, DoubleDoubleFunction doubleDoubleFunction) {
        int n = futureArray.length;
        Double[] doubleArray = new Double[n];
        double d = 0.0;
        try {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                doubleArray[n2] = (Double)futureArray[n2].get();
            }
            d = doubleArray[0];
            for (n2 = 1; n2 < n; ++n2) {
                d = doubleDoubleFunction.apply(d, doubleArray[n2]);
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return d;
    }

    public static int waitForCompletion(Future<?>[] futureArray, IntIntFunction intIntFunction) {
        int n = futureArray.length;
        Integer[] integerArray = new Integer[n];
        int n2 = 0;
        try {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                integerArray[n3] = (Integer)futureArray[n3].get();
            }
            n2 = integerArray[0];
            for (n3 = 1; n3 < n; ++n3) {
                n2 = intIntFunction.apply(n2, integerArray[n3]);
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return n2;
    }

    public static Object waitForCompletion(Future<?>[] futureArray, ObjectObjectFunction objectObjectFunction) {
        int n = futureArray.length;
        Object[] objectArray = new Object[n];
        Object object = null;
        try {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                objectArray[n2] = (Integer)futureArray[n2].get();
            }
            object = objectArray[0];
            for (n2 = 1; n2 < n; ++n2) {
                object = objectObjectFunction.apply(object, objectArray[n2]);
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return object;
    }

    public static double[] waitForCompletion(Future<?>[] futureArray, DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        int n = futureArray.length;
        double[][] dArray = new double[n][2];
        double[] dArray2 = null;
        try {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = (double[])futureArray[n2].get();
            }
            dArray2 = dArray[0];
            for (n2 = 1; n2 < n; ++n2) {
                dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dArray[n2]);
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return dArray2;
    }

    public static float[] waitForCompletion(Future<?>[] futureArray, FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        int n = futureArray.length;
        float[][] fArray = new float[n][2];
        float[] fArray2 = null;
        try {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                fArray[n2] = (float[])futureArray[n2].get();
            }
            fArray2 = fArray[0];
            for (n2 = 1; n2 < n; ++n2) {
                fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fArray[n2]);
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return fArray2;
    }

    public static float waitForCompletion(Future<?>[] futureArray, FloatFloatFunction floatFloatFunction) {
        int n = futureArray.length;
        Float[] floatArray = new Float[n];
        float f = 0.0f;
        try {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                floatArray[n2] = (Float)futureArray[n2].get();
            }
            f = floatArray[0].floatValue();
            for (n2 = 1; n2 < n; ++n2) {
                f = floatFloatFunction.apply(f, floatArray[n2].floatValue());
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return f;
    }

    public static boolean getUseJCublas() {
        return USE_JCUBLAS;
    }

    public static void setUseJCublas(boolean bl) {
        USE_JCUBLAS = bl;
    }

    public static int getThreadsBeginN_1D() {
        return THREADS_BEGIN_N_1D;
    }

    public static int getThreadsBeginN_1D_FFT_2Threads() {
        return THREADS_BEGIN_N_1D_FFT_2THREADS;
    }

    public static int getThreadsBeginN_1D_FFT_4Threads() {
        return THREADS_BEGIN_N_1D_FFT_4THREADS;
    }

    public static int getThreadsBeginN_2D() {
        return THREADS_BEGIN_N_2D;
    }

    public static int getThreadsBeginN_3D() {
        return THREADS_BEGIN_N_3D;
    }

    public static void setThreadsBeginN_1D_FFT_2Threads(int n) {
        THREADS_BEGIN_N_1D_FFT_2THREADS = n < 512 ? 512 : n;
    }

    public static void setThreadsBeginN_1D_FFT_4Threads(int n) {
        THREADS_BEGIN_N_1D_FFT_4THREADS = n < 512 ? 512 : n;
    }

    public static void setThreadsBeginN_1D(int n) {
        THREADS_BEGIN_N_1D = n;
    }

    public static void setThreadsBeginN_2D(int n) {
        THREADS_BEGIN_N_2D = n;
    }

    public static void setThreadsBeginN_3D(int n) {
        THREADS_BEGIN_N_3D = n;
    }

    public static void resetThreadsBeginN_FFT() {
        THREADS_BEGIN_N_1D_FFT_2THREADS = 8192;
        THREADS_BEGIN_N_1D_FFT_4THREADS = 65536;
    }

    public static void resetThreadsBeginN() {
        THREADS_BEGIN_N_1D = 32768;
        THREADS_BEGIN_N_2D = 65536;
        THREADS_BEGIN_N_3D = 65536;
    }

    public static void setNumberOfThreads(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater or equal 1");
        }
        NTHREADS = n;
    }

    public static int nextPow2(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((n & n - 1) == 0) {
            return n;
        }
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n |= n >>> 32;
        return n + 1;
    }

    public static int extendDimension(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        int n2 = ConcurrencyUtils.nextExp2(n);
        int n3 = n2 + 1;
        int n4 = (int)Math.round(Math.pow(2.0, n3));
        return n4;
    }

    public static int nextExp2(int n) {
        double d = Math.log(n) / Math.log(2.0);
        int n2 = (int)Math.ceil(d);
        double d2 = (double)n / Math.pow(2.0, n2);
        if (d2 == 0.5) {
            --n2;
        }
        return n2;
    }

    public static int prevPow2(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (int)Math.pow(2.0, Math.floor(Math.log(n) / Math.log(2.0)));
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private static final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final Thread.UncaughtExceptionHandler handler;

        CustomThreadFactory(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.handler = uncaughtExceptionHandler;
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = defaultFactory.newThread(runnable);
            thread.setUncaughtExceptionHandler(this.handler);
            return thread;
        }
    }

    private static class CustomExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CustomExceptionHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

