/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.buffer.tfloat.FloatBuffer;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.tfloat.AbstractFloatIntMap;
import cern.colt.map.tfloat.OpenFloatIntHashMap;
import cern.jet.random.tfloat.FloatUniform;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;
import cern.jet.stat.tfloat.FloatDescriptive;
import hep.aida.tfloat.bin.FloatBinBinFunction1D;
import hep.aida.tfloat.bin.QuantileFloatBin1D;

public class DynamicFloatBin1D
extends QuantileFloatBin1D {
    protected FloatArrayList elements = null;
    protected FloatArrayList sortedElements = null;
    protected boolean fixedOrder = false;
    protected boolean isSorted = true;
    protected boolean isIncrementalStatValid = true;
    protected boolean isSumOfInversionsValid = true;
    protected boolean isSumOfLogarithmsValid = true;

    public DynamicFloatBin1D() {
        this.clear();
        this.elements = new FloatArrayList();
        this.sortedElements = new FloatArrayList(0);
        this.fixedOrder = false;
        this.hasSumOfLogarithms = true;
        this.hasSumOfInversions = true;
    }

    public synchronized void add(float f) {
        this.elements.add(f);
        this.invalidateAll();
    }

    public synchronized void addAllOfFromTo(FloatArrayList floatArrayList, int n, int n2) {
        this.elements.addAllOfFromTo(floatArrayList, n, n2);
        this.invalidateAll();
    }

    public synchronized float aggregate(FloatFloatFunction floatFloatFunction, FloatFunction floatFunction) {
        int n = this.size();
        if (n == 0) {
            return Float.NaN;
        }
        float f = floatFunction.apply(this.elements.getQuick(n - 1));
        int n2 = n - 1;
        while (--n2 >= 0) {
            f = floatFloatFunction.apply(f, floatFunction.apply(this.elements.getQuick(n2)));
        }
        return f;
    }

    public synchronized void clear() {
        super.clear();
        if (this.elements != null) {
            this.elements.clear();
        }
        if (this.sortedElements != null) {
            this.sortedElements.clear();
        }
        this.validateAll();
    }

    protected void clearAllMeasures() {
        super.clearAllMeasures();
    }

    public synchronized Object clone() {
        DynamicFloatBin1D dynamicFloatBin1D = (DynamicFloatBin1D)super.clone();
        if (this.elements != null) {
            dynamicFloatBin1D.elements = dynamicFloatBin1D.elements.copy();
        }
        if (this.sortedElements != null) {
            dynamicFloatBin1D.sortedElements = dynamicFloatBin1D.sortedElements.copy();
        }
        return dynamicFloatBin1D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized float correlation(DynamicFloatBin1D dynamicFloatBin1D) {
        DynamicFloatBin1D dynamicFloatBin1D2 = dynamicFloatBin1D;
        synchronized (dynamicFloatBin1D2) {
            return this.covariance(dynamicFloatBin1D) / (this.standardDeviation() * dynamicFloatBin1D.standardDeviation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized float covariance(DynamicFloatBin1D dynamicFloatBin1D) {
        DynamicFloatBin1D dynamicFloatBin1D2 = dynamicFloatBin1D;
        synchronized (dynamicFloatBin1D2) {
            if (this.size() != dynamicFloatBin1D.size()) {
                throw new IllegalArgumentException("both bins must have same size");
            }
            float f = 0.0f;
            int n = this.size();
            while (--n >= 0) {
                f += this.elements.getQuick(n) * dynamicFloatBin1D.elements.getQuick(n);
            }
            float f2 = (f - this.sum() * dynamicFloatBin1D.sum() / (float)this.size()) / (float)this.size();
            return f2;
        }
    }

    public synchronized FloatArrayList elements() {
        return this.elements_unsafe().copy();
    }

    protected synchronized FloatArrayList elements_unsafe() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object object) {
        if (!(object instanceof DynamicFloatBin1D)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DynamicFloatBin1D dynamicFloatBin1D = (DynamicFloatBin1D)object;
        float[] fArray = this.sortedElements_unsafe().elements();
        DynamicFloatBin1D dynamicFloatBin1D2 = dynamicFloatBin1D;
        synchronized (dynamicFloatBin1D2) {
            float[] fArray2 = dynamicFloatBin1D.sortedElements_unsafe().elements();
            int n = this.size();
            return DynamicFloatBin1D.includes(fArray, fArray2, 0, n, 0, n) && DynamicFloatBin1D.includes(fArray2, fArray, 0, n, 0, n);
        }
    }

    private static boolean includes(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (fArray2[n3] < fArray[n]) {
                return false;
            }
            if (fArray[n] < fArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public synchronized void frequencies(FloatArrayList floatArrayList, IntArrayList intArrayList) {
        FloatDescriptive.frequencies(this.sortedElements_unsafe(), floatArrayList, intArrayList);
    }

    private synchronized AbstractFloatIntMap frequencyMap() {
        OpenFloatIntHashMap openFloatIntHashMap = new OpenFloatIntHashMap();
        int n = this.size();
        while (--n >= 0) {
            float f = this.elements.getQuick(n);
            ((AbstractFloatIntMap)openFloatIntHashMap).put(f, 1 + ((AbstractFloatIntMap)openFloatIntHashMap).get(f));
        }
        return openFloatIntHashMap;
    }

    public int getMaxOrderForSumOfPowers() {
        return Integer.MAX_VALUE;
    }

    public int getMinOrderForSumOfPowers() {
        return Integer.MIN_VALUE;
    }

    protected void invalidateAll() {
        this.isSorted = false;
        this.isIncrementalStatValid = false;
        this.isSumOfInversionsValid = false;
        this.isSumOfLogarithmsValid = false;
    }

    public synchronized boolean isRebinnable() {
        return true;
    }

    public synchronized float max() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.max;
    }

    public synchronized float min() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.min;
    }

    public synchronized float moment(int n, float f) {
        return FloatDescriptive.moment(this.elements, n, f);
    }

    public synchronized float quantile(float f) {
        return FloatDescriptive.quantile(this.sortedElements_unsafe(), f);
    }

    public synchronized float quantileInverse(float f) {
        return FloatDescriptive.quantileInverse(this.sortedElements_unsafe(), f);
    }

    public FloatArrayList quantiles(FloatArrayList floatArrayList) {
        return FloatDescriptive.quantiles(this.sortedElements_unsafe(), floatArrayList);
    }

    public synchronized boolean removeAllOf(FloatArrayList floatArrayList) {
        boolean bl = this.elements.removeAll(floatArrayList);
        if (bl) {
            this.clearAllMeasures();
            this.invalidateAll();
            this.size = 0;
            if (this.fixedOrder) {
                this.sortedElements.removeAll(floatArrayList);
                this.isSorted = true;
            }
        }
        return bl;
    }

    public synchronized void sample(int n, boolean bl, FloatRandomEngine floatRandomEngine, FloatBuffer floatBuffer) {
        if (floatRandomEngine == null) {
            floatRandomEngine = FloatUniform.makeDefaultGenerator();
        }
        floatBuffer.clear();
        if (!bl) {
            if (n > this.size()) {
                throw new IllegalArgumentException("n must be less than or equal to size()");
            }
            FloatRandomSamplingAssistant floatRandomSamplingAssistant = new FloatRandomSamplingAssistant(n, this.size(), floatRandomEngine);
            int n2 = n;
            while (--n2 >= 0) {
                if (!floatRandomSamplingAssistant.sampleNextElement()) continue;
                floatBuffer.add(this.elements.getQuick(n2));
            }
        } else {
            FloatUniform floatUniform = new FloatUniform(floatRandomEngine);
            int n3 = this.size();
            int n4 = n;
            while (--n4 >= 0) {
                floatBuffer.add(this.elements.getQuick(floatUniform.nextIntFromTo(0, n3 - 1)));
            }
            floatBuffer.flush();
        }
    }

    public synchronized DynamicFloatBin1D sampleBootstrap(DynamicFloatBin1D dynamicFloatBin1D, int n, FloatRandomEngine floatRandomEngine, FloatBinBinFunction1D floatBinBinFunction1D) {
        if (floatRandomEngine == null) {
            floatRandomEngine = FloatUniform.makeDefaultGenerator();
        }
        int n2 = 1000;
        int n3 = this.size();
        int n4 = dynamicFloatBin1D.size();
        DynamicFloatBin1D dynamicFloatBin1D2 = new DynamicFloatBin1D();
        FloatBuffer floatBuffer = dynamicFloatBin1D2.buffered(Math.min(n2, n3));
        DynamicFloatBin1D dynamicFloatBin1D3 = new DynamicFloatBin1D();
        FloatBuffer floatBuffer2 = dynamicFloatBin1D3.buffered(Math.min(n2, n4));
        DynamicFloatBin1D dynamicFloatBin1D4 = new DynamicFloatBin1D();
        FloatBuffer floatBuffer3 = dynamicFloatBin1D4.buffered(Math.min(n2, n));
        int n5 = n;
        while (--n5 >= 0) {
            dynamicFloatBin1D2.clear();
            dynamicFloatBin1D3.clear();
            this.sample(n3, true, floatRandomEngine, floatBuffer);
            dynamicFloatBin1D.sample(n4, true, floatRandomEngine, floatBuffer2);
            floatBuffer3.add(floatBinBinFunction1D.apply(dynamicFloatBin1D2, dynamicFloatBin1D3));
        }
        floatBuffer3.flush();
        return dynamicFloatBin1D4;
    }

    public void setFixedOrder(boolean bl) {
        this.fixedOrder = bl;
    }

    public synchronized int size() {
        return this.elements.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            if (this.fixedOrder) {
                this.sortedElements.clear();
                this.sortedElements.addAllOfFromTo(this.elements, 0, this.elements.size() - 1);
                this.sortedElements.sort();
            } else {
                this.updateIncrementalStats();
                this.invalidateAll();
                this.elements.sort();
                this.isIncrementalStatValid = true;
            }
            this.isSorted = true;
        }
    }

    public synchronized FloatArrayList sortedElements() {
        return this.sortedElements_unsafe().copy();
    }

    protected synchronized FloatArrayList sortedElements_unsafe() {
        this.sort();
        if (this.fixedOrder) {
            return this.sortedElements;
        }
        return this.elements;
    }

    public synchronized void standardize(float f, float f2) {
        FloatDescriptive.standardize(this.elements, f, f2);
        this.clearAllMeasures();
        this.invalidateAll();
        this.size = 0;
    }

    public synchronized float sum() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum;
    }

    public synchronized float sumOfInversions() {
        if (!this.isSumOfInversionsValid) {
            this.updateSumOfInversions();
        }
        return this.sumOfInversions;
    }

    public synchronized float sumOfLogarithms() {
        if (!this.isSumOfLogarithmsValid) {
            this.updateSumOfLogarithms();
        }
        return this.sumOfLogarithms;
    }

    public synchronized float sumOfPowers(int n) {
        if (n >= -1 && n <= 2) {
            return super.sumOfPowers(n);
        }
        return FloatDescriptive.sumOfPowers(this.elements, n);
    }

    public synchronized float sumOfSquares() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum_xx;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        FloatArrayList floatArrayList = new FloatArrayList();
        IntArrayList intArrayList = new IntArrayList();
        this.frequencies(floatArrayList, intArrayList);
        if (floatArrayList.size() < 100) {
            stringBuffer.append("Distinct elements: " + floatArrayList + "\n");
            stringBuffer.append("Frequencies: " + intArrayList + "\n");
        } else {
            stringBuffer.append("Distinct elements & frequencies not printed (too many).");
        }
        return stringBuffer.toString();
    }

    public synchronized void trim(int n, int n2) {
        FloatArrayList floatArrayList = this.sortedElements();
        this.clear();
        this.addAllOfFromTo(floatArrayList, n, floatArrayList.size() - 1 - n2);
    }

    public synchronized float trimmedMean(int n, int n2) {
        return FloatDescriptive.trimmedMean(this.sortedElements_unsafe(), this.mean(), n, n2);
    }

    public synchronized void trimToSize() {
        this.elements.trimToSize();
        this.sortedElements.clear();
        this.sortedElements.trimToSize();
        if (this.fixedOrder) {
            this.isSorted = false;
        }
    }

    protected void updateIncrementalStats() {
        float[] fArray = new float[]{this.min, this.max, this.sum, this.sum_xx};
        FloatDescriptive.incrementalUpdate(this.elements, this.size, this.elements.size() - 1, fArray);
        this.min = fArray[0];
        this.max = fArray[1];
        this.sum = fArray[2];
        this.sum_xx = fArray[3];
        this.isIncrementalStatValid = true;
        this.size = this.elements.size();
    }

    protected void updateSumOfInversions() {
        this.sumOfInversions = FloatDescriptive.sumOfInversions(this.elements, 0, this.size() - 1);
        this.isSumOfInversionsValid = true;
    }

    protected void updateSumOfLogarithms() {
        this.sumOfLogarithms = FloatDescriptive.sumOfLogarithms(this.elements, 0, this.size() - 1);
        this.isSumOfLogarithmsValid = true;
    }

    protected void validateAll() {
        this.isSorted = true;
        this.isIncrementalStatValid = true;
        this.isSumOfInversionsValid = true;
        this.isSumOfLogarithmsValid = true;
    }
}

