/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.ref.FloatHistogram;

abstract class FloatAbstractHistogram1D
extends FloatHistogram
implements FloatIHistogram1D {
    protected FloatIAxis xAxis;

    FloatAbstractHistogram1D(String string) {
        super(string);
    }

    public int allEntries() {
        return this.entries() + this.extraEntries();
    }

    public int dimensions() {
        return 1;
    }

    public int entries() {
        int n = 0;
        int n2 = this.xAxis.bins();
        while (--n2 >= 0) {
            n += this.binEntries(n2);
        }
        return n;
    }

    public int extraEntries() {
        return this.binEntries(-2) + this.binEntries(-1);
    }

    int map(int n) {
        int n2 = this.xAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    public int[] minMaxBins() {
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = this.xAxis.bins();
        while (--n3 >= 0) {
            float f3 = this.binHeight(n3);
            if (f3 < f) {
                f = f3;
                n = n3;
            }
            if (!(f3 > f2)) continue;
            f2 = f3;
            n2 = n3;
        }
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    public float sumAllBinHeights() {
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    public float sumBinHeights() {
        float f = 0.0f;
        int n = this.xAxis.bins();
        while (--n >= 0) {
            f += this.binHeight(n);
        }
        return f;
    }

    public float sumExtraBinHeights() {
        return this.binHeight(-2) + this.binHeight(-1);
    }

    public FloatIAxis xAxis() {
        return this.xAxis;
    }
}

