/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;

public class FloatFixedAxis
implements FloatIAxis {
    private int bins;
    private float min;
    private float binWidth;
    private int xunder;
    private int xover;

    public FloatFixedAxis(int n, float f, float f2) {
        if (n < 1) {
            throw new IllegalArgumentException("bins=" + n);
        }
        if (f2 <= f) {
            throw new IllegalArgumentException("max <= min");
        }
        this.bins = n;
        this.min = f;
        this.binWidth = (f2 - f) / (float)n;
    }

    public float binCentre(int n) {
        return this.min + this.binWidth * (float)n + this.binWidth / 2.0f;
    }

    public float binLowerEdge(int n) {
        if (n == -2) {
            return Float.NEGATIVE_INFINITY;
        }
        if (n == -1) {
            return this.upperEdge();
        }
        return this.min + this.binWidth * (float)n;
    }

    public int bins() {
        return this.bins;
    }

    public float binUpperEdge(int n) {
        if (n == -2) {
            return this.min;
        }
        if (n == -1) {
            return Float.POSITIVE_INFINITY;
        }
        return this.min + this.binWidth * (float)(n + 1);
    }

    public float binWidth(int n) {
        return this.binWidth;
    }

    public int coordToIndex(float f) {
        if (f < this.min) {
            return -2;
        }
        int n = (int)Math.floor((f - this.min) / this.binWidth);
        if (n >= this.bins) {
            return -1;
        }
        return n;
    }

    public float lowerEdge() {
        return this.min;
    }

    public float upperEdge() {
        return this.min + this.binWidth * (float)this.bins;
    }

    int xgetBin(float f) {
        if (f < this.min) {
            return this.xunder;
        }
        int n = (int)Math.floor((f - this.min) / this.binWidth);
        if (n > this.bins) {
            return this.xover;
        }
        return n + 1;
    }

    int xmap(int n) {
        if (n >= this.bins) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return this.xunder;
        }
        if (n == -1) {
            return this.xover;
        }
        throw new IllegalArgumentException("bin=" + n);
    }
}

