/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import edu.emory.mathcs.utils.ConcurrencyUtils;
import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.ref.FloatAbstractHistogram1D;
import hep.aida.tfloat.ref.FloatFixedAxis;
import hep.aida.tfloat.ref.FloatHistogram1DContents;
import hep.aida.tfloat.ref.FloatVariableAxis;
import java.util.concurrent.Future;

public class FloatHistogram1D
extends FloatAbstractHistogram1D
implements FloatIHistogram1D {
    private float[] errors;
    private float[] heights;
    private int[] entries;
    private int nEntry;
    private float sumWeight;
    private float sumWeightSquared;
    private float mean;
    private float rms;

    public FloatHistogram1D(String string, float[] fArray) {
        this(string, new FloatVariableAxis(fArray));
    }

    public FloatHistogram1D(String string, FloatIAxis floatIAxis) {
        super(string);
        this.xAxis = floatIAxis;
        int n = floatIAxis.bins();
        this.entries = new int[n + 2];
        this.heights = new float[n + 2];
        this.errors = new float[n + 2];
    }

    public FloatHistogram1D(String string, int n, float f, float f2) {
        this(string, new FloatFixedAxis(n, f, f2));
    }

    public int allEntries() {
        return this.nEntry;
    }

    public int binEntries(int n) {
        return this.entries[this.map(n)];
    }

    public float binError(int n) {
        return (float)Math.sqrt(this.errors[this.map(n)]);
    }

    public float binHeight(int n) {
        return this.heights[this.map(n)];
    }

    public float equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    public void fill(float f) {
        int n;
        int n2 = n = this.map(this.xAxis.coordToIndex(f));
        this.entries[n2] = this.entries[n2] + 1;
        int n3 = n;
        this.heights[n3] = this.heights[n3] + 1.0f;
        int n4 = n;
        this.errors[n4] = this.errors[n4] + 1.0f;
        ++this.nEntry;
        this.sumWeight += 1.0f;
        this.sumWeightSquared += 1.0f;
        this.mean += f;
        this.rms += f * f;
    }

    public void fill(float f, float f2) {
        int n;
        int n2 = n = this.map(this.xAxis.coordToIndex(f));
        this.entries[n2] = this.entries[n2] + 1;
        int n3 = n;
        this.heights[n3] = this.heights[n3] + f2;
        int n4 = n;
        this.errors[n4] = this.errors[n4] + f2 * f2;
        ++this.nEntry;
        this.sumWeight += f2;
        this.sumWeightSquared += f2 * f2;
        this.mean += f * f2;
        this.rms += f * f2 * f2;
    }

    public void fill_2D(final float[] fArray, int n, final int n2, final int n3, final int n4, final int n5) {
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n * n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int n;
                        float[] fArray5 = new float[FloatHistogram1D.this.errors.length];
                        float[] fArray2 = new float[FloatHistogram1D.this.heights.length];
                        int[] nArray = new int[FloatHistogram1D.this.entries.length];
                        int n22 = 0;
                        float f = 0.0f;
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        float f4 = 0.0f;
                        int n32 = n3 + n8 * n4;
                        for (int i = n8; i < n9; ++i) {
                            n = n32;
                            for (int j = 0; j < n2; ++j) {
                                int n42;
                                int n52 = n42 = FloatHistogram1D.this.map(FloatHistogram1D.this.xAxis.coordToIndex(fArray[n]));
                                nArray[n52] = nArray[n52] + 1;
                                int n6 = n42;
                                fArray2[n6] = fArray2[n6] + 1.0f;
                                int n7 = n42;
                                fArray5[n7] = fArray5[n7] + 1.0f;
                                ++n22;
                                f += 1.0f;
                                f2 += 1.0f;
                                f3 += fArray[n];
                                f4 += fArray[n] * fArray[n];
                                n += n5;
                            }
                            n32 += n4;
                        }
                        1 var10_11 = this;
                        synchronized (var10_11) {
                            for (n = 0; n < FloatHistogram1D.this.entries.length; ++n) {
                                float[] fArray3 = FloatHistogram1D.this.errors;
                                int n82 = n;
                                fArray3[n82] = fArray3[n82] + fArray5[n];
                                float[] fArray4 = FloatHistogram1D.this.heights;
                                int n92 = n;
                                fArray4[n92] = fArray4[n92] + fArray2[n];
                                int[] nArray2 = FloatHistogram1D.this.entries;
                                int n10 = n;
                                nArray2[n10] = nArray2[n10] + nArray[n];
                            }
                            FloatHistogram1D.this.nEntry += n22;
                            FloatHistogram1D.this.sumWeight += f;
                            FloatHistogram1D.this.sumWeightSquared += f2;
                            FloatHistogram1D.this.mean += f3;
                            FloatHistogram1D.this.rms += f4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3;
            for (int i = 0; i < n; ++i) {
                int n11 = n10;
                for (int j = 0; j < n2; ++j) {
                    int n12;
                    int n13 = n12 = this.map(this.xAxis.coordToIndex(fArray[n11]));
                    this.entries[n13] = this.entries[n13] + 1;
                    int n14 = n12;
                    this.heights[n14] = this.heights[n14] + 1.0f;
                    int n15 = n12;
                    this.errors[n15] = this.errors[n15] + 1.0f;
                    ++this.nEntry;
                    this.sumWeight += 1.0f;
                    this.sumWeightSquared += 1.0f;
                    this.mean += fArray[n11];
                    this.rms += fArray[n11] * fArray[n11];
                    n11 += n5;
                }
                n10 += n4;
            }
        }
    }

    public void fill_2D(final float[] fArray, final float[] fArray2, int n, final int n2, final int n3, final int n4, final int n5) {
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n * n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int n;
                        int n22 = n3 + n8 * n4;
                        float[] fArray5 = new float[FloatHistogram1D.this.errors.length];
                        float[] fArray22 = new float[FloatHistogram1D.this.heights.length];
                        int[] nArray = new int[FloatHistogram1D.this.entries.length];
                        int n32 = 0;
                        float f = 0.0f;
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        float f4 = 0.0f;
                        for (int i = n8; i < n9; ++i) {
                            n = n22;
                            for (int j = 0; j < n2; ++j) {
                                int n42 = FloatHistogram1D.this.map(FloatHistogram1D.this.xAxis.coordToIndex(fArray[n]));
                                int n52 = i * n2 + j;
                                float f5 = fArray2[n52] * fArray2[n52];
                                int n6 = n42;
                                nArray[n6] = nArray[n6] + 1;
                                int n7 = n42;
                                fArray22[n7] = fArray22[n7] + fArray2[n52];
                                int n82 = n42;
                                fArray5[n82] = fArray5[n82] + f5;
                                ++n32;
                                f += fArray2[n52];
                                f2 += f5;
                                f3 += fArray[n] * fArray2[n52];
                                f4 += fArray[n] * f5;
                                n += n5;
                            }
                            n22 += n4;
                        }
                        2 var10_11 = this;
                        synchronized (var10_11) {
                            for (n = 0; n < FloatHistogram1D.this.entries.length; ++n) {
                                float[] fArray3 = FloatHistogram1D.this.errors;
                                int n92 = n;
                                fArray3[n92] = fArray3[n92] + fArray5[n];
                                float[] fArray4 = FloatHistogram1D.this.heights;
                                int n10 = n;
                                fArray4[n10] = fArray4[n10] + fArray22[n];
                                int[] nArray2 = FloatHistogram1D.this.entries;
                                int n11 = n;
                                nArray2[n11] = nArray2[n11] + nArray[n];
                            }
                            FloatHistogram1D.this.nEntry += n32;
                            FloatHistogram1D.this.sumWeight += f;
                            FloatHistogram1D.this.sumWeightSquared += f2;
                            FloatHistogram1D.this.mean += f3;
                            FloatHistogram1D.this.rms += f4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3;
            for (int i = 0; i < n; ++i) {
                int n11 = n10;
                for (int j = 0; j < n2; ++j) {
                    int n12 = this.map(this.xAxis.coordToIndex(fArray[n11]));
                    int n13 = i * n2 + j;
                    float f = fArray2[n13] * fArray2[n13];
                    int n14 = n12;
                    this.entries[n14] = this.entries[n14] + 1;
                    int n15 = n12;
                    this.heights[n15] = this.heights[n15] + fArray2[n13];
                    int n16 = n12;
                    this.errors[n16] = this.errors[n16] + f;
                    ++this.nEntry;
                    this.sumWeight += fArray2[n13];
                    this.sumWeightSquared += f;
                    this.mean += fArray[n11] * fArray2[n13];
                    this.rms += fArray[n11] * f;
                    n11 += n5;
                }
                n10 += n4;
            }
        }
    }

    public FloatHistogram1DContents getContents() {
        return new FloatHistogram1DContents(this.entries, this.heights, this.errors, this.nEntry, this.sumWeight, this.sumWeightSquared, this.mean, this.rms);
    }

    public float mean() {
        return this.mean / this.sumWeight;
    }

    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = 0;
            this.heights[i] = 0.0f;
            this.errors[i] = 0.0f;
        }
        this.nEntry = 0;
        this.sumWeight = 0.0f;
        this.sumWeightSquared = 0.0f;
        this.mean = 0.0f;
        this.rms = 0.0f;
    }

    public float rms() {
        return (float)Math.sqrt(this.rms / this.sumWeight - this.mean * this.mean / this.sumWeight / this.sumWeight);
    }

    public void setContents(FloatHistogram1DContents floatHistogram1DContents) {
        this.entries = floatHistogram1DContents.getEntries();
        this.heights = floatHistogram1DContents.getHeights();
        this.errors = floatHistogram1DContents.getErrors();
        this.nEntry = floatHistogram1DContents.getNentry();
        this.sumWeight = floatHistogram1DContents.getSumWeight();
        this.sumWeightSquared = floatHistogram1DContents.getSumWeightSquared();
        this.mean = floatHistogram1DContents.getMean();
        this.rms = floatHistogram1DContents.getRms();
    }

    void setContents(int[] nArray, float[] fArray, float[] fArray2) {
        this.entries = nArray;
        this.heights = fArray;
        this.errors = fArray2;
        for (int i = 0; i < nArray.length; ++i) {
            this.nEntry += nArray[i];
            this.sumWeight += fArray[i];
        }
        this.sumWeightSquared = Float.NaN;
        this.mean = Float.NaN;
        this.rms = Float.NaN;
    }
}

