/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.ref.FloatAbstractHistogram2D;
import hep.aida.tfloat.ref.FloatFixedAxis;
import hep.aida.tfloat.ref.FloatHistogram1D;
import hep.aida.tfloat.ref.FloatVariableAxis;

public class FloatHistogram2D
extends FloatAbstractHistogram2D
implements FloatIHistogram2D {
    private float[][] heights;
    private float[][] errors;
    private int[][] entries;
    private int nEntry;
    private float sumWeight;
    private float sumWeightSquared;
    private float meanX;
    private float rmsX;
    private float meanY;
    private float rmsY;

    public FloatHistogram2D(String string, float[] fArray, float[] fArray2) {
        this(string, new FloatVariableAxis(fArray), new FloatVariableAxis(fArray2));
    }

    public FloatHistogram2D(String string, int n, float f, float f2, int n2, float f3, float f4) {
        this(string, new FloatFixedAxis(n, f, f2), new FloatFixedAxis(n2, f3, f4));
    }

    public FloatHistogram2D(String string, FloatIAxis floatIAxis, FloatIAxis floatIAxis2) {
        super(string);
        this.xAxis = floatIAxis;
        this.yAxis = floatIAxis2;
        int n = floatIAxis.bins();
        int n2 = floatIAxis2.bins();
        this.entries = new int[n + 2][n2 + 2];
        this.heights = new float[n + 2][n2 + 2];
        this.errors = new float[n + 2][n2 + 2];
    }

    public int allEntries() {
        return this.nEntry;
    }

    public int binEntries(int n, int n2) {
        return this.entries[this.mapX(n)][this.mapY(n2)];
    }

    public float binError(int n, int n2) {
        return (float)Math.sqrt(this.errors[this.mapX(n)][this.mapY(n2)]);
    }

    public float binHeight(int n, int n2) {
        return this.heights[this.mapX(n)][this.mapY(n2)];
    }

    public float equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    public void fill(float f, float f2) {
        int n = this.mapX(this.xAxis.coordToIndex(f));
        int n2 = this.mapY(this.yAxis.coordToIndex(f2));
        int[] nArray = this.entries[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] + 1;
        float[] fArray = this.heights[n];
        int n4 = n2;
        fArray[n4] = fArray[n4] + 1.0f;
        float[] fArray2 = this.errors[n];
        int n5 = n2;
        fArray2[n5] = fArray2[n5] + 1.0f;
        ++this.nEntry;
        this.sumWeight += 1.0f;
        this.sumWeightSquared += 1.0f;
        this.meanX += f;
        this.rmsX += f;
        this.meanY += f2;
        this.rmsY += f2;
    }

    public void fill(float f, float f2, float f3) {
        int n = this.mapX(this.xAxis.coordToIndex(f));
        int n2 = this.mapY(this.yAxis.coordToIndex(f2));
        int[] nArray = this.entries[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] + 1;
        float[] fArray = this.heights[n];
        int n4 = n2;
        fArray[n4] = fArray[n4] + f3;
        float[] fArray2 = this.errors[n];
        int n5 = n2;
        fArray2[n5] = fArray2[n5] + f3 * f3;
        ++this.nEntry;
        this.sumWeight += f3;
        this.sumWeightSquared += f3 * f3;
        this.meanX += f * f3;
        this.rmsX += f * f3 * f3;
        this.meanY += f2 * f3;
        this.rmsY += f2 * f3 * f3;
    }

    protected FloatIHistogram1D internalSliceX(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.xAxis.bins() + 2;
        int[] nArray = new int[n3];
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = n; j <= n2; ++j) {
                int n4 = i;
                nArray[n4] = nArray[n4] + this.entries[i][j];
                int n5 = i;
                fArray[n5] = fArray[n5] + this.heights[i][j];
                int n6 = i;
                fArray2[n6] = fArray2[n6] + this.errors[i][j];
            }
        }
        FloatHistogram1D floatHistogram1D = new FloatHistogram1D(string, this.xAxis);
        floatHistogram1D.setContents(nArray, fArray, fArray2);
        return floatHistogram1D;
    }

    protected FloatIHistogram1D internalSliceY(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.yAxis.bins() + 2;
        int[] nArray = new int[n3];
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = j;
                nArray[n4] = nArray[n4] + this.entries[i][j];
                int n5 = j;
                fArray[n5] = fArray[n5] + this.heights[i][j];
                int n6 = j;
                fArray2[n6] = fArray2[n6] + this.errors[i][j];
            }
        }
        FloatHistogram1D floatHistogram1D = new FloatHistogram1D(string, this.yAxis);
        floatHistogram1D.setContents(nArray, fArray, fArray2);
        return floatHistogram1D;
    }

    public float meanX() {
        return this.meanX / this.sumWeight;
    }

    public float meanY() {
        return this.meanY / this.sumWeight;
    }

    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[0].length; ++j) {
                this.entries[i][j] = 0;
                this.heights[i][j] = 0.0f;
                this.errors[i][j] = 0.0f;
            }
        }
        this.nEntry = 0;
        this.sumWeight = 0.0f;
        this.sumWeightSquared = 0.0f;
        this.meanX = 0.0f;
        this.rmsX = 0.0f;
        this.meanY = 0.0f;
        this.rmsY = 0.0f;
    }

    public float rmsX() {
        return (float)Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    public float rmsY() {
        return (float)Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    void setContents(int[][] nArray, float[][] fArray, float[][] fArray2) {
        this.entries = nArray;
        this.heights = fArray;
        this.errors = fArray2;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                this.nEntry += nArray[i][j];
                this.sumWeight += fArray[i][j];
            }
        }
        this.sumWeightSquared = Float.NaN;
        this.meanX = Float.NaN;
        this.rmsX = Float.NaN;
        this.meanY = Float.NaN;
        this.rmsY = Float.NaN;
    }

    public float sumAllBinHeights() {
        return this.sumWeight;
    }
}

