/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcublas;

public class JCuComplex {
    public float x;
    public float y;

    private JCuComplex() {
    }

    public static float cuCreal(JCuComplex jCuComplex) {
        return jCuComplex.x;
    }

    public static float cuCimag(JCuComplex jCuComplex) {
        return jCuComplex.y;
    }

    public static JCuComplex cuCmplx(float f, float f2) {
        JCuComplex jCuComplex = new JCuComplex();
        jCuComplex.x = f;
        jCuComplex.y = f2;
        return jCuComplex;
    }

    public static JCuComplex cuConj(JCuComplex jCuComplex) {
        return JCuComplex.cuCmplx(JCuComplex.cuCreal(jCuComplex), -JCuComplex.cuCimag(jCuComplex));
    }

    public static JCuComplex cuCadd(JCuComplex jCuComplex, JCuComplex jCuComplex2) {
        return JCuComplex.cuCmplx(JCuComplex.cuCreal(jCuComplex) + JCuComplex.cuCreal(jCuComplex2), JCuComplex.cuCimag(jCuComplex) + JCuComplex.cuCimag(jCuComplex2));
    }

    public static JCuComplex cuCmul(JCuComplex jCuComplex, JCuComplex jCuComplex2) {
        JCuComplex jCuComplex3 = JCuComplex.cuCmplx(JCuComplex.cuCreal(jCuComplex) * JCuComplex.cuCreal(jCuComplex2) - JCuComplex.cuCimag(jCuComplex) * JCuComplex.cuCimag(jCuComplex2), JCuComplex.cuCreal(jCuComplex) * JCuComplex.cuCimag(jCuComplex2) + JCuComplex.cuCimag(jCuComplex) * JCuComplex.cuCreal(jCuComplex2));
        return jCuComplex3;
    }

    public static JCuComplex cuCdiv(JCuComplex jCuComplex, JCuComplex jCuComplex2) {
        float f = Math.abs(JCuComplex.cuCreal(jCuComplex2)) + Math.abs(JCuComplex.cuCimag(jCuComplex2));
        float f2 = 1.0f / f;
        float f3 = JCuComplex.cuCreal(jCuComplex) * f2;
        float f4 = JCuComplex.cuCimag(jCuComplex) * f2;
        float f5 = JCuComplex.cuCreal(jCuComplex2) * f2;
        float f6 = JCuComplex.cuCimag(jCuComplex2) * f2;
        f = f5 * f5 + f6 * f6;
        f2 = 1.0f / f;
        JCuComplex jCuComplex3 = JCuComplex.cuCmplx((f3 * f5 + f4 * f6) * f2, (f4 * f5 - f3 * f6) * f2);
        return jCuComplex3;
    }

    public static float cuCabs(JCuComplex jCuComplex) {
        float f;
        float f2 = JCuComplex.cuCreal(jCuComplex);
        float f3 = JCuComplex.cuCimag(jCuComplex);
        if (f2 == 0.0f) {
            return f3;
        }
        if (f3 == 0.0f) {
            return f2;
        }
        if ((f2 = (float)Math.sqrt(f2)) < (f3 = (float)Math.sqrt(f3))) {
            f = f2;
            f2 = f3;
            f3 = f;
        }
        f = f3 / f2;
        return f2 * (float)Math.sqrt(1.0f + f * f);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

