/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcublas;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.security.CodeSource;
import jcuda.jcublas.JCuComplex;
import jcuda.jcublas.JCuDoubleComplex;

public class JCublas {
    public static final int CUBLAS_STATUS_SUCCESS = 0;
    public static final int CUBLAS_STATUS_NOT_INITIALIZED = 1;
    public static final int CUBLAS_STATUS_ALLOC_FAILED = 3;
    public static final int CUBLAS_STATUS_INVALID_VALUE = 7;
    public static final int CUBLAS_STATUS_ARCH_MISMATCH = 8;
    public static final int CUBLAS_STATUS_MAPPING_ERROR = 11;
    public static final int CUBLAS_STATUS_EXECUTION_FAILED = 13;
    public static final int CUBLAS_STATUS_INTERNAL_ERROR = 14;
    public static final int JCUBLAS_STATUS_MEMORY_ALREADY_USED = 0x10000001;
    public static final int JCUBLAS_STATUS_MEMORY_NOT_FOUND = 0x10000002;
    public static final int JCUBLAS_STATUS_INTERNAL_ERROR = 0x10000003;
    private static boolean defaultEmulation = false;

    private JCublas() {
    }

    public static void setEmulation(boolean bl) {
        defaultEmulation = bl;
    }

    public static int cublasInit() throws Throwable {
        return JCublas.cublasInit(defaultEmulation);
    }

    public static int cublasInit(boolean bl) throws Throwable {
        try {
            if (bl) {
                System.loadLibrary("JCublasEmu");
            } else {
                System.loadLibrary("JCublas");
            }
        }
        catch (Throwable throwable) {
            CodeSource codeSource = JCublas.class.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                throw new NullPointerException("sc == null");
            }
            File file = new File(codeSource.getLocation().toURI());
            if (bl) {
                System.load(file.getParentFile().getCanonicalPath().toString() + System.getProperty("file.separator") + "lib" + System.getProperty("file.separator") + JCublas.getNativeLibraryName("JCublasEmu"));
            }
            System.load(file.getParentFile().getCanonicalPath().toString() + System.getProperty("file.separator") + "lib" + System.getProperty("file.separator") + JCublas.getNativeLibraryName("JCublas"));
        }
        return JCublas.cublasInitNative();
    }

    private static OSType calculateOS() {
        String string = System.getProperty("os.name").toLowerCase();
        assert (string != null);
        if (string.startsWith("mac os x")) {
            return OSType.APPLE;
        }
        if (string.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (string.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (string.startsWith("sun")) {
            return OSType.SUN;
        }
        return OSType.UNKNOWN;
    }

    private static ARCHType calculateArch() {
        String string = System.getProperty("os.arch").toLowerCase();
        assert (string != null);
        if (string.equals("x86") || string.equals("i386")) {
            return ARCHType.X86;
        }
        if (string.startsWith("amd64") || string.startsWith("x86_64")) {
            return ARCHType.X86_64;
        }
        if (string.equals("ppc")) {
            return ARCHType.PPC;
        }
        if (string.startsWith("ppc")) {
            return ARCHType.PPC_64;
        }
        if (string.startsWith("sparc")) {
            return ARCHType.SPARC;
        }
        return ARCHType.UNKNOWN;
    }

    private static String getNativeLibraryName(String string) {
        OSType oSType = JCublas.calculateOS();
        String string2 = null;
        switch (oSType) {
            case APPLE: {
                string2 = string.toLowerCase() + "-" + oSType.toString().toLowerCase() + "-" + JCublas.calculateArch().toString().toLowerCase() + ".jnilib";
                break;
            }
            case LINUX: {
                string2 = string.toLowerCase() + "-" + oSType.toString().toLowerCase() + "-" + JCublas.calculateArch().toString().toLowerCase() + ".so";
                break;
            }
            case SUN: {
                string2 = string.toLowerCase() + "-" + oSType.toString().toLowerCase() + "-" + JCublas.calculateArch().toString().toLowerCase() + ".so";
                break;
            }
            case WINDOWS: {
                string2 = string.toLowerCase() + "-" + oSType.toString().toLowerCase() + "-" + JCublas.calculateArch().toString().toLowerCase() + ".dll";
                break;
            }
            case UNKNOWN: {
                string2 = "unknown";
            }
        }
        return string2;
    }

    private static native int cublasInitNative();

    public static native int cublasShutdown();

    public static native int cublasGetError();

    public static native int cublasAlloc(int var0, int var1, String var2);

    public static native int cublasFree(String var0);

    public static void setLogLevel(LogLevel logLevel) {
        JCublas.setLogLevel(logLevel.ordinal());
    }

    private static native void setLogLevel(int var0);

    public static native void printVector(int var0, String var1);

    public static native void printMatrix(int var0, String var1, int var2);

    private static native int cublasSetVector(int var0, int var1, Buffer var2, int var3, int var4, String var5, int var6, int var7);

    private static native int cublasGetVector(int var0, int var1, String var2, int var3, int var4, Buffer var5, int var6, int var7);

    private static native int cublasSetMatrix(int var0, int var1, int var2, Buffer var3, int var4, int var5, String var6, int var7, int var8);

    private static native int cublasGetMatrix(int var0, int var1, int var2, String var3, int var4, int var5, Buffer var6, int var7, int var8);

    public static int cublasSetVector(int n, FloatBuffer floatBuffer, int n2, String string, int n3) {
        return JCublas.cublasSetVector(n, floatBuffer, 0, n2, string, 0, n3);
    }

    public static int cublasSetVector(int n, FloatBuffer floatBuffer, int n2, int n3, String string, int n4, int n5) {
        return JCublas.cublasSetVector(n, 4, floatBuffer, n2, n3, string, n4, n5);
    }

    public static int cublasSetVector(int n, float[] fArray, int n2, String string, int n3) {
        return JCublas.cublasSetVector(n, fArray, 0, n2, string, 0, n3);
    }

    public static int cublasSetVector(int n, float[] fArray, int n2, int n3, String string, int n4, int n5) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        return JCublas.cublasSetVector(n, 4, floatBuffer, n2, n3, string, n4, n5);
    }

    public static int cublasSetVector(int n, JCuComplex[] jCuComplexArray, int n2, String string, int n3) {
        return JCublas.cublasSetVector(n, jCuComplexArray, 0, n2, string, 0, n3);
    }

    public static int cublasSetVector(int n, JCuComplex[] jCuComplexArray, int n2, int n3, String string, int n4, int n5) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(jCuComplexArray.length * 4 * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        int n6 = n2;
        int n7 = 0;
        while (n7 < n) {
            floatBuffer.put(n6 * 2 + 0, jCuComplexArray[n6].x);
            floatBuffer.put(n6 * 2 + 1, jCuComplexArray[n6].y);
            ++n7;
            n6 += n3;
        }
        return JCublas.cublasSetVector(n, 8, floatBuffer, 0, 1, string, n4, n5);
    }

    public static int cublasGetVector(int n, String string, int n2, FloatBuffer floatBuffer, int n3) {
        return JCublas.cublasGetVector(n, string, 0, n2, floatBuffer, 0, n3);
    }

    public static int cublasGetVector(int n, String string, int n2, int n3, FloatBuffer floatBuffer, int n4, int n5) {
        return JCublas.cublasGetVector(n, 4, string, n2, n3, floatBuffer, n4, n5);
    }

    public static int cublasGetVector(int n, String string, int n2, float[] fArray, int n3) {
        return JCublas.cublasGetVector(n, string, 0, n2, fArray, 0, n3);
    }

    public static int cublasGetVector(int n, String string, int n2, int n3, float[] fArray, int n4, int n5) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        int n6 = JCublas.cublasGetVector(n, 4, string, n2, n3, floatBuffer, n4, n5);
        if (n6 == 0) {
            floatBuffer.rewind();
            if (n3 == 1 && n5 == 1) {
                floatBuffer.get(fArray, n4, n);
            } else {
                int n7 = n4;
                int n8 = 0;
                while (n8 < n) {
                    fArray[n7] = floatBuffer.get(n7);
                    ++n8;
                    n7 += n5;
                }
            }
        }
        return n6;
    }

    public static int cublasGetVector(int n, String string, int n2, JCuComplex[] jCuComplexArray, int n3) {
        return JCublas.cublasGetVector(n, string, 0, n2, jCuComplexArray, 0, n3);
    }

    public static int cublasGetVector(int n, String string, int n2, int n3, JCuComplex[] jCuComplexArray, int n4, int n5) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(jCuComplexArray.length * 4 * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        int n6 = JCublas.cublasGetVector(n, 8, string, n2, n3, floatBuffer, n4, n5);
        if (n6 == 0) {
            floatBuffer.rewind();
            int n7 = n4;
            int n8 = 0;
            while (n8 < n) {
                jCuComplexArray[n7].x = floatBuffer.get(n7 * 2 + 0);
                jCuComplexArray[n7].y = floatBuffer.get(n7 * 2 + 1);
                ++n8;
                n7 += n5;
            }
        }
        return n6;
    }

    public static int cublasSetMatrix(int n, int n2, FloatBuffer floatBuffer, int n3, String string, int n4) {
        return JCublas.cublasSetMatrix(n, n2, floatBuffer, 0, n3, string, 0, n4);
    }

    public static int cublasSetMatrix(int n, int n2, FloatBuffer floatBuffer, int n3, int n4, String string, int n5, int n6) {
        return JCublas.cublasSetMatrix(n, n2, 4, floatBuffer, n3, n4, string, n5, n6);
    }

    public static int cublasSetMatrix(int n, int n2, float[] fArray, int n3, String string, int n4) {
        return JCublas.cublasSetMatrix(n, n2, fArray, 0, n3, string, 0, n4);
    }

    public static int cublasSetMatrix(int n, int n2, float[] fArray, int n3, int n4, String string, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        return JCublas.cublasSetMatrix(n, n2, 4, floatBuffer, n3, n4, string, n5, n6);
    }

    public static int cublasSetMatrix(int n, int n2, JCuComplex[] jCuComplexArray, int n3, String string, int n4) {
        return JCublas.cublasSetMatrix(n, n2, jCuComplexArray, 0, n3, string, 0, n4);
    }

    public static int cublasSetMatrix(int n, int n2, JCuComplex[] jCuComplexArray, int n3, int n4, String string, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(jCuComplexArray.length * 4 * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        for (int i = 0; i < jCuComplexArray.length; ++i) {
            floatBuffer.put(jCuComplexArray[i].x);
            floatBuffer.put(jCuComplexArray[i].y);
        }
        return JCublas.cublasSetMatrix(n, n2, 4, floatBuffer, n3, n4, string, n5, n6);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, FloatBuffer floatBuffer, int n4) {
        return JCublas.cublasGetMatrix(n, n2, 4, string, 0, n3, floatBuffer, 0, n4);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, int n4, FloatBuffer floatBuffer, int n5, int n6) {
        return JCublas.cublasGetMatrix(n, n2, 4, string, n3, n4, floatBuffer, n5, n6);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, float[] fArray, int n4) {
        return JCublas.cublasGetMatrix(n, n2, string, 0, n3, fArray, 0, n4);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, int n4, float[] fArray, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        int n7 = JCublas.cublasGetMatrix(n, n2, 4, string, n3, n4, floatBuffer, n5, n6);
        if (n7 == 0) {
            floatBuffer.rewind();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n8 = i * n6 + j + n5;
                    fArray[n8] = floatBuffer.get(n8);
                }
            }
        }
        return n7;
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, JCuComplex[] jCuComplexArray, int n4) {
        return JCublas.cublasGetMatrix(n, n2, string, 0, n3, jCuComplexArray, 0, n4);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, int n4, JCuComplex[] jCuComplexArray, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(jCuComplexArray.length * 4 * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        int n7 = JCublas.cublasGetMatrix(n, n2, 4, string, n3, n4, floatBuffer, n5, n6);
        if (n7 == 0) {
            floatBuffer.rewind();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n8 = i * n6 + j + n5;
                    jCuComplexArray[n8].x = floatBuffer.get(n8 * 2 + 0);
                    jCuComplexArray[n8].y = floatBuffer.get(n8 * 2 + 1);
                }
            }
        }
        return n7;
    }

    public static int cublasSetVector(int n, DoubleBuffer doubleBuffer, int n2, String string, int n3) {
        return JCublas.cublasSetVector(n, doubleBuffer, 0, n2, string, 0, n3);
    }

    public static int cublasSetVector(int n, DoubleBuffer doubleBuffer, int n2, int n3, String string, int n4, int n5) {
        return JCublas.cublasSetVector(n, 8, doubleBuffer, n2, n3, string, n4, n5);
    }

    public static int cublasSetVector(int n, double[] dArray, int n2, String string, int n3) {
        return JCublas.cublasSetVector(n, dArray, 0, n2, string, 0, n3);
    }

    public static int cublasSetVector(int n, double[] dArray, int n2, int n3, String string, int n4, int n5) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        doubleBuffer.put(dArray);
        return JCublas.cublasSetVector(n, 8, doubleBuffer, n2, n3, string, n4, n5);
    }

    public static int cublasSetVector(int n, JCuDoubleComplex[] jCuDoubleComplexArray, int n2, String string, int n3) {
        return JCublas.cublasSetVector(n, jCuDoubleComplexArray, 0, n2, string, 0, n3);
    }

    public static int cublasSetVector(int n, JCuDoubleComplex[] jCuDoubleComplexArray, int n2, int n3, String string, int n4, int n5) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(jCuDoubleComplexArray.length * 8 * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        int n6 = n2;
        int n7 = 0;
        while (n7 < n) {
            doubleBuffer.put(n6 * 2 + 0, jCuDoubleComplexArray[n6].x);
            doubleBuffer.put(n6 * 2 + 1, jCuDoubleComplexArray[n6].y);
            ++n7;
            n6 += n3;
        }
        return JCublas.cublasSetVector(n, 16, doubleBuffer, 0, 1, string, n4, n5);
    }

    public static int cublasGetVector(int n, String string, int n2, DoubleBuffer doubleBuffer, int n3) {
        return JCublas.cublasGetVector(n, string, 0, n2, doubleBuffer, 0, n3);
    }

    public static int cublasGetVector(int n, String string, int n2, int n3, DoubleBuffer doubleBuffer, int n4, int n5) {
        return JCublas.cublasGetVector(n, 8, string, n2, n3, doubleBuffer, n4, n5);
    }

    public static int cublasGetVector(int n, String string, int n2, double[] dArray, int n3) {
        return JCublas.cublasGetVector(n, string, 0, n2, dArray, 0, n3);
    }

    public static int cublasGetVector(int n, String string, int n2, int n3, double[] dArray, int n4, int n5) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        int n6 = JCublas.cublasGetVector(n, 8, string, n2, n3, doubleBuffer, n4, n5);
        if (n6 == 0) {
            doubleBuffer.rewind();
            if (n3 == 1 && n5 == 1) {
                doubleBuffer.get(dArray, n4, n);
            } else {
                int n7 = n4;
                int n8 = 0;
                while (n8 < n) {
                    dArray[n7] = doubleBuffer.get(n7);
                    ++n8;
                    n7 += n5;
                }
            }
        }
        return n6;
    }

    public static int cublasGetVector(int n, String string, int n2, JCuDoubleComplex[] jCuDoubleComplexArray, int n3) {
        return JCublas.cublasGetVector(n, string, 0, n2, jCuDoubleComplexArray, 0, n3);
    }

    public static int cublasGetVector(int n, String string, int n2, int n3, JCuDoubleComplex[] jCuDoubleComplexArray, int n4, int n5) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(jCuDoubleComplexArray.length * 8 * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        int n6 = JCublas.cublasGetVector(n, 8, string, n2, n3, doubleBuffer, n4, n5);
        if (n6 == 0) {
            doubleBuffer.rewind();
            int n7 = n4;
            int n8 = 0;
            while (n8 < n) {
                jCuDoubleComplexArray[n7].x = doubleBuffer.get(n7 * 2 + 0);
                jCuDoubleComplexArray[n7].y = doubleBuffer.get(n7 * 2 + 1);
                ++n8;
                n7 += n5;
            }
        }
        return n6;
    }

    public static int cublasSetMatrix(int n, int n2, DoubleBuffer doubleBuffer, int n3, String string, int n4) {
        return JCublas.cublasSetMatrix(n, n2, doubleBuffer, 0, n3, string, 0, n4);
    }

    public static int cublasSetMatrix(int n, int n2, DoubleBuffer doubleBuffer, int n3, int n4, String string, int n5, int n6) {
        return JCublas.cublasSetMatrix(n, n2, 8, doubleBuffer, n3, n4, string, n5, n6);
    }

    public static int cublasSetMatrix(int n, int n2, double[] dArray, int n3, String string, int n4) {
        return JCublas.cublasSetMatrix(n, n2, dArray, 0, n3, string, 0, n4);
    }

    public static int cublasSetMatrix(int n, int n2, double[] dArray, int n3, int n4, String string, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        doubleBuffer.put(dArray);
        return JCublas.cublasSetMatrix(n, n2, 8, doubleBuffer, n3, n4, string, n5, n6);
    }

    public static int cublasSetMatrix(int n, int n2, JCuDoubleComplex[] jCuDoubleComplexArray, int n3, String string, int n4) {
        return JCublas.cublasSetMatrix(n, n2, jCuDoubleComplexArray, 0, n3, string, 0, n4);
    }

    public static int cublasSetMatrix(int n, int n2, JCuDoubleComplex[] jCuDoubleComplexArray, int n3, int n4, String string, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(jCuDoubleComplexArray.length * 4 * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        for (int i = 0; i < jCuDoubleComplexArray.length; ++i) {
            doubleBuffer.put(jCuDoubleComplexArray[i].x);
            doubleBuffer.put(jCuDoubleComplexArray[i].y);
        }
        return JCublas.cublasSetMatrix(n, n2, 8, doubleBuffer, n3, n4, string, n5, n6);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, DoubleBuffer doubleBuffer, int n4) {
        return JCublas.cublasGetMatrix(n, n2, 8, string, 0, n3, doubleBuffer, 0, n4);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, int n4, DoubleBuffer doubleBuffer, int n5, int n6) {
        return JCublas.cublasGetMatrix(n, n2, 8, string, n3, n4, doubleBuffer, n5, n6);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, double[] dArray, int n4) {
        return JCublas.cublasGetMatrix(n, n2, string, 0, n3, dArray, 0, n4);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, int n4, double[] dArray, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        int n7 = JCublas.cublasGetMatrix(n, n2, 8, string, n3, n4, doubleBuffer, n5, n6);
        if (n7 == 0) {
            doubleBuffer.rewind();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n8 = i * n6 + j + n5;
                    dArray[n8] = doubleBuffer.get(n8);
                }
            }
        }
        return n7;
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, JCuDoubleComplex[] jCuDoubleComplexArray, int n4) {
        return JCublas.cublasGetMatrix(n, n2, string, 0, n3, jCuDoubleComplexArray, 0, n4);
    }

    public static int cublasGetMatrix(int n, int n2, String string, int n3, int n4, JCuDoubleComplex[] jCuDoubleComplexArray, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(jCuDoubleComplexArray.length * 8 * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        int n7 = JCublas.cublasGetMatrix(n, n2, 8, string, n3, n4, doubleBuffer, n5, n6);
        if (n7 == 0) {
            doubleBuffer.rewind();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n8 = i * n6 + j + n5;
                    jCuDoubleComplexArray[n8].x = doubleBuffer.get(n8 * 2 + 0);
                    jCuDoubleComplexArray[n8].y = doubleBuffer.get(n8 * 2 + 1);
                }
            }
        }
        return n7;
    }

    public static native void cublasSrotm(int var0, String var1, int var2, int var3, String var4, int var5, int var6, float[] var7);

    public static void cublasSrotm(int n, String string, int n2, String string2, int n3, float[] fArray) {
        JCublas.cublasSrotm(n, string, 0, n2, string2, 0, n3, fArray);
    }

    public static native void cublasSrotmg(float[] var0, float[] var1, float[] var2, float var3, float[] var4);

    public static native void cublasDrotm(int var0, String var1, int var2, int var3, String var4, int var5, int var6, double[] var7);

    public static void cublasSrotm(int n, String string, int n2, String string2, int n3, double[] dArray) {
        JCublas.cublasDrotm(n, string, 0, n2, string2, 0, n3, dArray);
    }

    public static native void cublasDrotmg(double[] var0, double[] var1, double[] var2, double var3, double[] var5);

    public static native int cublasIsamax(int var0, String var1, int var2, int var3);

    public static int cublasIsamax(int n, String string, int n2) {
        return JCublas.cublasIsamax(n, string, 0, n2);
    }

    public static native int cublasIsamin(int var0, String var1, int var2, int var3);

    public static int cublasIsamin(int n, String string, int n2) {
        return JCublas.cublasIsamin(n, string, 0, n2);
    }

    public static native void cublasSaxpy(int var0, float var1, String var2, int var3, int var4, String var5, int var6, int var7);

    public static void cublasSaxpy(int n, float f, String string, int n2, String string2, int n3) {
        JCublas.cublasSaxpy(n, f, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasScopy(int var0, String var1, int var2, int var3, String var4, int var5, int var6);

    public static void cublasScopy(int n, String string, int n2, String string2, int n3) {
        JCublas.cublasScopy(n, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasSrot(int var0, String var1, int var2, int var3, String var4, int var5, int var6, float var7, float var8);

    public static void cublasSrot(int n, String string, int n2, String string2, int n3, float f, float f2) {
        JCublas.cublasSrot(n, string, 0, n2, string2, 0, n3, f, f2);
    }

    public static native void cublasSrotg(String var0, int var1, String var2, int var3, String var4, int var5, String var6, int var7);

    public static void cublasSrotg(String string, String string2, String string3, String string4) {
        JCublas.cublasSrotg(string, 0, string2, 0, string3, 0, string4, 0);
    }

    public static native void cublasSscal(int var0, float var1, String var2, int var3, int var4);

    public static void cublasSscal(int n, float f, String string, int n2) {
        JCublas.cublasSscal(n, f, string, 0, n2);
    }

    public static native void cublasSswap(int var0, String var1, int var2, int var3, String var4, int var5, int var6);

    public static void cublasSswap(int n, String string, int n2, String string2, int n3) {
        JCublas.cublasSswap(n, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasCaxpy(int var0, JCuComplex var1, String var2, int var3, int var4, String var5, int var6, int var7);

    public static void cublasCaxpy(int n, JCuComplex jCuComplex, String string, int n2, String string2, int n3) {
        JCublas.cublasCaxpy(n, jCuComplex, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasCcopy(int var0, String var1, int var2, int var3, String var4, int var5, int var6);

    public static void cublasCcopy(int n, String string, int n2, String string2, int n3) {
        JCublas.cublasCcopy(n, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasCscal(int var0, JCuComplex var1, String var2, int var3, int var4);

    public static void cublasCscal(int n, JCuComplex jCuComplex, String string, int n2) {
        JCublas.cublasCscal(n, jCuComplex, string, 0, n2);
    }

    public static native void cublasCrotg(String var0, int var1, JCuComplex var2, String var3, int var4, String var5, int var6);

    public static void cublasCrotg(String string, JCuComplex jCuComplex, String string2, String string3) {
        JCublas.cublasCrotg(string, 0, jCuComplex, string2, 0, string3, 0);
    }

    public static native void cublasCrot(int var0, String var1, int var2, int var3, String var4, int var5, int var6, float var7, JCuComplex var8);

    public static void cublasCrot(int n, String string, int n2, String string2, int n3, float f, JCuComplex jCuComplex) {
        JCublas.cublasCrot(n, string, 0, n2, string2, 0, n3, f, jCuComplex);
    }

    public static native void cublasCsrot(int var0, String var1, int var2, int var3, String var4, int var5, int var6, float var7, float var8);

    public static void cublasCsrot(int n, String string, int n2, String string2, int n3, float f, float f2) {
        JCublas.cublasCsrot(n, string, 0, n2, string2, 0, n3, f, f2);
    }

    public static native void cublasCsscal(int var0, float var1, String var2, int var3, int var4);

    public static void cublasCsscal(int n, float f, String string, int n2) {
        JCublas.cublasCsscal(n, f, string, 0, n2);
    }

    public static native void cublasCswap(int var0, String var1, int var2, int var3, String var4, int var5, int var6);

    public static void cublasCswap(int n, String string, int n2, String string2, int n3) {
        JCublas.cublasCswap(n, string, 0, n2, string2, 0, n3);
    }

    public static native int cublasIcamax(int var0, String var1, int var2, int var3);

    public static int cublasIcamax(int n, String string, int n2) {
        return JCublas.cublasIcamax(n, string, 0, n2);
    }

    public static native int cublasIcamin(int var0, String var1, int var2, int var3);

    public static int cublasIcamin(int n, String string, int n2) {
        return JCublas.cublasIcamin(n, string, 0, n2);
    }

    public static native void cublasSgbmv(char var0, int var1, int var2, int var3, int var4, float var5, String var6, int var7, int var8, String var9, int var10, int var11, float var12, String var13, int var14, int var15);

    public static void cublasSgbmv(char c, int n, int n2, int n3, int n4, float f, String string, int n5, String string2, int n6, float f2, String string3, int n7) {
        JCublas.cublasSgbmv(c, n, n2, n3, n4, f, string, 0, n5, string2, 0, n6, f2, string3, 0, n7);
    }

    public static native void cublasSgemv(char var0, int var1, int var2, float var3, String var4, int var5, int var6, String var7, int var8, int var9, float var10, String var11, int var12, int var13);

    public static void cublasSgemv(char c, int n, int n2, float f, String string, int n3, String string2, int n4, float f2, String string3, int n5) {
        JCublas.cublasSgemv(c, n, n2, f, string, 0, n3, string2, 0, n4, f2, string3, 0, n5);
    }

    public static native void cublasSger(int var0, int var1, float var2, String var3, int var4, int var5, String var6, int var7, int var8, String var9, int var10, int var11);

    public static void cublasSger(int n, int n2, float f, String string, int n3, String string2, int n4, String string3, int n5) {
        JCublas.cublasSger(n, n2, f, string, 0, n3, string2, 0, n4, string3, 0, n5);
    }

    public static native void cublasSsbmv(char var0, int var1, int var2, float var3, String var4, int var5, int var6, String var7, int var8, int var9, float var10, String var11, int var12, int var13);

    public static void cublasSsbmv(char c, int n, int n2, float f, String string, int n3, String string2, int n4, float f2, String string3, int n5) {
        JCublas.cublasSsbmv(c, n, n2, f, string, 0, n3, string2, 0, n4, f2, string3, 0, n5);
    }

    public static native void cublasSspmv(char var0, int var1, float var2, String var3, int var4, String var5, int var6, int var7, float var8, String var9, int var10, int var11);

    public static void cublasSspmv(char c, int n, float f, String string, String string2, int n2, float f2, String string3, int n3) {
        JCublas.cublasSspmv(c, n, f, string, 0, string2, 0, n2, f2, string3, 0, n3);
    }

    public static native void cublasSspr(char var0, int var1, float var2, String var3, int var4, int var5, String var6, int var7);

    public static void cublasSspr(char c, int n, float f, String string, int n2, String string2) {
        JCublas.cublasSspr(c, n, f, string, 0, n2, string2, 0);
    }

    public static native void cublasSspr2(char var0, int var1, float var2, String var3, int var4, int var5, String var6, int var7, int var8, String var9, int var10);

    public static void cublasSspr2(char c, int n, float f, String string, int n2, String string2, int n3, String string3) {
        JCublas.cublasSspr2(c, n, f, string, 0, n2, string2, 0, n3, string3, 0);
    }

    public static native void cublasSsymv(char var0, int var1, float var2, String var3, int var4, int var5, String var6, int var7, int var8, float var9, String var10, int var11, int var12);

    public static void cublasSsymv(char c, int n, float f, String string, int n2, String string2, int n3, float f2, String string3, int n4) {
        JCublas.cublasSsymv(c, n, f, string, 0, n2, string2, 0, n3, f2, string3, 0, n4);
    }

    public static native void cublasSsyr(char var0, int var1, float var2, String var3, int var4, int var5, String var6, int var7, int var8);

    public static void cublasSsyr(char c, int n, float f, String string, int n2, String string2, int n3) {
        JCublas.cublasSsyr(c, n, f, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasSsyr2(char var0, int var1, float var2, String var3, int var4, int var5, String var6, int var7, int var8, String var9, int var10, int var11);

    public static void cublasSsyr2(char c, int n, float f, String string, int n2, String string2, int n3, String string3, int n4) {
        JCublas.cublasSsyr2(c, n, f, string, 0, n2, string2, 0, n3, string3, 0, n4);
    }

    public static native void cublasStbmv(char var0, char var1, char var2, int var3, int var4, String var5, int var6, int var7, String var8, int var9, int var10);

    public static void cublasStbmv(char c, char c2, char c3, int n, int n2, String string, int n3, String string2, int n4) {
        JCublas.cublasStbmv(c, c2, c3, n, n2, string, 0, n3, string2, 0, n4);
    }

    public static native void cublasStbsv(char var0, char var1, char var2, int var3, int var4, String var5, int var6, int var7, String var8, int var9, int var10);

    public static void cublasStbsv(char c, char c2, char c3, int n, int n2, String string, int n3, String string2, int n4) {
        JCublas.cublasStbsv(c, c2, c3, n, n2, string, 0, n3, string2, 0, n4);
    }

    public static native void cublasStpmv(char var0, char var1, char var2, int var3, String var4, int var5, String var6, int var7, int var8);

    public static void cublasStpmv(char c, char c2, char c3, int n, String string, String string2, int n2) {
        JCublas.cublasStpmv(c, c2, c3, n, string, 0, string2, 0, n2);
    }

    public static native void cublasStpsv(char var0, char var1, char var2, int var3, String var4, int var5, String var6, int var7, int var8);

    public static void cublasStpsv(char c, char c2, char c3, int n, String string, String string2, int n2) {
        JCublas.cublasStpsv(c, c2, c3, n, string, 0, string2, 0, n2);
    }

    public static native void cublasStrmv(char var0, char var1, char var2, int var3, String var4, int var5, int var6, String var7, int var8, int var9);

    public static void cublasStrmv(char c, char c2, char c3, int n, String string, int n2, String string2, int n3) {
        JCublas.cublasStrmv(c, c2, c3, n, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasStrsv(char var0, char var1, char var2, int var3, String var4, int var5, int var6, String var7, int var8, int var9);

    public static void cublasStrsv(char c, char c2, char c3, int n, String string, int n2, String string2, int n3) {
        JCublas.cublasStrsv(c, c2, c3, n, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasSgemm(char var0, char var1, int var2, int var3, int var4, float var5, String var6, int var7, int var8, String var9, int var10, int var11, float var12, String var13, int var14, int var15);

    public static void cublasSgemm(char c, char c2, int n, int n2, int n3, float f, String string, int n4, String string2, int n5, float f2, String string3, int n6) {
        JCublas.cublasSgemm(c, c2, n, n2, n3, f, string, 0, n4, string2, 0, n5, f2, string3, 0, n6);
    }

    public static native void cublasSsymm(char var0, char var1, int var2, int var3, float var4, String var5, int var6, int var7, String var8, int var9, int var10, float var11, String var12, int var13, int var14);

    public static void cublasSsymm(char c, char c2, int n, int n2, float f, String string, int n3, String string2, int n4, float f2, String string3, int n5) {
        JCublas.cublasSsymm(c, c2, n, n2, f, string, 0, n3, string2, 0, n4, f2, string3, 0, n5);
    }

    public static native void cublasSsyrk(char var0, char var1, int var2, int var3, float var4, String var5, int var6, int var7, float var8, String var9, int var10, int var11);

    public static void cublasSsyrk(char c, char c2, int n, int n2, float f, String string, int n3, float f2, String string2, int n4) {
        JCublas.cublasSsyrk(c, c2, n, n2, f, string, 0, n3, f2, string2, 0, n4);
    }

    public static native void cublasSsyr2k(char var0, char var1, int var2, int var3, float var4, String var5, int var6, int var7, String var8, int var9, int var10, float var11, String var12, int var13, int var14);

    public static void cublasSsyr2k(char c, char c2, int n, int n2, float f, String string, int n3, String string2, int n4, float f2, String string3, int n5) {
        JCublas.cublasSsyr2k(c, c2, n, n2, f, string, 0, n3, string2, 0, n4, f2, string3, 0, n5);
    }

    public static native void cublasStrmm(char var0, char var1, char var2, char var3, int var4, int var5, float var6, String var7, int var8, int var9, String var10, int var11, int var12);

    public static void cublasStrmm(char c, char c2, char c3, char c4, int n, int n2, float f, String string, int n3, String string2, int n4) {
        JCublas.cublasStrmm(c, c2, c3, c4, n, n2, f, string, 0, n3, string2, 0, n4);
    }

    public static native void cublasStrsm(char var0, char var1, char var2, char var3, int var4, int var5, float var6, String var7, int var8, int var9, String var10, int var11, int var12);

    public static void cublasStrsm(char c, char c2, char c3, char c4, int n, int n2, float f, String string, int n3, String string2, int n4) {
        JCublas.cublasStrsm(c, c2, c3, c4, n, n2, f, string, 0, n3, string2, 0, n4);
    }

    public static native void cublasCgemm(char var0, char var1, int var2, int var3, int var4, JCuComplex var5, String var6, int var7, int var8, String var9, int var10, int var11, JCuComplex var12, String var13, int var14, int var15);

    public static void cublasCgemm(char c, char c2, int n, int n2, int n3, JCuComplex jCuComplex, String string, int n4, String string2, int n5, JCuComplex jCuComplex2, String string3, int n6) {
        JCublas.cublasCgemm(c, c2, n, n2, n3, jCuComplex, string, 0, n4, string2, 0, n5, jCuComplex2, string3, 0, n6);
    }

    public static native void cublasDaxpy(int var0, double var1, String var3, int var4, int var5, String var6, int var7, int var8);

    public static void cublasDaxpy(int n, double d, String string, int n2, String string2, int n3) {
        JCublas.cublasDaxpy(n, d, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasDcopy(int var0, String var1, int var2, int var3, String var4, int var5, int var6);

    public static void cublasDcopy(int n, String string, int n2, String string2, int n3) {
        JCublas.cublasDcopy(n, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasDrot(int var0, String var1, int var2, int var3, String var4, int var5, int var6, double var7, double var9);

    public static void cublasDrot(int n, String string, int n2, String string2, int n3, double d, double d2) {
        JCublas.cublasDrot(n, string, 0, n2, string2, 0, n3, d, d2);
    }

    public static native void cublasDrotg(String var0, int var1, String var2, int var3, String var4, int var5, String var6, int var7);

    public static void cublasDrotg(String string, String string2, String string3, String string4) {
        JCublas.cublasDrotg(string, 0, string2, 0, string3, 0, string4, 0);
    }

    public static native void cublasDscal(int var0, double var1, String var3, int var4, int var5);

    public static void cublasDscal(int n, double d, String string, int n2) {
        JCublas.cublasDscal(n, d, string, 0, n2);
    }

    public static native void cublasDswap(int var0, String var1, int var2, int var3, String var4, int var5, int var6);

    public static void cublasDswap(int n, String string, int n2, String string2, int n3) {
        JCublas.cublasDswap(n, string, 0, n2, string2, 0, n3);
    }

    public static native int cublasIdamax(int var0, String var1, int var2, int var3);

    public static int cublasIdamax(int n, String string, int n2) {
        return JCublas.cublasIdamax(n, string, 0, n2);
    }

    public static native int cublasIdamin(int var0, String var1, int var2, int var3);

    public static int cublasIdamin(int n, String string, int n2) {
        return JCublas.cublasIdamin(n, string, 0, n2);
    }

    public static native void cublasDgemv(char var0, int var1, int var2, double var3, String var5, int var6, int var7, String var8, int var9, int var10, double var11, String var13, int var14, int var15);

    public static void cublasDgemv(char c, int n, int n2, double d, String string, int n3, String string2, int n4, double d2, String string3, int n5) {
        JCublas.cublasDgemv(c, n, n2, d, string, 0, n3, string2, 0, n4, d2, string3, 0, n5);
    }

    public static native void cublasDger(int var0, int var1, double var2, String var4, int var5, int var6, String var7, int var8, int var9, String var10, int var11, int var12);

    public static void cublasDger(int n, int n2, double d, String string, int n3, String string2, int n4, String string3, int n5) {
        JCublas.cublasDger(n, n2, d, string, 0, n3, string2, 0, n4, string3, 0, n5);
    }

    public static native void cublasDsyr(char var0, int var1, double var2, String var4, int var5, int var6, String var7, int var8, int var9);

    public static void cublasDsyr(char c, int n, double d, String string, int n2, String string2, int n3) {
        JCublas.cublasDsyr(c, n, d, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasDtrsv(char var0, char var1, char var2, int var3, String var4, int var5, int var6, String var7, int var8, int var9);

    public static void cublasDtrsv(char c, char c2, char c3, int n, String string, int n2, String string2, int n3) {
        JCublas.cublasDtrsv(c, c2, c3, n, string, 0, n2, string2, 0, n3);
    }

    public static native void cublasDgemm(char var0, char var1, int var2, int var3, int var4, double var5, String var7, int var8, int var9, String var10, int var11, int var12, double var13, String var15, int var16, int var17);

    public static void cublasDgemm(char c, char c2, int n, int n2, int n3, double d, String string, int n4, String string2, int n5, double d2, String string3, int n6) {
        JCublas.cublasDgemm(c, c2, n, n2, n3, d, string, 0, n4, string2, 0, n5, d2, string3, 0, n6);
    }

    public static native void cublasDtrsm(char var0, char var1, char var2, char var3, int var4, int var5, double var6, String var8, int var9, int var10, String var11, int var12, int var13);

    public static void cublasDtrsm(char c, char c2, char c3, char c4, int n, int n2, double d, String string, int n3, String string2, int n4) {
        JCublas.cublasDtrsm(c, c2, c3, c4, n, n2, d, string, 0, n3, string2, 0, n4);
    }

    public static native void cublasDtrmm(char var0, char var1, char var2, char var3, int var4, int var5, double var6, String var8, int var9, int var10, String var11, int var12, int var13);

    public static void cublasDtrmm(char c, char c2, char c3, char c4, int n, int n2, double d, String string, int n3, String string2, int n4) {
        JCublas.cublasDtrmm(c, c2, c3, c4, n, n2, d, string, 0, n3, string2, 0, n4);
    }

    public static native void cublasDsymm(char var0, char var1, int var2, int var3, double var4, String var6, int var7, int var8, String var9, int var10, int var11, double var12, String var14, int var15, int var16);

    public static void cublasDsymm(char c, char c2, int n, int n2, double d, String string, int n3, String string2, int n4, double d2, String string3, int n5) {
        JCublas.cublasDsymm(c, c2, n, n2, d, string, 0, n3, string2, 0, n4, d2, string3, 0, n5);
    }

    public static native void cublasDsyrk(char var0, char var1, int var2, int var3, double var4, String var6, int var7, int var8, double var9, String var11, int var12, int var13);

    public static void cublasDsyrk(char c, char c2, int n, int n2, double d, String string, int n3, double d2, String string2, int n4) {
        JCublas.cublasDsyrk(c, c2, n, n2, d, string, 0, n3, d2, string2, 0, n4);
    }

    public static native void cublasDsyr2k(char var0, char var1, int var2, int var3, double var4, String var6, int var7, int var8, String var9, int var10, int var11, double var12, String var14, int var15, int var16);

    public static void cublasDsyr2k(char c, char c2, int n, int n2, double d, String string, int n3, String string2, int n4, double d2, String string3, int n5) {
        JCublas.cublasDsyr2k(c, c2, n, n2, d, string, 0, n3, string2, 0, n4, d2, string3, 0, n5);
    }

    public static native void cublasZgemm(char var0, char var1, int var2, int var3, int var4, JCuDoubleComplex var5, String var6, int var7, int var8, String var9, int var10, int var11, JCuDoubleComplex var12, String var13, int var14, int var15);

    public static void cublasZgemm(char c, char c2, int n, int n2, int n3, JCuDoubleComplex jCuDoubleComplex, String string, int n4, String string2, int n5, JCuDoubleComplex jCuDoubleComplex2, String string3, int n6) {
        JCublas.cublasZgemm(c, c2, n, n2, n3, jCuDoubleComplex, string, 0, n4, string2, 0, n5, jCuDoubleComplex2, string3, 0, n6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogLevel {
        LOG_QUIET,
        LOG_ERROR,
        LOG_WARNING,
        LOG_INFO,
        LOG_DEBUG,
        LOG_TRACE,
        LOG_DEBUGTRACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSType {
        APPLE,
        LINUX,
        SUN,
        UNKNOWN,
        WINDOWS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ARCHType {
        PPC,
        PPC_64,
        SPARC,
        UNKNOWN,
        X86,
        X86_64;

    }
}

