if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}


var CLOSURE_NO_DEPS = true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0]);
  }
  for (var part;parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else {
      if (cur[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else {
      if (goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
        value = goog.global.CLOSURE_DEFINES[name];
      }
    }
  }
  goog.exportPath_(name, value);
};
goog.define("goog.DEBUG", true);
goog.define("goog.LOCALE", "en");
goog.define("goog.TRUSTED_SITE", true);
goog.define("goog.STRICT_MODE_COMPATIBLE", false);
goog.define("goog.DISALLOW_TEST_ONLY_CODE", COMPILED && !goog.DEBUG);
goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING", false);
goog.provide = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
  }
  goog.constructNamespace_(name);
};
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name, opt_obj);
};
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module = function(name) {
  if (!goog.isString(name) || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
    throw Error("Invalid module identifier");
  }
  if (!goog.isInModuleLoader_()) {
    throw Error("Module " + name + " has been loaded incorrectly.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      return name in goog.loadedModules_ ? goog.loadedModules_[name] : goog.getObjectByName(name);
    } else {
      return null;
    }
  }
};
goog.moduleLoaderState_ = null;
goog.isInModuleLoader_ = function() {
  return goog.moduleLoaderState_ != null;
};
goog.module.declareTestMethods = function() {
  if (!goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareTestMethods must be called from " + "within a goog.module");
  }
  goog.moduleLoaderState_.declareTestMethods = true;
};
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareLegacyNamespace must be called from " + "within a goog.module");
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module must be called prior to " + "goog.module.declareLegacyNamespace.");
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {"goog.module":true};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var part;part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires, opt_isModule) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for (var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      deps.pathIsModule[path] = !!opt_isModule;
    }
    for (var j = 0;require = requires[j];j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define("goog.ENABLE_DEBUG_LOADER", true);
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console["error"](msg);
  }
};
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
      goog.maybeProcessDeferredDep_(name);
    }
    if (goog.isProvided_(name)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(name);
      } else {
        return null;
      }
    }
    if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return null;
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    goog.logToConsole_(errorMessage);
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.define("goog.LOAD_MODULE_USING_EVAL", true);
goog.define("goog.SEAL_MODULE_EXPORTS", goog.DEBUG);
goog.loadedModules_ = {};
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
if (goog.DEPENDENCIES_ENABLED) {
  goog.included_ = {};
  goog.dependencies_ = {pathIsModule:{}, nameToPath:{}, requires:{}, visited:{}, written:{}, deferred:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc;
  };
  goog.findBasePath_ = function() {
    if (goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("SCRIPT");
    for (var i = scripts.length - 1;i >= 0;--i) {
      var script = (scripts[i]);
      var src = script.src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src, opt_sourceText) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (importScript(src, opt_sourceText)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.IS_OLD_IE_ = !goog.global.atob && goog.global.document && goog.global.document.all;
  goog.importModule_ = function(src) {
    var bootstrap = 'goog.retrieveAndExecModule_("' + src + '");';
    if (goog.importScript_("", bootstrap)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.queuedModules_ = [];
  goog.wrapModule_ = function(srcUrl, scriptText) {
    if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
      return "" + "goog.loadModule(function(exports) {" + '"use strict";' + scriptText + "\n" + ";return exports" + "});" + "\n//# sourceURL\x3d" + srcUrl + "\n";
    } else {
      return "" + "goog.loadModule(" + goog.global.JSON.stringify(scriptText + "\n//# sourceURL\x3d" + srcUrl + "\n") + ");";
    }
  };
  goog.loadQueuedModules_ = function() {
    var count = goog.queuedModules_.length;
    if (count > 0) {
      var queue = goog.queuedModules_;
      goog.queuedModules_ = [];
      for (var i = 0;i < count;i++) {
        var path = queue[i];
        goog.maybeProcessDeferredPath_(path);
      }
    }
  };
  goog.maybeProcessDeferredDep_ = function(name) {
    if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
      var path = goog.getPathFromDeps_(name);
      goog.maybeProcessDeferredPath_(goog.basePath + path);
    }
  };
  goog.isDeferredModule_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && goog.dependencies_.pathIsModule[path]) {
      var abspath = goog.basePath + path;
      return abspath in goog.dependencies_.deferred;
    }
    return false;
  };
  goog.allDepsAreAvailable_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && path in goog.dependencies_.requires) {
      for (var requireName in goog.dependencies_.requires[path]) {
        if (!goog.isProvided_(requireName) && !goog.isDeferredModule_(requireName)) {
          return false;
        }
      }
    }
    return true;
  };
  goog.maybeProcessDeferredPath_ = function(abspath) {
    if (abspath in goog.dependencies_.deferred) {
      var src = goog.dependencies_.deferred[abspath];
      delete goog.dependencies_.deferred[abspath];
      goog.globalEval(src);
    }
  };
  goog.loadModule = function(moduleDef) {
    var previousState = goog.moduleLoaderState_;
    try {
      goog.moduleLoaderState_ = {moduleName:undefined, declareTestMethods:false};
      var exports;
      if (goog.isFunction(moduleDef)) {
        exports = moduleDef.call(goog.global, {});
      } else {
        if (goog.isString(moduleDef)) {
          exports = goog.loadModuleFromSource_.call(goog.global, moduleDef);
        } else {
          throw Error("Invalid module definition");
        }
      }
      var moduleName = goog.moduleLoaderState_.moduleName;
      if (!goog.isString(moduleName) || !moduleName) {
        throw Error('Invalid module name "' + moduleName + '"');
      }
      if (goog.moduleLoaderState_.declareLegacyNamespace) {
        goog.constructNamespace_(moduleName, exports);
      } else {
        if (goog.SEAL_MODULE_EXPORTS && Object.seal) {
          Object.seal(exports);
        }
      }
      goog.loadedModules_[moduleName] = exports;
      if (goog.moduleLoaderState_.declareTestMethods) {
        for (var entry in exports) {
          if (entry.indexOf("test", 0) === 0 || entry == "tearDown" || entry == "setUp" || entry == "setUpPage" || entry == "tearDownPage") {
            goog.global[entry] = exports[entry];
          }
        }
      }
    } finally {
      goog.moduleLoaderState_ = previousState;
    }
  };
  goog.loadModuleFromSource_ = function(source) {
    var exports = {};
    eval(arguments[0]);
    return exports;
  };
  goog.writeScriptSrcNode_ = function(src) {
    goog.global.document.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"\x3e\x3c/' + "script\x3e");
  };
  goog.appendScriptSrcNode_ = function(src) {
    var doc = goog.global.document;
    var scriptEl = doc.createElement("script");
    scriptEl.type = "text/javascript";
    scriptEl.src = src;
    scriptEl.defer = false;
    scriptEl.async = false;
    doc.head.appendChild(scriptEl);
  };
  goog.writeScriptTag_ = function(src, opt_sourceText) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && doc.readyState == "complete") {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      var isOldIE = goog.IS_OLD_IE_;
      if (opt_sourceText === undefined) {
        if (!isOldIE) {
          if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
            goog.appendScriptSrcNode_(src);
          } else {
            goog.writeScriptSrcNode_(src);
          }
        } else {
          var state = " onreadystatechange\x3d'goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ";
          doc.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"' + state + "\x3e\x3c/" + "script\x3e");
        }
      } else {
        doc.write('\x3cscript type\x3d"text/javascript"\x3e' + opt_sourceText + "\x3c/" + "script\x3e");
      }
      return true;
    } else {
      return false;
    }
  };
  goog.lastNonModuleScriptIndex_ = 0;
  goog.onScriptLoad_ = function(script, scriptIndex) {
    if (script.readyState == "complete" && goog.lastNonModuleScriptIndex_ == scriptIndex) {
      goog.loadQueuedModules_();
    }
    return true;
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        if (!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path);
        }
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    for (var path in goog.included_) {
      if (!deps.written[path]) {
        visitNode(path);
      }
    }
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      goog.dependencies_.written[path] = true;
    }
    var moduleState = goog.moduleLoaderState_;
    goog.moduleLoaderState_ = null;
    var loadingModule = false;
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      if (path) {
        if (!deps.pathIsModule[path]) {
          goog.importScript_(goog.basePath + path);
        } else {
          loadingModule = true;
          goog.importModule_(goog.basePath + path);
        }
      } else {
        goog.moduleLoaderState_ = moduleState;
        throw Error("Undefined script input");
      }
    }
    goog.moduleLoaderState_ = moduleState;
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js");
  }
}
goog.normalizePath_ = function(path) {
  var components = path.split("/");
  var i = 0;
  while (i < components.length) {
    if (components[i] == ".") {
      components.splice(i, 1);
    } else {
      if (i && components[i] == ".." && components[i - 1] && components[i - 1] != "..") {
        components.splice(--i, 2);
      } else {
        i++;
      }
    }
  }
  return components.join("/");
};
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    var xhr = new goog.global["XMLHttpRequest"];
    xhr.open("get", src, false);
    xhr.send();
    return xhr.responseText;
  }
};
goog.retrieveAndExecModule_ = function(src) {
  if (!COMPILED) {
    var originalPath = src;
    src = goog.normalizePath_(src);
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    var scriptText = goog.loadFileSync_(src);
    if (scriptText != null) {
      var execModuleScript = goog.wrapModule_(src, scriptText);
      var isOldIE = goog.IS_OLD_IE_;
      if (isOldIE) {
        goog.dependencies_.deferred[originalPath] = execModuleScript;
        goog.queuedModules_.push(originalPath);
      } else {
        importScript(src, execModuleScript);
      }
    } else {
      throw new Error("load of " + src + "failed");
    }
  }
};
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call((value));
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
goog.isString = function(val) {
  return typeof val == "string";
};
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
goog.isNumber = function(val) {
  return typeof val == "number";
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if ("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1E9 >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return (fn.call.apply(fn.bind, arguments));
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ \x3d 1;");
        if (typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("SCRIPT");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt);
      }
    } else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  if (opt_modifier) {
    return className + "-" + rename(opt_modifier);
  } else {
    return rename(className);
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = new Array(arguments.length - 2);
    for (var i = 2;i < arguments.length;i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (caller.superClass_) {
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1;i < arguments.length;i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    return caller.superClass_.constructor.apply(me, ctorArgs);
  }
  var args = new Array(arguments.length - 2);
  for (var i = 2;i < arguments.length;i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (goog.defineClass.SEAL_CLASS_INSTANCES && Object.seal instanceof Function) {
    if (superClass && superClass.prototype && superClass.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]) {
      return ctr;
    }
    var wrappedCtr = function() {
      var instance = ctr.apply(this, arguments) || this;
      instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
      if (this.constructor === wrappedCtr) {
        Object.seal(instance);
      }
      return instance;
    };
    return wrappedCtr;
  }
  return ctr;
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0;i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.define("goog.string.DETECT_DOUBLE_ESCAPING", false);
goog.define("goog.string.FORCE_NON_DOM_HTML_UNESCAPING", false);
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split("%s");
  var returnString = "";
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length && splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.isEmptyString = function(str) {
  return str.length == 0;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == " ";
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd";
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(str) {
  return str.trim();
} : function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return -1;
  } else {
    if (test1 == test2) {
      return 0;
    } else {
      return 1;
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "\x3cbr /\x3e" : "\x3cbr\x3e");
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, "\x26amp;").replace(goog.string.LT_RE_, "\x26lt;").replace(goog.string.GT_RE_, "\x26gt;").replace(goog.string.QUOT_RE_, "\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;").replace(goog.string.NULL_RE_, "\x26#0;");
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) {
      return str;
    }
    if (str.indexOf("\x26") != -1) {
      str = str.replace(goog.string.AMP_RE_, "\x26amp;");
    }
    if (str.indexOf("\x3c") != -1) {
      str = str.replace(goog.string.LT_RE_, "\x26lt;");
    }
    if (str.indexOf("\x3e") != -1) {
      str = str.replace(goog.string.GT_RE_, "\x26gt;");
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, "\x26quot;");
    }
    if (str.indexOf("'") != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;");
    }
    if (str.indexOf("\x00") != -1) {
      str = str.replace(goog.string.NULL_RE_, "\x26#0;");
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf("e") != -1) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, "\x26")) {
    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, "\x26")) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"\x26amp;":"\x26", "\x26lt;":"\x3c", "\x26gt;":"\x3e", "\x26quot;":'"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement("div");
  } else {
    div = goog.global.document.createElement("div");
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "\x26";
      case "lt":
        return "\x3c";
      case "gt":
        return "\x3e";
      case "quot":
        return '"';
      default:
        if (entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " \x26#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + "...";
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos);
    }
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if (s.quote) {
    return s.quote();
  } else {
    var sb = ['"'];
    for (var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch));
    }
    sb.push('"');
    return sb.join("");
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = "\\x";
      if (cc < 16 || cc > 256) {
        rv += "0";
      }
    } else {
      rv = "\\u";
      if (cc < 4096) {
        rv += "0";
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = function(string, length) {
  return (new Array(length + 1)).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return -1;
  } else {
    if (left > right) {
      return 1;
    }
  }
  return 0;
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmptyOrWhitespace(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  delimiters = delimiters ? "|[" + delimiters + "]+" : "";
  var regexp = new RegExp("(^" + delimiters + ")([a-z])", "g");
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return /^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.string.editDistance = function(a, b) {
  var v0 = [];
  var v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0;i < b.length + 1;i++) {
    v0[i] = i;
  }
  for (var i = 0;i < a.length;i++) {
    v1[0] = i + 1;
    for (var j = 0;j < b.length;j++) {
      var cost = a[i] != b[j];
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
    }
    for (var j = 0;j < v0.length;j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call(opt_obj, obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call(opt_obj, obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call(opt_this, obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if (rv = key in obj) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value;
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  obj[key] = val;
  return val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (var k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for (var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};
goog.provide("goog.string.StringBuffer");
goog.string.StringBuffer = function(opt_a1, var_args) {
  if (opt_a1 != null) {
    this.append.apply(this, arguments);
  }
};
goog.string.StringBuffer.prototype.buffer_ = "";
goog.string.StringBuffer.prototype.set = function(s) {
  this.buffer_ = "" + s;
};
goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
  this.buffer_ += a1;
  if (opt_a2 != null) {
    for (var i = 1;i < arguments.length;i++) {
      this.buffer_ += arguments[i];
    }
  }
  return this;
};
goog.string.StringBuffer.prototype.clear = function() {
  this.buffer_ = "";
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.buffer_.length;
};
goog.string.StringBuffer.prototype.toString = function() {
  return this.buffer_;
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = (new Error).stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
  this.reportErrorToServer = true;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.dom.NodeType");
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.dom.NodeType");
goog.require("goog.string");
goog.define("goog.asserts.ENABLE_ASSERTS", goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    if (defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs;
    }
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.asserts.getType_ = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || "unknown type name";
  } else {
    if (value instanceof Object) {
      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
    } else {
      return value === null ? "null" : typeof value;
    }
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.define("goog.NATIVE_ARRAY_PROTOTYPES", goog.TRUSTED_SITE);
goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS", false);
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i < arr.length;i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if (fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex);
  }
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i >= 0;i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;--i) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      var val = arr2[i];
      if (f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val;
      }
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr);
    }
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduce.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduceRight.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true;
    }
  }
  return false;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false;
    }
  }
  return true;
};
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call(opt_obj, element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;i--) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1;i >= 0;i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if (rv = i >= 0) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    if (f.call(opt_obj, val, index, arr)) {
      if (goog.array.removeAt(arr, index)) {
        removedCount++;
      }
    }
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.join = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0;i < length;i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0;
      var len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0;j < len2;j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start);
  } else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while (left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = compareFn(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for (var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  }
  goog.array.sort(arr, stableCompareFn);
  for (var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr, function(obj) {
    return obj[key];
  }, opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0;i < l;i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter.call(opt_obj, value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call(opt_obj, element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return [];
  }
  if (step > 0) {
    for (var i = start;i < end;i += step) {
      array.push(i);
    }
  } else {
    for (var i = start;i > end;i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0;i < n;i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var CHUNK_SIZE = 8192;
  var result = [];
  for (var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      for (var c = 0;c < element.length;c += CHUNK_SIZE) {
        var chunk = goog.array.slice(element, c, c + CHUNK_SIZE);
        var recurseResult = goog.array.flatten.apply(null, chunk);
        for (var r = 0;r < recurseResult.length;r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n));
    } else {
      if (n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n));
      }
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = goog.array.ARRAY_PROTOTYPE_.splice.call(arr, fromIndex, 1);
  goog.array.ARRAY_PROTOTYPE_.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  var result = [];
  for (var i = 0;true;i++) {
    var value = [];
    for (var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if (i >= arr.length) {
        return result;
      }
      value.push(arr[i]);
    }
    result.push(value);
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.object");
goog.require("goog.array");
goog.require("goog.string.StringBuffer");
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3308";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_target_STAR_ = "default";
if (typeof cljs.core._STAR_print_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_fn_STAR_ = function cljs$core$_STAR_print_fn_STAR_(_) {
    throw new Error("No *print-fn* fn set for evaluation environment");
  };
}
cljs.core.set_print_fn_BANG_ = function cljs$core$set_print_fn_BANG_(f) {
  return cljs.core._STAR_print_fn_STAR_ = f;
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if (typeof cljs.core._STAR_loaded_libs_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = function cljs$core$pr_opts() {
  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, "flush-on-newline", "flush-on-newline", -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, "readably", "readably", 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, "meta", "meta", 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, "dup", "dup", 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, "print-length", "print-length", 
  1931866356), cljs.core._STAR_print_length_STAR_], null);
};
cljs.core.enable_console_print_BANG_ = function cljs$core$enable_console_print_BANG_() {
  cljs.core._STAR_print_newline_STAR_ = false;
  return cljs.core._STAR_print_fn_STAR_ = function() {
    var G__13596__delegate = function(args) {
      return console.log.apply(console, function() {
        var G__13595 = args;
        return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__13595) : cljs.core.into_array.call(null, G__13595);
      }());
    };
    var G__13596 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__13597__i = 0, G__13597__a = new Array(arguments.length - 0);
        while (G__13597__i < G__13597__a.length) {
          G__13597__a[G__13597__i] = arguments[G__13597__i + 0];
          ++G__13597__i;
        }
        args = new cljs.core.IndexedSeq(G__13597__a, 0);
      }
      return G__13596__delegate.call(this, args);
    };
    G__13596.cljs$lang$maxFixedArity = 0;
    G__13596.cljs$lang$applyTo = function(arglist__13598) {
      var args = cljs.core.seq(arglist__13598);
      return G__13596__delegate(args);
    };
    G__13596.cljs$core$IFn$_invoke$arity$variadic = G__13596__delegate;
    return G__13596;
  }();
};
cljs.core.truth_ = function cljs$core$truth_(x) {
  return x != null && x !== false;
};
cljs.core.not_native = null;
cljs.core.identical_QMARK_ = function cljs$core$identical_QMARK_(x, y) {
  return x === y;
};
cljs.core.nil_QMARK_ = function cljs$core$nil_QMARK_(x) {
  return x == null;
};
cljs.core.array_QMARK_ = function cljs$core$array_QMARK_(x) {
  if (cljs.core._STAR_target_STAR_ === "nodejs") {
    return Array.isArray(x);
  } else {
    return x instanceof Array;
  }
};
cljs.core.number_QMARK_ = function cljs$core$number_QMARK_(n) {
  return typeof n === "number";
};
cljs.core.not = function cljs$core$not(x) {
  if (cljs.core.truth_(x)) {
    return false;
  } else {
    return true;
  }
};
cljs.core.some_QMARK_ = function cljs$core$some_QMARK_(x) {
  return !(x == null);
};
cljs.core.object_QMARK_ = function cljs$core$object_QMARK_(x) {
  if (!(x == null)) {
    return x.constructor === Object;
  } else {
    return false;
  }
};
cljs.core.string_QMARK_ = function cljs$core$string_QMARK_(x) {
  var G__13600 = x;
  return goog.isString(G__13600);
};
cljs.core.native_satisfies_QMARK_ = function cljs$core$native_satisfies_QMARK_(p, x) {
  var x__$1 = x == null ? null : x;
  if (p[function() {
    var G__13602 = x__$1;
    return goog.typeOf(G__13602);
  }()]) {
    return true;
  } else {
    if (p["_"]) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.is_proto_ = function cljs$core$is_proto_(x) {
  return x.constructor.prototype === x;
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = function cljs$core$type(x) {
  if (x == null) {
    return null;
  } else {
    return x.constructor;
  }
};
cljs.core.missing_protocol = function cljs$core$missing_protocol(proto, obj) {
  var ty = cljs.core.type(obj);
  var ty__$1 = cljs.core.truth_(function() {
    var and__4297__auto__ = ty;
    if (cljs.core.truth_(and__4297__auto__)) {
      return ty.cljs$lang$type;
    } else {
      return and__4297__auto__;
    }
  }()) ? ty.cljs$lang$ctorStr : function() {
    var G__13604 = obj;
    return goog.typeOf(G__13604);
  }();
  return new Error(["No protocol method ", proto, " defined for type ", ty__$1, ": ", obj].join(""));
};
cljs.core.type__GT_str = function cljs$core$type__GT_str(ty) {
  var temp__4423__auto__ = ty.cljs$lang$ctorStr;
  if (cljs.core.truth_(temp__4423__auto__)) {
    var s = temp__4423__auto__;
    return s;
  } else {
    return [cljs.core.str(ty)].join("");
  }
};
cljs.core.load_file = function cljs$core$load_file(file) {
  if (cljs.core.truth_(COMPILED)) {
    return null;
  } else {
    return goog.nodeGlobalRequire(file);
  }
};
if (typeof Symbol !== "undefined" && function() {
  var G__13606 = Symbol;
  return goog.typeOf(G__13606);
}() === "function") {
  cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
  cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.make_array = function cljs$core$make_array() {
  var G__13608 = arguments.length;
  switch(G__13608) {
    case 1:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = function(size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = function(type, size) {
  return new Array(size);
};
cljs.core.make_array.cljs$lang$maxFixedArity = 2;
cljs.core.aclone = function cljs$core$aclone(arr) {
  var len = arr.length;
  var new_arr = new Array(len);
  var n__5194__auto___13610 = len;
  var i_13611 = 0;
  while (true) {
    if (i_13611 < n__5194__auto___13610) {
      new_arr[i_13611] = arr[i_13611];
      var G__13612 = i_13611 + 1;
      i_13611 = G__13612;
      continue;
    } else {
    }
    break;
  }
  return new_arr;
};
cljs.core.array = function cljs$core$array(var_args) {
  var a = new Array(arguments.length);
  var i = 0;
  while (true) {
    if (i < a.length) {
      a[i] = arguments[i];
      var G__13613 = i + 1;
      i = G__13613;
      continue;
    } else {
      return a;
    }
    break;
  }
};
cljs.core.aget = function cljs$core$aget() {
  var G__13618 = arguments.length;
  switch(G__13618) {
    case 2:
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return array[i];
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = function(array, i, idxs) {
  var G__13619 = cljs.core.aget;
  var G__13620 = array[i];
  var G__13621 = idxs;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__13619, G__13620, G__13621) : cljs.core.apply.call(null, G__13619, G__13620, G__13621);
};
cljs.core.aget.cljs$lang$applyTo = function(seq13614) {
  var G__13615 = cljs.core.first(seq13614);
  var seq13614__$1 = cljs.core.next(seq13614);
  var G__13616 = cljs.core.first(seq13614__$1);
  var seq13614__$2 = cljs.core.next(seq13614__$1);
  return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__13615, G__13616, seq13614__$2);
};
cljs.core.aget.cljs$lang$maxFixedArity = 2;
cljs.core.aset = function cljs$core$aset() {
  var G__13628 = arguments.length;
  switch(G__13628) {
    case 3:
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = function(array, i, val) {
  return array[i] = val;
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  var G__13629 = cljs.core.aset;
  var G__13630 = array[idx];
  var G__13631 = idx2;
  var G__13632 = idxv;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__13629, G__13630, G__13631, G__13632) : cljs.core.apply.call(null, G__13629, G__13630, G__13631, G__13632);
};
cljs.core.aset.cljs$lang$applyTo = function(seq13623) {
  var G__13624 = cljs.core.first(seq13623);
  var seq13623__$1 = cljs.core.next(seq13623);
  var G__13625 = cljs.core.first(seq13623__$1);
  var seq13623__$2 = cljs.core.next(seq13623__$1);
  var G__13626 = cljs.core.first(seq13623__$2);
  var seq13623__$3 = cljs.core.next(seq13623__$2);
  return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__13624, G__13625, G__13626, seq13623__$3);
};
cljs.core.aset.cljs$lang$maxFixedArity = 3;
cljs.core.alength = function cljs$core$alength(array) {
  return array.length;
};
cljs.core.into_array = function cljs$core$into_array() {
  var G__13635 = arguments.length;
  switch(G__13635) {
    case 1:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = function(aseq) {
  return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null, aseq);
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = function(type, aseq) {
  var G__13636 = function(a, x) {
    a.push(x);
    return a;
  };
  var G__13637 = [];
  var G__13638 = aseq;
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__13636, G__13637, G__13638) : cljs.core.reduce.call(null, G__13636, G__13637, G__13638);
};
cljs.core.into_array.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke = function cljs$core$js_invoke() {
  var argseq__5349__auto__ = 2 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0) : null;
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5349__auto__);
};
cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = function(obj, s, args) {
  return obj[s].apply(obj, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
cljs.core.js_invoke.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke.cljs$lang$applyTo = function(seq13640) {
  var G__13641 = cljs.core.first(seq13640);
  var seq13640__$1 = cljs.core.next(seq13640);
  var G__13642 = cljs.core.first(seq13640__$1);
  var seq13640__$2 = cljs.core.next(seq13640__$1);
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__13641, G__13642, seq13640__$2);
};
cljs.core.Fn = function() {
  var obj13644 = {};
  return obj13644;
}();
cljs.core.IFn = function() {
  var obj13646 = {};
  return obj13646;
}();
cljs.core._invoke = function cljs$core$_invoke() {
  var G__13648 = arguments.length;
  switch(G__13648) {
    case 1:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    case 8:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
      break;
    case 9:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
      break;
    case 10:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
      break;
    case 11:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
      break;
    case 12:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
      break;
    case 13:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
      break;
    case 14:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
      break;
    case 15:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
      break;
    case 16:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15]);
      break;
    case 17:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16]);
      break;
    case 18:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17]);
      break;
    case 19:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18]);
      break;
    case 20:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19]);
      break;
    case 21:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20]);
      break;
    case 22:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20], arguments[21]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = function(this$) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$1(this$);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13650 = x__4945__auto__;
        return goog.typeOf(G__13650);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = function(this$, a) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$2(this$, a);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13652 = x__4945__auto__;
        return goog.typeOf(G__13652);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = function(this$, a, b) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13654 = x__4945__auto__;
        return goog.typeOf(G__13654);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = function(this$, a, b, c) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$4;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13656 = x__4945__auto__;
        return goog.typeOf(G__13656);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = function(this$, a, b, c, d) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$5;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13658 = x__4945__auto__;
        return goog.typeOf(G__13658);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = function(this$, a, b, c, d, e) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$6;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13660 = x__4945__auto__;
        return goog.typeOf(G__13660);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = function(this$, a, b, c, d, e, f) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$7;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13662 = x__4945__auto__;
        return goog.typeOf(G__13662);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = function(this$, a, b, c, d, e, f, g) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$8;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13664 = x__4945__auto__;
        return goog.typeOf(G__13664);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = function(this$, a, b, c, d, e, f, g, h) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$9;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13666 = x__4945__auto__;
        return goog.typeOf(G__13666);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = function(this$, a, b, c, d, e, f, g, h, i) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$10;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13668 = x__4945__auto__;
        return goog.typeOf(G__13668);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$11;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13670 = x__4945__auto__;
        return goog.typeOf(G__13670);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$12;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13672 = x__4945__auto__;
        return goog.typeOf(G__13672);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$13;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13674 = x__4945__auto__;
        return goog.typeOf(G__13674);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$14;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13676 = x__4945__auto__;
        return goog.typeOf(G__13676);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$15;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13678 = x__4945__auto__;
        return goog.typeOf(G__13678);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$16;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13680 = x__4945__auto__;
        return goog.typeOf(G__13680);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$17;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13682 = x__4945__auto__;
        return goog.typeOf(G__13682);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$18;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13684 = x__4945__auto__;
        return goog.typeOf(G__13684);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$19;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13686 = x__4945__auto__;
        return goog.typeOf(G__13686);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$20;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13688 = x__4945__auto__;
        return goog.typeOf(G__13688);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$21;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13690 = x__4945__auto__;
        return goog.typeOf(G__13690);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$22;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__13692 = x__4945__auto__;
        return goog.typeOf(G__13692);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  }
};
cljs.core._invoke.cljs$lang$maxFixedArity = 22;
cljs.core.ICloneable = function() {
  var obj13695 = {};
  return obj13695;
}();
cljs.core._clone = function cljs$core$_clone(value) {
  if (function() {
    var and__4297__auto__ = value;
    if (and__4297__auto__) {
      return value.cljs$core$ICloneable$_clone$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return value.cljs$core$ICloneable$_clone$arity$1(value);
  } else {
    var x__4945__auto__ = value == null ? null : value;
    return function() {
      var or__4309__auto__ = cljs.core._clone[function() {
        var G__13699 = x__4945__auto__;
        return goog.typeOf(G__13699);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._clone["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICloneable.-clone", value);
        }
      }
    }().call(null, value);
  }
};
cljs.core.ICounted = function() {
  var obj13701 = {};
  return obj13701;
}();
cljs.core._count = function cljs$core$_count(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ICounted$_count$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._count[function() {
        var G__13705 = x__4945__auto__;
        return goog.typeOf(G__13705);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._count["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICounted.-count", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IEmptyableCollection = function() {
  var obj13707 = {};
  return obj13707;
}();
cljs.core._empty = function cljs$core$_empty(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._empty[function() {
        var G__13711 = x__4945__auto__;
        return goog.typeOf(G__13711);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._empty["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ICollection = function() {
  var obj13713 = {};
  return obj13713;
}();
cljs.core._conj = function cljs$core$_conj(coll, o) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ICollection$_conj$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._conj[function() {
        var G__13717 = x__4945__auto__;
        return goog.typeOf(G__13717);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._conj["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o);
  }
};
cljs.core.IIndexed = function() {
  var obj13719 = {};
  return obj13719;
}();
cljs.core._nth = function cljs$core$_nth() {
  var G__13721 = arguments.length;
  switch(G__13721) {
    case 2:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IIndexed$_nth$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._nth[function() {
        var G__13723 = x__4945__auto__;
        return goog.typeOf(G__13723);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._nth["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIndexed.-nth", coll);
        }
      }
    }().call(null, coll, n);
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IIndexed$_nth$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._nth[function() {
        var G__13725 = x__4945__auto__;
        return goog.typeOf(G__13725);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._nth["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIndexed.-nth", coll);
        }
      }
    }().call(null, coll, n, not_found);
  }
};
cljs.core._nth.cljs$lang$maxFixedArity = 3;
cljs.core.ASeq = function() {
  var obj13728 = {};
  return obj13728;
}();
cljs.core.ISeq = function() {
  var obj13730 = {};
  return obj13730;
}();
cljs.core._first = function cljs$core$_first(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISeq$_first$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._first[function() {
        var G__13734 = x__4945__auto__;
        return goog.typeOf(G__13734);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._first["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeq.-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._rest = function cljs$core$_rest(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISeq$_rest$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._rest[function() {
        var G__13738 = x__4945__auto__;
        return goog.typeOf(G__13738);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._rest["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeq.-rest", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.INext = function() {
  var obj13740 = {};
  return obj13740;
}();
cljs.core._next = function cljs$core$_next(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$INext$_next$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$INext$_next$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._next[function() {
        var G__13744 = x__4945__auto__;
        return goog.typeOf(G__13744);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._next["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INext.-next", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ILookup = function() {
  var obj13746 = {};
  return obj13746;
}();
cljs.core._lookup = function cljs$core$_lookup() {
  var G__13748 = arguments.length;
  switch(G__13748) {
    case 2:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ILookup$_lookup$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ILookup$_lookup$arity$2(o, k);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._lookup[function() {
        var G__13750 = x__4945__auto__;
        return goog.typeOf(G__13750);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._lookup["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ILookup.-lookup", o);
        }
      }
    }().call(null, o, k);
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ILookup$_lookup$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._lookup[function() {
        var G__13752 = x__4945__auto__;
        return goog.typeOf(G__13752);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._lookup["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ILookup.-lookup", o);
        }
      }
    }().call(null, o, k, not_found);
  }
};
cljs.core._lookup.cljs$lang$maxFixedArity = 3;
cljs.core.IAssociative = function() {
  var obj13755 = {};
  return obj13755;
}();
cljs.core._contains_key_QMARK_ = function cljs$core$_contains_key_QMARK_(coll, k) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._contains_key_QMARK_[function() {
        var G__13759 = x__4945__auto__;
        return goog.typeOf(G__13759);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._contains_key_QMARK_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k);
  }
};
cljs.core._assoc = function cljs$core$_assoc(coll, k, v) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IAssociative$_assoc$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc[function() {
        var G__13763 = x__4945__auto__;
        return goog.typeOf(G__13763);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v);
  }
};
cljs.core.IMap = function() {
  var obj13765 = {};
  return obj13765;
}();
cljs.core._dissoc = function cljs$core$_dissoc(coll, k) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IMap$_dissoc$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._dissoc[function() {
        var G__13769 = x__4945__auto__;
        return goog.typeOf(G__13769);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._dissoc["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k);
  }
};
cljs.core.IMapEntry = function() {
  var obj13771 = {};
  return obj13771;
}();
cljs.core._key = function cljs$core$_key(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IMapEntry$_key$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._key[function() {
        var G__13775 = x__4945__auto__;
        return goog.typeOf(G__13775);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._key["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMapEntry.-key", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._val = function cljs$core$_val(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IMapEntry$_val$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._val[function() {
        var G__13779 = x__4945__auto__;
        return goog.typeOf(G__13779);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._val["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMapEntry.-val", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ISet = function() {
  var obj13781 = {};
  return obj13781;
}();
cljs.core._disjoin = function cljs$core$_disjoin(coll, v) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISet$_disjoin$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._disjoin[function() {
        var G__13785 = x__4945__auto__;
        return goog.typeOf(G__13785);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._disjoin["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v);
  }
};
cljs.core.IStack = function() {
  var obj13787 = {};
  return obj13787;
}();
cljs.core._peek = function cljs$core$_peek(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IStack$_peek$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._peek[function() {
        var G__13791 = x__4945__auto__;
        return goog.typeOf(G__13791);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._peek["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IStack.-peek", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._pop = function cljs$core$_pop(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IStack$_pop$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._pop[function() {
        var G__13795 = x__4945__auto__;
        return goog.typeOf(G__13795);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._pop["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IStack.-pop", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IVector = function() {
  var obj13797 = {};
  return obj13797;
}();
cljs.core._assoc_n = function cljs$core$_assoc_n(coll, n, val) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IVector$_assoc_n$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc_n[function() {
        var G__13801 = x__4945__auto__;
        return goog.typeOf(G__13801);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc_n["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val);
  }
};
cljs.core.IDeref = function() {
  var obj13803 = {};
  return obj13803;
}();
cljs.core._deref = function cljs$core$_deref(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IDeref$_deref$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._deref[function() {
        var G__13807 = x__4945__auto__;
        return goog.typeOf(G__13807);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._deref["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IDeref.-deref", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.IDerefWithTimeout = function() {
  var obj13809 = {};
  return obj13809;
}();
cljs.core._deref_with_timeout = function cljs$core$_deref_with_timeout(o, msec, timeout_val) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._deref_with_timeout[function() {
        var G__13813 = x__4945__auto__;
        return goog.typeOf(G__13813);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._deref_with_timeout["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val);
  }
};
cljs.core.IMeta = function() {
  var obj13815 = {};
  return obj13815;
}();
cljs.core._meta = function cljs$core$_meta(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IMeta$_meta$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._meta[function() {
        var G__13819 = x__4945__auto__;
        return goog.typeOf(G__13819);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._meta["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMeta.-meta", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.IWithMeta = function() {
  var obj13821 = {};
  return obj13821;
}();
cljs.core._with_meta = function cljs$core$_with_meta(o, meta) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._with_meta[function() {
        var G__13825 = x__4945__auto__;
        return goog.typeOf(G__13825);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._with_meta["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta);
  }
};
cljs.core.IReduce = function() {
  var obj13827 = {};
  return obj13827;
}();
cljs.core._reduce = function cljs$core$_reduce() {
  var G__13829 = arguments.length;
  switch(G__13829) {
    case 2:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IReduce$_reduce$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._reduce[function() {
        var G__13831 = x__4945__auto__;
        return goog.typeOf(G__13831);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._reduce["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReduce.-reduce", coll);
        }
      }
    }().call(null, coll, f);
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, start) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IReduce$_reduce$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._reduce[function() {
        var G__13833 = x__4945__auto__;
        return goog.typeOf(G__13833);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._reduce["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReduce.-reduce", coll);
        }
      }
    }().call(null, coll, f, start);
  }
};
cljs.core._reduce.cljs$lang$maxFixedArity = 3;
cljs.core.IKVReduce = function() {
  var obj13836 = {};
  return obj13836;
}();
cljs.core._kv_reduce = function cljs$core$_kv_reduce(coll, f, init) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._kv_reduce[function() {
        var G__13840 = x__4945__auto__;
        return goog.typeOf(G__13840);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._kv_reduce["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init);
  }
};
cljs.core.IEquiv = function() {
  var obj13842 = {};
  return obj13842;
}();
cljs.core._equiv = function cljs$core$_equiv(o, other) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IEquiv$_equiv$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._equiv[function() {
        var G__13846 = x__4945__auto__;
        return goog.typeOf(G__13846);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._equiv["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other);
  }
};
cljs.core.IHash = function() {
  var obj13848 = {};
  return obj13848;
}();
cljs.core._hash = function cljs$core$_hash(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IHash$_hash$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._hash[function() {
        var G__13852 = x__4945__auto__;
        return goog.typeOf(G__13852);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._hash["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IHash.-hash", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.ISeqable = function() {
  var obj13854 = {};
  return obj13854;
}();
cljs.core._seq = function cljs$core$_seq(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISeqable$_seq$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._seq[function() {
        var G__13858 = x__4945__auto__;
        return goog.typeOf(G__13858);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._seq["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeqable.-seq", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.ISequential = function() {
  var obj13860 = {};
  return obj13860;
}();
cljs.core.IList = function() {
  var obj13862 = {};
  return obj13862;
}();
cljs.core.IRecord = function() {
  var obj13864 = {};
  return obj13864;
}();
cljs.core.IReversible = function() {
  var obj13866 = {};
  return obj13866;
}();
cljs.core._rseq = function cljs$core$_rseq(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IReversible$_rseq$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._rseq[function() {
        var G__13870 = x__4945__auto__;
        return goog.typeOf(G__13870);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._rseq["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReversible.-rseq", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ISorted = function() {
  var obj13872 = {};
  return obj13872;
}();
cljs.core._sorted_seq = function cljs$core$_sorted_seq(coll, ascending_QMARK_) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._sorted_seq[function() {
        var G__13876 = x__4945__auto__;
        return goog.typeOf(G__13876);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._sorted_seq["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_);
  }
};
cljs.core._sorted_seq_from = function cljs$core$_sorted_seq_from(coll, k, ascending_QMARK_) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._sorted_seq_from[function() {
        var G__13880 = x__4945__auto__;
        return goog.typeOf(G__13880);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._sorted_seq_from["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_);
  }
};
cljs.core._entry_key = function cljs$core$_entry_key(coll, entry) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_entry_key$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._entry_key[function() {
        var G__13884 = x__4945__auto__;
        return goog.typeOf(G__13884);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._entry_key["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry);
  }
};
cljs.core._comparator = function cljs$core$_comparator(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_comparator$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._comparator[function() {
        var G__13888 = x__4945__auto__;
        return goog.typeOf(G__13888);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._comparator["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-comparator", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IWriter = function() {
  var obj13890 = {};
  return obj13890;
}();
cljs.core._write = function cljs$core$_write(writer, s) {
  if (function() {
    var and__4297__auto__ = writer;
    if (and__4297__auto__) {
      return writer.cljs$core$IWriter$_write$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return writer.cljs$core$IWriter$_write$arity$2(writer, s);
  } else {
    var x__4945__auto__ = writer == null ? null : writer;
    return function() {
      var or__4309__auto__ = cljs.core._write[function() {
        var G__13894 = x__4945__auto__;
        return goog.typeOf(G__13894);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._write["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWriter.-write", writer);
        }
      }
    }().call(null, writer, s);
  }
};
cljs.core._flush = function cljs$core$_flush(writer) {
  if (function() {
    var and__4297__auto__ = writer;
    if (and__4297__auto__) {
      return writer.cljs$core$IWriter$_flush$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return writer.cljs$core$IWriter$_flush$arity$1(writer);
  } else {
    var x__4945__auto__ = writer == null ? null : writer;
    return function() {
      var or__4309__auto__ = cljs.core._flush[function() {
        var G__13898 = x__4945__auto__;
        return goog.typeOf(G__13898);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._flush["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWriter.-flush", writer);
        }
      }
    }().call(null, writer);
  }
};
cljs.core.IPrintWithWriter = function() {
  var obj13900 = {};
  return obj13900;
}();
cljs.core._pr_writer = function cljs$core$_pr_writer(o, writer, opts) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._pr_writer[function() {
        var G__13904 = x__4945__auto__;
        return goog.typeOf(G__13904);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._pr_writer["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer", o);
        }
      }
    }().call(null, o, writer, opts);
  }
};
cljs.core.IPending = function() {
  var obj13906 = {};
  return obj13906;
}();
cljs.core._realized_QMARK_ = function cljs$core$_realized_QMARK_(d) {
  if (function() {
    var and__4297__auto__ = d;
    if (and__4297__auto__) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
  } else {
    var x__4945__auto__ = d == null ? null : d;
    return function() {
      var or__4309__auto__ = cljs.core._realized_QMARK_[function() {
        var G__13910 = x__4945__auto__;
        return goog.typeOf(G__13910);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._realized_QMARK_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IPending.-realized?", d);
        }
      }
    }().call(null, d);
  }
};
cljs.core.IWatchable = function() {
  var obj13912 = {};
  return obj13912;
}();
cljs.core._notify_watches = function cljs$core$_notify_watches(this$, oldval, newval) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._notify_watches[function() {
        var G__13916 = x__4945__auto__;
        return goog.typeOf(G__13916);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._notify_watches["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval);
  }
};
cljs.core._add_watch = function cljs$core$_add_watch(this$, key, f) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._add_watch[function() {
        var G__13920 = x__4945__auto__;
        return goog.typeOf(G__13920);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._add_watch["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f);
  }
};
cljs.core._remove_watch = function cljs$core$_remove_watch(this$, key) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._remove_watch[function() {
        var G__13924 = x__4945__auto__;
        return goog.typeOf(G__13924);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._remove_watch["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key);
  }
};
cljs.core.IEditableCollection = function() {
  var obj13926 = {};
  return obj13926;
}();
cljs.core._as_transient = function cljs$core$_as_transient(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._as_transient[function() {
        var G__13930 = x__4945__auto__;
        return goog.typeOf(G__13930);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._as_transient["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ITransientCollection = function() {
  var obj13932 = {};
  return obj13932;
}();
cljs.core._conj_BANG_ = function cljs$core$_conj_BANG_(tcoll, val) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._conj_BANG_[function() {
        var G__13936 = x__4945__auto__;
        return goog.typeOf(G__13936);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._conj_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val);
  }
};
cljs.core._persistent_BANG_ = function cljs$core$_persistent_BANG_(tcoll) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._persistent_BANG_[function() {
        var G__13940 = x__4945__auto__;
        return goog.typeOf(G__13940);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._persistent_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll);
  }
};
cljs.core.ITransientAssociative = function() {
  var obj13942 = {};
  return obj13942;
}();
cljs.core._assoc_BANG_ = function cljs$core$_assoc_BANG_(tcoll, key, val) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc_BANG_[function() {
        var G__13946 = x__4945__auto__;
        return goog.typeOf(G__13946);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val);
  }
};
cljs.core.ITransientMap = function() {
  var obj13948 = {};
  return obj13948;
}();
cljs.core._dissoc_BANG_ = function cljs$core$_dissoc_BANG_(tcoll, key) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._dissoc_BANG_[function() {
        var G__13952 = x__4945__auto__;
        return goog.typeOf(G__13952);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._dissoc_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key);
  }
};
cljs.core.ITransientVector = function() {
  var obj13954 = {};
  return obj13954;
}();
cljs.core._assoc_n_BANG_ = function cljs$core$_assoc_n_BANG_(tcoll, n, val) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc_n_BANG_[function() {
        var G__13958 = x__4945__auto__;
        return goog.typeOf(G__13958);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc_n_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val);
  }
};
cljs.core._pop_BANG_ = function cljs$core$_pop_BANG_(tcoll) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._pop_BANG_[function() {
        var G__13962 = x__4945__auto__;
        return goog.typeOf(G__13962);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._pop_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll);
  }
};
cljs.core.ITransientSet = function() {
  var obj13964 = {};
  return obj13964;
}();
cljs.core._disjoin_BANG_ = function cljs$core$_disjoin_BANG_(tcoll, v) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._disjoin_BANG_[function() {
        var G__13968 = x__4945__auto__;
        return goog.typeOf(G__13968);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._disjoin_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v);
  }
};
cljs.core.IComparable = function() {
  var obj13970 = {};
  return obj13970;
}();
cljs.core._compare = function cljs$core$_compare(x, y) {
  if (function() {
    var and__4297__auto__ = x;
    if (and__4297__auto__) {
      return x.cljs$core$IComparable$_compare$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y);
  } else {
    var x__4945__auto__ = x == null ? null : x;
    return function() {
      var or__4309__auto__ = cljs.core._compare[function() {
        var G__13974 = x__4945__auto__;
        return goog.typeOf(G__13974);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._compare["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IComparable.-compare", x);
        }
      }
    }().call(null, x, y);
  }
};
cljs.core.IChunk = function() {
  var obj13976 = {};
  return obj13976;
}();
cljs.core._drop_first = function cljs$core$_drop_first(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunk$_drop_first$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._drop_first[function() {
        var G__13980 = x__4945__auto__;
        return goog.typeOf(G__13980);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._drop_first["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunk.-drop-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IChunkedSeq = function() {
  var obj13982 = {};
  return obj13982;
}();
cljs.core._chunked_first = function cljs$core$_chunked_first(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._chunked_first[function() {
        var G__13986 = x__4945__auto__;
        return goog.typeOf(G__13986);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._chunked_first["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._chunked_rest = function cljs$core$_chunked_rest(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._chunked_rest[function() {
        var G__13990 = x__4945__auto__;
        return goog.typeOf(G__13990);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._chunked_rest["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IChunkedNext = function() {
  var obj13992 = {};
  return obj13992;
}();
cljs.core._chunked_next = function cljs$core$_chunked_next(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._chunked_next[function() {
        var G__13996 = x__4945__auto__;
        return goog.typeOf(G__13996);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._chunked_next["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedNext.-chunked-next", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.INamed = function() {
  var obj13998 = {};
  return obj13998;
}();
cljs.core._name = function cljs$core$_name(x) {
  if (function() {
    var and__4297__auto__ = x;
    if (and__4297__auto__) {
      return x.cljs$core$INamed$_name$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return x.cljs$core$INamed$_name$arity$1(x);
  } else {
    var x__4945__auto__ = x == null ? null : x;
    return function() {
      var or__4309__auto__ = cljs.core._name[function() {
        var G__14002 = x__4945__auto__;
        return goog.typeOf(G__14002);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._name["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INamed.-name", x);
        }
      }
    }().call(null, x);
  }
};
cljs.core._namespace = function cljs$core$_namespace(x) {
  if (function() {
    var and__4297__auto__ = x;
    if (and__4297__auto__) {
      return x.cljs$core$INamed$_namespace$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return x.cljs$core$INamed$_namespace$arity$1(x);
  } else {
    var x__4945__auto__ = x == null ? null : x;
    return function() {
      var or__4309__auto__ = cljs.core._namespace[function() {
        var G__14006 = x__4945__auto__;
        return goog.typeOf(G__14006);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._namespace["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INamed.-namespace", x);
        }
      }
    }().call(null, x);
  }
};
cljs.core.IAtom = function() {
  var obj14008 = {};
  return obj14008;
}();
cljs.core.IReset = function() {
  var obj14010 = {};
  return obj14010;
}();
cljs.core._reset_BANG_ = function cljs$core$_reset_BANG_(o, new_value) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IReset$_reset_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._reset_BANG_[function() {
        var G__14014 = x__4945__auto__;
        return goog.typeOf(G__14014);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._reset_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReset.-reset!", o);
        }
      }
    }().call(null, o, new_value);
  }
};
cljs.core.ISwap = function() {
  var obj14016 = {};
  return obj14016;
}();
cljs.core._swap_BANG_ = function cljs$core$_swap_BANG_() {
  var G__14018 = arguments.length;
  switch(G__14018) {
    case 2:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(o, f) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__14020 = x__4945__auto__;
        return goog.typeOf(G__14020);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(o, f, a) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__14022 = x__4945__auto__;
        return goog.typeOf(G__14022);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(o, f, a, b) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$4;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__14024 = x__4945__auto__;
        return goog.typeOf(G__14024);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a, b);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = function(o, f, a, b, xs) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$5;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__14026 = x__4945__auto__;
        return goog.typeOf(G__14026);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a, b, xs);
  }
};
cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;
cljs.core.IVolatile = function() {
  var obj14029 = {};
  return obj14029;
}();
cljs.core._vreset_BANG_ = function cljs$core$_vreset_BANG_(o, new_value) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o, new_value);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._vreset_BANG_[function() {
        var G__14033 = x__4945__auto__;
        return goog.typeOf(G__14033);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._vreset_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IVolatile.-vreset!", o);
        }
      }
    }().call(null, o, new_value);
  }
};
cljs.core.IIterable = function() {
  var obj14035 = {};
  return obj14035;
}();
cljs.core._iterator = function cljs$core$_iterator(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IIterable$_iterator$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IIterable$_iterator$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._iterator[function() {
        var G__14039 = x__4945__auto__;
        return goog.typeOf(G__14039);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._iterator["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIterable.-iterator", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.StringBufferWriter = function(sb) {
  this.sb = sb;
  this.cljs$lang$protocol_mask$partition0$ = 1073741824;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {
  var self__ = this;
  var ___$1 = this;
  return self__.sb.append(s);
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return null;
};
cljs.core.StringBufferWriter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "sb", "sb", -1249746442, null)], null);
};
cljs.core.StringBufferWriter.cljs$lang$type = true;
cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";
cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/StringBufferWriter");
};
cljs.core.__GT_StringBufferWriter = function cljs$core$__GT_StringBufferWriter(sb) {
  return new cljs.core.StringBufferWriter(sb);
};
cljs.core.pr_str_STAR_ = function cljs$core$pr_str_STAR_(obj) {
  var sb = new goog.string.StringBuffer;
  var writer = new cljs.core.StringBufferWriter(sb);
  obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer, cljs.core.pr_opts());
  writer.cljs$core$IWriter$_flush$arity$1(null);
  return [cljs.core.str(sb)].join("");
};
cljs.core.int_rotate_left = function cljs$core$int_rotate_left(x, n) {
  return x << n | x >>> -n;
};
if (typeof Math.imul !== "undefined" && !(function() {
  var G__14042 = 4294967295;
  var G__14043 = 5;
  return Math.imul(G__14042, G__14043);
}() === 0)) {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var G__14046 = a;
    var G__14047 = b;
    return Math.imul(G__14046, G__14047);
  };
} else {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var ah = a >>> 16 & 65535;
    var al = a & 65535;
    var bh = b >>> 16 & 65535;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
  };
}
cljs.core.m3_seed = 0;
cljs.core.m3_C1 = 3432918353 | 0;
cljs.core.m3_C2 = 461845907 | 0;
cljs.core.m3_mix_K1 = function cljs$core$m3_mix_K1(k1) {
  return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1 | 0, cljs.core.m3_C1), 15), cljs.core.m3_C2);
};
cljs.core.m3_mix_H1 = function cljs$core$m3_mix_H1(h1, k1) {
  return cljs.core.imul(cljs.core.int_rotate_left((h1 | 0) ^ (k1 | 0), 13), 5) + (3864292196 | 0) | 0;
};
cljs.core.m3_fmix = function cljs$core$m3_fmix(h1, len) {
  var h1__$1 = h1 | 0;
  var h1__$2 = h1__$1 ^ len;
  var h1__$3 = h1__$2 ^ h1__$2 >>> 16;
  var h1__$4 = cljs.core.imul(h1__$3, 2246822507 | 0);
  var h1__$5 = h1__$4 ^ h1__$4 >>> 13;
  var h1__$6 = cljs.core.imul(h1__$5, 3266489909 | 0);
  var h1__$7 = h1__$6 ^ h1__$6 >>> 16;
  return h1__$7;
};
cljs.core.m3_hash_int = function cljs$core$m3_hash_int(in$) {
  if (in$ === 0) {
    return in$;
  } else {
    var k1 = cljs.core.m3_mix_K1(in$);
    var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed, k1);
    return cljs.core.m3_fmix(h1, 4);
  }
};
cljs.core.m3_hash_unencoded_chars = function cljs$core$m3_hash_unencoded_chars(in$) {
  var h1 = function() {
    var i = 1;
    var h1 = cljs.core.m3_seed;
    while (true) {
      if (i < in$.length) {
        var G__14048 = i + 2;
        var G__14049 = cljs.core.m3_mix_H1(h1, cljs.core.m3_mix_K1(in$.charCodeAt(i - 1) | in$.charCodeAt(i) << 16));
        i = G__14048;
        h1 = G__14049;
        continue;
      } else {
        return h1;
      }
      break;
    }
  }();
  var h1__$1 = (in$.length & 1) === 1 ? h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt(in$.length - 1)) : h1;
  return cljs.core.m3_fmix(h1__$1, cljs.core.imul(2, in$.length));
};
cljs.core.string_hash_cache = function() {
  var obj14051 = {};
  return obj14051;
}();
cljs.core.string_hash_cache_count = 0;
cljs.core.hash_string_STAR_ = function cljs$core$hash_string_STAR_(s) {
  if (!(s == null)) {
    var len = s.length;
    if (len > 0) {
      var i = 0;
      var hash = 0;
      while (true) {
        if (i < len) {
          var G__14052 = i + 1;
          var G__14053 = cljs.core.imul(31, hash) + s.charCodeAt(i);
          i = G__14052;
          hash = G__14053;
          continue;
        } else {
          return hash;
        }
        break;
      }
    } else {
      return 0;
    }
  } else {
    return 0;
  }
};
cljs.core.add_to_string_hash_cache = function cljs$core$add_to_string_hash_cache(k) {
  var h = cljs.core.hash_string_STAR_(k);
  cljs.core.string_hash_cache[k] = h;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h;
};
cljs.core.hash_string = function cljs$core$hash_string(k) {
  if (cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = function() {
      var obj14057 = {};
      return obj14057;
    }();
    cljs.core.string_hash_cache_count = 0;
  } else {
  }
  var h = cljs.core.string_hash_cache[k];
  if (typeof h === "number") {
    return h;
  } else {
    return cljs.core.add_to_string_hash_cache(k);
  }
};
cljs.core.hash = function cljs$core$hash(o) {
  if (function() {
    var G__14060 = o;
    if (G__14060) {
      var bit__4976__auto__ = G__14060.cljs$lang$protocol_mask$partition0$ & 4194304;
      if (bit__4976__auto__ || G__14060.cljs$core$IHash$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(null);
  } else {
    if (typeof o === "number") {
      return function() {
        var G__14061 = o;
        return Math.floor(G__14061);
      }() % 2147483647;
    } else {
      if (o === true) {
        return 1;
      } else {
        if (o === false) {
          return 0;
        } else {
          if (typeof o === "string") {
            return cljs.core.m3_hash_int(cljs.core.hash_string(o));
          } else {
            if (o instanceof Date) {
              return o.valueOf();
            } else {
              if (o == null) {
                return 0;
              } else {
                return cljs.core._hash(o);
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.hash_combine = function cljs$core$hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2);
};
cljs.core.instance_QMARK_ = function cljs$core$instance_QMARK_(t, o) {
  return o instanceof t;
};
cljs.core.symbol_QMARK_ = function cljs$core$symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol;
};
cljs.core.hash_symbol = function cljs$core$hash_symbol(sym) {
  return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name), cljs.core.hash_string(sym.ns));
};
cljs.core.compare_symbols = function cljs$core$compare_symbols(a, b) {
  if (a.str === b.str) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = cljs.core.not(a.ns);
      if (and__4297__auto__) {
        return b.ns;
      } else {
        return and__4297__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__14068 = a.ns;
            var G__14069 = b.ns;
            return goog.array.defaultCompare(G__14068, G__14069);
          }();
          if (0 === nsc) {
            var G__14070 = a.name;
            var G__14071 = b.name;
            return goog.array.defaultCompare(G__14070, G__14071);
          } else {
            return nsc;
          }
        }
      } else {
        var G__14072 = a.name;
        var G__14073 = b.name;
        return goog.array.defaultCompare(G__14072, G__14073);
      }
    }
  }
};
cljs.core.Symbol = function(ns, name, str, _hash, _meta) {
  this.ns = ns;
  this.name = name;
  this.str = str;
  this._hash = _hash;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2154168321;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Symbol.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return self__.str;
};
cljs.core.Symbol.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Symbol) {
    return self__.str === other.str;
  } else {
    return false;
  }
};
cljs.core.Symbol.prototype.call = function() {
  var G__14075 = null;
  var G__14075__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, null);
  };
  var G__14075__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
  };
  G__14075 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__14075__2.call(this, self__, coll);
      case 3:
        return G__14075__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__14075.cljs$core$IFn$_invoke$arity$2 = G__14075__2;
  G__14075.cljs$core$IFn$_invoke$arity$3 = G__14075__3;
  return G__14075;
}();
cljs.core.Symbol.prototype.apply = function(self__, args14074) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args14074)));
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var sym = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, null);
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var sym = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
};
cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);
};
cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {
  var self__ = this;
  var sym__$1 = this;
  var h__4725__auto__ = self__._hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_symbol(sym__$1);
    self__._hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, self__.str);
};
cljs.core.Symbol.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "str", "str", -1564826950, null), new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Symbol.cljs$lang$type = true;
cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";
cljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Symbol");
};
cljs.core.__GT_Symbol = function cljs$core$__GT_Symbol(ns, name, str, _hash, _meta) {
  return new cljs.core.Symbol(ns, name, str, _hash, _meta);
};
cljs.core.symbol = function cljs$core$symbol() {
  var G__14077 = arguments.length;
  switch(G__14077) {
    case 1:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Symbol) {
    return name;
  } else {
    return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null, name);
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var sym_str = !(ns == null) ? [cljs.core.str(ns), cljs.core.str("/"), cljs.core.str(name)].join("") : name;
  return new cljs.core.Symbol(ns, name, sym_str, null, null);
};
cljs.core.symbol.cljs$lang$maxFixedArity = 2;
cljs.core.Var = function(val, sym, _meta) {
  this.val = val;
  this.sym = sym;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 163841;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
};
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Var.prototype.cljs$core$Fn$ = true;
cljs.core.Var.prototype.call = function() {
  var G__14124 = null;
  var G__14124__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null);
  };
  var G__14124__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a);
  };
  var G__14124__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b);
  };
  var G__14124__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c);
  };
  var G__14124__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d);
  };
  var G__14124__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e);
  };
  var G__14124__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f);
  };
  var G__14124__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g);
  };
  var G__14124__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h);
  };
  var G__14124__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__14124__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__14124__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__14124__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__14124__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__14124__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__14124__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__14124__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__14124__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__14124__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__14124__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__14124__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__14124__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14080 = function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }();
    var G__14081 = a;
    var G__14082 = b;
    var G__14083 = c;
    var G__14084 = d;
    var G__14085 = e;
    var G__14086 = f;
    var G__14087 = g;
    var G__14088 = h;
    var G__14089 = i;
    var G__14090 = j;
    var G__14091 = k;
    var G__14092 = l;
    var G__14093 = m;
    var G__14094 = n;
    var G__14095 = o;
    var G__14096 = p;
    var G__14097 = q;
    var G__14098 = r;
    var G__14099 = s;
    var G__14100 = t;
    var G__14101 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__14080, G__14081, G__14082, G__14083, G__14084, G__14085, G__14086, G__14087, G__14088, G__14089, G__14090, G__14091, G__14092, G__14093, G__14094, G__14095, G__14096, G__14097, G__14098, G__14099, G__14100, G__14101) : cljs.core.apply.call(null, G__14080, G__14081, G__14082, G__14083, G__14084, G__14085, G__14086, G__14087, G__14088, G__14089, G__14090, G__14091, G__14092, G__14093, G__14094, 
    G__14095, G__14096, G__14097, G__14098, G__14099, G__14100, G__14101);
  };
  G__14124 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__14124__1.call(this, self__);
      case 2:
        return G__14124__2.call(this, self__, a);
      case 3:
        return G__14124__3.call(this, self__, a, b);
      case 4:
        return G__14124__4.call(this, self__, a, b, c);
      case 5:
        return G__14124__5.call(this, self__, a, b, c, d);
      case 6:
        return G__14124__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__14124__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__14124__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__14124__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__14124__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__14124__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__14124__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__14124__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__14124__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__14124__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__14124__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__14124__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__14124__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__14124__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__14124__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__14124__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__14124__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__14124.cljs$core$IFn$_invoke$arity$1 = G__14124__1;
  G__14124.cljs$core$IFn$_invoke$arity$2 = G__14124__2;
  G__14124.cljs$core$IFn$_invoke$arity$3 = G__14124__3;
  G__14124.cljs$core$IFn$_invoke$arity$4 = G__14124__4;
  G__14124.cljs$core$IFn$_invoke$arity$5 = G__14124__5;
  G__14124.cljs$core$IFn$_invoke$arity$6 = G__14124__6;
  G__14124.cljs$core$IFn$_invoke$arity$7 = G__14124__7;
  G__14124.cljs$core$IFn$_invoke$arity$8 = G__14124__8;
  G__14124.cljs$core$IFn$_invoke$arity$9 = G__14124__9;
  G__14124.cljs$core$IFn$_invoke$arity$10 = G__14124__10;
  G__14124.cljs$core$IFn$_invoke$arity$11 = G__14124__11;
  G__14124.cljs$core$IFn$_invoke$arity$12 = G__14124__12;
  G__14124.cljs$core$IFn$_invoke$arity$13 = G__14124__13;
  G__14124.cljs$core$IFn$_invoke$arity$14 = G__14124__14;
  G__14124.cljs$core$IFn$_invoke$arity$15 = G__14124__15;
  G__14124.cljs$core$IFn$_invoke$arity$16 = G__14124__16;
  G__14124.cljs$core$IFn$_invoke$arity$17 = G__14124__17;
  G__14124.cljs$core$IFn$_invoke$arity$18 = G__14124__18;
  G__14124.cljs$core$IFn$_invoke$arity$19 = G__14124__19;
  G__14124.cljs$core$IFn$_invoke$arity$20 = G__14124__20;
  G__14124.cljs$core$IFn$_invoke$arity$21 = G__14124__21;
  G__14124.cljs$core$IFn$_invoke$arity$22 = G__14124__22;
  return G__14124;
}();
cljs.core.Var.prototype.apply = function(self__, args14079) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args14079)));
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__14102 = function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }();
  var G__14103 = a;
  var G__14104 = b;
  var G__14105 = c;
  var G__14106 = d;
  var G__14107 = e;
  var G__14108 = f;
  var G__14109 = g;
  var G__14110 = h;
  var G__14111 = i;
  var G__14112 = j;
  var G__14113 = k;
  var G__14114 = l;
  var G__14115 = m;
  var G__14116 = n;
  var G__14117 = o;
  var G__14118 = p;
  var G__14119 = q;
  var G__14120 = r;
  var G__14121 = s;
  var G__14122 = t;
  var G__14123 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__14102, G__14103, G__14104, G__14105, G__14106, G__14107, G__14108, G__14109, G__14110, G__14111, G__14112, G__14113, G__14114, G__14115, G__14116, G__14117, G__14118, G__14119, G__14120, G__14121, G__14122, G__14123) : cljs.core.apply.call(null, G__14102, G__14103, G__14104, G__14105, G__14106, G__14107, G__14108, G__14109, G__14110, G__14111, G__14112, G__14113, G__14114, G__14115, G__14116, 
  G__14117, G__14118, G__14119, G__14120, G__14121, G__14122, G__14123);
};
cljs.core.Var.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "sym", "sym", 195671222, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Var.cljs$lang$type = true;
cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Var");
};
cljs.core.__GT_Var = function cljs$core$__GT_Var(val, sym, _meta) {
  return new cljs.core.Var(val, sym, _meta);
};
cljs.core.var_QMARK_ = function cljs$core$var_QMARK_(v) {
  return v instanceof cljs.core.Var;
};
cljs.core.iterable_QMARK_ = function cljs$core$iterable_QMARK_(x) {
  var G__14126 = x;
  if (G__14126) {
    var bit__4983__auto__ = null;
    if (cljs.core.truth_(function() {
      var or__4309__auto__ = bit__4983__auto__;
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        return G__14126.cljs$core$IIterable$;
      }
    }())) {
      return true;
    } else {
      if (!G__14126.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, G__14126);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, G__14126);
  }
};
cljs.core.clone = function cljs$core$clone(value) {
  return cljs.core._clone(value);
};
cljs.core.cloneable_QMARK_ = function cljs$core$cloneable_QMARK_(value) {
  var G__14128 = value;
  if (G__14128) {
    var bit__4983__auto__ = G__14128.cljs$lang$protocol_mask$partition1$ & 8192;
    if (bit__4983__auto__ || G__14128.cljs$core$ICloneable$) {
      return true;
    } else {
      if (!G__14128.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, G__14128);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, G__14128);
  }
};
cljs.core.seq = function cljs$core$seq(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__14130 = coll;
      if (G__14130) {
        var bit__4976__auto__ = G__14130.cljs$lang$protocol_mask$partition0$ & 8388608;
        if (bit__4976__auto__ || G__14130.cljs$core$ISeqable$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeqable$_seq$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        if (coll.length === 0) {
          return null;
        } else {
          return new cljs.core.IndexedSeq(coll, 0);
        }
      } else {
        if (typeof coll === "string") {
          if (coll.length === 0) {
            return null;
          } else {
            return new cljs.core.IndexedSeq(coll, 0);
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, coll)) {
            return cljs.core._seq(coll);
          } else {
            throw new Error([cljs.core.str(coll), cljs.core.str(" is not ISeqable")].join(""));
          }
        }
      }
    }
  }
};
cljs.core.first = function cljs$core$first(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__14132 = coll;
      if (G__14132) {
        var bit__4976__auto__ = G__14132.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4976__auto__ || G__14132.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeq$_first$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s == null) {
        return null;
      } else {
        return cljs.core._first(s);
      }
    }
  }
};
cljs.core.rest = function cljs$core$rest(coll) {
  if (!(coll == null)) {
    if (function() {
      var G__14134 = coll;
      if (G__14134) {
        var bit__4976__auto__ = G__14134.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4976__auto__ || G__14134.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeq$_rest$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s) {
        return cljs.core._rest(s);
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.next = function cljs$core$next(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__14136 = coll;
      if (G__14136) {
        var bit__4976__auto__ = G__14136.cljs$lang$protocol_mask$partition0$ & 128;
        if (bit__4976__auto__ || G__14136.cljs$core$INext$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$INext$_next$arity$1(null);
    } else {
      return cljs.core.seq(cljs.core.rest(coll));
    }
  }
};
cljs.core._EQ_ = function cljs$core$_EQ_() {
  var G__14141 = arguments.length;
  switch(G__14141) {
    case 1:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  if (x == null) {
    return y == null;
  } else {
    return x === y || cljs.core._equiv(x, y);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
      if (cljs.core.next(more)) {
        var G__14143 = y;
        var G__14144 = cljs.core.first(more);
        var G__14145 = cljs.core.next(more);
        x = G__14143;
        y = G__14144;
        more = G__14145;
        continue;
      } else {
        return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y, cljs.core.first(more));
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ_.cljs$lang$applyTo = function(seq14137) {
  var G__14138 = cljs.core.first(seq14137);
  var seq14137__$1 = cljs.core.next(seq14137);
  var G__14139 = cljs.core.first(seq14137__$1);
  var seq14137__$2 = cljs.core.next(seq14137__$1);
  return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__14138, G__14139, seq14137__$2);
};
cljs.core._EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.ES6Iterator = function(s) {
  this.s = s;
};
cljs.core.ES6Iterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":x, "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6Iterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null)], null);
};
cljs.core.ES6Iterator.cljs$lang$type = true;
cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6Iterator");
};
cljs.core.__GT_ES6Iterator = function cljs$core$__GT_ES6Iterator(s) {
  return new cljs.core.ES6Iterator(s);
};
cljs.core.es6_iterator = function cljs$core$es6_iterator(coll) {
  return new cljs.core.ES6Iterator(cljs.core.seq(coll));
};
cljs.core.ES6IteratorSeq = function(value, iter, _rest) {
  this.value = value;
  this.iter = iter;
  this._rest = _rest;
  this.cljs$lang$protocol_mask$partition0$ = 8388672;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.value;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__._rest == null) {
    self__._rest = function() {
      var G__14146 = self__.iter;
      return cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__14146) : cljs.core.es6_iterator_seq.call(null, G__14146);
    }();
  } else {
  }
  return self__._rest;
};
cljs.core.ES6IteratorSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "value", "value", 1946509744, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null), new cljs.core.Symbol(null, "_rest", "_rest", -2100466189, null)], null);
};
cljs.core.ES6IteratorSeq.cljs$lang$type = true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";
cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6IteratorSeq");
};
cljs.core.__GT_ES6IteratorSeq = function cljs$core$__GT_ES6IteratorSeq(value, iter, _rest) {
  return new cljs.core.ES6IteratorSeq(value, iter, _rest);
};
cljs.core.es6_iterator_seq = function cljs$core$es6_iterator_seq(iter) {
  var v = iter.next();
  if (cljs.core.truth_(v.done)) {
    return cljs.core.List.EMPTY;
  } else {
    return new cljs.core.ES6IteratorSeq(v.value, iter, null);
  }
};
cljs.core.mix_collection_hash = function cljs$core$mix_collection_hash(hash_basis, count) {
  var h1 = cljs.core.m3_seed;
  var k1 = cljs.core.m3_mix_K1(hash_basis);
  var h1__$1 = cljs.core.m3_mix_H1(h1, k1);
  return cljs.core.m3_fmix(h1__$1, count);
};
cljs.core.hash_ordered_coll = function cljs$core$hash_ordered_coll(coll) {
  var n = 0;
  var hash_code = 1;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__14147 = n + 1;
      var G__14148 = cljs.core.imul(31, hash_code) + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__14149 = cljs.core.next(coll__$1);
      n = G__14147;
      hash_code = G__14148;
      coll__$1 = G__14149;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash(1, 0);
cljs.core.hash_unordered_coll = function cljs$core$hash_unordered_coll(coll) {
  var n = 0;
  var hash_code = 0;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__14150 = n + 1;
      var G__14151 = hash_code + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__14152 = cljs.core.next(coll__$1);
      n = G__14150;
      hash_code = G__14151;
      coll__$1 = G__14152;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash(0, 0);
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0;
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var o__$1 = this;
  return other instanceof Date && o__$1.valueOf() === other.valueOf();
};
Date.prototype.cljs$core$IComparable$ = true;
Date.prototype.cljs$core$IComparable$_compare$arity$2 = function(this$, other) {
  var this$__$1 = this;
  if (other instanceof Date) {
    var G__14153 = this$__$1.valueOf();
    var G__14154 = other.valueOf();
    return goog.array.defaultCompare(G__14153, G__14154);
  } else {
    throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(this$__$1), cljs.core.str(" to "), cljs.core.str(other)].join(""));
  }
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o;
};
cljs.core.Fn["function"] = true;
cljs.core.IMeta["function"] = true;
cljs.core._meta["function"] = function(_) {
  return null;
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  var G__14155 = o;
  return goog.getUid(G__14155);
};
cljs.core.inc = function cljs$core$inc(x) {
  return x + 1;
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var self__ = this;
  var o__$1 = this;
  return self__.val;
};
cljs.core.Reduced.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";
cljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Reduced");
};
cljs.core.__GT_Reduced = function cljs$core$__GT_Reduced(val) {
  return new cljs.core.Reduced(val);
};
cljs.core.reduced = function cljs$core$reduced(x) {
  return new cljs.core.Reduced(x);
};
cljs.core.reduced_QMARK_ = function cljs$core$reduced_QMARK_(r) {
  return r instanceof cljs.core.Reduced;
};
cljs.core.ensure_reduced = function cljs$core$ensure_reduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return x;
  } else {
    return cljs.core.reduced(x);
  }
};
cljs.core.unreduced = function cljs$core$unreduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    var G__14157 = x;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__14157) : cljs.core.deref.call(null, G__14157);
  } else {
    return x;
  }
};
cljs.core.deref = function cljs$core$deref(o) {
  return cljs.core._deref(o);
};
cljs.core.ci_reduce = function cljs$core$ci_reduce() {
  var G__14159 = arguments.length;
  switch(G__14159) {
    case 2:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = function(cicoll, f) {
  var cnt = cljs.core._count(cicoll);
  if (cnt === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, 0);
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__14160 = val;
          var G__14161 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14160, G__14161) : f.call(null, G__14160, G__14161);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__14167 = nval;
          var G__14168 = n + 1;
          val = G__14167;
          n = G__14168;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = function(cicoll, f, val) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__14162 = val__$1;
        var G__14163 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14162, G__14163) : f.call(null, G__14162, G__14163);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__14169 = nval;
        var G__14170 = n + 1;
        val__$1 = G__14169;
        n = G__14170;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = function(cicoll, f, val, idx) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__14164 = val__$1;
        var G__14165 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14164, G__14165) : f.call(null, G__14164, G__14165);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__14171 = nval;
        var G__14172 = n + 1;
        val__$1 = G__14171;
        n = G__14172;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = function cljs$core$array_reduce() {
  var G__14174 = arguments.length;
  switch(G__14174) {
    case 2:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = function(arr, f) {
  var cnt = arr.length;
  if (arr.length === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = arr[0];
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__14175 = val;
          var G__14176 = arr[n];
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14175, G__14176) : f.call(null, G__14175, G__14176);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__14182 = nval;
          var G__14183 = n + 1;
          val = G__14182;
          n = G__14183;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = function(arr, f, val) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__14177 = val__$1;
        var G__14178 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14177, G__14178) : f.call(null, G__14177, G__14178);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__14184 = nval;
        var G__14185 = n + 1;
        val__$1 = G__14184;
        n = G__14185;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = function(arr, f, val, idx) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__14179 = val__$1;
        var G__14180 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14179, G__14180) : f.call(null, G__14179, G__14180);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__14186 = nval;
        var G__14187 = n + 1;
        val__$1 = G__14186;
        n = G__14187;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.counted_QMARK_ = function cljs$core$counted_QMARK_(x) {
  var G__14189 = x;
  if (G__14189) {
    var bit__4983__auto__ = G__14189.cljs$lang$protocol_mask$partition0$ & 2;
    if (bit__4983__auto__ || G__14189.cljs$core$ICounted$) {
      return true;
    } else {
      if (!G__14189.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, G__14189);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, G__14189);
  }
};
cljs.core.indexed_QMARK_ = function cljs$core$indexed_QMARK_(x) {
  var G__14191 = x;
  if (G__14191) {
    var bit__4983__auto__ = G__14191.cljs$lang$protocol_mask$partition0$ & 16;
    if (bit__4983__auto__ || G__14191.cljs$core$IIndexed$) {
      return true;
    } else {
      if (!G__14191.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, G__14191);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, G__14191);
  }
};
cljs.core.IndexedSeqIterator = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.IndexedSeqIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.IndexedSeqIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.IndexedSeqIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.IndexedSeqIterator.cljs$lang$type = true;
cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/IndexedSeqIterator");
};
cljs.core.__GT_IndexedSeqIterator = function cljs$core$__GT_IndexedSeqIterator(arr, i) {
  return new cljs.core.IndexedSeqIterator(arr, i);
};
cljs.core.IndexedSeq = function(arr, i) {
  this.arr = arr;
  this.i = i;
  this.cljs$lang$protocol_mask$partition0$ = 166199550;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.IndexedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return not_found;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeqIterator(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  var x__4621__auto__ = 0;
  var y__4622__auto__ = self__.arr.length - self__.i;
  return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var c = cljs.core._count(coll__$1);
  if (c > 0) {
    return new cljs.core.RSeq(coll__$1, c - 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  var G__14192 = coll__$1;
  var G__14193 = other;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__14192, G__14193) : cljs.core.equiv_sequential.call(null, G__14192, G__14193);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.i], self__.i + 1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr[self__.i];
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.i < self__.arr.length) {
    return this$__$1;
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__14194 = o;
  var G__14195 = coll__$1;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__14194, G__14195) : cljs.core.cons.call(null, G__14194, G__14195);
};
cljs.core.IndexedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";
cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/IndexedSeq");
};
cljs.core.__GT_IndexedSeq = function cljs$core$__GT_IndexedSeq(arr, i) {
  return new cljs.core.IndexedSeq(arr, i);
};
cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.prim_seq = function cljs$core$prim_seq() {
  var G__14197 = arguments.length;
  switch(G__14197) {
    case 1:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = function(prim) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim, 0);
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = function(prim, i) {
  if (i < prim.length) {
    return new cljs.core.IndexedSeq(prim, i);
  } else {
    return null;
  }
};
cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
cljs.core.array_seq = function cljs$core$array_seq() {
  var G__14200 = arguments.length;
  switch(G__14200) {
    case 1:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = function(array) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, 0);
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, i);
};
cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.RSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.RSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return null;
  }
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.i + 1;
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  var G__14202 = coll__$1;
  var G__14203 = other;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__14202, G__14203) : cljs.core.equiv_sequential.call(null, G__14202, G__14203);
};
cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__14204 = cljs.core.List.EMPTY;
  var G__14205 = self__.meta;
  return cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__14204, G__14205) : cljs.core.with_meta.call(null, G__14204, G__14205);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {
  var self__ = this;
  var col__$1 = this;
  var G__14206 = f;
  var G__14207 = col__$1;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__14206, G__14207) : cljs.core.seq_reduce.call(null, G__14206, G__14207);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {
  var self__ = this;
  var col__$1 = this;
  var G__14208 = f;
  var G__14209 = start;
  var G__14210 = col__$1;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__14208, G__14209, G__14210) : cljs.core.seq_reduce.call(null, G__14208, G__14209, G__14210);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci, self__.i);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__14211 = o;
  var G__14212 = coll__$1;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__14211, G__14212) : cljs.core.cons.call(null, G__14211, G__14212);
};
cljs.core.RSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ci", "ci", 2049808339, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RSeq");
};
cljs.core.__GT_RSeq = function cljs$core$__GT_RSeq(ci, i, meta) {
  return new cljs.core.RSeq(ci, i, meta);
};
cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.second = function cljs$core$second(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.ffirst = function cljs$core$ffirst(coll) {
  return cljs.core.first(cljs.core.first(coll));
};
cljs.core.nfirst = function cljs$core$nfirst(coll) {
  return cljs.core.next(cljs.core.first(coll));
};
cljs.core.fnext = function cljs$core$fnext(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.nnext = function cljs$core$nnext(coll) {
  return cljs.core.next(cljs.core.next(coll));
};
cljs.core.last = function cljs$core$last(s) {
  while (true) {
    var sn = cljs.core.next(s);
    if (!(sn == null)) {
      var G__14213 = sn;
      s = G__14213;
      continue;
    } else {
      return cljs.core.first(s);
    }
    break;
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o;
};
cljs.core.conj = function cljs$core$conj() {
  var G__14218 = arguments.length;
  switch(G__14218) {
    case 0:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  if (!(coll == null)) {
    return cljs.core._conj(coll, x);
  } else {
    return cljs.core._conj(cljs.core.List.EMPTY, x);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = function(coll, x, xs) {
  while (true) {
    if (cljs.core.truth_(xs)) {
      var G__14220 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
      var G__14221 = cljs.core.first(xs);
      var G__14222 = cljs.core.next(xs);
      coll = G__14220;
      x = G__14221;
      xs = G__14222;
      continue;
    } else {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
    }
    break;
  }
};
cljs.core.conj.cljs$lang$applyTo = function(seq14214) {
  var G__14215 = cljs.core.first(seq14214);
  var seq14214__$1 = cljs.core.next(seq14214);
  var G__14216 = cljs.core.first(seq14214__$1);
  var seq14214__$2 = cljs.core.next(seq14214__$1);
  return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__14215, G__14216, seq14214__$2);
};
cljs.core.conj.cljs$lang$maxFixedArity = 2;
cljs.core.empty = function cljs$core$empty(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._empty(coll);
  }
};
cljs.core.accumulating_seq_count = function cljs$core$accumulating_seq_count(coll) {
  var s = cljs.core.seq(coll);
  var acc = 0;
  while (true) {
    if (cljs.core.counted_QMARK_(s)) {
      return acc + cljs.core._count(s);
    } else {
      var G__14223 = cljs.core.next(s);
      var G__14224 = acc + 1;
      s = G__14223;
      acc = G__14224;
      continue;
    }
    break;
  }
};
cljs.core.count = function cljs$core$count(coll) {
  if (!(coll == null)) {
    if (function() {
      var G__14226 = coll;
      if (G__14226) {
        var bit__4976__auto__ = G__14226.cljs$lang$protocol_mask$partition0$ & 2;
        if (bit__4976__auto__ || G__14226.cljs$core$ICounted$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ICounted$_count$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return coll.length;
      } else {
        if (typeof coll === "string") {
          return coll.length;
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, coll)) {
            return cljs.core._count(coll);
          } else {
            return cljs.core.accumulating_seq_count(coll);
          }
        }
      }
    }
  } else {
    return 0;
  }
};
cljs.core.linear_traversal_nth = function cljs$core$linear_traversal_nth() {
  var G__14228 = arguments.length;
  switch(G__14228) {
    case 2:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  while (true) {
    if (coll == null) {
      throw new Error("Index out of bounds");
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          throw new Error("Index out of bounds");
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
        } else {
          if (cljs.core.seq(coll)) {
            var G__14230 = cljs.core.next(coll);
            var G__14231 = n - 1;
            coll = G__14230;
            n = G__14231;
            continue;
          } else {
            throw new Error("Index out of bounds");
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  while (true) {
    if (coll == null) {
      return not_found;
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          return not_found;
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
        } else {
          if (cljs.core.seq(coll)) {
            var G__14232 = cljs.core.next(coll);
            var G__14233 = n - 1;
            var G__14234 = not_found;
            coll = G__14232;
            n = G__14233;
            not_found = G__14234;
            continue;
          } else {
            return not_found;
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
cljs.core.nth = function cljs$core$nth() {
  var G__14236 = arguments.length;
  switch(G__14236) {
    case 2:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number");
  } else {
    if (coll == null) {
      return coll;
    } else {
      if (function() {
        var G__14237 = coll;
        if (G__14237) {
          var bit__4976__auto__ = G__14237.cljs$lang$protocol_mask$partition0$ & 16;
          if (bit__4976__auto__ || G__14237.cljs$core$IIndexed$) {
            return true;
          } else {
            return false;
          }
        } else {
          return false;
        }
      }()) {
        return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return null;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll[n];
            } else {
              return null;
            }
          } else {
            if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
              return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (function() {
                var G__14238 = coll;
                if (G__14238) {
                  var bit__4983__auto__ = G__14238.cljs$lang$protocol_mask$partition0$ & 64;
                  if (bit__4983__auto__ || G__14238.cljs$core$ISeq$) {
                    return true;
                  } else {
                    if (!G__14238.cljs$lang$protocol_mask$partition0$) {
                      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__14238);
                    } else {
                      return false;
                    }
                  }
                } else {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__14238);
                }
              }()) {
                return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number.");
  } else {
    if (coll == null) {
      return not_found;
    } else {
      if (function() {
        var G__14239 = coll;
        if (G__14239) {
          var bit__4976__auto__ = G__14239.cljs$lang$protocol_mask$partition0$ & 16;
          if (bit__4976__auto__ || G__14239.cljs$core$IIndexed$) {
            return true;
          } else {
            return false;
          }
        } else {
          return false;
        }
      }()) {
        return coll.cljs$core$IIndexed$_nth$arity$3(null, n, not_found);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return not_found;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll[n];
            } else {
              return not_found;
            }
          } else {
            if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
              return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (function() {
                var G__14240 = coll;
                if (G__14240) {
                  var bit__4983__auto__ = G__14240.cljs$lang$protocol_mask$partition0$ & 64;
                  if (bit__4983__auto__ || G__14240.cljs$core$ISeq$) {
                    return true;
                  } else {
                    if (!G__14240.cljs$lang$protocol_mask$partition0$) {
                      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__14240);
                    } else {
                      return false;
                    }
                  }
                } else {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__14240);
                }
              }()) {
                return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$lang$maxFixedArity = 3;
cljs.core.nthrest = function cljs$core$nthrest(coll, n) {
  var n__$1 = n;
  var xs = coll;
  while (true) {
    if (n__$1 > 0 && cljs.core.seq(xs)) {
      var G__14242 = n__$1 - 1;
      var G__14243 = cljs.core.rest(xs);
      n__$1 = G__14242;
      xs = G__14243;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.get = function cljs$core$get() {
  var G__14245 = arguments.length;
  switch(G__14245) {
    case 2:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (o == null) {
    return null;
  } else {
    if (function() {
      var G__14246 = o;
      if (G__14246) {
        var bit__4976__auto__ = G__14246.cljs$lang$protocol_mask$partition0$ & 256;
        if (bit__4976__auto__ || G__14246.cljs$core$ILookup$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(null, k);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k | 0];
        } else {
          return null;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k | 0];
          } else {
            return null;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o, k);
          } else {
            return null;
          }
        }
      }
    }
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null)) {
    if (function() {
      var G__14247 = o;
      if (G__14247) {
        var bit__4976__auto__ = G__14247.cljs$lang$protocol_mask$partition0$ & 256;
        if (bit__4976__auto__ || G__14247.cljs$core$ILookup$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k];
        } else {
          return not_found;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k];
          } else {
            return not_found;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o, k, not_found);
          } else {
            return not_found;
          }
        }
      }
    }
  } else {
    return not_found;
  }
};
cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.assoc = function cljs$core$assoc() {
  var G__14254 = arguments.length;
  switch(G__14254) {
    case 3:
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = function(coll, k, v) {
  if (!(coll == null)) {
    return cljs.core._assoc(coll, k, v);
  } else {
    return cljs.core.PersistentHashMap.fromArrays([k], [v]);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, v, kvs) {
  while (true) {
    var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll, k, v);
    if (cljs.core.truth_(kvs)) {
      var G__14256 = ret;
      var G__14257 = cljs.core.first(kvs);
      var G__14258 = cljs.core.second(kvs);
      var G__14259 = cljs.core.nnext(kvs);
      coll = G__14256;
      k = G__14257;
      v = G__14258;
      kvs = G__14259;
      continue;
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.assoc.cljs$lang$applyTo = function(seq14249) {
  var G__14250 = cljs.core.first(seq14249);
  var seq14249__$1 = cljs.core.next(seq14249);
  var G__14251 = cljs.core.first(seq14249__$1);
  var seq14249__$2 = cljs.core.next(seq14249__$1);
  var G__14252 = cljs.core.first(seq14249__$2);
  var seq14249__$3 = cljs.core.next(seq14249__$2);
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__14250, G__14251, G__14252, seq14249__$3);
};
cljs.core.assoc.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc = function cljs$core$dissoc() {
  var G__14264 = arguments.length;
  switch(G__14264) {
    case 1:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._dissoc(coll, k);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__14266 = ret;
        var G__14267 = cljs.core.first(ks);
        var G__14268 = cljs.core.next(ks);
        coll = G__14266;
        k = G__14267;
        ks = G__14268;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.dissoc.cljs$lang$applyTo = function(seq14260) {
  var G__14261 = cljs.core.first(seq14260);
  var seq14260__$1 = cljs.core.next(seq14260);
  var G__14262 = cljs.core.first(seq14260__$1);
  var seq14260__$2 = cljs.core.next(seq14260__$1);
  return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14261, G__14262, seq14260__$2);
};
cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
cljs.core.fn_QMARK_ = function cljs$core$fn_QMARK_(f) {
  var or__4309__auto__ = function() {
    var G__14273 = f;
    return goog.isFunction(G__14273);
  }();
  if (cljs.core.truth_(or__4309__auto__)) {
    return or__4309__auto__;
  } else {
    var G__14274 = f;
    if (G__14274) {
      var bit__4983__auto__ = null;
      if (cljs.core.truth_(function() {
        var or__4309__auto____$1 = bit__4983__auto__;
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          return G__14274.cljs$core$Fn$;
        }
      }())) {
        return true;
      } else {
        if (!G__14274.cljs$lang$protocol_mask$partition$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, G__14274);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, G__14274);
    }
  }
};
cljs.core.MetaFn = function(afn, meta) {
  this.afn = afn;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 393217;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.MetaFn(self__.afn, new_meta);
};
cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;
cljs.core.MetaFn.prototype.call = function() {
  var G__14740 = null;
  var G__14740__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
  };
  var G__14740__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14276 = a;
    return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__14276) : self__.afn.call(null, G__14276);
  };
  var G__14740__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14277 = a;
    var G__14278 = b;
    return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__14277, G__14278) : self__.afn.call(null, G__14277, G__14278);
  };
  var G__14740__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14279 = a;
    var G__14280 = b;
    var G__14281 = c;
    return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__14279, G__14280, G__14281) : self__.afn.call(null, G__14279, G__14280, G__14281);
  };
  var G__14740__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14282 = a;
    var G__14283 = b;
    var G__14284 = c;
    var G__14285 = d;
    return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__14282, G__14283, G__14284, G__14285) : self__.afn.call(null, G__14282, G__14283, G__14284, G__14285);
  };
  var G__14740__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14286 = a;
    var G__14287 = b;
    var G__14288 = c;
    var G__14289 = d;
    var G__14290 = e;
    return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__14286, G__14287, G__14288, G__14289, G__14290) : self__.afn.call(null, G__14286, G__14287, G__14288, G__14289, G__14290);
  };
  var G__14740__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14291 = a;
    var G__14292 = b;
    var G__14293 = c;
    var G__14294 = d;
    var G__14295 = e;
    var G__14296 = f;
    return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__14291, G__14292, G__14293, G__14294, G__14295, G__14296) : self__.afn.call(null, G__14291, G__14292, G__14293, G__14294, G__14295, G__14296);
  };
  var G__14740__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14297 = a;
    var G__14298 = b;
    var G__14299 = c;
    var G__14300 = d;
    var G__14301 = e;
    var G__14302 = f;
    var G__14303 = g;
    return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__14297, G__14298, G__14299, G__14300, G__14301, G__14302, G__14303) : self__.afn.call(null, G__14297, G__14298, G__14299, G__14300, G__14301, G__14302, G__14303);
  };
  var G__14740__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14304 = a;
    var G__14305 = b;
    var G__14306 = c;
    var G__14307 = d;
    var G__14308 = e;
    var G__14309 = f;
    var G__14310 = g;
    var G__14311 = h;
    return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__14304, G__14305, G__14306, G__14307, G__14308, G__14309, G__14310, G__14311) : self__.afn.call(null, G__14304, G__14305, G__14306, G__14307, G__14308, G__14309, G__14310, G__14311);
  };
  var G__14740__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14312 = a;
    var G__14313 = b;
    var G__14314 = c;
    var G__14315 = d;
    var G__14316 = e;
    var G__14317 = f;
    var G__14318 = g;
    var G__14319 = h;
    var G__14320 = i;
    return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__14312, G__14313, G__14314, G__14315, G__14316, G__14317, G__14318, G__14319, G__14320) : self__.afn.call(null, G__14312, G__14313, G__14314, G__14315, G__14316, G__14317, G__14318, G__14319, G__14320);
  };
  var G__14740__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14321 = a;
    var G__14322 = b;
    var G__14323 = c;
    var G__14324 = d;
    var G__14325 = e;
    var G__14326 = f;
    var G__14327 = g;
    var G__14328 = h;
    var G__14329 = i;
    var G__14330 = j;
    return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__14321, G__14322, G__14323, G__14324, G__14325, G__14326, G__14327, G__14328, G__14329, G__14330) : self__.afn.call(null, G__14321, G__14322, G__14323, G__14324, G__14325, G__14326, G__14327, G__14328, G__14329, G__14330);
  };
  var G__14740__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14331 = a;
    var G__14332 = b;
    var G__14333 = c;
    var G__14334 = d;
    var G__14335 = e;
    var G__14336 = f;
    var G__14337 = g;
    var G__14338 = h;
    var G__14339 = i;
    var G__14340 = j;
    var G__14341 = k;
    return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__14331, G__14332, G__14333, G__14334, G__14335, G__14336, G__14337, G__14338, G__14339, G__14340, G__14341) : self__.afn.call(null, G__14331, G__14332, G__14333, G__14334, G__14335, G__14336, G__14337, G__14338, G__14339, G__14340, G__14341);
  };
  var G__14740__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14342 = a;
    var G__14343 = b;
    var G__14344 = c;
    var G__14345 = d;
    var G__14346 = e;
    var G__14347 = f;
    var G__14348 = g;
    var G__14349 = h;
    var G__14350 = i;
    var G__14351 = j;
    var G__14352 = k;
    var G__14353 = l;
    return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__14342, G__14343, G__14344, G__14345, G__14346, G__14347, G__14348, G__14349, G__14350, G__14351, G__14352, G__14353) : self__.afn.call(null, G__14342, G__14343, G__14344, G__14345, G__14346, G__14347, G__14348, G__14349, G__14350, G__14351, G__14352, G__14353);
  };
  var G__14740__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14354 = a;
    var G__14355 = b;
    var G__14356 = c;
    var G__14357 = d;
    var G__14358 = e;
    var G__14359 = f;
    var G__14360 = g;
    var G__14361 = h;
    var G__14362 = i;
    var G__14363 = j;
    var G__14364 = k;
    var G__14365 = l;
    var G__14366 = m;
    return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__14354, G__14355, G__14356, G__14357, G__14358, G__14359, G__14360, G__14361, G__14362, G__14363, G__14364, G__14365, G__14366) : self__.afn.call(null, G__14354, G__14355, G__14356, G__14357, G__14358, G__14359, G__14360, G__14361, G__14362, G__14363, G__14364, G__14365, G__14366);
  };
  var G__14740__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14367 = a;
    var G__14368 = b;
    var G__14369 = c;
    var G__14370 = d;
    var G__14371 = e;
    var G__14372 = f;
    var G__14373 = g;
    var G__14374 = h;
    var G__14375 = i;
    var G__14376 = j;
    var G__14377 = k;
    var G__14378 = l;
    var G__14379 = m;
    var G__14380 = n;
    return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__14367, G__14368, G__14369, G__14370, G__14371, G__14372, G__14373, G__14374, G__14375, G__14376, G__14377, G__14378, G__14379, G__14380) : self__.afn.call(null, G__14367, G__14368, G__14369, G__14370, G__14371, G__14372, G__14373, G__14374, G__14375, G__14376, G__14377, G__14378, G__14379, G__14380);
  };
  var G__14740__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14381 = a;
    var G__14382 = b;
    var G__14383 = c;
    var G__14384 = d;
    var G__14385 = e;
    var G__14386 = f;
    var G__14387 = g;
    var G__14388 = h;
    var G__14389 = i;
    var G__14390 = j;
    var G__14391 = k;
    var G__14392 = l;
    var G__14393 = m;
    var G__14394 = n;
    var G__14395 = o;
    return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__14381, G__14382, G__14383, G__14384, G__14385, G__14386, G__14387, G__14388, G__14389, G__14390, G__14391, G__14392, G__14393, G__14394, G__14395) : self__.afn.call(null, G__14381, G__14382, G__14383, G__14384, G__14385, G__14386, G__14387, G__14388, G__14389, G__14390, G__14391, G__14392, G__14393, G__14394, G__14395);
  };
  var G__14740__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14396 = a;
    var G__14397 = b;
    var G__14398 = c;
    var G__14399 = d;
    var G__14400 = e;
    var G__14401 = f;
    var G__14402 = g;
    var G__14403 = h;
    var G__14404 = i;
    var G__14405 = j;
    var G__14406 = k;
    var G__14407 = l;
    var G__14408 = m;
    var G__14409 = n;
    var G__14410 = o;
    var G__14411 = p;
    return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__14396, G__14397, G__14398, G__14399, G__14400, G__14401, G__14402, G__14403, G__14404, G__14405, G__14406, G__14407, G__14408, G__14409, G__14410, G__14411) : self__.afn.call(null, G__14396, G__14397, G__14398, G__14399, G__14400, G__14401, G__14402, G__14403, G__14404, G__14405, G__14406, G__14407, G__14408, G__14409, G__14410, G__14411);
  };
  var G__14740__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14412 = a;
    var G__14413 = b;
    var G__14414 = c;
    var G__14415 = d;
    var G__14416 = e;
    var G__14417 = f;
    var G__14418 = g;
    var G__14419 = h;
    var G__14420 = i;
    var G__14421 = j;
    var G__14422 = k;
    var G__14423 = l;
    var G__14424 = m;
    var G__14425 = n;
    var G__14426 = o;
    var G__14427 = p;
    var G__14428 = q;
    return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__14412, G__14413, G__14414, G__14415, G__14416, G__14417, G__14418, G__14419, G__14420, G__14421, G__14422, G__14423, G__14424, G__14425, G__14426, G__14427, G__14428) : self__.afn.call(null, G__14412, G__14413, G__14414, G__14415, G__14416, G__14417, G__14418, G__14419, G__14420, G__14421, G__14422, G__14423, G__14424, G__14425, G__14426, G__14427, G__14428);
  };
  var G__14740__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14429 = a;
    var G__14430 = b;
    var G__14431 = c;
    var G__14432 = d;
    var G__14433 = e;
    var G__14434 = f;
    var G__14435 = g;
    var G__14436 = h;
    var G__14437 = i;
    var G__14438 = j;
    var G__14439 = k;
    var G__14440 = l;
    var G__14441 = m;
    var G__14442 = n;
    var G__14443 = o;
    var G__14444 = p;
    var G__14445 = q;
    var G__14446 = r;
    return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__14429, G__14430, G__14431, G__14432, G__14433, G__14434, G__14435, G__14436, G__14437, G__14438, G__14439, G__14440, G__14441, G__14442, G__14443, G__14444, G__14445, G__14446) : self__.afn.call(null, G__14429, G__14430, G__14431, G__14432, G__14433, G__14434, G__14435, G__14436, G__14437, G__14438, G__14439, G__14440, G__14441, G__14442, G__14443, G__14444, G__14445, G__14446);
  };
  var G__14740__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14447 = a;
    var G__14448 = b;
    var G__14449 = c;
    var G__14450 = d;
    var G__14451 = e;
    var G__14452 = f;
    var G__14453 = g;
    var G__14454 = h;
    var G__14455 = i;
    var G__14456 = j;
    var G__14457 = k;
    var G__14458 = l;
    var G__14459 = m;
    var G__14460 = n;
    var G__14461 = o;
    var G__14462 = p;
    var G__14463 = q;
    var G__14464 = r;
    var G__14465 = s;
    return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__14447, G__14448, G__14449, G__14450, G__14451, G__14452, G__14453, G__14454, G__14455, G__14456, G__14457, G__14458, G__14459, G__14460, G__14461, G__14462, G__14463, G__14464, G__14465) : self__.afn.call(null, G__14447, G__14448, G__14449, G__14450, G__14451, G__14452, G__14453, G__14454, G__14455, G__14456, G__14457, G__14458, G__14459, G__14460, G__14461, G__14462, G__14463, G__14464, G__14465);
  };
  var G__14740__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14466 = a;
    var G__14467 = b;
    var G__14468 = c;
    var G__14469 = d;
    var G__14470 = e;
    var G__14471 = f;
    var G__14472 = g;
    var G__14473 = h;
    var G__14474 = i;
    var G__14475 = j;
    var G__14476 = k;
    var G__14477 = l;
    var G__14478 = m;
    var G__14479 = n;
    var G__14480 = o;
    var G__14481 = p;
    var G__14482 = q;
    var G__14483 = r;
    var G__14484 = s;
    var G__14485 = t;
    return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__14466, G__14467, G__14468, G__14469, G__14470, G__14471, G__14472, G__14473, G__14474, G__14475, G__14476, G__14477, G__14478, G__14479, G__14480, G__14481, G__14482, G__14483, G__14484, G__14485) : self__.afn.call(null, G__14466, G__14467, G__14468, G__14469, G__14470, G__14471, G__14472, G__14473, G__14474, G__14475, G__14476, G__14477, G__14478, G__14479, G__14480, G__14481, G__14482, G__14483, 
    G__14484, G__14485);
  };
  var G__14740__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__14486 = self__.afn;
    var G__14487 = a;
    var G__14488 = b;
    var G__14489 = c;
    var G__14490 = d;
    var G__14491 = e;
    var G__14492 = f;
    var G__14493 = g;
    var G__14494 = h;
    var G__14495 = i;
    var G__14496 = j;
    var G__14497 = k;
    var G__14498 = l;
    var G__14499 = m;
    var G__14500 = n;
    var G__14501 = o;
    var G__14502 = p;
    var G__14503 = q;
    var G__14504 = r;
    var G__14505 = s;
    var G__14506 = t;
    var G__14507 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__14486, G__14487, G__14488, G__14489, G__14490, G__14491, G__14492, G__14493, G__14494, G__14495, G__14496, G__14497, G__14498, G__14499, G__14500, G__14501, G__14502, G__14503, G__14504, G__14505, G__14506, G__14507) : cljs.core.apply.call(null, G__14486, G__14487, G__14488, G__14489, G__14490, G__14491, G__14492, G__14493, G__14494, G__14495, G__14496, G__14497, G__14498, G__14499, G__14500, 
    G__14501, G__14502, G__14503, G__14504, G__14505, G__14506, G__14507);
  };
  G__14740 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__14740__1.call(this, self__);
      case 2:
        return G__14740__2.call(this, self__, a);
      case 3:
        return G__14740__3.call(this, self__, a, b);
      case 4:
        return G__14740__4.call(this, self__, a, b, c);
      case 5:
        return G__14740__5.call(this, self__, a, b, c, d);
      case 6:
        return G__14740__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__14740__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__14740__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__14740__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__14740__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__14740__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__14740__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__14740__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__14740__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__14740__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__14740__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__14740__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__14740__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__14740__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__14740__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__14740__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__14740__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__14740.cljs$core$IFn$_invoke$arity$1 = G__14740__1;
  G__14740.cljs$core$IFn$_invoke$arity$2 = G__14740__2;
  G__14740.cljs$core$IFn$_invoke$arity$3 = G__14740__3;
  G__14740.cljs$core$IFn$_invoke$arity$4 = G__14740__4;
  G__14740.cljs$core$IFn$_invoke$arity$5 = G__14740__5;
  G__14740.cljs$core$IFn$_invoke$arity$6 = G__14740__6;
  G__14740.cljs$core$IFn$_invoke$arity$7 = G__14740__7;
  G__14740.cljs$core$IFn$_invoke$arity$8 = G__14740__8;
  G__14740.cljs$core$IFn$_invoke$arity$9 = G__14740__9;
  G__14740.cljs$core$IFn$_invoke$arity$10 = G__14740__10;
  G__14740.cljs$core$IFn$_invoke$arity$11 = G__14740__11;
  G__14740.cljs$core$IFn$_invoke$arity$12 = G__14740__12;
  G__14740.cljs$core$IFn$_invoke$arity$13 = G__14740__13;
  G__14740.cljs$core$IFn$_invoke$arity$14 = G__14740__14;
  G__14740.cljs$core$IFn$_invoke$arity$15 = G__14740__15;
  G__14740.cljs$core$IFn$_invoke$arity$16 = G__14740__16;
  G__14740.cljs$core$IFn$_invoke$arity$17 = G__14740__17;
  G__14740.cljs$core$IFn$_invoke$arity$18 = G__14740__18;
  G__14740.cljs$core$IFn$_invoke$arity$19 = G__14740__19;
  G__14740.cljs$core$IFn$_invoke$arity$20 = G__14740__20;
  G__14740.cljs$core$IFn$_invoke$arity$21 = G__14740__21;
  G__14740.cljs$core$IFn$_invoke$arity$22 = G__14740__22;
  return G__14740;
}();
cljs.core.MetaFn.prototype.apply = function(self__, args14275) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args14275)));
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  var G__14508 = a;
  return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__14508) : self__.afn.call(null, G__14508);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  var G__14509 = a;
  var G__14510 = b;
  return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__14509, G__14510) : self__.afn.call(null, G__14509, G__14510);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  var G__14511 = a;
  var G__14512 = b;
  var G__14513 = c;
  return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__14511, G__14512, G__14513) : self__.afn.call(null, G__14511, G__14512, G__14513);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  var G__14514 = a;
  var G__14515 = b;
  var G__14516 = c;
  var G__14517 = d;
  return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__14514, G__14515, G__14516, G__14517) : self__.afn.call(null, G__14514, G__14515, G__14516, G__14517);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  var G__14518 = a;
  var G__14519 = b;
  var G__14520 = c;
  var G__14521 = d;
  var G__14522 = e;
  return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__14518, G__14519, G__14520, G__14521, G__14522) : self__.afn.call(null, G__14518, G__14519, G__14520, G__14521, G__14522);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  var G__14523 = a;
  var G__14524 = b;
  var G__14525 = c;
  var G__14526 = d;
  var G__14527 = e;
  var G__14528 = f;
  return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__14523, G__14524, G__14525, G__14526, G__14527, G__14528) : self__.afn.call(null, G__14523, G__14524, G__14525, G__14526, G__14527, G__14528);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  var G__14529 = a;
  var G__14530 = b;
  var G__14531 = c;
  var G__14532 = d;
  var G__14533 = e;
  var G__14534 = f;
  var G__14535 = g;
  return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__14529, G__14530, G__14531, G__14532, G__14533, G__14534, G__14535) : self__.afn.call(null, G__14529, G__14530, G__14531, G__14532, G__14533, G__14534, G__14535);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  var G__14536 = a;
  var G__14537 = b;
  var G__14538 = c;
  var G__14539 = d;
  var G__14540 = e;
  var G__14541 = f;
  var G__14542 = g;
  var G__14543 = h;
  return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__14536, G__14537, G__14538, G__14539, G__14540, G__14541, G__14542, G__14543) : self__.afn.call(null, G__14536, G__14537, G__14538, G__14539, G__14540, G__14541, G__14542, G__14543);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  var G__14544 = a;
  var G__14545 = b;
  var G__14546 = c;
  var G__14547 = d;
  var G__14548 = e;
  var G__14549 = f;
  var G__14550 = g;
  var G__14551 = h;
  var G__14552 = i;
  return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__14544, G__14545, G__14546, G__14547, G__14548, G__14549, G__14550, G__14551, G__14552) : self__.afn.call(null, G__14544, G__14545, G__14546, G__14547, G__14548, G__14549, G__14550, G__14551, G__14552);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  var G__14553 = a;
  var G__14554 = b;
  var G__14555 = c;
  var G__14556 = d;
  var G__14557 = e;
  var G__14558 = f;
  var G__14559 = g;
  var G__14560 = h;
  var G__14561 = i;
  var G__14562 = j;
  return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__14553, G__14554, G__14555, G__14556, G__14557, G__14558, G__14559, G__14560, G__14561, G__14562) : self__.afn.call(null, G__14553, G__14554, G__14555, G__14556, G__14557, G__14558, G__14559, G__14560, G__14561, G__14562);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  var G__14563 = a;
  var G__14564 = b;
  var G__14565 = c;
  var G__14566 = d;
  var G__14567 = e;
  var G__14568 = f;
  var G__14569 = g;
  var G__14570 = h;
  var G__14571 = i;
  var G__14572 = j;
  var G__14573 = k;
  return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__14563, G__14564, G__14565, G__14566, G__14567, G__14568, G__14569, G__14570, G__14571, G__14572, G__14573) : self__.afn.call(null, G__14563, G__14564, G__14565, G__14566, G__14567, G__14568, G__14569, G__14570, G__14571, G__14572, G__14573);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  var G__14574 = a;
  var G__14575 = b;
  var G__14576 = c;
  var G__14577 = d;
  var G__14578 = e;
  var G__14579 = f;
  var G__14580 = g;
  var G__14581 = h;
  var G__14582 = i;
  var G__14583 = j;
  var G__14584 = k;
  var G__14585 = l;
  return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__14574, G__14575, G__14576, G__14577, G__14578, G__14579, G__14580, G__14581, G__14582, G__14583, G__14584, G__14585) : self__.afn.call(null, G__14574, G__14575, G__14576, G__14577, G__14578, G__14579, G__14580, G__14581, G__14582, G__14583, G__14584, G__14585);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  var G__14586 = a;
  var G__14587 = b;
  var G__14588 = c;
  var G__14589 = d;
  var G__14590 = e;
  var G__14591 = f;
  var G__14592 = g;
  var G__14593 = h;
  var G__14594 = i;
  var G__14595 = j;
  var G__14596 = k;
  var G__14597 = l;
  var G__14598 = m;
  return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__14586, G__14587, G__14588, G__14589, G__14590, G__14591, G__14592, G__14593, G__14594, G__14595, G__14596, G__14597, G__14598) : self__.afn.call(null, G__14586, G__14587, G__14588, G__14589, G__14590, G__14591, G__14592, G__14593, G__14594, G__14595, G__14596, G__14597, G__14598);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  var G__14599 = a;
  var G__14600 = b;
  var G__14601 = c;
  var G__14602 = d;
  var G__14603 = e;
  var G__14604 = f;
  var G__14605 = g;
  var G__14606 = h;
  var G__14607 = i;
  var G__14608 = j;
  var G__14609 = k;
  var G__14610 = l;
  var G__14611 = m;
  var G__14612 = n;
  return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__14599, G__14600, G__14601, G__14602, G__14603, G__14604, G__14605, G__14606, G__14607, G__14608, G__14609, G__14610, G__14611, G__14612) : self__.afn.call(null, G__14599, G__14600, G__14601, G__14602, G__14603, G__14604, G__14605, G__14606, G__14607, G__14608, G__14609, G__14610, G__14611, G__14612);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  var G__14613 = a;
  var G__14614 = b;
  var G__14615 = c;
  var G__14616 = d;
  var G__14617 = e;
  var G__14618 = f;
  var G__14619 = g;
  var G__14620 = h;
  var G__14621 = i;
  var G__14622 = j;
  var G__14623 = k;
  var G__14624 = l;
  var G__14625 = m;
  var G__14626 = n;
  var G__14627 = o;
  return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__14613, G__14614, G__14615, G__14616, G__14617, G__14618, G__14619, G__14620, G__14621, G__14622, G__14623, G__14624, G__14625, G__14626, G__14627) : self__.afn.call(null, G__14613, G__14614, G__14615, G__14616, G__14617, G__14618, G__14619, G__14620, G__14621, G__14622, G__14623, G__14624, G__14625, G__14626, G__14627);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  var G__14628 = a;
  var G__14629 = b;
  var G__14630 = c;
  var G__14631 = d;
  var G__14632 = e;
  var G__14633 = f;
  var G__14634 = g;
  var G__14635 = h;
  var G__14636 = i;
  var G__14637 = j;
  var G__14638 = k;
  var G__14639 = l;
  var G__14640 = m;
  var G__14641 = n;
  var G__14642 = o;
  var G__14643 = p;
  return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__14628, G__14629, G__14630, G__14631, G__14632, G__14633, G__14634, G__14635, G__14636, G__14637, G__14638, G__14639, G__14640, G__14641, G__14642, G__14643) : self__.afn.call(null, G__14628, G__14629, G__14630, G__14631, G__14632, G__14633, G__14634, G__14635, G__14636, G__14637, G__14638, G__14639, G__14640, G__14641, G__14642, G__14643);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  var G__14644 = a;
  var G__14645 = b;
  var G__14646 = c;
  var G__14647 = d;
  var G__14648 = e;
  var G__14649 = f;
  var G__14650 = g;
  var G__14651 = h;
  var G__14652 = i;
  var G__14653 = j;
  var G__14654 = k;
  var G__14655 = l;
  var G__14656 = m;
  var G__14657 = n;
  var G__14658 = o;
  var G__14659 = p;
  var G__14660 = q;
  return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__14644, G__14645, G__14646, G__14647, G__14648, G__14649, G__14650, G__14651, G__14652, G__14653, G__14654, G__14655, G__14656, G__14657, G__14658, G__14659, G__14660) : self__.afn.call(null, G__14644, G__14645, G__14646, G__14647, G__14648, G__14649, G__14650, G__14651, G__14652, G__14653, G__14654, G__14655, G__14656, G__14657, G__14658, G__14659, G__14660);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  var G__14661 = a;
  var G__14662 = b;
  var G__14663 = c;
  var G__14664 = d;
  var G__14665 = e;
  var G__14666 = f;
  var G__14667 = g;
  var G__14668 = h;
  var G__14669 = i;
  var G__14670 = j;
  var G__14671 = k;
  var G__14672 = l;
  var G__14673 = m;
  var G__14674 = n;
  var G__14675 = o;
  var G__14676 = p;
  var G__14677 = q;
  var G__14678 = r;
  return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__14661, G__14662, G__14663, G__14664, G__14665, G__14666, G__14667, G__14668, G__14669, G__14670, G__14671, G__14672, G__14673, G__14674, G__14675, G__14676, G__14677, G__14678) : self__.afn.call(null, G__14661, G__14662, G__14663, G__14664, G__14665, G__14666, G__14667, G__14668, G__14669, G__14670, G__14671, G__14672, G__14673, G__14674, G__14675, G__14676, G__14677, G__14678);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  var G__14679 = a;
  var G__14680 = b;
  var G__14681 = c;
  var G__14682 = d;
  var G__14683 = e;
  var G__14684 = f;
  var G__14685 = g;
  var G__14686 = h;
  var G__14687 = i;
  var G__14688 = j;
  var G__14689 = k;
  var G__14690 = l;
  var G__14691 = m;
  var G__14692 = n;
  var G__14693 = o;
  var G__14694 = p;
  var G__14695 = q;
  var G__14696 = r;
  var G__14697 = s;
  return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__14679, G__14680, G__14681, G__14682, G__14683, G__14684, G__14685, G__14686, G__14687, G__14688, G__14689, G__14690, G__14691, G__14692, G__14693, G__14694, G__14695, G__14696, G__14697) : self__.afn.call(null, G__14679, G__14680, G__14681, G__14682, G__14683, G__14684, G__14685, G__14686, G__14687, G__14688, G__14689, G__14690, G__14691, G__14692, G__14693, G__14694, G__14695, G__14696, G__14697);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  var G__14698 = a;
  var G__14699 = b;
  var G__14700 = c;
  var G__14701 = d;
  var G__14702 = e;
  var G__14703 = f;
  var G__14704 = g;
  var G__14705 = h;
  var G__14706 = i;
  var G__14707 = j;
  var G__14708 = k;
  var G__14709 = l;
  var G__14710 = m;
  var G__14711 = n;
  var G__14712 = o;
  var G__14713 = p;
  var G__14714 = q;
  var G__14715 = r;
  var G__14716 = s;
  var G__14717 = t;
  return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__14698, G__14699, G__14700, G__14701, G__14702, G__14703, G__14704, G__14705, G__14706, G__14707, G__14708, G__14709, G__14710, G__14711, G__14712, G__14713, G__14714, G__14715, G__14716, G__14717) : self__.afn.call(null, G__14698, G__14699, G__14700, G__14701, G__14702, G__14703, G__14704, G__14705, G__14706, G__14707, G__14708, G__14709, G__14710, G__14711, G__14712, G__14713, G__14714, G__14715, G__14716, 
  G__14717);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__14718 = self__.afn;
  var G__14719 = a;
  var G__14720 = b;
  var G__14721 = c;
  var G__14722 = d;
  var G__14723 = e;
  var G__14724 = f;
  var G__14725 = g;
  var G__14726 = h;
  var G__14727 = i;
  var G__14728 = j;
  var G__14729 = k;
  var G__14730 = l;
  var G__14731 = m;
  var G__14732 = n;
  var G__14733 = o;
  var G__14734 = p;
  var G__14735 = q;
  var G__14736 = r;
  var G__14737 = s;
  var G__14738 = t;
  var G__14739 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__14718, G__14719, G__14720, G__14721, G__14722, G__14723, G__14724, G__14725, G__14726, G__14727, G__14728, G__14729, G__14730, G__14731, G__14732, G__14733, G__14734, G__14735, G__14736, G__14737, G__14738, G__14739) : cljs.core.apply.call(null, G__14718, G__14719, G__14720, G__14721, G__14722, G__14723, G__14724, G__14725, G__14726, G__14727, G__14728, G__14729, G__14730, G__14731, G__14732, 
  G__14733, G__14734, G__14735, G__14736, G__14737, G__14738, G__14739);
};
cljs.core.MetaFn.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "afn", "afn", 216963467, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.MetaFn.cljs$lang$type = true;
cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";
cljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/MetaFn");
};
cljs.core.__GT_MetaFn = function cljs$core$__GT_MetaFn(afn, meta) {
  return new cljs.core.MetaFn(afn, meta);
};
cljs.core.with_meta = function cljs$core$with_meta(o, meta) {
  if (cljs.core.fn_QMARK_(o) && !function() {
    var G__14744 = o;
    if (G__14744) {
      var bit__4983__auto__ = G__14744.cljs$lang$protocol_mask$partition0$ & 262144;
      if (bit__4983__auto__ || G__14744.cljs$core$IWithMeta$) {
        return true;
      } else {
        if (!G__14744.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta, G__14744);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta, G__14744);
    }
  }()) {
    return new cljs.core.MetaFn(o, meta);
  } else {
    if (o == null) {
      return null;
    } else {
      return cljs.core._with_meta(o, meta);
    }
  }
};
cljs.core.meta = function cljs$core$meta(o) {
  if (function() {
    var and__4297__auto__ = !(o == null);
    if (and__4297__auto__) {
      var G__14748 = o;
      if (G__14748) {
        var bit__4983__auto__ = G__14748.cljs$lang$protocol_mask$partition0$ & 131072;
        if (bit__4983__auto__ || G__14748.cljs$core$IMeta$) {
          return true;
        } else {
          if (!G__14748.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, G__14748);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, G__14748);
      }
    } else {
      return and__4297__auto__;
    }
  }()) {
    return cljs.core._meta(o);
  } else {
    return null;
  }
};
cljs.core.peek = function cljs$core$peek(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._peek(coll);
  }
};
cljs.core.pop = function cljs$core$pop(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._pop(coll);
  }
};
cljs.core.disj = function cljs$core$disj() {
  var G__14753 = arguments.length;
  switch(G__14753) {
    case 1:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._disjoin(coll, k);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__14755 = ret;
        var G__14756 = cljs.core.first(ks);
        var G__14757 = cljs.core.next(ks);
        coll = G__14755;
        k = G__14756;
        ks = G__14757;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.disj.cljs$lang$applyTo = function(seq14749) {
  var G__14750 = cljs.core.first(seq14749);
  var seq14749__$1 = cljs.core.next(seq14749);
  var G__14751 = cljs.core.first(seq14749__$1);
  var seq14749__$2 = cljs.core.next(seq14749__$1);
  return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__14750, G__14751, seq14749__$2);
};
cljs.core.disj.cljs$lang$maxFixedArity = 2;
cljs.core.empty_QMARK_ = function cljs$core$empty_QMARK_(coll) {
  return coll == null || cljs.core.not(cljs.core.seq(coll));
};
cljs.core.coll_QMARK_ = function cljs$core$coll_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__14759 = x;
    if (G__14759) {
      var bit__4983__auto__ = G__14759.cljs$lang$protocol_mask$partition0$ & 8;
      if (bit__4983__auto__ || G__14759.cljs$core$ICollection$) {
        return true;
      } else {
        if (!G__14759.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, G__14759);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, G__14759);
    }
  }
};
cljs.core.set_QMARK_ = function cljs$core$set_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__14761 = x;
    if (G__14761) {
      var bit__4983__auto__ = G__14761.cljs$lang$protocol_mask$partition0$ & 4096;
      if (bit__4983__auto__ || G__14761.cljs$core$ISet$) {
        return true;
      } else {
        if (!G__14761.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, G__14761);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, G__14761);
    }
  }
};
cljs.core.associative_QMARK_ = function cljs$core$associative_QMARK_(x) {
  var G__14763 = x;
  if (G__14763) {
    var bit__4983__auto__ = G__14763.cljs$lang$protocol_mask$partition0$ & 512;
    if (bit__4983__auto__ || G__14763.cljs$core$IAssociative$) {
      return true;
    } else {
      if (!G__14763.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, G__14763);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, G__14763);
  }
};
cljs.core.sequential_QMARK_ = function cljs$core$sequential_QMARK_(x) {
  var G__14765 = x;
  if (G__14765) {
    var bit__4983__auto__ = G__14765.cljs$lang$protocol_mask$partition0$ & 16777216;
    if (bit__4983__auto__ || G__14765.cljs$core$ISequential$) {
      return true;
    } else {
      if (!G__14765.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, G__14765);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, G__14765);
  }
};
cljs.core.sorted_QMARK_ = function cljs$core$sorted_QMARK_(x) {
  var G__14767 = x;
  if (G__14767) {
    var bit__4983__auto__ = G__14767.cljs$lang$protocol_mask$partition0$ & 268435456;
    if (bit__4983__auto__ || G__14767.cljs$core$ISorted$) {
      return true;
    } else {
      if (!G__14767.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, G__14767);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, G__14767);
  }
};
cljs.core.reduceable_QMARK_ = function cljs$core$reduceable_QMARK_(x) {
  var G__14769 = x;
  if (G__14769) {
    var bit__4983__auto__ = G__14769.cljs$lang$protocol_mask$partition0$ & 524288;
    if (bit__4983__auto__ || G__14769.cljs$core$IReduce$) {
      return true;
    } else {
      if (!G__14769.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, G__14769);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, G__14769);
  }
};
cljs.core.map_QMARK_ = function cljs$core$map_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__14771 = x;
    if (G__14771) {
      var bit__4983__auto__ = G__14771.cljs$lang$protocol_mask$partition0$ & 1024;
      if (bit__4983__auto__ || G__14771.cljs$core$IMap$) {
        return true;
      } else {
        if (!G__14771.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, G__14771);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, G__14771);
    }
  }
};
cljs.core.record_QMARK_ = function cljs$core$record_QMARK_(x) {
  var G__14773 = x;
  if (G__14773) {
    var bit__4983__auto__ = G__14773.cljs$lang$protocol_mask$partition0$ & 67108864;
    if (bit__4983__auto__ || G__14773.cljs$core$IRecord$) {
      return true;
    } else {
      if (!G__14773.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, G__14773);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, G__14773);
  }
};
cljs.core.vector_QMARK_ = function cljs$core$vector_QMARK_(x) {
  var G__14775 = x;
  if (G__14775) {
    var bit__4983__auto__ = G__14775.cljs$lang$protocol_mask$partition0$ & 16384;
    if (bit__4983__auto__ || G__14775.cljs$core$IVector$) {
      return true;
    } else {
      if (!G__14775.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, G__14775);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, G__14775);
  }
};
cljs.core.chunked_seq_QMARK_ = function cljs$core$chunked_seq_QMARK_(x) {
  var G__14777 = x;
  if (G__14777) {
    var bit__4976__auto__ = G__14777.cljs$lang$protocol_mask$partition1$ & 512;
    if (bit__4976__auto__ || G__14777.cljs$core$IChunkedSeq$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.js_obj = function cljs$core$js_obj() {
  var G__14780 = arguments.length;
  switch(G__14780) {
    case 0:
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0);
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__5360__auto__);
  }
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = function() {
  var obj14782 = {};
  return obj14782;
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var G__14783 = goog.object.create;
  var G__14784 = keyvals;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__14783, G__14784) : cljs.core.apply.call(null, G__14783, G__14784);
};
cljs.core.js_obj.cljs$lang$applyTo = function(seq14778) {
  return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14778));
};
cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
cljs.core.js_keys = function cljs$core$js_keys(obj) {
  var keys = [];
  var G__14788_14790 = obj;
  var G__14789_14791 = function(G__14788_14790, keys) {
    return function(val, key, obj__$1) {
      return keys.push(key);
    };
  }(G__14788_14790, keys);
  goog.object.forEach(G__14788_14790, G__14789_14791);
  return keys;
};
cljs.core.js_delete = function cljs$core$js_delete(obj, key) {
  return delete obj[key];
};
cljs.core.array_copy = function cljs$core$array_copy(from, i, to, j, len) {
  var i__$1 = i;
  var j__$1 = j;
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__14792 = i__$1 + 1;
      var G__14793 = j__$1 + 1;
      var G__14794 = len__$1 - 1;
      i__$1 = G__14792;
      j__$1 = G__14793;
      len__$1 = G__14794;
      continue;
    }
    break;
  }
};
cljs.core.array_copy_downward = function cljs$core$array_copy_downward(from, i, to, j, len) {
  var i__$1 = i + (len - 1);
  var j__$1 = j + (len - 1);
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__14795 = i__$1 - 1;
      var G__14796 = j__$1 - 1;
      var G__14797 = len__$1 - 1;
      i__$1 = G__14795;
      j__$1 = G__14796;
      len__$1 = G__14797;
      continue;
    }
    break;
  }
};
cljs.core.lookup_sentinel = function() {
  var obj14799 = {};
  return obj14799;
}();
cljs.core.false_QMARK_ = function cljs$core$false_QMARK_(x) {
  return x === false;
};
cljs.core.true_QMARK_ = function cljs$core$true_QMARK_(x) {
  return x === true;
};
cljs.core.undefined_QMARK_ = function cljs$core$undefined_QMARK_(x) {
  return void 0 === x;
};
cljs.core.seq_QMARK_ = function cljs$core$seq_QMARK_(s) {
  if (s == null) {
    return false;
  } else {
    var G__14801 = s;
    if (G__14801) {
      var bit__4983__auto__ = G__14801.cljs$lang$protocol_mask$partition0$ & 64;
      if (bit__4983__auto__ || G__14801.cljs$core$ISeq$) {
        return true;
      } else {
        if (!G__14801.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__14801);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__14801);
    }
  }
};
cljs.core.seqable_QMARK_ = function cljs$core$seqable_QMARK_(s) {
  var G__14803 = s;
  if (G__14803) {
    var bit__4983__auto__ = G__14803.cljs$lang$protocol_mask$partition0$ & 8388608;
    if (bit__4983__auto__ || G__14803.cljs$core$ISeqable$) {
      return true;
    } else {
      if (!G__14803.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, G__14803);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, G__14803);
  }
};
cljs.core.boolean$ = function cljs$core$boolean(x) {
  if (cljs.core.truth_(x)) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ifn_QMARK_ = function cljs$core$ifn_QMARK_(f) {
  var or__4309__auto__ = cljs.core.fn_QMARK_(f);
  if (or__4309__auto__) {
    return or__4309__auto__;
  } else {
    var G__14807 = f;
    if (G__14807) {
      var bit__4983__auto__ = G__14807.cljs$lang$protocol_mask$partition0$ & 1;
      if (bit__4983__auto__ || G__14807.cljs$core$IFn$) {
        return true;
      } else {
        if (!G__14807.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, G__14807);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, G__14807);
    }
  }
};
cljs.core.integer_QMARK_ = function cljs$core$integer_QMARK_(n) {
  return typeof n === "number" && cljs.core.not(function() {
    var G__14820 = n;
    return isNaN(G__14820);
  }()) && !(n === Infinity) && function() {
    var G__14821 = n;
    return parseFloat(G__14821);
  }() === function() {
    var G__14822 = n;
    var G__14823 = 10;
    return parseInt(G__14822, G__14823);
  }();
};
cljs.core.contains_QMARK_ = function cljs$core$contains_QMARK_(coll, v) {
  if (cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false;
  } else {
    return true;
  }
};
cljs.core.find = function cljs$core$find(coll, k) {
  if (!(coll == null) && cljs.core.associative_QMARK_(coll) && cljs.core.contains_QMARK_(coll, k)) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, k)], null);
  } else {
    return null;
  }
};
cljs.core.distinct_QMARK_ = function cljs$core$distinct_QMARK_() {
  var G__14828 = arguments.length;
  switch(G__14828) {
    case 1:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  if (!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
    var s = cljs.core.PersistentHashSet.fromArray([x, y], true);
    var xs = more;
    while (true) {
      var x__$1 = cljs.core.first(xs);
      var etc = cljs.core.next(xs);
      if (cljs.core.truth_(xs)) {
        if (cljs.core.contains_QMARK_(s, x__$1)) {
          return false;
        } else {
          var G__14830 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s, x__$1);
          var G__14831 = etc;
          s = G__14830;
          xs = G__14831;
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  } else {
    return false;
  }
};
cljs.core.distinct_QMARK_.cljs$lang$applyTo = function(seq14824) {
  var G__14825 = cljs.core.first(seq14824);
  var seq14824__$1 = cljs.core.next(seq14824);
  var G__14826 = cljs.core.first(seq14824__$1);
  var seq14824__$2 = cljs.core.next(seq14824__$1);
  return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__14825, G__14826, seq14824__$2);
};
cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs.core.compare = function cljs$core$compare(x, y) {
  if (x === y) {
    return 0;
  } else {
    if (x == null) {
      return -1;
    } else {
      if (y == null) {
        return 1;
      } else {
        if (typeof x === "number") {
          if (typeof y === "number") {
            var G__14837 = x;
            var G__14838 = y;
            return goog.array.defaultCompare(G__14837, G__14838);
          } else {
            throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
          }
        } else {
          if (function() {
            var G__14839 = x;
            if (G__14839) {
              var bit__4983__auto__ = G__14839.cljs$lang$protocol_mask$partition1$ & 2048;
              if (bit__4983__auto__ || G__14839.cljs$core$IComparable$) {
                return true;
              } else {
                if (!G__14839.cljs$lang$protocol_mask$partition1$) {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, G__14839);
                } else {
                  return false;
                }
              }
            } else {
              return cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, G__14839);
            }
          }()) {
            return cljs.core._compare(x, y);
          } else {
            if ((typeof x === "string" || cljs.core.array_QMARK_(x) || x === true || x === false) && cljs.core.type(x) === cljs.core.type(y)) {
              var G__14840 = x;
              var G__14841 = y;
              return goog.array.defaultCompare(G__14840, G__14841);
            } else {
              throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
            }
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function cljs$core$compare_indexed() {
  var G__14843 = arguments.length;
  switch(G__14843) {
    case 2:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 4:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = function(xs, ys) {
  var xl = cljs.core.count(xs);
  var yl = cljs.core.count(ys);
  if (xl < yl) {
    return -1;
  } else {
    if (xl > yl) {
      return 1;
    } else {
      if (xl === 0) {
        return 0;
      } else {
        return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs, ys, xl, 0);
      }
    }
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = function(xs, ys, len, n) {
  while (true) {
    var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs, n), cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys, n));
    if (d === 0 && n + 1 < len) {
      var G__14845 = xs;
      var G__14846 = ys;
      var G__14847 = len;
      var G__14848 = n + 1;
      xs = G__14845;
      ys = G__14846;
      len = G__14847;
      n = G__14848;
      continue;
    } else {
      return d;
    }
    break;
  }
};
cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
cljs.core.fn__GT_comparator = function cljs$core$fn__GT_comparator(f) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f, cljs.core.compare)) {
    return cljs.core.compare;
  } else {
    return function(x, y) {
      var r = function() {
        var G__14853 = x;
        var G__14854 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14853, G__14854) : f.call(null, G__14853, G__14854);
      }();
      if (typeof r === "number") {
        return r;
      } else {
        if (cljs.core.truth_(r)) {
          return -1;
        } else {
          if (cljs.core.truth_(function() {
            var G__14855 = y;
            var G__14856 = x;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14855, G__14856) : f.call(null, G__14855, G__14856);
          }())) {
            return 1;
          } else {
            return 0;
          }
        }
      }
    };
  }
};
cljs.core.sort = function cljs$core$sort() {
  var G__14858 = arguments.length;
  switch(G__14858) {
    case 1:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare, coll);
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = function(comp, coll) {
  if (cljs.core.seq(coll)) {
    var a = function() {
      var G__14859 = coll;
      return cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__14859) : cljs.core.to_array.call(null, G__14859);
    }();
    var G__14860_14863 = a;
    var G__14861_14864 = cljs.core.fn__GT_comparator(comp);
    goog.array.stableSort(G__14860_14863, G__14861_14864);
    return cljs.core.seq(a);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sort.cljs$lang$maxFixedArity = 2;
cljs.core.sort_by = function cljs$core$sort_by() {
  var G__14866 = arguments.length;
  switch(G__14866) {
    case 2:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = function(keyfn, coll) {
  return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn, cljs.core.compare, coll);
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = function(keyfn, comp, coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x, y) {
    return cljs.core.fn__GT_comparator(comp).call(null, function() {
      var G__14867 = x;
      return keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__14867) : keyfn.call(null, G__14867);
    }(), function() {
      var G__14868 = y;
      return keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__14868) : keyfn.call(null, G__14868);
    }());
  }, coll);
};
cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = function cljs$core$seq_reduce() {
  var G__14871 = arguments.length;
  switch(G__14871) {
    case 2:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var temp__4423__auto__ = cljs.core.seq(coll);
  if (temp__4423__auto__) {
    var s = temp__4423__auto__;
    var G__14872 = f;
    var G__14873 = cljs.core.first(s);
    var G__14874 = cljs.core.next(s);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__14872, G__14873, G__14874) : cljs.core.reduce.call(null, G__14872, G__14873, G__14874);
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  var val__$1 = val;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (coll__$1) {
      var nval = function() {
        var G__14875 = val__$1;
        var G__14876 = cljs.core.first(coll__$1);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14875, G__14876) : f.call(null, G__14875, G__14876);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__14878 = nval;
        var G__14879 = cljs.core.next(coll__$1);
        val__$1 = G__14878;
        coll__$1 = G__14879;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.shuffle = function cljs$core$shuffle(coll) {
  var a = function() {
    var G__14883 = coll;
    return cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__14883) : cljs.core.to_array.call(null, G__14883);
  }();
  var G__14884_14886 = a;
  goog.array.shuffle(G__14884_14886);
  var G__14885 = a;
  return cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__14885) : cljs.core.vec.call(null, G__14885);
};
cljs.core.reduce = function cljs$core$reduce() {
  var G__14888 = arguments.length;
  switch(G__14888) {
    case 2:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  if (function() {
    var G__14889 = coll;
    if (G__14889) {
      var bit__4976__auto__ = G__14889.cljs$lang$protocol_mask$partition0$ & 524288;
      if (bit__4976__auto__ || G__14889.cljs$core$IReduce$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  if (function() {
    var G__14890 = coll;
    if (G__14890) {
      var bit__4976__auto__ = G__14890.cljs$lang$protocol_mask$partition0$ & 524288;
      if (bit__4976__auto__ || G__14890.cljs$core$IReduce$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$3(null, f, val);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, val, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce_kv = function cljs$core$reduce_kv(f, init, coll) {
  if (!(coll == null)) {
    return cljs.core._kv_reduce(coll, f, init);
  } else {
    return init;
  }
};
cljs.core.identity = function cljs$core$identity(x) {
  return x;
};
cljs.core.completing = function cljs$core$completing() {
  var G__14893 = arguments.length;
  switch(G__14893) {
    case 1:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f, cljs.core.identity);
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = function(f, cf) {
  return function() {
    var G__14898 = null;
    var G__14898__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    };
    var G__14898__1 = function(x) {
      var G__14894 = x;
      return cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__14894) : cf.call(null, G__14894);
    };
    var G__14898__2 = function(x, y) {
      var G__14895 = x;
      var G__14896 = y;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14895, G__14896) : f.call(null, G__14895, G__14896);
    };
    G__14898 = function(x, y) {
      switch(arguments.length) {
        case 0:
          return G__14898__0.call(this);
        case 1:
          return G__14898__1.call(this, x);
        case 2:
          return G__14898__2.call(this, x, y);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__14898.cljs$core$IFn$_invoke$arity$0 = G__14898__0;
    G__14898.cljs$core$IFn$_invoke$arity$1 = G__14898__1;
    G__14898.cljs$core$IFn$_invoke$arity$2 = G__14898__2;
    return G__14898;
  }();
};
cljs.core.completing.cljs$lang$maxFixedArity = 2;
cljs.core.transduce = function cljs$core$transduce() {
  var G__14900 = arguments.length;
  switch(G__14900) {
    case 3:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = function(xform, f, coll) {
  return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, f, function() {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }(), coll);
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = function(xform, f, init, coll) {
  var f__$1 = function() {
    var G__14901 = f;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__14901) : xform.call(null, G__14901);
  }();
  var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1, init, coll);
  var G__14902 = ret;
  return f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__14902) : f__$1.call(null, G__14902);
};
cljs.core.transduce.cljs$lang$maxFixedArity = 4;
cljs.core._PLUS_ = function cljs$core$_PLUS_() {
  var G__14908 = arguments.length;
  switch(G__14908) {
    case 0:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_, x + y, more);
};
cljs.core._PLUS_.cljs$lang$applyTo = function(seq14904) {
  var G__14905 = cljs.core.first(seq14904);
  var seq14904__$1 = cljs.core.next(seq14904);
  var G__14906 = cljs.core.first(seq14904__$1);
  var seq14904__$2 = cljs.core.next(seq14904__$1);
  return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__14905, G__14906, seq14904__$2);
};
cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
cljs.core._ = function cljs$core$_() {
  var G__14914 = arguments.length;
  switch(G__14914) {
    case 1:
      return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core._.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._, x - y, more);
};
cljs.core._.cljs$lang$applyTo = function(seq14910) {
  var G__14911 = cljs.core.first(seq14910);
  var seq14910__$1 = cljs.core.next(seq14910);
  var G__14912 = cljs.core.first(seq14910__$1);
  var seq14910__$2 = cljs.core.next(seq14910__$1);
  return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__14911, G__14912, seq14910__$2);
};
cljs.core._.cljs$lang$maxFixedArity = 2;
cljs.core._STAR_ = function cljs$core$_STAR_() {
  var G__14920 = arguments.length;
  switch(G__14920) {
    case 0:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_, x * y, more);
};
cljs.core._STAR_.cljs$lang$applyTo = function(seq14916) {
  var G__14917 = cljs.core.first(seq14916);
  var seq14916__$1 = cljs.core.next(seq14916);
  var G__14918 = cljs.core.first(seq14916__$1);
  var seq14916__$2 = cljs.core.next(seq14916__$1);
  return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__14917, G__14918, seq14916__$2);
};
cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
cljs.core._SLASH_ = function cljs$core$_SLASH_() {
  var G__14926 = arguments.length;
  switch(G__14926) {
    case 1:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_, x / y, more);
};
cljs.core._SLASH_.cljs$lang$applyTo = function(seq14922) {
  var G__14923 = cljs.core.first(seq14922);
  var seq14922__$1 = cljs.core.next(seq14922);
  var G__14924 = cljs.core.first(seq14922__$1);
  var seq14922__$2 = cljs.core.next(seq14922__$1);
  return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__14923, G__14924, seq14922__$2);
};
cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
cljs.core._LT_ = function cljs$core$_LT_() {
  var G__14932 = arguments.length;
  switch(G__14932) {
    case 1:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x < y;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x < y) {
      if (cljs.core.next(more)) {
        var G__14934 = y;
        var G__14935 = cljs.core.first(more);
        var G__14936 = cljs.core.next(more);
        x = G__14934;
        y = G__14935;
        more = G__14936;
        continue;
      } else {
        return y < cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT_.cljs$lang$applyTo = function(seq14928) {
  var G__14929 = cljs.core.first(seq14928);
  var seq14928__$1 = cljs.core.next(seq14928);
  var G__14930 = cljs.core.first(seq14928__$1);
  var seq14928__$2 = cljs.core.next(seq14928__$1);
  return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__14929, G__14930, seq14928__$2);
};
cljs.core._LT_.cljs$lang$maxFixedArity = 2;
cljs.core._LT__EQ_ = function cljs$core$_LT__EQ_() {
  var G__14941 = arguments.length;
  switch(G__14941) {
    case 1:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x <= y;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x <= y) {
      if (cljs.core.next(more)) {
        var G__14943 = y;
        var G__14944 = cljs.core.first(more);
        var G__14945 = cljs.core.next(more);
        x = G__14943;
        y = G__14944;
        more = G__14945;
        continue;
      } else {
        return y <= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT__EQ_.cljs$lang$applyTo = function(seq14937) {
  var G__14938 = cljs.core.first(seq14937);
  var seq14937__$1 = cljs.core.next(seq14937);
  var G__14939 = cljs.core.first(seq14937__$1);
  var seq14937__$2 = cljs.core.next(seq14937__$1);
  return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__14938, G__14939, seq14937__$2);
};
cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core._GT_ = function cljs$core$_GT_() {
  var G__14950 = arguments.length;
  switch(G__14950) {
    case 1:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x > y;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x > y) {
      if (cljs.core.next(more)) {
        var G__14952 = y;
        var G__14953 = cljs.core.first(more);
        var G__14954 = cljs.core.next(more);
        x = G__14952;
        y = G__14953;
        more = G__14954;
        continue;
      } else {
        return y > cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT_.cljs$lang$applyTo = function(seq14946) {
  var G__14947 = cljs.core.first(seq14946);
  var seq14946__$1 = cljs.core.next(seq14946);
  var G__14948 = cljs.core.first(seq14946__$1);
  var seq14946__$2 = cljs.core.next(seq14946__$1);
  return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__14947, G__14948, seq14946__$2);
};
cljs.core._GT_.cljs$lang$maxFixedArity = 2;
cljs.core._GT__EQ_ = function cljs$core$_GT__EQ_() {
  var G__14959 = arguments.length;
  switch(G__14959) {
    case 1:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x >= y;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x >= y) {
      if (cljs.core.next(more)) {
        var G__14961 = y;
        var G__14962 = cljs.core.first(more);
        var G__14963 = cljs.core.next(more);
        x = G__14961;
        y = G__14962;
        more = G__14963;
        continue;
      } else {
        return y >= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT__EQ_.cljs$lang$applyTo = function(seq14955) {
  var G__14956 = cljs.core.first(seq14955);
  var seq14955__$1 = cljs.core.next(seq14955);
  var G__14957 = cljs.core.first(seq14955__$1);
  var seq14955__$2 = cljs.core.next(seq14955__$1);
  return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__14956, G__14957, seq14955__$2);
};
cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.dec = function cljs$core$dec(x) {
  return x - 1;
};
cljs.core.max = function cljs$core$max() {
  var G__14968 = arguments.length;
  switch(G__14968) {
    case 1:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.max.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4621__auto__ = x;
  var y__4622__auto__ = y;
  return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max, function() {
    var x__4621__auto__ = x;
    var y__4622__auto__ = y;
    return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
  }(), more);
};
cljs.core.max.cljs$lang$applyTo = function(seq14964) {
  var G__14965 = cljs.core.first(seq14964);
  var seq14964__$1 = cljs.core.next(seq14964);
  var G__14966 = cljs.core.first(seq14964__$1);
  var seq14964__$2 = cljs.core.next(seq14964__$1);
  return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__14965, G__14966, seq14964__$2);
};
cljs.core.max.cljs$lang$maxFixedArity = 2;
cljs.core.min = function cljs$core$min() {
  var G__14974 = arguments.length;
  switch(G__14974) {
    case 1:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.min.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4628__auto__ = x;
  var y__4629__auto__ = y;
  return x__4628__auto__ < y__4629__auto__ ? x__4628__auto__ : y__4629__auto__;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min, function() {
    var x__4628__auto__ = x;
    var y__4629__auto__ = y;
    return x__4628__auto__ < y__4629__auto__ ? x__4628__auto__ : y__4629__auto__;
  }(), more);
};
cljs.core.min.cljs$lang$applyTo = function(seq14970) {
  var G__14971 = cljs.core.first(seq14970);
  var seq14970__$1 = cljs.core.next(seq14970);
  var G__14972 = cljs.core.first(seq14970__$1);
  var seq14970__$2 = cljs.core.next(seq14970__$1);
  return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__14971, G__14972, seq14970__$2);
};
cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = function cljs$core$byte(x) {
  return x;
};
cljs.core.char$ = function cljs$core$char(x) {
  if (typeof x === "number") {
    return String.fromCharCode(x);
  } else {
    if (typeof x === "string" && x.length === 1) {
      return x;
    } else {
      throw new Error("Argument to char must be a character or number");
    }
  }
};
cljs.core.short$ = function cljs$core$short(x) {
  return x;
};
cljs.core.float$ = function cljs$core$float(x) {
  return x;
};
cljs.core.double$ = function cljs$core$double(x) {
  return x;
};
cljs.core.unchecked_byte = function cljs$core$unchecked_byte(x) {
  return x;
};
cljs.core.unchecked_char = function cljs$core$unchecked_char(x) {
  return x;
};
cljs.core.unchecked_short = function cljs$core$unchecked_short(x) {
  return x;
};
cljs.core.unchecked_float = function cljs$core$unchecked_float(x) {
  return x;
};
cljs.core.unchecked_double = function cljs$core$unchecked_double(x) {
  return x;
};
cljs.core.unchecked_add = function cljs$core$unchecked_add() {
  var G__14980 = arguments.length;
  switch(G__14980) {
    case 0:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add, x + y, more);
};
cljs.core.unchecked_add.cljs$lang$applyTo = function(seq14976) {
  var G__14977 = cljs.core.first(seq14976);
  var seq14976__$1 = cljs.core.next(seq14976);
  var G__14978 = cljs.core.first(seq14976__$1);
  var seq14976__$2 = cljs.core.next(seq14976__$1);
  return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__14977, G__14978, seq14976__$2);
};
cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_add_int = function cljs$core$unchecked_add_int() {
  var G__14986 = arguments.length;
  switch(G__14986) {
    case 0:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int, x + y, more);
};
cljs.core.unchecked_add_int.cljs$lang$applyTo = function(seq14982) {
  var G__14983 = cljs.core.first(seq14982);
  var seq14982__$1 = cljs.core.next(seq14982);
  var G__14984 = cljs.core.first(seq14982__$1);
  var seq14982__$2 = cljs.core.next(seq14982__$1);
  return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__14983, G__14984, seq14982__$2);
};
cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_dec = function cljs$core$unchecked_dec(x) {
  return x - 1;
};
cljs.core.unchecked_dec_int = function cljs$core$unchecked_dec_int(x) {
  return x - 1;
};
cljs.core.unchecked_divide_int = function cljs$core$unchecked_divide_int() {
  var G__14992 = arguments.length;
  switch(G__14992) {
    case 1:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int, x / y, more);
};
cljs.core.unchecked_divide_int.cljs$lang$applyTo = function(seq14988) {
  var G__14989 = cljs.core.first(seq14988);
  var seq14988__$1 = cljs.core.next(seq14988);
  var G__14990 = cljs.core.first(seq14988__$1);
  var seq14988__$2 = cljs.core.next(seq14988__$1);
  return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__14989, G__14990, seq14988__$2);
};
cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = function cljs$core$unchecked_inc(x) {
  return x + 1;
};
cljs.core.unchecked_inc_int = function cljs$core$unchecked_inc_int(x) {
  return x + 1;
};
cljs.core.unchecked_multiply = function cljs$core$unchecked_multiply() {
  var G__14998 = arguments.length;
  switch(G__14998) {
    case 0:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply, x * y, more);
};
cljs.core.unchecked_multiply.cljs$lang$applyTo = function(seq14994) {
  var G__14995 = cljs.core.first(seq14994);
  var seq14994__$1 = cljs.core.next(seq14994);
  var G__14996 = cljs.core.first(seq14994__$1);
  var seq14994__$2 = cljs.core.next(seq14994__$1);
  return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__14995, G__14996, seq14994__$2);
};
cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_multiply_int = function cljs$core$unchecked_multiply_int() {
  var G__15004 = arguments.length;
  switch(G__15004) {
    case 0:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int, x * y, more);
};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = function(seq15000) {
  var G__15001 = cljs.core.first(seq15000);
  var seq15000__$1 = cljs.core.next(seq15000);
  var G__15002 = cljs.core.first(seq15000__$1);
  var seq15000__$2 = cljs.core.next(seq15000__$1);
  return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__15001, G__15002, seq15000__$2);
};
cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = function cljs$core$unchecked_negate(x) {
  return -x;
};
cljs.core.unchecked_negate_int = function cljs$core$unchecked_negate_int(x) {
  return -x;
};
cljs.core.unchecked_remainder_int = function cljs$core$unchecked_remainder_int(x, n) {
  var G__15008 = x;
  var G__15009 = n;
  return cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__15008, G__15009) : cljs.core.mod.call(null, G__15008, G__15009);
};
cljs.core.unchecked_subtract = function cljs$core$unchecked_subtract() {
  var G__15014 = arguments.length;
  switch(G__15014) {
    case 1:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract, x - y, more);
};
cljs.core.unchecked_subtract.cljs$lang$applyTo = function(seq15010) {
  var G__15011 = cljs.core.first(seq15010);
  var seq15010__$1 = cljs.core.next(seq15010);
  var G__15012 = cljs.core.first(seq15010__$1);
  var seq15010__$2 = cljs.core.next(seq15010__$1);
  return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__15011, G__15012, seq15010__$2);
};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_subtract_int = function cljs$core$unchecked_subtract_int() {
  var G__15020 = arguments.length;
  switch(G__15020) {
    case 1:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int, x - y, more);
};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = function(seq15016) {
  var G__15017 = cljs.core.first(seq15016);
  var seq15016__$1 = cljs.core.next(seq15016);
  var G__15018 = cljs.core.first(seq15016__$1);
  var seq15016__$2 = cljs.core.next(seq15016__$1);
  return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__15017, G__15018, seq15016__$2);
};
cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = function cljs$core$fix(q) {
  if (q >= 0) {
    var G__15024 = q;
    return Math.floor(G__15024);
  } else {
    var G__15025 = q;
    return Math.ceil(G__15025);
  }
};
cljs.core.int$ = function cljs$core$int(x) {
  return x | 0;
};
cljs.core.unchecked_int = function cljs$core$unchecked_int(x) {
  return cljs.core.fix(x);
};
cljs.core.long$ = function cljs$core$long(x) {
  return cljs.core.fix(x);
};
cljs.core.unchecked_long = function cljs$core$unchecked_long(x) {
  return cljs.core.fix(x);
};
cljs.core.booleans = function cljs$core$booleans(x) {
  return x;
};
cljs.core.bytes = function cljs$core$bytes(x) {
  return x;
};
cljs.core.chars = function cljs$core$chars(x) {
  return x;
};
cljs.core.shorts = function cljs$core$shorts(x) {
  return x;
};
cljs.core.ints = function cljs$core$ints(x) {
  return x;
};
cljs.core.floats = function cljs$core$floats(x) {
  return x;
};
cljs.core.doubles = function cljs$core$doubles(x) {
  return x;
};
cljs.core.longs = function cljs$core$longs(x) {
  return x;
};
cljs.core.js_mod = function cljs$core$js_mod(n, d) {
  return n % d;
};
cljs.core.mod = function cljs$core$mod(n, d) {
  return (n % d + d) % d;
};
cljs.core.quot = function cljs$core$quot(n, d) {
  var rem = n % d;
  return cljs.core.fix((n - rem) / d);
};
cljs.core.rem = function cljs$core$rem(n, d) {
  var q = cljs.core.quot(n, d);
  return n - d * q;
};
cljs.core.bit_xor = function cljs$core$bit_xor() {
  var G__15030 = arguments.length;
  switch(G__15030) {
    case 2:
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x ^ y;
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor, x ^ y, more);
};
cljs.core.bit_xor.cljs$lang$applyTo = function(seq15026) {
  var G__15027 = cljs.core.first(seq15026);
  var seq15026__$1 = cljs.core.next(seq15026);
  var G__15028 = cljs.core.first(seq15026__$1);
  var seq15026__$2 = cljs.core.next(seq15026__$1);
  return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__15027, G__15028, seq15026__$2);
};
cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and = function cljs$core$bit_and() {
  var G__15036 = arguments.length;
  switch(G__15036) {
    case 2:
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & y;
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and, x & y, more);
};
cljs.core.bit_and.cljs$lang$applyTo = function(seq15032) {
  var G__15033 = cljs.core.first(seq15032);
  var seq15032__$1 = cljs.core.next(seq15032);
  var G__15034 = cljs.core.first(seq15032__$1);
  var seq15032__$2 = cljs.core.next(seq15032__$1);
  return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__15033, G__15034, seq15032__$2);
};
cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
cljs.core.bit_or = function cljs$core$bit_or() {
  var G__15042 = arguments.length;
  switch(G__15042) {
    case 2:
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x | y;
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or, x | y, more);
};
cljs.core.bit_or.cljs$lang$applyTo = function(seq15038) {
  var G__15039 = cljs.core.first(seq15038);
  var seq15038__$1 = cljs.core.next(seq15038);
  var G__15040 = cljs.core.first(seq15038__$1);
  var seq15038__$2 = cljs.core.next(seq15038__$1);
  return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__15039, G__15040, seq15038__$2);
};
cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and_not = function cljs$core$bit_and_not() {
  var G__15048 = arguments.length;
  switch(G__15048) {
    case 2:
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & ~y;
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not, x & ~y, more);
};
cljs.core.bit_and_not.cljs$lang$applyTo = function(seq15044) {
  var G__15045 = cljs.core.first(seq15044);
  var seq15044__$1 = cljs.core.next(seq15044);
  var G__15046 = cljs.core.first(seq15044__$1);
  var seq15044__$2 = cljs.core.next(seq15044__$1);
  return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__15045, G__15046, seq15044__$2);
};
cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
cljs.core.bit_clear = function cljs$core$bit_clear(x, n) {
  return x & ~(1 << n);
};
cljs.core.bit_flip = function cljs$core$bit_flip(x, n) {
  return x ^ 1 << n;
};
cljs.core.bit_not = function cljs$core$bit_not(x) {
  return ~x;
};
cljs.core.bit_set = function cljs$core$bit_set(x, n) {
  return x | 1 << n;
};
cljs.core.bit_test = function cljs$core$bit_test(x, n) {
  return (x & 1 << n) != 0;
};
cljs.core.bit_shift_left = function cljs$core$bit_shift_left(x, n) {
  return x << n;
};
cljs.core.bit_shift_right = function cljs$core$bit_shift_right(x, n) {
  return x >> n;
};
cljs.core.bit_shift_right_zero_fill = function cljs$core$bit_shift_right_zero_fill(x, n) {
  return x >>> n;
};
cljs.core.unsigned_bit_shift_right = function cljs$core$unsigned_bit_shift_right(x, n) {
  return x >>> n;
};
cljs.core.bit_count = function cljs$core$bit_count(v) {
  var v__$1 = v - (v >> 1 & 1431655765);
  var v__$2 = (v__$1 & 858993459) + (v__$1 >> 2 & 858993459);
  return (v__$2 + (v__$2 >> 4) & 252645135) * 16843009 >> 24;
};
cljs.core._EQ__EQ_ = function cljs$core$_EQ__EQ_() {
  var G__15054 = arguments.length;
  switch(G__15054) {
    case 1:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return cljs.core._equiv(x, y);
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x === y) {
      if (cljs.core.next(more)) {
        var G__15056 = y;
        var G__15057 = cljs.core.first(more);
        var G__15058 = cljs.core.next(more);
        x = G__15056;
        y = G__15057;
        more = G__15058;
        continue;
      } else {
        return y === cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ__EQ_.cljs$lang$applyTo = function(seq15050) {
  var G__15051 = cljs.core.first(seq15050);
  var seq15050__$1 = cljs.core.next(seq15050);
  var G__15052 = cljs.core.first(seq15050__$1);
  var seq15050__$2 = cljs.core.next(seq15050__$1);
  return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__15051, G__15052, seq15050__$2);
};
cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.pos_QMARK_ = function cljs$core$pos_QMARK_(n) {
  return n > 0;
};
cljs.core.zero_QMARK_ = function cljs$core$zero_QMARK_(n) {
  return n === 0;
};
cljs.core.neg_QMARK_ = function cljs$core$neg_QMARK_(x) {
  return x < 0;
};
cljs.core.nthnext = function cljs$core$nthnext(coll, n) {
  var n__$1 = n;
  var xs = cljs.core.seq(coll);
  while (true) {
    if (xs && n__$1 > 0) {
      var G__15059 = n__$1 - 1;
      var G__15060 = cljs.core.next(xs);
      n__$1 = G__15059;
      xs = G__15060;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.str = function cljs$core$str() {
  var G__15064 = arguments.length;
  switch(G__15064) {
    case 0:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5360__auto__);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$0 = function() {
  return "";
};
cljs.core.str.cljs$core$IFn$_invoke$arity$1 = function(x) {
  if (x == null) {
    return "";
  } else {
    var G__15065 = x;
    return goog.string.buildString(G__15065);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = function(x, ys) {
  var sb = new goog.string.StringBuffer([cljs.core.str(x)].join(""));
  var more = ys;
  while (true) {
    if (cljs.core.truth_(more)) {
      var G__15067 = sb.append([cljs.core.str(cljs.core.first(more))].join(""));
      var G__15068 = cljs.core.next(more);
      sb = G__15067;
      more = G__15068;
      continue;
    } else {
      return sb.toString();
    }
    break;
  }
};
cljs.core.str.cljs$lang$applyTo = function(seq15061) {
  var G__15062 = cljs.core.first(seq15061);
  var seq15061__$1 = cljs.core.next(seq15061);
  return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__15062, seq15061__$1);
};
cljs.core.str.cljs$lang$maxFixedArity = 1;
cljs.core.subs = function cljs$core$subs() {
  var G__15070 = arguments.length;
  switch(G__15070) {
    case 2:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = function(s, start) {
  return s.substring(start);
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = function(s, start, end) {
  return s.substring(start, end);
};
cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.equiv_sequential = function cljs$core$equiv_sequential(x, y) {
  return cljs.core.boolean$(cljs.core.sequential_QMARK_(y) ? cljs.core.counted_QMARK_(x) && cljs.core.counted_QMARK_(y) && !(cljs.core.count(x) === cljs.core.count(y)) ? false : function() {
    var xs = cljs.core.seq(x);
    var ys = cljs.core.seq(y);
    while (true) {
      if (xs == null) {
        return ys == null;
      } else {
        if (ys == null) {
          return false;
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs), cljs.core.first(ys))) {
            var G__15072 = cljs.core.next(xs);
            var G__15073 = cljs.core.next(ys);
            xs = G__15072;
            ys = G__15073;
            continue;
          } else {
            return false;
          }
        }
      }
      break;
    }
  }() : null);
};
cljs.core.hash_coll = function cljs$core$hash_coll(coll) {
  if (cljs.core.seq(coll)) {
    var res = cljs.core.hash(cljs.core.first(coll));
    var s = cljs.core.next(coll);
    while (true) {
      if (s == null) {
        return res;
      } else {
        var G__15074 = cljs.core.hash_combine(res, cljs.core.hash(cljs.core.first(s)));
        var G__15075 = cljs.core.next(s);
        res = G__15074;
        s = G__15075;
        continue;
      }
      break;
    }
  } else {
    return 0;
  }
};
cljs.core.hash_imap = function cljs$core$hash_imap(m) {
  var h = 0;
  var s = cljs.core.seq(m);
  while (true) {
    if (s) {
      var e = cljs.core.first(s);
      var G__15080 = (h + (cljs.core.hash(function() {
        var G__15078 = e;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__15078) : cljs.core.key.call(null, G__15078);
      }()) ^ cljs.core.hash(function() {
        var G__15079 = e;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__15079) : cljs.core.val.call(null, G__15079);
      }()))) % 4503599627370496;
      var G__15081 = cljs.core.next(s);
      h = G__15080;
      s = G__15081;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.hash_iset = function cljs$core$hash_iset(s) {
  var h = 0;
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (s__$1) {
      var e = cljs.core.first(s__$1);
      var G__15082 = (h + cljs.core.hash(e)) % 4503599627370496;
      var G__15083 = cljs.core.next(s__$1);
      h = G__15082;
      s__$1 = G__15083;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.extend_object_BANG_ = function cljs$core$extend_object_BANG_(obj, fn_map) {
  var seq__15094_15104 = cljs.core.seq(fn_map);
  var chunk__15095_15105 = null;
  var count__15096_15106 = 0;
  var i__15097_15107 = 0;
  while (true) {
    if (i__15097_15107 < count__15096_15106) {
      var vec__15098_15108 = chunk__15095_15105.cljs$core$IIndexed$_nth$arity$2(null, i__15097_15107);
      var key_name_15109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15098_15108, 0, null);
      var f_15110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15098_15108, 1, null);
      var str_name_15111 = function() {
        var G__15099 = key_name_15109;
        return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__15099) : cljs.core.name.call(null, G__15099);
      }();
      obj[str_name_15111] = f_15110;
      var G__15112 = seq__15094_15104;
      var G__15113 = chunk__15095_15105;
      var G__15114 = count__15096_15106;
      var G__15115 = i__15097_15107 + 1;
      seq__15094_15104 = G__15112;
      chunk__15095_15105 = G__15113;
      count__15096_15106 = G__15114;
      i__15097_15107 = G__15115;
      continue;
    } else {
      var temp__4425__auto___15116 = cljs.core.seq(seq__15094_15104);
      if (temp__4425__auto___15116) {
        var seq__15094_15117__$1 = temp__4425__auto___15116;
        if (cljs.core.chunked_seq_QMARK_(seq__15094_15117__$1)) {
          var c__5094__auto___15118 = function() {
            var G__15100 = seq__15094_15117__$1;
            return cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__15100) : cljs.core.chunk_first.call(null, G__15100);
          }();
          var G__15119 = function() {
            var G__15101 = seq__15094_15117__$1;
            return cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__15101) : cljs.core.chunk_rest.call(null, G__15101);
          }();
          var G__15120 = c__5094__auto___15118;
          var G__15121 = cljs.core.count(c__5094__auto___15118);
          var G__15122 = 0;
          seq__15094_15104 = G__15119;
          chunk__15095_15105 = G__15120;
          count__15096_15106 = G__15121;
          i__15097_15107 = G__15122;
          continue;
        } else {
          var vec__15102_15123 = cljs.core.first(seq__15094_15117__$1);
          var key_name_15124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15102_15123, 0, null);
          var f_15125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15102_15123, 1, null);
          var str_name_15126 = function() {
            var G__15103 = key_name_15124;
            return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__15103) : cljs.core.name.call(null, G__15103);
          }();
          obj[str_name_15126] = f_15125;
          var G__15127 = cljs.core.next(seq__15094_15117__$1);
          var G__15128 = null;
          var G__15129 = 0;
          var G__15130 = 0;
          seq__15094_15104 = G__15127;
          chunk__15095_15105 = G__15128;
          count__15096_15106 = G__15129;
          i__15097_15107 = G__15130;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return obj;
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65937646;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.List.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.List.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return null;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._rest(coll__$1);
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);
};
cljs.core.List.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";
cljs.core.List.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/List");
};
cljs.core.__GT_List = function cljs$core$__GT_List(meta, first, rest, count, __hash) {
  return new cljs.core.List(meta, first, rest, count, __hash);
};
cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 65937614;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.EmptyList.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.EmptyList.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.EmptyList(self__.meta);
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return 0;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.empty_ordered_hash;
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.EmptyList(meta__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, null, 1, null);
};
cljs.core.EmptyList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/EmptyList");
};
cljs.core.__GT_EmptyList = function cljs$core$__GT_EmptyList(meta) {
  return new cljs.core.EmptyList(meta);
};
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.reversible_QMARK_ = function cljs$core$reversible_QMARK_(coll) {
  var G__15132 = coll;
  if (G__15132) {
    var bit__4983__auto__ = G__15132.cljs$lang$protocol_mask$partition0$ & 134217728;
    if (bit__4983__auto__ || G__15132.cljs$core$IReversible$) {
      return true;
    } else {
      if (!G__15132.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, G__15132);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, G__15132);
  }
};
cljs.core.rseq = function cljs$core$rseq(coll) {
  return cljs.core._rseq(coll);
};
cljs.core.reverse = function cljs$core$reverse(coll) {
  if (cljs.core.reversible_QMARK_(coll)) {
    return cljs.core.rseq(coll);
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, coll);
  }
};
cljs.core.list = function cljs$core$list() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = function(xs) {
  var arr = xs instanceof cljs.core.IndexedSeq && xs.i === 0 ? xs.arr : function() {
    var arr = [];
    var xs__$1 = xs;
    while (true) {
      if (!(xs__$1 == null)) {
        arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));
        var G__15134 = xs__$1.cljs$core$INext$_next$arity$1(null);
        xs__$1 = G__15134;
        continue;
      } else {
        return arr;
      }
      break;
    }
  }();
  var i = arr.length;
  var r = cljs.core.List.EMPTY;
  while (true) {
    if (i > 0) {
      var G__15135 = i - 1;
      var G__15136 = r.cljs$core$ICollection$_conj$arity$2(null, arr[i - 1]);
      i = G__15135;
      r = G__15136;
      continue;
    } else {
      return r;
    }
    break;
  }
};
cljs.core.list.cljs$lang$maxFixedArity = 0;
cljs.core.list.cljs$lang$applyTo = function(seq15133) {
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq15133));
};
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65929452;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Cons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core.seq(self__.rest);
  }
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(null, o, coll__$1, self__.__hash);
};
cljs.core.Cons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";
cljs.core.Cons.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Cons");
};
cljs.core.__GT_Cons = function cljs$core$__GT_Cons(meta, first, rest, __hash) {
  return new cljs.core.Cons(meta, first, rest, __hash);
};
cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.cons = function cljs$core$cons(x, coll) {
  if (function() {
    var or__4309__auto__ = coll == null;
    if (or__4309__auto__) {
      return or__4309__auto__;
    } else {
      var G__15140 = coll;
      if (G__15140) {
        var bit__4976__auto__ = G__15140.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4976__auto__ || G__15140.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null);
  } else {
    return new cljs.core.Cons(null, x, cljs.core.seq(coll), null);
  }
};
cljs.core.list_QMARK_ = function cljs$core$list_QMARK_(x) {
  var G__15142 = x;
  if (G__15142) {
    var bit__4983__auto__ = G__15142.cljs$lang$protocol_mask$partition0$ & 33554432;
    if (bit__4983__auto__ || G__15142.cljs$core$IList$) {
      return true;
    } else {
      if (!G__15142.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IList, G__15142);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IList, G__15142);
  }
};
cljs.core.hash_keyword = function cljs$core$hash_keyword(k) {
  return cljs.core.hash_symbol(k) + 2654435769 | 0;
};
cljs.core.compare_keywords = function cljs$core$compare_keywords(a, b) {
  if (a.fqn === b.fqn) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = cljs.core.not(a.ns);
      if (and__4297__auto__) {
        return b.ns;
      } else {
        return and__4297__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__15149 = a.ns;
            var G__15150 = b.ns;
            return goog.array.defaultCompare(G__15149, G__15150);
          }();
          if (0 === nsc) {
            var G__15151 = a.name;
            var G__15152 = b.name;
            return goog.array.defaultCompare(G__15151, G__15152);
          } else {
            return nsc;
          }
        }
      } else {
        var G__15153 = a.name;
        var G__15154 = b.name;
        return goog.array.defaultCompare(G__15153, G__15154);
      }
    }
  }
};
cljs.core.Keyword = function(ns, name, fqn, _hash) {
  this.ns = ns;
  this.name = name;
  this.fqn = fqn;
  this._hash = _hash;
  this.cljs$lang$protocol_mask$partition0$ = 2153775105;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Keyword.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str(":"), cljs.core.str(self__.fqn)].join("");
};
cljs.core.Keyword.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Keyword) {
    return self__.fqn === other.fqn;
  } else {
    return false;
  }
};
cljs.core.Keyword.prototype.call = function() {
  var G__15156 = null;
  var G__15156__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
  };
  var G__15156__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
  };
  G__15156 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__15156__2.call(this, self__, coll);
      case 3:
        return G__15156__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__15156.cljs$core$IFn$_invoke$arity$2 = G__15156__2;
  G__15156.cljs$core$IFn$_invoke$arity$3 = G__15156__3;
  return G__15156;
}();
cljs.core.Keyword.prototype.apply = function(self__, args15155) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args15155)));
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var h__4725__auto__ = self__._hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_keyword(this$__$1);
    self__._hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, [cljs.core.str(":"), cljs.core.str(self__.fqn)].join(""));
};
cljs.core.Keyword.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "fqn", "fqn", -1749334463, null), new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null)], null);
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";
cljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Keyword");
};
cljs.core.__GT_Keyword = function cljs$core$__GT_Keyword(ns, name, fqn, _hash) {
  return new cljs.core.Keyword(ns, name, fqn, _hash);
};
cljs.core.keyword_QMARK_ = function cljs$core$keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword;
};
cljs.core.keyword_identical_QMARK_ = function cljs$core$keyword_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Keyword && y instanceof cljs.core.Keyword) {
      return x.fqn === y.fqn;
    } else {
      return false;
    }
  }
};
cljs.core.namespace = function cljs$core$namespace(x) {
  if (function() {
    var G__15158 = x;
    if (G__15158) {
      var bit__4976__auto__ = G__15158.cljs$lang$protocol_mask$partition1$ & 4096;
      if (bit__4976__auto__ || G__15158.cljs$core$INamed$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return x.cljs$core$INamed$_namespace$arity$1(null);
  } else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.keyword = function cljs$core$keyword() {
  var G__15160 = arguments.length;
  switch(G__15160) {
    case 1:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Keyword) {
    return name;
  } else {
    if (name instanceof cljs.core.Symbol) {
      return new cljs.core.Keyword(cljs.core.namespace(name), function() {
        var G__15161 = name;
        return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__15161) : cljs.core.name.call(null, G__15161);
      }(), name.str, null);
    } else {
      if (typeof name === "string") {
        var parts = name.split("/");
        if (parts.length === 2) {
          return new cljs.core.Keyword(parts[0], parts[1], name, null);
        } else {
          return new cljs.core.Keyword(null, parts[0], name, null);
        }
      } else {
        return null;
      }
    }
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  return new cljs.core.Keyword(ns, name, [cljs.core.str(cljs.core.truth_(ns) ? [cljs.core.str(ns), cljs.core.str("/")].join("") : null), cljs.core.str(name)].join(""), null);
};
cljs.core.keyword.cljs$lang$maxFixedArity = 2;
cljs.core.LazySeq = function(meta, fn, s, __hash) {
  this.meta = meta;
  this.fn = fn;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.LazySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.LazySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.LazySeq.prototype.sval = function() {
  var self__ = this;
  var coll = this;
  if (self__.fn == null) {
    return self__.s;
  } else {
    self__.s = function() {
      return self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null);
    }();
    self__.fn = null;
    return self__.s;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.next(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (!(self__.s == null)) {
    return cljs.core.rest(self__.s);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.sval();
  if (self__.s == null) {
    return null;
  } else {
    var ls = self__.s;
    while (true) {
      if (ls instanceof cljs.core.LazySeq) {
        var G__15163 = ls.sval();
        ls = G__15163;
        continue;
      } else {
        self__.s = ls;
        return cljs.core.seq(self__.s);
      }
      break;
    }
  }
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.LazySeq(meta__$1, self__.fn, self__.s, self__.__hash);
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.LazySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "fn", "fn", 465265323, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";
cljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/LazySeq");
};
cljs.core.__GT_LazySeq = function cljs$core$__GT_LazySeq(meta, fn, s, __hash) {
  return new cljs.core.LazySeq(meta, fn, s, __hash);
};
cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 2;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var self__ = this;
  var _ = this;
  self__.buf[self__.end] = o;
  return self__.end = self__.end + 1;
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);
  self__.buf = null;
  return ret;
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end;
};
cljs.core.ChunkBuffer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "buf", "buf", 1426618187, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";
cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ChunkBuffer");
};
cljs.core.__GT_ChunkBuffer = function cljs$core$__GT_ChunkBuffer(buf, end) {
  return new cljs.core.ChunkBuffer(buf, end);
};
cljs.core.chunk_buffer = function cljs$core$chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(new Array(capacity), 0);
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 524306;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end - self__.off;
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var self__ = this;
  var coll__$1 = this;
  return self__.arr[self__.off + i];
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (i >= 0 && i < self__.end - self__.off) {
    return self__.arr[self__.off + i];
  } else {
    return not_found;
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off === self__.end) {
    throw new Error("-drop-first of empty chunk");
  } else {
    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.off], self__.off + 1);
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.off);
};
cljs.core.ArrayChunk.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayChunk");
};
cljs.core.__GT_ArrayChunk = function cljs$core$__GT_ArrayChunk(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk = function cljs$core$array_chunk() {
  var G__15165 = arguments.length;
  switch(G__15165) {
    case 1:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = function(arr) {
  return new cljs.core.ArrayChunk(arr, 0, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = function(arr, off) {
  return new cljs.core.ArrayChunk(arr, off, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = function(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;
cljs.core.ChunkedCons = function(chunk, more, meta, __hash) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850732;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedCons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedCons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    var more__$1 = cljs.core._seq(self__.more);
    if (more__$1 == null) {
      return null;
    } else {
      return more__$1;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk, 0);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    if (self__.more == null) {
      return cljs.core.List.EMPTY;
    } else {
      return self__.more;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.chunk;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1);
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return null;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "chunk", "chunk", 449371907, null), new cljs.core.Symbol(null, "more", "more", -418290273, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";
cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ChunkedCons");
};
cljs.core.__GT_ChunkedCons = function cljs$core$__GT_ChunkedCons(chunk, more, meta, __hash) {
  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);
};
cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.chunk_cons = function cljs$core$chunk_cons(chunk, rest) {
  if (cljs.core._count(chunk) === 0) {
    return rest;
  } else {
    return new cljs.core.ChunkedCons(chunk, rest, null, null);
  }
};
cljs.core.chunk_append = function cljs$core$chunk_append(b, x) {
  return b.add(x);
};
cljs.core.chunk = function cljs$core$chunk(b) {
  return b.chunk();
};
cljs.core.chunk_first = function cljs$core$chunk_first(s) {
  return cljs.core._chunked_first(s);
};
cljs.core.chunk_rest = function cljs$core$chunk_rest(s) {
  return cljs.core._chunked_rest(s);
};
cljs.core.chunk_next = function cljs$core$chunk_next(s) {
  if (function() {
    var G__15168 = s;
    if (G__15168) {
      var bit__4976__auto__ = G__15168.cljs$lang$protocol_mask$partition1$ & 1024;
      if (bit__4976__auto__ || G__15168.cljs$core$IChunkedNext$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return cljs.core._chunked_next(s);
  } else {
    return cljs.core.seq(cljs.core._chunked_rest(s));
  }
};
cljs.core.to_array = function cljs$core$to_array(s) {
  var ary = [];
  var s__$1 = s;
  while (true) {
    if (cljs.core.seq(s__$1)) {
      ary.push(cljs.core.first(s__$1));
      var G__15169 = cljs.core.next(s__$1);
      s__$1 = G__15169;
      continue;
    } else {
      return ary;
    }
    break;
  }
};
cljs.core.to_array_2d = function cljs$core$to_array_2d(coll) {
  var ret = new Array(cljs.core.count(coll));
  var i_15170 = 0;
  var xs_15171 = cljs.core.seq(coll);
  while (true) {
    if (xs_15171) {
      ret[i_15170] = cljs.core.to_array(cljs.core.first(xs_15171));
      var G__15172 = i_15170 + 1;
      var G__15173 = cljs.core.next(xs_15171);
      i_15170 = G__15172;
      xs_15171 = G__15173;
      continue;
    } else {
    }
    break;
  }
  return ret;
};
cljs.core.int_array = function cljs$core$int_array() {
  var G__15175 = arguments.length;
  switch(G__15175) {
    case 1:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__15177 = i + 1;
        var G__15178 = cljs.core.next(s__$1);
        i = G__15177;
        s__$1 = G__15178;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___15179 = size;
    var i_15180 = 0;
    while (true) {
      if (i_15180 < n__5194__auto___15179) {
        a[i_15180] = init_val_or_seq;
        var G__15181 = i_15180 + 1;
        i_15180 = G__15181;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.int_array.cljs$lang$maxFixedArity = 2;
cljs.core.long_array = function cljs$core$long_array() {
  var G__15183 = arguments.length;
  switch(G__15183) {
    case 1:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__15185 = i + 1;
        var G__15186 = cljs.core.next(s__$1);
        i = G__15185;
        s__$1 = G__15186;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___15187 = size;
    var i_15188 = 0;
    while (true) {
      if (i_15188 < n__5194__auto___15187) {
        a[i_15188] = init_val_or_seq;
        var G__15189 = i_15188 + 1;
        i_15188 = G__15189;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.long_array.cljs$lang$maxFixedArity = 2;
cljs.core.double_array = function cljs$core$double_array() {
  var G__15191 = arguments.length;
  switch(G__15191) {
    case 1:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__15193 = i + 1;
        var G__15194 = cljs.core.next(s__$1);
        i = G__15193;
        s__$1 = G__15194;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___15195 = size;
    var i_15196 = 0;
    while (true) {
      if (i_15196 < n__5194__auto___15195) {
        a[i_15196] = init_val_or_seq;
        var G__15197 = i_15196 + 1;
        i_15196 = G__15197;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.double_array.cljs$lang$maxFixedArity = 2;
cljs.core.object_array = function cljs$core$object_array() {
  var G__15199 = arguments.length;
  switch(G__15199) {
    case 1:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__15201 = i + 1;
        var G__15202 = cljs.core.next(s__$1);
        i = G__15201;
        s__$1 = G__15202;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___15203 = size;
    var i_15204 = 0;
    while (true) {
      if (i_15204 < n__5194__auto___15203) {
        a[i_15204] = init_val_or_seq;
        var G__15205 = i_15204 + 1;
        i_15204 = G__15205;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = function cljs$core$bounded_count(s, n) {
  if (cljs.core.counted_QMARK_(s)) {
    return cljs.core.count(s);
  } else {
    var s__$1 = s;
    var i = n;
    var sum = 0;
    while (true) {
      if (i > 0 && cljs.core.seq(s__$1)) {
        var G__15206 = cljs.core.next(s__$1);
        var G__15207 = i - 1;
        var G__15208 = sum + 1;
        s__$1 = G__15206;
        i = G__15207;
        sum = G__15208;
        continue;
      } else {
        return sum;
      }
      break;
    }
  }
};
cljs.core.spread = function cljs$core$spread(arglist) {
  if (arglist == null) {
    return null;
  } else {
    if (cljs.core.next(arglist) == null) {
      return cljs.core.seq(cljs.core.first(arglist));
    } else {
      return cljs.core.cons(cljs.core.first(arglist), cljs$core$spread(cljs.core.next(arglist)));
    }
  }
};
cljs.core.concat = function cljs$core$concat() {
  var G__15214 = arguments.length;
  switch(G__15214) {
    case 0:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = function() {
  return new cljs.core.LazySeq(null, function() {
    return null;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return x;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return new cljs.core.LazySeq(null, function() {
    var s = cljs.core.seq(x);
    if (s) {
      if (cljs.core.chunked_seq_QMARK_(s)) {
        return cljs.core.chunk_cons(cljs.core.chunk_first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s), y));
      } else {
        return cljs.core.cons(cljs.core.first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s), y));
      }
    } else {
      return y;
    }
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = function(x, y, zs) {
  var cat = function cljs$core$cat(xys, zs__$1) {
    return new cljs.core.LazySeq(null, function() {
      var xys__$1 = cljs.core.seq(xys);
      if (xys__$1) {
        if (cljs.core.chunked_seq_QMARK_(xys__$1)) {
          return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1), cljs$core$cat(cljs.core.chunk_rest(xys__$1), zs__$1));
        } else {
          return cljs.core.cons(cljs.core.first(xys__$1), cljs$core$cat(cljs.core.rest(xys__$1), zs__$1));
        }
      } else {
        if (cljs.core.truth_(zs__$1)) {
          return cljs$core$cat(cljs.core.first(zs__$1), cljs.core.next(zs__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x, y), zs);
};
cljs.core.concat.cljs$lang$applyTo = function(seq15210) {
  var G__15211 = cljs.core.first(seq15210);
  var seq15210__$1 = cljs.core.next(seq15210);
  var G__15212 = cljs.core.first(seq15210__$1);
  var seq15210__$2 = cljs.core.next(seq15210__$1);
  return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__15211, G__15212, seq15210__$2);
};
cljs.core.concat.cljs$lang$maxFixedArity = 2;
cljs.core.list_STAR_ = function cljs$core$list_STAR_() {
  var G__15228 = arguments.length;
  switch(G__15228) {
    case 1:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = function(args) {
  return cljs.core.seq(args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = function(a, args) {
  return cljs.core.cons(a, args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = function(a, b, args) {
  return cljs.core.cons(a, cljs.core.cons(b, args));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, args) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, args)));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = function(a, b, c, d, more) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(more)))));
};
cljs.core.list_STAR_.cljs$lang$applyTo = function(seq15222) {
  var G__15223 = cljs.core.first(seq15222);
  var seq15222__$1 = cljs.core.next(seq15222);
  var G__15224 = cljs.core.first(seq15222__$1);
  var seq15222__$2 = cljs.core.next(seq15222__$1);
  var G__15225 = cljs.core.first(seq15222__$2);
  var seq15222__$3 = cljs.core.next(seq15222__$2);
  var G__15226 = cljs.core.first(seq15222__$3);
  var seq15222__$4 = cljs.core.next(seq15222__$3);
  return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__15223, G__15224, G__15225, G__15226, seq15222__$4);
};
cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
cljs.core.transient$ = function cljs$core$transient(coll) {
  return cljs.core._as_transient(coll);
};
cljs.core.persistent_BANG_ = function cljs$core$persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_(tcoll);
};
cljs.core.conj_BANG_ = function cljs$core$conj_BANG_() {
  var G__15234 = arguments.length;
  switch(G__15234) {
    case 0:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._conj_BANG_(tcoll, val);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._conj_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__15236 = ntcoll;
      var G__15237 = cljs.core.first(vals);
      var G__15238 = cljs.core.next(vals);
      tcoll = G__15236;
      val = G__15237;
      vals = G__15238;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.conj_BANG_.cljs$lang$applyTo = function(seq15230) {
  var G__15231 = cljs.core.first(seq15230);
  var seq15230__$1 = cljs.core.next(seq15230);
  var G__15232 = cljs.core.first(seq15230__$1);
  var seq15230__$2 = cljs.core.next(seq15230__$1);
  return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15231, G__15232, seq15230__$2);
};
cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.assoc_BANG_ = function cljs$core$assoc_BANG_() {
  var G__15244 = arguments.length;
  switch(G__15244) {
    case 3:
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = function(tcoll, key, val) {
  return cljs.core._assoc_BANG_(tcoll, key, val);
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, val, kvs) {
  while (true) {
    var ntcoll = cljs.core._assoc_BANG_(tcoll, key, val);
    if (cljs.core.truth_(kvs)) {
      var G__15246 = ntcoll;
      var G__15247 = cljs.core.first(kvs);
      var G__15248 = cljs.core.second(kvs);
      var G__15249 = cljs.core.nnext(kvs);
      tcoll = G__15246;
      key = G__15247;
      val = G__15248;
      kvs = G__15249;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.assoc_BANG_.cljs$lang$applyTo = function(seq15239) {
  var G__15240 = cljs.core.first(seq15239);
  var seq15239__$1 = cljs.core.next(seq15239);
  var G__15241 = cljs.core.first(seq15239__$1);
  var seq15239__$2 = cljs.core.next(seq15239__$1);
  var G__15242 = cljs.core.first(seq15239__$2);
  var seq15239__$3 = cljs.core.next(seq15239__$2);
  return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15240, G__15241, G__15242, seq15239__$3);
};
cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc_BANG_ = function cljs$core$dissoc_BANG_() {
  var G__15254 = arguments.length;
  switch(G__15254) {
    case 2:
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, key) {
  return cljs.core._dissoc_BANG_(tcoll, key);
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, ks) {
  while (true) {
    var ntcoll = cljs.core._dissoc_BANG_(tcoll, key);
    if (cljs.core.truth_(ks)) {
      var G__15256 = ntcoll;
      var G__15257 = cljs.core.first(ks);
      var G__15258 = cljs.core.next(ks);
      tcoll = G__15256;
      key = G__15257;
      ks = G__15258;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.dissoc_BANG_.cljs$lang$applyTo = function(seq15250) {
  var G__15251 = cljs.core.first(seq15250);
  var seq15250__$1 = cljs.core.next(seq15250);
  var G__15252 = cljs.core.first(seq15250__$1);
  var seq15250__$2 = cljs.core.next(seq15250__$1);
  return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15251, G__15252, seq15250__$2);
};
cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.pop_BANG_ = function cljs$core$pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_(tcoll);
};
cljs.core.disj_BANG_ = function cljs$core$disj_BANG_() {
  var G__15263 = arguments.length;
  switch(G__15263) {
    case 2:
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._disjoin_BANG_(tcoll, val);
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._disjoin_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__15265 = ntcoll;
      var G__15266 = cljs.core.first(vals);
      var G__15267 = cljs.core.next(vals);
      tcoll = G__15265;
      val = G__15266;
      vals = G__15267;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.disj_BANG_.cljs$lang$applyTo = function(seq15259) {
  var G__15260 = cljs.core.first(seq15259);
  var seq15259__$1 = cljs.core.next(seq15259);
  var G__15261 = cljs.core.first(seq15259__$1);
  var seq15259__$2 = cljs.core.next(seq15259__$1);
  return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15260, G__15261, seq15259__$2);
};
cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.apply_to = function cljs$core$apply_to(f, argc, args) {
  var args__$1 = cljs.core.seq(args);
  if (argc === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var a5238 = cljs.core._first(args__$1);
    var args__$2 = cljs.core._rest(args__$1);
    if (argc === 1) {
      if (f.cljs$core$IFn$_invoke$arity$1) {
        return f.cljs$core$IFn$_invoke$arity$1(a5238);
      } else {
        var G__15478 = a5238;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15478) : f.call(null, G__15478);
      }
    } else {
      var b5239 = cljs.core._first(args__$2);
      var args__$3 = cljs.core._rest(args__$2);
      if (argc === 2) {
        if (f.cljs$core$IFn$_invoke$arity$2) {
          return f.cljs$core$IFn$_invoke$arity$2(a5238, b5239);
        } else {
          var G__15479 = a5238;
          var G__15480 = b5239;
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15479, G__15480) : f.call(null, G__15479, G__15480);
        }
      } else {
        var c5240 = cljs.core._first(args__$3);
        var args__$4 = cljs.core._rest(args__$3);
        if (argc === 3) {
          if (f.cljs$core$IFn$_invoke$arity$3) {
            return f.cljs$core$IFn$_invoke$arity$3(a5238, b5239, c5240);
          } else {
            var G__15481 = a5238;
            var G__15482 = b5239;
            var G__15483 = c5240;
            return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15481, G__15482, G__15483) : f.call(null, G__15481, G__15482, G__15483);
          }
        } else {
          var d5241 = cljs.core._first(args__$4);
          var args__$5 = cljs.core._rest(args__$4);
          if (argc === 4) {
            if (f.cljs$core$IFn$_invoke$arity$4) {
              return f.cljs$core$IFn$_invoke$arity$4(a5238, b5239, c5240, d5241);
            } else {
              var G__15484 = a5238;
              var G__15485 = b5239;
              var G__15486 = c5240;
              var G__15487 = d5241;
              return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15484, G__15485, G__15486, G__15487) : f.call(null, G__15484, G__15485, G__15486, G__15487);
            }
          } else {
            var e5242 = cljs.core._first(args__$5);
            var args__$6 = cljs.core._rest(args__$5);
            if (argc === 5) {
              if (f.cljs$core$IFn$_invoke$arity$5) {
                return f.cljs$core$IFn$_invoke$arity$5(a5238, b5239, c5240, d5241, e5242);
              } else {
                var G__15488 = a5238;
                var G__15489 = b5239;
                var G__15490 = c5240;
                var G__15491 = d5241;
                var G__15492 = e5242;
                return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__15488, G__15489, G__15490, G__15491, G__15492) : f.call(null, G__15488, G__15489, G__15490, G__15491, G__15492);
              }
            } else {
              var f5243 = cljs.core._first(args__$6);
              var args__$7 = cljs.core._rest(args__$6);
              if (argc === 6) {
                if (f.cljs$core$IFn$_invoke$arity$6) {
                  return f.cljs$core$IFn$_invoke$arity$6(a5238, b5239, c5240, d5241, e5242, f5243);
                } else {
                  var G__15493 = a5238;
                  var G__15494 = b5239;
                  var G__15495 = c5240;
                  var G__15496 = d5241;
                  var G__15497 = e5242;
                  var G__15498 = f5243;
                  return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__15493, G__15494, G__15495, G__15496, G__15497, G__15498) : f.call(null, G__15493, G__15494, G__15495, G__15496, G__15497, G__15498);
                }
              } else {
                var g5244 = cljs.core._first(args__$7);
                var args__$8 = cljs.core._rest(args__$7);
                if (argc === 7) {
                  if (f.cljs$core$IFn$_invoke$arity$7) {
                    return f.cljs$core$IFn$_invoke$arity$7(a5238, b5239, c5240, d5241, e5242, f5243, g5244);
                  } else {
                    var G__15499 = a5238;
                    var G__15500 = b5239;
                    var G__15501 = c5240;
                    var G__15502 = d5241;
                    var G__15503 = e5242;
                    var G__15504 = f5243;
                    var G__15505 = g5244;
                    return f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__15499, G__15500, G__15501, G__15502, G__15503, G__15504, G__15505) : f.call(null, G__15499, G__15500, G__15501, G__15502, G__15503, G__15504, G__15505);
                  }
                } else {
                  var h5245 = cljs.core._first(args__$8);
                  var args__$9 = cljs.core._rest(args__$8);
                  if (argc === 8) {
                    if (f.cljs$core$IFn$_invoke$arity$8) {
                      return f.cljs$core$IFn$_invoke$arity$8(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245);
                    } else {
                      var G__15506 = a5238;
                      var G__15507 = b5239;
                      var G__15508 = c5240;
                      var G__15509 = d5241;
                      var G__15510 = e5242;
                      var G__15511 = f5243;
                      var G__15512 = g5244;
                      var G__15513 = h5245;
                      return f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__15506, G__15507, G__15508, G__15509, G__15510, G__15511, G__15512, G__15513) : f.call(null, G__15506, G__15507, G__15508, G__15509, G__15510, G__15511, G__15512, G__15513);
                    }
                  } else {
                    var i5246 = cljs.core._first(args__$9);
                    var args__$10 = cljs.core._rest(args__$9);
                    if (argc === 9) {
                      if (f.cljs$core$IFn$_invoke$arity$9) {
                        return f.cljs$core$IFn$_invoke$arity$9(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246);
                      } else {
                        var G__15514 = a5238;
                        var G__15515 = b5239;
                        var G__15516 = c5240;
                        var G__15517 = d5241;
                        var G__15518 = e5242;
                        var G__15519 = f5243;
                        var G__15520 = g5244;
                        var G__15521 = h5245;
                        var G__15522 = i5246;
                        return f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__15514, G__15515, G__15516, G__15517, G__15518, G__15519, G__15520, G__15521, G__15522) : f.call(null, G__15514, G__15515, G__15516, G__15517, G__15518, G__15519, G__15520, G__15521, G__15522);
                      }
                    } else {
                      var j5247 = cljs.core._first(args__$10);
                      var args__$11 = cljs.core._rest(args__$10);
                      if (argc === 10) {
                        if (f.cljs$core$IFn$_invoke$arity$10) {
                          return f.cljs$core$IFn$_invoke$arity$10(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247);
                        } else {
                          var G__15523 = a5238;
                          var G__15524 = b5239;
                          var G__15525 = c5240;
                          var G__15526 = d5241;
                          var G__15527 = e5242;
                          var G__15528 = f5243;
                          var G__15529 = g5244;
                          var G__15530 = h5245;
                          var G__15531 = i5246;
                          var G__15532 = j5247;
                          return f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__15523, G__15524, G__15525, G__15526, G__15527, G__15528, G__15529, G__15530, G__15531, G__15532) : f.call(null, G__15523, G__15524, G__15525, G__15526, G__15527, G__15528, G__15529, G__15530, G__15531, G__15532);
                        }
                      } else {
                        var k5248 = cljs.core._first(args__$11);
                        var args__$12 = cljs.core._rest(args__$11);
                        if (argc === 11) {
                          if (f.cljs$core$IFn$_invoke$arity$11) {
                            return f.cljs$core$IFn$_invoke$arity$11(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248);
                          } else {
                            var G__15533 = a5238;
                            var G__15534 = b5239;
                            var G__15535 = c5240;
                            var G__15536 = d5241;
                            var G__15537 = e5242;
                            var G__15538 = f5243;
                            var G__15539 = g5244;
                            var G__15540 = h5245;
                            var G__15541 = i5246;
                            var G__15542 = j5247;
                            var G__15543 = k5248;
                            return f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__15533, G__15534, G__15535, G__15536, G__15537, G__15538, G__15539, G__15540, G__15541, G__15542, G__15543) : f.call(null, G__15533, G__15534, G__15535, G__15536, G__15537, G__15538, G__15539, G__15540, G__15541, G__15542, G__15543);
                          }
                        } else {
                          var l5249 = cljs.core._first(args__$12);
                          var args__$13 = cljs.core._rest(args__$12);
                          if (argc === 12) {
                            if (f.cljs$core$IFn$_invoke$arity$12) {
                              return f.cljs$core$IFn$_invoke$arity$12(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249);
                            } else {
                              var G__15544 = a5238;
                              var G__15545 = b5239;
                              var G__15546 = c5240;
                              var G__15547 = d5241;
                              var G__15548 = e5242;
                              var G__15549 = f5243;
                              var G__15550 = g5244;
                              var G__15551 = h5245;
                              var G__15552 = i5246;
                              var G__15553 = j5247;
                              var G__15554 = k5248;
                              var G__15555 = l5249;
                              return f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__15544, G__15545, G__15546, G__15547, G__15548, G__15549, G__15550, G__15551, G__15552, G__15553, G__15554, G__15555) : f.call(null, G__15544, G__15545, G__15546, G__15547, G__15548, G__15549, G__15550, G__15551, G__15552, G__15553, G__15554, G__15555);
                            }
                          } else {
                            var m5250 = cljs.core._first(args__$13);
                            var args__$14 = cljs.core._rest(args__$13);
                            if (argc === 13) {
                              if (f.cljs$core$IFn$_invoke$arity$13) {
                                return f.cljs$core$IFn$_invoke$arity$13(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250);
                              } else {
                                var G__15556 = a5238;
                                var G__15557 = b5239;
                                var G__15558 = c5240;
                                var G__15559 = d5241;
                                var G__15560 = e5242;
                                var G__15561 = f5243;
                                var G__15562 = g5244;
                                var G__15563 = h5245;
                                var G__15564 = i5246;
                                var G__15565 = j5247;
                                var G__15566 = k5248;
                                var G__15567 = l5249;
                                var G__15568 = m5250;
                                return f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__15556, G__15557, G__15558, G__15559, G__15560, G__15561, G__15562, G__15563, G__15564, G__15565, G__15566, G__15567, G__15568) : f.call(null, G__15556, G__15557, G__15558, G__15559, G__15560, G__15561, G__15562, G__15563, G__15564, G__15565, G__15566, G__15567, G__15568);
                              }
                            } else {
                              var n5251 = cljs.core._first(args__$14);
                              var args__$15 = cljs.core._rest(args__$14);
                              if (argc === 14) {
                                if (f.cljs$core$IFn$_invoke$arity$14) {
                                  return f.cljs$core$IFn$_invoke$arity$14(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251);
                                } else {
                                  var G__15569 = a5238;
                                  var G__15570 = b5239;
                                  var G__15571 = c5240;
                                  var G__15572 = d5241;
                                  var G__15573 = e5242;
                                  var G__15574 = f5243;
                                  var G__15575 = g5244;
                                  var G__15576 = h5245;
                                  var G__15577 = i5246;
                                  var G__15578 = j5247;
                                  var G__15579 = k5248;
                                  var G__15580 = l5249;
                                  var G__15581 = m5250;
                                  var G__15582 = n5251;
                                  return f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__15569, G__15570, G__15571, G__15572, G__15573, G__15574, G__15575, G__15576, G__15577, G__15578, G__15579, G__15580, G__15581, G__15582) : f.call(null, G__15569, G__15570, G__15571, G__15572, G__15573, G__15574, G__15575, G__15576, G__15577, G__15578, G__15579, G__15580, G__15581, G__15582);
                                }
                              } else {
                                var o5252 = cljs.core._first(args__$15);
                                var args__$16 = cljs.core._rest(args__$15);
                                if (argc === 15) {
                                  if (f.cljs$core$IFn$_invoke$arity$15) {
                                    return f.cljs$core$IFn$_invoke$arity$15(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252);
                                  } else {
                                    var G__15583 = a5238;
                                    var G__15584 = b5239;
                                    var G__15585 = c5240;
                                    var G__15586 = d5241;
                                    var G__15587 = e5242;
                                    var G__15588 = f5243;
                                    var G__15589 = g5244;
                                    var G__15590 = h5245;
                                    var G__15591 = i5246;
                                    var G__15592 = j5247;
                                    var G__15593 = k5248;
                                    var G__15594 = l5249;
                                    var G__15595 = m5250;
                                    var G__15596 = n5251;
                                    var G__15597 = o5252;
                                    return f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__15583, G__15584, G__15585, G__15586, G__15587, G__15588, G__15589, G__15590, G__15591, G__15592, G__15593, G__15594, G__15595, G__15596, G__15597) : f.call(null, G__15583, G__15584, G__15585, G__15586, G__15587, G__15588, G__15589, G__15590, G__15591, G__15592, G__15593, G__15594, G__15595, G__15596, G__15597);
                                  }
                                } else {
                                  var p5253 = cljs.core._first(args__$16);
                                  var args__$17 = cljs.core._rest(args__$16);
                                  if (argc === 16) {
                                    if (f.cljs$core$IFn$_invoke$arity$16) {
                                      return f.cljs$core$IFn$_invoke$arity$16(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253);
                                    } else {
                                      var G__15598 = a5238;
                                      var G__15599 = b5239;
                                      var G__15600 = c5240;
                                      var G__15601 = d5241;
                                      var G__15602 = e5242;
                                      var G__15603 = f5243;
                                      var G__15604 = g5244;
                                      var G__15605 = h5245;
                                      var G__15606 = i5246;
                                      var G__15607 = j5247;
                                      var G__15608 = k5248;
                                      var G__15609 = l5249;
                                      var G__15610 = m5250;
                                      var G__15611 = n5251;
                                      var G__15612 = o5252;
                                      var G__15613 = p5253;
                                      return f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__15598, G__15599, G__15600, G__15601, G__15602, G__15603, G__15604, G__15605, G__15606, G__15607, G__15608, G__15609, G__15610, G__15611, G__15612, G__15613) : f.call(null, G__15598, G__15599, G__15600, G__15601, G__15602, G__15603, G__15604, G__15605, G__15606, G__15607, G__15608, G__15609, G__15610, G__15611, G__15612, G__15613);
                                    }
                                  } else {
                                    var q5254 = cljs.core._first(args__$17);
                                    var args__$18 = cljs.core._rest(args__$17);
                                    if (argc === 17) {
                                      if (f.cljs$core$IFn$_invoke$arity$17) {
                                        return f.cljs$core$IFn$_invoke$arity$17(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254);
                                      } else {
                                        var G__15614 = a5238;
                                        var G__15615 = b5239;
                                        var G__15616 = c5240;
                                        var G__15617 = d5241;
                                        var G__15618 = e5242;
                                        var G__15619 = f5243;
                                        var G__15620 = g5244;
                                        var G__15621 = h5245;
                                        var G__15622 = i5246;
                                        var G__15623 = j5247;
                                        var G__15624 = k5248;
                                        var G__15625 = l5249;
                                        var G__15626 = m5250;
                                        var G__15627 = n5251;
                                        var G__15628 = o5252;
                                        var G__15629 = p5253;
                                        var G__15630 = q5254;
                                        return f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__15614, G__15615, G__15616, G__15617, G__15618, G__15619, G__15620, G__15621, G__15622, G__15623, G__15624, G__15625, G__15626, G__15627, G__15628, G__15629, G__15630) : f.call(null, G__15614, G__15615, G__15616, G__15617, G__15618, G__15619, G__15620, G__15621, G__15622, G__15623, G__15624, G__15625, G__15626, G__15627, G__15628, G__15629, G__15630);
                                      }
                                    } else {
                                      var r5255 = cljs.core._first(args__$18);
                                      var args__$19 = cljs.core._rest(args__$18);
                                      if (argc === 18) {
                                        if (f.cljs$core$IFn$_invoke$arity$18) {
                                          return f.cljs$core$IFn$_invoke$arity$18(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254, r5255);
                                        } else {
                                          var G__15631 = a5238;
                                          var G__15632 = b5239;
                                          var G__15633 = c5240;
                                          var G__15634 = d5241;
                                          var G__15635 = e5242;
                                          var G__15636 = f5243;
                                          var G__15637 = g5244;
                                          var G__15638 = h5245;
                                          var G__15639 = i5246;
                                          var G__15640 = j5247;
                                          var G__15641 = k5248;
                                          var G__15642 = l5249;
                                          var G__15643 = m5250;
                                          var G__15644 = n5251;
                                          var G__15645 = o5252;
                                          var G__15646 = p5253;
                                          var G__15647 = q5254;
                                          var G__15648 = r5255;
                                          return f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__15631, G__15632, G__15633, G__15634, G__15635, G__15636, G__15637, G__15638, G__15639, G__15640, G__15641, G__15642, G__15643, G__15644, G__15645, G__15646, G__15647, G__15648) : f.call(null, G__15631, G__15632, G__15633, G__15634, G__15635, G__15636, G__15637, G__15638, G__15639, G__15640, G__15641, G__15642, G__15643, G__15644, G__15645, G__15646, G__15647, G__15648);
                                        }
                                      } else {
                                        var s5256 = cljs.core._first(args__$19);
                                        var args__$20 = cljs.core._rest(args__$19);
                                        if (argc === 19) {
                                          if (f.cljs$core$IFn$_invoke$arity$19) {
                                            return f.cljs$core$IFn$_invoke$arity$19(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254, r5255, s5256);
                                          } else {
                                            var G__15649 = a5238;
                                            var G__15650 = b5239;
                                            var G__15651 = c5240;
                                            var G__15652 = d5241;
                                            var G__15653 = e5242;
                                            var G__15654 = f5243;
                                            var G__15655 = g5244;
                                            var G__15656 = h5245;
                                            var G__15657 = i5246;
                                            var G__15658 = j5247;
                                            var G__15659 = k5248;
                                            var G__15660 = l5249;
                                            var G__15661 = m5250;
                                            var G__15662 = n5251;
                                            var G__15663 = o5252;
                                            var G__15664 = p5253;
                                            var G__15665 = q5254;
                                            var G__15666 = r5255;
                                            var G__15667 = s5256;
                                            return f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__15649, G__15650, G__15651, G__15652, G__15653, G__15654, G__15655, G__15656, G__15657, G__15658, G__15659, G__15660, G__15661, G__15662, G__15663, G__15664, G__15665, G__15666, G__15667) : f.call(null, G__15649, G__15650, G__15651, G__15652, G__15653, G__15654, G__15655, G__15656, G__15657, G__15658, G__15659, G__15660, G__15661, G__15662, G__15663, G__15664, G__15665, G__15666, 
                                            G__15667);
                                          }
                                        } else {
                                          var t5257 = cljs.core._first(args__$20);
                                          var args__$21 = cljs.core._rest(args__$20);
                                          if (argc === 20) {
                                            if (f.cljs$core$IFn$_invoke$arity$20) {
                                              return f.cljs$core$IFn$_invoke$arity$20(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254, r5255, s5256, t5257);
                                            } else {
                                              var G__15668 = a5238;
                                              var G__15669 = b5239;
                                              var G__15670 = c5240;
                                              var G__15671 = d5241;
                                              var G__15672 = e5242;
                                              var G__15673 = f5243;
                                              var G__15674 = g5244;
                                              var G__15675 = h5245;
                                              var G__15676 = i5246;
                                              var G__15677 = j5247;
                                              var G__15678 = k5248;
                                              var G__15679 = l5249;
                                              var G__15680 = m5250;
                                              var G__15681 = n5251;
                                              var G__15682 = o5252;
                                              var G__15683 = p5253;
                                              var G__15684 = q5254;
                                              var G__15685 = r5255;
                                              var G__15686 = s5256;
                                              var G__15687 = t5257;
                                              return f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__15668, G__15669, G__15670, G__15671, G__15672, G__15673, G__15674, G__15675, G__15676, G__15677, G__15678, G__15679, G__15680, G__15681, G__15682, G__15683, G__15684, G__15685, G__15686, G__15687) : f.call(null, G__15668, G__15669, G__15670, G__15671, G__15672, G__15673, G__15674, G__15675, G__15676, G__15677, G__15678, G__15679, G__15680, G__15681, G__15682, G__15683, G__15684, 
                                              G__15685, G__15686, G__15687);
                                            }
                                          } else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function cljs$core$apply() {
  var G__15695 = arguments.length;
  switch(G__15695) {
    case 2:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 5), 0);
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], argseq__5360__auto__);
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(args, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, args);
    } else {
      return f.cljs$lang$applyTo(args);
    }
  } else {
    return f.apply(f, cljs.core.to_array(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = function(f, x, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x, y, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = function(f, x, y, z, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x, y, z, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = function(f, a, b, c, d, args) {
  var arglist = cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(args)))));
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$lang$applyTo = function(seq15688) {
  var G__15689 = cljs.core.first(seq15688);
  var seq15688__$1 = cljs.core.next(seq15688);
  var G__15690 = cljs.core.first(seq15688__$1);
  var seq15688__$2 = cljs.core.next(seq15688__$1);
  var G__15691 = cljs.core.first(seq15688__$2);
  var seq15688__$3 = cljs.core.next(seq15688__$2);
  var G__15692 = cljs.core.first(seq15688__$3);
  var seq15688__$4 = cljs.core.next(seq15688__$3);
  var G__15693 = cljs.core.first(seq15688__$4);
  var seq15688__$5 = cljs.core.next(seq15688__$4);
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__15689, G__15690, G__15691, G__15692, G__15693, seq15688__$5);
};
cljs.core.apply.cljs$lang$maxFixedArity = 5;
cljs.core.vary_meta = function cljs$core$vary_meta() {
  var G__15705 = arguments.length;
  switch(G__15705) {
    case 2:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5360__auto__);
  }
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = function(obj, f) {
  return cljs.core.with_meta(obj, function() {
    var G__15706 = cljs.core.meta(obj);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15706) : f.call(null, G__15706);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = function(obj, f, a) {
  return cljs.core.with_meta(obj, function() {
    var G__15707 = cljs.core.meta(obj);
    var G__15708 = a;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15707, G__15708) : f.call(null, G__15707, G__15708);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = function(obj, f, a, b) {
  return cljs.core.with_meta(obj, function() {
    var G__15709 = cljs.core.meta(obj);
    var G__15710 = a;
    var G__15711 = b;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15709, G__15710, G__15711) : f.call(null, G__15709, G__15710, G__15711);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = function(obj, f, a, b, c) {
  return cljs.core.with_meta(obj, function() {
    var G__15712 = cljs.core.meta(obj);
    var G__15713 = a;
    var G__15714 = b;
    var G__15715 = c;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15712, G__15713, G__15714, G__15715) : f.call(null, G__15712, G__15713, G__15714, G__15715);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = function(obj, f, a, b, c, d) {
  return cljs.core.with_meta(obj, function() {
    var G__15716 = cljs.core.meta(obj);
    var G__15717 = a;
    var G__15718 = b;
    var G__15719 = c;
    var G__15720 = d;
    return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__15716, G__15717, G__15718, G__15719, G__15720) : f.call(null, G__15716, G__15717, G__15718, G__15719, G__15720);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = function(obj, f, a, b, c, d, args) {
  return cljs.core.with_meta(obj, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.meta(obj), a, b, c, cljs.core.array_seq([d, args], 0)));
};
cljs.core.vary_meta.cljs$lang$applyTo = function(seq15697) {
  var G__15698 = cljs.core.first(seq15697);
  var seq15697__$1 = cljs.core.next(seq15697);
  var G__15699 = cljs.core.first(seq15697__$1);
  var seq15697__$2 = cljs.core.next(seq15697__$1);
  var G__15700 = cljs.core.first(seq15697__$2);
  var seq15697__$3 = cljs.core.next(seq15697__$2);
  var G__15701 = cljs.core.first(seq15697__$3);
  var seq15697__$4 = cljs.core.next(seq15697__$3);
  var G__15702 = cljs.core.first(seq15697__$4);
  var seq15697__$5 = cljs.core.next(seq15697__$4);
  var G__15703 = cljs.core.first(seq15697__$5);
  var seq15697__$6 = cljs.core.next(seq15697__$5);
  return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__15698, G__15699, G__15700, G__15701, G__15702, G__15703, seq15697__$6);
};
cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
cljs.core.not_EQ_ = function cljs$core$not_EQ_() {
  var G__15726 = arguments.length;
  switch(G__15726) {
    case 1:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return false;
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_, x, y, more));
};
cljs.core.not_EQ_.cljs$lang$applyTo = function(seq15722) {
  var G__15723 = cljs.core.first(seq15722);
  var seq15722__$1 = cljs.core.next(seq15722);
  var G__15724 = cljs.core.first(seq15722__$1);
  var seq15722__$2 = cljs.core.next(seq15722__$1);
  return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__15723, G__15724, seq15722__$2);
};
cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.not_empty = function cljs$core$not_empty(coll) {
  if (cljs.core.seq(coll)) {
    return coll;
  } else {
    return null;
  }
};
cljs.core.nil_iter = function cljs$core$nil_iter() {
  if (typeof cljs.core.t15731 !== "undefined") {
  } else {
    cljs.core.t15731 = function(nil_iter, meta15732) {
      this.nil_iter = nil_iter;
      this.meta15732 = meta15732;
      this.cljs$lang$protocol_mask$partition0$ = 393216;
      this.cljs$lang$protocol_mask$partition1$ = 0;
    };
    cljs.core.t15731.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_15733, meta15732__$1) {
      var self__ = this;
      var _15733__$1 = this;
      return new cljs.core.t15731(self__.nil_iter, meta15732__$1);
    };
    cljs.core.t15731.prototype.cljs$core$IMeta$_meta$arity$1 = function(_15733) {
      var self__ = this;
      var _15733__$1 = this;
      return self__.meta15732;
    };
    cljs.core.t15731.prototype.hasNext = function() {
      var self__ = this;
      var _ = this;
      return false;
    };
    cljs.core.t15731.prototype.next = function() {
      var self__ = this;
      var _ = this;
      return new Error("No such element");
    };
    cljs.core.t15731.prototype.remove = function() {
      var self__ = this;
      var _ = this;
      return new Error("Unsupported operation");
    };
    cljs.core.t15731.getBasis = function() {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "nil-iter", "nil-iter", 1101030523, null), new cljs.core.Symbol(null, "meta15732", "meta15732", 199225453, null)], null);
    };
    cljs.core.t15731.cljs$lang$type = true;
    cljs.core.t15731.cljs$lang$ctorStr = "cljs.core/t15731";
    cljs.core.t15731.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
      return cljs.core._write(writer__4889__auto__, "cljs.core/t15731");
    };
    cljs.core.__GT_t15731 = function cljs$core$nil_iter_$___GT_t15731(nil_iter__$1, meta15732) {
      return new cljs.core.t15731(nil_iter__$1, meta15732);
    };
  }
  return new cljs.core.t15731(cljs$core$nil_iter, cljs.core.PersistentArrayMap.EMPTY);
};
cljs.core.StringIter = function(s, i) {
  this.s = s;
  this.i = i;
};
cljs.core.StringIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.s.length;
};
cljs.core.StringIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.s.charAt(self__.i);
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.StringIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.StringIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.StringIter.cljs$lang$type = true;
cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/StringIter");
};
cljs.core.__GT_StringIter = function cljs$core$__GT_StringIter(s, i) {
  return new cljs.core.StringIter(s, i);
};
cljs.core.string_iter = function cljs$core$string_iter(x) {
  return new cljs.core.StringIter(x, 0);
};
cljs.core.ArrayIter = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.ArrayIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.ArrayIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.ArrayIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.ArrayIter.cljs$lang$type = true;
cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayIter");
};
cljs.core.__GT_ArrayIter = function cljs$core$__GT_ArrayIter(arr, i) {
  return new cljs.core.ArrayIter(arr, i);
};
cljs.core.array_iter = function cljs$core$array_iter(x) {
  return new cljs.core.ArrayIter(x, 0);
};
cljs.core.INIT = {};
cljs.core.START = {};
cljs.core.SeqIter = function(_seq, _next) {
  this._seq = _seq;
  this._next = _next;
};
cljs.core.SeqIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__._seq === cljs.core.INIT) {
    self__._seq = cljs.core.START;
    self__._next = cljs.core.seq(self__._next);
  } else {
    if (self__._seq === self__._next) {
      self__._next = cljs.core.next(self__._seq);
    } else {
    }
  }
  return !(self__._next == null);
};
cljs.core.SeqIter.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.not(this$.hasNext())) {
    throw new Error("No such element");
  } else {
    self__._seq = self__._next;
    return cljs.core.first(self__._next);
  }
};
cljs.core.SeqIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.SeqIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "_seq", "_seq", -449557847, null), new cljs.core.Symbol(null, "_next", "_next", 101877036, null)], null);
};
cljs.core.SeqIter.cljs$lang$type = true;
cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";
cljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/SeqIter");
};
cljs.core.__GT_SeqIter = function cljs$core$__GT_SeqIter(_seq, _next) {
  return new cljs.core.SeqIter(_seq, _next);
};
cljs.core.seq_iter = function cljs$core$seq_iter(coll) {
  return new cljs.core.SeqIter(cljs.core.INIT, coll);
};
cljs.core.iter = function cljs$core$iter(coll) {
  if (coll == null) {
    return cljs.core.nil_iter();
  } else {
    if (typeof coll === "string") {
      return cljs.core.string_iter(coll);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return cljs.core.array_iter(coll);
      } else {
        if (cljs.core.truth_(cljs.core.iterable_QMARK_(coll))) {
          return cljs.core._iterator(coll);
        } else {
          if (cljs.core.seqable_QMARK_(coll)) {
            return cljs.core.seq_iter(coll);
          } else {
            throw new Error([cljs.core.str("Cannot create iterator from "), cljs.core.str(coll)].join(""));
          }
        }
      }
    }
  }
};
cljs.core.lazy_transformer = function cljs$core$lazy_transformer(stepper) {
  return new cljs.core.LazyTransformer(stepper, null, null, null);
};
cljs.core.Stepper = function(xform, iter) {
  this.xform = xform;
  this.iter = iter;
};
cljs.core.Stepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = !(lt.stepper == null);
      if (and__4297__auto__) {
        return self__.iter.hasNext();
      } else {
        return and__4297__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(function() {
        var G__15734 = lt;
        var G__15735 = self__.iter.next();
        return self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__15734, G__15735) : self__.xform.call(null, G__15734, G__15735);
      }())) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    var G__15736 = lt;
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__15736) : self__.xform.call(null, G__15736);
  }
};
cljs.core.Stepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null)], null);
};
cljs.core.Stepper.cljs$lang$type = true;
cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";
cljs.core.Stepper.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Stepper");
};
cljs.core.__GT_Stepper = function cljs$core$__GT_Stepper(xform, iter) {
  return new cljs.core.Stepper(xform, iter);
};
cljs.core.stepper = function cljs$core$stepper(xform, iter) {
  var stepfn = function() {
    var cljs$core$stepper_$_stepfn = null;
    var cljs$core$stepper_$_stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return result;
    };
    var cljs$core$stepper_$_stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepper_$_stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepper_$_stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepper_$_stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
    return cljs$core$stepper_$_stepfn;
  }();
  return new cljs.core.Stepper(function() {
    var G__15738 = stepfn;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__15738) : xform.call(null, G__15738);
  }(), iter);
};
cljs.core.MultiStepper = function(xform, iters, nexts) {
  this.xform = xform;
  this.iters = iters;
  this.nexts = nexts;
};
cljs.core.MultiStepper.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var iters__$1 = cljs.core.seq(self__.iters);
  while (true) {
    if (!(iters__$1 == null)) {
      var iter = cljs.core.first(iters__$1);
      if (cljs.core.not(iter.hasNext())) {
        return false;
      } else {
        var G__15740 = cljs.core.next(iters__$1);
        iters__$1 = G__15740;
        continue;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.MultiStepper.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var n__5194__auto___15741 = self__.iters.length;
  var i_15742 = 0;
  while (true) {
    if (i_15742 < n__5194__auto___15741) {
      self__.nexts[i_15742] = self__.iters[i_15742].next();
      var G__15743 = i_15742 + 1;
      i_15742 = G__15743;
      continue;
    } else {
    }
    break;
  }
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts, 0);
};
cljs.core.MultiStepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = !(lt.stepper == null);
      if (and__4297__auto__) {
        return this$.hasNext();
      } else {
        return and__4297__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform, cljs.core.cons(lt, this$.next())))) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    var G__15739 = lt;
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__15739) : self__.xform.call(null, G__15739);
  }
};
cljs.core.MultiStepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iters", "iters", 719353031, null), new cljs.core.Symbol(null, "nexts", "nexts", -1683579407, null)], null);
};
cljs.core.MultiStepper.cljs$lang$type = true;
cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";
cljs.core.MultiStepper.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/MultiStepper");
};
cljs.core.__GT_MultiStepper = function cljs$core$__GT_MultiStepper(xform, iters, nexts) {
  return new cljs.core.MultiStepper(xform, iters, nexts);
};
cljs.core.multi_stepper = function cljs$core$multi_stepper() {
  var G__15745 = arguments.length;
  switch(G__15745) {
    case 2:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = function(xform, iters) {
  return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length));
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = function(xform, iters, nexts) {
  var stepfn = function() {
    var cljs$core$stepfn = null;
    var cljs$core$stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return lt;
    };
    var cljs$core$stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
    return cljs$core$stepfn;
  }();
  return new cljs.core.MultiStepper(function() {
    var G__15746 = stepfn;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__15746) : xform.call(null, G__15746);
  }(), iters, nexts);
};
cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;
cljs.core.LazyTransformer = function(stepper, first, rest, meta) {
  this.stepper = stepper;
  this.first = first;
  this.rest = rest;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 31719628;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(this$, new_meta) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.LazyTransformer(self__.stepper, self__.first, self__.rest, new_meta);
};
cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, cljs.core._seq(this$__$1));
};
cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  var s = cljs.core._seq(this$__$1);
  if (!(s == null)) {
    return cljs.core.equiv_sequential(this$__$1, other);
  } else {
    return cljs.core.sequential_QMARK_(other) && cljs.core.seq(other) == null;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.hash_ordered_coll(this$__$1);
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    self__.stepper.step(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return this$__$1;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return self__.first;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core._seq(self__.rest);
  }
};
cljs.core.LazyTransformer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "stepper", "stepper", 1159163296, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.LazyTransformer.cljs$lang$type = true;
cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";
cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/LazyTransformer");
};
cljs.core.__GT_LazyTransformer = function cljs$core$__GT_LazyTransformer(stepper, first, rest, meta) {
  return new cljs.core.LazyTransformer(stepper, first, rest, meta);
};
cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.LazyTransformer.create = function(xform, coll) {
  return new cljs.core.LazyTransformer(cljs.core.stepper(xform, cljs.core.iter(coll)), null, null, null);
};
cljs.core.LazyTransformer.createMulti = function(xform, colls) {
  var iters = [];
  var seq__15748_15752 = cljs.core.seq(colls);
  var chunk__15749_15753 = null;
  var count__15750_15754 = 0;
  var i__15751_15755 = 0;
  while (true) {
    if (i__15751_15755 < count__15750_15754) {
      var coll_15756 = chunk__15749_15753.cljs$core$IIndexed$_nth$arity$2(null, i__15751_15755);
      iters.push(cljs.core.iter(coll_15756));
      var G__15757 = seq__15748_15752;
      var G__15758 = chunk__15749_15753;
      var G__15759 = count__15750_15754;
      var G__15760 = i__15751_15755 + 1;
      seq__15748_15752 = G__15757;
      chunk__15749_15753 = G__15758;
      count__15750_15754 = G__15759;
      i__15751_15755 = G__15760;
      continue;
    } else {
      var temp__4425__auto___15761 = cljs.core.seq(seq__15748_15752);
      if (temp__4425__auto___15761) {
        var seq__15748_15762__$1 = temp__4425__auto___15761;
        if (cljs.core.chunked_seq_QMARK_(seq__15748_15762__$1)) {
          var c__5094__auto___15763 = cljs.core.chunk_first(seq__15748_15762__$1);
          var G__15764 = cljs.core.chunk_rest(seq__15748_15762__$1);
          var G__15765 = c__5094__auto___15763;
          var G__15766 = cljs.core.count(c__5094__auto___15763);
          var G__15767 = 0;
          seq__15748_15752 = G__15764;
          chunk__15749_15753 = G__15765;
          count__15750_15754 = G__15766;
          i__15751_15755 = G__15767;
          continue;
        } else {
          var coll_15768 = cljs.core.first(seq__15748_15762__$1);
          iters.push(cljs.core.iter(coll_15768));
          var G__15769 = cljs.core.next(seq__15748_15762__$1);
          var G__15770 = null;
          var G__15771 = 0;
          var G__15772 = 0;
          seq__15748_15752 = G__15769;
          chunk__15749_15753 = G__15770;
          count__15750_15754 = G__15771;
          i__15751_15755 = G__15772;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length)), null, null, null);
};
cljs.core.sequence = function cljs$core$sequence() {
  var G__15777 = arguments.length;
  switch(G__15777) {
    case 1:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  if (cljs.core.seq_QMARK_(coll)) {
    return coll;
  } else {
    var or__4309__auto__ = cljs.core.seq(coll);
    if (or__4309__auto__) {
      return or__4309__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = function(xform, coll) {
  return cljs.core.LazyTransformer.create(xform, coll);
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = function(xform, coll, colls) {
  return cljs.core.LazyTransformer.createMulti(xform, cljs.core.to_array(cljs.core.cons(coll, colls)));
};
cljs.core.sequence.cljs$lang$applyTo = function(seq15773) {
  var G__15774 = cljs.core.first(seq15773);
  var seq15773__$1 = cljs.core.next(seq15773);
  var G__15775 = cljs.core.first(seq15773__$1);
  var seq15773__$2 = cljs.core.next(seq15773__$1);
  return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__15774, G__15775, seq15773__$2);
};
cljs.core.sequence.cljs$lang$maxFixedArity = 2;
cljs.core.every_QMARK_ = function cljs$core$every_QMARK_(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll) == null) {
      return true;
    } else {
      if (cljs.core.truth_(function() {
        var G__15780 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15780) : pred.call(null, G__15780);
      }())) {
        var G__15781 = pred;
        var G__15782 = cljs.core.next(coll);
        pred = G__15781;
        coll = G__15782;
        continue;
      } else {
        return false;
      }
    }
    break;
  }
};
cljs.core.not_every_QMARK_ = function cljs$core$not_every_QMARK_(pred, coll) {
  return !cljs.core.every_QMARK_(pred, coll);
};
cljs.core.some = function cljs$core$some(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll)) {
      var or__4309__auto__ = function() {
        var G__15786 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15786) : pred.call(null, G__15786);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var G__15787 = pred;
        var G__15788 = cljs.core.next(coll);
        pred = G__15787;
        coll = G__15788;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.not_any_QMARK_ = function cljs$core$not_any_QMARK_(pred, coll) {
  return cljs.core.not(cljs.core.some(pred, coll));
};
cljs.core.even_QMARK_ = function cljs$core$even_QMARK_(n) {
  if (cljs.core.integer_QMARK_(n)) {
    return (n & 1) === 0;
  } else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function cljs$core$odd_QMARK_(n) {
  return !cljs.core.even_QMARK_(n);
};
cljs.core.complement = function cljs$core$complement(f) {
  return function() {
    var G__15795 = null;
    var G__15795__0 = function() {
      return cljs.core.not(function() {
        return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
      }());
    };
    var G__15795__1 = function(x) {
      return cljs.core.not(function() {
        var G__15792 = x;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15792) : f.call(null, G__15792);
      }());
    };
    var G__15795__2 = function(x, y) {
      return cljs.core.not(function() {
        var G__15793 = x;
        var G__15794 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15793, G__15794) : f.call(null, G__15793, G__15794);
      }());
    };
    var G__15795__3 = function() {
      var G__15796__delegate = function(x, y, zs) {
        return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f, x, y, zs));
      };
      var G__15796 = function(x, y, var_args) {
        var zs = null;
        if (arguments.length > 2) {
          var G__15797__i = 0, G__15797__a = new Array(arguments.length - 2);
          while (G__15797__i < G__15797__a.length) {
            G__15797__a[G__15797__i] = arguments[G__15797__i + 2];
            ++G__15797__i;
          }
          zs = new cljs.core.IndexedSeq(G__15797__a, 0);
        }
        return G__15796__delegate.call(this, x, y, zs);
      };
      G__15796.cljs$lang$maxFixedArity = 2;
      G__15796.cljs$lang$applyTo = function(arglist__15798) {
        var x = cljs.core.first(arglist__15798);
        arglist__15798 = cljs.core.next(arglist__15798);
        var y = cljs.core.first(arglist__15798);
        var zs = cljs.core.rest(arglist__15798);
        return G__15796__delegate(x, y, zs);
      };
      G__15796.cljs$core$IFn$_invoke$arity$variadic = G__15796__delegate;
      return G__15796;
    }();
    G__15795 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__15795__0.call(this);
        case 1:
          return G__15795__1.call(this, x);
        case 2:
          return G__15795__2.call(this, x, y);
        default:
          var G__15799 = null;
          if (arguments.length > 2) {
            var G__15800__i = 0, G__15800__a = new Array(arguments.length - 2);
            while (G__15800__i < G__15800__a.length) {
              G__15800__a[G__15800__i] = arguments[G__15800__i + 2];
              ++G__15800__i;
            }
            G__15799 = new cljs.core.IndexedSeq(G__15800__a, 0);
          }
          return G__15795__3.cljs$core$IFn$_invoke$arity$variadic(x, y, G__15799);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__15795.cljs$lang$maxFixedArity = 2;
    G__15795.cljs$lang$applyTo = G__15795__3.cljs$lang$applyTo;
    G__15795.cljs$core$IFn$_invoke$arity$0 = G__15795__0;
    G__15795.cljs$core$IFn$_invoke$arity$1 = G__15795__1;
    G__15795.cljs$core$IFn$_invoke$arity$2 = G__15795__2;
    G__15795.cljs$core$IFn$_invoke$arity$variadic = G__15795__3.cljs$core$IFn$_invoke$arity$variadic;
    return G__15795;
  }();
};
cljs.core.constantly = function cljs$core$constantly(x) {
  return function() {
    var G__15801__delegate = function(args) {
      return x;
    };
    var G__15801 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__15802__i = 0, G__15802__a = new Array(arguments.length - 0);
        while (G__15802__i < G__15802__a.length) {
          G__15802__a[G__15802__i] = arguments[G__15802__i + 0];
          ++G__15802__i;
        }
        args = new cljs.core.IndexedSeq(G__15802__a, 0);
      }
      return G__15801__delegate.call(this, args);
    };
    G__15801.cljs$lang$maxFixedArity = 0;
    G__15801.cljs$lang$applyTo = function(arglist__15803) {
      var args = cljs.core.seq(arglist__15803);
      return G__15801__delegate(args);
    };
    G__15801.cljs$core$IFn$_invoke$arity$variadic = G__15801__delegate;
    return G__15801;
  }();
};
cljs.core.comp = function cljs$core$comp() {
  var G__15809 = arguments.length;
  switch(G__15809) {
    case 0:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.identity;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__15838 = null;
    var G__15838__0 = function() {
      var G__15810 = function() {
        return g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15810) : f.call(null, G__15810);
    };
    var G__15838__1 = function(x) {
      var G__15811 = function() {
        var G__15812 = x;
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15812) : g.call(null, G__15812);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15811) : f.call(null, G__15811);
    };
    var G__15838__2 = function(x, y) {
      var G__15813 = function() {
        var G__15814 = x;
        var G__15815 = y;
        return g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__15814, G__15815) : g.call(null, G__15814, G__15815);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15813) : f.call(null, G__15813);
    };
    var G__15838__3 = function(x, y, z) {
      var G__15816 = function() {
        var G__15817 = x;
        var G__15818 = y;
        var G__15819 = z;
        return g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__15817, G__15818, G__15819) : g.call(null, G__15817, G__15818, G__15819);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15816) : f.call(null, G__15816);
    };
    var G__15838__4 = function() {
      var G__15839__delegate = function(x, y, z, args) {
        var G__15820 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args);
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15820) : f.call(null, G__15820);
      };
      var G__15839 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__15840__i = 0, G__15840__a = new Array(arguments.length - 3);
          while (G__15840__i < G__15840__a.length) {
            G__15840__a[G__15840__i] = arguments[G__15840__i + 3];
            ++G__15840__i;
          }
          args = new cljs.core.IndexedSeq(G__15840__a, 0);
        }
        return G__15839__delegate.call(this, x, y, z, args);
      };
      G__15839.cljs$lang$maxFixedArity = 3;
      G__15839.cljs$lang$applyTo = function(arglist__15841) {
        var x = cljs.core.first(arglist__15841);
        arglist__15841 = cljs.core.next(arglist__15841);
        var y = cljs.core.first(arglist__15841);
        arglist__15841 = cljs.core.next(arglist__15841);
        var z = cljs.core.first(arglist__15841);
        var args = cljs.core.rest(arglist__15841);
        return G__15839__delegate(x, y, z, args);
      };
      G__15839.cljs$core$IFn$_invoke$arity$variadic = G__15839__delegate;
      return G__15839;
    }();
    G__15838 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__15838__0.call(this);
        case 1:
          return G__15838__1.call(this, x);
        case 2:
          return G__15838__2.call(this, x, y);
        case 3:
          return G__15838__3.call(this, x, y, z);
        default:
          var G__15842 = null;
          if (arguments.length > 3) {
            var G__15843__i = 0, G__15843__a = new Array(arguments.length - 3);
            while (G__15843__i < G__15843__a.length) {
              G__15843__a[G__15843__i] = arguments[G__15843__i + 3];
              ++G__15843__i;
            }
            G__15842 = new cljs.core.IndexedSeq(G__15843__a, 0);
          }
          return G__15838__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__15842);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__15838.cljs$lang$maxFixedArity = 3;
    G__15838.cljs$lang$applyTo = G__15838__4.cljs$lang$applyTo;
    G__15838.cljs$core$IFn$_invoke$arity$0 = G__15838__0;
    G__15838.cljs$core$IFn$_invoke$arity$1 = G__15838__1;
    G__15838.cljs$core$IFn$_invoke$arity$2 = G__15838__2;
    G__15838.cljs$core$IFn$_invoke$arity$3 = G__15838__3;
    G__15838.cljs$core$IFn$_invoke$arity$variadic = G__15838__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__15838;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__15844 = null;
    var G__15844__0 = function() {
      var G__15821 = function() {
        var G__15822 = function() {
          return h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15822) : g.call(null, G__15822);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15821) : f.call(null, G__15821);
    };
    var G__15844__1 = function(x) {
      var G__15823 = function() {
        var G__15824 = function() {
          var G__15825 = x;
          return h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__15825) : h.call(null, G__15825);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15824) : g.call(null, G__15824);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15823) : f.call(null, G__15823);
    };
    var G__15844__2 = function(x, y) {
      var G__15826 = function() {
        var G__15827 = function() {
          var G__15828 = x;
          var G__15829 = y;
          return h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__15828, G__15829) : h.call(null, G__15828, G__15829);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15827) : g.call(null, G__15827);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15826) : f.call(null, G__15826);
    };
    var G__15844__3 = function(x, y, z) {
      var G__15830 = function() {
        var G__15831 = function() {
          var G__15832 = x;
          var G__15833 = y;
          var G__15834 = z;
          return h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__15832, G__15833, G__15834) : h.call(null, G__15832, G__15833, G__15834);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15831) : g.call(null, G__15831);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15830) : f.call(null, G__15830);
    };
    var G__15844__4 = function() {
      var G__15845__delegate = function(x, y, z, args) {
        var G__15835 = function() {
          var G__15836 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args);
          return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15836) : g.call(null, G__15836);
        }();
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15835) : f.call(null, G__15835);
      };
      var G__15845 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__15846__i = 0, G__15846__a = new Array(arguments.length - 3);
          while (G__15846__i < G__15846__a.length) {
            G__15846__a[G__15846__i] = arguments[G__15846__i + 3];
            ++G__15846__i;
          }
          args = new cljs.core.IndexedSeq(G__15846__a, 0);
        }
        return G__15845__delegate.call(this, x, y, z, args);
      };
      G__15845.cljs$lang$maxFixedArity = 3;
      G__15845.cljs$lang$applyTo = function(arglist__15847) {
        var x = cljs.core.first(arglist__15847);
        arglist__15847 = cljs.core.next(arglist__15847);
        var y = cljs.core.first(arglist__15847);
        arglist__15847 = cljs.core.next(arglist__15847);
        var z = cljs.core.first(arglist__15847);
        var args = cljs.core.rest(arglist__15847);
        return G__15845__delegate(x, y, z, args);
      };
      G__15845.cljs$core$IFn$_invoke$arity$variadic = G__15845__delegate;
      return G__15845;
    }();
    G__15844 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__15844__0.call(this);
        case 1:
          return G__15844__1.call(this, x);
        case 2:
          return G__15844__2.call(this, x, y);
        case 3:
          return G__15844__3.call(this, x, y, z);
        default:
          var G__15848 = null;
          if (arguments.length > 3) {
            var G__15849__i = 0, G__15849__a = new Array(arguments.length - 3);
            while (G__15849__i < G__15849__a.length) {
              G__15849__a[G__15849__i] = arguments[G__15849__i + 3];
              ++G__15849__i;
            }
            G__15848 = new cljs.core.IndexedSeq(G__15849__a, 0);
          }
          return G__15844__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__15848);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__15844.cljs$lang$maxFixedArity = 3;
    G__15844.cljs$lang$applyTo = G__15844__4.cljs$lang$applyTo;
    G__15844.cljs$core$IFn$_invoke$arity$0 = G__15844__0;
    G__15844.cljs$core$IFn$_invoke$arity$1 = G__15844__1;
    G__15844.cljs$core$IFn$_invoke$arity$2 = G__15844__2;
    G__15844.cljs$core$IFn$_invoke$arity$3 = G__15844__3;
    G__15844.cljs$core$IFn$_invoke$arity$variadic = G__15844__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__15844;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = function(f1, f2, f3, fs) {
  var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1, f2, f3, fs));
  return function(fs__$1) {
    return function() {
      var G__15850__delegate = function(args) {
        var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1), args);
        var fs__$2 = cljs.core.next(fs__$1);
        while (true) {
          if (fs__$2) {
            var G__15851 = cljs.core.first(fs__$2).call(null, ret);
            var G__15852 = cljs.core.next(fs__$2);
            ret = G__15851;
            fs__$2 = G__15852;
            continue;
          } else {
            return ret;
          }
          break;
        }
      };
      var G__15850 = function(var_args) {
        var args = null;
        if (arguments.length > 0) {
          var G__15853__i = 0, G__15853__a = new Array(arguments.length - 0);
          while (G__15853__i < G__15853__a.length) {
            G__15853__a[G__15853__i] = arguments[G__15853__i + 0];
            ++G__15853__i;
          }
          args = new cljs.core.IndexedSeq(G__15853__a, 0);
        }
        return G__15850__delegate.call(this, args);
      };
      G__15850.cljs$lang$maxFixedArity = 0;
      G__15850.cljs$lang$applyTo = function(arglist__15854) {
        var args = cljs.core.seq(arglist__15854);
        return G__15850__delegate(args);
      };
      G__15850.cljs$core$IFn$_invoke$arity$variadic = G__15850__delegate;
      return G__15850;
    }();
  }(fs__$1);
};
cljs.core.comp.cljs$lang$applyTo = function(seq15804) {
  var G__15805 = cljs.core.first(seq15804);
  var seq15804__$1 = cljs.core.next(seq15804);
  var G__15806 = cljs.core.first(seq15804__$1);
  var seq15804__$2 = cljs.core.next(seq15804__$1);
  var G__15807 = cljs.core.first(seq15804__$2);
  var seq15804__$3 = cljs.core.next(seq15804__$2);
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__15805, G__15806, G__15807, seq15804__$3);
};
cljs.core.comp.cljs$lang$maxFixedArity = 3;
cljs.core.partial = function cljs$core$partial() {
  var G__15861 = arguments.length;
  switch(G__15861) {
    case 1:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = function(f, arg1) {
  return function() {
    var G__15905 = null;
    var G__15905__0 = function() {
      var G__15862 = arg1;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15862) : f.call(null, G__15862);
    };
    var G__15905__1 = function(x) {
      var G__15863 = arg1;
      var G__15864 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15863, G__15864) : f.call(null, G__15863, G__15864);
    };
    var G__15905__2 = function(x, y) {
      var G__15865 = arg1;
      var G__15866 = x;
      var G__15867 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15865, G__15866, G__15867) : f.call(null, G__15865, G__15866, G__15867);
    };
    var G__15905__3 = function(x, y, z) {
      var G__15868 = arg1;
      var G__15869 = x;
      var G__15870 = y;
      var G__15871 = z;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15868, G__15869, G__15870, G__15871) : f.call(null, G__15868, G__15869, G__15870, G__15871);
    };
    var G__15905__4 = function() {
      var G__15906__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, x, y, z, cljs.core.array_seq([args], 0));
      };
      var G__15906 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__15907__i = 0, G__15907__a = new Array(arguments.length - 3);
          while (G__15907__i < G__15907__a.length) {
            G__15907__a[G__15907__i] = arguments[G__15907__i + 3];
            ++G__15907__i;
          }
          args = new cljs.core.IndexedSeq(G__15907__a, 0);
        }
        return G__15906__delegate.call(this, x, y, z, args);
      };
      G__15906.cljs$lang$maxFixedArity = 3;
      G__15906.cljs$lang$applyTo = function(arglist__15908) {
        var x = cljs.core.first(arglist__15908);
        arglist__15908 = cljs.core.next(arglist__15908);
        var y = cljs.core.first(arglist__15908);
        arglist__15908 = cljs.core.next(arglist__15908);
        var z = cljs.core.first(arglist__15908);
        var args = cljs.core.rest(arglist__15908);
        return G__15906__delegate(x, y, z, args);
      };
      G__15906.cljs$core$IFn$_invoke$arity$variadic = G__15906__delegate;
      return G__15906;
    }();
    G__15905 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__15905__0.call(this);
        case 1:
          return G__15905__1.call(this, x);
        case 2:
          return G__15905__2.call(this, x, y);
        case 3:
          return G__15905__3.call(this, x, y, z);
        default:
          var G__15909 = null;
          if (arguments.length > 3) {
            var G__15910__i = 0, G__15910__a = new Array(arguments.length - 3);
            while (G__15910__i < G__15910__a.length) {
              G__15910__a[G__15910__i] = arguments[G__15910__i + 3];
              ++G__15910__i;
            }
            G__15909 = new cljs.core.IndexedSeq(G__15910__a, 0);
          }
          return G__15905__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__15909);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__15905.cljs$lang$maxFixedArity = 3;
    G__15905.cljs$lang$applyTo = G__15905__4.cljs$lang$applyTo;
    G__15905.cljs$core$IFn$_invoke$arity$0 = G__15905__0;
    G__15905.cljs$core$IFn$_invoke$arity$1 = G__15905__1;
    G__15905.cljs$core$IFn$_invoke$arity$2 = G__15905__2;
    G__15905.cljs$core$IFn$_invoke$arity$3 = G__15905__3;
    G__15905.cljs$core$IFn$_invoke$arity$variadic = G__15905__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__15905;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = function(f, arg1, arg2) {
  return function() {
    var G__15911 = null;
    var G__15911__0 = function() {
      var G__15872 = arg1;
      var G__15873 = arg2;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15872, G__15873) : f.call(null, G__15872, G__15873);
    };
    var G__15911__1 = function(x) {
      var G__15874 = arg1;
      var G__15875 = arg2;
      var G__15876 = x;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15874, G__15875, G__15876) : f.call(null, G__15874, G__15875, G__15876);
    };
    var G__15911__2 = function(x, y) {
      var G__15877 = arg1;
      var G__15878 = arg2;
      var G__15879 = x;
      var G__15880 = y;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15877, G__15878, G__15879, G__15880) : f.call(null, G__15877, G__15878, G__15879, G__15880);
    };
    var G__15911__3 = function(x, y, z) {
      var G__15881 = arg1;
      var G__15882 = arg2;
      var G__15883 = x;
      var G__15884 = y;
      var G__15885 = z;
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__15881, G__15882, G__15883, G__15884, G__15885) : f.call(null, G__15881, G__15882, G__15883, G__15884, G__15885);
    };
    var G__15911__4 = function() {
      var G__15912__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, x, y, cljs.core.array_seq([z, args], 0));
      };
      var G__15912 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__15913__i = 0, G__15913__a = new Array(arguments.length - 3);
          while (G__15913__i < G__15913__a.length) {
            G__15913__a[G__15913__i] = arguments[G__15913__i + 3];
            ++G__15913__i;
          }
          args = new cljs.core.IndexedSeq(G__15913__a, 0);
        }
        return G__15912__delegate.call(this, x, y, z, args);
      };
      G__15912.cljs$lang$maxFixedArity = 3;
      G__15912.cljs$lang$applyTo = function(arglist__15914) {
        var x = cljs.core.first(arglist__15914);
        arglist__15914 = cljs.core.next(arglist__15914);
        var y = cljs.core.first(arglist__15914);
        arglist__15914 = cljs.core.next(arglist__15914);
        var z = cljs.core.first(arglist__15914);
        var args = cljs.core.rest(arglist__15914);
        return G__15912__delegate(x, y, z, args);
      };
      G__15912.cljs$core$IFn$_invoke$arity$variadic = G__15912__delegate;
      return G__15912;
    }();
    G__15911 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__15911__0.call(this);
        case 1:
          return G__15911__1.call(this, x);
        case 2:
          return G__15911__2.call(this, x, y);
        case 3:
          return G__15911__3.call(this, x, y, z);
        default:
          var G__15915 = null;
          if (arguments.length > 3) {
            var G__15916__i = 0, G__15916__a = new Array(arguments.length - 3);
            while (G__15916__i < G__15916__a.length) {
              G__15916__a[G__15916__i] = arguments[G__15916__i + 3];
              ++G__15916__i;
            }
            G__15915 = new cljs.core.IndexedSeq(G__15916__a, 0);
          }
          return G__15911__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__15915);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__15911.cljs$lang$maxFixedArity = 3;
    G__15911.cljs$lang$applyTo = G__15911__4.cljs$lang$applyTo;
    G__15911.cljs$core$IFn$_invoke$arity$0 = G__15911__0;
    G__15911.cljs$core$IFn$_invoke$arity$1 = G__15911__1;
    G__15911.cljs$core$IFn$_invoke$arity$2 = G__15911__2;
    G__15911.cljs$core$IFn$_invoke$arity$3 = G__15911__3;
    G__15911.cljs$core$IFn$_invoke$arity$variadic = G__15911__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__15911;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = function(f, arg1, arg2, arg3) {
  return function() {
    var G__15917 = null;
    var G__15917__0 = function() {
      var G__15886 = arg1;
      var G__15887 = arg2;
      var G__15888 = arg3;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15886, G__15887, G__15888) : f.call(null, G__15886, G__15887, G__15888);
    };
    var G__15917__1 = function(x) {
      var G__15889 = arg1;
      var G__15890 = arg2;
      var G__15891 = arg3;
      var G__15892 = x;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15889, G__15890, G__15891, G__15892) : f.call(null, G__15889, G__15890, G__15891, G__15892);
    };
    var G__15917__2 = function(x, y) {
      var G__15893 = arg1;
      var G__15894 = arg2;
      var G__15895 = arg3;
      var G__15896 = x;
      var G__15897 = y;
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__15893, G__15894, G__15895, G__15896, G__15897) : f.call(null, G__15893, G__15894, G__15895, G__15896, G__15897);
    };
    var G__15917__3 = function(x, y, z) {
      var G__15898 = arg1;
      var G__15899 = arg2;
      var G__15900 = arg3;
      var G__15901 = x;
      var G__15902 = y;
      var G__15903 = z;
      return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__15898, G__15899, G__15900, G__15901, G__15902, G__15903) : f.call(null, G__15898, G__15899, G__15900, G__15901, G__15902, G__15903);
    };
    var G__15917__4 = function() {
      var G__15918__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, arg3, x, cljs.core.array_seq([y, z, args], 0));
      };
      var G__15918 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__15919__i = 0, G__15919__a = new Array(arguments.length - 3);
          while (G__15919__i < G__15919__a.length) {
            G__15919__a[G__15919__i] = arguments[G__15919__i + 3];
            ++G__15919__i;
          }
          args = new cljs.core.IndexedSeq(G__15919__a, 0);
        }
        return G__15918__delegate.call(this, x, y, z, args);
      };
      G__15918.cljs$lang$maxFixedArity = 3;
      G__15918.cljs$lang$applyTo = function(arglist__15920) {
        var x = cljs.core.first(arglist__15920);
        arglist__15920 = cljs.core.next(arglist__15920);
        var y = cljs.core.first(arglist__15920);
        arglist__15920 = cljs.core.next(arglist__15920);
        var z = cljs.core.first(arglist__15920);
        var args = cljs.core.rest(arglist__15920);
        return G__15918__delegate(x, y, z, args);
      };
      G__15918.cljs$core$IFn$_invoke$arity$variadic = G__15918__delegate;
      return G__15918;
    }();
    G__15917 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__15917__0.call(this);
        case 1:
          return G__15917__1.call(this, x);
        case 2:
          return G__15917__2.call(this, x, y);
        case 3:
          return G__15917__3.call(this, x, y, z);
        default:
          var G__15921 = null;
          if (arguments.length > 3) {
            var G__15922__i = 0, G__15922__a = new Array(arguments.length - 3);
            while (G__15922__i < G__15922__a.length) {
              G__15922__a[G__15922__i] = arguments[G__15922__i + 3];
              ++G__15922__i;
            }
            G__15921 = new cljs.core.IndexedSeq(G__15922__a, 0);
          }
          return G__15917__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__15921);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__15917.cljs$lang$maxFixedArity = 3;
    G__15917.cljs$lang$applyTo = G__15917__4.cljs$lang$applyTo;
    G__15917.cljs$core$IFn$_invoke$arity$0 = G__15917__0;
    G__15917.cljs$core$IFn$_invoke$arity$1 = G__15917__1;
    G__15917.cljs$core$IFn$_invoke$arity$2 = G__15917__2;
    G__15917.cljs$core$IFn$_invoke$arity$3 = G__15917__3;
    G__15917.cljs$core$IFn$_invoke$arity$variadic = G__15917__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__15917;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = function(f, arg1, arg2, arg3, more) {
  return function() {
    var G__15923__delegate = function(args) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, arg1, arg2, arg3, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more, args));
    };
    var G__15923 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__15924__i = 0, G__15924__a = new Array(arguments.length - 0);
        while (G__15924__i < G__15924__a.length) {
          G__15924__a[G__15924__i] = arguments[G__15924__i + 0];
          ++G__15924__i;
        }
        args = new cljs.core.IndexedSeq(G__15924__a, 0);
      }
      return G__15923__delegate.call(this, args);
    };
    G__15923.cljs$lang$maxFixedArity = 0;
    G__15923.cljs$lang$applyTo = function(arglist__15925) {
      var args = cljs.core.seq(arglist__15925);
      return G__15923__delegate(args);
    };
    G__15923.cljs$core$IFn$_invoke$arity$variadic = G__15923__delegate;
    return G__15923;
  }();
};
cljs.core.partial.cljs$lang$applyTo = function(seq15855) {
  var G__15856 = cljs.core.first(seq15855);
  var seq15855__$1 = cljs.core.next(seq15855);
  var G__15857 = cljs.core.first(seq15855__$1);
  var seq15855__$2 = cljs.core.next(seq15855__$1);
  var G__15858 = cljs.core.first(seq15855__$2);
  var seq15855__$3 = cljs.core.next(seq15855__$2);
  var G__15859 = cljs.core.first(seq15855__$3);
  var seq15855__$4 = cljs.core.next(seq15855__$3);
  return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__15856, G__15857, G__15858, G__15859, seq15855__$4);
};
cljs.core.partial.cljs$lang$maxFixedArity = 4;
cljs.core.fnil = function cljs$core$fnil() {
  var G__15927 = arguments.length;
  switch(G__15927) {
    case 2:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = function(f, x) {
  return function() {
    var G__15945 = null;
    var G__15945__1 = function(a) {
      var G__15928 = a == null ? x : a;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15928) : f.call(null, G__15928);
    };
    var G__15945__2 = function(a, b) {
      var G__15929 = a == null ? x : a;
      var G__15930 = b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15929, G__15930) : f.call(null, G__15929, G__15930);
    };
    var G__15945__3 = function(a, b, c) {
      var G__15931 = a == null ? x : a;
      var G__15932 = b;
      var G__15933 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15931, G__15932, G__15933) : f.call(null, G__15931, G__15932, G__15933);
    };
    var G__15945__4 = function() {
      var G__15946__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b, c, ds);
      };
      var G__15946 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__15947__i = 0, G__15947__a = new Array(arguments.length - 3);
          while (G__15947__i < G__15947__a.length) {
            G__15947__a[G__15947__i] = arguments[G__15947__i + 3];
            ++G__15947__i;
          }
          ds = new cljs.core.IndexedSeq(G__15947__a, 0);
        }
        return G__15946__delegate.call(this, a, b, c, ds);
      };
      G__15946.cljs$lang$maxFixedArity = 3;
      G__15946.cljs$lang$applyTo = function(arglist__15948) {
        var a = cljs.core.first(arglist__15948);
        arglist__15948 = cljs.core.next(arglist__15948);
        var b = cljs.core.first(arglist__15948);
        arglist__15948 = cljs.core.next(arglist__15948);
        var c = cljs.core.first(arglist__15948);
        var ds = cljs.core.rest(arglist__15948);
        return G__15946__delegate(a, b, c, ds);
      };
      G__15946.cljs$core$IFn$_invoke$arity$variadic = G__15946__delegate;
      return G__15946;
    }();
    G__15945 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 1:
          return G__15945__1.call(this, a);
        case 2:
          return G__15945__2.call(this, a, b);
        case 3:
          return G__15945__3.call(this, a, b, c);
        default:
          var G__15949 = null;
          if (arguments.length > 3) {
            var G__15950__i = 0, G__15950__a = new Array(arguments.length - 3);
            while (G__15950__i < G__15950__a.length) {
              G__15950__a[G__15950__i] = arguments[G__15950__i + 3];
              ++G__15950__i;
            }
            G__15949 = new cljs.core.IndexedSeq(G__15950__a, 0);
          }
          return G__15945__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__15949);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__15945.cljs$lang$maxFixedArity = 3;
    G__15945.cljs$lang$applyTo = G__15945__4.cljs$lang$applyTo;
    G__15945.cljs$core$IFn$_invoke$arity$1 = G__15945__1;
    G__15945.cljs$core$IFn$_invoke$arity$2 = G__15945__2;
    G__15945.cljs$core$IFn$_invoke$arity$3 = G__15945__3;
    G__15945.cljs$core$IFn$_invoke$arity$variadic = G__15945__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__15945;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = function(f, x, y) {
  return function() {
    var G__15951 = null;
    var G__15951__2 = function(a, b) {
      var G__15934 = a == null ? x : a;
      var G__15935 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15934, G__15935) : f.call(null, G__15934, G__15935);
    };
    var G__15951__3 = function(a, b, c) {
      var G__15936 = a == null ? x : a;
      var G__15937 = b == null ? y : b;
      var G__15938 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15936, G__15937, G__15938) : f.call(null, G__15936, G__15937, G__15938);
    };
    var G__15951__4 = function() {
      var G__15952__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c, ds);
      };
      var G__15952 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__15953__i = 0, G__15953__a = new Array(arguments.length - 3);
          while (G__15953__i < G__15953__a.length) {
            G__15953__a[G__15953__i] = arguments[G__15953__i + 3];
            ++G__15953__i;
          }
          ds = new cljs.core.IndexedSeq(G__15953__a, 0);
        }
        return G__15952__delegate.call(this, a, b, c, ds);
      };
      G__15952.cljs$lang$maxFixedArity = 3;
      G__15952.cljs$lang$applyTo = function(arglist__15954) {
        var a = cljs.core.first(arglist__15954);
        arglist__15954 = cljs.core.next(arglist__15954);
        var b = cljs.core.first(arglist__15954);
        arglist__15954 = cljs.core.next(arglist__15954);
        var c = cljs.core.first(arglist__15954);
        var ds = cljs.core.rest(arglist__15954);
        return G__15952__delegate(a, b, c, ds);
      };
      G__15952.cljs$core$IFn$_invoke$arity$variadic = G__15952__delegate;
      return G__15952;
    }();
    G__15951 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__15951__2.call(this, a, b);
        case 3:
          return G__15951__3.call(this, a, b, c);
        default:
          var G__15955 = null;
          if (arguments.length > 3) {
            var G__15956__i = 0, G__15956__a = new Array(arguments.length - 3);
            while (G__15956__i < G__15956__a.length) {
              G__15956__a[G__15956__i] = arguments[G__15956__i + 3];
              ++G__15956__i;
            }
            G__15955 = new cljs.core.IndexedSeq(G__15956__a, 0);
          }
          return G__15951__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__15955);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__15951.cljs$lang$maxFixedArity = 3;
    G__15951.cljs$lang$applyTo = G__15951__4.cljs$lang$applyTo;
    G__15951.cljs$core$IFn$_invoke$arity$2 = G__15951__2;
    G__15951.cljs$core$IFn$_invoke$arity$3 = G__15951__3;
    G__15951.cljs$core$IFn$_invoke$arity$variadic = G__15951__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__15951;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, z) {
  return function() {
    var G__15957 = null;
    var G__15957__2 = function(a, b) {
      var G__15939 = a == null ? x : a;
      var G__15940 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15939, G__15940) : f.call(null, G__15939, G__15940);
    };
    var G__15957__3 = function(a, b, c) {
      var G__15941 = a == null ? x : a;
      var G__15942 = b == null ? y : b;
      var G__15943 = c == null ? z : c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15941, G__15942, G__15943) : f.call(null, G__15941, G__15942, G__15943);
    };
    var G__15957__4 = function() {
      var G__15958__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds);
      };
      var G__15958 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__15959__i = 0, G__15959__a = new Array(arguments.length - 3);
          while (G__15959__i < G__15959__a.length) {
            G__15959__a[G__15959__i] = arguments[G__15959__i + 3];
            ++G__15959__i;
          }
          ds = new cljs.core.IndexedSeq(G__15959__a, 0);
        }
        return G__15958__delegate.call(this, a, b, c, ds);
      };
      G__15958.cljs$lang$maxFixedArity = 3;
      G__15958.cljs$lang$applyTo = function(arglist__15960) {
        var a = cljs.core.first(arglist__15960);
        arglist__15960 = cljs.core.next(arglist__15960);
        var b = cljs.core.first(arglist__15960);
        arglist__15960 = cljs.core.next(arglist__15960);
        var c = cljs.core.first(arglist__15960);
        var ds = cljs.core.rest(arglist__15960);
        return G__15958__delegate(a, b, c, ds);
      };
      G__15958.cljs$core$IFn$_invoke$arity$variadic = G__15958__delegate;
      return G__15958;
    }();
    G__15957 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__15957__2.call(this, a, b);
        case 3:
          return G__15957__3.call(this, a, b, c);
        default:
          var G__15961 = null;
          if (arguments.length > 3) {
            var G__15962__i = 0, G__15962__a = new Array(arguments.length - 3);
            while (G__15962__i < G__15962__a.length) {
              G__15962__a[G__15962__i] = arguments[G__15962__i + 3];
              ++G__15962__i;
            }
            G__15961 = new cljs.core.IndexedSeq(G__15962__a, 0);
          }
          return G__15957__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__15961);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__15957.cljs$lang$maxFixedArity = 3;
    G__15957.cljs$lang$applyTo = G__15957__4.cljs$lang$applyTo;
    G__15957.cljs$core$IFn$_invoke$arity$2 = G__15957__2;
    G__15957.cljs$core$IFn$_invoke$arity$3 = G__15957__3;
    G__15957.cljs$core$IFn$_invoke$arity$variadic = G__15957__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__15957;
  }();
};
cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.map_indexed = function cljs$core$map_indexed() {
  var G__15964 = arguments.length;
  switch(G__15964) {
    case 1:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var i = function() {
      var G__15965 = -1;
      return cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__15965) : cljs.core.volatile_BANG_.call(null, G__15965);
    }();
    return function(i) {
      return function() {
        var G__15996 = null;
        var G__15996__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__15996__1 = function(result) {
          var G__15966 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__15966) : rf.call(null, G__15966);
        };
        var G__15996__2 = function(result, input) {
          var G__15967 = result;
          var G__15968 = function() {
            var G__15969 = cljs.core._vreset_BANG_(i, cljs.core._deref(i) + 1);
            var G__15970 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15969, G__15970) : f.call(null, G__15969, G__15970);
          }();
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__15967, G__15968) : rf.call(null, G__15967, G__15968);
        };
        G__15996 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__15996__0.call(this);
            case 1:
              return G__15996__1.call(this, result);
            case 2:
              return G__15996__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__15996.cljs$core$IFn$_invoke$arity$0 = G__15996__0;
        G__15996.cljs$core$IFn$_invoke$arity$1 = G__15996__1;
        G__15996.cljs$core$IFn$_invoke$arity$2 = G__15996__2;
        return G__15996;
      }();
    }(i);
  };
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var mapi = function cljs$core$mapi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4425__auto__ = cljs.core.seq(coll__$1);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__5194__auto___15997 = size;
          var i_15998 = 0;
          while (true) {
            if (i_15998 < n__5194__auto___15997) {
              cljs.core.chunk_append(b, function() {
                var G__15991 = idx + i_15998;
                var G__15992 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_15998);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15991, G__15992) : f.call(null, G__15991, G__15992);
              }());
              var G__15999 = i_15998 + 1;
              i_15998 = G__15999;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$mapi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          return cljs.core.cons(function() {
            var G__15993 = idx;
            var G__15994 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15993, G__15994) : f.call(null, G__15993, G__15994);
          }(), cljs$core$mapi(idx + 1, cljs.core.rest(s)));
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return mapi(0, coll);
};
cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.keep = function cljs$core$keep() {
  var G__16001 = arguments.length;
  switch(G__16001) {
    case 1:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__16009 = null;
      var G__16009__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__16009__1 = function(result) {
        var G__16002 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__16002) : rf.call(null, G__16002);
      };
      var G__16009__2 = function(result, input) {
        var v = function() {
          var G__16003 = input;
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16003) : f.call(null, G__16003);
        }();
        if (v == null) {
          return result;
        } else {
          var G__16004 = result;
          var G__16005 = v;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16004, G__16005) : rf.call(null, G__16004, G__16005);
        }
      };
      G__16009 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__16009__0.call(this);
          case 1:
            return G__16009__1.call(this, result);
          case 2:
            return G__16009__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__16009.cljs$core$IFn$_invoke$arity$0 = G__16009__0;
      G__16009.cljs$core$IFn$_invoke$arity$1 = G__16009__1;
      G__16009.cljs$core$IFn$_invoke$arity$2 = G__16009__2;
      return G__16009;
    }();
  };
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5194__auto___16010 = size;
        var i_16011 = 0;
        while (true) {
          if (i_16011 < n__5194__auto___16010) {
            var x_16012 = function() {
              var G__16006 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_16011);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16006) : f.call(null, G__16006);
            }();
            if (x_16012 == null) {
            } else {
              cljs.core.chunk_append(b, x_16012);
            }
            var G__16013 = i_16011 + 1;
            i_16011 = G__16013;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        var x = function() {
          var G__16007 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16007) : f.call(null, G__16007);
        }();
        if (x == null) {
          return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s));
        } else {
          return cljs.core.cons(x, cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.keep.cljs$lang$maxFixedArity = 2;
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 16386;
  this.cljs$lang$protocol_mask$partition0$ = 6455296;
};
cljs.core.Atom.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return o__$1 === other;
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var self__ = this;
  var this$__$1 = this;
  var seq__16014 = cljs.core.seq(self__.watches);
  var chunk__16015 = null;
  var count__16016 = 0;
  var i__16017 = 0;
  while (true) {
    if (i__16017 < count__16016) {
      var vec__16018 = chunk__16015.cljs$core$IIndexed$_nth$arity$2(null, i__16017);
      var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16018, 0, null);
      var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16018, 1, null);
      var G__16019_16029 = key;
      var G__16020_16030 = this$__$1;
      var G__16021_16031 = oldval;
      var G__16022_16032 = newval;
      f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16019_16029, G__16020_16030, G__16021_16031, G__16022_16032) : f.call(null, G__16019_16029, G__16020_16030, G__16021_16031, G__16022_16032);
      var G__16033 = seq__16014;
      var G__16034 = chunk__16015;
      var G__16035 = count__16016;
      var G__16036 = i__16017 + 1;
      seq__16014 = G__16033;
      chunk__16015 = G__16034;
      count__16016 = G__16035;
      i__16017 = G__16036;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__16014);
      if (temp__4425__auto__) {
        var seq__16014__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__16014__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__16014__$1);
          var G__16037 = cljs.core.chunk_rest(seq__16014__$1);
          var G__16038 = c__5094__auto__;
          var G__16039 = cljs.core.count(c__5094__auto__);
          var G__16040 = 0;
          seq__16014 = G__16037;
          chunk__16015 = G__16038;
          count__16016 = G__16039;
          i__16017 = G__16040;
          continue;
        } else {
          var vec__16023 = cljs.core.first(seq__16014__$1);
          var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16023, 0, null);
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16023, 1, null);
          var G__16024_16041 = key;
          var G__16025_16042 = this$__$1;
          var G__16026_16043 = oldval;
          var G__16027_16044 = newval;
          f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16024_16041, G__16025_16042, G__16026_16043, G__16027_16044) : f.call(null, G__16024_16041, G__16025_16042, G__16026_16043, G__16027_16044);
          var G__16045 = cljs.core.next(seq__16014__$1);
          var G__16046 = null;
          var G__16047 = 0;
          var G__16048 = 0;
          seq__16014 = G__16045;
          chunk__16015 = G__16046;
          count__16016 = G__16047;
          i__16017 = G__16048;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var self__ = this;
  var this$__$1 = this;
  this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches, key, f);
  return this$__$1;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches, key);
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var G__16028 = this$__$1;
  return goog.getUid(G__16028);
};
cljs.core.Atom.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "validator", "validator", -325659154, null), new cljs.core.Symbol(null, "watches", "watches", 1367433992, null)], null);
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Atom");
};
cljs.core.__GT_Atom = function cljs$core$__GT_Atom(state, meta, validator, watches) {
  return new cljs.core.Atom(state, meta, validator, watches);
};
cljs.core.atom = function cljs$core$atom() {
  var G__16052 = arguments.length;
  switch(G__16052) {
    case 1:
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5360__auto__);
  }
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Atom(x, null, null, null);
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = function(x, p__16053) {
  var map__16054 = p__16053;
  var map__16054__$1 = cljs.core.seq_QMARK_(map__16054) ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map, map__16054) : map__16054;
  var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16054__$1, new cljs.core.Keyword(null, "meta", "meta", 1499536964));
  var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16054__$1, new cljs.core.Keyword(null, "validator", "validator", -1966190681));
  return new cljs.core.Atom(x, meta, validator, null);
};
cljs.core.atom.cljs$lang$applyTo = function(seq16049) {
  var G__16050 = cljs.core.first(seq16049);
  var seq16049__$1 = cljs.core.next(seq16049);
  return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__16050, seq16049__$1);
};
cljs.core.atom.cljs$lang$maxFixedArity = 1;
cljs.core.reset_BANG_ = function cljs$core$reset_BANG_(a, new_value) {
  if (a instanceof cljs.core.Atom) {
    var validate = a.validator;
    if (validate == null) {
    } else {
      if (cljs.core.truth_(function() {
        var G__16058 = new_value;
        return validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__16058) : validate.call(null, G__16058);
      }())) {
      } else {
        throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(function() {
          var G__16059 = cljs.core.list(new cljs.core.Symbol(null, "validate", "validate", 1439230700, null), new cljs.core.Symbol(null, "new-value", "new-value", -1567397401, null));
          return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__16059) : cljs.core.pr_str.call(null, G__16059);
        }())].join(""));
      }
    }
    var old_value = a.state;
    a.state = new_value;
    if (a.watches == null) {
    } else {
      cljs.core._notify_watches(a, old_value, new_value);
    }
    return new_value;
  } else {
    return cljs.core._reset_BANG_(a, new_value);
  }
};
cljs.core.swap_BANG_ = function cljs$core$swap_BANG_() {
  var G__16066 = arguments.length;
  switch(G__16066) {
    case 2:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__16067 = a.state;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16067) : f.call(null, G__16067);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a, f);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__16068 = a.state;
      var G__16069 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16068, G__16069) : f.call(null, G__16068, G__16069);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a, f, x);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__16070 = a.state;
      var G__16071 = x;
      var G__16072 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16070, G__16071, G__16072) : f.call(null, G__16070, G__16071, G__16072);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a, f, x, y);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a, f, x, y, more);
  }
};
cljs.core.swap_BANG_.cljs$lang$applyTo = function(seq16060) {
  var G__16061 = cljs.core.first(seq16060);
  var seq16060__$1 = cljs.core.next(seq16060);
  var G__16062 = cljs.core.first(seq16060__$1);
  var seq16060__$2 = cljs.core.next(seq16060__$1);
  var G__16063 = cljs.core.first(seq16060__$2);
  var seq16060__$3 = cljs.core.next(seq16060__$2);
  var G__16064 = cljs.core.first(seq16060__$3);
  var seq16060__$4 = cljs.core.next(seq16060__$3);
  return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16061, G__16062, G__16063, G__16064, seq16060__$4);
};
cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.compare_and_set_BANG_ = function cljs$core$compare_and_set_BANG_(a, oldval, newval) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null), oldval)) {
    cljs.core.reset_BANG_(a, newval);
    return true;
  } else {
    return false;
  }
};
cljs.core.set_validator_BANG_ = function cljs$core$set_validator_BANG_(iref, val) {
  return iref.validator = val;
};
cljs.core.get_validator = function cljs$core$get_validator(iref) {
  return iref.validator;
};
cljs.core.Volatile = function(state) {
  this.state = state;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;
cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = function(_, new_state) {
  var self__ = this;
  var ___$1 = this;
  return self__.state = new_state;
};
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Volatile.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null)], null);
};
cljs.core.Volatile.cljs$lang$type = true;
cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Volatile");
};
cljs.core.__GT_Volatile = function cljs$core$__GT_Volatile(state) {
  return new cljs.core.Volatile(state);
};
cljs.core.volatile_BANG_ = function cljs$core$volatile_BANG_(val) {
  return new cljs.core.Volatile(val);
};
cljs.core.volatile_QMARK_ = function cljs$core$volatile_QMARK_(x) {
  return x instanceof cljs.core.Volatile;
};
cljs.core.vreset_BANG_ = function cljs$core$vreset_BANG_(vol, newval) {
  return cljs.core._vreset_BANG_(vol, newval);
};
cljs.core.keep_indexed = function cljs$core$keep_indexed() {
  var G__16075 = arguments.length;
  switch(G__16075) {
    case 1:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__16110 = null;
        var G__16110__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__16110__1 = function(result) {
          var G__16076 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__16076) : rf.call(null, G__16076);
        };
        var G__16110__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          var v = function() {
            var G__16077 = i;
            var G__16078 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16077, G__16078) : f.call(null, G__16077, G__16078);
          }();
          if (v == null) {
            return result;
          } else {
            var G__16079 = result;
            var G__16080 = v;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16079, G__16080) : rf.call(null, G__16079, G__16080);
          }
        };
        G__16110 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__16110__0.call(this);
            case 1:
              return G__16110__1.call(this, result);
            case 2:
              return G__16110__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__16110.cljs$core$IFn$_invoke$arity$0 = G__16110__0;
        G__16110.cljs$core$IFn$_invoke$arity$1 = G__16110__1;
        G__16110.cljs$core$IFn$_invoke$arity$2 = G__16110__2;
        return G__16110;
      }();
    }(ia);
  };
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var keepi = function cljs$core$keepi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4425__auto__ = cljs.core.seq(coll__$1);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__5194__auto___16111 = size;
          var i_16112 = 0;
          while (true) {
            if (i_16112 < n__5194__auto___16111) {
              var x_16113 = function() {
                var G__16105 = idx + i_16112;
                var G__16106 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_16112);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16105, G__16106) : f.call(null, G__16105, G__16106);
              }();
              if (x_16113 == null) {
              } else {
                cljs.core.chunk_append(b, x_16113);
              }
              var G__16114 = i_16112 + 1;
              i_16112 = G__16114;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$keepi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          var x = function() {
            var G__16107 = idx;
            var G__16108 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16107, G__16108) : f.call(null, G__16107, G__16108);
          }();
          if (x == null) {
            return cljs$core$keepi(idx + 1, cljs.core.rest(s));
          } else {
            return cljs.core.cons(x, cljs$core$keepi(idx + 1, cljs.core.rest(s)));
          }
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return keepi(0, coll);
};
cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.every_pred = function cljs$core$every_pred() {
  var G__16126 = arguments.length;
  switch(G__16126) {
    case 1:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$ep1 = null;
    var cljs$core$ep1__0 = function() {
      return true;
    };
    var cljs$core$ep1__1 = function(x) {
      return cljs.core.boolean$(function() {
        var G__16142 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16142) : p.call(null, G__16142);
      }());
    };
    var cljs$core$ep1__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__16144 = x;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16144) : p.call(null, G__16144);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var G__16145 = y;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16145) : p.call(null, G__16145);
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep1__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__16147 = x;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16147) : p.call(null, G__16147);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__16149 = y;
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16149) : p.call(null, G__16149);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var G__16150 = z;
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16150) : p.call(null, G__16150);
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep1__4 = function() {
      var G__16312__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4297__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4297__auto__)) {
            return cljs.core.every_QMARK_(p, args);
          } else {
            return and__4297__auto__;
          }
        }());
      };
      var G__16312 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__16313__i = 0, G__16313__a = new Array(arguments.length - 3);
          while (G__16313__i < G__16313__a.length) {
            G__16313__a[G__16313__i] = arguments[G__16313__i + 3];
            ++G__16313__i;
          }
          args = new cljs.core.IndexedSeq(G__16313__a, 0);
        }
        return G__16312__delegate.call(this, x, y, z, args);
      };
      G__16312.cljs$lang$maxFixedArity = 3;
      G__16312.cljs$lang$applyTo = function(arglist__16314) {
        var x = cljs.core.first(arglist__16314);
        arglist__16314 = cljs.core.next(arglist__16314);
        var y = cljs.core.first(arglist__16314);
        arglist__16314 = cljs.core.next(arglist__16314);
        var z = cljs.core.first(arglist__16314);
        var args = cljs.core.rest(arglist__16314);
        return G__16312__delegate(x, y, z, args);
      };
      G__16312.cljs$core$IFn$_invoke$arity$variadic = G__16312__delegate;
      return G__16312;
    }();
    cljs$core$ep1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep1__0.call(this);
        case 1:
          return cljs$core$ep1__1.call(this, x);
        case 2:
          return cljs$core$ep1__2.call(this, x, y);
        case 3:
          return cljs$core$ep1__3.call(this, x, y, z);
        default:
          var G__16315 = null;
          if (arguments.length > 3) {
            var G__16316__i = 0, G__16316__a = new Array(arguments.length - 3);
            while (G__16316__i < G__16316__a.length) {
              G__16316__a[G__16316__i] = arguments[G__16316__i + 3];
              ++G__16316__i;
            }
            G__16315 = new cljs.core.IndexedSeq(G__16316__a, 0);
          }
          return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__16315);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep1.cljs$lang$maxFixedArity = 3;
    cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep1;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$ep2 = null;
    var cljs$core$ep2__0 = function() {
      return true;
    };
    var cljs$core$ep2__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__16182 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16182) : p1.call(null, G__16182);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var G__16183 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16183) : p2.call(null, G__16183);
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep2__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__16185 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16185) : p1.call(null, G__16185);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__16187 = y;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16187) : p1.call(null, G__16187);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__16189 = x;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16189) : p2.call(null, G__16189);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var G__16190 = y;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16190) : p2.call(null, G__16190);
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep2__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__16192 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16192) : p1.call(null, G__16192);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__16194 = y;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16194) : p1.call(null, G__16194);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__16196 = z;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16196) : p1.call(null, G__16196);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var and__4297__auto____$3 = function() {
                var G__16198 = x;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16198) : p2.call(null, G__16198);
              }();
              if (cljs.core.truth_(and__4297__auto____$3)) {
                var and__4297__auto____$4 = function() {
                  var G__16200 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16200) : p2.call(null, G__16200);
                }();
                if (cljs.core.truth_(and__4297__auto____$4)) {
                  var G__16201 = z;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16201) : p2.call(null, G__16201);
                } else {
                  return and__4297__auto____$4;
                }
              } else {
                return and__4297__auto____$3;
              }
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep2__4 = function() {
      var G__16317__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4297__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4297__auto__)) {
            return cljs.core.every_QMARK_(function(and__4297__auto__) {
              return function(p1__16115_SHARP_) {
                var and__4297__auto____$1 = function() {
                  var G__16203 = p1__16115_SHARP_;
                  return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16203) : p1.call(null, G__16203);
                }();
                if (cljs.core.truth_(and__4297__auto____$1)) {
                  var G__16204 = p1__16115_SHARP_;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16204) : p2.call(null, G__16204);
                } else {
                  return and__4297__auto____$1;
                }
              };
            }(and__4297__auto__), args);
          } else {
            return and__4297__auto__;
          }
        }());
      };
      var G__16317 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__16318__i = 0, G__16318__a = new Array(arguments.length - 3);
          while (G__16318__i < G__16318__a.length) {
            G__16318__a[G__16318__i] = arguments[G__16318__i + 3];
            ++G__16318__i;
          }
          args = new cljs.core.IndexedSeq(G__16318__a, 0);
        }
        return G__16317__delegate.call(this, x, y, z, args);
      };
      G__16317.cljs$lang$maxFixedArity = 3;
      G__16317.cljs$lang$applyTo = function(arglist__16319) {
        var x = cljs.core.first(arglist__16319);
        arglist__16319 = cljs.core.next(arglist__16319);
        var y = cljs.core.first(arglist__16319);
        arglist__16319 = cljs.core.next(arglist__16319);
        var z = cljs.core.first(arglist__16319);
        var args = cljs.core.rest(arglist__16319);
        return G__16317__delegate(x, y, z, args);
      };
      G__16317.cljs$core$IFn$_invoke$arity$variadic = G__16317__delegate;
      return G__16317;
    }();
    cljs$core$ep2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep2__0.call(this);
        case 1:
          return cljs$core$ep2__1.call(this, x);
        case 2:
          return cljs$core$ep2__2.call(this, x, y);
        case 3:
          return cljs$core$ep2__3.call(this, x, y, z);
        default:
          var G__16320 = null;
          if (arguments.length > 3) {
            var G__16321__i = 0, G__16321__a = new Array(arguments.length - 3);
            while (G__16321__i < G__16321__a.length) {
              G__16321__a[G__16321__i] = arguments[G__16321__i + 3];
              ++G__16321__i;
            }
            G__16320 = new cljs.core.IndexedSeq(G__16321__a, 0);
          }
          return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__16320);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep2.cljs$lang$maxFixedArity = 3;
    cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep2;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$ep3 = null;
    var cljs$core$ep3__0 = function() {
      return true;
    };
    var cljs$core$ep3__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__16250 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16250) : p1.call(null, G__16250);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__16252 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16252) : p2.call(null, G__16252);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var G__16253 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16253) : p3.call(null, G__16253);
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep3__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__16255 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16255) : p1.call(null, G__16255);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__16257 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16257) : p2.call(null, G__16257);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__16259 = x;
              return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16259) : p3.call(null, G__16259);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var and__4297__auto____$3 = function() {
                var G__16261 = y;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16261) : p1.call(null, G__16261);
              }();
              if (cljs.core.truth_(and__4297__auto____$3)) {
                var and__4297__auto____$4 = function() {
                  var G__16263 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16263) : p2.call(null, G__16263);
                }();
                if (cljs.core.truth_(and__4297__auto____$4)) {
                  var G__16264 = y;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16264) : p3.call(null, G__16264);
                } else {
                  return and__4297__auto____$4;
                }
              } else {
                return and__4297__auto____$3;
              }
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep3__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__16266 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16266) : p1.call(null, G__16266);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__16268 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16268) : p2.call(null, G__16268);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__16270 = x;
              return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16270) : p3.call(null, G__16270);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var and__4297__auto____$3 = function() {
                var G__16272 = y;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16272) : p1.call(null, G__16272);
              }();
              if (cljs.core.truth_(and__4297__auto____$3)) {
                var and__4297__auto____$4 = function() {
                  var G__16274 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16274) : p2.call(null, G__16274);
                }();
                if (cljs.core.truth_(and__4297__auto____$4)) {
                  var and__4297__auto____$5 = function() {
                    var G__16276 = y;
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16276) : p3.call(null, G__16276);
                  }();
                  if (cljs.core.truth_(and__4297__auto____$5)) {
                    var and__4297__auto____$6 = function() {
                      var G__16278 = z;
                      return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16278) : p1.call(null, G__16278);
                    }();
                    if (cljs.core.truth_(and__4297__auto____$6)) {
                      var and__4297__auto____$7 = function() {
                        var G__16280 = z;
                        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16280) : p2.call(null, G__16280);
                      }();
                      if (cljs.core.truth_(and__4297__auto____$7)) {
                        var G__16281 = z;
                        return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16281) : p3.call(null, G__16281);
                      } else {
                        return and__4297__auto____$7;
                      }
                    } else {
                      return and__4297__auto____$6;
                    }
                  } else {
                    return and__4297__auto____$5;
                  }
                } else {
                  return and__4297__auto____$4;
                }
              } else {
                return and__4297__auto____$3;
              }
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep3__4 = function() {
      var G__16322__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4297__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4297__auto__)) {
            return cljs.core.every_QMARK_(function(and__4297__auto__) {
              return function(p1__16116_SHARP_) {
                var and__4297__auto____$1 = function() {
                  var G__16283 = p1__16116_SHARP_;
                  return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16283) : p1.call(null, G__16283);
                }();
                if (cljs.core.truth_(and__4297__auto____$1)) {
                  var and__4297__auto____$2 = function() {
                    var G__16285 = p1__16116_SHARP_;
                    return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16285) : p2.call(null, G__16285);
                  }();
                  if (cljs.core.truth_(and__4297__auto____$2)) {
                    var G__16286 = p1__16116_SHARP_;
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16286) : p3.call(null, G__16286);
                  } else {
                    return and__4297__auto____$2;
                  }
                } else {
                  return and__4297__auto____$1;
                }
              };
            }(and__4297__auto__), args);
          } else {
            return and__4297__auto__;
          }
        }());
      };
      var G__16322 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__16323__i = 0, G__16323__a = new Array(arguments.length - 3);
          while (G__16323__i < G__16323__a.length) {
            G__16323__a[G__16323__i] = arguments[G__16323__i + 3];
            ++G__16323__i;
          }
          args = new cljs.core.IndexedSeq(G__16323__a, 0);
        }
        return G__16322__delegate.call(this, x, y, z, args);
      };
      G__16322.cljs$lang$maxFixedArity = 3;
      G__16322.cljs$lang$applyTo = function(arglist__16324) {
        var x = cljs.core.first(arglist__16324);
        arglist__16324 = cljs.core.next(arglist__16324);
        var y = cljs.core.first(arglist__16324);
        arglist__16324 = cljs.core.next(arglist__16324);
        var z = cljs.core.first(arglist__16324);
        var args = cljs.core.rest(arglist__16324);
        return G__16322__delegate(x, y, z, args);
      };
      G__16322.cljs$core$IFn$_invoke$arity$variadic = G__16322__delegate;
      return G__16322;
    }();
    cljs$core$ep3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep3__0.call(this);
        case 1:
          return cljs$core$ep3__1.call(this, x);
        case 2:
          return cljs$core$ep3__2.call(this, x, y);
        case 3:
          return cljs$core$ep3__3.call(this, x, y, z);
        default:
          var G__16325 = null;
          if (arguments.length > 3) {
            var G__16326__i = 0, G__16326__a = new Array(arguments.length - 3);
            while (G__16326__i < G__16326__a.length) {
              G__16326__a[G__16326__i] = arguments[G__16326__i + 3];
              ++G__16326__i;
            }
            G__16325 = new cljs.core.IndexedSeq(G__16326__a, 0);
          }
          return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__16325);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep3.cljs$lang$maxFixedArity = 3;
    cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep3;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$epn = null;
      var cljs$core$epn__0 = function() {
        return true;
      };
      var cljs$core$epn__1 = function(x) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__16117_SHARP_) {
            var G__16302 = x;
            return p1__16117_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16117_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16302) : p1__16117_SHARP_.call(null, G__16302);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__2 = function(x, y) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__16118_SHARP_) {
            var and__4297__auto__ = function() {
              var G__16304 = x;
              return p1__16118_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16118_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16304) : p1__16118_SHARP_.call(null, G__16304);
            }();
            if (cljs.core.truth_(and__4297__auto__)) {
              var G__16305 = y;
              return p1__16118_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16118_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16305) : p1__16118_SHARP_.call(null, G__16305);
            } else {
              return and__4297__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__3 = function(x, y, z) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__16119_SHARP_) {
            var and__4297__auto__ = function() {
              var G__16307 = x;
              return p1__16119_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16119_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16307) : p1__16119_SHARP_.call(null, G__16307);
            }();
            if (cljs.core.truth_(and__4297__auto__)) {
              var and__4297__auto____$1 = function() {
                var G__16309 = y;
                return p1__16119_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16119_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16309) : p1__16119_SHARP_.call(null, G__16309);
              }();
              if (cljs.core.truth_(and__4297__auto____$1)) {
                var G__16310 = z;
                return p1__16119_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16119_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16310) : p1__16119_SHARP_.call(null, G__16310);
              } else {
                return and__4297__auto____$1;
              }
            } else {
              return and__4297__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__4 = function() {
        var G__16327__delegate = function(x, y, z, args) {
          return cljs.core.boolean$(function() {
            var and__4297__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x, y, z);
            if (cljs.core.truth_(and__4297__auto__)) {
              return cljs.core.every_QMARK_(function(and__4297__auto__, ps__$1) {
                return function(p1__16120_SHARP_) {
                  return cljs.core.every_QMARK_(p1__16120_SHARP_, args);
                };
              }(and__4297__auto__, ps__$1), ps__$1);
            } else {
              return and__4297__auto__;
            }
          }());
        };
        var G__16327 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__16328__i = 0, G__16328__a = new Array(arguments.length - 3);
            while (G__16328__i < G__16328__a.length) {
              G__16328__a[G__16328__i] = arguments[G__16328__i + 3];
              ++G__16328__i;
            }
            args = new cljs.core.IndexedSeq(G__16328__a, 0);
          }
          return G__16327__delegate.call(this, x, y, z, args);
        };
        G__16327.cljs$lang$maxFixedArity = 3;
        G__16327.cljs$lang$applyTo = function(arglist__16329) {
          var x = cljs.core.first(arglist__16329);
          arglist__16329 = cljs.core.next(arglist__16329);
          var y = cljs.core.first(arglist__16329);
          arglist__16329 = cljs.core.next(arglist__16329);
          var z = cljs.core.first(arglist__16329);
          var args = cljs.core.rest(arglist__16329);
          return G__16327__delegate(x, y, z, args);
        };
        G__16327.cljs$core$IFn$_invoke$arity$variadic = G__16327__delegate;
        return G__16327;
      }();
      cljs$core$epn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$epn__0.call(this);
          case 1:
            return cljs$core$epn__1.call(this, x);
          case 2:
            return cljs$core$epn__2.call(this, x, y);
          case 3:
            return cljs$core$epn__3.call(this, x, y, z);
          default:
            var G__16330 = null;
            if (arguments.length > 3) {
              var G__16331__i = 0, G__16331__a = new Array(arguments.length - 3);
              while (G__16331__i < G__16331__a.length) {
                G__16331__a[G__16331__i] = arguments[G__16331__i + 3];
                ++G__16331__i;
              }
              G__16330 = new cljs.core.IndexedSeq(G__16331__a, 0);
            }
            return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__16330);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$epn.cljs$lang$maxFixedArity = 3;
      cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$epn;
    }();
  }(ps__$1);
};
cljs.core.every_pred.cljs$lang$applyTo = function(seq16121) {
  var G__16122 = cljs.core.first(seq16121);
  var seq16121__$1 = cljs.core.next(seq16121);
  var G__16123 = cljs.core.first(seq16121__$1);
  var seq16121__$2 = cljs.core.next(seq16121__$1);
  var G__16124 = cljs.core.first(seq16121__$2);
  var seq16121__$3 = cljs.core.next(seq16121__$2);
  return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__16122, G__16123, G__16124, seq16121__$3);
};
cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
cljs.core.some_fn = function cljs$core$some_fn() {
  var G__16343 = arguments.length;
  switch(G__16343) {
    case 1:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$sp1 = null;
    var cljs$core$sp1__0 = function() {
      return null;
    };
    var cljs$core$sp1__1 = function(x) {
      var G__16359 = x;
      return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16359) : p.call(null, G__16359);
    };
    var cljs$core$sp1__2 = function(x, y) {
      var or__4309__auto__ = function() {
        var G__16361 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16361) : p.call(null, G__16361);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var G__16362 = y;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16362) : p.call(null, G__16362);
      }
    };
    var cljs$core$sp1__3 = function(x, y, z) {
      var or__4309__auto__ = function() {
        var G__16364 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16364) : p.call(null, G__16364);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__16366 = y;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16366) : p.call(null, G__16366);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var G__16367 = z;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__16367) : p.call(null, G__16367);
        }
      }
    };
    var cljs$core$sp1__4 = function() {
      var G__16529__delegate = function(x, y, z, args) {
        var or__4309__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.some(p, args);
        }
      };
      var G__16529 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__16530__i = 0, G__16530__a = new Array(arguments.length - 3);
          while (G__16530__i < G__16530__a.length) {
            G__16530__a[G__16530__i] = arguments[G__16530__i + 3];
            ++G__16530__i;
          }
          args = new cljs.core.IndexedSeq(G__16530__a, 0);
        }
        return G__16529__delegate.call(this, x, y, z, args);
      };
      G__16529.cljs$lang$maxFixedArity = 3;
      G__16529.cljs$lang$applyTo = function(arglist__16531) {
        var x = cljs.core.first(arglist__16531);
        arglist__16531 = cljs.core.next(arglist__16531);
        var y = cljs.core.first(arglist__16531);
        arglist__16531 = cljs.core.next(arglist__16531);
        var z = cljs.core.first(arglist__16531);
        var args = cljs.core.rest(arglist__16531);
        return G__16529__delegate(x, y, z, args);
      };
      G__16529.cljs$core$IFn$_invoke$arity$variadic = G__16529__delegate;
      return G__16529;
    }();
    cljs$core$sp1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp1__0.call(this);
        case 1:
          return cljs$core$sp1__1.call(this, x);
        case 2:
          return cljs$core$sp1__2.call(this, x, y);
        case 3:
          return cljs$core$sp1__3.call(this, x, y, z);
        default:
          var G__16532 = null;
          if (arguments.length > 3) {
            var G__16533__i = 0, G__16533__a = new Array(arguments.length - 3);
            while (G__16533__i < G__16533__a.length) {
              G__16533__a[G__16533__i] = arguments[G__16533__i + 3];
              ++G__16533__i;
            }
            G__16532 = new cljs.core.IndexedSeq(G__16533__a, 0);
          }
          return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__16532);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp1.cljs$lang$maxFixedArity = 3;
    cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp1;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$sp2 = null;
    var cljs$core$sp2__0 = function() {
      return null;
    };
    var cljs$core$sp2__1 = function(x) {
      var or__4309__auto__ = function() {
        var G__16399 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16399) : p1.call(null, G__16399);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var G__16400 = x;
        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16400) : p2.call(null, G__16400);
      }
    };
    var cljs$core$sp2__2 = function(x, y) {
      var or__4309__auto__ = function() {
        var G__16402 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16402) : p1.call(null, G__16402);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__16404 = y;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16404) : p1.call(null, G__16404);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__16406 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16406) : p2.call(null, G__16406);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var G__16407 = y;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16407) : p2.call(null, G__16407);
          }
        }
      }
    };
    var cljs$core$sp2__3 = function(x, y, z) {
      var or__4309__auto__ = function() {
        var G__16409 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16409) : p1.call(null, G__16409);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__16411 = y;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16411) : p1.call(null, G__16411);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__16413 = z;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16413) : p1.call(null, G__16413);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var or__4309__auto____$3 = function() {
              var G__16415 = x;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16415) : p2.call(null, G__16415);
            }();
            if (cljs.core.truth_(or__4309__auto____$3)) {
              return or__4309__auto____$3;
            } else {
              var or__4309__auto____$4 = function() {
                var G__16417 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16417) : p2.call(null, G__16417);
              }();
              if (cljs.core.truth_(or__4309__auto____$4)) {
                return or__4309__auto____$4;
              } else {
                var G__16418 = z;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16418) : p2.call(null, G__16418);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp2__4 = function() {
      var G__16534__delegate = function(x, y, z, args) {
        var or__4309__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.some(function(or__4309__auto__) {
            return function(p1__16332_SHARP_) {
              var or__4309__auto____$1 = function() {
                var G__16420 = p1__16332_SHARP_;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16420) : p1.call(null, G__16420);
              }();
              if (cljs.core.truth_(or__4309__auto____$1)) {
                return or__4309__auto____$1;
              } else {
                var G__16421 = p1__16332_SHARP_;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16421) : p2.call(null, G__16421);
              }
            };
          }(or__4309__auto__), args);
        }
      };
      var G__16534 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__16535__i = 0, G__16535__a = new Array(arguments.length - 3);
          while (G__16535__i < G__16535__a.length) {
            G__16535__a[G__16535__i] = arguments[G__16535__i + 3];
            ++G__16535__i;
          }
          args = new cljs.core.IndexedSeq(G__16535__a, 0);
        }
        return G__16534__delegate.call(this, x, y, z, args);
      };
      G__16534.cljs$lang$maxFixedArity = 3;
      G__16534.cljs$lang$applyTo = function(arglist__16536) {
        var x = cljs.core.first(arglist__16536);
        arglist__16536 = cljs.core.next(arglist__16536);
        var y = cljs.core.first(arglist__16536);
        arglist__16536 = cljs.core.next(arglist__16536);
        var z = cljs.core.first(arglist__16536);
        var args = cljs.core.rest(arglist__16536);
        return G__16534__delegate(x, y, z, args);
      };
      G__16534.cljs$core$IFn$_invoke$arity$variadic = G__16534__delegate;
      return G__16534;
    }();
    cljs$core$sp2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp2__0.call(this);
        case 1:
          return cljs$core$sp2__1.call(this, x);
        case 2:
          return cljs$core$sp2__2.call(this, x, y);
        case 3:
          return cljs$core$sp2__3.call(this, x, y, z);
        default:
          var G__16537 = null;
          if (arguments.length > 3) {
            var G__16538__i = 0, G__16538__a = new Array(arguments.length - 3);
            while (G__16538__i < G__16538__a.length) {
              G__16538__a[G__16538__i] = arguments[G__16538__i + 3];
              ++G__16538__i;
            }
            G__16537 = new cljs.core.IndexedSeq(G__16538__a, 0);
          }
          return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__16537);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp2.cljs$lang$maxFixedArity = 3;
    cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp2;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$sp3 = null;
    var cljs$core$sp3__0 = function() {
      return null;
    };
    var cljs$core$sp3__1 = function(x) {
      var or__4309__auto__ = function() {
        var G__16467 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16467) : p1.call(null, G__16467);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__16469 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16469) : p2.call(null, G__16469);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var G__16470 = x;
          return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16470) : p3.call(null, G__16470);
        }
      }
    };
    var cljs$core$sp3__2 = function(x, y) {
      var or__4309__auto__ = function() {
        var G__16472 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16472) : p1.call(null, G__16472);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__16474 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16474) : p2.call(null, G__16474);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__16476 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16476) : p3.call(null, G__16476);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var or__4309__auto____$3 = function() {
              var G__16478 = y;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16478) : p1.call(null, G__16478);
            }();
            if (cljs.core.truth_(or__4309__auto____$3)) {
              return or__4309__auto____$3;
            } else {
              var or__4309__auto____$4 = function() {
                var G__16480 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16480) : p2.call(null, G__16480);
              }();
              if (cljs.core.truth_(or__4309__auto____$4)) {
                return or__4309__auto____$4;
              } else {
                var G__16481 = y;
                return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16481) : p3.call(null, G__16481);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__3 = function(x, y, z) {
      var or__4309__auto__ = function() {
        var G__16483 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16483) : p1.call(null, G__16483);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__16485 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16485) : p2.call(null, G__16485);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__16487 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16487) : p3.call(null, G__16487);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var or__4309__auto____$3 = function() {
              var G__16489 = y;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16489) : p1.call(null, G__16489);
            }();
            if (cljs.core.truth_(or__4309__auto____$3)) {
              return or__4309__auto____$3;
            } else {
              var or__4309__auto____$4 = function() {
                var G__16491 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16491) : p2.call(null, G__16491);
              }();
              if (cljs.core.truth_(or__4309__auto____$4)) {
                return or__4309__auto____$4;
              } else {
                var or__4309__auto____$5 = function() {
                  var G__16493 = y;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16493) : p3.call(null, G__16493);
                }();
                if (cljs.core.truth_(or__4309__auto____$5)) {
                  return or__4309__auto____$5;
                } else {
                  var or__4309__auto____$6 = function() {
                    var G__16495 = z;
                    return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16495) : p1.call(null, G__16495);
                  }();
                  if (cljs.core.truth_(or__4309__auto____$6)) {
                    return or__4309__auto____$6;
                  } else {
                    var or__4309__auto____$7 = function() {
                      var G__16497 = z;
                      return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16497) : p2.call(null, G__16497);
                    }();
                    if (cljs.core.truth_(or__4309__auto____$7)) {
                      return or__4309__auto____$7;
                    } else {
                      var G__16498 = z;
                      return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16498) : p3.call(null, G__16498);
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__4 = function() {
      var G__16539__delegate = function(x, y, z, args) {
        var or__4309__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.some(function(or__4309__auto__) {
            return function(p1__16333_SHARP_) {
              var or__4309__auto____$1 = function() {
                var G__16500 = p1__16333_SHARP_;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__16500) : p1.call(null, G__16500);
              }();
              if (cljs.core.truth_(or__4309__auto____$1)) {
                return or__4309__auto____$1;
              } else {
                var or__4309__auto____$2 = function() {
                  var G__16502 = p1__16333_SHARP_;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__16502) : p2.call(null, G__16502);
                }();
                if (cljs.core.truth_(or__4309__auto____$2)) {
                  return or__4309__auto____$2;
                } else {
                  var G__16503 = p1__16333_SHARP_;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__16503) : p3.call(null, G__16503);
                }
              }
            };
          }(or__4309__auto__), args);
        }
      };
      var G__16539 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__16540__i = 0, G__16540__a = new Array(arguments.length - 3);
          while (G__16540__i < G__16540__a.length) {
            G__16540__a[G__16540__i] = arguments[G__16540__i + 3];
            ++G__16540__i;
          }
          args = new cljs.core.IndexedSeq(G__16540__a, 0);
        }
        return G__16539__delegate.call(this, x, y, z, args);
      };
      G__16539.cljs$lang$maxFixedArity = 3;
      G__16539.cljs$lang$applyTo = function(arglist__16541) {
        var x = cljs.core.first(arglist__16541);
        arglist__16541 = cljs.core.next(arglist__16541);
        var y = cljs.core.first(arglist__16541);
        arglist__16541 = cljs.core.next(arglist__16541);
        var z = cljs.core.first(arglist__16541);
        var args = cljs.core.rest(arglist__16541);
        return G__16539__delegate(x, y, z, args);
      };
      G__16539.cljs$core$IFn$_invoke$arity$variadic = G__16539__delegate;
      return G__16539;
    }();
    cljs$core$sp3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp3__0.call(this);
        case 1:
          return cljs$core$sp3__1.call(this, x);
        case 2:
          return cljs$core$sp3__2.call(this, x, y);
        case 3:
          return cljs$core$sp3__3.call(this, x, y, z);
        default:
          var G__16542 = null;
          if (arguments.length > 3) {
            var G__16543__i = 0, G__16543__a = new Array(arguments.length - 3);
            while (G__16543__i < G__16543__a.length) {
              G__16543__a[G__16543__i] = arguments[G__16543__i + 3];
              ++G__16543__i;
            }
            G__16542 = new cljs.core.IndexedSeq(G__16543__a, 0);
          }
          return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__16542);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp3.cljs$lang$maxFixedArity = 3;
    cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp3;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$spn = null;
      var cljs$core$spn__0 = function() {
        return null;
      };
      var cljs$core$spn__1 = function(x) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__16334_SHARP_) {
            var G__16519 = x;
            return p1__16334_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16334_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16519) : p1__16334_SHARP_.call(null, G__16519);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__2 = function(x, y) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__16335_SHARP_) {
            var or__4309__auto__ = function() {
              var G__16521 = x;
              return p1__16335_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16335_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16521) : p1__16335_SHARP_.call(null, G__16521);
            }();
            if (cljs.core.truth_(or__4309__auto__)) {
              return or__4309__auto__;
            } else {
              var G__16522 = y;
              return p1__16335_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16335_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16522) : p1__16335_SHARP_.call(null, G__16522);
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__3 = function(x, y, z) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__16336_SHARP_) {
            var or__4309__auto__ = function() {
              var G__16524 = x;
              return p1__16336_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16336_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16524) : p1__16336_SHARP_.call(null, G__16524);
            }();
            if (cljs.core.truth_(or__4309__auto__)) {
              return or__4309__auto__;
            } else {
              var or__4309__auto____$1 = function() {
                var G__16526 = y;
                return p1__16336_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16336_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16526) : p1__16336_SHARP_.call(null, G__16526);
              }();
              if (cljs.core.truth_(or__4309__auto____$1)) {
                return or__4309__auto____$1;
              } else {
                var G__16527 = z;
                return p1__16336_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16336_SHARP_.cljs$core$IFn$_invoke$arity$1(G__16527) : p1__16336_SHARP_.call(null, G__16527);
              }
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__4 = function() {
        var G__16544__delegate = function(x, y, z, args) {
          var or__4309__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(or__4309__auto__)) {
            return or__4309__auto__;
          } else {
            return cljs.core.some(function(or__4309__auto__, ps__$1) {
              return function(p1__16337_SHARP_) {
                return cljs.core.some(p1__16337_SHARP_, args);
              };
            }(or__4309__auto__, ps__$1), ps__$1);
          }
        };
        var G__16544 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__16545__i = 0, G__16545__a = new Array(arguments.length - 3);
            while (G__16545__i < G__16545__a.length) {
              G__16545__a[G__16545__i] = arguments[G__16545__i + 3];
              ++G__16545__i;
            }
            args = new cljs.core.IndexedSeq(G__16545__a, 0);
          }
          return G__16544__delegate.call(this, x, y, z, args);
        };
        G__16544.cljs$lang$maxFixedArity = 3;
        G__16544.cljs$lang$applyTo = function(arglist__16546) {
          var x = cljs.core.first(arglist__16546);
          arglist__16546 = cljs.core.next(arglist__16546);
          var y = cljs.core.first(arglist__16546);
          arglist__16546 = cljs.core.next(arglist__16546);
          var z = cljs.core.first(arglist__16546);
          var args = cljs.core.rest(arglist__16546);
          return G__16544__delegate(x, y, z, args);
        };
        G__16544.cljs$core$IFn$_invoke$arity$variadic = G__16544__delegate;
        return G__16544;
      }();
      cljs$core$spn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$spn__0.call(this);
          case 1:
            return cljs$core$spn__1.call(this, x);
          case 2:
            return cljs$core$spn__2.call(this, x, y);
          case 3:
            return cljs$core$spn__3.call(this, x, y, z);
          default:
            var G__16547 = null;
            if (arguments.length > 3) {
              var G__16548__i = 0, G__16548__a = new Array(arguments.length - 3);
              while (G__16548__i < G__16548__a.length) {
                G__16548__a[G__16548__i] = arguments[G__16548__i + 3];
                ++G__16548__i;
              }
              G__16547 = new cljs.core.IndexedSeq(G__16548__a, 0);
            }
            return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__16547);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$spn.cljs$lang$maxFixedArity = 3;
      cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$spn;
    }();
  }(ps__$1);
};
cljs.core.some_fn.cljs$lang$applyTo = function(seq16338) {
  var G__16339 = cljs.core.first(seq16338);
  var seq16338__$1 = cljs.core.next(seq16338);
  var G__16340 = cljs.core.first(seq16338__$1);
  var seq16338__$2 = cljs.core.next(seq16338__$1);
  var G__16341 = cljs.core.first(seq16338__$2);
  var seq16338__$3 = cljs.core.next(seq16338__$2);
  return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__16339, G__16340, G__16341, seq16338__$3);
};
cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
cljs.core.map = function cljs$core$map() {
  var G__16556 = arguments.length;
  switch(G__16556) {
    case 1:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.map.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__16572 = null;
      var G__16572__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__16572__1 = function(result) {
        var G__16557 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__16557) : rf.call(null, G__16557);
      };
      var G__16572__2 = function(result, input) {
        var G__16558 = result;
        var G__16559 = function() {
          var G__16560 = input;
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16560) : f.call(null, G__16560);
        }();
        return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16558, G__16559) : rf.call(null, G__16558, G__16559);
      };
      var G__16572__3 = function() {
        var G__16573__delegate = function(result, input, inputs) {
          var G__16561 = result;
          var G__16562 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f, input, inputs);
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16561, G__16562) : rf.call(null, G__16561, G__16562);
        };
        var G__16573 = function(result, input, var_args) {
          var inputs = null;
          if (arguments.length > 2) {
            var G__16574__i = 0, G__16574__a = new Array(arguments.length - 2);
            while (G__16574__i < G__16574__a.length) {
              G__16574__a[G__16574__i] = arguments[G__16574__i + 2];
              ++G__16574__i;
            }
            inputs = new cljs.core.IndexedSeq(G__16574__a, 0);
          }
          return G__16573__delegate.call(this, result, input, inputs);
        };
        G__16573.cljs$lang$maxFixedArity = 2;
        G__16573.cljs$lang$applyTo = function(arglist__16575) {
          var result = cljs.core.first(arglist__16575);
          arglist__16575 = cljs.core.next(arglist__16575);
          var input = cljs.core.first(arglist__16575);
          var inputs = cljs.core.rest(arglist__16575);
          return G__16573__delegate(result, input, inputs);
        };
        G__16573.cljs$core$IFn$_invoke$arity$variadic = G__16573__delegate;
        return G__16573;
      }();
      G__16572 = function(result, input, var_args) {
        var inputs = var_args;
        switch(arguments.length) {
          case 0:
            return G__16572__0.call(this);
          case 1:
            return G__16572__1.call(this, result);
          case 2:
            return G__16572__2.call(this, result, input);
          default:
            var G__16576 = null;
            if (arguments.length > 2) {
              var G__16577__i = 0, G__16577__a = new Array(arguments.length - 2);
              while (G__16577__i < G__16577__a.length) {
                G__16577__a[G__16577__i] = arguments[G__16577__i + 2];
                ++G__16577__i;
              }
              G__16576 = new cljs.core.IndexedSeq(G__16577__a, 0);
            }
            return G__16572__3.cljs$core$IFn$_invoke$arity$variadic(result, input, G__16576);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__16572.cljs$lang$maxFixedArity = 2;
      G__16572.cljs$lang$applyTo = G__16572__3.cljs$lang$applyTo;
      G__16572.cljs$core$IFn$_invoke$arity$0 = G__16572__0;
      G__16572.cljs$core$IFn$_invoke$arity$1 = G__16572__1;
      G__16572.cljs$core$IFn$_invoke$arity$2 = G__16572__2;
      G__16572.cljs$core$IFn$_invoke$arity$variadic = G__16572__3.cljs$core$IFn$_invoke$arity$variadic;
      return G__16572;
    }();
  };
};
cljs.core.map.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5194__auto___16578 = size;
        var i_16579 = 0;
        while (true) {
          if (i_16579 < n__5194__auto___16578) {
            cljs.core.chunk_append(b, function() {
              var G__16563 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_16579);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16563) : f.call(null, G__16563);
            }());
            var G__16580 = i_16579 + 1;
            i_16579 = G__16580;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        return cljs.core.cons(function() {
          var G__16564 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16564) : f.call(null, G__16564);
        }(), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(function() {
        var G__16565 = cljs.core.first(s1);
        var G__16566 = cljs.core.first(s2);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16565, G__16566) : f.call(null, G__16565, G__16566);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, cljs.core.rest(s1), cljs.core.rest(s2)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    var s3 = cljs.core.seq(c3);
    if (s1 && s2 && s3) {
      return cljs.core.cons(function() {
        var G__16567 = cljs.core.first(s1);
        var G__16568 = cljs.core.first(s2);
        var G__16569 = cljs.core.first(s3);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16567, G__16568, G__16569) : f.call(null, G__16567, G__16568, G__16569);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, cljs.core.rest(s1), cljs.core.rest(s2), cljs.core.rest(s3)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  var step = function cljs$core$step(cs) {
    return new cljs.core.LazySeq(null, function() {
      var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cs);
      if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
        return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
      } else {
        return null;
      }
    }, null, null);
  };
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step) {
    return function(p1__16549_SHARP_) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f, p1__16549_SHARP_);
    };
  }(step), step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c3, cljs.core.array_seq([c2, c1], 0))));
};
cljs.core.map.cljs$lang$applyTo = function(seq16550) {
  var G__16551 = cljs.core.first(seq16550);
  var seq16550__$1 = cljs.core.next(seq16550);
  var G__16552 = cljs.core.first(seq16550__$1);
  var seq16550__$2 = cljs.core.next(seq16550__$1);
  var G__16553 = cljs.core.first(seq16550__$2);
  var seq16550__$3 = cljs.core.next(seq16550__$2);
  var G__16554 = cljs.core.first(seq16550__$3);
  var seq16550__$4 = cljs.core.next(seq16550__$3);
  return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__16551, G__16552, G__16553, G__16554, seq16550__$4);
};
cljs.core.map.cljs$lang$maxFixedArity = 4;
cljs.core.take = function cljs$core$take() {
  var G__16582 = arguments.length;
  switch(G__16582) {
    case 1:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__16587 = null;
        var G__16587__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__16587__1 = function(result) {
          var G__16583 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__16583) : rf.call(null, G__16583);
        };
        var G__16587__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          var nn = cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          var result__$1 = n__$1 > 0 ? function() {
            var G__16584 = result;
            var G__16585 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16584, G__16585) : rf.call(null, G__16584, G__16585);
          }() : result;
          if (!(nn > 0)) {
            return cljs.core.ensure_reduced(result__$1);
          } else {
            return result__$1;
          }
        };
        G__16587 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__16587__0.call(this);
            case 1:
              return G__16587__1.call(this, result);
            case 2:
              return G__16587__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__16587.cljs$core$IFn$_invoke$arity$0 = G__16587__0;
        G__16587.cljs$core$IFn$_invoke$arity$1 = G__16587__1;
        G__16587.cljs$core$IFn$_invoke$arity$2 = G__16587__2;
        return G__16587;
      }();
    }(na);
  };
};
cljs.core.take.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return new cljs.core.LazySeq(null, function() {
    if (n > 0) {
      var temp__4425__auto__ = cljs.core.seq(coll);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        return cljs.core.cons(cljs.core.first(s), cljs.core.take.cljs$core$IFn$_invoke$arity$2(n - 1, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take.cljs$lang$maxFixedArity = 2;
cljs.core.drop = function cljs$core$drop() {
  var G__16589 = arguments.length;
  switch(G__16589) {
    case 1:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__16594 = null;
        var G__16594__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__16594__1 = function(result) {
          var G__16590 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__16590) : rf.call(null, G__16590);
        };
        var G__16594__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          if (n__$1 > 0) {
            return result;
          } else {
            var G__16591 = result;
            var G__16592 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16591, G__16592) : rf.call(null, G__16591, G__16592);
          }
        };
        G__16594 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__16594__0.call(this);
            case 1:
              return G__16594__1.call(this, result);
            case 2:
              return G__16594__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__16594.cljs$core$IFn$_invoke$arity$0 = G__16594__0;
        G__16594.cljs$core$IFn$_invoke$arity$1 = G__16594__1;
        G__16594.cljs$core$IFn$_invoke$arity$2 = G__16594__2;
        return G__16594;
      }();
    }(na);
  };
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  var step = function(n__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (n__$1 > 0 && s) {
        var G__16595 = n__$1 - 1;
        var G__16596 = cljs.core.rest(s);
        n__$1 = G__16595;
        coll__$1 = G__16596;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(n, coll);
    };
  }(step), null, null);
};
cljs.core.drop.cljs$lang$maxFixedArity = 2;
cljs.core.drop_last = function cljs$core$drop_last() {
  var G__16598 = arguments.length;
  switch(G__16598) {
    case 1:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = function(s) {
  return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1, s);
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = function(n, s) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x, _) {
    return x;
  }, s, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s));
};
cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
cljs.core.take_last = function cljs$core$take_last(n, coll) {
  var s = cljs.core.seq(coll);
  var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll));
  while (true) {
    if (lead) {
      var G__16600 = cljs.core.next(s);
      var G__16601 = cljs.core.next(lead);
      s = G__16600;
      lead = G__16601;
      continue;
    } else {
      return s;
    }
    break;
  }
};
cljs.core.drop_while = function cljs$core$drop_while() {
  var G__16603 = arguments.length;
  switch(G__16603) {
    case 1:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    var da = cljs.core.volatile_BANG_(true);
    return function(da) {
      return function() {
        var G__16611 = null;
        var G__16611__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__16611__1 = function(result) {
          var G__16604 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__16604) : rf.call(null, G__16604);
        };
        var G__16611__2 = function(result, input) {
          var drop_QMARK_ = cljs.core.deref(da);
          if (cljs.core.truth_(function() {
            var and__4297__auto__ = drop_QMARK_;
            if (cljs.core.truth_(and__4297__auto__)) {
              var G__16605 = input;
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16605) : pred.call(null, G__16605);
            } else {
              return and__4297__auto__;
            }
          }())) {
            return result;
          } else {
            cljs.core.vreset_BANG_(da, null);
            var G__16606 = result;
            var G__16607 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16606, G__16607) : rf.call(null, G__16606, G__16607);
          }
        };
        G__16611 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__16611__0.call(this);
            case 1:
              return G__16611__1.call(this, result);
            case 2:
              return G__16611__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__16611.cljs$core$IFn$_invoke$arity$0 = G__16611__0;
        G__16611.cljs$core$IFn$_invoke$arity$1 = G__16611__1;
        G__16611.cljs$core$IFn$_invoke$arity$2 = G__16611__2;
        return G__16611;
      }();
    }(da);
  };
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  var step = function(pred__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (cljs.core.truth_(function() {
        var and__4297__auto__ = s;
        if (and__4297__auto__) {
          var G__16609 = cljs.core.first(s);
          return pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__16609) : pred__$1.call(null, G__16609);
        } else {
          return and__4297__auto__;
        }
      }())) {
        var G__16612 = pred__$1;
        var G__16613 = cljs.core.rest(s);
        pred__$1 = G__16612;
        coll__$1 = G__16613;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(pred, coll);
    };
  }(step), null, null);
};
cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
cljs.core.cycle = function cljs$core$cycle(coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s, cljs$core$cycle(s));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.split_at = function cljs$core$split_at(n, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, coll), cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll)], null);
};
cljs.core.repeat = function cljs$core$repeat() {
  var G__16616 = arguments.length;
  switch(G__16616) {
    case 1:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(x, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
  }, null, null);
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = function(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeat.cljs$lang$maxFixedArity = 2;
cljs.core.replicate = function cljs$core$replicate(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeatedly = function cljs$core$repeatedly() {
  var G__16619 = arguments.length;
  switch(G__16619) {
    case 1:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    }(), cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
  }, null, null);
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = function(n, f) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
};
cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
cljs.core.iterate = function cljs$core$iterate(f, x) {
  return cljs.core.cons(x, new cljs.core.LazySeq(null, function() {
    return cljs$core$iterate(f, function() {
      var G__16624 = x;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16624) : f.call(null, G__16624);
    }());
  }, null, null));
};
cljs.core.interleave = function cljs$core$interleave() {
  var G__16629 = arguments.length;
  switch(G__16629) {
    case 2:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = function(c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(cljs.core.first(s1), cljs.core.cons(cljs.core.first(s2), cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1), cljs.core.rest(s2))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = function(c1, c2, colls) {
  return new cljs.core.LazySeq(null, function() {
    var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c2, cljs.core.array_seq([c1], 0)));
    if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$lang$applyTo = function(seq16625) {
  var G__16626 = cljs.core.first(seq16625);
  var seq16625__$1 = cljs.core.next(seq16625);
  var G__16627 = cljs.core.first(seq16625__$1);
  var seq16625__$2 = cljs.core.next(seq16625__$1);
  return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__16626, G__16627, seq16625__$2);
};
cljs.core.interleave.cljs$lang$maxFixedArity = 2;
cljs.core.interpose = function cljs$core$interpose() {
  var G__16632 = arguments.length;
  switch(G__16632) {
    case 1:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = function(sep) {
  return function(rf) {
    var started = cljs.core.volatile_BANG_(false);
    return function(started) {
      return function() {
        var G__16641 = null;
        var G__16641__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__16641__1 = function(result) {
          var G__16633 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__16633) : rf.call(null, G__16633);
        };
        var G__16641__2 = function(result, input) {
          if (cljs.core.truth_(cljs.core.deref(started))) {
            var sepr = function() {
              var G__16634 = result;
              var G__16635 = sep;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16634, G__16635) : rf.call(null, G__16634, G__16635);
            }();
            if (cljs.core.reduced_QMARK_(sepr)) {
              return sepr;
            } else {
              var G__16636 = sepr;
              var G__16637 = input;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16636, G__16637) : rf.call(null, G__16636, G__16637);
            }
          } else {
            cljs.core.vreset_BANG_(started, true);
            var G__16638 = result;
            var G__16639 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16638, G__16639) : rf.call(null, G__16638, G__16639);
          }
        };
        G__16641 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__16641__0.call(this);
            case 1:
              return G__16641__1.call(this, result);
            case 2:
              return G__16641__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__16641.cljs$core$IFn$_invoke$arity$0 = G__16641__0;
        G__16641.cljs$core$IFn$_invoke$arity$1 = G__16641__1;
        G__16641.cljs$core$IFn$_invoke$arity$2 = G__16641__2;
        return G__16641;
      }();
    }(started);
  };
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = function(sep, coll) {
  return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1, cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep), coll));
};
cljs.core.interpose.cljs$lang$maxFixedArity = 2;
cljs.core.flatten1 = function cljs$core$flatten1(colls) {
  var cat = function cljs$core$flatten1_$_cat(coll, colls__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4423__auto__ = cljs.core.seq(coll);
      if (temp__4423__auto__) {
        var coll__$1 = temp__4423__auto__;
        return cljs.core.cons(cljs.core.first(coll__$1), cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1), colls__$1));
      } else {
        if (cljs.core.seq(colls__$1)) {
          return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1), cljs.core.rest(colls__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(null, colls);
};
cljs.core.mapcat = function cljs$core$mapcat() {
  var G__16653 = arguments.length;
  switch(G__16653) {
    case 1:
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5360__auto__);
  }
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f), cljs.core.cat);
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = function(f, colls) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat, cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map, f, colls));
};
cljs.core.mapcat.cljs$lang$applyTo = function(seq16650) {
  var G__16651 = cljs.core.first(seq16650);
  var seq16650__$1 = cljs.core.next(seq16650);
  return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__16651, seq16650__$1);
};
cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
cljs.core.filter = function cljs$core$filter() {
  var G__16656 = arguments.length;
  switch(G__16656) {
    case 1:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__16664 = null;
      var G__16664__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__16664__1 = function(result) {
        var G__16657 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__16657) : rf.call(null, G__16657);
      };
      var G__16664__2 = function(result, input) {
        if (cljs.core.truth_(function() {
          var G__16658 = input;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16658) : pred.call(null, G__16658);
        }())) {
          var G__16659 = result;
          var G__16660 = input;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16659, G__16660) : rf.call(null, G__16659, G__16660);
        } else {
          return result;
        }
      };
      G__16664 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__16664__0.call(this);
          case 1:
            return G__16664__1.call(this, result);
          case 2:
            return G__16664__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__16664.cljs$core$IFn$_invoke$arity$0 = G__16664__0;
      G__16664.cljs$core$IFn$_invoke$arity$1 = G__16664__1;
      G__16664.cljs$core$IFn$_invoke$arity$2 = G__16664__2;
      return G__16664;
    }();
  };
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5194__auto___16665 = size;
        var i_16666 = 0;
        while (true) {
          if (i_16666 < n__5194__auto___16665) {
            if (cljs.core.truth_(function() {
              var G__16661 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_16666);
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16661) : pred.call(null, G__16661);
            }())) {
              cljs.core.chunk_append(b, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_16666));
            } else {
            }
            var G__16667 = i_16666 + 1;
            i_16666 = G__16667;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.chunk_rest(s)));
      } else {
        var f = cljs.core.first(s);
        var r = cljs.core.rest(s);
        if (cljs.core.truth_(function() {
          var G__16662 = f;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16662) : pred.call(null, G__16662);
        }())) {
          return cljs.core.cons(f, cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r));
        } else {
          return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r);
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.filter.cljs$lang$maxFixedArity = 2;
cljs.core.remove = function cljs$core$remove() {
  var G__16669 = arguments.length;
  switch(G__16669) {
    case 1:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred), coll);
};
cljs.core.remove.cljs$lang$maxFixedArity = 2;
cljs.core.tree_seq = function cljs$core$tree_seq(branch_QMARK_, children, root) {
  var walk = function cljs$core$tree_seq_$_walk(node) {
    return new cljs.core.LazySeq(null, function() {
      return cljs.core.cons(node, cljs.core.truth_(function() {
        var G__16677 = node;
        return branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16677) : branch_QMARK_.call(null, G__16677);
      }()) ? cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk, cljs.core.array_seq([function() {
        var G__16678 = node;
        return children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__16678) : children.call(null, G__16678);
      }()], 0)) : null);
    }, null, null);
  };
  return walk(root);
};
cljs.core.flatten = function cljs$core$flatten(x) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__16679_SHARP_) {
    return !cljs.core.sequential_QMARK_(p1__16679_SHARP_);
  }, cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_, cljs.core.seq, x)));
};
cljs.core.into = function cljs$core$into() {
  var G__16681 = arguments.length;
  switch(G__16681) {
    case 2:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$2 = function(to, from) {
  if (!(to == null)) {
    if (function() {
      var G__16682 = to;
      if (G__16682) {
        var bit__4976__auto__ = G__16682.cljs$lang$protocol_mask$partition1$ & 4;
        if (bit__4976__auto__ || G__16682.cljs$core$IEditableCollection$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
    } else {
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, to, from);
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, from);
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$3 = function(to, xform, from) {
  if (function() {
    var G__16683 = to;
    if (G__16683) {
      var bit__4976__auto__ = G__16683.cljs$lang$protocol_mask$partition1$ & 4;
      if (bit__4976__auto__ || G__16683.cljs$core$IEditableCollection$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
  } else {
    return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj, to, from);
  }
};
cljs.core.into.cljs$lang$maxFixedArity = 3;
cljs.core.mapv = function cljs$core$mapv() {
  var G__16691 = arguments.length;
  switch(G__16691) {
    case 2:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, function() {
      var G__16692 = o;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16692) : f.call(null, G__16692);
    }());
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, c1, c2));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, c1, c2, c3));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map, f, c1, c2, c3, cljs.core.array_seq([colls], 0)));
};
cljs.core.mapv.cljs$lang$applyTo = function(seq16685) {
  var G__16686 = cljs.core.first(seq16685);
  var seq16685__$1 = cljs.core.next(seq16685);
  var G__16687 = cljs.core.first(seq16685__$1);
  var seq16685__$2 = cljs.core.next(seq16685__$1);
  var G__16688 = cljs.core.first(seq16685__$2);
  var seq16685__$3 = cljs.core.next(seq16685__$2);
  var G__16689 = cljs.core.first(seq16685__$3);
  var seq16685__$4 = cljs.core.next(seq16685__$3);
  return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__16686, G__16687, G__16688, G__16689, seq16685__$4);
};
cljs.core.mapv.cljs$lang$maxFixedArity = 4;
cljs.core.filterv = function cljs$core$filterv(pred, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    if (cljs.core.truth_(function() {
      var G__16695 = o;
      return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16695) : pred.call(null, G__16695);
    }())) {
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, o);
    } else {
      return v;
    }
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.partition = function cljs$core$partition() {
  var G__16697 = arguments.length;
  switch(G__16697) {
    case 2:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = function(n, step, pad, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n, step, pad, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return cljs.core._conj(cljs.core.List.EMPTY, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p, pad)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$lang$maxFixedArity = 4;
cljs.core.get_in = function cljs$core$get_in() {
  var G__16700 = arguments.length;
  switch(G__16700) {
    case 2:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = function(m, ks) {
  return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m, ks, null);
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = function(m, ks, not_found) {
  var sentinel = cljs.core.lookup_sentinel;
  var m__$1 = m;
  var ks__$1 = cljs.core.seq(ks);
  while (true) {
    if (ks__$1) {
      if (!function() {
        var G__16701 = m__$1;
        if (G__16701) {
          var bit__4983__auto__ = G__16701.cljs$lang$protocol_mask$partition0$ & 256;
          if (bit__4983__auto__ || G__16701.cljs$core$ILookup$) {
            return true;
          } else {
            if (!G__16701.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, G__16701);
            } else {
              return false;
            }
          }
        } else {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, G__16701);
        }
      }()) {
        return not_found;
      } else {
        var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1, cljs.core.first(ks__$1), sentinel);
        if (sentinel === m__$2) {
          return not_found;
        } else {
          var G__16703 = sentinel;
          var G__16704 = m__$2;
          var G__16705 = cljs.core.next(ks__$1);
          sentinel = G__16703;
          m__$1 = G__16704;
          ks__$1 = G__16705;
          continue;
        }
      }
    } else {
      return m__$1;
    }
    break;
  }
};
cljs.core.get_in.cljs$lang$maxFixedArity = 3;
cljs.core.assoc_in = function cljs$core$assoc_in(m, p__16706, v) {
  var vec__16711 = p__16706;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16711, 0, null);
  var ks = cljs.core.nthnext(vec__16711, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, v));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
  }
};
cljs.core.update_in = function cljs$core$update_in() {
  var G__16720 = arguments.length;
  switch(G__16720) {
    case 3:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5360__auto__);
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = function(m, p__16721, f) {
  var vec__16722 = p__16721;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16722, 0, null);
  var ks = cljs.core.nthnext(vec__16722, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__16723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16723) : f.call(null, G__16723);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = function(m, p__16724, f, a) {
  var vec__16725 = p__16724;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16725, 0, null);
  var ks = cljs.core.nthnext(vec__16725, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__16726 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__16727 = a;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16726, G__16727) : f.call(null, G__16726, G__16727);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = function(m, p__16728, f, a, b) {
  var vec__16729 = p__16728;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16729, 0, null);
  var ks = cljs.core.nthnext(vec__16729, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__16730 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__16731 = a;
      var G__16732 = b;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16730, G__16731, G__16732) : f.call(null, G__16730, G__16731, G__16732);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = function(m, p__16733, f, a, b, c) {
  var vec__16734 = p__16733;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16734, 0, null);
  var ks = cljs.core.nthnext(vec__16734, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b, c));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__16735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__16736 = a;
      var G__16737 = b;
      var G__16738 = c;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16735, G__16736, G__16737, G__16738) : f.call(null, G__16735, G__16736, G__16737, G__16738);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = function(m, p__16739, f, a, b, c, args) {
  var vec__16740 = p__16739;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16740, 0, null);
  var ks = cljs.core.nthnext(vec__16740, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, cljs.core.array_seq([b, c, args], 0)));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), a, b, c, cljs.core.array_seq([args], 0)));
  }
};
cljs.core.update_in.cljs$lang$applyTo = function(seq16712) {
  var G__16713 = cljs.core.first(seq16712);
  var seq16712__$1 = cljs.core.next(seq16712);
  var G__16714 = cljs.core.first(seq16712__$1);
  var seq16712__$2 = cljs.core.next(seq16712__$1);
  var G__16715 = cljs.core.first(seq16712__$2);
  var seq16712__$3 = cljs.core.next(seq16712__$2);
  var G__16716 = cljs.core.first(seq16712__$3);
  var seq16712__$4 = cljs.core.next(seq16712__$3);
  var G__16717 = cljs.core.first(seq16712__$4);
  var seq16712__$5 = cljs.core.next(seq16712__$4);
  var G__16718 = cljs.core.first(seq16712__$5);
  var seq16712__$6 = cljs.core.next(seq16712__$5);
  return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__16713, G__16714, G__16715, G__16716, G__16717, G__16718, seq16712__$6);
};
cljs.core.update_in.cljs$lang$maxFixedArity = 6;
cljs.core.update = function cljs$core$update() {
  var G__16750 = arguments.length;
  switch(G__16750) {
    case 3:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5360__auto__);
  }
};
cljs.core.update.cljs$core$IFn$_invoke$arity$3 = function(m, k, f) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__16751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16751) : f.call(null, G__16751);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$4 = function(m, k, f, x) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__16752 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__16753 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16752, G__16753) : f.call(null, G__16752, G__16753);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$5 = function(m, k, f, x, y) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__16754 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__16755 = x;
    var G__16756 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16754, G__16755, G__16756) : f.call(null, G__16754, G__16755, G__16756);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$6 = function(m, k, f, x, y, z) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__16757 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__16758 = x;
    var G__16759 = y;
    var G__16760 = z;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16757, G__16758, G__16759, G__16760) : f.call(null, G__16757, G__16758, G__16759, G__16760);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = function(m, k, f, x, y, z, more) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), x, y, z, cljs.core.array_seq([more], 0)));
};
cljs.core.update.cljs$lang$applyTo = function(seq16742) {
  var G__16743 = cljs.core.first(seq16742);
  var seq16742__$1 = cljs.core.next(seq16742);
  var G__16744 = cljs.core.first(seq16742__$1);
  var seq16742__$2 = cljs.core.next(seq16742__$1);
  var G__16745 = cljs.core.first(seq16742__$2);
  var seq16742__$3 = cljs.core.next(seq16742__$2);
  var G__16746 = cljs.core.first(seq16742__$3);
  var seq16742__$4 = cljs.core.next(seq16742__$3);
  var G__16747 = cljs.core.first(seq16742__$4);
  var seq16742__$5 = cljs.core.next(seq16742__$4);
  var G__16748 = cljs.core.first(seq16742__$5);
  var seq16742__$6 = cljs.core.next(seq16742__$5);
  return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__16743, G__16744, G__16745, G__16746, G__16747, G__16748, seq16742__$6);
};
cljs.core.update.cljs$lang$maxFixedArity = 6;
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr;
};
cljs.core.VectorNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/VectorNode");
};
cljs.core.__GT_VectorNode = function cljs$core$__GT_VectorNode(edit, arr) {
  return new cljs.core.VectorNode(edit, arr);
};
cljs.core.pv_fresh_node = function cljs$core$pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
};
cljs.core.pv_aget = function cljs$core$pv_aget(node, idx) {
  return node.arr[idx];
};
cljs.core.pv_aset = function cljs$core$pv_aset(node, idx, val) {
  return node.arr[idx] = val;
};
cljs.core.pv_clone_node = function cljs$core$pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone(node.arr));
};
cljs.core.tail_off = function cljs$core$tail_off(pv) {
  var cnt = pv.cnt;
  if (cnt < 32) {
    return 0;
  } else {
    return cnt - 1 >>> 5 << 5;
  }
};
cljs.core.new_path = function cljs$core$new_path(edit, level, node) {
  var ll = level;
  var ret = node;
  while (true) {
    if (ll === 0) {
      return ret;
    } else {
      var embed = ret;
      var r = cljs.core.pv_fresh_node(edit);
      var _ = cljs.core.pv_aset(r, 0, embed);
      var G__16762 = ll - 5;
      var G__16763 = r;
      ll = G__16762;
      ret = G__16763;
      continue;
    }
    break;
  }
};
cljs.core.push_tail = function cljs$core$push_tail(pv, level, parent, tailnode) {
  var ret = cljs.core.pv_clone_node(parent);
  var subidx = pv.cnt - 1 >>> level & 31;
  if (5 === level) {
    cljs.core.pv_aset(ret, subidx, tailnode);
    return ret;
  } else {
    var child = cljs.core.pv_aget(parent, subidx);
    if (!(child == null)) {
      var node_to_insert = cljs$core$push_tail(pv, level - 5, child, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    } else {
      var node_to_insert = cljs.core.new_path(null, level - 5, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    }
  }
};
cljs.core.vector_index_out_of_bounds = function cljs$core$vector_index_out_of_bounds(i, cnt) {
  throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(cnt)].join(""));
};
cljs.core.first_array_for_longvec = function cljs$core$first_array_for_longvec(pv) {
  var node = pv.root;
  var level = pv.shift;
  while (true) {
    if (level > 0) {
      var G__16768 = cljs.core.pv_aget(node, 0);
      var G__16769 = level - 5;
      node = G__16768;
      level = G__16769;
      continue;
    } else {
      return node.arr;
    }
    break;
  }
};
cljs.core.unchecked_array_for = function cljs$core$unchecked_array_for(pv, i) {
  if (i >= cljs.core.tail_off(pv)) {
    return pv.tail;
  } else {
    var node = pv.root;
    var level = pv.shift;
    while (true) {
      if (level > 0) {
        var G__16770 = cljs.core.pv_aget(node, i >>> level & 31);
        var G__16771 = level - 5;
        node = G__16770;
        level = G__16771;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.array_for = function cljs$core$array_for(pv, i) {
  if (0 <= i && i < pv.cnt) {
    return cljs.core.unchecked_array_for(pv, i);
  } else {
    return cljs.core.vector_index_out_of_bounds(i, pv.cnt);
  }
};
cljs.core.do_assoc = function cljs$core$do_assoc(pv, level, node, i, val) {
  var ret = cljs.core.pv_clone_node(node);
  if (level === 0) {
    cljs.core.pv_aset(ret, i & 31, val);
    return ret;
  } else {
    var subidx = i >>> level & 31;
    cljs.core.pv_aset(ret, subidx, cljs$core$do_assoc(pv, level - 5, cljs.core.pv_aget(node, subidx), i, val));
    return ret;
  }
};
cljs.core.pop_tail = function cljs$core$pop_tail(pv, level, node) {
  var subidx = pv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$pop_tail(pv, level - 5, cljs.core.pv_aget(node, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, new_child);
      return ret;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, null);
      return ret;
    }
  }
};
cljs.core.RangedIterator = function(i, base, arr, v, start, end) {
  this.i = i;
  this.base = base;
  this.arr = arr;
  this.v = v;
  this.start = start;
  this.end = end;
};
cljs.core.RangedIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return self__.i < self__.end;
};
cljs.core.RangedIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (self__.i - self__.base === 32) {
    self__.arr = cljs.core.unchecked_array_for(self__.v, self__.i);
    self__.base = self__.base + 32;
  } else {
  }
  var ret = self__.arr[self__.i & 31];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.RangedIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "base", "base", 1825810849, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.RangedIterator.cljs$lang$type = true;
cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RangedIterator");
};
cljs.core.__GT_RangedIterator = function cljs$core$__GT_RangedIterator(i, base, arr, v, start, end) {
  return new cljs.core.RangedIterator(i, base, arr, v, start, end);
};
cljs.core.ranged_iterator = function cljs$core$ranged_iterator(v, start, end) {
  var i = start;
  return new cljs.core.RangedIterator(i, i - i % 32, start < cljs.core.count(v) ? cljs.core.unchecked_array_for(v, i) : null, v, start, end);
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167668511;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentVector.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentVector.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__16781 = init__$2;
              var G__16782 = j + i;
              var G__16783 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16781, G__16782, G__16783) : f.call(null, G__16781, G__16782, G__16783);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__16794 = j + 1;
              var G__16795 = init__$3;
              j = G__16794;
              init__$2 = G__16795;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__16784 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__16784) : cljs.core.deref.call(null, G__16784);
      } else {
        var G__16796 = i + len;
        var G__16797 = init__$2;
        i = G__16796;
        init__$1 = G__16797;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_for(coll__$1, n)[n & 31];
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core.unchecked_array_for(coll__$1, n)[n & 31];
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    if (cljs.core.tail_off(coll__$1) <= n) {
      var new_tail = cljs.core.aclone(self__.tail);
      new_tail[n & 31] = val;
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, new_tail, null);
    } else {
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, cljs.core.do_assoc(coll__$1, self__.shift, self__.root, n, val), self__.tail, null);
    }
  } else {
    if (n === self__.cnt) {
      return cljs.core._conj(coll__$1, val);
    } else {
      throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds  [0,"), cljs.core.str(self__.cnt), cljs.core.str("]")].join(""));
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.ranged_iterator(this$__$1, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 0);
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 1);
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, self__.cnt - 1);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    throw new Error("Can't pop empty vector");
  } else {
    if (1 === self__.cnt) {
      return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
    } else {
      if (1 < self__.cnt - cljs.core.tail_off(coll__$1)) {
        return new cljs.core.PersistentVector(self__.meta, self__.cnt - 1, self__.shift, self__.root, self__.tail.slice(0, -1), null);
      } else {
        var new_tail = cljs.core.unchecked_array_for(coll__$1, self__.cnt - 2);
        var nr = cljs.core.pop_tail(coll__$1, self__.shift, self__.root);
        var new_root = nr == null ? cljs.core.PersistentVector.EMPTY_NODE : nr;
        var cnt_1 = self__.cnt - 1;
        if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift - 5, cljs.core.pv_aget(new_root, 0), new_tail, null);
        } else {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift, new_root, new_tail, null);
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return new cljs.core.RSeq(coll__$1, self__.cnt - 1, null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (other instanceof cljs.core.PersistentVector) {
    if (self__.cnt === cljs.core.count(other)) {
      var me_iter = cljs.core._iterator(coll__$1);
      var you_iter = cljs.core._iterator(other);
      while (true) {
        if (cljs.core.truth_(me_iter.hasNext())) {
          var x = me_iter.next();
          var y = you_iter.next();
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
            continue;
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_sequential(coll__$1, other);
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientVector(self__.cnt, self__.shift, function() {
    var G__16785 = self__.root;
    return cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__16785) : cljs.core.tv_editable_root.call(null, G__16785);
  }(), function() {
    var G__16786 = self__.tail;
    return cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__16786) : cljs.core.tv_editable_tail.call(null, G__16786);
  }());
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var self__ = this;
  var v__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1, f);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__16787 = init__$2;
              var G__16788 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16787, G__16788) : f.call(null, G__16787, G__16788);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__16798 = j + 1;
              var G__16799 = init__$3;
              j = G__16798;
              init__$2 = G__16799;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__16789 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__16789) : cljs.core.deref.call(null, G__16789);
      } else {
        var G__16800 = i + len;
        var G__16801 = init__$2;
        i = G__16800;
        init__$1 = G__16801;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._assoc_n(coll__$1, k, v);
  } else {
    throw new Error("Vector's key for assoc must be a number.");
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    return null;
  } else {
    if (self__.cnt <= 32) {
      return new cljs.core.IndexedSeq(self__.tail, 0);
    } else {
      var G__16790 = coll__$1;
      var G__16791 = cljs.core.first_array_for_longvec(coll__$1);
      var G__16792 = 0;
      var G__16793 = 0;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__16790, G__16791, G__16792, G__16793) : cljs.core.chunked_seq.call(null, G__16790, G__16791, G__16792, G__16793);
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(meta__$1, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt - cljs.core.tail_off(coll__$1) < 32) {
    var len = self__.tail.length;
    var new_tail = new Array(len + 1);
    var n__5194__auto___16802 = len;
    var i_16803 = 0;
    while (true) {
      if (i_16803 < n__5194__auto___16802) {
        new_tail[i_16803] = self__.tail[i_16803];
        var G__16804 = i_16803 + 1;
        i_16803 = G__16804;
        continue;
      } else {
      }
      break;
    }
    new_tail[len] = o;
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, self__.shift, self__.root, new_tail, null);
  } else {
    var root_overflow_QMARK_ = self__.cnt >>> 5 > 1 << self__.shift;
    var new_shift = root_overflow_QMARK_ ? self__.shift + 5 : self__.shift;
    var new_root = root_overflow_QMARK_ ? function() {
      var n_r = cljs.core.pv_fresh_node(null);
      cljs.core.pv_aset(n_r, 0, self__.root);
      cljs.core.pv_aset(n_r, 1, cljs.core.new_path(null, self__.shift, new cljs.core.VectorNode(null, self__.tail)));
      return n_r;
    }() : cljs.core.push_tail(coll__$1, self__.shift, self__.root, new cljs.core.VectorNode(null, self__.tail));
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, new_shift, new_root, [o], null);
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__16805 = null;
  var G__16805__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__16805__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__16805 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__16805__2.call(this, self__, k);
      case 3:
        return G__16805__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16805.cljs$core$IFn$_invoke$arity$2 = G__16805__2;
  G__16805.cljs$core$IFn$_invoke$arity$3 = G__16805__3;
  return G__16805;
}();
cljs.core.PersistentVector.prototype.apply = function(self__, args16780) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16780)));
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.PersistentVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";
cljs.core.PersistentVector.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentVector");
};
cljs.core.__GT_PersistentVector = function cljs$core$__GT_PersistentVector(meta, cnt, shift, root, tail, __hash) {
  return new cljs.core.PersistentVector(meta, cnt, shift, root, tail, __hash);
};
cljs.core.PersistentVector.EMPTY_NODE = new cljs.core.VectorNode(null, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l = xs.length;
  var xs__$1 = no_clone ? xs : cljs.core.aclone(xs);
  if (l < 32) {
    return new cljs.core.PersistentVector(null, l, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__$1, null);
  } else {
    var node = xs__$1.slice(0, 32);
    var v = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node, null);
    var i = 32;
    var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
    while (true) {
      if (i < l) {
        var G__16806 = i + 1;
        var G__16807 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out, xs__$1[i]);
        i = G__16806;
        out = G__16807;
        continue;
      } else {
        return cljs.core.persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.vec = function cljs$core$vec(coll) {
  if (cljs.core.array_QMARK_(coll)) {
    return cljs.core.PersistentVector.fromArray(coll, true);
  } else {
    return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core._as_transient(cljs.core.PersistentVector.EMPTY), coll));
  }
};
cljs.core.vector = function cljs$core$vector() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = function(args) {
  if (args instanceof cljs.core.IndexedSeq && args.i === 0) {
    return cljs.core.PersistentVector.fromArray(args.arr, true);
  } else {
    return cljs.core.vec(args);
  }
};
cljs.core.vector.cljs$lang$maxFixedArity = 0;
cljs.core.vector.cljs$lang$applyTo = function(seq16808) {
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16808));
};
cljs.core.ChunkedSeq = function(vec, node, i, off, meta, __hash) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375020;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__16809 = self__.vec;
      var G__16810 = self__.node;
      var G__16811 = self__.i;
      var G__16812 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__16809, G__16810, G__16811, G__16812) : cljs.core.chunked_seq.call(null, G__16809, G__16810, G__16811, G__16812);
    }();
    if (s == null) {
      return null;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_next(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(function() {
    var G__16813 = self__.vec;
    var G__16814 = self__.i + self__.off;
    var G__16815 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__16813, G__16814, G__16815) : cljs.core.subvec.call(null, G__16813, G__16814, G__16815);
  }(), f);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(function() {
    var G__16816 = self__.vec;
    var G__16817 = self__.i + self__.off;
    var G__16818 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__16816, G__16817, G__16818) : cljs.core.subvec.call(null, G__16816, G__16817, G__16818);
  }(), f, start);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.node[self__.off];
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__16819 = self__.vec;
      var G__16820 = self__.node;
      var G__16821 = self__.i;
      var G__16822 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__16819, G__16820, G__16821, G__16822) : cljs.core.chunked_seq.call(null, G__16819, G__16820, G__16821, G__16822);
    }();
    if (s == null) {
      return cljs.core.List.EMPTY;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_rest(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node, self__.off);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__16823 = self__.vec;
    var G__16824 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__16825 = end;
    var G__16826 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__16823, G__16824, G__16825, G__16826) : cljs.core.chunked_seq.call(null, G__16823, G__16824, G__16825, G__16826);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  var G__16827 = self__.vec;
  var G__16828 = self__.node;
  var G__16829 = self__.i;
  var G__16830 = self__.off;
  var G__16831 = m;
  return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__16827, G__16828, G__16829, G__16830, G__16831) : cljs.core.chunked_seq.call(null, G__16827, G__16828, G__16829, G__16830, G__16831);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__16832 = self__.vec;
    var G__16833 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__16834 = end;
    var G__16835 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__16832, G__16833, G__16834, G__16835) : cljs.core.chunked_seq.call(null, G__16832, G__16833, G__16834, G__16835);
  } else {
    return null;
  }
};
cljs.core.ChunkedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "vec", "vec", 982683596, null), new cljs.core.Symbol(null, "node", "node", -2073234571, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";
cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ChunkedSeq");
};
cljs.core.__GT_ChunkedSeq = function cljs$core$__GT_ChunkedSeq(vec, node, i, off, meta, __hash) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, __hash);
};
cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.chunked_seq = function cljs$core$chunked_seq() {
  var G__16837 = arguments.length;
  switch(G__16837) {
    case 3:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = function(vec, i, off) {
  return new cljs.core.ChunkedSeq(vec, cljs.core.array_for(vec, i), i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = function(vec, node, i, off) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = function(vec, node, i, off, meta) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, null);
};
cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Subvec.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Subvec.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var i = self__.start;
  var j = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.end) {
      var init__$2 = function() {
        var G__16840 = init__$1;
        var G__16841 = j;
        var G__16842 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16840, G__16841, G__16842) : f.call(null, G__16840, G__16841, G__16842);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__16843 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__16843) : cljs.core.deref.call(null, G__16843);
      } else {
        var G__16865 = i + 1;
        var G__16866 = j + 1;
        var G__16867 = init__$2;
        i = G__16865;
        j = G__16866;
        init__$1 = G__16867;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return cljs.core.vector_index_out_of_bounds(n, self__.end - self__.start);
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.start + n);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return not_found;
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v, self__.start + n, not_found);
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  var v_pos = self__.start + n;
  var G__16844 = self__.meta;
  var G__16845 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v, v_pos, val);
  var G__16846 = self__.start;
  var G__16847 = function() {
    var x__4621__auto__ = self__.end;
    var y__4622__auto__ = v_pos + 1;
    return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
  }();
  var G__16848 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__16844, G__16845, G__16846, G__16847, G__16848) : cljs.core.build_subvec.call(null, G__16844, G__16845, G__16846, G__16847, G__16848);
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Subvec(self__.meta, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.end - self__.start;
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.end - 1);
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.start === self__.end) {
    throw new Error("Can't pop empty vector");
  } else {
    var G__16849 = self__.meta;
    var G__16850 = self__.v;
    var G__16851 = self__.start;
    var G__16852 = self__.end - 1;
    var G__16853 = null;
    return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__16849, G__16850, G__16851, G__16852, G__16853) : cljs.core.build_subvec.call(null, G__16849, G__16850, G__16851, G__16852, G__16853);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.start === self__.end)) {
    return new cljs.core.RSeq(coll__$1, self__.end - self__.start - 1, null);
  } else {
    return null;
  }
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, start__$1);
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n(coll__$1, key, val);
  } else {
    throw new Error("Subvec's key for assoc must be a number.");
  }
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var subvec_seq = function(coll__$1) {
    return function cljs$core$subvec_seq(i) {
      if (i === self__.end) {
        return null;
      } else {
        return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i), new cljs.core.LazySeq(null, function(coll__$1) {
          return function() {
            return cljs$core$subvec_seq(i + 1);
          };
        }(coll__$1), null, null));
      }
    };
  }(coll__$1);
  return subvec_seq(self__.start);
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  var G__16855 = meta__$1;
  var G__16856 = self__.v;
  var G__16857 = self__.start;
  var G__16858 = self__.end;
  var G__16859 = self__.__hash;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__16855, G__16856, G__16857, G__16858, G__16859) : cljs.core.build_subvec.call(null, G__16855, G__16856, G__16857, G__16858, G__16859);
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__16860 = self__.meta;
  var G__16861 = cljs.core._assoc_n(self__.v, self__.end, o);
  var G__16862 = self__.start;
  var G__16863 = self__.end + 1;
  var G__16864 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__16860, G__16861, G__16862, G__16863, G__16864) : cljs.core.build_subvec.call(null, G__16860, G__16861, G__16862, G__16863, G__16864);
};
cljs.core.Subvec.prototype.call = function() {
  var G__16868 = null;
  var G__16868__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__16868__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__16868 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__16868__2.call(this, self__, k);
      case 3:
        return G__16868__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16868.cljs$core$IFn$_invoke$arity$2 = G__16868__2;
  G__16868.cljs$core$IFn$_invoke$arity$3 = G__16868__3;
  return G__16868;
}();
cljs.core.Subvec.prototype.apply = function(self__, args16839) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16839)));
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.Subvec.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";
cljs.core.Subvec.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Subvec");
};
cljs.core.__GT_Subvec = function cljs$core$__GT_Subvec(meta, v, start, end, __hash) {
  return new cljs.core.Subvec(meta, v, start, end, __hash);
};
cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.build_subvec = function cljs$core$build_subvec(meta, v, start, end, __hash) {
  while (true) {
    if (v instanceof cljs.core.Subvec) {
      var G__16869 = meta;
      var G__16870 = v.v;
      var G__16871 = v.start + start;
      var G__16872 = v.start + end;
      var G__16873 = __hash;
      meta = G__16869;
      v = G__16870;
      start = G__16871;
      end = G__16872;
      __hash = G__16873;
      continue;
    } else {
      var c = cljs.core.count(v);
      if (start < 0 || end < 0 || start > c || end > c) {
        throw new Error("Index out of bounds");
      } else {
      }
      return new cljs.core.Subvec(meta, v, start, end, __hash);
    }
    break;
  }
};
cljs.core.subvec = function cljs$core$subvec() {
  var G__16875 = arguments.length;
  switch(G__16875) {
    case 2:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = function(v, start) {
  return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v, start, cljs.core.count(v));
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = function(v, start, end) {
  return cljs.core.build_subvec(null, v, start, end, null);
};
cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = function cljs$core$tv_ensure_editable(edit, node) {
  if (edit === node.edit) {
    return node;
  } else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone(node.arr));
  }
};
cljs.core.tv_editable_root = function cljs$core$tv_editable_root(node) {
  return new cljs.core.VectorNode(function() {
    var obj16880 = {};
    return obj16880;
  }(), cljs.core.aclone(node.arr));
};
cljs.core.tv_editable_tail = function cljs$core$tv_editable_tail(tl) {
  var ret = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
  cljs.core.array_copy(tl, 0, ret, 0, tl.length);
  return ret;
};
cljs.core.tv_push_tail = function cljs$core$tv_push_tail(tv, level, parent, tail_node) {
  var ret = cljs.core.tv_ensure_editable(tv.root.edit, parent);
  var subidx = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset(ret, subidx, level === 5 ? tail_node : function() {
    var child = cljs.core.pv_aget(ret, subidx);
    if (!(child == null)) {
      return cljs$core$tv_push_tail(tv, level - 5, child, tail_node);
    } else {
      return cljs.core.new_path(tv.root.edit, level - 5, tail_node);
    }
  }());
  return ret;
};
cljs.core.tv_pop_tail = function cljs$core$tv_pop_tail(tv, level, node) {
  var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit, node);
  var subidx = tv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$tv_pop_tail(tv, level - 5, cljs.core.pv_aget(node__$1, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, new_child);
      return node__$1;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, null);
      return node__$1;
    }
  }
};
cljs.core.unchecked_editable_array_for = function cljs$core$unchecked_editable_array_for(tv, i) {
  if (i >= cljs.core.tail_off(tv)) {
    return tv.tail;
  } else {
    var root = tv.root;
    var node = root;
    var level = tv.shift;
    while (true) {
      if (level > 0) {
        var G__16888 = cljs.core.tv_ensure_editable(root.edit, cljs.core.pv_aget(node, i >>> level & 31));
        var G__16889 = level - 5;
        node = G__16888;
        level = G__16889;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition1$ = 88;
  this.cljs$lang$protocol_mask$partition0$ = 275;
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt - cljs.core.tail_off(tcoll__$1) < 32) {
      self__.tail[self__.cnt & 31] = o;
      self__.cnt = self__.cnt + 1;
      return tcoll__$1;
    } else {
      var tail_node = new cljs.core.VectorNode(self__.root.edit, self__.tail);
      var new_tail = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      new_tail[0] = o;
      self__.tail = new_tail;
      if (self__.cnt >>> 5 > 1 << self__.shift) {
        var new_root_array = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var new_shift = self__.shift + 5;
        new_root_array[0] = self__.root;
        new_root_array[1] = cljs.core.new_path(self__.root.edit, self__.shift, tail_node);
        self__.root = new cljs.core.VectorNode(self__.root.edit, new_root_array);
        self__.shift = new_shift;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      } else {
        var new_root = cljs.core.tv_push_tail(tcoll__$1, self__.shift, self__.root, tail_node);
        self__.root = new_root;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    self__.root.edit = null;
    var len = self__.cnt - cljs.core.tail_off(tcoll__$1);
    var trimmed_tail = new Array(len);
    cljs.core.array_copy(self__.tail, 0, trimmed_tail, 0, len);
    return new cljs.core.PersistentVector(null, self__.cnt, self__.shift, self__.root, trimmed_tail, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n_BANG_(tcoll__$1, key, val);
  } else {
    throw new Error("TransientVector's key for assoc! must be a number.");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (0 <= n && n < self__.cnt) {
      if (cljs.core.tail_off(tcoll__$1) <= n) {
        self__.tail[n & 31] = val;
        return tcoll__$1;
      } else {
        var new_root = function(tcoll__$1) {
          return function cljs$core$go(level, node) {
            var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit, node);
            if (level === 0) {
              cljs.core.pv_aset(node__$1, n & 31, val);
              return node__$1;
            } else {
              var subidx = n >>> level & 31;
              cljs.core.pv_aset(node__$1, subidx, cljs$core$go(level - 5, cljs.core.pv_aget(node__$1, subidx)));
              return node__$1;
            }
          };
        }(tcoll__$1).call(null, self__.shift, self__.root);
        self__.root = new_root;
        return tcoll__$1;
      }
    } else {
      if (n === self__.cnt) {
        return cljs.core._conj_BANG_(tcoll__$1, val);
      } else {
        throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(self__.cnt)].join(""));
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt === 0) {
      throw new Error("Can't pop empty vector");
    } else {
      if (1 === self__.cnt) {
        self__.cnt = 0;
        return tcoll__$1;
      } else {
        if ((self__.cnt - 1 & 31) > 0) {
          self__.cnt = self__.cnt - 1;
          return tcoll__$1;
        } else {
          var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1, self__.cnt - 2);
          var new_root = function() {
            var nr = cljs.core.tv_pop_tail(tcoll__$1, self__.shift, self__.root);
            if (!(nr == null)) {
              return nr;
            } else {
              return new cljs.core.VectorNode(self__.root.edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
            }
          }();
          if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
            var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit, cljs.core.pv_aget(new_root, 0));
            self__.root = new_root__$1;
            self__.shift = self__.shift - 5;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          } else {
            self__.root = new_root;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          }
        }
      }
    }
  } else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return self__.cnt;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return cljs.core.array_for(coll__$1, n)[n & 31];
  } else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, n);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.call = function() {
  var G__16893 = null;
  var G__16893__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__16893__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__16893 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__16893__2.call(this, self__, k);
      case 3:
        return G__16893__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16893.cljs$core$IFn$_invoke$arity$2 = G__16893__2;
  G__16893.cljs$core$IFn$_invoke$arity$3 = G__16893__3;
  return G__16893;
}();
cljs.core.TransientVector.prototype.apply = function(self__, args16890) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16890)));
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.TransientVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null)], null);
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";
cljs.core.TransientVector.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientVector");
};
cljs.core.__GT_TransientVector = function cljs$core$__GT_TransientVector(cnt, shift, root, tail) {
  return new cljs.core.TransientVector(cnt, shift, root, tail);
};
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850572;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueueSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__4423__auto__ = cljs.core.next(self__.front);
  if (temp__4423__auto__) {
    var f1 = temp__4423__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (self__.rear == null) {
      return cljs.core._empty(coll__$1);
    } else {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueSeq(meta__$1, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentQueueSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentQueueSeq");
};
cljs.core.__GT_PersistentQueueSeq = function cljs$core$__GT_PersistentQueueSeq(meta, front, rear, __hash) {
  return new cljs.core.PersistentQueueSeq(meta, front, rear, __hash);
};
cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31858766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueue.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(self__.meta, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    var temp__4423__auto__ = cljs.core.next(self__.front);
    if (temp__4423__auto__) {
      var f1 = temp__4423__auto__;
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, f1, self__.rear, null);
    } else {
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, cljs.core.seq(self__.rear), cljs.core.PersistentVector.EMPTY, null);
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY, self__.meta);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.rest(cljs.core.seq(coll__$1));
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var rear__$1 = cljs.core.seq(self__.rear);
  if (cljs.core.truth_(function() {
    var or__4309__auto__ = self__.front;
    if (cljs.core.truth_(or__4309__auto__)) {
      return or__4309__auto__;
    } else {
      return rear__$1;
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, self__.front, cljs.core.seq(rear__$1), null);
  } else {
    return null;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(meta__$1, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, self__.front, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
      var or__4309__auto__ = self__.rear;
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        return cljs.core.PersistentVector.EMPTY;
      }
    }(), o), null);
  } else {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front, o), cljs.core.PersistentVector.EMPTY, null);
  }
};
cljs.core.PersistentQueue.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";
cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentQueue");
};
cljs.core.__GT_PersistentQueue = function cljs$core$__GT_PersistentQueue(meta, count, front, rear, __hash) {
  return new cljs.core.PersistentQueue(meta, count, front, rear, __hash);
};
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, cljs.core.empty_ordered_hash);
cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NeverEquiv.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return false;
};
cljs.core.NeverEquiv.getBasis = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";
cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/NeverEquiv");
};
cljs.core.__GT_NeverEquiv = function cljs$core$__GT_NeverEquiv() {
  return new cljs.core.NeverEquiv;
};
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function cljs$core$equiv_map(x, y) {
  return cljs.core.boolean$(cljs.core.map_QMARK_(y) ? cljs.core.count(x) === cljs.core.count(y) ? cljs.core.every_QMARK_(cljs.core.identity, cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(xkv) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, cljs.core.first(xkv), cljs.core.never_equiv), cljs.core.second(xkv));
  }, x)) : null : null);
};
cljs.core.scan_array = function cljs$core$scan_array(incr, k, array) {
  var len = array.length;
  var i = 0;
  while (true) {
    if (i < len) {
      if (k === array[i]) {
        return i;
      } else {
        var G__16894 = i + incr;
        i = G__16894;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.obj_map_compare_keys = function cljs$core$obj_map_compare_keys(a, b) {
  var a__$1 = cljs.core.hash(a);
  var b__$1 = cljs.core.hash(b);
  if (a__$1 < b__$1) {
    return -1;
  } else {
    if (a__$1 > b__$1) {
      return 1;
    } else {
      return 0;
    }
  }
};
cljs.core.obj_map__GT_hash_map = function cljs$core$obj_map__GT_hash_map(m, k, v) {
  var ks = m.keys;
  var len = ks.length;
  var so = m.strobj;
  var mm = cljs.core.meta(m);
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var k__$1 = ks[i];
      var G__16895 = i + 1;
      var G__16896 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k__$1, so[k__$1]);
      i = G__16895;
      out = G__16896;
      continue;
    } else {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k, v)), mm);
    }
    break;
  }
};
cljs.core.obj_clone = function cljs$core$obj_clone(obj, ks) {
  var new_obj = function() {
    var obj16900 = {};
    return obj16900;
  }();
  var l = ks.length;
  var i_16901 = 0;
  while (true) {
    if (i_16901 < l) {
      var k_16902 = ks[i_16901];
      new_obj[k_16902] = obj[k_16902];
      var G__16903 = i_16901 + 1;
      i_16901 = G__16903;
      continue;
    } else {
    }
    break;
  }
  return new_obj;
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 4;
};
cljs.core.ObjMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ObjMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4297__auto__ = function() {
      var G__16907 = k;
      return goog.isString(G__16907);
    }();
    if (cljs.core.truth_(and__4297__auto__)) {
      return !(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4297__auto__;
    }
  }())) {
    return self__.strobj[k];
  } else {
    return not_found;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.keys.length;
  var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
  var init__$1 = init;
  while (true) {
    if (cljs.core.seq(keys__$1)) {
      var k = cljs.core.first(keys__$1);
      var init__$2 = function() {
        var G__16908 = init__$1;
        var G__16909 = k;
        var G__16910 = self__.strobj[k];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16908, G__16909, G__16910) : f.call(null, G__16908, G__16909, G__16910);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__16911 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__16911) : cljs.core.deref.call(null, G__16911);
      } else {
        var G__16917 = cljs.core.rest(keys__$1);
        var G__16918 = init__$2;
        keys__$1 = G__16917;
        init__$1 = G__16918;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.keys.length;
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1));
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.ObjMap.EMPTY, self__.meta);
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4297__auto__ = function() {
      var G__16913 = k;
      return goog.isString(G__16913);
    }();
    if (cljs.core.truth_(and__4297__auto__)) {
      return !(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4297__auto__;
    }
  }())) {
    var new_keys = cljs.core.aclone(self__.keys);
    var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
    new_keys.splice(cljs.core.scan_array(1, k, new_keys), 1);
    delete new_strobj[k];
    return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
  } else {
    return coll__$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var G__16914 = k;
    return goog.isString(G__16914);
  }())) {
    if (self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD || self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD) {
      return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
    } else {
      if (!(cljs.core.scan_array(1, k, self__.keys) == null)) {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        new_strobj[k] = v;
        return new cljs.core.ObjMap(self__.meta, self__.keys, new_strobj, self__.update_count + 1, null);
      } else {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        var new_keys = cljs.core.aclone(self__.keys);
        new_strobj[k] = v;
        new_keys.push(k);
        return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
      }
    }
  } else {
    return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4297__auto__ = function() {
      var G__16916 = k;
      return goog.isString(G__16916);
    }();
    if (cljs.core.truth_(and__4297__auto__)) {
      return !(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4297__auto__;
    }
  }())) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.keys.length > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(coll__$1) {
      return function(p1__16904_SHARP_) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16904_SHARP_, self__.strobj[p1__16904_SHARP_]], null);
      };
    }(coll__$1), self__.keys.sort(cljs.core.obj_map_compare_keys));
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ObjMap(meta__$1, self__.keys, self__.strobj, self__.update_count, self__.__hash);
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, coll__$1, entry);
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__16919 = null;
  var G__16919__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__16919__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__16919 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__16919__2.call(this, self__, k);
      case 3:
        return G__16919__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16919.cljs$core$IFn$_invoke$arity$2 = G__16919__2;
  G__16919.cljs$core$IFn$_invoke$arity$3 = G__16919__3;
  return G__16919;
}();
cljs.core.ObjMap.prototype.apply = function(self__, args16905) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16905)));
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.ObjMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "keys", "keys", -1586012071, null), new cljs.core.Symbol(null, "strobj", "strobj", 1088091283, null), new cljs.core.Symbol(null, "update-count", "update-count", -411982269, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";
cljs.core.ObjMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ObjMap");
};
cljs.core.__GT_ObjMap = function cljs$core$__GT_ObjMap(meta, keys, strobj, update_count, __hash) {
  return new cljs.core.ObjMap(meta, keys, strobj, update_count, __hash);
};
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], function() {
  var obj16921 = {};
  return obj16921;
}(), 0, cljs.core.empty_unordered_hash);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 8;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null);
};
cljs.core.ES6EntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6EntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var vec__16922 = cljs.core.first(self__.s);
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16922, 0, null);
    var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16922, 1, null);
    self__.s = cljs.core.next(self__.s);
    return {"value":[k, v], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6EntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null)], null);
};
cljs.core.ES6EntriesIterator.cljs$lang$type = true;
cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";
cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6EntriesIterator");
};
cljs.core.__GT_ES6EntriesIterator = function cljs$core$__GT_ES6EntriesIterator(s) {
  return new cljs.core.ES6EntriesIterator(s);
};
cljs.core.es6_entries_iterator = function cljs$core$es6_entries_iterator(coll) {
  return new cljs.core.ES6EntriesIterator(cljs.core.seq(coll));
};
cljs.core.ES6SetEntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6SetEntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":[x, x], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6SetEntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null)], null);
};
cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6SetEntriesIterator");
};
cljs.core.__GT_ES6SetEntriesIterator = function cljs$core$__GT_ES6SetEntriesIterator(s) {
  return new cljs.core.ES6SetEntriesIterator(s);
};
cljs.core.es6_set_entries_iterator = function cljs$core$es6_set_entries_iterator(coll) {
  return new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll));
};
cljs.core.array_index_of_nil_QMARK_ = function cljs$core$array_index_of_nil_QMARK_(arr) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] == null) {
        return i;
      } else {
        var G__16923 = i + 2;
        i = G__16923;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_keyword_QMARK_ = function cljs$core$array_index_of_keyword_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.fqn;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (function() {
        var k_SINGLEQUOTE_ = arr[i];
        return k_SINGLEQUOTE_ instanceof cljs.core.Keyword && kstr === k_SINGLEQUOTE_.fqn;
      }()) {
        return i;
      } else {
        var G__16924 = i + 2;
        i = G__16924;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_symbol_QMARK_ = function cljs$core$array_index_of_symbol_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.str;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (function() {
        var k_SINGLEQUOTE_ = arr[i];
        return k_SINGLEQUOTE_ instanceof cljs.core.Symbol && kstr === k_SINGLEQUOTE_.str;
      }()) {
        return i;
      } else {
        var G__16925 = i + 2;
        i = G__16925;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_identical_QMARK_ = function cljs$core$array_index_of_identical_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (k === arr[i]) {
        return i;
      } else {
        var G__16926 = i + 2;
        i = G__16926;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_equiv_QMARK_ = function cljs$core$array_index_of_equiv_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, arr[i])) {
        return i;
      } else {
        var G__16927 = i + 2;
        i = G__16927;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of = function cljs$core$array_index_of(arr, k) {
  if (k instanceof cljs.core.Keyword) {
    return cljs.core.array_index_of_keyword_QMARK_(arr, k);
  } else {
    if (cljs.core.truth_(function() {
      var or__4309__auto__ = function() {
        var G__16931 = k;
        return goog.isString(G__16931);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        return typeof k === "number";
      }
    }())) {
      return cljs.core.array_index_of_identical_QMARK_(arr, k);
    } else {
      if (k instanceof cljs.core.Symbol) {
        return cljs.core.array_index_of_symbol_QMARK_(arr, k);
      } else {
        if (k == null) {
          return cljs.core.array_index_of_nil_QMARK_(arr);
        } else {
          return cljs.core.array_index_of_equiv_QMARK_(arr, k);
        }
      }
    }
  }
};
cljs.core.array_map_index_of = function cljs$core$array_map_index_of(m, k) {
  return cljs.core.array_index_of(m.arr, k);
};
cljs.core.array_extend_kv = function cljs$core$array_extend_kv(arr, k, v) {
  var l = arr.length;
  var narr = new Array(l + 2);
  var i_16932 = 0;
  while (true) {
    if (i_16932 < l) {
      narr[i_16932] = arr[i_16932];
      var G__16933 = i_16932 + 1;
      i_16932 = G__16933;
      continue;
    } else {
    }
    break;
  }
  narr[l] = k;
  narr[l + 1] = v;
  return narr;
};
cljs.core.array_map_extend_kv = function cljs$core$array_map_extend_kv(m, k, v) {
  return cljs.core.array_extend_kv(m.arr, k, v);
};
cljs.core.PersistentArrayMapSeq = function(arr, i, _meta) {
  this.arr = arr;
  this.i = i;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentArrayMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return (self__.arr.length - self__.i) / 2;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i, new_meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentArrayMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentArrayMapSeq");
};
cljs.core.__GT_PersistentArrayMapSeq = function cljs$core$__GT_PersistentArrayMapSeq(arr, i, _meta) {
  return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
};
cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.persistent_array_map_seq = function cljs$core$persistent_array_map_seq(arr, i, _meta) {
  if (i <= arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapIterator = function(arr, i, cnt) {
  this.arr = arr;
  this.i = i;
  this.cnt = cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
  self__.i = self__.i + 2;
  return ret;
};
cljs.core.PersistentArrayMapIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null)], null);
};
cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentArrayMapIterator");
};
cljs.core.__GT_PersistentArrayMapIterator = function cljs$core$__GT_PersistentArrayMapIterator(arr, i, cnt) {
  return new cljs.core.PersistentArrayMapIterator(arr, i, cnt);
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16647951;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__16935 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__16935) : cljs.core.keys.call(null, G__16935);
  }());
};
cljs.core.PersistentArrayMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentArrayMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__16936 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__16936) : cljs.core.vals.call(null, G__16936);
  }());
};
cljs.core.PersistentArrayMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentArrayMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__16937 = cljs.core.seq(coll);
  var chunk__16938 = null;
  var count__16939 = 0;
  var i__16940 = 0;
  while (true) {
    if (i__16940 < count__16939) {
      var vec__16941 = chunk__16938.cljs$core$IIndexed$_nth$arity$2(null, i__16940);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16941, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16941, 1, null);
      var G__16942_16955 = v;
      var G__16943_16956 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16942_16955, G__16943_16956) : f.call(null, G__16942_16955, G__16943_16956);
      var G__16957 = seq__16937;
      var G__16958 = chunk__16938;
      var G__16959 = count__16939;
      var G__16960 = i__16940 + 1;
      seq__16937 = G__16957;
      chunk__16938 = G__16958;
      count__16939 = G__16959;
      i__16940 = G__16960;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__16937);
      if (temp__4425__auto__) {
        var seq__16937__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__16937__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__16937__$1);
          var G__16961 = cljs.core.chunk_rest(seq__16937__$1);
          var G__16962 = c__5094__auto__;
          var G__16963 = cljs.core.count(c__5094__auto__);
          var G__16964 = 0;
          seq__16937 = G__16961;
          chunk__16938 = G__16962;
          count__16939 = G__16963;
          i__16940 = G__16964;
          continue;
        } else {
          var vec__16944 = cljs.core.first(seq__16937__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16944, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16944, 1, null);
          var G__16945_16965 = v;
          var G__16946_16966 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16945_16965, G__16946_16966) : f.call(null, G__16945_16965, G__16946_16966);
          var G__16967 = cljs.core.next(seq__16937__$1);
          var G__16968 = null;
          var G__16969 = 0;
          var G__16970 = 0;
          seq__16937 = G__16967;
          chunk__16938 = G__16968;
          count__16939 = G__16969;
          i__16940 = G__16970;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return not_found;
  } else {
    return self__.arr[idx + 1];
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var G__16947 = init__$1;
        var G__16948 = self__.arr[i];
        var G__16949 = self__.arr[i + 1];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16947, G__16948, G__16949) : f.call(null, G__16947, G__16948, G__16949);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__16950 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__16950) : cljs.core.deref.call(null, G__16950);
      } else {
        var G__16971 = i + 2;
        var G__16972 = init__$2;
        i = G__16971;
        init__$1 = G__16972;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.PersistentArrayMapIterator(self__.arr, 0, self__.cnt * 2);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (function() {
    var G__16951 = other;
    if (G__16951) {
      var bit__4976__auto__ = G__16951.cljs$lang$protocol_mask$partition0$ & 1024;
      if (bit__4976__auto__ || G__16951.cljs$core$IMap$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    var alen = self__.arr.length;
    var other__$1 = other;
    if (self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null)) {
      var i = 0;
      while (true) {
        if (i < alen) {
          var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, self__.arr[i], cljs.core.lookup_sentinel);
          if (!(v === cljs.core.lookup_sentinel)) {
            if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[i + 1], v)) {
              var G__16973 = i + 2;
              i = G__16973;
              continue;
            } else {
              return false;
            }
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_map(coll__$1, other);
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientArrayMap(function() {
    var obj16953 = {};
    return obj16953;
  }(), self__.arr.length, cljs.core.aclone(self__.arr));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY, self__.meta);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx >= 0) {
    var len = self__.arr.length;
    var new_len = len - 2;
    if (new_len === 0) {
      return cljs.core._empty(coll__$1);
    } else {
      var new_arr = new Array(new_len);
      var s = 0;
      var d = 0;
      while (true) {
        if (s >= len) {
          return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt - 1, new_arr, null);
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, self__.arr[s])) {
            var G__16974 = s + 2;
            var G__16975 = d;
            s = G__16974;
            d = G__16975;
            continue;
          } else {
            new_arr[d] = self__.arr[s];
            new_arr[d + 1] = self__.arr[s + 1];
            var G__16976 = s + 2;
            var G__16977 = d + 2;
            s = G__16976;
            d = G__16977;
            continue;
          }
        }
        break;
      }
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    if (self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      var arr__$1 = cljs.core.array_map_extend_kv(coll__$1, k, v);
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt + 1, arr__$1, null);
    } else {
      return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1), k, v), self__.meta);
    }
  } else {
    if (v === self__.arr[idx + 1]) {
      return coll__$1;
    } else {
      var arr__$1 = function() {
        var G__16954 = cljs.core.aclone(self__.arr);
        G__16954[idx + 1] = v;
        return G__16954;
      }();
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, arr__$1, null);
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(cljs.core.array_map_index_of(coll__$1, k) === -1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.persistent_array_map_seq(self__.arr, 0, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMap(meta__$1, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__16978 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__16979 = cljs.core.next(es);
          ret = G__16978;
          es = G__16979;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__16980 = null;
  var G__16980__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__16980__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__16980 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__16980__2.call(this, self__, k);
      case 3:
        return G__16980__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16980.cljs$core$IFn$_invoke$arity$2 = G__16980__2;
  G__16980.cljs$core$IFn$_invoke$arity$3 = G__16980__3;
  return G__16980;
}();
cljs.core.PersistentArrayMap.prototype.apply = function(self__, args16934) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16934)));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";
cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentArrayMap");
};
cljs.core.__GT_PersistentArrayMap = function cljs$core$__GT_PersistentArrayMap(meta, cnt, arr, __hash) {
  return new cljs.core.PersistentArrayMap(meta, cnt, arr, __hash);
};
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], cljs.core.empty_unordered_hash);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 8;
cljs.core.PersistentArrayMap.fromArray = function(arr, no_clone, no_check) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var arr__$2 = no_check ? arr__$1 : function() {
    var ret = [];
    var i_16981 = 0;
    while (true) {
      if (i_16981 < arr__$1.length) {
        var k_16982 = arr__$1[i_16981];
        var v_16983 = arr__$1[i_16981 + 1];
        var idx_16984 = cljs.core.array_index_of(ret, k_16982);
        if (idx_16984 === -1) {
          ret.push(k_16982);
          ret.push(v_16983);
        } else {
        }
        var G__16985 = i_16981 + 2;
        i_16981 = G__16985;
        continue;
      } else {
      }
      break;
    }
    return ret;
  }();
  var arr__$3 = function() {
    var cnt = arr__$2.length / 2;
    return new cljs.core.PersistentArrayMap(null, cnt, arr__$2, null);
  }();
  return arr__$3;
};
cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    return cljs.core.quot(self__.len, 2);
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, k, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, k);
    if (idx === -1) {
      return not_found;
    } else {
      return self__.arr[idx + 1];
    }
  } else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    if (function() {
      var G__16986 = o;
      if (G__16986) {
        var bit__4983__auto__ = G__16986.cljs$lang$protocol_mask$partition0$ & 2048;
        if (bit__4983__auto__ || G__16986.cljs$core$IMapEntry$) {
          return true;
        } else {
          if (!G__16986.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__16986);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__16986);
      }
    }()) {
      return cljs.core._assoc_BANG_(tcoll__$1, function() {
        var G__16987 = o;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__16987) : cljs.core.key.call(null, G__16987);
      }(), function() {
        var G__16988 = o;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__16988) : cljs.core.val.call(null, G__16988);
      }());
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$2 = tcoll__$1;
      while (true) {
        var temp__4423__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          var G__16994 = cljs.core.next(es);
          var G__16995 = cljs.core._assoc_BANG_(tcoll__$2, function() {
            var G__16989 = e;
            return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__16989) : cljs.core.key.call(null, G__16989);
          }(), function() {
            var G__16990 = e;
            return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__16990) : cljs.core.val.call(null, G__16990);
          }());
          es = G__16994;
          tcoll__$2 = G__16995;
          continue;
        } else {
          return tcoll__$2;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    self__.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot(self__.len, 2), self__.arr, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx === -1) {
      if (self__.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        self__.len = self__.len + 2;
        self__.arr.push(key);
        self__.arr.push(val);
        return tcoll__$1;
      } else {
        return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(function() {
          var G__16991 = self__.len;
          var G__16992 = self__.arr;
          return cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__16991, G__16992) : cljs.core.array__GT_transient_hash_map.call(null, G__16991, G__16992);
        }(), key, val);
      }
    } else {
      if (val === self__.arr[idx + 1]) {
        return tcoll__$1;
      } else {
        self__.arr[idx + 1] = val;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx >= 0) {
      self__.arr[idx] = self__.arr[self__.len - 2];
      self__.arr[idx + 1] = self__.arr[self__.len - 1];
      var G__16993_16996 = self__.arr;
      G__16993_16996.pop();
      G__16993_16996.pop();
      self__.len = self__.len - 2;
    } else {
    }
    return tcoll__$1;
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "editable?", "editable?", -164945806, null), new cljs.core.Symbol(null, "len", "len", -1230778691, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";
cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientArrayMap");
};
cljs.core.__GT_TransientArrayMap = function cljs$core$__GT_TransientArrayMap(editable_QMARK_, len, arr) {
  return new cljs.core.TransientArrayMap(editable_QMARK_, len, arr);
};
cljs.core.array__GT_transient_hash_map = function cljs$core$array__GT_transient_hash_map(len, arr) {
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i = 0;
  while (true) {
    if (i < len) {
      var G__16997 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, arr[i], arr[i + 1]);
      var G__16998 = i + 2;
      out = G__16997;
      i = G__16998;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.Box = function(val) {
  this.val = val;
};
cljs.core.Box.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";
cljs.core.Box.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Box");
};
cljs.core.__GT_Box = function cljs$core$__GT_Box(val) {
  return new cljs.core.Box(val);
};
cljs.core.key_test = function cljs$core$key_test(key, other) {
  if (key === other) {
    return true;
  } else {
    if (cljs.core.keyword_identical_QMARK_(key, other)) {
      return true;
    } else {
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key, other);
    }
  }
};
cljs.core.mask = function cljs$core$mask(hash, shift) {
  return hash >>> shift & 31;
};
cljs.core.clone_and_set = function cljs$core$clone_and_set() {
  var G__17000 = arguments.length;
  switch(G__17000) {
    case 3:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = function(arr, i, a) {
  var G__17001 = cljs.core.aclone(arr);
  G__17001[i] = a;
  return G__17001;
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = function(arr, i, a, j, b) {
  var G__17002 = cljs.core.aclone(arr);
  G__17002[i] = a;
  G__17002[j] = b;
  return G__17002;
};
cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = function cljs$core$remove_pair(arr, i) {
  var new_arr = new Array(arr.length - 2);
  cljs.core.array_copy(arr, 0, new_arr, 0, 2 * i);
  cljs.core.array_copy(arr, 2 * (i + 1), new_arr, 2 * i, new_arr.length - 2 * i);
  return new_arr;
};
cljs.core.bitmap_indexed_node_index = function cljs$core$bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count(bitmap & bit - 1);
};
cljs.core.bitpos = function cljs$core$bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31);
};
cljs.core.edit_and_set = function cljs$core$edit_and_set() {
  var G__17005 = arguments.length;
  switch(G__17005) {
    case 4:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 6:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = function(inode, edit, i, a) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  return editable;
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = function(inode, edit, i, a, j, b) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  editable.arr[j] = b;
  return editable;
};
cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = function cljs$core$inode_kv_reduce(arr, f, init) {
  var len = arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var k = arr[i];
        if (!(k == null)) {
          var G__17011 = init__$1;
          var G__17012 = k;
          var G__17013 = arr[i + 1];
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17011, G__17012, G__17013) : f.call(null, G__17011, G__17012, G__17013);
        } else {
          var node = arr[i + 1];
          if (!(node == null)) {
            return node.kv_reduce(f, init__$1);
          } else {
            return init__$1;
          }
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__17014 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__17014) : cljs.core.deref.call(null, G__17014);
      } else {
        var G__17015 = i + 2;
        var G__17016 = init__$2;
        i = G__17015;
        init__$1 = G__17016;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr;
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var n = cljs.core.bit_count(self__.bitmap);
    var new_arr = new Array(n < 0 ? 4 : 2 * (n + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * n);
    return new cljs.core.BitmapIndexedNode(e, self__.bitmap, new_arr);
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return inode.edit_and_remove_pair(edit__$1, bit, idx);
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        removed_leaf_QMARK_[0] = true;
        return inode.edit_and_remove_pair(edit__$1, bit, idx);
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var self__ = this;
  var inode = this;
  if (self__.bitmap === bit) {
    return null;
  } else {
    var editable = inode.ensure_editable(e);
    var earr = editable.arr;
    var len = earr.length;
    editable.bitmap = bit ^ editable.bitmap;
    cljs.core.array_copy(earr, 2 * (i + 1), earr, 2 * i, len - 2 * (i + 1));
    earr[len - 2] = null;
    earr[len - 1] = null;
    return editable;
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__17017 = self__.arr;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__17017) : cljs.core.create_inode_seq.call(null, G__17017);
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_lookup(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return val_or_node;
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (2 * n < self__.arr.length) {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward(earr, 2 * idx, earr, 2 * (idx + 1), 2 * (n - idx));
      earr[2 * idx] = key;
      earr[2 * idx + 1] = val;
      editable.bitmap = editable.bitmap | bit;
      return editable;
    } else {
      if (n >= 16) {
        var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var jdx = hash >>> shift & 31;
        nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i_17031 = 0;
        var j_17032 = 0;
        while (true) {
          if (i_17031 < 32) {
            if ((self__.bitmap >>> i_17031 & 1) === 0) {
              var G__17033 = i_17031 + 1;
              var G__17034 = j_17032;
              i_17031 = G__17033;
              j_17032 = G__17034;
              continue;
            } else {
              nodes[i_17031] = !(self__.arr[j_17032] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, cljs.core.hash(self__.arr[j_17032]), self__.arr[j_17032], self__.arr[j_17032 + 1], added_leaf_QMARK_) : self__.arr[j_17032 + 1];
              var G__17035 = i_17031 + 1;
              var G__17036 = j_17032 + 2;
              i_17031 = G__17035;
              j_17032 = G__17036;
              continue;
            }
          } else {
          }
          break;
        }
        return new cljs.core.ArrayNode(edit__$1, n + 1, nodes);
      } else {
        var new_arr = new Array(2 * (n + 4));
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
        new_arr[2 * idx] = key;
        new_arr[2 * idx + 1] = val;
        cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
        added_leaf_QMARK_.val = true;
        var editable = inode.ensure_editable(edit__$1);
        editable.arr = new_arr;
        editable.bitmap = editable.bitmap | bit;
        return editable;
      }
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, val);
        }
      } else {
        added_leaf_QMARK_.val = true;
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * idx, null, 2 * idx + 1, function() {
          var G__17018 = edit__$1;
          var G__17019 = shift + 5;
          var G__17020 = key_or_nil;
          var G__17021 = val_or_node;
          var G__17022 = hash;
          var G__17023 = key;
          var G__17024 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__17018, G__17019, G__17020, G__17021, G__17022, G__17023, G__17024) : cljs.core.create_node.call(null, G__17018, G__17019, G__17020, G__17021, G__17022, G__17023, G__17024);
        }());
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (n >= 16) {
      var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      var jdx = hash >>> shift & 31;
      nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i_17037 = 0;
      var j_17038 = 0;
      while (true) {
        if (i_17037 < 32) {
          if ((self__.bitmap >>> i_17037 & 1) === 0) {
            var G__17039 = i_17037 + 1;
            var G__17040 = j_17038;
            i_17037 = G__17039;
            j_17038 = G__17040;
            continue;
          } else {
            nodes[i_17037] = !(self__.arr[j_17038] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash(self__.arr[j_17038]), self__.arr[j_17038], self__.arr[j_17038 + 1], added_leaf_QMARK_) : self__.arr[j_17038 + 1];
            var G__17041 = i_17037 + 1;
            var G__17042 = j_17038 + 2;
            i_17037 = G__17041;
            j_17038 = G__17042;
            continue;
          }
        } else {
        }
        break;
      }
      return new cljs.core.ArrayNode(null, n + 1, nodes);
    } else {
      var new_arr = new Array(2 * (n + 1));
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
      new_arr[2 * idx] = key;
      new_arr[2 * idx + 1] = val;
      cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, self__.bitmap | bit, new_arr);
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, val));
        }
      } else {
        added_leaf_QMARK_.val = true;
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr, 2 * idx, null, 2 * idx + 1, function() {
          var G__17025 = shift + 5;
          var G__17026 = key_or_nil;
          var G__17027 = val_or_node;
          var G__17028 = hash;
          var G__17029 = key;
          var G__17030 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__17025, G__17026, G__17027, G__17028, G__17029, G__17030) : cljs.core.create_node.call(null, G__17025, G__17026, G__17027, G__17028, G__17029, G__17030);
        }()));
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_find(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil, val_or_node], null);
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without(shift + 5, hash, key);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "bitmap", "bitmap", 501334601, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/BitmapIndexedNode");
};
cljs.core.__GT_BitmapIndexedNode = function cljs$core$__GT_BitmapIndexedNode(edit, bitmap, arr) {
  return new cljs.core.BitmapIndexedNode(edit, bitmap, arr);
};
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, []);
cljs.core.pack_array_node = function cljs$core$pack_array_node(array_node, edit, idx) {
  var arr = array_node.arr;
  var len = arr.length;
  var new_arr = new Array(2 * (array_node.cnt - 1));
  var i = 0;
  var j = 1;
  var bitmap = 0;
  while (true) {
    if (i < len) {
      if (!(i === idx) && !(arr[i] == null)) {
        new_arr[j] = arr[i];
        var G__17043 = i + 1;
        var G__17044 = j + 2;
        var G__17045 = bitmap | 1 << i;
        i = G__17043;
        j = G__17044;
        bitmap = G__17045;
        continue;
      } else {
        var G__17046 = i + 1;
        var G__17047 = j;
        var G__17048 = bitmap;
        i = G__17046;
        j = G__17047;
        bitmap = G__17048;
        continue;
      }
    } else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap, new_arr);
    }
    break;
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    return new cljs.core.ArrayNode(e, self__.cnt, cljs.core.aclone(self__.arr));
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return inode;
  } else {
    var n = node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, edit__$1, idx);
        } else {
          var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
          editable.cnt = editable.cnt - 1;
          return editable;
        }
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
      }
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__17049 = self__.arr;
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__17049) : cljs.core.create_array_node_seq.call(null, G__17049);
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var node = self__.arr[i];
      if (!(node == null)) {
        var init__$2 = node.kv_reduce(f, init__$1);
        if (cljs.core.reduced_QMARK_(init__$2)) {
          var G__17050 = init__$2;
          return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__17050) : cljs.core.deref.call(null, G__17050);
        } else {
          var G__17051 = i + 1;
          var G__17052 = init__$2;
          i = G__17051;
          init__$1 = G__17052;
          continue;
        }
      } else {
        var G__17053 = i + 1;
        var G__17054 = init__$1;
        i = G__17053;
        init__$1 = G__17054;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_lookup(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable.cnt = editable.cnt + 1;
    return editable;
  } else {
    var n = node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
    }
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return new cljs.core.ArrayNode(null, self__.cnt + 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)));
  } else {
    var n = node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
    }
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_find(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    var n = node.inode_without(shift + 5, hash, key);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, null, idx);
        } else {
          return new cljs.core.ArrayNode(null, self__.cnt - 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
        }
      } else {
        return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
      }
    }
  } else {
    return inode;
  }
};
cljs.core.ArrayNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";
cljs.core.ArrayNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayNode");
};
cljs.core.__GT_ArrayNode = function cljs$core$__GT_ArrayNode(edit, cnt, arr) {
  return new cljs.core.ArrayNode(edit, cnt, arr);
};
cljs.core.hash_collision_node_find_index = function cljs$core$hash_collision_node_find_index(arr, cnt, key) {
  var lim = 2 * cnt;
  var i = 0;
  while (true) {
    if (i < lim) {
      if (cljs.core.key_test(key, arr[i])) {
        return i;
      } else {
        var G__17055 = i + 2;
        i = G__17055;
        continue;
      }
    } else {
      return -1;
    }
    break;
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var new_arr = new Array(2 * (self__.cnt + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * self__.cnt);
    return new cljs.core.HashCollisionNode(e, self__.collision_hash, self__.cnt, new_arr);
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    removed_leaf_QMARK_[0] = true;
    if (self__.cnt === 1) {
      return null;
    } else {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      earr[idx] = earr[2 * self__.cnt - 2];
      earr[idx + 1] = earr[2 * self__.cnt - 1];
      earr[2 * self__.cnt - 1] = null;
      earr[2 * self__.cnt - 2] = null;
      editable.cnt = editable.cnt - 1;
      return editable;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__17056 = self__.arr;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__17056) : cljs.core.create_inode_seq.call(null, G__17056);
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return self__.arr[idx + 1];
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      if (self__.arr.length > 2 * self__.cnt) {
        var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * self__.cnt, key, 2 * self__.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable.cnt = editable.cnt + 1;
        return editable;
      } else {
        var len = self__.arr.length;
        var new_arr = new Array(len + 2);
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
        new_arr[len] = key;
        new_arr[len + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode.ensure_editable_array(edit__$1, self__.cnt + 1, new_arr);
      }
    } else {
      if (self__.arr[idx + 1] === val) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx + 1, val);
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(edit__$1, 1 << (self__.collision_hash >>> shift & 31), [null, inode, null, null])).inode_assoc_BANG_(edit__$1, shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      var len = 2 * self__.cnt;
      var new_arr = new Array(len + 2);
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
      new_arr[len] = key;
      new_arr[len + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt + 1, new_arr);
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[idx], val)) {
        return inode;
      } else {
        return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx + 1, val));
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(null, 1 << (self__.collision_hash >>> shift & 31), [null, inode])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    self__.arr = array;
    self__.cnt = count;
    return inode;
  } else {
    return new cljs.core.HashCollisionNode(self__.edit, self__.collision_hash, count, array);
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[idx], self__.arr[idx + 1]], null);
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    if (self__.cnt === 1) {
      return null;
    } else {
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt - 1, cljs.core.remove_pair(self__.arr, cljs.core.quot(idx, 2)));
    }
  }
};
cljs.core.HashCollisionNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "collision-hash", "collision-hash", -35831342, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";
cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/HashCollisionNode");
};
cljs.core.__GT_HashCollisionNode = function cljs$core$__GT_HashCollisionNode(edit, collision_hash, cnt, arr) {
  return new cljs.core.HashCollisionNode(edit, collision_hash, cnt, arr);
};
cljs.core.create_node = function cljs$core$create_node() {
  var G__17058 = arguments.length;
  switch(G__17058) {
    case 6:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = function(shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$lang$maxFixedArity = 7;
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.NodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.nodes[self__.i], self__.nodes[self__.i + 1]], null);
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    var G__17060 = self__.nodes;
    var G__17061 = self__.i + 2;
    var G__17062 = null;
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__17060, G__17061, G__17062) : cljs.core.create_inode_seq.call(null, G__17060, G__17061, G__17062);
  } else {
    var G__17063 = self__.nodes;
    var G__17064 = self__.i;
    var G__17065 = cljs.core.next(self__.s);
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__17063, G__17064, G__17065) : cljs.core.create_inode_seq.call(null, G__17063, G__17064, G__17065);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.NodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";
cljs.core.NodeSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/NodeSeq");
};
cljs.core.__GT_NodeSeq = function cljs$core$__GT_NodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.NodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.create_inode_seq = function cljs$core$create_inode_seq() {
  var G__17067 = arguments.length;
  switch(G__17067) {
    case 1:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 3:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes, 0, null);
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = function(nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        if (!(nodes[j] == null)) {
          return new cljs.core.NodeSeq(null, nodes, j, null, null);
        } else {
          var temp__4423__auto__ = nodes[j + 1];
          if (cljs.core.truth_(temp__4423__auto__)) {
            var node = temp__4423__auto__;
            var temp__4423__auto____$1 = node.inode_seq();
            if (cljs.core.truth_(temp__4423__auto____$1)) {
              var node_seq = temp__4423__auto____$1;
              return new cljs.core.NodeSeq(null, nodes, j + 2, node_seq, null);
            } else {
              var G__17069 = j + 2;
              j = G__17069;
              continue;
            }
          } else {
            var G__17070 = j + 2;
            j = G__17070;
            continue;
          }
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.NodeSeq(null, nodes, i, s, null);
  }
};
cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ArrayNodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.s);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__17071 = null;
  var G__17072 = self__.nodes;
  var G__17073 = self__.i;
  var G__17074 = cljs.core.next(self__.s);
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__17071, G__17072, G__17073, G__17074) : cljs.core.create_array_node_seq.call(null, G__17071, G__17072, G__17073, G__17074);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ArrayNodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayNodeSeq");
};
cljs.core.__GT_ArrayNodeSeq = function cljs$core$__GT_ArrayNodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.create_array_node_seq = function cljs$core$create_array_node_seq() {
  var G__17076 = arguments.length;
  switch(G__17076) {
    case 1:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 4:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null, nodes, 0, null);
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = function(meta, nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        var temp__4423__auto__ = nodes[j];
        if (cljs.core.truth_(temp__4423__auto__)) {
          var nj = temp__4423__auto__;
          var temp__4423__auto____$1 = nj.inode_seq();
          if (cljs.core.truth_(temp__4423__auto____$1)) {
            var ns = temp__4423__auto____$1;
            return new cljs.core.ArrayNodeSeq(meta, nodes, j + 1, ns, null);
          } else {
            var G__17078 = j + 1;
            j = G__17078;
            continue;
          }
        } else {
          var G__17079 = j + 1;
          j = G__17079;
          continue;
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null);
  }
};
cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__17081 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__17081) : cljs.core.keys.call(null, G__17081);
  }());
};
cljs.core.PersistentHashMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__17082 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__17082) : cljs.core.vals.call(null, G__17082);
  }());
};
cljs.core.PersistentHashMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__17083 = cljs.core.seq(coll);
  var chunk__17084 = null;
  var count__17085 = 0;
  var i__17086 = 0;
  while (true) {
    if (i__17086 < count__17085) {
      var vec__17087 = chunk__17084.cljs$core$IIndexed$_nth$arity$2(null, i__17086);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17087, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17087, 1, null);
      var G__17088_17099 = v;
      var G__17089_17100 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17088_17099, G__17089_17100) : f.call(null, G__17088_17099, G__17089_17100);
      var G__17101 = seq__17083;
      var G__17102 = chunk__17084;
      var G__17103 = count__17085;
      var G__17104 = i__17086 + 1;
      seq__17083 = G__17101;
      chunk__17084 = G__17102;
      count__17085 = G__17103;
      i__17086 = G__17104;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__17083);
      if (temp__4425__auto__) {
        var seq__17083__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__17083__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__17083__$1);
          var G__17105 = cljs.core.chunk_rest(seq__17083__$1);
          var G__17106 = c__5094__auto__;
          var G__17107 = cljs.core.count(c__5094__auto__);
          var G__17108 = 0;
          seq__17083 = G__17105;
          chunk__17084 = G__17106;
          count__17085 = G__17107;
          i__17086 = G__17108;
          continue;
        } else {
          var vec__17090 = cljs.core.first(seq__17083__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17090, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17090, 1, null);
          var G__17091_17109 = v;
          var G__17092_17110 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17091_17109, G__17092_17110) : f.call(null, G__17091_17109, G__17092_17110);
          var G__17111 = cljs.core.next(seq__17083__$1);
          var G__17112 = null;
          var G__17113 = 0;
          var G__17114 = 0;
          seq__17083 = G__17111;
          chunk__17084 = G__17112;
          count__17085 = G__17113;
          i__17086 = G__17114;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var init__$1 = self__.has_nil_QMARK_ ? function() {
    var G__17093 = init;
    var G__17094 = null;
    var G__17095 = self__.nil_val;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17093, G__17094, G__17095) : f.call(null, G__17093, G__17094, G__17095);
  }() : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    var G__17096 = init__$1;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__17096) : cljs.core.deref.call(null, G__17096);
  } else {
    if (!(self__.root == null)) {
      return self__.root.kv_reduce(f, init__$1);
    } else {
      return init__$1;
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashMap(self__.meta, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashMap(function() {
    var obj17098 = {};
    return obj17098;
  }(), self__.root, self__.cnt, self__.has_nil_QMARK_, self__.nil_val);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY, self__.meta);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, self__.root, false, null, null);
    } else {
      return coll__$1;
    }
  } else {
    if (self__.root == null) {
      return coll__$1;
    } else {
      var new_root = self__.root.inode_without(0, cljs.core.hash(k), k);
      if (new_root === self__.root) {
        return coll__$1;
      } else {
        return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_ && v === self__.nil_val) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, self__.has_nil_QMARK_ ? self__.cnt : self__.cnt + 1, self__.root, true, v, null);
    }
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    var new_root = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc(0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
    if (new_root === self__.root) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, added_leaf_QMARK_.val ? self__.cnt + 1 : self__.cnt, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    return self__.has_nil_QMARK_;
  } else {
    if (self__.root == null) {
      return false;
    } else {
      return !(self__.root.inode_lookup(0, cljs.core.hash(k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var s = !(self__.root == null) ? self__.root.inode_seq() : null;
    if (self__.has_nil_QMARK_) {
      return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null), s);
    } else {
      return s;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashMap(meta__$1, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__17115 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__17116 = cljs.core.next(es);
          ret = G__17115;
          es = G__17116;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__17117 = null;
  var G__17117__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__17117__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__17117 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17117__2.call(this, self__, k);
      case 3:
        return G__17117__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17117.cljs$core$IFn$_invoke$arity$2 = G__17117__2;
  G__17117.cljs$core$IFn$_invoke$arity$3 = G__17117__3;
  return G__17117;
}();
cljs.core.PersistentHashMap.prototype.apply = function(self__, args17080) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17080)));
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";
cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentHashMap");
};
cljs.core.__GT_PersistentHashMap = function cljs$core$__GT_PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  return new cljs.core.PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash);
};
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashMap.fromArray = function(arr, no_clone) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var len = arr__$1.length;
  var i = 0;
  var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__17118 = i + 2;
      var G__17119 = cljs.core._assoc_BANG_(ret, arr__$1[i], arr__$1[i + 1]);
      i = G__17118;
      ret = G__17119;
      continue;
    } else {
      return cljs.core._persistent_BANG_(ret);
    }
    break;
  }
};
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len = ks.length;
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__17120 = i + 1;
      var G__17121 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, ks[i], vs[i]);
      i = G__17120;
      out = G__17121;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (function() {
      var G__17122 = o;
      if (G__17122) {
        var bit__4983__auto__ = G__17122.cljs$lang$protocol_mask$partition0$ & 2048;
        if (bit__4983__auto__ || G__17122.cljs$core$IMapEntry$) {
          return true;
        } else {
          if (!G__17122.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__17122);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__17122);
      }
    }()) {
      return tcoll.assoc_BANG_(function() {
        var G__17123 = o;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__17123) : cljs.core.key.call(null, G__17123);
      }(), function() {
        var G__17124 = o;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__17124) : cljs.core.val.call(null, G__17124);
      }());
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$1 = tcoll;
      while (true) {
        var temp__4423__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          var G__17127 = cljs.core.next(es);
          var G__17128 = tcoll__$1.assoc_BANG_(function() {
            var G__17125 = e;
            return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__17125) : cljs.core.key.call(null, G__17125);
          }(), function() {
            var G__17126 = e;
            return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__17126) : cljs.core.val.call(null, G__17126);
          }());
          es = G__17127;
          tcoll__$1 = G__17128;
          continue;
        } else {
          return tcoll__$1;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.nil_val === v) {
      } else {
        self__.nil_val = v;
      }
      if (self__.has_nil_QMARK_) {
      } else {
        self__.count = self__.count + 1;
        self__.has_nil_QMARK_ = true;
      }
      return tcoll;
    } else {
      var added_leaf_QMARK_ = new cljs.core.Box(false);
      var node = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc_BANG_(self__.edit, 0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
      if (node === self__.root) {
      } else {
        self__.root = node;
      }
      if (added_leaf_QMARK_.val) {
        self__.count = self__.count + 1;
      } else {
      }
      return tcoll;
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.has_nil_QMARK_) {
        self__.has_nil_QMARK_ = false;
        self__.nil_val = null;
        self__.count = self__.count - 1;
        return tcoll;
      } else {
        return tcoll;
      }
    } else {
      if (self__.root == null) {
        return tcoll;
      } else {
        var removed_leaf_QMARK_ = new cljs.core.Box(false);
        var node = self__.root.inode_without_BANG_(self__.edit, 0, cljs.core.hash(k), k, removed_leaf_QMARK_);
        if (node === self__.root) {
        } else {
          self__.root = node;
        }
        if (cljs.core.truth_(removed_leaf_QMARK_[0])) {
          self__.count = self__.count - 1;
        } else {
        }
        return tcoll;
      }
    }
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    self__.edit = null;
    return new cljs.core.PersistentHashMap(null, self__.count, self__.root, self__.has_nil_QMARK_, self__.nil_val, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.edit) {
    return self__.count;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return null;
    }
  } else {
    if (self__.root == null) {
      return null;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.conj_BANG_(val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.persistent_BANG_();
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.assoc_BANG_(key, val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.without_BANG_(key);
};
cljs.core.TransientHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null)], null);
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";
cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientHashMap");
};
cljs.core.__GT_TransientHashMap = function cljs$core$__GT_TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val) {
  return new cljs.core.TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val);
};
cljs.core.tree_map_seq_push = function cljs$core$tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t = node;
  var stack__$1 = stack;
  while (true) {
    if (!(t == null)) {
      var G__17129 = ascending_QMARK_ ? t.left : t.right;
      var G__17130 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1, t);
      t = G__17129;
      stack__$1 = G__17130;
      continue;
    } else {
      return stack__$1;
    }
    break;
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374862;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt < 0) {
    return cljs.core.count(cljs.core.next(coll__$1)) + 1;
  } else {
    return self__.cnt;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.peek(self__.stack);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var t = cljs.core.first(self__.stack);
  var next_stack = cljs.core.tree_map_seq_push(self__.ascending_QMARK_ ? t.right : t.left, cljs.core.next(self__.stack), self__.ascending_QMARK_);
  if (!(next_stack == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack, self__.ascending_QMARK_, self__.cnt - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMapSeq(meta__$1, self__.stack, self__.ascending_QMARK_, self__.cnt, self__.__hash);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentTreeMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "stack", "stack", 847125597, null), new cljs.core.Symbol(null, "ascending?", "ascending?", -1938452653, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentTreeMapSeq");
};
cljs.core.__GT_PersistentTreeMapSeq = function cljs$core$__GT_PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash) {
  return new cljs.core.PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash);
};
cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.create_tree_map_seq = function cljs$core$create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push(tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null);
};
cljs.core.balance_left = function cljs$core$balance_left(key, val, ins, right) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null);
    } else {
      if (ins.right instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, ins, right, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, ins, right, null);
  }
};
cljs.core.balance_right = function cljs$core$balance_right(key, val, left, ins) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null);
    } else {
      if (ins.left instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, left, ins, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, left, ins, null);
  }
};
cljs.core.balance_left_del = function cljs$core$balance_left_del(key, val, del, right) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null);
  } else {
    if (right instanceof cljs.core.BlackNode) {
      return cljs.core.balance_right(key, val, del, right.redden());
    } else {
      if (right instanceof cljs.core.RedNode && right.left instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right(right.key, right.val, right.left.right, right.right.redden()), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.balance_right_del = function cljs$core$balance_right_del(key, val, left, del) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null);
  } else {
    if (left instanceof cljs.core.BlackNode) {
      return cljs.core.balance_left(key, val, left.redden(), del);
    } else {
      if (left instanceof cljs.core.RedNode && left.right instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left(left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function cljs$core$tree_map_kv_reduce(node, f, init) {
  var init__$1 = !(node.left == null) ? cljs$core$tree_map_kv_reduce(node.left, f, init) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    var G__17143 = init__$1;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__17143) : cljs.core.deref.call(null, G__17143);
  } else {
    var init__$2 = function() {
      var G__17144 = init__$1;
      var G__17145 = node.key;
      var G__17146 = node.val;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17144, G__17145, G__17146) : f.call(null, G__17144, G__17145, G__17146);
    }();
    if (cljs.core.reduced_QMARK_(init__$2)) {
      var G__17147 = init__$2;
      return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__17147) : cljs.core.deref.call(null, G__17147);
    } else {
      var init__$3 = !(node.right == null) ? cljs$core$tree_map_kv_reduce(node.right, f, init__$2) : init__$2;
      if (cljs.core.reduced_QMARK_(init__$3)) {
        var G__17148 = init__$3;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__17148) : cljs.core.deref.call(null, G__17148);
      } else {
        return init__$3;
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_right(node);
};
cljs.core.BlackNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.BlackNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return node;
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_left(node);
};
cljs.core.BlackNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
};
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_left_del(self__.key, self__.val, del, self__.right);
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_right_del(self__.key, self__.val, self__.left, del);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY, self__.val), self__.key);
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.BlackNode.prototype.call = function() {
  var G__17150 = null;
  var G__17150__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__17150__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__17150 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17150__2.call(this, self__, k);
      case 3:
        return G__17150__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17150.cljs$core$IFn$_invoke$arity$2 = G__17150__2;
  G__17150.cljs$core$IFn$_invoke$arity$3 = G__17150__3;
  return G__17150;
}();
cljs.core.BlackNode.prototype.apply = function(self__, args17149) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17149)));
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.BlackNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";
cljs.core.BlackNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/BlackNode");
};
cljs.core.__GT_BlackNode = function cljs$core$__GT_BlackNode(key, val, left, right, __hash) {
  return new cljs.core.BlackNode(key, val, left, right, __hash);
};
cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, ins, null);
};
cljs.core.RedNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, ins, self__.right, null);
};
cljs.core.RedNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.left instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, self__.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, self__.right, parent.right, null), null);
  } else {
    if (self__.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.right.key, self__.right.val, new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, self__.right.right, parent.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
    }
  }
};
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.right instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left, null), self__.right.blacken(), null);
  } else {
    if (self__.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.left.key, self__.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left.left, null), new cljs.core.BlackNode(self__.key, self__.val, self__.left.right, self__.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
    }
  }
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, del, self__.right, null);
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, del, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY, self__.val), self__.key);
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.RedNode.prototype.call = function() {
  var G__17152 = null;
  var G__17152__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__17152__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__17152 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17152__2.call(this, self__, k);
      case 3:
        return G__17152__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17152.cljs$core$IFn$_invoke$arity$2 = G__17152__2;
  G__17152.cljs$core$IFn$_invoke$arity$3 = G__17152__3;
  return G__17152;
}();
cljs.core.RedNode.prototype.apply = function(self__, args17151) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17151)));
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.RedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";
cljs.core.RedNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RedNode");
};
cljs.core.__GT_RedNode = function cljs$core$__GT_RedNode(key, val, left, right, __hash) {
  return new cljs.core.RedNode(key, val, left, right, __hash);
};
cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.tree_map_add = function cljs$core$tree_map_add(comp, tree, k, v, found) {
  if (tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null);
  } else {
    var c = function() {
      var G__17165 = k;
      var G__17166 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__17165, G__17166) : comp.call(null, G__17165, G__17166);
    }();
    if (c === 0) {
      found[0] = tree;
      return null;
    } else {
      if (c < 0) {
        var ins = cljs$core$tree_map_add(comp, tree.left, k, v, found);
        if (!(ins == null)) {
          return tree.add_left(ins);
        } else {
          return null;
        }
      } else {
        var ins = cljs$core$tree_map_add(comp, tree.right, k, v, found);
        if (!(ins == null)) {
          return tree.add_right(ins);
        } else {
          return null;
        }
      }
    }
  }
};
cljs.core.tree_map_append = function cljs$core$tree_map_append(left, right) {
  if (left == null) {
    return right;
  } else {
    if (right == null) {
      return left;
    } else {
      if (left instanceof cljs.core.RedNode) {
        if (right instanceof cljs.core.RedNode) {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.RedNode(left.key, left.val, left.left, app.left, null), new cljs.core.RedNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app, right.right, null), null);
          }
        } else {
          return new cljs.core.RedNode(left.key, left.val, left.left, cljs$core$tree_map_append(left.right, right), null);
        }
      } else {
        if (right instanceof cljs.core.RedNode) {
          return new cljs.core.RedNode(right.key, right.val, cljs$core$tree_map_append(left, right.left), right.right, null);
        } else {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.BlackNode(left.key, left.val, left.left, app.left, null), new cljs.core.BlackNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return cljs.core.balance_left_del(left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app, right.right, null));
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function cljs$core$tree_map_remove(comp, tree, k, found) {
  if (!(tree == null)) {
    var c = function() {
      var G__17185 = k;
      var G__17186 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__17185, G__17186) : comp.call(null, G__17185, G__17186);
    }();
    if (c === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append(tree.left, tree.right);
    } else {
      if (c < 0) {
        var del = cljs$core$tree_map_remove(comp, tree.left, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.left instanceof cljs.core.BlackNode) {
            return cljs.core.balance_left_del(tree.key, tree.val, del, tree.right);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, del, tree.right, null);
          }
        } else {
          return null;
        }
      } else {
        var del = cljs$core$tree_map_remove(comp, tree.right, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.right instanceof cljs.core.BlackNode) {
            return cljs.core.balance_right_del(tree.key, tree.val, tree.left, del);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, tree.left, del, null);
          }
        } else {
          return null;
        }
      }
    }
  } else {
    return null;
  }
};
cljs.core.tree_map_replace = function cljs$core$tree_map_replace(comp, tree, k, v) {
  var tk = tree.key;
  var c = function() {
    var G__17197 = k;
    var G__17198 = tk;
    return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__17197, G__17198) : comp.call(null, G__17197, G__17198);
  }();
  if (c === 0) {
    return tree.replace(tk, v, tree.left, tree.right);
  } else {
    if (c < 0) {
      return tree.replace(tk, tree.val, cljs$core$tree_map_replace(comp, tree.left, k, v), tree.right);
    } else {
      return tree.replace(tk, tree.val, tree.left, cljs$core$tree_map_replace(comp, tree.right, k, v));
    }
  }
};
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 418776847;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__17200 = cljs.core.seq(coll);
  var chunk__17201 = null;
  var count__17202 = 0;
  var i__17203 = 0;
  while (true) {
    if (i__17203 < count__17202) {
      var vec__17204 = chunk__17201.cljs$core$IIndexed$_nth$arity$2(null, i__17203);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17204, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17204, 1, null);
      var G__17205_17217 = v;
      var G__17206_17218 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17205_17217, G__17206_17218) : f.call(null, G__17205_17217, G__17206_17218);
      var G__17219 = seq__17200;
      var G__17220 = chunk__17201;
      var G__17221 = count__17202;
      var G__17222 = i__17203 + 1;
      seq__17200 = G__17219;
      chunk__17201 = G__17220;
      count__17202 = G__17221;
      i__17203 = G__17222;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__17200);
      if (temp__4425__auto__) {
        var seq__17200__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__17200__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__17200__$1);
          var G__17223 = cljs.core.chunk_rest(seq__17200__$1);
          var G__17224 = c__5094__auto__;
          var G__17225 = cljs.core.count(c__5094__auto__);
          var G__17226 = 0;
          seq__17200 = G__17223;
          chunk__17201 = G__17224;
          count__17202 = G__17225;
          i__17203 = G__17226;
          continue;
        } else {
          var vec__17207 = cljs.core.first(seq__17200__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17207, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17207, 1, null);
          var G__17208_17227 = v;
          var G__17209_17228 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17208_17227, G__17209_17228) : f.call(null, G__17208_17227, G__17209_17228);
          var G__17229 = cljs.core.next(seq__17200__$1);
          var G__17230 = null;
          var G__17231 = 0;
          var G__17232 = 0;
          seq__17200 = G__17229;
          chunk__17201 = G__17230;
          count__17202 = G__17231;
          i__17203 = G__17232;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__17210 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__17210) : cljs.core.keys.call(null, G__17210);
  }());
};
cljs.core.PersistentTreeMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__17211 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__17211) : cljs.core.vals.call(null, G__17211);
  }());
};
cljs.core.PersistentTreeMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var self__ = this;
  var coll = this;
  var t = self__.tree;
  while (true) {
    if (!(t == null)) {
      var c = function() {
        var G__17212 = k;
        var G__17213 = t.key;
        return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__17212, G__17213) : self__.comp.call(null, G__17212, G__17213);
      }();
      if (c === 0) {
        return t;
      } else {
        if (c < 0) {
          var G__17233 = t.left;
          t = G__17233;
          continue;
        } else {
          var G__17234 = t.right;
          t = G__17234;
          continue;
        }
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var n = coll__$1.entry_at(k);
  if (!(n == null)) {
    return n.val;
  } else {
    return not_found;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.tree == null)) {
    return cljs.core.tree_map_kv_reduce(self__.tree, f, init);
  } else {
    return init;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, self__.meta, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, false, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, 0);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_remove(self__.comp, self__.tree, k, found);
  if (t == null) {
    if (cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0) == null) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt - 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_add(self__.comp, self__.tree, k, v, found);
  if (t == null) {
    var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0);
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v, found_node.val)) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, cljs.core.tree_map_replace(self__.comp, self__.tree, k, v), self__.cnt, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt + 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(coll__$1.entry_at(k) == null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, true, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, meta__$1, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__17235 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__17236 = cljs.core.next(es);
          ret = G__17235;
          es = G__17236;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__17237 = null;
  var G__17237__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__17237__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__17237 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17237__2.call(this, self__, k);
      case 3:
        return G__17237__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17237.cljs$core$IFn$_invoke$arity$2 = G__17237__2;
  G__17237.cljs$core$IFn$_invoke$arity$3 = G__17237__3;
  return G__17237;
}();
cljs.core.PersistentTreeMap.prototype.apply = function(self__, args17199) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17199)));
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, ascending_QMARK_, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var stack = null;
    var t = self__.tree;
    while (true) {
      if (!(t == null)) {
        var c = function() {
          var G__17214 = k;
          var G__17215 = t.key;
          return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__17214, G__17215) : self__.comp.call(null, G__17214, G__17215);
        }();
        if (c === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t), ascending_QMARK_, -1, null);
        } else {
          if (cljs.core.truth_(ascending_QMARK_)) {
            if (c < 0) {
              var G__17238 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__17239 = t.left;
              stack = G__17238;
              t = G__17239;
              continue;
            } else {
              var G__17240 = stack;
              var G__17241 = t.right;
              stack = G__17240;
              t = G__17241;
              continue;
            }
          } else {
            if (c > 0) {
              var G__17242 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__17243 = t.right;
              stack = G__17242;
              t = G__17243;
              continue;
            } else {
              var G__17244 = stack;
              var G__17245 = t.left;
              stack = G__17244;
              t = G__17245;
              continue;
            }
          }
        }
      } else {
        if (stack == null) {
          return null;
        } else {
          return new cljs.core.PersistentTreeMapSeq(null, stack, ascending_QMARK_, -1, null);
        }
      }
      break;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  var G__17216 = entry;
  return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__17216) : cljs.core.key.call(null, G__17216);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.comp;
};
cljs.core.PersistentTreeMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "comp", "comp", -1462482139, null), new cljs.core.Symbol(null, "tree", "tree", 1444219499, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";
cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentTreeMap");
};
cljs.core.__GT_PersistentTreeMap = function cljs$core$__GT_PersistentTreeMap(comp, tree, cnt, meta, __hash) {
  return new cljs.core.PersistentTreeMap(comp, tree, cnt, meta, __hash);
};
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.hash_map = function cljs$core$hash_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (in$) {
      var G__17247 = cljs.core.nnext(in$);
      var G__17248 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__17247;
      out = G__17248;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.hash_map.cljs$lang$maxFixedArity = 0;
cljs.core.hash_map.cljs$lang$applyTo = function(seq17246) {
  return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17246));
};
cljs.core.array_map = function cljs$core$array_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var arr = keyvals instanceof cljs.core.IndexedSeq && keyvals.i === 0 ? keyvals.arr : cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals);
  return cljs.core.PersistentArrayMap.fromArray(arr, true, false);
};
cljs.core.array_map.cljs$lang$maxFixedArity = 0;
cljs.core.array_map.cljs$lang$applyTo = function(seq17249) {
  return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17249));
};
cljs.core.obj_map = function cljs$core$obj_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var ks = [];
  var obj = function() {
    var obj17252 = {};
    return obj17252;
  }();
  var kvs = cljs.core.seq(keyvals);
  while (true) {
    if (kvs) {
      ks.push(cljs.core.first(kvs));
      obj[cljs.core.first(kvs)] = cljs.core.second(kvs);
      var G__17253 = cljs.core.nnext(kvs);
      kvs = G__17253;
      continue;
    } else {
      return cljs.core.ObjMap.fromObject(ks, obj);
    }
    break;
  }
};
cljs.core.obj_map.cljs$lang$maxFixedArity = 0;
cljs.core.obj_map.cljs$lang$applyTo = function(seq17250) {
  return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17250));
};
cljs.core.sorted_map = function cljs$core$sorted_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = cljs.core.PersistentTreeMap.EMPTY;
  while (true) {
    if (in$) {
      var G__17255 = cljs.core.nnext(in$);
      var G__17256 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__17255;
      out = G__17256;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.sorted_map.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_map.cljs$lang$applyTo = function(seq17254) {
  return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17254));
};
cljs.core.sorted_map_by = function cljs$core$sorted_map_by() {
  var argseq__5349__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5349__auto__);
};
cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = function(comparator, keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator), null, 0, null, 0);
  while (true) {
    if (in$) {
      var G__17259 = cljs.core.nnext(in$);
      var G__17260 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__17259;
      out = G__17260;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.sorted_map_by.cljs$lang$maxFixedArity = 1;
cljs.core.sorted_map_by.cljs$lang$applyTo = function(seq17257) {
  var G__17258 = cljs.core.first(seq17257);
  var seq17257__$1 = cljs.core.next(seq17257);
  return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__17258, seq17257__$1);
};
cljs.core.KeySeq = function(mseq, _meta) {
  this.mseq = mseq;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.KeySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.KeySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__17261 = self__.mseq;
    if (G__17261) {
      var bit__4983__auto__ = G__17261.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__17261.cljs$core$INext$) {
        return true;
      } else {
        if (!G__17261.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__17261);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__17261);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (nseq == null) {
    return null;
  } else {
    return new cljs.core.KeySeq(nseq, self__._meta);
  }
};
cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
  return me.cljs$core$IMapEntry$_key$arity$1(null);
};
cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__17262 = self__.mseq;
    if (G__17262) {
      var bit__4983__auto__ = G__17262.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__17262.cljs$core$INext$) {
        return true;
      } else {
        if (!G__17262.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__17262);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__17262);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (!(nseq == null)) {
    return new cljs.core.KeySeq(nseq, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.KeySeq(self__.mseq, new_meta);
};
cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.KeySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "mseq", "mseq", 1602647196, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.KeySeq.cljs$lang$type = true;
cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";
cljs.core.KeySeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/KeySeq");
};
cljs.core.__GT_KeySeq = function cljs$core$__GT_KeySeq(mseq, _meta) {
  return new cljs.core.KeySeq(mseq, _meta);
};
cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.keys = function cljs$core$keys(hash_map) {
  var temp__4425__auto__ = cljs.core.seq(hash_map);
  if (temp__4425__auto__) {
    var mseq = temp__4425__auto__;
    return new cljs.core.KeySeq(mseq, null);
  } else {
    return null;
  }
};
cljs.core.key = function cljs$core$key(map_entry) {
  return cljs.core._key(map_entry);
};
cljs.core.ValSeq = function(mseq, _meta) {
  this.mseq = mseq;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ValSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ValSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__17263 = self__.mseq;
    if (G__17263) {
      var bit__4983__auto__ = G__17263.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__17263.cljs$core$INext$) {
        return true;
      } else {
        if (!G__17263.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__17263);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__17263);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (nseq == null) {
    return null;
  } else {
    return new cljs.core.ValSeq(nseq, self__._meta);
  }
};
cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
  return me.cljs$core$IMapEntry$_val$arity$1(null);
};
cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__17264 = self__.mseq;
    if (G__17264) {
      var bit__4983__auto__ = G__17264.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__17264.cljs$core$INext$) {
        return true;
      } else {
        if (!G__17264.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__17264);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__17264);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (!(nseq == null)) {
    return new cljs.core.ValSeq(nseq, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ValSeq(self__.mseq, new_meta);
};
cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ValSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "mseq", "mseq", 1602647196, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.ValSeq.cljs$lang$type = true;
cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";
cljs.core.ValSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ValSeq");
};
cljs.core.__GT_ValSeq = function cljs$core$__GT_ValSeq(mseq, _meta) {
  return new cljs.core.ValSeq(mseq, _meta);
};
cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.vals = function cljs$core$vals(hash_map) {
  var temp__4425__auto__ = cljs.core.seq(hash_map);
  if (temp__4425__auto__) {
    var mseq = temp__4425__auto__;
    return new cljs.core.ValSeq(mseq, null);
  } else {
    return null;
  }
};
cljs.core.val = function cljs$core$val(map_entry) {
  return cljs.core._val(map_entry);
};
cljs.core.merge = function cljs$core$merge() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = function(maps) {
  if (cljs.core.truth_(cljs.core.some(cljs.core.identity, maps))) {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(function(p1__17265_SHARP_, p2__17266_SHARP_) {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
        var or__4309__auto__ = p1__17265_SHARP_;
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.PersistentArrayMap.EMPTY;
        }
      }(), p2__17266_SHARP_);
    }, maps);
  } else {
    return null;
  }
};
cljs.core.merge.cljs$lang$maxFixedArity = 0;
cljs.core.merge.cljs$lang$applyTo = function(seq17267) {
  return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17267));
};
cljs.core.merge_with = function cljs$core$merge_with() {
  var argseq__5349__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5349__auto__);
};
cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = function(f, maps) {
  if (cljs.core.truth_(cljs.core.some(cljs.core.identity, maps))) {
    var merge_entry = function(m, e) {
      var k = cljs.core.first(e);
      var v = cljs.core.second(e);
      if (cljs.core.contains_QMARK_(m, k)) {
        return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
          var G__17270 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
          var G__17271 = v;
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17270, G__17271) : f.call(null, G__17270, G__17271);
        }());
      } else {
        return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
      }
    };
    var merge2 = function(merge_entry) {
      return function(m1, m2) {
        return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry, function() {
          var or__4309__auto__ = m1;
          if (cljs.core.truth_(or__4309__auto__)) {
            return or__4309__auto__;
          } else {
            return cljs.core.PersistentArrayMap.EMPTY;
          }
        }(), cljs.core.seq(m2));
      };
    }(merge_entry);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2, maps);
  } else {
    return null;
  }
};
cljs.core.merge_with.cljs$lang$maxFixedArity = 1;
cljs.core.merge_with.cljs$lang$applyTo = function(seq17268) {
  var G__17269 = cljs.core.first(seq17268);
  var seq17268__$1 = cljs.core.next(seq17268);
  return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__17269, seq17268__$1);
};
cljs.core.select_keys = function cljs$core$select_keys(map, keyseq) {
  var ret = cljs.core.PersistentArrayMap.EMPTY;
  var keys = cljs.core.seq(keyseq);
  while (true) {
    if (keys) {
      var key = cljs.core.first(keys);
      var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map, key, new cljs.core.Keyword("cljs.core", "not-found", "cljs.core/not-found", -1572889185));
      var G__17272 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry, new cljs.core.Keyword("cljs.core", "not-found", "cljs.core/not-found", -1572889185)) ? cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret, key, entry) : ret;
      var G__17273 = cljs.core.next(keys);
      ret = G__17272;
      keys = G__17273;
      continue;
    } else {
      return cljs.core.with_meta(ret, cljs.core.meta(map));
    }
    break;
  }
};
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 15077647;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashSet.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashSet.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashSet.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__17276 = cljs.core.seq(coll);
  var chunk__17277 = null;
  var count__17278 = 0;
  var i__17279 = 0;
  while (true) {
    if (i__17279 < count__17278) {
      var vec__17280 = chunk__17277.cljs$core$IIndexed$_nth$arity$2(null, i__17279);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17280, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17280, 1, null);
      var G__17281_17286 = v;
      var G__17282_17287 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17281_17286, G__17282_17287) : f.call(null, G__17281_17286, G__17282_17287);
      var G__17288 = seq__17276;
      var G__17289 = chunk__17277;
      var G__17290 = count__17278;
      var G__17291 = i__17279 + 1;
      seq__17276 = G__17288;
      chunk__17277 = G__17289;
      count__17278 = G__17290;
      i__17279 = G__17291;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__17276);
      if (temp__4425__auto__) {
        var seq__17276__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__17276__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__17276__$1);
          var G__17292 = cljs.core.chunk_rest(seq__17276__$1);
          var G__17293 = c__5094__auto__;
          var G__17294 = cljs.core.count(c__5094__auto__);
          var G__17295 = 0;
          seq__17276 = G__17292;
          chunk__17277 = G__17293;
          count__17278 = G__17294;
          i__17279 = G__17295;
          continue;
        } else {
          var vec__17283 = cljs.core.first(seq__17276__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17283, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17283, 1, null);
          var G__17284_17296 = v;
          var G__17285_17297 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17284_17296, G__17285_17297) : f.call(null, G__17284_17296, G__17285_17297);
          var G__17298 = cljs.core.next(seq__17276__$1);
          var G__17299 = null;
          var G__17300 = 0;
          var G__17301 = 0;
          seq__17276 = G__17298;
          chunk__17277 = G__17299;
          count__17278 = G__17300;
          i__17279 = G__17301;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, v, null);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._contains_key_QMARK_(self__.hash_map, v)) {
    return v;
  } else {
    return not_found;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, self__.hash_map, self__.__hash);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._count(self__.hash_map);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.set_QMARK_(other) && cljs.core.count(coll__$1) === cljs.core.count(other) && cljs.core.every_QMARK_(function(coll__$1) {
    return function(p1__17274_SHARP_) {
      return cljs.core.contains_QMARK_(coll__$1, p1__17274_SHARP_);
    };
  }(coll__$1), other);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map));
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY, self__.meta);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, cljs.core._dissoc(self__.hash_map, v), null);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.keys(self__.hash_map);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(meta__$1, self__.hash_map, self__.__hash);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map, o, null), null);
};
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__17302 = null;
  var G__17302__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__17302__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__17302 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17302__2.call(this, self__, k);
      case 3:
        return G__17302__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17302.cljs$core$IFn$_invoke$arity$2 = G__17302__2;
  G__17302.cljs$core$IFn$_invoke$arity$3 = G__17302__3;
  return G__17302;
}();
cljs.core.PersistentHashSet.prototype.apply = function(self__, args17275) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17275)));
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashSet.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "hash-map", "hash-map", -439030950, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";
cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentHashSet");
};
cljs.core.__GT_PersistentHashSet = function cljs$core$__GT_PersistentHashSet(meta, hash_map, __hash) {
  return new cljs.core.PersistentHashSet(meta, hash_map, __hash);
};
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.PersistentArrayMap.EMPTY, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashSet.fromArray = function(items, no_clone) {
  var len = items.length;
  if (len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
    var arr = no_clone ? items : cljs.core.aclone(items);
    var i = 0;
    var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
    while (true) {
      if (i < len) {
        var G__17303 = i + 1;
        var G__17304 = cljs.core._assoc_BANG_(out, items[i], null);
        i = G__17303;
        out = G__17304;
        continue;
      } else {
        return new cljs.core.PersistentHashSet(null, cljs.core._persistent_BANG_(out), null);
      }
      break;
    }
  } else {
    var i = 0;
    var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
    while (true) {
      if (i < len) {
        var G__17305 = i + 1;
        var G__17306 = cljs.core._conj_BANG_(out, items[i]);
        i = G__17305;
        out = G__17306;
        continue;
      } else {
        return cljs.core._persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition1$ = 136;
  this.cljs$lang$protocol_mask$partition0$ = 259;
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map, o, null);
  return tcoll__$1;
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_(self__.transient_map), null);
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var self__ = this;
  var tcoll__$1 = this;
  self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map, v);
  return tcoll__$1;
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core.count(self__.transient_map);
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, v, null);
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found;
  } else {
    return v;
  }
};
cljs.core.TransientHashSet.prototype.call = function() {
  var G__17308 = null;
  var G__17308__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null;
    } else {
      return k;
    }
  };
  var G__17308__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found;
    } else {
      return k;
    }
  };
  G__17308 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17308__2.call(this, self__, k);
      case 3:
        return G__17308__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17308.cljs$core$IFn$_invoke$arity$2 = G__17308__2;
  G__17308.cljs$core$IFn$_invoke$arity$3 = G__17308__3;
  return G__17308;
}();
cljs.core.TransientHashSet.prototype.apply = function(self__, args17307) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17307)));
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var tcoll = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return null;
  } else {
    return k;
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var tcoll = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found;
  } else {
    return k;
  }
};
cljs.core.TransientHashSet.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "transient-map", "transient-map", 351764893, null)], null);
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";
cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientHashSet");
};
cljs.core.__GT_TransientHashSet = function cljs$core$__GT_TransientHashSet(transient_map) {
  return new cljs.core.TransientHashSet(transient_map);
};
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 417730831;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeSet.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeSet.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentTreeSet.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__17311 = cljs.core.seq(coll);
  var chunk__17312 = null;
  var count__17313 = 0;
  var i__17314 = 0;
  while (true) {
    if (i__17314 < count__17313) {
      var vec__17315 = chunk__17312.cljs$core$IIndexed$_nth$arity$2(null, i__17314);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17315, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17315, 1, null);
      var G__17316_17321 = v;
      var G__17317_17322 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17316_17321, G__17317_17322) : f.call(null, G__17316_17321, G__17317_17322);
      var G__17323 = seq__17311;
      var G__17324 = chunk__17312;
      var G__17325 = count__17313;
      var G__17326 = i__17314 + 1;
      seq__17311 = G__17323;
      chunk__17312 = G__17324;
      count__17313 = G__17325;
      i__17314 = G__17326;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__17311);
      if (temp__4425__auto__) {
        var seq__17311__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__17311__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__17311__$1);
          var G__17327 = cljs.core.chunk_rest(seq__17311__$1);
          var G__17328 = c__5094__auto__;
          var G__17329 = cljs.core.count(c__5094__auto__);
          var G__17330 = 0;
          seq__17311 = G__17327;
          chunk__17312 = G__17328;
          count__17313 = G__17329;
          i__17314 = G__17330;
          continue;
        } else {
          var vec__17318 = cljs.core.first(seq__17311__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17318, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17318, 1, null);
          var G__17319_17331 = v;
          var G__17320_17332 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17319_17331, G__17320_17332) : f.call(null, G__17319_17331, G__17320_17332);
          var G__17333 = cljs.core.next(seq__17311__$1);
          var G__17334 = null;
          var G__17335 = 0;
          var G__17336 = 0;
          seq__17311 = G__17333;
          chunk__17312 = G__17334;
          count__17313 = G__17335;
          i__17314 = G__17336;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, v, null);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var n = self__.tree_map.entry_at(v);
  if (!(n == null)) {
    return n.key;
  } else {
    return not_found;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, self__.tree_map, self__.__hash);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.count(self__.tree_map);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.count(self__.tree_map) > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core.rseq(self__.tree_map));
  } else {
    return null;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.set_QMARK_(other) && cljs.core.count(coll__$1) === cljs.core.count(other) && cljs.core.every_QMARK_(function(coll__$1) {
    return function(p1__17309_SHARP_) {
      return cljs.core.contains_QMARK_(coll__$1, p1__17309_SHARP_);
    };
  }(coll__$1), other);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core._empty(self__.tree_map), 0);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map, v), null);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.keys(self__.tree_map);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(meta__$1, self__.tree_map, self__.__hash);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map, o, null), null);
};
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__17337 = null;
  var G__17337__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__17337__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__17337 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17337__2.call(this, self__, k);
      case 3:
        return G__17337__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17337.cljs$core$IFn$_invoke$arity$2 = G__17337__2;
  G__17337.cljs$core$IFn$_invoke$arity$3 = G__17337__3;
  return G__17337;
}();
cljs.core.PersistentTreeSet.prototype.apply = function(self__, args17310) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17310)));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core._sorted_seq(self__.tree_map, ascending_QMARK_));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core._sorted_seq_from(self__.tree_map, k, ascending_QMARK_));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  return entry;
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._comparator(self__.tree_map);
};
cljs.core.PersistentTreeSet.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "tree-map", "tree-map", 1373073049, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";
cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentTreeSet");
};
cljs.core.__GT_PersistentTreeSet = function cljs$core$__GT_PersistentTreeSet(meta, tree_map, __hash) {
  return new cljs.core.PersistentTreeSet(meta, tree_map, __hash);
};
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.PersistentTreeMap.EMPTY, cljs.core.empty_unordered_hash);
cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.set_from_indexed_seq = function cljs$core$set_from_indexed_seq(iseq) {
  var arr = iseq.arr;
  var ret = function() {
    var a__5188__auto__ = arr;
    var i = 0;
    var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
    while (true) {
      if (i < a__5188__auto__.length) {
        var G__17338 = i + 1;
        var G__17339 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, arr[i]);
        i = G__17338;
        res = G__17339;
        continue;
      } else {
        return res;
      }
      break;
    }
  }();
  return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
};
cljs.core.set = function cljs$core$set(coll) {
  var in$ = cljs.core.seq(coll);
  if (in$ == null) {
    return cljs.core.PersistentHashSet.EMPTY;
  } else {
    if (in$ instanceof cljs.core.IndexedSeq && in$.i === 0) {
      return cljs.core.set_from_indexed_seq(in$);
    } else {
      var in$__$1 = in$;
      var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
      while (true) {
        if (!(in$__$1 == null)) {
          var G__17340 = cljs.core.next(in$__$1);
          var G__17341 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, in$__$1.cljs$core$ISeq$_first$arity$1(null));
          in$__$1 = G__17340;
          out = G__17341;
          continue;
        } else {
          return cljs.core.persistent_BANG_(out);
        }
        break;
      }
    }
  }
};
cljs.core.hash_set = function cljs$core$hash_set() {
  var G__17344 = arguments.length;
  switch(G__17344) {
    case 0:
      return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0);
      return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5360__auto__);
  }
};
cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentHashSet.EMPTY;
};
cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = function(keys) {
  return cljs.core.set(keys);
};
cljs.core.hash_set.cljs$lang$applyTo = function(seq17342) {
  return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17342));
};
cljs.core.hash_set.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_set = function cljs$core$sorted_set() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = function(keys) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys);
};
cljs.core.sorted_set.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_set.cljs$lang$applyTo = function(seq17346) {
  return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17346));
};
cljs.core.sorted_set_by = function cljs$core$sorted_set_by() {
  var argseq__5349__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5349__auto__);
};
cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = function(comparator, keys) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by(comparator), 0), keys);
};
cljs.core.sorted_set_by.cljs$lang$maxFixedArity = 1;
cljs.core.sorted_set_by.cljs$lang$applyTo = function(seq17347) {
  var G__17348 = cljs.core.first(seq17347);
  var seq17347__$1 = cljs.core.next(seq17347);
  return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__17348, seq17347__$1);
};
cljs.core.replace = function cljs$core$replace() {
  var G__17352 = arguments.length;
  switch(G__17352) {
    case 1:
      return cljs.core.replace.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.replace.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = function(smap) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$1(function(p1__17349_SHARP_) {
    var temp__4423__auto__ = cljs.core.find(smap, p1__17349_SHARP_);
    if (cljs.core.truth_(temp__4423__auto__)) {
      var e = temp__4423__auto__;
      return cljs.core.val(e);
    } else {
      return p1__17349_SHARP_;
    }
  });
};
cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = function(smap, coll) {
  if (cljs.core.vector_QMARK_(coll)) {
    var n = cljs.core.count(coll);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(n) {
      return function(v, i) {
        var temp__4423__auto__ = cljs.core.find(smap, cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v, i));
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v, i, cljs.core.second(e));
        } else {
          return v;
        }
      };
    }(n), coll, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.iterate(cljs.core.inc, 0)));
  } else {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(p1__17350_SHARP_) {
      var temp__4423__auto__ = cljs.core.find(smap, p1__17350_SHARP_);
      if (cljs.core.truth_(temp__4423__auto__)) {
        var e = temp__4423__auto__;
        return cljs.core.second(e);
      } else {
        return p1__17350_SHARP_;
      }
    }, coll);
  }
};
cljs.core.replace.cljs$lang$maxFixedArity = 2;
cljs.core.distinct = function cljs$core$distinct() {
  var G__17355 = arguments.length;
  switch(G__17355) {
    case 0:
      return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = function() {
  return function(rf) {
    var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
    return function(seen) {
      return function() {
        var G__17367 = null;
        var G__17367__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17367__1 = function(result) {
          var G__17356 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17356) : rf.call(null, G__17356);
        };
        var G__17367__2 = function(result, input) {
          if (cljs.core.contains_QMARK_(function() {
            var G__17357 = seen;
            return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__17357) : cljs.core.deref.call(null, G__17357);
          }(), input)) {
            return result;
          } else {
            cljs.core._vreset_BANG_(seen, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen), input));
            var G__17358 = result;
            var G__17359 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17358, G__17359) : rf.call(null, G__17358, G__17359);
          }
        };
        G__17367 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17367__0.call(this);
            case 1:
              return G__17367__1.call(this, result);
            case 2:
              return G__17367__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17367.cljs$core$IFn$_invoke$arity$0 = G__17367__0;
        G__17367.cljs$core$IFn$_invoke$arity$1 = G__17367__1;
        G__17367.cljs$core$IFn$_invoke$arity$2 = G__17367__2;
        return G__17367;
      }();
    }(seen);
  };
};
cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var step = function cljs$core$step(xs, seen) {
    return new cljs.core.LazySeq(null, function() {
      return function(p__17364, seen__$1) {
        while (true) {
          var vec__17365 = p__17364;
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17365, 0, null);
          var xs__$1 = vec__17365;
          var temp__4425__auto__ = cljs.core.seq(xs__$1);
          if (temp__4425__auto__) {
            var s = temp__4425__auto__;
            if (cljs.core.contains_QMARK_(seen__$1, f)) {
              var G__17368 = cljs.core.rest(s);
              var G__17369 = seen__$1;
              p__17364 = G__17368;
              seen__$1 = G__17369;
              continue;
            } else {
              return cljs.core.cons(f, cljs$core$step(cljs.core.rest(s), cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1, f)));
            }
          } else {
            return null;
          }
          break;
        }
      }.call(null, xs, seen);
    }, null, null);
  };
  return step(coll, cljs.core.PersistentHashSet.EMPTY);
};
cljs.core.distinct.cljs$lang$maxFixedArity = 1;
cljs.core.butlast = function cljs$core$butlast(s) {
  var ret = cljs.core.PersistentVector.EMPTY;
  var s__$1 = s;
  while (true) {
    if (cljs.core.next(s__$1)) {
      var G__17370 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret, cljs.core.first(s__$1));
      var G__17371 = cljs.core.next(s__$1);
      ret = G__17370;
      s__$1 = G__17371;
      continue;
    } else {
      return cljs.core.seq(ret);
    }
    break;
  }
};
cljs.core.name = function cljs$core$name(x) {
  if (function() {
    var G__17373 = x;
    if (G__17373) {
      var bit__4976__auto__ = G__17373.cljs$lang$protocol_mask$partition1$ & 4096;
      if (bit__4976__auto__ || G__17373.cljs$core$INamed$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return x.cljs$core$INamed$_name$arity$1(null);
  } else {
    if (typeof x === "string") {
      return x;
    } else {
      throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
    }
  }
};
cljs.core.zipmap = function cljs$core$zipmap(keys, vals) {
  var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
  var ks = cljs.core.seq(keys);
  var vs = cljs.core.seq(vals);
  while (true) {
    if (ks && vs) {
      var G__17374 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map, cljs.core.first(ks), cljs.core.first(vs));
      var G__17375 = cljs.core.next(ks);
      var G__17376 = cljs.core.next(vs);
      map = G__17374;
      ks = G__17375;
      vs = G__17376;
      continue;
    } else {
      return cljs.core.persistent_BANG_(map);
    }
    break;
  }
};
cljs.core.max_key = function cljs$core$max_key() {
  var G__17384 = arguments.length;
  switch(G__17384) {
    case 2:
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = function(k, x) {
  return x;
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = function(k, x, y) {
  if (function() {
    var G__17385 = x;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__17385) : k.call(null, G__17385);
  }() > function() {
    var G__17386 = y;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__17386) : k.call(null, G__17386);
  }()) {
    return x;
  } else {
    return y;
  }
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = function(k, x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(p1__17377_SHARP_, p2__17378_SHARP_) {
    return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k, p1__17377_SHARP_, p2__17378_SHARP_);
  }, cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k, x, y), more);
};
cljs.core.max_key.cljs$lang$applyTo = function(seq17379) {
  var G__17380 = cljs.core.first(seq17379);
  var seq17379__$1 = cljs.core.next(seq17379);
  var G__17381 = cljs.core.first(seq17379__$1);
  var seq17379__$2 = cljs.core.next(seq17379__$1);
  var G__17382 = cljs.core.first(seq17379__$2);
  var seq17379__$3 = cljs.core.next(seq17379__$2);
  return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__17380, G__17381, G__17382, seq17379__$3);
};
cljs.core.max_key.cljs$lang$maxFixedArity = 3;
cljs.core.min_key = function cljs$core$min_key() {
  var G__17395 = arguments.length;
  switch(G__17395) {
    case 2:
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = function(k, x) {
  return x;
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = function(k, x, y) {
  if (function() {
    var G__17396 = x;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__17396) : k.call(null, G__17396);
  }() < function() {
    var G__17397 = y;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__17397) : k.call(null, G__17397);
  }()) {
    return x;
  } else {
    return y;
  }
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = function(k, x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(p1__17388_SHARP_, p2__17389_SHARP_) {
    return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k, p1__17388_SHARP_, p2__17389_SHARP_);
  }, cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k, x, y), more);
};
cljs.core.min_key.cljs$lang$applyTo = function(seq17390) {
  var G__17391 = cljs.core.first(seq17390);
  var seq17390__$1 = cljs.core.next(seq17390);
  var G__17392 = cljs.core.first(seq17390__$1);
  var seq17390__$2 = cljs.core.next(seq17390__$1);
  var G__17393 = cljs.core.first(seq17390__$2);
  var seq17390__$3 = cljs.core.next(seq17390__$2);
  return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__17391, G__17392, G__17393, seq17390__$3);
};
cljs.core.min_key.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayList = function(arr) {
  this.arr = arr;
};
cljs.core.ArrayList.prototype.add = function(x) {
  var self__ = this;
  var _ = this;
  return self__.arr.push(x);
};
cljs.core.ArrayList.prototype.size = function() {
  var self__ = this;
  var _ = this;
  return self__.arr.length;
};
cljs.core.ArrayList.prototype.clear = function() {
  var self__ = this;
  var _ = this;
  return self__.arr = [];
};
cljs.core.ArrayList.prototype.isEmpty = function() {
  var self__ = this;
  var _ = this;
  return self__.arr.length === 0;
};
cljs.core.ArrayList.prototype.toArray = function() {
  var self__ = this;
  var _ = this;
  return self__.arr;
};
cljs.core.ArrayList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.ArrayList.cljs$lang$type = true;
cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";
cljs.core.ArrayList.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayList");
};
cljs.core.__GT_ArrayList = function cljs$core$__GT_ArrayList(arr) {
  return new cljs.core.ArrayList(arr);
};
cljs.core.array_list = function cljs$core$array_list() {
  return new cljs.core.ArrayList([]);
};
cljs.core.partition_all = function cljs$core$partition_all() {
  var G__17400 = arguments.length;
  switch(G__17400) {
    case 1:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var a = cljs.core.array_list();
    return function(a) {
      return function() {
        var G__17407 = null;
        var G__17407__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17407__1 = function(result) {
          var result__$1 = cljs.core.truth_(a.isEmpty()) ? result : function() {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            return cljs.core.unreduced(function() {
              var G__17401 = result;
              var G__17402 = v;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17401, G__17402) : rf.call(null, G__17401, G__17402);
            }());
          }();
          var G__17403 = result__$1;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17403) : rf.call(null, G__17403);
        };
        var G__17407__2 = function(result, input) {
          a.add(input);
          if (n === a.size()) {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            var G__17404 = result;
            var G__17405 = v;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17404, G__17405) : rf.call(null, G__17404, G__17405);
          } else {
            return result;
          }
        };
        G__17407 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17407__0.call(this);
            case 1:
              return G__17407__1.call(this, result);
            case 2:
              return G__17407__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17407.cljs$core$IFn$_invoke$arity$0 = G__17407__0;
        G__17407.cljs$core$IFn$_invoke$arity$1 = G__17407__1;
        G__17407.cljs$core$IFn$_invoke$arity$2 = G__17407__2;
        return G__17407;
      }();
    }(a);
  };
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s), cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition_all.cljs$lang$maxFixedArity = 3;
cljs.core.take_while = function cljs$core$take_while() {
  var G__17409 = arguments.length;
  switch(G__17409) {
    case 1:
      return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__17416 = null;
      var G__17416__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__17416__1 = function(result) {
        var G__17410 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17410) : rf.call(null, G__17410);
      };
      var G__17416__2 = function(result, input) {
        if (cljs.core.truth_(function() {
          var G__17411 = input;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17411) : pred.call(null, G__17411);
        }())) {
          var G__17412 = result;
          var G__17413 = input;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17412, G__17413) : rf.call(null, G__17412, G__17413);
        } else {
          return cljs.core.reduced(result);
        }
      };
      G__17416 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__17416__0.call(this);
          case 1:
            return G__17416__1.call(this, result);
          case 2:
            return G__17416__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__17416.cljs$core$IFn$_invoke$arity$0 = G__17416__0;
      G__17416.cljs$core$IFn$_invoke$arity$1 = G__17416__1;
      G__17416.cljs$core$IFn$_invoke$arity$2 = G__17416__2;
      return G__17416;
    }();
  };
};
cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.truth_(function() {
        var G__17414 = cljs.core.first(s);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17414) : pred.call(null, G__17414);
      }())) {
        return cljs.core.cons(cljs.core.first(s), cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take_while.cljs$lang$maxFixedArity = 2;
cljs.core.mk_bound_fn = function cljs$core$mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp = cljs.core._comparator(sc);
    var G__17421 = function() {
      var G__17423 = cljs.core._entry_key(sc, e);
      var G__17424 = key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__17423, G__17424) : comp.call(null, G__17423, G__17424);
    }();
    var G__17422 = 0;
    return test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__17421, G__17422) : test.call(null, G__17421, G__17422);
  };
};
cljs.core.subseq = function cljs$core$subseq() {
  var G__17426 = arguments.length;
  switch(G__17426) {
    case 3:
      return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = function(sc, test, key) {
  var include = cljs.core.mk_bound_fn(sc, test, key);
  if (cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_, cljs.core._GT__EQ_], true).call(null, test))) {
    var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, key, true);
    if (cljs.core.truth_(temp__4425__auto__)) {
      var vec__17427 = temp__4425__auto__;
      var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17427, 0, null);
      var s = vec__17427;
      if (cljs.core.truth_(function() {
        var G__17428 = e;
        return include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__17428) : include.call(null, G__17428);
      }())) {
        return s;
      } else {
        return cljs.core.next(s);
      }
    } else {
      return null;
    }
  } else {
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include, cljs.core._sorted_seq(sc, true));
  }
};
cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = function(sc, start_test, start_key, end_test, end_key) {
  var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, start_key, true);
  if (cljs.core.truth_(temp__4425__auto__)) {
    var vec__17429 = temp__4425__auto__;
    var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17429, 0, null);
    var s = vec__17429;
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn(sc, start_test, start_key).call(null, e)) ? s : cljs.core.next(s));
  } else {
    return null;
  }
};
cljs.core.subseq.cljs$lang$maxFixedArity = 5;
cljs.core.rsubseq = function cljs$core$rsubseq() {
  var G__17432 = arguments.length;
  switch(G__17432) {
    case 3:
      return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = function(sc, test, key) {
  var include = cljs.core.mk_bound_fn(sc, test, key);
  if (cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_, cljs.core._LT__EQ_], true).call(null, test))) {
    var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, key, false);
    if (cljs.core.truth_(temp__4425__auto__)) {
      var vec__17433 = temp__4425__auto__;
      var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17433, 0, null);
      var s = vec__17433;
      if (cljs.core.truth_(function() {
        var G__17434 = e;
        return include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__17434) : include.call(null, G__17434);
      }())) {
        return s;
      } else {
        return cljs.core.next(s);
      }
    } else {
      return null;
    }
  } else {
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include, cljs.core._sorted_seq(sc, false));
  }
};
cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = function(sc, start_test, start_key, end_test, end_key) {
  var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, end_key, false);
  if (cljs.core.truth_(temp__4425__auto__)) {
    var vec__17435 = temp__4425__auto__;
    var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17435, 0, null);
    var s = vec__17435;
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn(sc, end_test, end_key).call(null, e)) ? s : cljs.core.next(s));
  } else {
    return null;
  }
};
cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;
cljs.core.RangeIterator = function(i, end, step) {
  this.i = i;
  this.end = end;
  this.step = step;
};
cljs.core.RangeIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__.step > 0) {
    return self__.i < self__.end;
  } else {
    return self__.i > self__.end;
  }
};
cljs.core.RangeIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.i;
  self__.i = self__.i + self__.step;
  return ret;
};
cljs.core.RangeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.Symbol(null, "step", "step", -1365547645, null)], null);
};
cljs.core.RangeIterator.cljs$lang$type = true;
cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";
cljs.core.RangeIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RangeIterator");
};
cljs.core.__GT_RangeIterator = function cljs$core$__GT_RangeIterator(i, end, step) {
  return new cljs.core.RangeIterator(i, end, step);
};
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375006;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Range.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Range.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var self__ = this;
  var rng__$1 = this;
  if (n < cljs.core._count(rng__$1)) {
    return self__.start + n * self__.step;
  } else {
    if (self__.start > self__.end && self__.step === 0) {
      return self__.start;
    } else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var self__ = this;
  var rng__$1 = this;
  if (n < cljs.core._count(rng__$1)) {
    return self__.start + n * self__.step;
  } else {
    if (self__.start > self__.end && self__.step === 0) {
      return self__.start;
    } else {
      return not_found;
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIterable$ = true;
cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RangeIterator(self__.start, self__.end, self__.step);
};
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  return self__.meta;
};
cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Range(self__.meta, self__.start, self__.end, self__.step, self__.__hash);
};
cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (self__.step > 0) {
    if (self__.start + self__.step < self__.end) {
      return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
    } else {
      return null;
    }
  } else {
    if (self__.start + self__.step > self__.end) {
      return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
    } else {
      return null;
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (cljs.core.not(cljs.core._seq(rng__$1))) {
    return 0;
  } else {
    var G__17437 = (self__.end - self__.start) / self__.step;
    return Math.ceil(G__17437);
  }
};
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.equiv_sequential(rng__$1, other);
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1, f);
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, init) {
  var self__ = this;
  var rng__$1 = this;
  var i = self__.start;
  var r