if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}


var CLOSURE_NO_DEPS = true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0]);
  }
  for (var part;parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else {
      if (cur[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else {
      if (goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
        value = goog.global.CLOSURE_DEFINES[name];
      }
    }
  }
  goog.exportPath_(name, value);
};
goog.define("goog.DEBUG", true);
goog.define("goog.LOCALE", "en");
goog.define("goog.TRUSTED_SITE", true);
goog.define("goog.STRICT_MODE_COMPATIBLE", false);
goog.define("goog.DISALLOW_TEST_ONLY_CODE", COMPILED && !goog.DEBUG);
goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING", false);
goog.provide = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
  }
  goog.constructNamespace_(name);
};
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name, opt_obj);
};
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module = function(name) {
  if (!goog.isString(name) || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
    throw Error("Invalid module identifier");
  }
  if (!goog.isInModuleLoader_()) {
    throw Error("Module " + name + " has been loaded incorrectly.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      return name in goog.loadedModules_ ? goog.loadedModules_[name] : goog.getObjectByName(name);
    } else {
      return null;
    }
  }
};
goog.moduleLoaderState_ = null;
goog.isInModuleLoader_ = function() {
  return goog.moduleLoaderState_ != null;
};
goog.module.declareTestMethods = function() {
  if (!goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareTestMethods must be called from " + "within a goog.module");
  }
  goog.moduleLoaderState_.declareTestMethods = true;
};
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareLegacyNamespace must be called from " + "within a goog.module");
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module must be called prior to " + "goog.module.declareLegacyNamespace.");
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {"goog.module":true};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var part;part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires, opt_isModule) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for (var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      deps.pathIsModule[path] = !!opt_isModule;
    }
    for (var j = 0;require = requires[j];j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define("goog.ENABLE_DEBUG_LOADER", true);
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console["error"](msg);
  }
};
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
      goog.maybeProcessDeferredDep_(name);
    }
    if (goog.isProvided_(name)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(name);
      } else {
        return null;
      }
    }
    if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return null;
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    goog.logToConsole_(errorMessage);
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.define("goog.LOAD_MODULE_USING_EVAL", true);
goog.define("goog.SEAL_MODULE_EXPORTS", goog.DEBUG);
goog.loadedModules_ = {};
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
if (goog.DEPENDENCIES_ENABLED) {
  goog.included_ = {};
  goog.dependencies_ = {pathIsModule:{}, nameToPath:{}, requires:{}, visited:{}, written:{}, deferred:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc;
  };
  goog.findBasePath_ = function() {
    if (goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("SCRIPT");
    for (var i = scripts.length - 1;i >= 0;--i) {
      var script = (scripts[i]);
      var src = script.src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src, opt_sourceText) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (importScript(src, opt_sourceText)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.IS_OLD_IE_ = !goog.global.atob && goog.global.document && goog.global.document.all;
  goog.importModule_ = function(src) {
    var bootstrap = 'goog.retrieveAndExecModule_("' + src + '");';
    if (goog.importScript_("", bootstrap)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.queuedModules_ = [];
  goog.wrapModule_ = function(srcUrl, scriptText) {
    if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
      return "" + "goog.loadModule(function(exports) {" + '"use strict";' + scriptText + "\n" + ";return exports" + "});" + "\n//# sourceURL\x3d" + srcUrl + "\n";
    } else {
      return "" + "goog.loadModule(" + goog.global.JSON.stringify(scriptText + "\n//# sourceURL\x3d" + srcUrl + "\n") + ");";
    }
  };
  goog.loadQueuedModules_ = function() {
    var count = goog.queuedModules_.length;
    if (count > 0) {
      var queue = goog.queuedModules_;
      goog.queuedModules_ = [];
      for (var i = 0;i < count;i++) {
        var path = queue[i];
        goog.maybeProcessDeferredPath_(path);
      }
    }
  };
  goog.maybeProcessDeferredDep_ = function(name) {
    if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
      var path = goog.getPathFromDeps_(name);
      goog.maybeProcessDeferredPath_(goog.basePath + path);
    }
  };
  goog.isDeferredModule_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && goog.dependencies_.pathIsModule[path]) {
      var abspath = goog.basePath + path;
      return abspath in goog.dependencies_.deferred;
    }
    return false;
  };
  goog.allDepsAreAvailable_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && path in goog.dependencies_.requires) {
      for (var requireName in goog.dependencies_.requires[path]) {
        if (!goog.isProvided_(requireName) && !goog.isDeferredModule_(requireName)) {
          return false;
        }
      }
    }
    return true;
  };
  goog.maybeProcessDeferredPath_ = function(abspath) {
    if (abspath in goog.dependencies_.deferred) {
      var src = goog.dependencies_.deferred[abspath];
      delete goog.dependencies_.deferred[abspath];
      goog.globalEval(src);
    }
  };
  goog.loadModule = function(moduleDef) {
    var previousState = goog.moduleLoaderState_;
    try {
      goog.moduleLoaderState_ = {moduleName:undefined, declareTestMethods:false};
      var exports;
      if (goog.isFunction(moduleDef)) {
        exports = moduleDef.call(goog.global, {});
      } else {
        if (goog.isString(moduleDef)) {
          exports = goog.loadModuleFromSource_.call(goog.global, moduleDef);
        } else {
          throw Error("Invalid module definition");
        }
      }
      var moduleName = goog.moduleLoaderState_.moduleName;
      if (!goog.isString(moduleName) || !moduleName) {
        throw Error('Invalid module name "' + moduleName + '"');
      }
      if (goog.moduleLoaderState_.declareLegacyNamespace) {
        goog.constructNamespace_(moduleName, exports);
      } else {
        if (goog.SEAL_MODULE_EXPORTS && Object.seal) {
          Object.seal(exports);
        }
      }
      goog.loadedModules_[moduleName] = exports;
      if (goog.moduleLoaderState_.declareTestMethods) {
        for (var entry in exports) {
          if (entry.indexOf("test", 0) === 0 || entry == "tearDown" || entry == "setUp" || entry == "setUpPage" || entry == "tearDownPage") {
            goog.global[entry] = exports[entry];
          }
        }
      }
    } finally {
      goog.moduleLoaderState_ = previousState;
    }
  };
  goog.loadModuleFromSource_ = function(source) {
    var exports = {};
    eval(arguments[0]);
    return exports;
  };
  goog.writeScriptSrcNode_ = function(src) {
    goog.global.document.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"\x3e\x3c/' + "script\x3e");
  };
  goog.appendScriptSrcNode_ = function(src) {
    var doc = goog.global.document;
    var scriptEl = doc.createElement("script");
    scriptEl.type = "text/javascript";
    scriptEl.src = src;
    scriptEl.defer = false;
    scriptEl.async = false;
    doc.head.appendChild(scriptEl);
  };
  goog.writeScriptTag_ = function(src, opt_sourceText) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && doc.readyState == "complete") {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      var isOldIE = goog.IS_OLD_IE_;
      if (opt_sourceText === undefined) {
        if (!isOldIE) {
          if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
            goog.appendScriptSrcNode_(src);
          } else {
            goog.writeScriptSrcNode_(src);
          }
        } else {
          var state = " onreadystatechange\x3d'goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ";
          doc.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"' + state + "\x3e\x3c/" + "script\x3e");
        }
      } else {
        doc.write('\x3cscript type\x3d"text/javascript"\x3e' + opt_sourceText + "\x3c/" + "script\x3e");
      }
      return true;
    } else {
      return false;
    }
  };
  goog.lastNonModuleScriptIndex_ = 0;
  goog.onScriptLoad_ = function(script, scriptIndex) {
    if (script.readyState == "complete" && goog.lastNonModuleScriptIndex_ == scriptIndex) {
      goog.loadQueuedModules_();
    }
    return true;
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        if (!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path);
        }
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    for (var path in goog.included_) {
      if (!deps.written[path]) {
        visitNode(path);
      }
    }
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      goog.dependencies_.written[path] = true;
    }
    var moduleState = goog.moduleLoaderState_;
    goog.moduleLoaderState_ = null;
    var loadingModule = false;
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      if (path) {
        if (!deps.pathIsModule[path]) {
          goog.importScript_(goog.basePath + path);
        } else {
          loadingModule = true;
          goog.importModule_(goog.basePath + path);
        }
      } else {
        goog.moduleLoaderState_ = moduleState;
        throw Error("Undefined script input");
      }
    }
    goog.moduleLoaderState_ = moduleState;
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js");
  }
}
goog.normalizePath_ = function(path) {
  var components = path.split("/");
  var i = 0;
  while (i < components.length) {
    if (components[i] == ".") {
      components.splice(i, 1);
    } else {
      if (i && components[i] == ".." && components[i - 1] && components[i - 1] != "..") {
        components.splice(--i, 2);
      } else {
        i++;
      }
    }
  }
  return components.join("/");
};
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    var xhr = new goog.global["XMLHttpRequest"];
    xhr.open("get", src, false);
    xhr.send();
    return xhr.responseText;
  }
};
goog.retrieveAndExecModule_ = function(src) {
  if (!COMPILED) {
    var originalPath = src;
    src = goog.normalizePath_(src);
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    var scriptText = goog.loadFileSync_(src);
    if (scriptText != null) {
      var execModuleScript = goog.wrapModule_(src, scriptText);
      var isOldIE = goog.IS_OLD_IE_;
      if (isOldIE) {
        goog.dependencies_.deferred[originalPath] = execModuleScript;
        goog.queuedModules_.push(originalPath);
      } else {
        importScript(src, execModuleScript);
      }
    } else {
      throw new Error("load of " + src + "failed");
    }
  }
};
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call((value));
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
goog.isString = function(val) {
  return typeof val == "string";
};
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
goog.isNumber = function(val) {
  return typeof val == "number";
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if ("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1E9 >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return (fn.call.apply(fn.bind, arguments));
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ \x3d 1;");
        if (typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("SCRIPT");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt);
      }
    } else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  if (opt_modifier) {
    return className + "-" + rename(opt_modifier);
  } else {
    return rename(className);
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = new Array(arguments.length - 2);
    for (var i = 2;i < arguments.length;i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (caller.superClass_) {
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1;i < arguments.length;i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    return caller.superClass_.constructor.apply(me, ctorArgs);
  }
  var args = new Array(arguments.length - 2);
  for (var i = 2;i < arguments.length;i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (goog.defineClass.SEAL_CLASS_INSTANCES && Object.seal instanceof Function) {
    if (superClass && superClass.prototype && superClass.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]) {
      return ctr;
    }
    var wrappedCtr = function() {
      var instance = ctr.apply(this, arguments) || this;
      instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
      if (this.constructor === wrappedCtr) {
        Object.seal(instance);
      }
      return instance;
    };
    return wrappedCtr;
  }
  return ctr;
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0;i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.define("goog.string.DETECT_DOUBLE_ESCAPING", false);
goog.define("goog.string.FORCE_NON_DOM_HTML_UNESCAPING", false);
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split("%s");
  var returnString = "";
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length && splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.isEmptyString = function(str) {
  return str.length == 0;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == " ";
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd";
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(str) {
  return str.trim();
} : function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return -1;
  } else {
    if (test1 == test2) {
      return 0;
    } else {
      return 1;
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "\x3cbr /\x3e" : "\x3cbr\x3e");
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, "\x26amp;").replace(goog.string.LT_RE_, "\x26lt;").replace(goog.string.GT_RE_, "\x26gt;").replace(goog.string.QUOT_RE_, "\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;").replace(goog.string.NULL_RE_, "\x26#0;");
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) {
      return str;
    }
    if (str.indexOf("\x26") != -1) {
      str = str.replace(goog.string.AMP_RE_, "\x26amp;");
    }
    if (str.indexOf("\x3c") != -1) {
      str = str.replace(goog.string.LT_RE_, "\x26lt;");
    }
    if (str.indexOf("\x3e") != -1) {
      str = str.replace(goog.string.GT_RE_, "\x26gt;");
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, "\x26quot;");
    }
    if (str.indexOf("'") != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;");
    }
    if (str.indexOf("\x00") != -1) {
      str = str.replace(goog.string.NULL_RE_, "\x26#0;");
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf("e") != -1) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, "\x26")) {
    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, "\x26")) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"\x26amp;":"\x26", "\x26lt;":"\x3c", "\x26gt;":"\x3e", "\x26quot;":'"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement("div");
  } else {
    div = goog.global.document.createElement("div");
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "\x26";
      case "lt":
        return "\x3c";
      case "gt":
        return "\x3e";
      case "quot":
        return '"';
      default:
        if (entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " \x26#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + "...";
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos);
    }
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if (s.quote) {
    return s.quote();
  } else {
    var sb = ['"'];
    for (var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch));
    }
    sb.push('"');
    return sb.join("");
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = "\\x";
      if (cc < 16 || cc > 256) {
        rv += "0";
      }
    } else {
      rv = "\\u";
      if (cc < 4096) {
        rv += "0";
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = function(string, length) {
  return (new Array(length + 1)).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return -1;
  } else {
    if (left > right) {
      return 1;
    }
  }
  return 0;
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmptyOrWhitespace(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  delimiters = delimiters ? "|[" + delimiters + "]+" : "";
  var regexp = new RegExp("(^" + delimiters + ")([a-z])", "g");
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return /^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.string.editDistance = function(a, b) {
  var v0 = [];
  var v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0;i < b.length + 1;i++) {
    v0[i] = i;
  }
  for (var i = 0;i < a.length;i++) {
    v1[0] = i + 1;
    for (var j = 0;j < b.length;j++) {
      var cost = a[i] != b[j];
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
    }
    for (var j = 0;j < v0.length;j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call(opt_obj, obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call(opt_obj, obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call(opt_this, obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if (rv = key in obj) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value;
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  obj[key] = val;
  return val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (var k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for (var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};
goog.provide("goog.string.StringBuffer");
goog.string.StringBuffer = function(opt_a1, var_args) {
  if (opt_a1 != null) {
    this.append.apply(this, arguments);
  }
};
goog.string.StringBuffer.prototype.buffer_ = "";
goog.string.StringBuffer.prototype.set = function(s) {
  this.buffer_ = "" + s;
};
goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
  this.buffer_ += a1;
  if (opt_a2 != null) {
    for (var i = 1;i < arguments.length;i++) {
      this.buffer_ += arguments[i];
    }
  }
  return this;
};
goog.string.StringBuffer.prototype.clear = function() {
  this.buffer_ = "";
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.buffer_.length;
};
goog.string.StringBuffer.prototype.toString = function() {
  return this.buffer_;
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = (new Error).stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
  this.reportErrorToServer = true;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.dom.NodeType");
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.dom.NodeType");
goog.require("goog.string");
goog.define("goog.asserts.ENABLE_ASSERTS", goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    if (defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs;
    }
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.asserts.getType_ = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || "unknown type name";
  } else {
    if (value instanceof Object) {
      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
    } else {
      return value === null ? "null" : typeof value;
    }
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.define("goog.NATIVE_ARRAY_PROTOTYPES", goog.TRUSTED_SITE);
goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS", false);
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i < arr.length;i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if (fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex);
  }
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i >= 0;i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;--i) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      var val = arr2[i];
      if (f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val;
      }
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr);
    }
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduce.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduceRight.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true;
    }
  }
  return false;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false;
    }
  }
  return true;
};
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call(opt_obj, element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;i--) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1;i >= 0;i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if (rv = i >= 0) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    if (f.call(opt_obj, val, index, arr)) {
      if (goog.array.removeAt(arr, index)) {
        removedCount++;
      }
    }
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.join = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0;i < length;i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0;
      var len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0;j < len2;j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start);
  } else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while (left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = compareFn(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for (var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  }
  goog.array.sort(arr, stableCompareFn);
  for (var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr, function(obj) {
    return obj[key];
  }, opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0;i < l;i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter.call(opt_obj, value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call(opt_obj, element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return [];
  }
  if (step > 0) {
    for (var i = start;i < end;i += step) {
      array.push(i);
    }
  } else {
    for (var i = start;i > end;i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0;i < n;i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var CHUNK_SIZE = 8192;
  var result = [];
  for (var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      for (var c = 0;c < element.length;c += CHUNK_SIZE) {
        var chunk = goog.array.slice(element, c, c + CHUNK_SIZE);
        var recurseResult = goog.array.flatten.apply(null, chunk);
        for (var r = 0;r < recurseResult.length;r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n));
    } else {
      if (n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n));
      }
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = goog.array.ARRAY_PROTOTYPE_.splice.call(arr, fromIndex, 1);
  goog.array.ARRAY_PROTOTYPE_.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  var result = [];
  for (var i = 0;true;i++) {
    var value = [];
    for (var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if (i >= arr.length) {
        return result;
      }
      value.push(arr[i]);
    }
    result.push(value);
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.object");
goog.require("goog.array");
goog.require("goog.string.StringBuffer");
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3308";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_target_STAR_ = "default";
if (typeof cljs.core._STAR_print_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_fn_STAR_ = function cljs$core$_STAR_print_fn_STAR_(_) {
    throw new Error("No *print-fn* fn set for evaluation environment");
  };
}
cljs.core.set_print_fn_BANG_ = function cljs$core$set_print_fn_BANG_(f) {
  return cljs.core._STAR_print_fn_STAR_ = f;
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if (typeof cljs.core._STAR_loaded_libs_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = function cljs$core$pr_opts() {
  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, "flush-on-newline", "flush-on-newline", -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, "readably", "readably", 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, "meta", "meta", 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, "dup", "dup", 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, "print-length", "print-length", 
  1931866356), cljs.core._STAR_print_length_STAR_], null);
};
cljs.core.enable_console_print_BANG_ = function cljs$core$enable_console_print_BANG_() {
  cljs.core._STAR_print_newline_STAR_ = false;
  return cljs.core._STAR_print_fn_STAR_ = function() {
    var G__6759__delegate = function(args) {
      return console.log.apply(console, function() {
        var G__6758 = args;
        return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__6758) : cljs.core.into_array.call(null, G__6758);
      }());
    };
    var G__6759 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__6760__i = 0, G__6760__a = new Array(arguments.length - 0);
        while (G__6760__i < G__6760__a.length) {
          G__6760__a[G__6760__i] = arguments[G__6760__i + 0];
          ++G__6760__i;
        }
        args = new cljs.core.IndexedSeq(G__6760__a, 0);
      }
      return G__6759__delegate.call(this, args);
    };
    G__6759.cljs$lang$maxFixedArity = 0;
    G__6759.cljs$lang$applyTo = function(arglist__6761) {
      var args = cljs.core.seq(arglist__6761);
      return G__6759__delegate(args);
    };
    G__6759.cljs$core$IFn$_invoke$arity$variadic = G__6759__delegate;
    return G__6759;
  }();
};
cljs.core.truth_ = function cljs$core$truth_(x) {
  return x != null && x !== false;
};
cljs.core.not_native = null;
cljs.core.identical_QMARK_ = function cljs$core$identical_QMARK_(x, y) {
  return x === y;
};
cljs.core.nil_QMARK_ = function cljs$core$nil_QMARK_(x) {
  return x == null;
};
cljs.core.array_QMARK_ = function cljs$core$array_QMARK_(x) {
  if (cljs.core._STAR_target_STAR_ === "nodejs") {
    return Array.isArray(x);
  } else {
    return x instanceof Array;
  }
};
cljs.core.number_QMARK_ = function cljs$core$number_QMARK_(n) {
  return typeof n === "number";
};
cljs.core.not = function cljs$core$not(x) {
  if (cljs.core.truth_(x)) {
    return false;
  } else {
    return true;
  }
};
cljs.core.some_QMARK_ = function cljs$core$some_QMARK_(x) {
  return !(x == null);
};
cljs.core.object_QMARK_ = function cljs$core$object_QMARK_(x) {
  if (!(x == null)) {
    return x.constructor === Object;
  } else {
    return false;
  }
};
cljs.core.string_QMARK_ = function cljs$core$string_QMARK_(x) {
  var G__6763 = x;
  return goog.isString(G__6763);
};
cljs.core.native_satisfies_QMARK_ = function cljs$core$native_satisfies_QMARK_(p, x) {
  var x__$1 = x == null ? null : x;
  if (p[function() {
    var G__6765 = x__$1;
    return goog.typeOf(G__6765);
  }()]) {
    return true;
  } else {
    if (p["_"]) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.is_proto_ = function cljs$core$is_proto_(x) {
  return x.constructor.prototype === x;
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = function cljs$core$type(x) {
  if (x == null) {
    return null;
  } else {
    return x.constructor;
  }
};
cljs.core.missing_protocol = function cljs$core$missing_protocol(proto, obj) {
  var ty = cljs.core.type(obj);
  var ty__$1 = cljs.core.truth_(function() {
    var and__4297__auto__ = ty;
    if (cljs.core.truth_(and__4297__auto__)) {
      return ty.cljs$lang$type;
    } else {
      return and__4297__auto__;
    }
  }()) ? ty.cljs$lang$ctorStr : function() {
    var G__6767 = obj;
    return goog.typeOf(G__6767);
  }();
  return new Error(["No protocol method ", proto, " defined for type ", ty__$1, ": ", obj].join(""));
};
cljs.core.type__GT_str = function cljs$core$type__GT_str(ty) {
  var temp__4423__auto__ = ty.cljs$lang$ctorStr;
  if (cljs.core.truth_(temp__4423__auto__)) {
    var s = temp__4423__auto__;
    return s;
  } else {
    return [cljs.core.str(ty)].join("");
  }
};
cljs.core.load_file = function cljs$core$load_file(file) {
  if (cljs.core.truth_(COMPILED)) {
    return null;
  } else {
    return goog.nodeGlobalRequire(file);
  }
};
if (typeof Symbol !== "undefined" && function() {
  var G__6769 = Symbol;
  return goog.typeOf(G__6769);
}() === "function") {
  cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
  cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.make_array = function cljs$core$make_array() {
  var G__6771 = arguments.length;
  switch(G__6771) {
    case 1:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = function(size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = function(type, size) {
  return new Array(size);
};
cljs.core.make_array.cljs$lang$maxFixedArity = 2;
cljs.core.aclone = function cljs$core$aclone(arr) {
  var len = arr.length;
  var new_arr = new Array(len);
  var n__5194__auto___6773 = len;
  var i_6774 = 0;
  while (true) {
    if (i_6774 < n__5194__auto___6773) {
      new_arr[i_6774] = arr[i_6774];
      var G__6775 = i_6774 + 1;
      i_6774 = G__6775;
      continue;
    } else {
    }
    break;
  }
  return new_arr;
};
cljs.core.array = function cljs$core$array(var_args) {
  var a = new Array(arguments.length);
  var i = 0;
  while (true) {
    if (i < a.length) {
      a[i] = arguments[i];
      var G__6776 = i + 1;
      i = G__6776;
      continue;
    } else {
      return a;
    }
    break;
  }
};
cljs.core.aget = function cljs$core$aget() {
  var G__6781 = arguments.length;
  switch(G__6781) {
    case 2:
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return array[i];
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = function(array, i, idxs) {
  var G__6782 = cljs.core.aget;
  var G__6783 = array[i];
  var G__6784 = idxs;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__6782, G__6783, G__6784) : cljs.core.apply.call(null, G__6782, G__6783, G__6784);
};
cljs.core.aget.cljs$lang$applyTo = function(seq6777) {
  var G__6778 = cljs.core.first(seq6777);
  var seq6777__$1 = cljs.core.next(seq6777);
  var G__6779 = cljs.core.first(seq6777__$1);
  var seq6777__$2 = cljs.core.next(seq6777__$1);
  return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__6778, G__6779, seq6777__$2);
};
cljs.core.aget.cljs$lang$maxFixedArity = 2;
cljs.core.aset = function cljs$core$aset() {
  var G__6791 = arguments.length;
  switch(G__6791) {
    case 3:
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = function(array, i, val) {
  return array[i] = val;
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  var G__6792 = cljs.core.aset;
  var G__6793 = array[idx];
  var G__6794 = idx2;
  var G__6795 = idxv;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__6792, G__6793, G__6794, G__6795) : cljs.core.apply.call(null, G__6792, G__6793, G__6794, G__6795);
};
cljs.core.aset.cljs$lang$applyTo = function(seq6786) {
  var G__6787 = cljs.core.first(seq6786);
  var seq6786__$1 = cljs.core.next(seq6786);
  var G__6788 = cljs.core.first(seq6786__$1);
  var seq6786__$2 = cljs.core.next(seq6786__$1);
  var G__6789 = cljs.core.first(seq6786__$2);
  var seq6786__$3 = cljs.core.next(seq6786__$2);
  return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__6787, G__6788, G__6789, seq6786__$3);
};
cljs.core.aset.cljs$lang$maxFixedArity = 3;
cljs.core.alength = function cljs$core$alength(array) {
  return array.length;
};
cljs.core.into_array = function cljs$core$into_array() {
  var G__6798 = arguments.length;
  switch(G__6798) {
    case 1:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = function(aseq) {
  return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null, aseq);
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = function(type, aseq) {
  var G__6799 = function(a, x) {
    a.push(x);
    return a;
  };
  var G__6800 = [];
  var G__6801 = aseq;
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__6799, G__6800, G__6801) : cljs.core.reduce.call(null, G__6799, G__6800, G__6801);
};
cljs.core.into_array.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke = function cljs$core$js_invoke() {
  var argseq__5349__auto__ = 2 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0) : null;
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5349__auto__);
};
cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = function(obj, s, args) {
  return obj[s].apply(obj, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
cljs.core.js_invoke.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke.cljs$lang$applyTo = function(seq6803) {
  var G__6804 = cljs.core.first(seq6803);
  var seq6803__$1 = cljs.core.next(seq6803);
  var G__6805 = cljs.core.first(seq6803__$1);
  var seq6803__$2 = cljs.core.next(seq6803__$1);
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__6804, G__6805, seq6803__$2);
};
cljs.core.Fn = function() {
  var obj6807 = {};
  return obj6807;
}();
cljs.core.IFn = function() {
  var obj6809 = {};
  return obj6809;
}();
cljs.core._invoke = function cljs$core$_invoke() {
  var G__6811 = arguments.length;
  switch(G__6811) {
    case 1:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    case 8:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
      break;
    case 9:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
      break;
    case 10:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
      break;
    case 11:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
      break;
    case 12:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
      break;
    case 13:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
      break;
    case 14:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
      break;
    case 15:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
      break;
    case 16:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15]);
      break;
    case 17:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16]);
      break;
    case 18:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17]);
      break;
    case 19:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18]);
      break;
    case 20:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19]);
      break;
    case 21:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20]);
      break;
    case 22:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20], arguments[21]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = function(this$) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$1(this$);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6813 = x__4945__auto__;
        return goog.typeOf(G__6813);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = function(this$, a) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$2(this$, a);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6815 = x__4945__auto__;
        return goog.typeOf(G__6815);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = function(this$, a, b) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6817 = x__4945__auto__;
        return goog.typeOf(G__6817);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = function(this$, a, b, c) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$4;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6819 = x__4945__auto__;
        return goog.typeOf(G__6819);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = function(this$, a, b, c, d) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$5;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6821 = x__4945__auto__;
        return goog.typeOf(G__6821);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = function(this$, a, b, c, d, e) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$6;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6823 = x__4945__auto__;
        return goog.typeOf(G__6823);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = function(this$, a, b, c, d, e, f) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$7;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6825 = x__4945__auto__;
        return goog.typeOf(G__6825);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = function(this$, a, b, c, d, e, f, g) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$8;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6827 = x__4945__auto__;
        return goog.typeOf(G__6827);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = function(this$, a, b, c, d, e, f, g, h) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$9;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6829 = x__4945__auto__;
        return goog.typeOf(G__6829);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = function(this$, a, b, c, d, e, f, g, h, i) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$10;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6831 = x__4945__auto__;
        return goog.typeOf(G__6831);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$11;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6833 = x__4945__auto__;
        return goog.typeOf(G__6833);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$12;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6835 = x__4945__auto__;
        return goog.typeOf(G__6835);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$13;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6837 = x__4945__auto__;
        return goog.typeOf(G__6837);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$14;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6839 = x__4945__auto__;
        return goog.typeOf(G__6839);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$15;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6841 = x__4945__auto__;
        return goog.typeOf(G__6841);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$16;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6843 = x__4945__auto__;
        return goog.typeOf(G__6843);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$17;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6845 = x__4945__auto__;
        return goog.typeOf(G__6845);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$18;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6847 = x__4945__auto__;
        return goog.typeOf(G__6847);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$19;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6849 = x__4945__auto__;
        return goog.typeOf(G__6849);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$20;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6851 = x__4945__auto__;
        return goog.typeOf(G__6851);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$21;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6853 = x__4945__auto__;
        return goog.typeOf(G__6853);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$22;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__6855 = x__4945__auto__;
        return goog.typeOf(G__6855);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  }
};
cljs.core._invoke.cljs$lang$maxFixedArity = 22;
cljs.core.ICloneable = function() {
  var obj6858 = {};
  return obj6858;
}();
cljs.core._clone = function cljs$core$_clone(value) {
  if (function() {
    var and__4297__auto__ = value;
    if (and__4297__auto__) {
      return value.cljs$core$ICloneable$_clone$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return value.cljs$core$ICloneable$_clone$arity$1(value);
  } else {
    var x__4945__auto__ = value == null ? null : value;
    return function() {
      var or__4309__auto__ = cljs.core._clone[function() {
        var G__6862 = x__4945__auto__;
        return goog.typeOf(G__6862);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._clone["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICloneable.-clone", value);
        }
      }
    }().call(null, value);
  }
};
cljs.core.ICounted = function() {
  var obj6864 = {};
  return obj6864;
}();
cljs.core._count = function cljs$core$_count(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ICounted$_count$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._count[function() {
        var G__6868 = x__4945__auto__;
        return goog.typeOf(G__6868);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._count["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICounted.-count", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IEmptyableCollection = function() {
  var obj6870 = {};
  return obj6870;
}();
cljs.core._empty = function cljs$core$_empty(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._empty[function() {
        var G__6874 = x__4945__auto__;
        return goog.typeOf(G__6874);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._empty["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ICollection = function() {
  var obj6876 = {};
  return obj6876;
}();
cljs.core._conj = function cljs$core$_conj(coll, o) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ICollection$_conj$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._conj[function() {
        var G__6880 = x__4945__auto__;
        return goog.typeOf(G__6880);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._conj["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o);
  }
};
cljs.core.IIndexed = function() {
  var obj6882 = {};
  return obj6882;
}();
cljs.core._nth = function cljs$core$_nth() {
  var G__6884 = arguments.length;
  switch(G__6884) {
    case 2:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IIndexed$_nth$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._nth[function() {
        var G__6886 = x__4945__auto__;
        return goog.typeOf(G__6886);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._nth["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIndexed.-nth", coll);
        }
      }
    }().call(null, coll, n);
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IIndexed$_nth$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._nth[function() {
        var G__6888 = x__4945__auto__;
        return goog.typeOf(G__6888);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._nth["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIndexed.-nth", coll);
        }
      }
    }().call(null, coll, n, not_found);
  }
};
cljs.core._nth.cljs$lang$maxFixedArity = 3;
cljs.core.ASeq = function() {
  var obj6891 = {};
  return obj6891;
}();
cljs.core.ISeq = function() {
  var obj6893 = {};
  return obj6893;
}();
cljs.core._first = function cljs$core$_first(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISeq$_first$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._first[function() {
        var G__6897 = x__4945__auto__;
        return goog.typeOf(G__6897);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._first["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeq.-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._rest = function cljs$core$_rest(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISeq$_rest$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._rest[function() {
        var G__6901 = x__4945__auto__;
        return goog.typeOf(G__6901);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._rest["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeq.-rest", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.INext = function() {
  var obj6903 = {};
  return obj6903;
}();
cljs.core._next = function cljs$core$_next(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$INext$_next$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$INext$_next$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._next[function() {
        var G__6907 = x__4945__auto__;
        return goog.typeOf(G__6907);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._next["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INext.-next", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ILookup = function() {
  var obj6909 = {};
  return obj6909;
}();
cljs.core._lookup = function cljs$core$_lookup() {
  var G__6911 = arguments.length;
  switch(G__6911) {
    case 2:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ILookup$_lookup$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ILookup$_lookup$arity$2(o, k);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._lookup[function() {
        var G__6913 = x__4945__auto__;
        return goog.typeOf(G__6913);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._lookup["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ILookup.-lookup", o);
        }
      }
    }().call(null, o, k);
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ILookup$_lookup$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._lookup[function() {
        var G__6915 = x__4945__auto__;
        return goog.typeOf(G__6915);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._lookup["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ILookup.-lookup", o);
        }
      }
    }().call(null, o, k, not_found);
  }
};
cljs.core._lookup.cljs$lang$maxFixedArity = 3;
cljs.core.IAssociative = function() {
  var obj6918 = {};
  return obj6918;
}();
cljs.core._contains_key_QMARK_ = function cljs$core$_contains_key_QMARK_(coll, k) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._contains_key_QMARK_[function() {
        var G__6922 = x__4945__auto__;
        return goog.typeOf(G__6922);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._contains_key_QMARK_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k);
  }
};
cljs.core._assoc = function cljs$core$_assoc(coll, k, v) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IAssociative$_assoc$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc[function() {
        var G__6926 = x__4945__auto__;
        return goog.typeOf(G__6926);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v);
  }
};
cljs.core.IMap = function() {
  var obj6928 = {};
  return obj6928;
}();
cljs.core._dissoc = function cljs$core$_dissoc(coll, k) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IMap$_dissoc$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._dissoc[function() {
        var G__6932 = x__4945__auto__;
        return goog.typeOf(G__6932);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._dissoc["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k);
  }
};
cljs.core.IMapEntry = function() {
  var obj6934 = {};
  return obj6934;
}();
cljs.core._key = function cljs$core$_key(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IMapEntry$_key$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._key[function() {
        var G__6938 = x__4945__auto__;
        return goog.typeOf(G__6938);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._key["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMapEntry.-key", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._val = function cljs$core$_val(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IMapEntry$_val$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._val[function() {
        var G__6942 = x__4945__auto__;
        return goog.typeOf(G__6942);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._val["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMapEntry.-val", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ISet = function() {
  var obj6944 = {};
  return obj6944;
}();
cljs.core._disjoin = function cljs$core$_disjoin(coll, v) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISet$_disjoin$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._disjoin[function() {
        var G__6948 = x__4945__auto__;
        return goog.typeOf(G__6948);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._disjoin["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v);
  }
};
cljs.core.IStack = function() {
  var obj6950 = {};
  return obj6950;
}();
cljs.core._peek = function cljs$core$_peek(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IStack$_peek$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._peek[function() {
        var G__6954 = x__4945__auto__;
        return goog.typeOf(G__6954);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._peek["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IStack.-peek", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._pop = function cljs$core$_pop(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IStack$_pop$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._pop[function() {
        var G__6958 = x__4945__auto__;
        return goog.typeOf(G__6958);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._pop["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IStack.-pop", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IVector = function() {
  var obj6960 = {};
  return obj6960;
}();
cljs.core._assoc_n = function cljs$core$_assoc_n(coll, n, val) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IVector$_assoc_n$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc_n[function() {
        var G__6964 = x__4945__auto__;
        return goog.typeOf(G__6964);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc_n["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val);
  }
};
cljs.core.IDeref = function() {
  var obj6966 = {};
  return obj6966;
}();
cljs.core._deref = function cljs$core$_deref(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IDeref$_deref$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._deref[function() {
        var G__6970 = x__4945__auto__;
        return goog.typeOf(G__6970);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._deref["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IDeref.-deref", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.IDerefWithTimeout = function() {
  var obj6972 = {};
  return obj6972;
}();
cljs.core._deref_with_timeout = function cljs$core$_deref_with_timeout(o, msec, timeout_val) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._deref_with_timeout[function() {
        var G__6976 = x__4945__auto__;
        return goog.typeOf(G__6976);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._deref_with_timeout["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val);
  }
};
cljs.core.IMeta = function() {
  var obj6978 = {};
  return obj6978;
}();
cljs.core._meta = function cljs$core$_meta(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IMeta$_meta$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._meta[function() {
        var G__6982 = x__4945__auto__;
        return goog.typeOf(G__6982);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._meta["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMeta.-meta", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.IWithMeta = function() {
  var obj6984 = {};
  return obj6984;
}();
cljs.core._with_meta = function cljs$core$_with_meta(o, meta) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._with_meta[function() {
        var G__6988 = x__4945__auto__;
        return goog.typeOf(G__6988);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._with_meta["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta);
  }
};
cljs.core.IReduce = function() {
  var obj6990 = {};
  return obj6990;
}();
cljs.core._reduce = function cljs$core$_reduce() {
  var G__6992 = arguments.length;
  switch(G__6992) {
    case 2:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IReduce$_reduce$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._reduce[function() {
        var G__6994 = x__4945__auto__;
        return goog.typeOf(G__6994);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._reduce["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReduce.-reduce", coll);
        }
      }
    }().call(null, coll, f);
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, start) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IReduce$_reduce$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._reduce[function() {
        var G__6996 = x__4945__auto__;
        return goog.typeOf(G__6996);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._reduce["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReduce.-reduce", coll);
        }
      }
    }().call(null, coll, f, start);
  }
};
cljs.core._reduce.cljs$lang$maxFixedArity = 3;
cljs.core.IKVReduce = function() {
  var obj6999 = {};
  return obj6999;
}();
cljs.core._kv_reduce = function cljs$core$_kv_reduce(coll, f, init) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._kv_reduce[function() {
        var G__7003 = x__4945__auto__;
        return goog.typeOf(G__7003);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._kv_reduce["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init);
  }
};
cljs.core.IEquiv = function() {
  var obj7005 = {};
  return obj7005;
}();
cljs.core._equiv = function cljs$core$_equiv(o, other) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IEquiv$_equiv$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._equiv[function() {
        var G__7009 = x__4945__auto__;
        return goog.typeOf(G__7009);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._equiv["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other);
  }
};
cljs.core.IHash = function() {
  var obj7011 = {};
  return obj7011;
}();
cljs.core._hash = function cljs$core$_hash(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IHash$_hash$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._hash[function() {
        var G__7015 = x__4945__auto__;
        return goog.typeOf(G__7015);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._hash["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IHash.-hash", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.ISeqable = function() {
  var obj7017 = {};
  return obj7017;
}();
cljs.core._seq = function cljs$core$_seq(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISeqable$_seq$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._seq[function() {
        var G__7021 = x__4945__auto__;
        return goog.typeOf(G__7021);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._seq["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeqable.-seq", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.ISequential = function() {
  var obj7023 = {};
  return obj7023;
}();
cljs.core.IList = function() {
  var obj7025 = {};
  return obj7025;
}();
cljs.core.IRecord = function() {
  var obj7027 = {};
  return obj7027;
}();
cljs.core.IReversible = function() {
  var obj7029 = {};
  return obj7029;
}();
cljs.core._rseq = function cljs$core$_rseq(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IReversible$_rseq$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._rseq[function() {
        var G__7033 = x__4945__auto__;
        return goog.typeOf(G__7033);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._rseq["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReversible.-rseq", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ISorted = function() {
  var obj7035 = {};
  return obj7035;
}();
cljs.core._sorted_seq = function cljs$core$_sorted_seq(coll, ascending_QMARK_) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._sorted_seq[function() {
        var G__7039 = x__4945__auto__;
        return goog.typeOf(G__7039);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._sorted_seq["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_);
  }
};
cljs.core._sorted_seq_from = function cljs$core$_sorted_seq_from(coll, k, ascending_QMARK_) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._sorted_seq_from[function() {
        var G__7043 = x__4945__auto__;
        return goog.typeOf(G__7043);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._sorted_seq_from["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_);
  }
};
cljs.core._entry_key = function cljs$core$_entry_key(coll, entry) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_entry_key$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._entry_key[function() {
        var G__7047 = x__4945__auto__;
        return goog.typeOf(G__7047);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._entry_key["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry);
  }
};
cljs.core._comparator = function cljs$core$_comparator(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_comparator$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._comparator[function() {
        var G__7051 = x__4945__auto__;
        return goog.typeOf(G__7051);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._comparator["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-comparator", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IWriter = function() {
  var obj7053 = {};
  return obj7053;
}();
cljs.core._write = function cljs$core$_write(writer, s) {
  if (function() {
    var and__4297__auto__ = writer;
    if (and__4297__auto__) {
      return writer.cljs$core$IWriter$_write$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return writer.cljs$core$IWriter$_write$arity$2(writer, s);
  } else {
    var x__4945__auto__ = writer == null ? null : writer;
    return function() {
      var or__4309__auto__ = cljs.core._write[function() {
        var G__7057 = x__4945__auto__;
        return goog.typeOf(G__7057);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._write["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWriter.-write", writer);
        }
      }
    }().call(null, writer, s);
  }
};
cljs.core._flush = function cljs$core$_flush(writer) {
  if (function() {
    var and__4297__auto__ = writer;
    if (and__4297__auto__) {
      return writer.cljs$core$IWriter$_flush$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return writer.cljs$core$IWriter$_flush$arity$1(writer);
  } else {
    var x__4945__auto__ = writer == null ? null : writer;
    return function() {
      var or__4309__auto__ = cljs.core._flush[function() {
        var G__7061 = x__4945__auto__;
        return goog.typeOf(G__7061);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._flush["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWriter.-flush", writer);
        }
      }
    }().call(null, writer);
  }
};
cljs.core.IPrintWithWriter = function() {
  var obj7063 = {};
  return obj7063;
}();
cljs.core._pr_writer = function cljs$core$_pr_writer(o, writer, opts) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._pr_writer[function() {
        var G__7067 = x__4945__auto__;
        return goog.typeOf(G__7067);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._pr_writer["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer", o);
        }
      }
    }().call(null, o, writer, opts);
  }
};
cljs.core.IPending = function() {
  var obj7069 = {};
  return obj7069;
}();
cljs.core._realized_QMARK_ = function cljs$core$_realized_QMARK_(d) {
  if (function() {
    var and__4297__auto__ = d;
    if (and__4297__auto__) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
  } else {
    var x__4945__auto__ = d == null ? null : d;
    return function() {
      var or__4309__auto__ = cljs.core._realized_QMARK_[function() {
        var G__7073 = x__4945__auto__;
        return goog.typeOf(G__7073);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._realized_QMARK_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IPending.-realized?", d);
        }
      }
    }().call(null, d);
  }
};
cljs.core.IWatchable = function() {
  var obj7075 = {};
  return obj7075;
}();
cljs.core._notify_watches = function cljs$core$_notify_watches(this$, oldval, newval) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._notify_watches[function() {
        var G__7079 = x__4945__auto__;
        return goog.typeOf(G__7079);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._notify_watches["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval);
  }
};
cljs.core._add_watch = function cljs$core$_add_watch(this$, key, f) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._add_watch[function() {
        var G__7083 = x__4945__auto__;
        return goog.typeOf(G__7083);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._add_watch["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f);
  }
};
cljs.core._remove_watch = function cljs$core$_remove_watch(this$, key) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._remove_watch[function() {
        var G__7087 = x__4945__auto__;
        return goog.typeOf(G__7087);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._remove_watch["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key);
  }
};
cljs.core.IEditableCollection = function() {
  var obj7089 = {};
  return obj7089;
}();
cljs.core._as_transient = function cljs$core$_as_transient(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._as_transient[function() {
        var G__7093 = x__4945__auto__;
        return goog.typeOf(G__7093);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._as_transient["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ITransientCollection = function() {
  var obj7095 = {};
  return obj7095;
}();
cljs.core._conj_BANG_ = function cljs$core$_conj_BANG_(tcoll, val) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._conj_BANG_[function() {
        var G__7099 = x__4945__auto__;
        return goog.typeOf(G__7099);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._conj_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val);
  }
};
cljs.core._persistent_BANG_ = function cljs$core$_persistent_BANG_(tcoll) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._persistent_BANG_[function() {
        var G__7103 = x__4945__auto__;
        return goog.typeOf(G__7103);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._persistent_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll);
  }
};
cljs.core.ITransientAssociative = function() {
  var obj7105 = {};
  return obj7105;
}();
cljs.core._assoc_BANG_ = function cljs$core$_assoc_BANG_(tcoll, key, val) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc_BANG_[function() {
        var G__7109 = x__4945__auto__;
        return goog.typeOf(G__7109);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val);
  }
};
cljs.core.ITransientMap = function() {
  var obj7111 = {};
  return obj7111;
}();
cljs.core._dissoc_BANG_ = function cljs$core$_dissoc_BANG_(tcoll, key) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._dissoc_BANG_[function() {
        var G__7115 = x__4945__auto__;
        return goog.typeOf(G__7115);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._dissoc_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key);
  }
};
cljs.core.ITransientVector = function() {
  var obj7117 = {};
  return obj7117;
}();
cljs.core._assoc_n_BANG_ = function cljs$core$_assoc_n_BANG_(tcoll, n, val) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc_n_BANG_[function() {
        var G__7121 = x__4945__auto__;
        return goog.typeOf(G__7121);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc_n_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val);
  }
};
cljs.core._pop_BANG_ = function cljs$core$_pop_BANG_(tcoll) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._pop_BANG_[function() {
        var G__7125 = x__4945__auto__;
        return goog.typeOf(G__7125);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._pop_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll);
  }
};
cljs.core.ITransientSet = function() {
  var obj7127 = {};
  return obj7127;
}();
cljs.core._disjoin_BANG_ = function cljs$core$_disjoin_BANG_(tcoll, v) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._disjoin_BANG_[function() {
        var G__7131 = x__4945__auto__;
        return goog.typeOf(G__7131);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._disjoin_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v);
  }
};
cljs.core.IComparable = function() {
  var obj7133 = {};
  return obj7133;
}();
cljs.core._compare = function cljs$core$_compare(x, y) {
  if (function() {
    var and__4297__auto__ = x;
    if (and__4297__auto__) {
      return x.cljs$core$IComparable$_compare$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y);
  } else {
    var x__4945__auto__ = x == null ? null : x;
    return function() {
      var or__4309__auto__ = cljs.core._compare[function() {
        var G__7137 = x__4945__auto__;
        return goog.typeOf(G__7137);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._compare["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IComparable.-compare", x);
        }
      }
    }().call(null, x, y);
  }
};
cljs.core.IChunk = function() {
  var obj7139 = {};
  return obj7139;
}();
cljs.core._drop_first = function cljs$core$_drop_first(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunk$_drop_first$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._drop_first[function() {
        var G__7143 = x__4945__auto__;
        return goog.typeOf(G__7143);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._drop_first["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunk.-drop-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IChunkedSeq = function() {
  var obj7145 = {};
  return obj7145;
}();
cljs.core._chunked_first = function cljs$core$_chunked_first(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._chunked_first[function() {
        var G__7149 = x__4945__auto__;
        return goog.typeOf(G__7149);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._chunked_first["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._chunked_rest = function cljs$core$_chunked_rest(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._chunked_rest[function() {
        var G__7153 = x__4945__auto__;
        return goog.typeOf(G__7153);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._chunked_rest["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IChunkedNext = function() {
  var obj7155 = {};
  return obj7155;
}();
cljs.core._chunked_next = function cljs$core$_chunked_next(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._chunked_next[function() {
        var G__7159 = x__4945__auto__;
        return goog.typeOf(G__7159);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._chunked_next["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedNext.-chunked-next", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.INamed = function() {
  var obj7161 = {};
  return obj7161;
}();
cljs.core._name = function cljs$core$_name(x) {
  if (function() {
    var and__4297__auto__ = x;
    if (and__4297__auto__) {
      return x.cljs$core$INamed$_name$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return x.cljs$core$INamed$_name$arity$1(x);
  } else {
    var x__4945__auto__ = x == null ? null : x;
    return function() {
      var or__4309__auto__ = cljs.core._name[function() {
        var G__7165 = x__4945__auto__;
        return goog.typeOf(G__7165);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._name["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INamed.-name", x);
        }
      }
    }().call(null, x);
  }
};
cljs.core._namespace = function cljs$core$_namespace(x) {
  if (function() {
    var and__4297__auto__ = x;
    if (and__4297__auto__) {
      return x.cljs$core$INamed$_namespace$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return x.cljs$core$INamed$_namespace$arity$1(x);
  } else {
    var x__4945__auto__ = x == null ? null : x;
    return function() {
      var or__4309__auto__ = cljs.core._namespace[function() {
        var G__7169 = x__4945__auto__;
        return goog.typeOf(G__7169);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._namespace["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INamed.-namespace", x);
        }
      }
    }().call(null, x);
  }
};
cljs.core.IAtom = function() {
  var obj7171 = {};
  return obj7171;
}();
cljs.core.IReset = function() {
  var obj7173 = {};
  return obj7173;
}();
cljs.core._reset_BANG_ = function cljs$core$_reset_BANG_(o, new_value) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IReset$_reset_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._reset_BANG_[function() {
        var G__7177 = x__4945__auto__;
        return goog.typeOf(G__7177);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._reset_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReset.-reset!", o);
        }
      }
    }().call(null, o, new_value);
  }
};
cljs.core.ISwap = function() {
  var obj7179 = {};
  return obj7179;
}();
cljs.core._swap_BANG_ = function cljs$core$_swap_BANG_() {
  var G__7181 = arguments.length;
  switch(G__7181) {
    case 2:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(o, f) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__7183 = x__4945__auto__;
        return goog.typeOf(G__7183);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(o, f, a) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__7185 = x__4945__auto__;
        return goog.typeOf(G__7185);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(o, f, a, b) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$4;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__7187 = x__4945__auto__;
        return goog.typeOf(G__7187);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a, b);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = function(o, f, a, b, xs) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$5;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__7189 = x__4945__auto__;
        return goog.typeOf(G__7189);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a, b, xs);
  }
};
cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;
cljs.core.IVolatile = function() {
  var obj7192 = {};
  return obj7192;
}();
cljs.core._vreset_BANG_ = function cljs$core$_vreset_BANG_(o, new_value) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o, new_value);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._vreset_BANG_[function() {
        var G__7196 = x__4945__auto__;
        return goog.typeOf(G__7196);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._vreset_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IVolatile.-vreset!", o);
        }
      }
    }().call(null, o, new_value);
  }
};
cljs.core.IIterable = function() {
  var obj7198 = {};
  return obj7198;
}();
cljs.core._iterator = function cljs$core$_iterator(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IIterable$_iterator$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IIterable$_iterator$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._iterator[function() {
        var G__7202 = x__4945__auto__;
        return goog.typeOf(G__7202);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._iterator["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIterable.-iterator", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.StringBufferWriter = function(sb) {
  this.sb = sb;
  this.cljs$lang$protocol_mask$partition0$ = 1073741824;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {
  var self__ = this;
  var ___$1 = this;
  return self__.sb.append(s);
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return null;
};
cljs.core.StringBufferWriter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "sb", "sb", -1249746442, null)], null);
};
cljs.core.StringBufferWriter.cljs$lang$type = true;
cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";
cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/StringBufferWriter");
};
cljs.core.__GT_StringBufferWriter = function cljs$core$__GT_StringBufferWriter(sb) {
  return new cljs.core.StringBufferWriter(sb);
};
cljs.core.pr_str_STAR_ = function cljs$core$pr_str_STAR_(obj) {
  var sb = new goog.string.StringBuffer;
  var writer = new cljs.core.StringBufferWriter(sb);
  obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer, cljs.core.pr_opts());
  writer.cljs$core$IWriter$_flush$arity$1(null);
  return [cljs.core.str(sb)].join("");
};
cljs.core.int_rotate_left = function cljs$core$int_rotate_left(x, n) {
  return x << n | x >>> -n;
};
if (typeof Math.imul !== "undefined" && !(function() {
  var G__7205 = 4294967295;
  var G__7206 = 5;
  return Math.imul(G__7205, G__7206);
}() === 0)) {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var G__7209 = a;
    var G__7210 = b;
    return Math.imul(G__7209, G__7210);
  };
} else {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var ah = a >>> 16 & 65535;
    var al = a & 65535;
    var bh = b >>> 16 & 65535;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
  };
}
cljs.core.m3_seed = 0;
cljs.core.m3_C1 = 3432918353 | 0;
cljs.core.m3_C2 = 461845907 | 0;
cljs.core.m3_mix_K1 = function cljs$core$m3_mix_K1(k1) {
  return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1 | 0, cljs.core.m3_C1), 15), cljs.core.m3_C2);
};
cljs.core.m3_mix_H1 = function cljs$core$m3_mix_H1(h1, k1) {
  return cljs.core.imul(cljs.core.int_rotate_left((h1 | 0) ^ (k1 | 0), 13), 5) + (3864292196 | 0) | 0;
};
cljs.core.m3_fmix = function cljs$core$m3_fmix(h1, len) {
  var h1__$1 = h1 | 0;
  var h1__$2 = h1__$1 ^ len;
  var h1__$3 = h1__$2 ^ h1__$2 >>> 16;
  var h1__$4 = cljs.core.imul(h1__$3, 2246822507 | 0);
  var h1__$5 = h1__$4 ^ h1__$4 >>> 13;
  var h1__$6 = cljs.core.imul(h1__$5, 3266489909 | 0);
  var h1__$7 = h1__$6 ^ h1__$6 >>> 16;
  return h1__$7;
};
cljs.core.m3_hash_int = function cljs$core$m3_hash_int(in$) {
  if (in$ === 0) {
    return in$;
  } else {
    var k1 = cljs.core.m3_mix_K1(in$);
    var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed, k1);
    return cljs.core.m3_fmix(h1, 4);
  }
};
cljs.core.m3_hash_unencoded_chars = function cljs$core$m3_hash_unencoded_chars(in$) {
  var h1 = function() {
    var i = 1;
    var h1 = cljs.core.m3_seed;
    while (true) {
      if (i < in$.length) {
        var G__7211 = i + 2;
        var G__7212 = cljs.core.m3_mix_H1(h1, cljs.core.m3_mix_K1(in$.charCodeAt(i - 1) | in$.charCodeAt(i) << 16));
        i = G__7211;
        h1 = G__7212;
        continue;
      } else {
        return h1;
      }
      break;
    }
  }();
  var h1__$1 = (in$.length & 1) === 1 ? h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt(in$.length - 1)) : h1;
  return cljs.core.m3_fmix(h1__$1, cljs.core.imul(2, in$.length));
};
cljs.core.string_hash_cache = function() {
  var obj7214 = {};
  return obj7214;
}();
cljs.core.string_hash_cache_count = 0;
cljs.core.hash_string_STAR_ = function cljs$core$hash_string_STAR_(s) {
  if (!(s == null)) {
    var len = s.length;
    if (len > 0) {
      var i = 0;
      var hash = 0;
      while (true) {
        if (i < len) {
          var G__7215 = i + 1;
          var G__7216 = cljs.core.imul(31, hash) + s.charCodeAt(i);
          i = G__7215;
          hash = G__7216;
          continue;
        } else {
          return hash;
        }
        break;
      }
    } else {
      return 0;
    }
  } else {
    return 0;
  }
};
cljs.core.add_to_string_hash_cache = function cljs$core$add_to_string_hash_cache(k) {
  var h = cljs.core.hash_string_STAR_(k);
  cljs.core.string_hash_cache[k] = h;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h;
};
cljs.core.hash_string = function cljs$core$hash_string(k) {
  if (cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = function() {
      var obj7220 = {};
      return obj7220;
    }();
    cljs.core.string_hash_cache_count = 0;
  } else {
  }
  var h = cljs.core.string_hash_cache[k];
  if (typeof h === "number") {
    return h;
  } else {
    return cljs.core.add_to_string_hash_cache(k);
  }
};
cljs.core.hash = function cljs$core$hash(o) {
  if (function() {
    var G__7223 = o;
    if (G__7223) {
      var bit__4976__auto__ = G__7223.cljs$lang$protocol_mask$partition0$ & 4194304;
      if (bit__4976__auto__ || G__7223.cljs$core$IHash$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(null);
  } else {
    if (typeof o === "number") {
      return function() {
        var G__7224 = o;
        return Math.floor(G__7224);
      }() % 2147483647;
    } else {
      if (o === true) {
        return 1;
      } else {
        if (o === false) {
          return 0;
        } else {
          if (typeof o === "string") {
            return cljs.core.m3_hash_int(cljs.core.hash_string(o));
          } else {
            if (o instanceof Date) {
              return o.valueOf();
            } else {
              if (o == null) {
                return 0;
              } else {
                return cljs.core._hash(o);
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.hash_combine = function cljs$core$hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2);
};
cljs.core.instance_QMARK_ = function cljs$core$instance_QMARK_(t, o) {
  return o instanceof t;
};
cljs.core.symbol_QMARK_ = function cljs$core$symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol;
};
cljs.core.hash_symbol = function cljs$core$hash_symbol(sym) {
  return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name), cljs.core.hash_string(sym.ns));
};
cljs.core.compare_symbols = function cljs$core$compare_symbols(a, b) {
  if (a.str === b.str) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = cljs.core.not(a.ns);
      if (and__4297__auto__) {
        return b.ns;
      } else {
        return and__4297__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__7231 = a.ns;
            var G__7232 = b.ns;
            return goog.array.defaultCompare(G__7231, G__7232);
          }();
          if (0 === nsc) {
            var G__7233 = a.name;
            var G__7234 = b.name;
            return goog.array.defaultCompare(G__7233, G__7234);
          } else {
            return nsc;
          }
        }
      } else {
        var G__7235 = a.name;
        var G__7236 = b.name;
        return goog.array.defaultCompare(G__7235, G__7236);
      }
    }
  }
};
cljs.core.Symbol = function(ns, name, str, _hash, _meta) {
  this.ns = ns;
  this.name = name;
  this.str = str;
  this._hash = _hash;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2154168321;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Symbol.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return self__.str;
};
cljs.core.Symbol.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Symbol) {
    return self__.str === other.str;
  } else {
    return false;
  }
};
cljs.core.Symbol.prototype.call = function() {
  var G__7238 = null;
  var G__7238__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, null);
  };
  var G__7238__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
  };
  G__7238 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7238__2.call(this, self__, coll);
      case 3:
        return G__7238__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__7238.cljs$core$IFn$_invoke$arity$2 = G__7238__2;
  G__7238.cljs$core$IFn$_invoke$arity$3 = G__7238__3;
  return G__7238;
}();
cljs.core.Symbol.prototype.apply = function(self__, args7237) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args7237)));
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var sym = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, null);
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var sym = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
};
cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);
};
cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {
  var self__ = this;
  var sym__$1 = this;
  var h__4725__auto__ = self__._hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_symbol(sym__$1);
    self__._hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, self__.str);
};
cljs.core.Symbol.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "str", "str", -1564826950, null), new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Symbol.cljs$lang$type = true;
cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";
cljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Symbol");
};
cljs.core.__GT_Symbol = function cljs$core$__GT_Symbol(ns, name, str, _hash, _meta) {
  return new cljs.core.Symbol(ns, name, str, _hash, _meta);
};
cljs.core.symbol = function cljs$core$symbol() {
  var G__7240 = arguments.length;
  switch(G__7240) {
    case 1:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Symbol) {
    return name;
  } else {
    return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null, name);
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var sym_str = !(ns == null) ? [cljs.core.str(ns), cljs.core.str("/"), cljs.core.str(name)].join("") : name;
  return new cljs.core.Symbol(ns, name, sym_str, null, null);
};
cljs.core.symbol.cljs$lang$maxFixedArity = 2;
cljs.core.Var = function(val, sym, _meta) {
  this.val = val;
  this.sym = sym;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 163841;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
};
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Var.prototype.cljs$core$Fn$ = true;
cljs.core.Var.prototype.call = function() {
  var G__7287 = null;
  var G__7287__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null);
  };
  var G__7287__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a);
  };
  var G__7287__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b);
  };
  var G__7287__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c);
  };
  var G__7287__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d);
  };
  var G__7287__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e);
  };
  var G__7287__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f);
  };
  var G__7287__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g);
  };
  var G__7287__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h);
  };
  var G__7287__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__7287__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__7287__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__7287__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__7287__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__7287__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__7287__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__7287__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__7287__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__7287__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__7287__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__7287__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__7287__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7243 = function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }();
    var G__7244 = a;
    var G__7245 = b;
    var G__7246 = c;
    var G__7247 = d;
    var G__7248 = e;
    var G__7249 = f;
    var G__7250 = g;
    var G__7251 = h;
    var G__7252 = i;
    var G__7253 = j;
    var G__7254 = k;
    var G__7255 = l;
    var G__7256 = m;
    var G__7257 = n;
    var G__7258 = o;
    var G__7259 = p;
    var G__7260 = q;
    var G__7261 = r;
    var G__7262 = s;
    var G__7263 = t;
    var G__7264 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7243, G__7244, G__7245, G__7246, G__7247, G__7248, G__7249, G__7250, G__7251, G__7252, G__7253, G__7254, G__7255, G__7256, G__7257, G__7258, G__7259, G__7260, G__7261, G__7262, G__7263, G__7264) : cljs.core.apply.call(null, G__7243, G__7244, G__7245, G__7246, G__7247, G__7248, G__7249, G__7250, G__7251, G__7252, G__7253, G__7254, G__7255, G__7256, G__7257, G__7258, G__7259, G__7260, G__7261, 
    G__7262, G__7263, G__7264);
  };
  G__7287 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__7287__1.call(this, self__);
      case 2:
        return G__7287__2.call(this, self__, a);
      case 3:
        return G__7287__3.call(this, self__, a, b);
      case 4:
        return G__7287__4.call(this, self__, a, b, c);
      case 5:
        return G__7287__5.call(this, self__, a, b, c, d);
      case 6:
        return G__7287__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__7287__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__7287__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__7287__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__7287__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__7287__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__7287__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__7287__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__7287__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__7287__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__7287__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__7287__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__7287__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__7287__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__7287__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__7287__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__7287__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__7287.cljs$core$IFn$_invoke$arity$1 = G__7287__1;
  G__7287.cljs$core$IFn$_invoke$arity$2 = G__7287__2;
  G__7287.cljs$core$IFn$_invoke$arity$3 = G__7287__3;
  G__7287.cljs$core$IFn$_invoke$arity$4 = G__7287__4;
  G__7287.cljs$core$IFn$_invoke$arity$5 = G__7287__5;
  G__7287.cljs$core$IFn$_invoke$arity$6 = G__7287__6;
  G__7287.cljs$core$IFn$_invoke$arity$7 = G__7287__7;
  G__7287.cljs$core$IFn$_invoke$arity$8 = G__7287__8;
  G__7287.cljs$core$IFn$_invoke$arity$9 = G__7287__9;
  G__7287.cljs$core$IFn$_invoke$arity$10 = G__7287__10;
  G__7287.cljs$core$IFn$_invoke$arity$11 = G__7287__11;
  G__7287.cljs$core$IFn$_invoke$arity$12 = G__7287__12;
  G__7287.cljs$core$IFn$_invoke$arity$13 = G__7287__13;
  G__7287.cljs$core$IFn$_invoke$arity$14 = G__7287__14;
  G__7287.cljs$core$IFn$_invoke$arity$15 = G__7287__15;
  G__7287.cljs$core$IFn$_invoke$arity$16 = G__7287__16;
  G__7287.cljs$core$IFn$_invoke$arity$17 = G__7287__17;
  G__7287.cljs$core$IFn$_invoke$arity$18 = G__7287__18;
  G__7287.cljs$core$IFn$_invoke$arity$19 = G__7287__19;
  G__7287.cljs$core$IFn$_invoke$arity$20 = G__7287__20;
  G__7287.cljs$core$IFn$_invoke$arity$21 = G__7287__21;
  G__7287.cljs$core$IFn$_invoke$arity$22 = G__7287__22;
  return G__7287;
}();
cljs.core.Var.prototype.apply = function(self__, args7242) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args7242)));
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__7265 = function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }();
  var G__7266 = a;
  var G__7267 = b;
  var G__7268 = c;
  var G__7269 = d;
  var G__7270 = e;
  var G__7271 = f;
  var G__7272 = g;
  var G__7273 = h;
  var G__7274 = i;
  var G__7275 = j;
  var G__7276 = k;
  var G__7277 = l;
  var G__7278 = m;
  var G__7279 = n;
  var G__7280 = o;
  var G__7281 = p;
  var G__7282 = q;
  var G__7283 = r;
  var G__7284 = s;
  var G__7285 = t;
  var G__7286 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7265, G__7266, G__7267, G__7268, G__7269, G__7270, G__7271, G__7272, G__7273, G__7274, G__7275, G__7276, G__7277, G__7278, G__7279, G__7280, G__7281, G__7282, G__7283, G__7284, G__7285, G__7286) : cljs.core.apply.call(null, G__7265, G__7266, G__7267, G__7268, G__7269, G__7270, G__7271, G__7272, G__7273, G__7274, G__7275, G__7276, G__7277, G__7278, G__7279, G__7280, G__7281, G__7282, G__7283, 
  G__7284, G__7285, G__7286);
};
cljs.core.Var.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "sym", "sym", 195671222, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Var.cljs$lang$type = true;
cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Var");
};
cljs.core.__GT_Var = function cljs$core$__GT_Var(val, sym, _meta) {
  return new cljs.core.Var(val, sym, _meta);
};
cljs.core.var_QMARK_ = function cljs$core$var_QMARK_(v) {
  return v instanceof cljs.core.Var;
};
cljs.core.iterable_QMARK_ = function cljs$core$iterable_QMARK_(x) {
  var G__7289 = x;
  if (G__7289) {
    var bit__4983__auto__ = null;
    if (cljs.core.truth_(function() {
      var or__4309__auto__ = bit__4983__auto__;
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        return G__7289.cljs$core$IIterable$;
      }
    }())) {
      return true;
    } else {
      if (!G__7289.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, G__7289);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, G__7289);
  }
};
cljs.core.clone = function cljs$core$clone(value) {
  return cljs.core._clone(value);
};
cljs.core.cloneable_QMARK_ = function cljs$core$cloneable_QMARK_(value) {
  var G__7291 = value;
  if (G__7291) {
    var bit__4983__auto__ = G__7291.cljs$lang$protocol_mask$partition1$ & 8192;
    if (bit__4983__auto__ || G__7291.cljs$core$ICloneable$) {
      return true;
    } else {
      if (!G__7291.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, G__7291);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, G__7291);
  }
};
cljs.core.seq = function cljs$core$seq(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__7293 = coll;
      if (G__7293) {
        var bit__4976__auto__ = G__7293.cljs$lang$protocol_mask$partition0$ & 8388608;
        if (bit__4976__auto__ || G__7293.cljs$core$ISeqable$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeqable$_seq$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        if (coll.length === 0) {
          return null;
        } else {
          return new cljs.core.IndexedSeq(coll, 0);
        }
      } else {
        if (typeof coll === "string") {
          if (coll.length === 0) {
            return null;
          } else {
            return new cljs.core.IndexedSeq(coll, 0);
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, coll)) {
            return cljs.core._seq(coll);
          } else {
            throw new Error([cljs.core.str(coll), cljs.core.str(" is not ISeqable")].join(""));
          }
        }
      }
    }
  }
};
cljs.core.first = function cljs$core$first(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__7295 = coll;
      if (G__7295) {
        var bit__4976__auto__ = G__7295.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4976__auto__ || G__7295.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeq$_first$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s == null) {
        return null;
      } else {
        return cljs.core._first(s);
      }
    }
  }
};
cljs.core.rest = function cljs$core$rest(coll) {
  if (!(coll == null)) {
    if (function() {
      var G__7297 = coll;
      if (G__7297) {
        var bit__4976__auto__ = G__7297.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4976__auto__ || G__7297.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeq$_rest$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s) {
        return cljs.core._rest(s);
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.next = function cljs$core$next(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__7299 = coll;
      if (G__7299) {
        var bit__4976__auto__ = G__7299.cljs$lang$protocol_mask$partition0$ & 128;
        if (bit__4976__auto__ || G__7299.cljs$core$INext$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$INext$_next$arity$1(null);
    } else {
      return cljs.core.seq(cljs.core.rest(coll));
    }
  }
};
cljs.core._EQ_ = function cljs$core$_EQ_() {
  var G__7304 = arguments.length;
  switch(G__7304) {
    case 1:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  if (x == null) {
    return y == null;
  } else {
    return x === y || cljs.core._equiv(x, y);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
      if (cljs.core.next(more)) {
        var G__7306 = y;
        var G__7307 = cljs.core.first(more);
        var G__7308 = cljs.core.next(more);
        x = G__7306;
        y = G__7307;
        more = G__7308;
        continue;
      } else {
        return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y, cljs.core.first(more));
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ_.cljs$lang$applyTo = function(seq7300) {
  var G__7301 = cljs.core.first(seq7300);
  var seq7300__$1 = cljs.core.next(seq7300);
  var G__7302 = cljs.core.first(seq7300__$1);
  var seq7300__$2 = cljs.core.next(seq7300__$1);
  return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__7301, G__7302, seq7300__$2);
};
cljs.core._EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.ES6Iterator = function(s) {
  this.s = s;
};
cljs.core.ES6Iterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":x, "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6Iterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null)], null);
};
cljs.core.ES6Iterator.cljs$lang$type = true;
cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6Iterator");
};
cljs.core.__GT_ES6Iterator = function cljs$core$__GT_ES6Iterator(s) {
  return new cljs.core.ES6Iterator(s);
};
cljs.core.es6_iterator = function cljs$core$es6_iterator(coll) {
  return new cljs.core.ES6Iterator(cljs.core.seq(coll));
};
cljs.core.ES6IteratorSeq = function(value, iter, _rest) {
  this.value = value;
  this.iter = iter;
  this._rest = _rest;
  this.cljs$lang$protocol_mask$partition0$ = 8388672;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.value;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__._rest == null) {
    self__._rest = function() {
      var G__7309 = self__.iter;
      return cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__7309) : cljs.core.es6_iterator_seq.call(null, G__7309);
    }();
  } else {
  }
  return self__._rest;
};
cljs.core.ES6IteratorSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "value", "value", 1946509744, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null), new cljs.core.Symbol(null, "_rest", "_rest", -2100466189, null)], null);
};
cljs.core.ES6IteratorSeq.cljs$lang$type = true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";
cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6IteratorSeq");
};
cljs.core.__GT_ES6IteratorSeq = function cljs$core$__GT_ES6IteratorSeq(value, iter, _rest) {
  return new cljs.core.ES6IteratorSeq(value, iter, _rest);
};
cljs.core.es6_iterator_seq = function cljs$core$es6_iterator_seq(iter) {
  var v = iter.next();
  if (cljs.core.truth_(v.done)) {
    return cljs.core.List.EMPTY;
  } else {
    return new cljs.core.ES6IteratorSeq(v.value, iter, null);
  }
};
cljs.core.mix_collection_hash = function cljs$core$mix_collection_hash(hash_basis, count) {
  var h1 = cljs.core.m3_seed;
  var k1 = cljs.core.m3_mix_K1(hash_basis);
  var h1__$1 = cljs.core.m3_mix_H1(h1, k1);
  return cljs.core.m3_fmix(h1__$1, count);
};
cljs.core.hash_ordered_coll = function cljs$core$hash_ordered_coll(coll) {
  var n = 0;
  var hash_code = 1;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__7310 = n + 1;
      var G__7311 = cljs.core.imul(31, hash_code) + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__7312 = cljs.core.next(coll__$1);
      n = G__7310;
      hash_code = G__7311;
      coll__$1 = G__7312;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash(1, 0);
cljs.core.hash_unordered_coll = function cljs$core$hash_unordered_coll(coll) {
  var n = 0;
  var hash_code = 0;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__7313 = n + 1;
      var G__7314 = hash_code + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__7315 = cljs.core.next(coll__$1);
      n = G__7313;
      hash_code = G__7314;
      coll__$1 = G__7315;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash(0, 0);
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0;
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var o__$1 = this;
  return other instanceof Date && o__$1.valueOf() === other.valueOf();
};
Date.prototype.cljs$core$IComparable$ = true;
Date.prototype.cljs$core$IComparable$_compare$arity$2 = function(this$, other) {
  var this$__$1 = this;
  if (other instanceof Date) {
    var G__7316 = this$__$1.valueOf();
    var G__7317 = other.valueOf();
    return goog.array.defaultCompare(G__7316, G__7317);
  } else {
    throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(this$__$1), cljs.core.str(" to "), cljs.core.str(other)].join(""));
  }
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o;
};
cljs.core.Fn["function"] = true;
cljs.core.IMeta["function"] = true;
cljs.core._meta["function"] = function(_) {
  return null;
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  var G__7318 = o;
  return goog.getUid(G__7318);
};
cljs.core.inc = function cljs$core$inc(x) {
  return x + 1;
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var self__ = this;
  var o__$1 = this;
  return self__.val;
};
cljs.core.Reduced.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";
cljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Reduced");
};
cljs.core.__GT_Reduced = function cljs$core$__GT_Reduced(val) {
  return new cljs.core.Reduced(val);
};
cljs.core.reduced = function cljs$core$reduced(x) {
  return new cljs.core.Reduced(x);
};
cljs.core.reduced_QMARK_ = function cljs$core$reduced_QMARK_(r) {
  return r instanceof cljs.core.Reduced;
};
cljs.core.ensure_reduced = function cljs$core$ensure_reduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return x;
  } else {
    return cljs.core.reduced(x);
  }
};
cljs.core.unreduced = function cljs$core$unreduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    var G__7320 = x;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__7320) : cljs.core.deref.call(null, G__7320);
  } else {
    return x;
  }
};
cljs.core.deref = function cljs$core$deref(o) {
  return cljs.core._deref(o);
};
cljs.core.ci_reduce = function cljs$core$ci_reduce() {
  var G__7322 = arguments.length;
  switch(G__7322) {
    case 2:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = function(cicoll, f) {
  var cnt = cljs.core._count(cicoll);
  if (cnt === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, 0);
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__7323 = val;
          var G__7324 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7323, G__7324) : f.call(null, G__7323, G__7324);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__7330 = nval;
          var G__7331 = n + 1;
          val = G__7330;
          n = G__7331;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = function(cicoll, f, val) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__7325 = val__$1;
        var G__7326 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7325, G__7326) : f.call(null, G__7325, G__7326);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__7332 = nval;
        var G__7333 = n + 1;
        val__$1 = G__7332;
        n = G__7333;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = function(cicoll, f, val, idx) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__7327 = val__$1;
        var G__7328 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7327, G__7328) : f.call(null, G__7327, G__7328);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__7334 = nval;
        var G__7335 = n + 1;
        val__$1 = G__7334;
        n = G__7335;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = function cljs$core$array_reduce() {
  var G__7337 = arguments.length;
  switch(G__7337) {
    case 2:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = function(arr, f) {
  var cnt = arr.length;
  if (arr.length === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = arr[0];
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__7338 = val;
          var G__7339 = arr[n];
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7338, G__7339) : f.call(null, G__7338, G__7339);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__7345 = nval;
          var G__7346 = n + 1;
          val = G__7345;
          n = G__7346;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = function(arr, f, val) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__7340 = val__$1;
        var G__7341 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7340, G__7341) : f.call(null, G__7340, G__7341);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__7347 = nval;
        var G__7348 = n + 1;
        val__$1 = G__7347;
        n = G__7348;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = function(arr, f, val, idx) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__7342 = val__$1;
        var G__7343 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7342, G__7343) : f.call(null, G__7342, G__7343);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__7349 = nval;
        var G__7350 = n + 1;
        val__$1 = G__7349;
        n = G__7350;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.counted_QMARK_ = function cljs$core$counted_QMARK_(x) {
  var G__7352 = x;
  if (G__7352) {
    var bit__4983__auto__ = G__7352.cljs$lang$protocol_mask$partition0$ & 2;
    if (bit__4983__auto__ || G__7352.cljs$core$ICounted$) {
      return true;
    } else {
      if (!G__7352.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, G__7352);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, G__7352);
  }
};
cljs.core.indexed_QMARK_ = function cljs$core$indexed_QMARK_(x) {
  var G__7354 = x;
  if (G__7354) {
    var bit__4983__auto__ = G__7354.cljs$lang$protocol_mask$partition0$ & 16;
    if (bit__4983__auto__ || G__7354.cljs$core$IIndexed$) {
      return true;
    } else {
      if (!G__7354.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, G__7354);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, G__7354);
  }
};
cljs.core.IndexedSeqIterator = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.IndexedSeqIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.IndexedSeqIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.IndexedSeqIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.IndexedSeqIterator.cljs$lang$type = true;
cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/IndexedSeqIterator");
};
cljs.core.__GT_IndexedSeqIterator = function cljs$core$__GT_IndexedSeqIterator(arr, i) {
  return new cljs.core.IndexedSeqIterator(arr, i);
};
cljs.core.IndexedSeq = function(arr, i) {
  this.arr = arr;
  this.i = i;
  this.cljs$lang$protocol_mask$partition0$ = 166199550;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.IndexedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return not_found;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeqIterator(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  var x__4621__auto__ = 0;
  var y__4622__auto__ = self__.arr.length - self__.i;
  return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var c = cljs.core._count(coll__$1);
  if (c > 0) {
    return new cljs.core.RSeq(coll__$1, c - 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  var G__7355 = coll__$1;
  var G__7356 = other;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__7355, G__7356) : cljs.core.equiv_sequential.call(null, G__7355, G__7356);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.i], self__.i + 1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr[self__.i];
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.i < self__.arr.length) {
    return this$__$1;
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__7357 = o;
  var G__7358 = coll__$1;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__7357, G__7358) : cljs.core.cons.call(null, G__7357, G__7358);
};
cljs.core.IndexedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";
cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/IndexedSeq");
};
cljs.core.__GT_IndexedSeq = function cljs$core$__GT_IndexedSeq(arr, i) {
  return new cljs.core.IndexedSeq(arr, i);
};
cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.prim_seq = function cljs$core$prim_seq() {
  var G__7360 = arguments.length;
  switch(G__7360) {
    case 1:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = function(prim) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim, 0);
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = function(prim, i) {
  if (i < prim.length) {
    return new cljs.core.IndexedSeq(prim, i);
  } else {
    return null;
  }
};
cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
cljs.core.array_seq = function cljs$core$array_seq() {
  var G__7363 = arguments.length;
  switch(G__7363) {
    case 1:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = function(array) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, 0);
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, i);
};
cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.RSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.RSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return null;
  }
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.i + 1;
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  var G__7365 = coll__$1;
  var G__7366 = other;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__7365, G__7366) : cljs.core.equiv_sequential.call(null, G__7365, G__7366);
};
cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__7367 = cljs.core.List.EMPTY;
  var G__7368 = self__.meta;
  return cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__7367, G__7368) : cljs.core.with_meta.call(null, G__7367, G__7368);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {
  var self__ = this;
  var col__$1 = this;
  var G__7369 = f;
  var G__7370 = col__$1;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__7369, G__7370) : cljs.core.seq_reduce.call(null, G__7369, G__7370);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {
  var self__ = this;
  var col__$1 = this;
  var G__7371 = f;
  var G__7372 = start;
  var G__7373 = col__$1;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__7371, G__7372, G__7373) : cljs.core.seq_reduce.call(null, G__7371, G__7372, G__7373);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci, self__.i);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__7374 = o;
  var G__7375 = coll__$1;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__7374, G__7375) : cljs.core.cons.call(null, G__7374, G__7375);
};
cljs.core.RSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ci", "ci", 2049808339, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RSeq");
};
cljs.core.__GT_RSeq = function cljs$core$__GT_RSeq(ci, i, meta) {
  return new cljs.core.RSeq(ci, i, meta);
};
cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.second = function cljs$core$second(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.ffirst = function cljs$core$ffirst(coll) {
  return cljs.core.first(cljs.core.first(coll));
};
cljs.core.nfirst = function cljs$core$nfirst(coll) {
  return cljs.core.next(cljs.core.first(coll));
};
cljs.core.fnext = function cljs$core$fnext(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.nnext = function cljs$core$nnext(coll) {
  return cljs.core.next(cljs.core.next(coll));
};
cljs.core.last = function cljs$core$last(s) {
  while (true) {
    var sn = cljs.core.next(s);
    if (!(sn == null)) {
      var G__7376 = sn;
      s = G__7376;
      continue;
    } else {
      return cljs.core.first(s);
    }
    break;
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o;
};
cljs.core.conj = function cljs$core$conj() {
  var G__7381 = arguments.length;
  switch(G__7381) {
    case 0:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  if (!(coll == null)) {
    return cljs.core._conj(coll, x);
  } else {
    return cljs.core._conj(cljs.core.List.EMPTY, x);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = function(coll, x, xs) {
  while (true) {
    if (cljs.core.truth_(xs)) {
      var G__7383 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
      var G__7384 = cljs.core.first(xs);
      var G__7385 = cljs.core.next(xs);
      coll = G__7383;
      x = G__7384;
      xs = G__7385;
      continue;
    } else {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
    }
    break;
  }
};
cljs.core.conj.cljs$lang$applyTo = function(seq7377) {
  var G__7378 = cljs.core.first(seq7377);
  var seq7377__$1 = cljs.core.next(seq7377);
  var G__7379 = cljs.core.first(seq7377__$1);
  var seq7377__$2 = cljs.core.next(seq7377__$1);
  return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__7378, G__7379, seq7377__$2);
};
cljs.core.conj.cljs$lang$maxFixedArity = 2;
cljs.core.empty = function cljs$core$empty(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._empty(coll);
  }
};
cljs.core.accumulating_seq_count = function cljs$core$accumulating_seq_count(coll) {
  var s = cljs.core.seq(coll);
  var acc = 0;
  while (true) {
    if (cljs.core.counted_QMARK_(s)) {
      return acc + cljs.core._count(s);
    } else {
      var G__7386 = cljs.core.next(s);
      var G__7387 = acc + 1;
      s = G__7386;
      acc = G__7387;
      continue;
    }
    break;
  }
};
cljs.core.count = function cljs$core$count(coll) {
  if (!(coll == null)) {
    if (function() {
      var G__7389 = coll;
      if (G__7389) {
        var bit__4976__auto__ = G__7389.cljs$lang$protocol_mask$partition0$ & 2;
        if (bit__4976__auto__ || G__7389.cljs$core$ICounted$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ICounted$_count$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return coll.length;
      } else {
        if (typeof coll === "string") {
          return coll.length;
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, coll)) {
            return cljs.core._count(coll);
          } else {
            return cljs.core.accumulating_seq_count(coll);
          }
        }
      }
    }
  } else {
    return 0;
  }
};
cljs.core.linear_traversal_nth = function cljs$core$linear_traversal_nth() {
  var G__7391 = arguments.length;
  switch(G__7391) {
    case 2:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  while (true) {
    if (coll == null) {
      throw new Error("Index out of bounds");
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          throw new Error("Index out of bounds");
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
        } else {
          if (cljs.core.seq(coll)) {
            var G__7393 = cljs.core.next(coll);
            var G__7394 = n - 1;
            coll = G__7393;
            n = G__7394;
            continue;
          } else {
            throw new Error("Index out of bounds");
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  while (true) {
    if (coll == null) {
      return not_found;
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          return not_found;
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
        } else {
          if (cljs.core.seq(coll)) {
            var G__7395 = cljs.core.next(coll);
            var G__7396 = n - 1;
            var G__7397 = not_found;
            coll = G__7395;
            n = G__7396;
            not_found = G__7397;
            continue;
          } else {
            return not_found;
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
cljs.core.nth = function cljs$core$nth() {
  var G__7399 = arguments.length;
  switch(G__7399) {
    case 2:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number");
  } else {
    if (coll == null) {
      return coll;
    } else {
      if (function() {
        var G__7400 = coll;
        if (G__7400) {
          var bit__4976__auto__ = G__7400.cljs$lang$protocol_mask$partition0$ & 16;
          if (bit__4976__auto__ || G__7400.cljs$core$IIndexed$) {
            return true;
          } else {
            return false;
          }
        } else {
          return false;
        }
      }()) {
        return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return null;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll[n];
            } else {
              return null;
            }
          } else {
            if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
              return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (function() {
                var G__7401 = coll;
                if (G__7401) {
                  var bit__4983__auto__ = G__7401.cljs$lang$protocol_mask$partition0$ & 64;
                  if (bit__4983__auto__ || G__7401.cljs$core$ISeq$) {
                    return true;
                  } else {
                    if (!G__7401.cljs$lang$protocol_mask$partition0$) {
                      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__7401);
                    } else {
                      return false;
                    }
                  }
                } else {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__7401);
                }
              }()) {
                return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number.");
  } else {
    if (coll == null) {
      return not_found;
    } else {
      if (function() {
        var G__7402 = coll;
        if (G__7402) {
          var bit__4976__auto__ = G__7402.cljs$lang$protocol_mask$partition0$ & 16;
          if (bit__4976__auto__ || G__7402.cljs$core$IIndexed$) {
            return true;
          } else {
            return false;
          }
        } else {
          return false;
        }
      }()) {
        return coll.cljs$core$IIndexed$_nth$arity$3(null, n, not_found);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return not_found;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll[n];
            } else {
              return not_found;
            }
          } else {
            if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
              return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (function() {
                var G__7403 = coll;
                if (G__7403) {
                  var bit__4983__auto__ = G__7403.cljs$lang$protocol_mask$partition0$ & 64;
                  if (bit__4983__auto__ || G__7403.cljs$core$ISeq$) {
                    return true;
                  } else {
                    if (!G__7403.cljs$lang$protocol_mask$partition0$) {
                      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__7403);
                    } else {
                      return false;
                    }
                  }
                } else {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__7403);
                }
              }()) {
                return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$lang$maxFixedArity = 3;
cljs.core.nthrest = function cljs$core$nthrest(coll, n) {
  var n__$1 = n;
  var xs = coll;
  while (true) {
    if (n__$1 > 0 && cljs.core.seq(xs)) {
      var G__7405 = n__$1 - 1;
      var G__7406 = cljs.core.rest(xs);
      n__$1 = G__7405;
      xs = G__7406;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.get = function cljs$core$get() {
  var G__7408 = arguments.length;
  switch(G__7408) {
    case 2:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (o == null) {
    return null;
  } else {
    if (function() {
      var G__7409 = o;
      if (G__7409) {
        var bit__4976__auto__ = G__7409.cljs$lang$protocol_mask$partition0$ & 256;
        if (bit__4976__auto__ || G__7409.cljs$core$ILookup$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(null, k);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k | 0];
        } else {
          return null;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k | 0];
          } else {
            return null;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o, k);
          } else {
            return null;
          }
        }
      }
    }
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null)) {
    if (function() {
      var G__7410 = o;
      if (G__7410) {
        var bit__4976__auto__ = G__7410.cljs$lang$protocol_mask$partition0$ & 256;
        if (bit__4976__auto__ || G__7410.cljs$core$ILookup$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k];
        } else {
          return not_found;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k];
          } else {
            return not_found;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o, k, not_found);
          } else {
            return not_found;
          }
        }
      }
    }
  } else {
    return not_found;
  }
};
cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.assoc = function cljs$core$assoc() {
  var G__7417 = arguments.length;
  switch(G__7417) {
    case 3:
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = function(coll, k, v) {
  if (!(coll == null)) {
    return cljs.core._assoc(coll, k, v);
  } else {
    return cljs.core.PersistentHashMap.fromArrays([k], [v]);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, v, kvs) {
  while (true) {
    var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll, k, v);
    if (cljs.core.truth_(kvs)) {
      var G__7419 = ret;
      var G__7420 = cljs.core.first(kvs);
      var G__7421 = cljs.core.second(kvs);
      var G__7422 = cljs.core.nnext(kvs);
      coll = G__7419;
      k = G__7420;
      v = G__7421;
      kvs = G__7422;
      continue;
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.assoc.cljs$lang$applyTo = function(seq7412) {
  var G__7413 = cljs.core.first(seq7412);
  var seq7412__$1 = cljs.core.next(seq7412);
  var G__7414 = cljs.core.first(seq7412__$1);
  var seq7412__$2 = cljs.core.next(seq7412__$1);
  var G__7415 = cljs.core.first(seq7412__$2);
  var seq7412__$3 = cljs.core.next(seq7412__$2);
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__7413, G__7414, G__7415, seq7412__$3);
};
cljs.core.assoc.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc = function cljs$core$dissoc() {
  var G__7427 = arguments.length;
  switch(G__7427) {
    case 1:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._dissoc(coll, k);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__7429 = ret;
        var G__7430 = cljs.core.first(ks);
        var G__7431 = cljs.core.next(ks);
        coll = G__7429;
        k = G__7430;
        ks = G__7431;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.dissoc.cljs$lang$applyTo = function(seq7423) {
  var G__7424 = cljs.core.first(seq7423);
  var seq7423__$1 = cljs.core.next(seq7423);
  var G__7425 = cljs.core.first(seq7423__$1);
  var seq7423__$2 = cljs.core.next(seq7423__$1);
  return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__7424, G__7425, seq7423__$2);
};
cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
cljs.core.fn_QMARK_ = function cljs$core$fn_QMARK_(f) {
  var or__4309__auto__ = function() {
    var G__7436 = f;
    return goog.isFunction(G__7436);
  }();
  if (cljs.core.truth_(or__4309__auto__)) {
    return or__4309__auto__;
  } else {
    var G__7437 = f;
    if (G__7437) {
      var bit__4983__auto__ = null;
      if (cljs.core.truth_(function() {
        var or__4309__auto____$1 = bit__4983__auto__;
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          return G__7437.cljs$core$Fn$;
        }
      }())) {
        return true;
      } else {
        if (!G__7437.cljs$lang$protocol_mask$partition$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, G__7437);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, G__7437);
    }
  }
};
cljs.core.MetaFn = function(afn, meta) {
  this.afn = afn;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 393217;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.MetaFn(self__.afn, new_meta);
};
cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;
cljs.core.MetaFn.prototype.call = function() {
  var G__7903 = null;
  var G__7903__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
  };
  var G__7903__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7439 = a;
    return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__7439) : self__.afn.call(null, G__7439);
  };
  var G__7903__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7440 = a;
    var G__7441 = b;
    return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__7440, G__7441) : self__.afn.call(null, G__7440, G__7441);
  };
  var G__7903__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7442 = a;
    var G__7443 = b;
    var G__7444 = c;
    return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__7442, G__7443, G__7444) : self__.afn.call(null, G__7442, G__7443, G__7444);
  };
  var G__7903__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7445 = a;
    var G__7446 = b;
    var G__7447 = c;
    var G__7448 = d;
    return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__7445, G__7446, G__7447, G__7448) : self__.afn.call(null, G__7445, G__7446, G__7447, G__7448);
  };
  var G__7903__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7449 = a;
    var G__7450 = b;
    var G__7451 = c;
    var G__7452 = d;
    var G__7453 = e;
    return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__7449, G__7450, G__7451, G__7452, G__7453) : self__.afn.call(null, G__7449, G__7450, G__7451, G__7452, G__7453);
  };
  var G__7903__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7454 = a;
    var G__7455 = b;
    var G__7456 = c;
    var G__7457 = d;
    var G__7458 = e;
    var G__7459 = f;
    return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__7454, G__7455, G__7456, G__7457, G__7458, G__7459) : self__.afn.call(null, G__7454, G__7455, G__7456, G__7457, G__7458, G__7459);
  };
  var G__7903__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7460 = a;
    var G__7461 = b;
    var G__7462 = c;
    var G__7463 = d;
    var G__7464 = e;
    var G__7465 = f;
    var G__7466 = g;
    return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__7460, G__7461, G__7462, G__7463, G__7464, G__7465, G__7466) : self__.afn.call(null, G__7460, G__7461, G__7462, G__7463, G__7464, G__7465, G__7466);
  };
  var G__7903__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7467 = a;
    var G__7468 = b;
    var G__7469 = c;
    var G__7470 = d;
    var G__7471 = e;
    var G__7472 = f;
    var G__7473 = g;
    var G__7474 = h;
    return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__7467, G__7468, G__7469, G__7470, G__7471, G__7472, G__7473, G__7474) : self__.afn.call(null, G__7467, G__7468, G__7469, G__7470, G__7471, G__7472, G__7473, G__7474);
  };
  var G__7903__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7475 = a;
    var G__7476 = b;
    var G__7477 = c;
    var G__7478 = d;
    var G__7479 = e;
    var G__7480 = f;
    var G__7481 = g;
    var G__7482 = h;
    var G__7483 = i;
    return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__7475, G__7476, G__7477, G__7478, G__7479, G__7480, G__7481, G__7482, G__7483) : self__.afn.call(null, G__7475, G__7476, G__7477, G__7478, G__7479, G__7480, G__7481, G__7482, G__7483);
  };
  var G__7903__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7484 = a;
    var G__7485 = b;
    var G__7486 = c;
    var G__7487 = d;
    var G__7488 = e;
    var G__7489 = f;
    var G__7490 = g;
    var G__7491 = h;
    var G__7492 = i;
    var G__7493 = j;
    return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__7484, G__7485, G__7486, G__7487, G__7488, G__7489, G__7490, G__7491, G__7492, G__7493) : self__.afn.call(null, G__7484, G__7485, G__7486, G__7487, G__7488, G__7489, G__7490, G__7491, G__7492, G__7493);
  };
  var G__7903__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7494 = a;
    var G__7495 = b;
    var G__7496 = c;
    var G__7497 = d;
    var G__7498 = e;
    var G__7499 = f;
    var G__7500 = g;
    var G__7501 = h;
    var G__7502 = i;
    var G__7503 = j;
    var G__7504 = k;
    return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__7494, G__7495, G__7496, G__7497, G__7498, G__7499, G__7500, G__7501, G__7502, G__7503, G__7504) : self__.afn.call(null, G__7494, G__7495, G__7496, G__7497, G__7498, G__7499, G__7500, G__7501, G__7502, G__7503, G__7504);
  };
  var G__7903__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7505 = a;
    var G__7506 = b;
    var G__7507 = c;
    var G__7508 = d;
    var G__7509 = e;
    var G__7510 = f;
    var G__7511 = g;
    var G__7512 = h;
    var G__7513 = i;
    var G__7514 = j;
    var G__7515 = k;
    var G__7516 = l;
    return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__7505, G__7506, G__7507, G__7508, G__7509, G__7510, G__7511, G__7512, G__7513, G__7514, G__7515, G__7516) : self__.afn.call(null, G__7505, G__7506, G__7507, G__7508, G__7509, G__7510, G__7511, G__7512, G__7513, G__7514, G__7515, G__7516);
  };
  var G__7903__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7517 = a;
    var G__7518 = b;
    var G__7519 = c;
    var G__7520 = d;
    var G__7521 = e;
    var G__7522 = f;
    var G__7523 = g;
    var G__7524 = h;
    var G__7525 = i;
    var G__7526 = j;
    var G__7527 = k;
    var G__7528 = l;
    var G__7529 = m;
    return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__7517, G__7518, G__7519, G__7520, G__7521, G__7522, G__7523, G__7524, G__7525, G__7526, G__7527, G__7528, G__7529) : self__.afn.call(null, G__7517, G__7518, G__7519, G__7520, G__7521, G__7522, G__7523, G__7524, G__7525, G__7526, G__7527, G__7528, G__7529);
  };
  var G__7903__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7530 = a;
    var G__7531 = b;
    var G__7532 = c;
    var G__7533 = d;
    var G__7534 = e;
    var G__7535 = f;
    var G__7536 = g;
    var G__7537 = h;
    var G__7538 = i;
    var G__7539 = j;
    var G__7540 = k;
    var G__7541 = l;
    var G__7542 = m;
    var G__7543 = n;
    return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__7530, G__7531, G__7532, G__7533, G__7534, G__7535, G__7536, G__7537, G__7538, G__7539, G__7540, G__7541, G__7542, G__7543) : self__.afn.call(null, G__7530, G__7531, G__7532, G__7533, G__7534, G__7535, G__7536, G__7537, G__7538, G__7539, G__7540, G__7541, G__7542, G__7543);
  };
  var G__7903__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7544 = a;
    var G__7545 = b;
    var G__7546 = c;
    var G__7547 = d;
    var G__7548 = e;
    var G__7549 = f;
    var G__7550 = g;
    var G__7551 = h;
    var G__7552 = i;
    var G__7553 = j;
    var G__7554 = k;
    var G__7555 = l;
    var G__7556 = m;
    var G__7557 = n;
    var G__7558 = o;
    return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__7544, G__7545, G__7546, G__7547, G__7548, G__7549, G__7550, G__7551, G__7552, G__7553, G__7554, G__7555, G__7556, G__7557, G__7558) : self__.afn.call(null, G__7544, G__7545, G__7546, G__7547, G__7548, G__7549, G__7550, G__7551, G__7552, G__7553, G__7554, G__7555, G__7556, G__7557, G__7558);
  };
  var G__7903__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7559 = a;
    var G__7560 = b;
    var G__7561 = c;
    var G__7562 = d;
    var G__7563 = e;
    var G__7564 = f;
    var G__7565 = g;
    var G__7566 = h;
    var G__7567 = i;
    var G__7568 = j;
    var G__7569 = k;
    var G__7570 = l;
    var G__7571 = m;
    var G__7572 = n;
    var G__7573 = o;
    var G__7574 = p;
    return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__7559, G__7560, G__7561, G__7562, G__7563, G__7564, G__7565, G__7566, G__7567, G__7568, G__7569, G__7570, G__7571, G__7572, G__7573, G__7574) : self__.afn.call(null, G__7559, G__7560, G__7561, G__7562, G__7563, G__7564, G__7565, G__7566, G__7567, G__7568, G__7569, G__7570, G__7571, G__7572, G__7573, G__7574);
  };
  var G__7903__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7575 = a;
    var G__7576 = b;
    var G__7577 = c;
    var G__7578 = d;
    var G__7579 = e;
    var G__7580 = f;
    var G__7581 = g;
    var G__7582 = h;
    var G__7583 = i;
    var G__7584 = j;
    var G__7585 = k;
    var G__7586 = l;
    var G__7587 = m;
    var G__7588 = n;
    var G__7589 = o;
    var G__7590 = p;
    var G__7591 = q;
    return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__7575, G__7576, G__7577, G__7578, G__7579, G__7580, G__7581, G__7582, G__7583, G__7584, G__7585, G__7586, G__7587, G__7588, G__7589, G__7590, G__7591) : self__.afn.call(null, G__7575, G__7576, G__7577, G__7578, G__7579, G__7580, G__7581, G__7582, G__7583, G__7584, G__7585, G__7586, G__7587, G__7588, G__7589, G__7590, G__7591);
  };
  var G__7903__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7592 = a;
    var G__7593 = b;
    var G__7594 = c;
    var G__7595 = d;
    var G__7596 = e;
    var G__7597 = f;
    var G__7598 = g;
    var G__7599 = h;
    var G__7600 = i;
    var G__7601 = j;
    var G__7602 = k;
    var G__7603 = l;
    var G__7604 = m;
    var G__7605 = n;
    var G__7606 = o;
    var G__7607 = p;
    var G__7608 = q;
    var G__7609 = r;
    return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__7592, G__7593, G__7594, G__7595, G__7596, G__7597, G__7598, G__7599, G__7600, G__7601, G__7602, G__7603, G__7604, G__7605, G__7606, G__7607, G__7608, G__7609) : self__.afn.call(null, G__7592, G__7593, G__7594, G__7595, G__7596, G__7597, G__7598, G__7599, G__7600, G__7601, G__7602, G__7603, G__7604, G__7605, G__7606, G__7607, G__7608, G__7609);
  };
  var G__7903__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7610 = a;
    var G__7611 = b;
    var G__7612 = c;
    var G__7613 = d;
    var G__7614 = e;
    var G__7615 = f;
    var G__7616 = g;
    var G__7617 = h;
    var G__7618 = i;
    var G__7619 = j;
    var G__7620 = k;
    var G__7621 = l;
    var G__7622 = m;
    var G__7623 = n;
    var G__7624 = o;
    var G__7625 = p;
    var G__7626 = q;
    var G__7627 = r;
    var G__7628 = s;
    return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__7610, G__7611, G__7612, G__7613, G__7614, G__7615, G__7616, G__7617, G__7618, G__7619, G__7620, G__7621, G__7622, G__7623, G__7624, G__7625, G__7626, G__7627, G__7628) : self__.afn.call(null, G__7610, G__7611, G__7612, G__7613, G__7614, G__7615, G__7616, G__7617, G__7618, G__7619, G__7620, G__7621, G__7622, G__7623, G__7624, G__7625, G__7626, G__7627, G__7628);
  };
  var G__7903__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7629 = a;
    var G__7630 = b;
    var G__7631 = c;
    var G__7632 = d;
    var G__7633 = e;
    var G__7634 = f;
    var G__7635 = g;
    var G__7636 = h;
    var G__7637 = i;
    var G__7638 = j;
    var G__7639 = k;
    var G__7640 = l;
    var G__7641 = m;
    var G__7642 = n;
    var G__7643 = o;
    var G__7644 = p;
    var G__7645 = q;
    var G__7646 = r;
    var G__7647 = s;
    var G__7648 = t;
    return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__7629, G__7630, G__7631, G__7632, G__7633, G__7634, G__7635, G__7636, G__7637, G__7638, G__7639, G__7640, G__7641, G__7642, G__7643, G__7644, G__7645, G__7646, G__7647, G__7648) : self__.afn.call(null, G__7629, G__7630, G__7631, G__7632, G__7633, G__7634, G__7635, G__7636, G__7637, G__7638, G__7639, G__7640, G__7641, G__7642, G__7643, G__7644, G__7645, G__7646, G__7647, G__7648);
  };
  var G__7903__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__7649 = self__.afn;
    var G__7650 = a;
    var G__7651 = b;
    var G__7652 = c;
    var G__7653 = d;
    var G__7654 = e;
    var G__7655 = f;
    var G__7656 = g;
    var G__7657 = h;
    var G__7658 = i;
    var G__7659 = j;
    var G__7660 = k;
    var G__7661 = l;
    var G__7662 = m;
    var G__7663 = n;
    var G__7664 = o;
    var G__7665 = p;
    var G__7666 = q;
    var G__7667 = r;
    var G__7668 = s;
    var G__7669 = t;
    var G__7670 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7649, G__7650, G__7651, G__7652, G__7653, G__7654, G__7655, G__7656, G__7657, G__7658, G__7659, G__7660, G__7661, G__7662, G__7663, G__7664, G__7665, G__7666, G__7667, G__7668, G__7669, G__7670) : cljs.core.apply.call(null, G__7649, G__7650, G__7651, G__7652, G__7653, G__7654, G__7655, G__7656, G__7657, G__7658, G__7659, G__7660, G__7661, G__7662, G__7663, G__7664, G__7665, G__7666, G__7667, 
    G__7668, G__7669, G__7670);
  };
  G__7903 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__7903__1.call(this, self__);
      case 2:
        return G__7903__2.call(this, self__, a);
      case 3:
        return G__7903__3.call(this, self__, a, b);
      case 4:
        return G__7903__4.call(this, self__, a, b, c);
      case 5:
        return G__7903__5.call(this, self__, a, b, c, d);
      case 6:
        return G__7903__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__7903__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__7903__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__7903__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__7903__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__7903__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__7903__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__7903__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__7903__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__7903__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__7903__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__7903__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__7903__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__7903__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__7903__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__7903__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__7903__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__7903.cljs$core$IFn$_invoke$arity$1 = G__7903__1;
  G__7903.cljs$core$IFn$_invoke$arity$2 = G__7903__2;
  G__7903.cljs$core$IFn$_invoke$arity$3 = G__7903__3;
  G__7903.cljs$core$IFn$_invoke$arity$4 = G__7903__4;
  G__7903.cljs$core$IFn$_invoke$arity$5 = G__7903__5;
  G__7903.cljs$core$IFn$_invoke$arity$6 = G__7903__6;
  G__7903.cljs$core$IFn$_invoke$arity$7 = G__7903__7;
  G__7903.cljs$core$IFn$_invoke$arity$8 = G__7903__8;
  G__7903.cljs$core$IFn$_invoke$arity$9 = G__7903__9;
  G__7903.cljs$core$IFn$_invoke$arity$10 = G__7903__10;
  G__7903.cljs$core$IFn$_invoke$arity$11 = G__7903__11;
  G__7903.cljs$core$IFn$_invoke$arity$12 = G__7903__12;
  G__7903.cljs$core$IFn$_invoke$arity$13 = G__7903__13;
  G__7903.cljs$core$IFn$_invoke$arity$14 = G__7903__14;
  G__7903.cljs$core$IFn$_invoke$arity$15 = G__7903__15;
  G__7903.cljs$core$IFn$_invoke$arity$16 = G__7903__16;
  G__7903.cljs$core$IFn$_invoke$arity$17 = G__7903__17;
  G__7903.cljs$core$IFn$_invoke$arity$18 = G__7903__18;
  G__7903.cljs$core$IFn$_invoke$arity$19 = G__7903__19;
  G__7903.cljs$core$IFn$_invoke$arity$20 = G__7903__20;
  G__7903.cljs$core$IFn$_invoke$arity$21 = G__7903__21;
  G__7903.cljs$core$IFn$_invoke$arity$22 = G__7903__22;
  return G__7903;
}();
cljs.core.MetaFn.prototype.apply = function(self__, args7438) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args7438)));
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  var G__7671 = a;
  return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__7671) : self__.afn.call(null, G__7671);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  var G__7672 = a;
  var G__7673 = b;
  return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__7672, G__7673) : self__.afn.call(null, G__7672, G__7673);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  var G__7674 = a;
  var G__7675 = b;
  var G__7676 = c;
  return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__7674, G__7675, G__7676) : self__.afn.call(null, G__7674, G__7675, G__7676);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  var G__7677 = a;
  var G__7678 = b;
  var G__7679 = c;
  var G__7680 = d;
  return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__7677, G__7678, G__7679, G__7680) : self__.afn.call(null, G__7677, G__7678, G__7679, G__7680);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  var G__7681 = a;
  var G__7682 = b;
  var G__7683 = c;
  var G__7684 = d;
  var G__7685 = e;
  return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__7681, G__7682, G__7683, G__7684, G__7685) : self__.afn.call(null, G__7681, G__7682, G__7683, G__7684, G__7685);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  var G__7686 = a;
  var G__7687 = b;
  var G__7688 = c;
  var G__7689 = d;
  var G__7690 = e;
  var G__7691 = f;
  return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__7686, G__7687, G__7688, G__7689, G__7690, G__7691) : self__.afn.call(null, G__7686, G__7687, G__7688, G__7689, G__7690, G__7691);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  var G__7692 = a;
  var G__7693 = b;
  var G__7694 = c;
  var G__7695 = d;
  var G__7696 = e;
  var G__7697 = f;
  var G__7698 = g;
  return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__7692, G__7693, G__7694, G__7695, G__7696, G__7697, G__7698) : self__.afn.call(null, G__7692, G__7693, G__7694, G__7695, G__7696, G__7697, G__7698);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  var G__7699 = a;
  var G__7700 = b;
  var G__7701 = c;
  var G__7702 = d;
  var G__7703 = e;
  var G__7704 = f;
  var G__7705 = g;
  var G__7706 = h;
  return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__7699, G__7700, G__7701, G__7702, G__7703, G__7704, G__7705, G__7706) : self__.afn.call(null, G__7699, G__7700, G__7701, G__7702, G__7703, G__7704, G__7705, G__7706);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  var G__7707 = a;
  var G__7708 = b;
  var G__7709 = c;
  var G__7710 = d;
  var G__7711 = e;
  var G__7712 = f;
  var G__7713 = g;
  var G__7714 = h;
  var G__7715 = i;
  return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__7707, G__7708, G__7709, G__7710, G__7711, G__7712, G__7713, G__7714, G__7715) : self__.afn.call(null, G__7707, G__7708, G__7709, G__7710, G__7711, G__7712, G__7713, G__7714, G__7715);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  var G__7716 = a;
  var G__7717 = b;
  var G__7718 = c;
  var G__7719 = d;
  var G__7720 = e;
  var G__7721 = f;
  var G__7722 = g;
  var G__7723 = h;
  var G__7724 = i;
  var G__7725 = j;
  return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__7716, G__7717, G__7718, G__7719, G__7720, G__7721, G__7722, G__7723, G__7724, G__7725) : self__.afn.call(null, G__7716, G__7717, G__7718, G__7719, G__7720, G__7721, G__7722, G__7723, G__7724, G__7725);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  var G__7726 = a;
  var G__7727 = b;
  var G__7728 = c;
  var G__7729 = d;
  var G__7730 = e;
  var G__7731 = f;
  var G__7732 = g;
  var G__7733 = h;
  var G__7734 = i;
  var G__7735 = j;
  var G__7736 = k;
  return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__7726, G__7727, G__7728, G__7729, G__7730, G__7731, G__7732, G__7733, G__7734, G__7735, G__7736) : self__.afn.call(null, G__7726, G__7727, G__7728, G__7729, G__7730, G__7731, G__7732, G__7733, G__7734, G__7735, G__7736);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  var G__7737 = a;
  var G__7738 = b;
  var G__7739 = c;
  var G__7740 = d;
  var G__7741 = e;
  var G__7742 = f;
  var G__7743 = g;
  var G__7744 = h;
  var G__7745 = i;
  var G__7746 = j;
  var G__7747 = k;
  var G__7748 = l;
  return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__7737, G__7738, G__7739, G__7740, G__7741, G__7742, G__7743, G__7744, G__7745, G__7746, G__7747, G__7748) : self__.afn.call(null, G__7737, G__7738, G__7739, G__7740, G__7741, G__7742, G__7743, G__7744, G__7745, G__7746, G__7747, G__7748);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  var G__7749 = a;
  var G__7750 = b;
  var G__7751 = c;
  var G__7752 = d;
  var G__7753 = e;
  var G__7754 = f;
  var G__7755 = g;
  var G__7756 = h;
  var G__7757 = i;
  var G__7758 = j;
  var G__7759 = k;
  var G__7760 = l;
  var G__7761 = m;
  return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__7749, G__7750, G__7751, G__7752, G__7753, G__7754, G__7755, G__7756, G__7757, G__7758, G__7759, G__7760, G__7761) : self__.afn.call(null, G__7749, G__7750, G__7751, G__7752, G__7753, G__7754, G__7755, G__7756, G__7757, G__7758, G__7759, G__7760, G__7761);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  var G__7762 = a;
  var G__7763 = b;
  var G__7764 = c;
  var G__7765 = d;
  var G__7766 = e;
  var G__7767 = f;
  var G__7768 = g;
  var G__7769 = h;
  var G__7770 = i;
  var G__7771 = j;
  var G__7772 = k;
  var G__7773 = l;
  var G__7774 = m;
  var G__7775 = n;
  return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__7762, G__7763, G__7764, G__7765, G__7766, G__7767, G__7768, G__7769, G__7770, G__7771, G__7772, G__7773, G__7774, G__7775) : self__.afn.call(null, G__7762, G__7763, G__7764, G__7765, G__7766, G__7767, G__7768, G__7769, G__7770, G__7771, G__7772, G__7773, G__7774, G__7775);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  var G__7776 = a;
  var G__7777 = b;
  var G__7778 = c;
  var G__7779 = d;
  var G__7780 = e;
  var G__7781 = f;
  var G__7782 = g;
  var G__7783 = h;
  var G__7784 = i;
  var G__7785 = j;
  var G__7786 = k;
  var G__7787 = l;
  var G__7788 = m;
  var G__7789 = n;
  var G__7790 = o;
  return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__7776, G__7777, G__7778, G__7779, G__7780, G__7781, G__7782, G__7783, G__7784, G__7785, G__7786, G__7787, G__7788, G__7789, G__7790) : self__.afn.call(null, G__7776, G__7777, G__7778, G__7779, G__7780, G__7781, G__7782, G__7783, G__7784, G__7785, G__7786, G__7787, G__7788, G__7789, G__7790);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  var G__7791 = a;
  var G__7792 = b;
  var G__7793 = c;
  var G__7794 = d;
  var G__7795 = e;
  var G__7796 = f;
  var G__7797 = g;
  var G__7798 = h;
  var G__7799 = i;
  var G__7800 = j;
  var G__7801 = k;
  var G__7802 = l;
  var G__7803 = m;
  var G__7804 = n;
  var G__7805 = o;
  var G__7806 = p;
  return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__7791, G__7792, G__7793, G__7794, G__7795, G__7796, G__7797, G__7798, G__7799, G__7800, G__7801, G__7802, G__7803, G__7804, G__7805, G__7806) : self__.afn.call(null, G__7791, G__7792, G__7793, G__7794, G__7795, G__7796, G__7797, G__7798, G__7799, G__7800, G__7801, G__7802, G__7803, G__7804, G__7805, G__7806);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  var G__7807 = a;
  var G__7808 = b;
  var G__7809 = c;
  var G__7810 = d;
  var G__7811 = e;
  var G__7812 = f;
  var G__7813 = g;
  var G__7814 = h;
  var G__7815 = i;
  var G__7816 = j;
  var G__7817 = k;
  var G__7818 = l;
  var G__7819 = m;
  var G__7820 = n;
  var G__7821 = o;
  var G__7822 = p;
  var G__7823 = q;
  return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__7807, G__7808, G__7809, G__7810, G__7811, G__7812, G__7813, G__7814, G__7815, G__7816, G__7817, G__7818, G__7819, G__7820, G__7821, G__7822, G__7823) : self__.afn.call(null, G__7807, G__7808, G__7809, G__7810, G__7811, G__7812, G__7813, G__7814, G__7815, G__7816, G__7817, G__7818, G__7819, G__7820, G__7821, G__7822, G__7823);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  var G__7824 = a;
  var G__7825 = b;
  var G__7826 = c;
  var G__7827 = d;
  var G__7828 = e;
  var G__7829 = f;
  var G__7830 = g;
  var G__7831 = h;
  var G__7832 = i;
  var G__7833 = j;
  var G__7834 = k;
  var G__7835 = l;
  var G__7836 = m;
  var G__7837 = n;
  var G__7838 = o;
  var G__7839 = p;
  var G__7840 = q;
  var G__7841 = r;
  return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__7824, G__7825, G__7826, G__7827, G__7828, G__7829, G__7830, G__7831, G__7832, G__7833, G__7834, G__7835, G__7836, G__7837, G__7838, G__7839, G__7840, G__7841) : self__.afn.call(null, G__7824, G__7825, G__7826, G__7827, G__7828, G__7829, G__7830, G__7831, G__7832, G__7833, G__7834, G__7835, G__7836, G__7837, G__7838, G__7839, G__7840, G__7841);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  var G__7842 = a;
  var G__7843 = b;
  var G__7844 = c;
  var G__7845 = d;
  var G__7846 = e;
  var G__7847 = f;
  var G__7848 = g;
  var G__7849 = h;
  var G__7850 = i;
  var G__7851 = j;
  var G__7852 = k;
  var G__7853 = l;
  var G__7854 = m;
  var G__7855 = n;
  var G__7856 = o;
  var G__7857 = p;
  var G__7858 = q;
  var G__7859 = r;
  var G__7860 = s;
  return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__7842, G__7843, G__7844, G__7845, G__7846, G__7847, G__7848, G__7849, G__7850, G__7851, G__7852, G__7853, G__7854, G__7855, G__7856, G__7857, G__7858, G__7859, G__7860) : self__.afn.call(null, G__7842, G__7843, G__7844, G__7845, G__7846, G__7847, G__7848, G__7849, G__7850, G__7851, G__7852, G__7853, G__7854, G__7855, G__7856, G__7857, G__7858, G__7859, G__7860);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  var G__7861 = a;
  var G__7862 = b;
  var G__7863 = c;
  var G__7864 = d;
  var G__7865 = e;
  var G__7866 = f;
  var G__7867 = g;
  var G__7868 = h;
  var G__7869 = i;
  var G__7870 = j;
  var G__7871 = k;
  var G__7872 = l;
  var G__7873 = m;
  var G__7874 = n;
  var G__7875 = o;
  var G__7876 = p;
  var G__7877 = q;
  var G__7878 = r;
  var G__7879 = s;
  var G__7880 = t;
  return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__7861, G__7862, G__7863, G__7864, G__7865, G__7866, G__7867, G__7868, G__7869, G__7870, G__7871, G__7872, G__7873, G__7874, G__7875, G__7876, G__7877, G__7878, G__7879, G__7880) : self__.afn.call(null, G__7861, G__7862, G__7863, G__7864, G__7865, G__7866, G__7867, G__7868, G__7869, G__7870, G__7871, G__7872, G__7873, G__7874, G__7875, G__7876, G__7877, G__7878, G__7879, G__7880);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__7881 = self__.afn;
  var G__7882 = a;
  var G__7883 = b;
  var G__7884 = c;
  var G__7885 = d;
  var G__7886 = e;
  var G__7887 = f;
  var G__7888 = g;
  var G__7889 = h;
  var G__7890 = i;
  var G__7891 = j;
  var G__7892 = k;
  var G__7893 = l;
  var G__7894 = m;
  var G__7895 = n;
  var G__7896 = o;
  var G__7897 = p;
  var G__7898 = q;
  var G__7899 = r;
  var G__7900 = s;
  var G__7901 = t;
  var G__7902 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7881, G__7882, G__7883, G__7884, G__7885, G__7886, G__7887, G__7888, G__7889, G__7890, G__7891, G__7892, G__7893, G__7894, G__7895, G__7896, G__7897, G__7898, G__7899, G__7900, G__7901, G__7902) : cljs.core.apply.call(null, G__7881, G__7882, G__7883, G__7884, G__7885, G__7886, G__7887, G__7888, G__7889, G__7890, G__7891, G__7892, G__7893, G__7894, G__7895, G__7896, G__7897, G__7898, G__7899, 
  G__7900, G__7901, G__7902);
};
cljs.core.MetaFn.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "afn", "afn", 216963467, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.MetaFn.cljs$lang$type = true;
cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";
cljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/MetaFn");
};
cljs.core.__GT_MetaFn = function cljs$core$__GT_MetaFn(afn, meta) {
  return new cljs.core.MetaFn(afn, meta);
};
cljs.core.with_meta = function cljs$core$with_meta(o, meta) {
  if (cljs.core.fn_QMARK_(o) && !function() {
    var G__7907 = o;
    if (G__7907) {
      var bit__4983__auto__ = G__7907.cljs$lang$protocol_mask$partition0$ & 262144;
      if (bit__4983__auto__ || G__7907.cljs$core$IWithMeta$) {
        return true;
      } else {
        if (!G__7907.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta, G__7907);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta, G__7907);
    }
  }()) {
    return new cljs.core.MetaFn(o, meta);
  } else {
    if (o == null) {
      return null;
    } else {
      return cljs.core._with_meta(o, meta);
    }
  }
};
cljs.core.meta = function cljs$core$meta(o) {
  if (function() {
    var and__4297__auto__ = !(o == null);
    if (and__4297__auto__) {
      var G__7911 = o;
      if (G__7911) {
        var bit__4983__auto__ = G__7911.cljs$lang$protocol_mask$partition0$ & 131072;
        if (bit__4983__auto__ || G__7911.cljs$core$IMeta$) {
          return true;
        } else {
          if (!G__7911.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, G__7911);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, G__7911);
      }
    } else {
      return and__4297__auto__;
    }
  }()) {
    return cljs.core._meta(o);
  } else {
    return null;
  }
};
cljs.core.peek = function cljs$core$peek(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._peek(coll);
  }
};
cljs.core.pop = function cljs$core$pop(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._pop(coll);
  }
};
cljs.core.disj = function cljs$core$disj() {
  var G__7916 = arguments.length;
  switch(G__7916) {
    case 1:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._disjoin(coll, k);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__7918 = ret;
        var G__7919 = cljs.core.first(ks);
        var G__7920 = cljs.core.next(ks);
        coll = G__7918;
        k = G__7919;
        ks = G__7920;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.disj.cljs$lang$applyTo = function(seq7912) {
  var G__7913 = cljs.core.first(seq7912);
  var seq7912__$1 = cljs.core.next(seq7912);
  var G__7914 = cljs.core.first(seq7912__$1);
  var seq7912__$2 = cljs.core.next(seq7912__$1);
  return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__7913, G__7914, seq7912__$2);
};
cljs.core.disj.cljs$lang$maxFixedArity = 2;
cljs.core.empty_QMARK_ = function cljs$core$empty_QMARK_(coll) {
  return coll == null || cljs.core.not(cljs.core.seq(coll));
};
cljs.core.coll_QMARK_ = function cljs$core$coll_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__7922 = x;
    if (G__7922) {
      var bit__4983__auto__ = G__7922.cljs$lang$protocol_mask$partition0$ & 8;
      if (bit__4983__auto__ || G__7922.cljs$core$ICollection$) {
        return true;
      } else {
        if (!G__7922.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, G__7922);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, G__7922);
    }
  }
};
cljs.core.set_QMARK_ = function cljs$core$set_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__7924 = x;
    if (G__7924) {
      var bit__4983__auto__ = G__7924.cljs$lang$protocol_mask$partition0$ & 4096;
      if (bit__4983__auto__ || G__7924.cljs$core$ISet$) {
        return true;
      } else {
        if (!G__7924.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, G__7924);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, G__7924);
    }
  }
};
cljs.core.associative_QMARK_ = function cljs$core$associative_QMARK_(x) {
  var G__7926 = x;
  if (G__7926) {
    var bit__4983__auto__ = G__7926.cljs$lang$protocol_mask$partition0$ & 512;
    if (bit__4983__auto__ || G__7926.cljs$core$IAssociative$) {
      return true;
    } else {
      if (!G__7926.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, G__7926);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, G__7926);
  }
};
cljs.core.sequential_QMARK_ = function cljs$core$sequential_QMARK_(x) {
  var G__7928 = x;
  if (G__7928) {
    var bit__4983__auto__ = G__7928.cljs$lang$protocol_mask$partition0$ & 16777216;
    if (bit__4983__auto__ || G__7928.cljs$core$ISequential$) {
      return true;
    } else {
      if (!G__7928.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, G__7928);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, G__7928);
  }
};
cljs.core.sorted_QMARK_ = function cljs$core$sorted_QMARK_(x) {
  var G__7930 = x;
  if (G__7930) {
    var bit__4983__auto__ = G__7930.cljs$lang$protocol_mask$partition0$ & 268435456;
    if (bit__4983__auto__ || G__7930.cljs$core$ISorted$) {
      return true;
    } else {
      if (!G__7930.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, G__7930);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, G__7930);
  }
};
cljs.core.reduceable_QMARK_ = function cljs$core$reduceable_QMARK_(x) {
  var G__7932 = x;
  if (G__7932) {
    var bit__4983__auto__ = G__7932.cljs$lang$protocol_mask$partition0$ & 524288;
    if (bit__4983__auto__ || G__7932.cljs$core$IReduce$) {
      return true;
    } else {
      if (!G__7932.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, G__7932);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, G__7932);
  }
};
cljs.core.map_QMARK_ = function cljs$core$map_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__7934 = x;
    if (G__7934) {
      var bit__4983__auto__ = G__7934.cljs$lang$protocol_mask$partition0$ & 1024;
      if (bit__4983__auto__ || G__7934.cljs$core$IMap$) {
        return true;
      } else {
        if (!G__7934.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, G__7934);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, G__7934);
    }
  }
};
cljs.core.record_QMARK_ = function cljs$core$record_QMARK_(x) {
  var G__7936 = x;
  if (G__7936) {
    var bit__4983__auto__ = G__7936.cljs$lang$protocol_mask$partition0$ & 67108864;
    if (bit__4983__auto__ || G__7936.cljs$core$IRecord$) {
      return true;
    } else {
      if (!G__7936.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, G__7936);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, G__7936);
  }
};
cljs.core.vector_QMARK_ = function cljs$core$vector_QMARK_(x) {
  var G__7938 = x;
  if (G__7938) {
    var bit__4983__auto__ = G__7938.cljs$lang$protocol_mask$partition0$ & 16384;
    if (bit__4983__auto__ || G__7938.cljs$core$IVector$) {
      return true;
    } else {
      if (!G__7938.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, G__7938);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, G__7938);
  }
};
cljs.core.chunked_seq_QMARK_ = function cljs$core$chunked_seq_QMARK_(x) {
  var G__7940 = x;
  if (G__7940) {
    var bit__4976__auto__ = G__7940.cljs$lang$protocol_mask$partition1$ & 512;
    if (bit__4976__auto__ || G__7940.cljs$core$IChunkedSeq$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.js_obj = function cljs$core$js_obj() {
  var G__7943 = arguments.length;
  switch(G__7943) {
    case 0:
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0);
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__5360__auto__);
  }
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = function() {
  var obj7945 = {};
  return obj7945;
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var G__7946 = goog.object.create;
  var G__7947 = keyvals;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__7946, G__7947) : cljs.core.apply.call(null, G__7946, G__7947);
};
cljs.core.js_obj.cljs$lang$applyTo = function(seq7941) {
  return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7941));
};
cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
cljs.core.js_keys = function cljs$core$js_keys(obj) {
  var keys = [];
  var G__7951_7953 = obj;
  var G__7952_7954 = function(G__7951_7953, keys) {
    return function(val, key, obj__$1) {
      return keys.push(key);
    };
  }(G__7951_7953, keys);
  goog.object.forEach(G__7951_7953, G__7952_7954);
  return keys;
};
cljs.core.js_delete = function cljs$core$js_delete(obj, key) {
  return delete obj[key];
};
cljs.core.array_copy = function cljs$core$array_copy(from, i, to, j, len) {
  var i__$1 = i;
  var j__$1 = j;
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__7955 = i__$1 + 1;
      var G__7956 = j__$1 + 1;
      var G__7957 = len__$1 - 1;
      i__$1 = G__7955;
      j__$1 = G__7956;
      len__$1 = G__7957;
      continue;
    }
    break;
  }
};
cljs.core.array_copy_downward = function cljs$core$array_copy_downward(from, i, to, j, len) {
  var i__$1 = i + (len - 1);
  var j__$1 = j + (len - 1);
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__7958 = i__$1 - 1;
      var G__7959 = j__$1 - 1;
      var G__7960 = len__$1 - 1;
      i__$1 = G__7958;
      j__$1 = G__7959;
      len__$1 = G__7960;
      continue;
    }
    break;
  }
};
cljs.core.lookup_sentinel = function() {
  var obj7962 = {};
  return obj7962;
}();
cljs.core.false_QMARK_ = function cljs$core$false_QMARK_(x) {
  return x === false;
};
cljs.core.true_QMARK_ = function cljs$core$true_QMARK_(x) {
  return x === true;
};
cljs.core.undefined_QMARK_ = function cljs$core$undefined_QMARK_(x) {
  return void 0 === x;
};
cljs.core.seq_QMARK_ = function cljs$core$seq_QMARK_(s) {
  if (s == null) {
    return false;
  } else {
    var G__7964 = s;
    if (G__7964) {
      var bit__4983__auto__ = G__7964.cljs$lang$protocol_mask$partition0$ & 64;
      if (bit__4983__auto__ || G__7964.cljs$core$ISeq$) {
        return true;
      } else {
        if (!G__7964.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__7964);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__7964);
    }
  }
};
cljs.core.seqable_QMARK_ = function cljs$core$seqable_QMARK_(s) {
  var G__7966 = s;
  if (G__7966) {
    var bit__4983__auto__ = G__7966.cljs$lang$protocol_mask$partition0$ & 8388608;
    if (bit__4983__auto__ || G__7966.cljs$core$ISeqable$) {
      return true;
    } else {
      if (!G__7966.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, G__7966);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, G__7966);
  }
};
cljs.core.boolean$ = function cljs$core$boolean(x) {
  if (cljs.core.truth_(x)) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ifn_QMARK_ = function cljs$core$ifn_QMARK_(f) {
  var or__4309__auto__ = cljs.core.fn_QMARK_(f);
  if (or__4309__auto__) {
    return or__4309__auto__;
  } else {
    var G__7970 = f;
    if (G__7970) {
      var bit__4983__auto__ = G__7970.cljs$lang$protocol_mask$partition0$ & 1;
      if (bit__4983__auto__ || G__7970.cljs$core$IFn$) {
        return true;
      } else {
        if (!G__7970.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, G__7970);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, G__7970);
    }
  }
};
cljs.core.integer_QMARK_ = function cljs$core$integer_QMARK_(n) {
  return typeof n === "number" && cljs.core.not(function() {
    var G__7983 = n;
    return isNaN(G__7983);
  }()) && !(n === Infinity) && function() {
    var G__7984 = n;
    return parseFloat(G__7984);
  }() === function() {
    var G__7985 = n;
    var G__7986 = 10;
    return parseInt(G__7985, G__7986);
  }();
};
cljs.core.contains_QMARK_ = function cljs$core$contains_QMARK_(coll, v) {
  if (cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false;
  } else {
    return true;
  }
};
cljs.core.find = function cljs$core$find(coll, k) {
  if (!(coll == null) && cljs.core.associative_QMARK_(coll) && cljs.core.contains_QMARK_(coll, k)) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, k)], null);
  } else {
    return null;
  }
};
cljs.core.distinct_QMARK_ = function cljs$core$distinct_QMARK_() {
  var G__7991 = arguments.length;
  switch(G__7991) {
    case 1:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  if (!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
    var s = cljs.core.PersistentHashSet.fromArray([x, y], true);
    var xs = more;
    while (true) {
      var x__$1 = cljs.core.first(xs);
      var etc = cljs.core.next(xs);
      if (cljs.core.truth_(xs)) {
        if (cljs.core.contains_QMARK_(s, x__$1)) {
          return false;
        } else {
          var G__7993 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s, x__$1);
          var G__7994 = etc;
          s = G__7993;
          xs = G__7994;
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  } else {
    return false;
  }
};
cljs.core.distinct_QMARK_.cljs$lang$applyTo = function(seq7987) {
  var G__7988 = cljs.core.first(seq7987);
  var seq7987__$1 = cljs.core.next(seq7987);
  var G__7989 = cljs.core.first(seq7987__$1);
  var seq7987__$2 = cljs.core.next(seq7987__$1);
  return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__7988, G__7989, seq7987__$2);
};
cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs.core.compare = function cljs$core$compare(x, y) {
  if (x === y) {
    return 0;
  } else {
    if (x == null) {
      return -1;
    } else {
      if (y == null) {
        return 1;
      } else {
        if (typeof x === "number") {
          if (typeof y === "number") {
            var G__8000 = x;
            var G__8001 = y;
            return goog.array.defaultCompare(G__8000, G__8001);
          } else {
            throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
          }
        } else {
          if (function() {
            var G__8002 = x;
            if (G__8002) {
              var bit__4983__auto__ = G__8002.cljs$lang$protocol_mask$partition1$ & 2048;
              if (bit__4983__auto__ || G__8002.cljs$core$IComparable$) {
                return true;
              } else {
                if (!G__8002.cljs$lang$protocol_mask$partition1$) {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, G__8002);
                } else {
                  return false;
                }
              }
            } else {
              return cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, G__8002);
            }
          }()) {
            return cljs.core._compare(x, y);
          } else {
            if ((typeof x === "string" || cljs.core.array_QMARK_(x) || x === true || x === false) && cljs.core.type(x) === cljs.core.type(y)) {
              var G__8003 = x;
              var G__8004 = y;
              return goog.array.defaultCompare(G__8003, G__8004);
            } else {
              throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
            }
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function cljs$core$compare_indexed() {
  var G__8006 = arguments.length;
  switch(G__8006) {
    case 2:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 4:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = function(xs, ys) {
  var xl = cljs.core.count(xs);
  var yl = cljs.core.count(ys);
  if (xl < yl) {
    return -1;
  } else {
    if (xl > yl) {
      return 1;
    } else {
      if (xl === 0) {
        return 0;
      } else {
        return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs, ys, xl, 0);
      }
    }
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = function(xs, ys, len, n) {
  while (true) {
    var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs, n), cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys, n));
    if (d === 0 && n + 1 < len) {
      var G__8008 = xs;
      var G__8009 = ys;
      var G__8010 = len;
      var G__8011 = n + 1;
      xs = G__8008;
      ys = G__8009;
      len = G__8010;
      n = G__8011;
      continue;
    } else {
      return d;
    }
    break;
  }
};
cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
cljs.core.fn__GT_comparator = function cljs$core$fn__GT_comparator(f) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f, cljs.core.compare)) {
    return cljs.core.compare;
  } else {
    return function(x, y) {
      var r = function() {
        var G__8016 = x;
        var G__8017 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8016, G__8017) : f.call(null, G__8016, G__8017);
      }();
      if (typeof r === "number") {
        return r;
      } else {
        if (cljs.core.truth_(r)) {
          return -1;
        } else {
          if (cljs.core.truth_(function() {
            var G__8018 = y;
            var G__8019 = x;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8018, G__8019) : f.call(null, G__8018, G__8019);
          }())) {
            return 1;
          } else {
            return 0;
          }
        }
      }
    };
  }
};
cljs.core.sort = function cljs$core$sort() {
  var G__8021 = arguments.length;
  switch(G__8021) {
    case 1:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare, coll);
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = function(comp, coll) {
  if (cljs.core.seq(coll)) {
    var a = function() {
      var G__8022 = coll;
      return cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__8022) : cljs.core.to_array.call(null, G__8022);
    }();
    var G__8023_8026 = a;
    var G__8024_8027 = cljs.core.fn__GT_comparator(comp);
    goog.array.stableSort(G__8023_8026, G__8024_8027);
    return cljs.core.seq(a);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sort.cljs$lang$maxFixedArity = 2;
cljs.core.sort_by = function cljs$core$sort_by() {
  var G__8029 = arguments.length;
  switch(G__8029) {
    case 2:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = function(keyfn, coll) {
  return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn, cljs.core.compare, coll);
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = function(keyfn, comp, coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x, y) {
    return cljs.core.fn__GT_comparator(comp).call(null, function() {
      var G__8030 = x;
      return keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__8030) : keyfn.call(null, G__8030);
    }(), function() {
      var G__8031 = y;
      return keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__8031) : keyfn.call(null, G__8031);
    }());
  }, coll);
};
cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = function cljs$core$seq_reduce() {
  var G__8034 = arguments.length;
  switch(G__8034) {
    case 2:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var temp__4423__auto__ = cljs.core.seq(coll);
  if (temp__4423__auto__) {
    var s = temp__4423__auto__;
    var G__8035 = f;
    var G__8036 = cljs.core.first(s);
    var G__8037 = cljs.core.next(s);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__8035, G__8036, G__8037) : cljs.core.reduce.call(null, G__8035, G__8036, G__8037);
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  var val__$1 = val;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (coll__$1) {
      var nval = function() {
        var G__8038 = val__$1;
        var G__8039 = cljs.core.first(coll__$1);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8038, G__8039) : f.call(null, G__8038, G__8039);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__8041 = nval;
        var G__8042 = cljs.core.next(coll__$1);
        val__$1 = G__8041;
        coll__$1 = G__8042;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.shuffle = function cljs$core$shuffle(coll) {
  var a = function() {
    var G__8046 = coll;
    return cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__8046) : cljs.core.to_array.call(null, G__8046);
  }();
  var G__8047_8049 = a;
  goog.array.shuffle(G__8047_8049);
  var G__8048 = a;
  return cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__8048) : cljs.core.vec.call(null, G__8048);
};
cljs.core.reduce = function cljs$core$reduce() {
  var G__8051 = arguments.length;
  switch(G__8051) {
    case 2:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  if (function() {
    var G__8052 = coll;
    if (G__8052) {
      var bit__4976__auto__ = G__8052.cljs$lang$protocol_mask$partition0$ & 524288;
      if (bit__4976__auto__ || G__8052.cljs$core$IReduce$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  if (function() {
    var G__8053 = coll;
    if (G__8053) {
      var bit__4976__auto__ = G__8053.cljs$lang$protocol_mask$partition0$ & 524288;
      if (bit__4976__auto__ || G__8053.cljs$core$IReduce$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$3(null, f, val);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, val, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce_kv = function cljs$core$reduce_kv(f, init, coll) {
  if (!(coll == null)) {
    return cljs.core._kv_reduce(coll, f, init);
  } else {
    return init;
  }
};
cljs.core.identity = function cljs$core$identity(x) {
  return x;
};
cljs.core.completing = function cljs$core$completing() {
  var G__8056 = arguments.length;
  switch(G__8056) {
    case 1:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f, cljs.core.identity);
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = function(f, cf) {
  return function() {
    var G__8061 = null;
    var G__8061__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    };
    var G__8061__1 = function(x) {
      var G__8057 = x;
      return cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__8057) : cf.call(null, G__8057);
    };
    var G__8061__2 = function(x, y) {
      var G__8058 = x;
      var G__8059 = y;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8058, G__8059) : f.call(null, G__8058, G__8059);
    };
    G__8061 = function(x, y) {
      switch(arguments.length) {
        case 0:
          return G__8061__0.call(this);
        case 1:
          return G__8061__1.call(this, x);
        case 2:
          return G__8061__2.call(this, x, y);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__8061.cljs$core$IFn$_invoke$arity$0 = G__8061__0;
    G__8061.cljs$core$IFn$_invoke$arity$1 = G__8061__1;
    G__8061.cljs$core$IFn$_invoke$arity$2 = G__8061__2;
    return G__8061;
  }();
};
cljs.core.completing.cljs$lang$maxFixedArity = 2;
cljs.core.transduce = function cljs$core$transduce() {
  var G__8063 = arguments.length;
  switch(G__8063) {
    case 3:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = function(xform, f, coll) {
  return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, f, function() {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }(), coll);
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = function(xform, f, init, coll) {
  var f__$1 = function() {
    var G__8064 = f;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8064) : xform.call(null, G__8064);
  }();
  var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1, init, coll);
  var G__8065 = ret;
  return f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__8065) : f__$1.call(null, G__8065);
};
cljs.core.transduce.cljs$lang$maxFixedArity = 4;
cljs.core._PLUS_ = function cljs$core$_PLUS_() {
  var G__8071 = arguments.length;
  switch(G__8071) {
    case 0:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_, x + y, more);
};
cljs.core._PLUS_.cljs$lang$applyTo = function(seq8067) {
  var G__8068 = cljs.core.first(seq8067);
  var seq8067__$1 = cljs.core.next(seq8067);
  var G__8069 = cljs.core.first(seq8067__$1);
  var seq8067__$2 = cljs.core.next(seq8067__$1);
  return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__8068, G__8069, seq8067__$2);
};
cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
cljs.core._ = function cljs$core$_() {
  var G__8077 = arguments.length;
  switch(G__8077) {
    case 1:
      return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core._.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._, x - y, more);
};
cljs.core._.cljs$lang$applyTo = function(seq8073) {
  var G__8074 = cljs.core.first(seq8073);
  var seq8073__$1 = cljs.core.next(seq8073);
  var G__8075 = cljs.core.first(seq8073__$1);
  var seq8073__$2 = cljs.core.next(seq8073__$1);
  return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__8074, G__8075, seq8073__$2);
};
cljs.core._.cljs$lang$maxFixedArity = 2;
cljs.core._STAR_ = function cljs$core$_STAR_() {
  var G__8083 = arguments.length;
  switch(G__8083) {
    case 0:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_, x * y, more);
};
cljs.core._STAR_.cljs$lang$applyTo = function(seq8079) {
  var G__8080 = cljs.core.first(seq8079);
  var seq8079__$1 = cljs.core.next(seq8079);
  var G__8081 = cljs.core.first(seq8079__$1);
  var seq8079__$2 = cljs.core.next(seq8079__$1);
  return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__8080, G__8081, seq8079__$2);
};
cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
cljs.core._SLASH_ = function cljs$core$_SLASH_() {
  var G__8089 = arguments.length;
  switch(G__8089) {
    case 1:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_, x / y, more);
};
cljs.core._SLASH_.cljs$lang$applyTo = function(seq8085) {
  var G__8086 = cljs.core.first(seq8085);
  var seq8085__$1 = cljs.core.next(seq8085);
  var G__8087 = cljs.core.first(seq8085__$1);
  var seq8085__$2 = cljs.core.next(seq8085__$1);
  return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__8086, G__8087, seq8085__$2);
};
cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
cljs.core._LT_ = function cljs$core$_LT_() {
  var G__8095 = arguments.length;
  switch(G__8095) {
    case 1:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x < y;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x < y) {
      if (cljs.core.next(more)) {
        var G__8097 = y;
        var G__8098 = cljs.core.first(more);
        var G__8099 = cljs.core.next(more);
        x = G__8097;
        y = G__8098;
        more = G__8099;
        continue;
      } else {
        return y < cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT_.cljs$lang$applyTo = function(seq8091) {
  var G__8092 = cljs.core.first(seq8091);
  var seq8091__$1 = cljs.core.next(seq8091);
  var G__8093 = cljs.core.first(seq8091__$1);
  var seq8091__$2 = cljs.core.next(seq8091__$1);
  return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__8092, G__8093, seq8091__$2);
};
cljs.core._LT_.cljs$lang$maxFixedArity = 2;
cljs.core._LT__EQ_ = function cljs$core$_LT__EQ_() {
  var G__8104 = arguments.length;
  switch(G__8104) {
    case 1:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x <= y;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x <= y) {
      if (cljs.core.next(more)) {
        var G__8106 = y;
        var G__8107 = cljs.core.first(more);
        var G__8108 = cljs.core.next(more);
        x = G__8106;
        y = G__8107;
        more = G__8108;
        continue;
      } else {
        return y <= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT__EQ_.cljs$lang$applyTo = function(seq8100) {
  var G__8101 = cljs.core.first(seq8100);
  var seq8100__$1 = cljs.core.next(seq8100);
  var G__8102 = cljs.core.first(seq8100__$1);
  var seq8100__$2 = cljs.core.next(seq8100__$1);
  return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__8101, G__8102, seq8100__$2);
};
cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core._GT_ = function cljs$core$_GT_() {
  var G__8113 = arguments.length;
  switch(G__8113) {
    case 1:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x > y;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x > y) {
      if (cljs.core.next(more)) {
        var G__8115 = y;
        var G__8116 = cljs.core.first(more);
        var G__8117 = cljs.core.next(more);
        x = G__8115;
        y = G__8116;
        more = G__8117;
        continue;
      } else {
        return y > cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT_.cljs$lang$applyTo = function(seq8109) {
  var G__8110 = cljs.core.first(seq8109);
  var seq8109__$1 = cljs.core.next(seq8109);
  var G__8111 = cljs.core.first(seq8109__$1);
  var seq8109__$2 = cljs.core.next(seq8109__$1);
  return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__8110, G__8111, seq8109__$2);
};
cljs.core._GT_.cljs$lang$maxFixedArity = 2;
cljs.core._GT__EQ_ = function cljs$core$_GT__EQ_() {
  var G__8122 = arguments.length;
  switch(G__8122) {
    case 1:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x >= y;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x >= y) {
      if (cljs.core.next(more)) {
        var G__8124 = y;
        var G__8125 = cljs.core.first(more);
        var G__8126 = cljs.core.next(more);
        x = G__8124;
        y = G__8125;
        more = G__8126;
        continue;
      } else {
        return y >= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT__EQ_.cljs$lang$applyTo = function(seq8118) {
  var G__8119 = cljs.core.first(seq8118);
  var seq8118__$1 = cljs.core.next(seq8118);
  var G__8120 = cljs.core.first(seq8118__$1);
  var seq8118__$2 = cljs.core.next(seq8118__$1);
  return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__8119, G__8120, seq8118__$2);
};
cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.dec = function cljs$core$dec(x) {
  return x - 1;
};
cljs.core.max = function cljs$core$max() {
  var G__8131 = arguments.length;
  switch(G__8131) {
    case 1:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.max.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4621__auto__ = x;
  var y__4622__auto__ = y;
  return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max, function() {
    var x__4621__auto__ = x;
    var y__4622__auto__ = y;
    return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
  }(), more);
};
cljs.core.max.cljs$lang$applyTo = function(seq8127) {
  var G__8128 = cljs.core.first(seq8127);
  var seq8127__$1 = cljs.core.next(seq8127);
  var G__8129 = cljs.core.first(seq8127__$1);
  var seq8127__$2 = cljs.core.next(seq8127__$1);
  return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__8128, G__8129, seq8127__$2);
};
cljs.core.max.cljs$lang$maxFixedArity = 2;
cljs.core.min = function cljs$core$min() {
  var G__8137 = arguments.length;
  switch(G__8137) {
    case 1:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.min.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4628__auto__ = x;
  var y__4629__auto__ = y;
  return x__4628__auto__ < y__4629__auto__ ? x__4628__auto__ : y__4629__auto__;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min, function() {
    var x__4628__auto__ = x;
    var y__4629__auto__ = y;
    return x__4628__auto__ < y__4629__auto__ ? x__4628__auto__ : y__4629__auto__;
  }(), more);
};
cljs.core.min.cljs$lang$applyTo = function(seq8133) {
  var G__8134 = cljs.core.first(seq8133);
  var seq8133__$1 = cljs.core.next(seq8133);
  var G__8135 = cljs.core.first(seq8133__$1);
  var seq8133__$2 = cljs.core.next(seq8133__$1);
  return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__8134, G__8135, seq8133__$2);
};
cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = function cljs$core$byte(x) {
  return x;
};
cljs.core.char$ = function cljs$core$char(x) {
  if (typeof x === "number") {
    return String.fromCharCode(x);
  } else {
    if (typeof x === "string" && x.length === 1) {
      return x;
    } else {
      throw new Error("Argument to char must be a character or number");
    }
  }
};
cljs.core.short$ = function cljs$core$short(x) {
  return x;
};
cljs.core.float$ = function cljs$core$float(x) {
  return x;
};
cljs.core.double$ = function cljs$core$double(x) {
  return x;
};
cljs.core.unchecked_byte = function cljs$core$unchecked_byte(x) {
  return x;
};
cljs.core.unchecked_char = function cljs$core$unchecked_char(x) {
  return x;
};
cljs.core.unchecked_short = function cljs$core$unchecked_short(x) {
  return x;
};
cljs.core.unchecked_float = function cljs$core$unchecked_float(x) {
  return x;
};
cljs.core.unchecked_double = function cljs$core$unchecked_double(x) {
  return x;
};
cljs.core.unchecked_add = function cljs$core$unchecked_add() {
  var G__8143 = arguments.length;
  switch(G__8143) {
    case 0:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add, x + y, more);
};
cljs.core.unchecked_add.cljs$lang$applyTo = function(seq8139) {
  var G__8140 = cljs.core.first(seq8139);
  var seq8139__$1 = cljs.core.next(seq8139);
  var G__8141 = cljs.core.first(seq8139__$1);
  var seq8139__$2 = cljs.core.next(seq8139__$1);
  return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__8140, G__8141, seq8139__$2);
};
cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_add_int = function cljs$core$unchecked_add_int() {
  var G__8149 = arguments.length;
  switch(G__8149) {
    case 0:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int, x + y, more);
};
cljs.core.unchecked_add_int.cljs$lang$applyTo = function(seq8145) {
  var G__8146 = cljs.core.first(seq8145);
  var seq8145__$1 = cljs.core.next(seq8145);
  var G__8147 = cljs.core.first(seq8145__$1);
  var seq8145__$2 = cljs.core.next(seq8145__$1);
  return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__8146, G__8147, seq8145__$2);
};
cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_dec = function cljs$core$unchecked_dec(x) {
  return x - 1;
};
cljs.core.unchecked_dec_int = function cljs$core$unchecked_dec_int(x) {
  return x - 1;
};
cljs.core.unchecked_divide_int = function cljs$core$unchecked_divide_int() {
  var G__8155 = arguments.length;
  switch(G__8155) {
    case 1:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int, x / y, more);
};
cljs.core.unchecked_divide_int.cljs$lang$applyTo = function(seq8151) {
  var G__8152 = cljs.core.first(seq8151);
  var seq8151__$1 = cljs.core.next(seq8151);
  var G__8153 = cljs.core.first(seq8151__$1);
  var seq8151__$2 = cljs.core.next(seq8151__$1);
  return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__8152, G__8153, seq8151__$2);
};
cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = function cljs$core$unchecked_inc(x) {
  return x + 1;
};
cljs.core.unchecked_inc_int = function cljs$core$unchecked_inc_int(x) {
  return x + 1;
};
cljs.core.unchecked_multiply = function cljs$core$unchecked_multiply() {
  var G__8161 = arguments.length;
  switch(G__8161) {
    case 0:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply, x * y, more);
};
cljs.core.unchecked_multiply.cljs$lang$applyTo = function(seq8157) {
  var G__8158 = cljs.core.first(seq8157);
  var seq8157__$1 = cljs.core.next(seq8157);
  var G__8159 = cljs.core.first(seq8157__$1);
  var seq8157__$2 = cljs.core.next(seq8157__$1);
  return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__8158, G__8159, seq8157__$2);
};
cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_multiply_int = function cljs$core$unchecked_multiply_int() {
  var G__8167 = arguments.length;
  switch(G__8167) {
    case 0:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int, x * y, more);
};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = function(seq8163) {
  var G__8164 = cljs.core.first(seq8163);
  var seq8163__$1 = cljs.core.next(seq8163);
  var G__8165 = cljs.core.first(seq8163__$1);
  var seq8163__$2 = cljs.core.next(seq8163__$1);
  return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__8164, G__8165, seq8163__$2);
};
cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = function cljs$core$unchecked_negate(x) {
  return -x;
};
cljs.core.unchecked_negate_int = function cljs$core$unchecked_negate_int(x) {
  return -x;
};
cljs.core.unchecked_remainder_int = function cljs$core$unchecked_remainder_int(x, n) {
  var G__8171 = x;
  var G__8172 = n;
  return cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__8171, G__8172) : cljs.core.mod.call(null, G__8171, G__8172);
};
cljs.core.unchecked_subtract = function cljs$core$unchecked_subtract() {
  var G__8177 = arguments.length;
  switch(G__8177) {
    case 1:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract, x - y, more);
};
cljs.core.unchecked_subtract.cljs$lang$applyTo = function(seq8173) {
  var G__8174 = cljs.core.first(seq8173);
  var seq8173__$1 = cljs.core.next(seq8173);
  var G__8175 = cljs.core.first(seq8173__$1);
  var seq8173__$2 = cljs.core.next(seq8173__$1);
  return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__8174, G__8175, seq8173__$2);
};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_subtract_int = function cljs$core$unchecked_subtract_int() {
  var G__8183 = arguments.length;
  switch(G__8183) {
    case 1:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int, x - y, more);
};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = function(seq8179) {
  var G__8180 = cljs.core.first(seq8179);
  var seq8179__$1 = cljs.core.next(seq8179);
  var G__8181 = cljs.core.first(seq8179__$1);
  var seq8179__$2 = cljs.core.next(seq8179__$1);
  return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__8180, G__8181, seq8179__$2);
};
cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = function cljs$core$fix(q) {
  if (q >= 0) {
    var G__8187 = q;
    return Math.floor(G__8187);
  } else {
    var G__8188 = q;
    return Math.ceil(G__8188);
  }
};
cljs.core.int$ = function cljs$core$int(x) {
  return x | 0;
};
cljs.core.unchecked_int = function cljs$core$unchecked_int(x) {
  return cljs.core.fix(x);
};
cljs.core.long$ = function cljs$core$long(x) {
  return cljs.core.fix(x);
};
cljs.core.unchecked_long = function cljs$core$unchecked_long(x) {
  return cljs.core.fix(x);
};
cljs.core.booleans = function cljs$core$booleans(x) {
  return x;
};
cljs.core.bytes = function cljs$core$bytes(x) {
  return x;
};
cljs.core.chars = function cljs$core$chars(x) {
  return x;
};
cljs.core.shorts = function cljs$core$shorts(x) {
  return x;
};
cljs.core.ints = function cljs$core$ints(x) {
  return x;
};
cljs.core.floats = function cljs$core$floats(x) {
  return x;
};
cljs.core.doubles = function cljs$core$doubles(x) {
  return x;
};
cljs.core.longs = function cljs$core$longs(x) {
  return x;
};
cljs.core.js_mod = function cljs$core$js_mod(n, d) {
  return n % d;
};
cljs.core.mod = function cljs$core$mod(n, d) {
  return (n % d + d) % d;
};
cljs.core.quot = function cljs$core$quot(n, d) {
  var rem = n % d;
  return cljs.core.fix((n - rem) / d);
};
cljs.core.rem = function cljs$core$rem(n, d) {
  var q = cljs.core.quot(n, d);
  return n - d * q;
};
cljs.core.bit_xor = function cljs$core$bit_xor() {
  var G__8193 = arguments.length;
  switch(G__8193) {
    case 2:
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x ^ y;
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor, x ^ y, more);
};
cljs.core.bit_xor.cljs$lang$applyTo = function(seq8189) {
  var G__8190 = cljs.core.first(seq8189);
  var seq8189__$1 = cljs.core.next(seq8189);
  var G__8191 = cljs.core.first(seq8189__$1);
  var seq8189__$2 = cljs.core.next(seq8189__$1);
  return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__8190, G__8191, seq8189__$2);
};
cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and = function cljs$core$bit_and() {
  var G__8199 = arguments.length;
  switch(G__8199) {
    case 2:
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & y;
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and, x & y, more);
};
cljs.core.bit_and.cljs$lang$applyTo = function(seq8195) {
  var G__8196 = cljs.core.first(seq8195);
  var seq8195__$1 = cljs.core.next(seq8195);
  var G__8197 = cljs.core.first(seq8195__$1);
  var seq8195__$2 = cljs.core.next(seq8195__$1);
  return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__8196, G__8197, seq8195__$2);
};
cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
cljs.core.bit_or = function cljs$core$bit_or() {
  var G__8205 = arguments.length;
  switch(G__8205) {
    case 2:
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x | y;
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or, x | y, more);
};
cljs.core.bit_or.cljs$lang$applyTo = function(seq8201) {
  var G__8202 = cljs.core.first(seq8201);
  var seq8201__$1 = cljs.core.next(seq8201);
  var G__8203 = cljs.core.first(seq8201__$1);
  var seq8201__$2 = cljs.core.next(seq8201__$1);
  return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__8202, G__8203, seq8201__$2);
};
cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and_not = function cljs$core$bit_and_not() {
  var G__8211 = arguments.length;
  switch(G__8211) {
    case 2:
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & ~y;
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not, x & ~y, more);
};
cljs.core.bit_and_not.cljs$lang$applyTo = function(seq8207) {
  var G__8208 = cljs.core.first(seq8207);
  var seq8207__$1 = cljs.core.next(seq8207);
  var G__8209 = cljs.core.first(seq8207__$1);
  var seq8207__$2 = cljs.core.next(seq8207__$1);
  return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__8208, G__8209, seq8207__$2);
};
cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
cljs.core.bit_clear = function cljs$core$bit_clear(x, n) {
  return x & ~(1 << n);
};
cljs.core.bit_flip = function cljs$core$bit_flip(x, n) {
  return x ^ 1 << n;
};
cljs.core.bit_not = function cljs$core$bit_not(x) {
  return ~x;
};
cljs.core.bit_set = function cljs$core$bit_set(x, n) {
  return x | 1 << n;
};
cljs.core.bit_test = function cljs$core$bit_test(x, n) {
  return (x & 1 << n) != 0;
};
cljs.core.bit_shift_left = function cljs$core$bit_shift_left(x, n) {
  return x << n;
};
cljs.core.bit_shift_right = function cljs$core$bit_shift_right(x, n) {
  return x >> n;
};
cljs.core.bit_shift_right_zero_fill = function cljs$core$bit_shift_right_zero_fill(x, n) {
  return x >>> n;
};
cljs.core.unsigned_bit_shift_right = function cljs$core$unsigned_bit_shift_right(x, n) {
  return x >>> n;
};
cljs.core.bit_count = function cljs$core$bit_count(v) {
  var v__$1 = v - (v >> 1 & 1431655765);
  var v__$2 = (v__$1 & 858993459) + (v__$1 >> 2 & 858993459);
  return (v__$2 + (v__$2 >> 4) & 252645135) * 16843009 >> 24;
};
cljs.core._EQ__EQ_ = function cljs$core$_EQ__EQ_() {
  var G__8217 = arguments.length;
  switch(G__8217) {
    case 1:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return cljs.core._equiv(x, y);
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x === y) {
      if (cljs.core.next(more)) {
        var G__8219 = y;
        var G__8220 = cljs.core.first(more);
        var G__8221 = cljs.core.next(more);
        x = G__8219;
        y = G__8220;
        more = G__8221;
        continue;
      } else {
        return y === cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ__EQ_.cljs$lang$applyTo = function(seq8213) {
  var G__8214 = cljs.core.first(seq8213);
  var seq8213__$1 = cljs.core.next(seq8213);
  var G__8215 = cljs.core.first(seq8213__$1);
  var seq8213__$2 = cljs.core.next(seq8213__$1);
  return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__8214, G__8215, seq8213__$2);
};
cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.pos_QMARK_ = function cljs$core$pos_QMARK_(n) {
  return n > 0;
};
cljs.core.zero_QMARK_ = function cljs$core$zero_QMARK_(n) {
  return n === 0;
};
cljs.core.neg_QMARK_ = function cljs$core$neg_QMARK_(x) {
  return x < 0;
};
cljs.core.nthnext = function cljs$core$nthnext(coll, n) {
  var n__$1 = n;
  var xs = cljs.core.seq(coll);
  while (true) {
    if (xs && n__$1 > 0) {
      var G__8222 = n__$1 - 1;
      var G__8223 = cljs.core.next(xs);
      n__$1 = G__8222;
      xs = G__8223;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.str = function cljs$core$str() {
  var G__8227 = arguments.length;
  switch(G__8227) {
    case 0:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5360__auto__);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$0 = function() {
  return "";
};
cljs.core.str.cljs$core$IFn$_invoke$arity$1 = function(x) {
  if (x == null) {
    return "";
  } else {
    var G__8228 = x;
    return goog.string.buildString(G__8228);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = function(x, ys) {
  var sb = new goog.string.StringBuffer([cljs.core.str(x)].join(""));
  var more = ys;
  while (true) {
    if (cljs.core.truth_(more)) {
      var G__8230 = sb.append([cljs.core.str(cljs.core.first(more))].join(""));
      var G__8231 = cljs.core.next(more);
      sb = G__8230;
      more = G__8231;
      continue;
    } else {
      return sb.toString();
    }
    break;
  }
};
cljs.core.str.cljs$lang$applyTo = function(seq8224) {
  var G__8225 = cljs.core.first(seq8224);
  var seq8224__$1 = cljs.core.next(seq8224);
  return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__8225, seq8224__$1);
};
cljs.core.str.cljs$lang$maxFixedArity = 1;
cljs.core.subs = function cljs$core$subs() {
  var G__8233 = arguments.length;
  switch(G__8233) {
    case 2:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = function(s, start) {
  return s.substring(start);
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = function(s, start, end) {
  return s.substring(start, end);
};
cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.equiv_sequential = function cljs$core$equiv_sequential(x, y) {
  return cljs.core.boolean$(cljs.core.sequential_QMARK_(y) ? cljs.core.counted_QMARK_(x) && cljs.core.counted_QMARK_(y) && !(cljs.core.count(x) === cljs.core.count(y)) ? false : function() {
    var xs = cljs.core.seq(x);
    var ys = cljs.core.seq(y);
    while (true) {
      if (xs == null) {
        return ys == null;
      } else {
        if (ys == null) {
          return false;
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs), cljs.core.first(ys))) {
            var G__8235 = cljs.core.next(xs);
            var G__8236 = cljs.core.next(ys);
            xs = G__8235;
            ys = G__8236;
            continue;
          } else {
            return false;
          }
        }
      }
      break;
    }
  }() : null);
};
cljs.core.hash_coll = function cljs$core$hash_coll(coll) {
  if (cljs.core.seq(coll)) {
    var res = cljs.core.hash(cljs.core.first(coll));
    var s = cljs.core.next(coll);
    while (true) {
      if (s == null) {
        return res;
      } else {
        var G__8237 = cljs.core.hash_combine(res, cljs.core.hash(cljs.core.first(s)));
        var G__8238 = cljs.core.next(s);
        res = G__8237;
        s = G__8238;
        continue;
      }
      break;
    }
  } else {
    return 0;
  }
};
cljs.core.hash_imap = function cljs$core$hash_imap(m) {
  var h = 0;
  var s = cljs.core.seq(m);
  while (true) {
    if (s) {
      var e = cljs.core.first(s);
      var G__8243 = (h + (cljs.core.hash(function() {
        var G__8241 = e;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__8241) : cljs.core.key.call(null, G__8241);
      }()) ^ cljs.core.hash(function() {
        var G__8242 = e;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__8242) : cljs.core.val.call(null, G__8242);
      }()))) % 4503599627370496;
      var G__8244 = cljs.core.next(s);
      h = G__8243;
      s = G__8244;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.hash_iset = function cljs$core$hash_iset(s) {
  var h = 0;
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (s__$1) {
      var e = cljs.core.first(s__$1);
      var G__8245 = (h + cljs.core.hash(e)) % 4503599627370496;
      var G__8246 = cljs.core.next(s__$1);
      h = G__8245;
      s__$1 = G__8246;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.extend_object_BANG_ = function cljs$core$extend_object_BANG_(obj, fn_map) {
  var seq__8257_8267 = cljs.core.seq(fn_map);
  var chunk__8258_8268 = null;
  var count__8259_8269 = 0;
  var i__8260_8270 = 0;
  while (true) {
    if (i__8260_8270 < count__8259_8269) {
      var vec__8261_8271 = chunk__8258_8268.cljs$core$IIndexed$_nth$arity$2(null, i__8260_8270);
      var key_name_8272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8261_8271, 0, null);
      var f_8273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8261_8271, 1, null);
      var str_name_8274 = function() {
        var G__8262 = key_name_8272;
        return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__8262) : cljs.core.name.call(null, G__8262);
      }();
      obj[str_name_8274] = f_8273;
      var G__8275 = seq__8257_8267;
      var G__8276 = chunk__8258_8268;
      var G__8277 = count__8259_8269;
      var G__8278 = i__8260_8270 + 1;
      seq__8257_8267 = G__8275;
      chunk__8258_8268 = G__8276;
      count__8259_8269 = G__8277;
      i__8260_8270 = G__8278;
      continue;
    } else {
      var temp__4425__auto___8279 = cljs.core.seq(seq__8257_8267);
      if (temp__4425__auto___8279) {
        var seq__8257_8280__$1 = temp__4425__auto___8279;
        if (cljs.core.chunked_seq_QMARK_(seq__8257_8280__$1)) {
          var c__5094__auto___8281 = function() {
            var G__8263 = seq__8257_8280__$1;
            return cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__8263) : cljs.core.chunk_first.call(null, G__8263);
          }();
          var G__8282 = function() {
            var G__8264 = seq__8257_8280__$1;
            return cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__8264) : cljs.core.chunk_rest.call(null, G__8264);
          }();
          var G__8283 = c__5094__auto___8281;
          var G__8284 = cljs.core.count(c__5094__auto___8281);
          var G__8285 = 0;
          seq__8257_8267 = G__8282;
          chunk__8258_8268 = G__8283;
          count__8259_8269 = G__8284;
          i__8260_8270 = G__8285;
          continue;
        } else {
          var vec__8265_8286 = cljs.core.first(seq__8257_8280__$1);
          var key_name_8287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8265_8286, 0, null);
          var f_8288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8265_8286, 1, null);
          var str_name_8289 = function() {
            var G__8266 = key_name_8287;
            return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__8266) : cljs.core.name.call(null, G__8266);
          }();
          obj[str_name_8289] = f_8288;
          var G__8290 = cljs.core.next(seq__8257_8280__$1);
          var G__8291 = null;
          var G__8292 = 0;
          var G__8293 = 0;
          seq__8257_8267 = G__8290;
          chunk__8258_8268 = G__8291;
          count__8259_8269 = G__8292;
          i__8260_8270 = G__8293;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return obj;
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65937646;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.List.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.List.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return null;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._rest(coll__$1);
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);
};
cljs.core.List.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";
cljs.core.List.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/List");
};
cljs.core.__GT_List = function cljs$core$__GT_List(meta, first, rest, count, __hash) {
  return new cljs.core.List(meta, first, rest, count, __hash);
};
cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 65937614;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.EmptyList.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.EmptyList.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.EmptyList(self__.meta);
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return 0;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.empty_ordered_hash;
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.EmptyList(meta__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, null, 1, null);
};
cljs.core.EmptyList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/EmptyList");
};
cljs.core.__GT_EmptyList = function cljs$core$__GT_EmptyList(meta) {
  return new cljs.core.EmptyList(meta);
};
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.reversible_QMARK_ = function cljs$core$reversible_QMARK_(coll) {
  var G__8295 = coll;
  if (G__8295) {
    var bit__4983__auto__ = G__8295.cljs$lang$protocol_mask$partition0$ & 134217728;
    if (bit__4983__auto__ || G__8295.cljs$core$IReversible$) {
      return true;
    } else {
      if (!G__8295.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, G__8295);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, G__8295);
  }
};
cljs.core.rseq = function cljs$core$rseq(coll) {
  return cljs.core._rseq(coll);
};
cljs.core.reverse = function cljs$core$reverse(coll) {
  if (cljs.core.reversible_QMARK_(coll)) {
    return cljs.core.rseq(coll);
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, coll);
  }
};
cljs.core.list = function cljs$core$list() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = function(xs) {
  var arr = xs instanceof cljs.core.IndexedSeq && xs.i === 0 ? xs.arr : function() {
    var arr = [];
    var xs__$1 = xs;
    while (true) {
      if (!(xs__$1 == null)) {
        arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));
        var G__8297 = xs__$1.cljs$core$INext$_next$arity$1(null);
        xs__$1 = G__8297;
        continue;
      } else {
        return arr;
      }
      break;
    }
  }();
  var i = arr.length;
  var r = cljs.core.List.EMPTY;
  while (true) {
    if (i > 0) {
      var G__8298 = i - 1;
      var G__8299 = r.cljs$core$ICollection$_conj$arity$2(null, arr[i - 1]);
      i = G__8298;
      r = G__8299;
      continue;
    } else {
      return r;
    }
    break;
  }
};
cljs.core.list.cljs$lang$maxFixedArity = 0;
cljs.core.list.cljs$lang$applyTo = function(seq8296) {
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq8296));
};
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65929452;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Cons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core.seq(self__.rest);
  }
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(null, o, coll__$1, self__.__hash);
};
cljs.core.Cons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";
cljs.core.Cons.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Cons");
};
cljs.core.__GT_Cons = function cljs$core$__GT_Cons(meta, first, rest, __hash) {
  return new cljs.core.Cons(meta, first, rest, __hash);
};
cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.cons = function cljs$core$cons(x, coll) {
  if (function() {
    var or__4309__auto__ = coll == null;
    if (or__4309__auto__) {
      return or__4309__auto__;
    } else {
      var G__8303 = coll;
      if (G__8303) {
        var bit__4976__auto__ = G__8303.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4976__auto__ || G__8303.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null);
  } else {
    return new cljs.core.Cons(null, x, cljs.core.seq(coll), null);
  }
};
cljs.core.list_QMARK_ = function cljs$core$list_QMARK_(x) {
  var G__8305 = x;
  if (G__8305) {
    var bit__4983__auto__ = G__8305.cljs$lang$protocol_mask$partition0$ & 33554432;
    if (bit__4983__auto__ || G__8305.cljs$core$IList$) {
      return true;
    } else {
      if (!G__8305.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IList, G__8305);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IList, G__8305);
  }
};
cljs.core.hash_keyword = function cljs$core$hash_keyword(k) {
  return cljs.core.hash_symbol(k) + 2654435769 | 0;
};
cljs.core.compare_keywords = function cljs$core$compare_keywords(a, b) {
  if (a.fqn === b.fqn) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = cljs.core.not(a.ns);
      if (and__4297__auto__) {
        return b.ns;
      } else {
        return and__4297__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__8312 = a.ns;
            var G__8313 = b.ns;
            return goog.array.defaultCompare(G__8312, G__8313);
          }();
          if (0 === nsc) {
            var G__8314 = a.name;
            var G__8315 = b.name;
            return goog.array.defaultCompare(G__8314, G__8315);
          } else {
            return nsc;
          }
        }
      } else {
        var G__8316 = a.name;
        var G__8317 = b.name;
        return goog.array.defaultCompare(G__8316, G__8317);
      }
    }
  }
};
cljs.core.Keyword = function(ns, name, fqn, _hash) {
  this.ns = ns;
  this.name = name;
  this.fqn = fqn;
  this._hash = _hash;
  this.cljs$lang$protocol_mask$partition0$ = 2153775105;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Keyword.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str(":"), cljs.core.str(self__.fqn)].join("");
};
cljs.core.Keyword.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Keyword) {
    return self__.fqn === other.fqn;
  } else {
    return false;
  }
};
cljs.core.Keyword.prototype.call = function() {
  var G__8319 = null;
  var G__8319__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
  };
  var G__8319__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
  };
  G__8319 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8319__2.call(this, self__, coll);
      case 3:
        return G__8319__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__8319.cljs$core$IFn$_invoke$arity$2 = G__8319__2;
  G__8319.cljs$core$IFn$_invoke$arity$3 = G__8319__3;
  return G__8319;
}();
cljs.core.Keyword.prototype.apply = function(self__, args8318) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args8318)));
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var h__4725__auto__ = self__._hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_keyword(this$__$1);
    self__._hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, [cljs.core.str(":"), cljs.core.str(self__.fqn)].join(""));
};
cljs.core.Keyword.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "fqn", "fqn", -1749334463, null), new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null)], null);
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";
cljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Keyword");
};
cljs.core.__GT_Keyword = function cljs$core$__GT_Keyword(ns, name, fqn, _hash) {
  return new cljs.core.Keyword(ns, name, fqn, _hash);
};
cljs.core.keyword_QMARK_ = function cljs$core$keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword;
};
cljs.core.keyword_identical_QMARK_ = function cljs$core$keyword_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Keyword && y instanceof cljs.core.Keyword) {
      return x.fqn === y.fqn;
    } else {
      return false;
    }
  }
};
cljs.core.namespace = function cljs$core$namespace(x) {
  if (function() {
    var G__8321 = x;
    if (G__8321) {
      var bit__4976__auto__ = G__8321.cljs$lang$protocol_mask$partition1$ & 4096;
      if (bit__4976__auto__ || G__8321.cljs$core$INamed$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return x.cljs$core$INamed$_namespace$arity$1(null);
  } else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.keyword = function cljs$core$keyword() {
  var G__8323 = arguments.length;
  switch(G__8323) {
    case 1:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Keyword) {
    return name;
  } else {
    if (name instanceof cljs.core.Symbol) {
      return new cljs.core.Keyword(cljs.core.namespace(name), function() {
        var G__8324 = name;
        return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__8324) : cljs.core.name.call(null, G__8324);
      }(), name.str, null);
    } else {
      if (typeof name === "string") {
        var parts = name.split("/");
        if (parts.length === 2) {
          return new cljs.core.Keyword(parts[0], parts[1], name, null);
        } else {
          return new cljs.core.Keyword(null, parts[0], name, null);
        }
      } else {
        return null;
      }
    }
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  return new cljs.core.Keyword(ns, name, [cljs.core.str(cljs.core.truth_(ns) ? [cljs.core.str(ns), cljs.core.str("/")].join("") : null), cljs.core.str(name)].join(""), null);
};
cljs.core.keyword.cljs$lang$maxFixedArity = 2;
cljs.core.LazySeq = function(meta, fn, s, __hash) {
  this.meta = meta;
  this.fn = fn;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.LazySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.LazySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.LazySeq.prototype.sval = function() {
  var self__ = this;
  var coll = this;
  if (self__.fn == null) {
    return self__.s;
  } else {
    self__.s = function() {
      return self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null);
    }();
    self__.fn = null;
    return self__.s;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.next(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (!(self__.s == null)) {
    return cljs.core.rest(self__.s);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.sval();
  if (self__.s == null) {
    return null;
  } else {
    var ls = self__.s;
    while (true) {
      if (ls instanceof cljs.core.LazySeq) {
        var G__8326 = ls.sval();
        ls = G__8326;
        continue;
      } else {
        self__.s = ls;
        return cljs.core.seq(self__.s);
      }
      break;
    }
  }
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.LazySeq(meta__$1, self__.fn, self__.s, self__.__hash);
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.LazySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "fn", "fn", 465265323, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";
cljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/LazySeq");
};
cljs.core.__GT_LazySeq = function cljs$core$__GT_LazySeq(meta, fn, s, __hash) {
  return new cljs.core.LazySeq(meta, fn, s, __hash);
};
cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 2;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var self__ = this;
  var _ = this;
  self__.buf[self__.end] = o;
  return self__.end = self__.end + 1;
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);
  self__.buf = null;
  return ret;
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end;
};
cljs.core.ChunkBuffer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "buf", "buf", 1426618187, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";
cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ChunkBuffer");
};
cljs.core.__GT_ChunkBuffer = function cljs$core$__GT_ChunkBuffer(buf, end) {
  return new cljs.core.ChunkBuffer(buf, end);
};
cljs.core.chunk_buffer = function cljs$core$chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(new Array(capacity), 0);
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 524306;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end - self__.off;
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var self__ = this;
  var coll__$1 = this;
  return self__.arr[self__.off + i];
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (i >= 0 && i < self__.end - self__.off) {
    return self__.arr[self__.off + i];
  } else {
    return not_found;
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off === self__.end) {
    throw new Error("-drop-first of empty chunk");
  } else {
    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.off], self__.off + 1);
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.off);
};
cljs.core.ArrayChunk.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayChunk");
};
cljs.core.__GT_ArrayChunk = function cljs$core$__GT_ArrayChunk(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk = function cljs$core$array_chunk() {
  var G__8328 = arguments.length;
  switch(G__8328) {
    case 1:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = function(arr) {
  return new cljs.core.ArrayChunk(arr, 0, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = function(arr, off) {
  return new cljs.core.ArrayChunk(arr, off, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = function(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;
cljs.core.ChunkedCons = function(chunk, more, meta, __hash) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850732;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedCons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedCons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    var more__$1 = cljs.core._seq(self__.more);
    if (more__$1 == null) {
      return null;
    } else {
      return more__$1;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk, 0);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    if (self__.more == null) {
      return cljs.core.List.EMPTY;
    } else {
      return self__.more;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.chunk;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1);
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return null;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "chunk", "chunk", 449371907, null), new cljs.core.Symbol(null, "more", "more", -418290273, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";
cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ChunkedCons");
};
cljs.core.__GT_ChunkedCons = function cljs$core$__GT_ChunkedCons(chunk, more, meta, __hash) {
  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);
};
cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.chunk_cons = function cljs$core$chunk_cons(chunk, rest) {
  if (cljs.core._count(chunk) === 0) {
    return rest;
  } else {
    return new cljs.core.ChunkedCons(chunk, rest, null, null);
  }
};
cljs.core.chunk_append = function cljs$core$chunk_append(b, x) {
  return b.add(x);
};
cljs.core.chunk = function cljs$core$chunk(b) {
  return b.chunk();
};
cljs.core.chunk_first = function cljs$core$chunk_first(s) {
  return cljs.core._chunked_first(s);
};
cljs.core.chunk_rest = function cljs$core$chunk_rest(s) {
  return cljs.core._chunked_rest(s);
};
cljs.core.chunk_next = function cljs$core$chunk_next(s) {
  if (function() {
    var G__8331 = s;
    if (G__8331) {
      var bit__4976__auto__ = G__8331.cljs$lang$protocol_mask$partition1$ & 1024;
      if (bit__4976__auto__ || G__8331.cljs$core$IChunkedNext$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return cljs.core._chunked_next(s);
  } else {
    return cljs.core.seq(cljs.core._chunked_rest(s));
  }
};
cljs.core.to_array = function cljs$core$to_array(s) {
  var ary = [];
  var s__$1 = s;
  while (true) {
    if (cljs.core.seq(s__$1)) {
      ary.push(cljs.core.first(s__$1));
      var G__8332 = cljs.core.next(s__$1);
      s__$1 = G__8332;
      continue;
    } else {
      return ary;
    }
    break;
  }
};
cljs.core.to_array_2d = function cljs$core$to_array_2d(coll) {
  var ret = new Array(cljs.core.count(coll));
  var i_8333 = 0;
  var xs_8334 = cljs.core.seq(coll);
  while (true) {
    if (xs_8334) {
      ret[i_8333] = cljs.core.to_array(cljs.core.first(xs_8334));
      var G__8335 = i_8333 + 1;
      var G__8336 = cljs.core.next(xs_8334);
      i_8333 = G__8335;
      xs_8334 = G__8336;
      continue;
    } else {
    }
    break;
  }
  return ret;
};
cljs.core.int_array = function cljs$core$int_array() {
  var G__8338 = arguments.length;
  switch(G__8338) {
    case 1:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__8340 = i + 1;
        var G__8341 = cljs.core.next(s__$1);
        i = G__8340;
        s__$1 = G__8341;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___8342 = size;
    var i_8343 = 0;
    while (true) {
      if (i_8343 < n__5194__auto___8342) {
        a[i_8343] = init_val_or_seq;
        var G__8344 = i_8343 + 1;
        i_8343 = G__8344;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.int_array.cljs$lang$maxFixedArity = 2;
cljs.core.long_array = function cljs$core$long_array() {
  var G__8346 = arguments.length;
  switch(G__8346) {
    case 1:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__8348 = i + 1;
        var G__8349 = cljs.core.next(s__$1);
        i = G__8348;
        s__$1 = G__8349;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___8350 = size;
    var i_8351 = 0;
    while (true) {
      if (i_8351 < n__5194__auto___8350) {
        a[i_8351] = init_val_or_seq;
        var G__8352 = i_8351 + 1;
        i_8351 = G__8352;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.long_array.cljs$lang$maxFixedArity = 2;
cljs.core.double_array = function cljs$core$double_array() {
  var G__8354 = arguments.length;
  switch(G__8354) {
    case 1:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__8356 = i + 1;
        var G__8357 = cljs.core.next(s__$1);
        i = G__8356;
        s__$1 = G__8357;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___8358 = size;
    var i_8359 = 0;
    while (true) {
      if (i_8359 < n__5194__auto___8358) {
        a[i_8359] = init_val_or_seq;
        var G__8360 = i_8359 + 1;
        i_8359 = G__8360;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.double_array.cljs$lang$maxFixedArity = 2;
cljs.core.object_array = function cljs$core$object_array() {
  var G__8362 = arguments.length;
  switch(G__8362) {
    case 1:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__8364 = i + 1;
        var G__8365 = cljs.core.next(s__$1);
        i = G__8364;
        s__$1 = G__8365;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___8366 = size;
    var i_8367 = 0;
    while (true) {
      if (i_8367 < n__5194__auto___8366) {
        a[i_8367] = init_val_or_seq;
        var G__8368 = i_8367 + 1;
        i_8367 = G__8368;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = function cljs$core$bounded_count(s, n) {
  if (cljs.core.counted_QMARK_(s)) {
    return cljs.core.count(s);
  } else {
    var s__$1 = s;
    var i = n;
    var sum = 0;
    while (true) {
      if (i > 0 && cljs.core.seq(s__$1)) {
        var G__8369 = cljs.core.next(s__$1);
        var G__8370 = i - 1;
        var G__8371 = sum + 1;
        s__$1 = G__8369;
        i = G__8370;
        sum = G__8371;
        continue;
      } else {
        return sum;
      }
      break;
    }
  }
};
cljs.core.spread = function cljs$core$spread(arglist) {
  if (arglist == null) {
    return null;
  } else {
    if (cljs.core.next(arglist) == null) {
      return cljs.core.seq(cljs.core.first(arglist));
    } else {
      return cljs.core.cons(cljs.core.first(arglist), cljs$core$spread(cljs.core.next(arglist)));
    }
  }
};
cljs.core.concat = function cljs$core$concat() {
  var G__8377 = arguments.length;
  switch(G__8377) {
    case 0:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = function() {
  return new cljs.core.LazySeq(null, function() {
    return null;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return x;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return new cljs.core.LazySeq(null, function() {
    var s = cljs.core.seq(x);
    if (s) {
      if (cljs.core.chunked_seq_QMARK_(s)) {
        return cljs.core.chunk_cons(cljs.core.chunk_first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s), y));
      } else {
        return cljs.core.cons(cljs.core.first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s), y));
      }
    } else {
      return y;
    }
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = function(x, y, zs) {
  var cat = function cljs$core$cat(xys, zs__$1) {
    return new cljs.core.LazySeq(null, function() {
      var xys__$1 = cljs.core.seq(xys);
      if (xys__$1) {
        if (cljs.core.chunked_seq_QMARK_(xys__$1)) {
          return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1), cljs$core$cat(cljs.core.chunk_rest(xys__$1), zs__$1));
        } else {
          return cljs.core.cons(cljs.core.first(xys__$1), cljs$core$cat(cljs.core.rest(xys__$1), zs__$1));
        }
      } else {
        if (cljs.core.truth_(zs__$1)) {
          return cljs$core$cat(cljs.core.first(zs__$1), cljs.core.next(zs__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x, y), zs);
};
cljs.core.concat.cljs$lang$applyTo = function(seq8373) {
  var G__8374 = cljs.core.first(seq8373);
  var seq8373__$1 = cljs.core.next(seq8373);
  var G__8375 = cljs.core.first(seq8373__$1);
  var seq8373__$2 = cljs.core.next(seq8373__$1);
  return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__8374, G__8375, seq8373__$2);
};
cljs.core.concat.cljs$lang$maxFixedArity = 2;
cljs.core.list_STAR_ = function cljs$core$list_STAR_() {
  var G__8391 = arguments.length;
  switch(G__8391) {
    case 1:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = function(args) {
  return cljs.core.seq(args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = function(a, args) {
  return cljs.core.cons(a, args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = function(a, b, args) {
  return cljs.core.cons(a, cljs.core.cons(b, args));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, args) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, args)));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = function(a, b, c, d, more) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(more)))));
};
cljs.core.list_STAR_.cljs$lang$applyTo = function(seq8385) {
  var G__8386 = cljs.core.first(seq8385);
  var seq8385__$1 = cljs.core.next(seq8385);
  var G__8387 = cljs.core.first(seq8385__$1);
  var seq8385__$2 = cljs.core.next(seq8385__$1);
  var G__8388 = cljs.core.first(seq8385__$2);
  var seq8385__$3 = cljs.core.next(seq8385__$2);
  var G__8389 = cljs.core.first(seq8385__$3);
  var seq8385__$4 = cljs.core.next(seq8385__$3);
  return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__8386, G__8387, G__8388, G__8389, seq8385__$4);
};
cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
cljs.core.transient$ = function cljs$core$transient(coll) {
  return cljs.core._as_transient(coll);
};
cljs.core.persistent_BANG_ = function cljs$core$persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_(tcoll);
};
cljs.core.conj_BANG_ = function cljs$core$conj_BANG_() {
  var G__8397 = arguments.length;
  switch(G__8397) {
    case 0:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._conj_BANG_(tcoll, val);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._conj_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__8399 = ntcoll;
      var G__8400 = cljs.core.first(vals);
      var G__8401 = cljs.core.next(vals);
      tcoll = G__8399;
      val = G__8400;
      vals = G__8401;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.conj_BANG_.cljs$lang$applyTo = function(seq8393) {
  var G__8394 = cljs.core.first(seq8393);
  var seq8393__$1 = cljs.core.next(seq8393);
  var G__8395 = cljs.core.first(seq8393__$1);
  var seq8393__$2 = cljs.core.next(seq8393__$1);
  return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8394, G__8395, seq8393__$2);
};
cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.assoc_BANG_ = function cljs$core$assoc_BANG_() {
  var G__8407 = arguments.length;
  switch(G__8407) {
    case 3:
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = function(tcoll, key, val) {
  return cljs.core._assoc_BANG_(tcoll, key, val);
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, val, kvs) {
  while (true) {
    var ntcoll = cljs.core._assoc_BANG_(tcoll, key, val);
    if (cljs.core.truth_(kvs)) {
      var G__8409 = ntcoll;
      var G__8410 = cljs.core.first(kvs);
      var G__8411 = cljs.core.second(kvs);
      var G__8412 = cljs.core.nnext(kvs);
      tcoll = G__8409;
      key = G__8410;
      val = G__8411;
      kvs = G__8412;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.assoc_BANG_.cljs$lang$applyTo = function(seq8402) {
  var G__8403 = cljs.core.first(seq8402);
  var seq8402__$1 = cljs.core.next(seq8402);
  var G__8404 = cljs.core.first(seq8402__$1);
  var seq8402__$2 = cljs.core.next(seq8402__$1);
  var G__8405 = cljs.core.first(seq8402__$2);
  var seq8402__$3 = cljs.core.next(seq8402__$2);
  return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8403, G__8404, G__8405, seq8402__$3);
};
cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc_BANG_ = function cljs$core$dissoc_BANG_() {
  var G__8417 = arguments.length;
  switch(G__8417) {
    case 2:
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, key) {
  return cljs.core._dissoc_BANG_(tcoll, key);
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, ks) {
  while (true) {
    var ntcoll = cljs.core._dissoc_BANG_(tcoll, key);
    if (cljs.core.truth_(ks)) {
      var G__8419 = ntcoll;
      var G__8420 = cljs.core.first(ks);
      var G__8421 = cljs.core.next(ks);
      tcoll = G__8419;
      key = G__8420;
      ks = G__8421;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.dissoc_BANG_.cljs$lang$applyTo = function(seq8413) {
  var G__8414 = cljs.core.first(seq8413);
  var seq8413__$1 = cljs.core.next(seq8413);
  var G__8415 = cljs.core.first(seq8413__$1);
  var seq8413__$2 = cljs.core.next(seq8413__$1);
  return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8414, G__8415, seq8413__$2);
};
cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.pop_BANG_ = function cljs$core$pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_(tcoll);
};
cljs.core.disj_BANG_ = function cljs$core$disj_BANG_() {
  var G__8426 = arguments.length;
  switch(G__8426) {
    case 2:
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._disjoin_BANG_(tcoll, val);
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._disjoin_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__8428 = ntcoll;
      var G__8429 = cljs.core.first(vals);
      var G__8430 = cljs.core.next(vals);
      tcoll = G__8428;
      val = G__8429;
      vals = G__8430;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.disj_BANG_.cljs$lang$applyTo = function(seq8422) {
  var G__8423 = cljs.core.first(seq8422);
  var seq8422__$1 = cljs.core.next(seq8422);
  var G__8424 = cljs.core.first(seq8422__$1);
  var seq8422__$2 = cljs.core.next(seq8422__$1);
  return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8423, G__8424, seq8422__$2);
};
cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.apply_to = function cljs$core$apply_to(f, argc, args) {
  var args__$1 = cljs.core.seq(args);
  if (argc === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var a5238 = cljs.core._first(args__$1);
    var args__$2 = cljs.core._rest(args__$1);
    if (argc === 1) {
      if (f.cljs$core$IFn$_invoke$arity$1) {
        return f.cljs$core$IFn$_invoke$arity$1(a5238);
      } else {
        var G__8641 = a5238;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8641) : f.call(null, G__8641);
      }
    } else {
      var b5239 = cljs.core._first(args__$2);
      var args__$3 = cljs.core._rest(args__$2);
      if (argc === 2) {
        if (f.cljs$core$IFn$_invoke$arity$2) {
          return f.cljs$core$IFn$_invoke$arity$2(a5238, b5239);
        } else {
          var G__8642 = a5238;
          var G__8643 = b5239;
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8642, G__8643) : f.call(null, G__8642, G__8643);
        }
      } else {
        var c5240 = cljs.core._first(args__$3);
        var args__$4 = cljs.core._rest(args__$3);
        if (argc === 3) {
          if (f.cljs$core$IFn$_invoke$arity$3) {
            return f.cljs$core$IFn$_invoke$arity$3(a5238, b5239, c5240);
          } else {
            var G__8644 = a5238;
            var G__8645 = b5239;
            var G__8646 = c5240;
            return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8644, G__8645, G__8646) : f.call(null, G__8644, G__8645, G__8646);
          }
        } else {
          var d5241 = cljs.core._first(args__$4);
          var args__$5 = cljs.core._rest(args__$4);
          if (argc === 4) {
            if (f.cljs$core$IFn$_invoke$arity$4) {
              return f.cljs$core$IFn$_invoke$arity$4(a5238, b5239, c5240, d5241);
            } else {
              var G__8647 = a5238;
              var G__8648 = b5239;
              var G__8649 = c5240;
              var G__8650 = d5241;
              return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8647, G__8648, G__8649, G__8650) : f.call(null, G__8647, G__8648, G__8649, G__8650);
            }
          } else {
            var e5242 = cljs.core._first(args__$5);
            var args__$6 = cljs.core._rest(args__$5);
            if (argc === 5) {
              if (f.cljs$core$IFn$_invoke$arity$5) {
                return f.cljs$core$IFn$_invoke$arity$5(a5238, b5239, c5240, d5241, e5242);
              } else {
                var G__8651 = a5238;
                var G__8652 = b5239;
                var G__8653 = c5240;
                var G__8654 = d5241;
                var G__8655 = e5242;
                return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8651, G__8652, G__8653, G__8654, G__8655) : f.call(null, G__8651, G__8652, G__8653, G__8654, G__8655);
              }
            } else {
              var f5243 = cljs.core._first(args__$6);
              var args__$7 = cljs.core._rest(args__$6);
              if (argc === 6) {
                if (f.cljs$core$IFn$_invoke$arity$6) {
                  return f.cljs$core$IFn$_invoke$arity$6(a5238, b5239, c5240, d5241, e5242, f5243);
                } else {
                  var G__8656 = a5238;
                  var G__8657 = b5239;
                  var G__8658 = c5240;
                  var G__8659 = d5241;
                  var G__8660 = e5242;
                  var G__8661 = f5243;
                  return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__8656, G__8657, G__8658, G__8659, G__8660, G__8661) : f.call(null, G__8656, G__8657, G__8658, G__8659, G__8660, G__8661);
                }
              } else {
                var g5244 = cljs.core._first(args__$7);
                var args__$8 = cljs.core._rest(args__$7);
                if (argc === 7) {
                  if (f.cljs$core$IFn$_invoke$arity$7) {
                    return f.cljs$core$IFn$_invoke$arity$7(a5238, b5239, c5240, d5241, e5242, f5243, g5244);
                  } else {
                    var G__8662 = a5238;
                    var G__8663 = b5239;
                    var G__8664 = c5240;
                    var G__8665 = d5241;
                    var G__8666 = e5242;
                    var G__8667 = f5243;
                    var G__8668 = g5244;
                    return f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__8662, G__8663, G__8664, G__8665, G__8666, G__8667, G__8668) : f.call(null, G__8662, G__8663, G__8664, G__8665, G__8666, G__8667, G__8668);
                  }
                } else {
                  var h5245 = cljs.core._first(args__$8);
                  var args__$9 = cljs.core._rest(args__$8);
                  if (argc === 8) {
                    if (f.cljs$core$IFn$_invoke$arity$8) {
                      return f.cljs$core$IFn$_invoke$arity$8(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245);
                    } else {
                      var G__8669 = a5238;
                      var G__8670 = b5239;
                      var G__8671 = c5240;
                      var G__8672 = d5241;
                      var G__8673 = e5242;
                      var G__8674 = f5243;
                      var G__8675 = g5244;
                      var G__8676 = h5245;
                      return f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__8669, G__8670, G__8671, G__8672, G__8673, G__8674, G__8675, G__8676) : f.call(null, G__8669, G__8670, G__8671, G__8672, G__8673, G__8674, G__8675, G__8676);
                    }
                  } else {
                    var i5246 = cljs.core._first(args__$9);
                    var args__$10 = cljs.core._rest(args__$9);
                    if (argc === 9) {
                      if (f.cljs$core$IFn$_invoke$arity$9) {
                        return f.cljs$core$IFn$_invoke$arity$9(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246);
                      } else {
                        var G__8677 = a5238;
                        var G__8678 = b5239;
                        var G__8679 = c5240;
                        var G__8680 = d5241;
                        var G__8681 = e5242;
                        var G__8682 = f5243;
                        var G__8683 = g5244;
                        var G__8684 = h5245;
                        var G__8685 = i5246;
                        return f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__8677, G__8678, G__8679, G__8680, G__8681, G__8682, G__8683, G__8684, G__8685) : f.call(null, G__8677, G__8678, G__8679, G__8680, G__8681, G__8682, G__8683, G__8684, G__8685);
                      }
                    } else {
                      var j5247 = cljs.core._first(args__$10);
                      var args__$11 = cljs.core._rest(args__$10);
                      if (argc === 10) {
                        if (f.cljs$core$IFn$_invoke$arity$10) {
                          return f.cljs$core$IFn$_invoke$arity$10(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247);
                        } else {
                          var G__8686 = a5238;
                          var G__8687 = b5239;
                          var G__8688 = c5240;
                          var G__8689 = d5241;
                          var G__8690 = e5242;
                          var G__8691 = f5243;
                          var G__8692 = g5244;
                          var G__8693 = h5245;
                          var G__8694 = i5246;
                          var G__8695 = j5247;
                          return f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__8686, G__8687, G__8688, G__8689, G__8690, G__8691, G__8692, G__8693, G__8694, G__8695) : f.call(null, G__8686, G__8687, G__8688, G__8689, G__8690, G__8691, G__8692, G__8693, G__8694, G__8695);
                        }
                      } else {
                        var k5248 = cljs.core._first(args__$11);
                        var args__$12 = cljs.core._rest(args__$11);
                        if (argc === 11) {
                          if (f.cljs$core$IFn$_invoke$arity$11) {
                            return f.cljs$core$IFn$_invoke$arity$11(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248);
                          } else {
                            var G__8696 = a5238;
                            var G__8697 = b5239;
                            var G__8698 = c5240;
                            var G__8699 = d5241;
                            var G__8700 = e5242;
                            var G__8701 = f5243;
                            var G__8702 = g5244;
                            var G__8703 = h5245;
                            var G__8704 = i5246;
                            var G__8705 = j5247;
                            var G__8706 = k5248;
                            return f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__8696, G__8697, G__8698, G__8699, G__8700, G__8701, G__8702, G__8703, G__8704, G__8705, G__8706) : f.call(null, G__8696, G__8697, G__8698, G__8699, G__8700, G__8701, G__8702, G__8703, G__8704, G__8705, G__8706);
                          }
                        } else {
                          var l5249 = cljs.core._first(args__$12);
                          var args__$13 = cljs.core._rest(args__$12);
                          if (argc === 12) {
                            if (f.cljs$core$IFn$_invoke$arity$12) {
                              return f.cljs$core$IFn$_invoke$arity$12(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249);
                            } else {
                              var G__8707 = a5238;
                              var G__8708 = b5239;
                              var G__8709 = c5240;
                              var G__8710 = d5241;
                              var G__8711 = e5242;
                              var G__8712 = f5243;
                              var G__8713 = g5244;
                              var G__8714 = h5245;
                              var G__8715 = i5246;
                              var G__8716 = j5247;
                              var G__8717 = k5248;
                              var G__8718 = l5249;
                              return f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__8707, G__8708, G__8709, G__8710, G__8711, G__8712, G__8713, G__8714, G__8715, G__8716, G__8717, G__8718) : f.call(null, G__8707, G__8708, G__8709, G__8710, G__8711, G__8712, G__8713, G__8714, G__8715, G__8716, G__8717, G__8718);
                            }
                          } else {
                            var m5250 = cljs.core._first(args__$13);
                            var args__$14 = cljs.core._rest(args__$13);
                            if (argc === 13) {
                              if (f.cljs$core$IFn$_invoke$arity$13) {
                                return f.cljs$core$IFn$_invoke$arity$13(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250);
                              } else {
                                var G__8719 = a5238;
                                var G__8720 = b5239;
                                var G__8721 = c5240;
                                var G__8722 = d5241;
                                var G__8723 = e5242;
                                var G__8724 = f5243;
                                var G__8725 = g5244;
                                var G__8726 = h5245;
                                var G__8727 = i5246;
                                var G__8728 = j5247;
                                var G__8729 = k5248;
                                var G__8730 = l5249;
                                var G__8731 = m5250;
                                return f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__8719, G__8720, G__8721, G__8722, G__8723, G__8724, G__8725, G__8726, G__8727, G__8728, G__8729, G__8730, G__8731) : f.call(null, G__8719, G__8720, G__8721, G__8722, G__8723, G__8724, G__8725, G__8726, G__8727, G__8728, G__8729, G__8730, G__8731);
                              }
                            } else {
                              var n5251 = cljs.core._first(args__$14);
                              var args__$15 = cljs.core._rest(args__$14);
                              if (argc === 14) {
                                if (f.cljs$core$IFn$_invoke$arity$14) {
                                  return f.cljs$core$IFn$_invoke$arity$14(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251);
                                } else {
                                  var G__8732 = a5238;
                                  var G__8733 = b5239;
                                  var G__8734 = c5240;
                                  var G__8735 = d5241;
                                  var G__8736 = e5242;
                                  var G__8737 = f5243;
                                  var G__8738 = g5244;
                                  var G__8739 = h5245;
                                  var G__8740 = i5246;
                                  var G__8741 = j5247;
                                  var G__8742 = k5248;
                                  var G__8743 = l5249;
                                  var G__8744 = m5250;
                                  var G__8745 = n5251;
                                  return f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__8732, G__8733, G__8734, G__8735, G__8736, G__8737, G__8738, G__8739, G__8740, G__8741, G__8742, G__8743, G__8744, G__8745) : f.call(null, G__8732, G__8733, G__8734, G__8735, G__8736, G__8737, G__8738, G__8739, G__8740, G__8741, G__8742, G__8743, G__8744, G__8745);
                                }
                              } else {
                                var o5252 = cljs.core._first(args__$15);
                                var args__$16 = cljs.core._rest(args__$15);
                                if (argc === 15) {
                                  if (f.cljs$core$IFn$_invoke$arity$15) {
                                    return f.cljs$core$IFn$_invoke$arity$15(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252);
                                  } else {
                                    var G__8746 = a5238;
                                    var G__8747 = b5239;
                                    var G__8748 = c5240;
                                    var G__8749 = d5241;
                                    var G__8750 = e5242;
                                    var G__8751 = f5243;
                                    var G__8752 = g5244;
                                    var G__8753 = h5245;
                                    var G__8754 = i5246;
                                    var G__8755 = j5247;
                                    var G__8756 = k5248;
                                    var G__8757 = l5249;
                                    var G__8758 = m5250;
                                    var G__8759 = n5251;
                                    var G__8760 = o5252;
                                    return f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__8746, G__8747, G__8748, G__8749, G__8750, G__8751, G__8752, G__8753, G__8754, G__8755, G__8756, G__8757, G__8758, G__8759, G__8760) : f.call(null, G__8746, G__8747, G__8748, G__8749, G__8750, G__8751, G__8752, G__8753, G__8754, G__8755, G__8756, G__8757, G__8758, G__8759, G__8760);
                                  }
                                } else {
                                  var p5253 = cljs.core._first(args__$16);
                                  var args__$17 = cljs.core._rest(args__$16);
                                  if (argc === 16) {
                                    if (f.cljs$core$IFn$_invoke$arity$16) {
                                      return f.cljs$core$IFn$_invoke$arity$16(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253);
                                    } else {
                                      var G__8761 = a5238;
                                      var G__8762 = b5239;
                                      var G__8763 = c5240;
                                      var G__8764 = d5241;
                                      var G__8765 = e5242;
                                      var G__8766 = f5243;
                                      var G__8767 = g5244;
                                      var G__8768 = h5245;
                                      var G__8769 = i5246;
                                      var G__8770 = j5247;
                                      var G__8771 = k5248;
                                      var G__8772 = l5249;
                                      var G__8773 = m5250;
                                      var G__8774 = n5251;
                                      var G__8775 = o5252;
                                      var G__8776 = p5253;
                                      return f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__8761, G__8762, G__8763, G__8764, G__8765, G__8766, G__8767, G__8768, G__8769, G__8770, G__8771, G__8772, G__8773, G__8774, G__8775, G__8776) : f.call(null, G__8761, G__8762, G__8763, G__8764, G__8765, G__8766, G__8767, G__8768, G__8769, G__8770, G__8771, G__8772, G__8773, G__8774, G__8775, G__8776);
                                    }
                                  } else {
                                    var q5254 = cljs.core._first(args__$17);
                                    var args__$18 = cljs.core._rest(args__$17);
                                    if (argc === 17) {
                                      if (f.cljs$core$IFn$_invoke$arity$17) {
                                        return f.cljs$core$IFn$_invoke$arity$17(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254);
                                      } else {
                                        var G__8777 = a5238;
                                        var G__8778 = b5239;
                                        var G__8779 = c5240;
                                        var G__8780 = d5241;
                                        var G__8781 = e5242;
                                        var G__8782 = f5243;
                                        var G__8783 = g5244;
                                        var G__8784 = h5245;
                                        var G__8785 = i5246;
                                        var G__8786 = j5247;
                                        var G__8787 = k5248;
                                        var G__8788 = l5249;
                                        var G__8789 = m5250;
                                        var G__8790 = n5251;
                                        var G__8791 = o5252;
                                        var G__8792 = p5253;
                                        var G__8793 = q5254;
                                        return f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__8777, G__8778, G__8779, G__8780, G__8781, G__8782, G__8783, G__8784, G__8785, G__8786, G__8787, G__8788, G__8789, G__8790, G__8791, G__8792, G__8793) : f.call(null, G__8777, G__8778, G__8779, G__8780, G__8781, G__8782, G__8783, G__8784, G__8785, G__8786, G__8787, G__8788, G__8789, G__8790, G__8791, G__8792, G__8793);
                                      }
                                    } else {
                                      var r5255 = cljs.core._first(args__$18);
                                      var args__$19 = cljs.core._rest(args__$18);
                                      if (argc === 18) {
                                        if (f.cljs$core$IFn$_invoke$arity$18) {
                                          return f.cljs$core$IFn$_invoke$arity$18(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254, r5255);
                                        } else {
                                          var G__8794 = a5238;
                                          var G__8795 = b5239;
                                          var G__8796 = c5240;
                                          var G__8797 = d5241;
                                          var G__8798 = e5242;
                                          var G__8799 = f5243;
                                          var G__8800 = g5244;
                                          var G__8801 = h5245;
                                          var G__8802 = i5246;
                                          var G__8803 = j5247;
                                          var G__8804 = k5248;
                                          var G__8805 = l5249;
                                          var G__8806 = m5250;
                                          var G__8807 = n5251;
                                          var G__8808 = o5252;
                                          var G__8809 = p5253;
                                          var G__8810 = q5254;
                                          var G__8811 = r5255;
                                          return f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__8794, G__8795, G__8796, G__8797, G__8798, G__8799, G__8800, G__8801, G__8802, G__8803, G__8804, G__8805, G__8806, G__8807, G__8808, G__8809, G__8810, G__8811) : f.call(null, G__8794, G__8795, G__8796, G__8797, G__8798, G__8799, G__8800, G__8801, G__8802, G__8803, G__8804, G__8805, G__8806, G__8807, G__8808, G__8809, G__8810, G__8811);
                                        }
                                      } else {
                                        var s5256 = cljs.core._first(args__$19);
                                        var args__$20 = cljs.core._rest(args__$19);
                                        if (argc === 19) {
                                          if (f.cljs$core$IFn$_invoke$arity$19) {
                                            return f.cljs$core$IFn$_invoke$arity$19(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254, r5255, s5256);
                                          } else {
                                            var G__8812 = a5238;
                                            var G__8813 = b5239;
                                            var G__8814 = c5240;
                                            var G__8815 = d5241;
                                            var G__8816 = e5242;
                                            var G__8817 = f5243;
                                            var G__8818 = g5244;
                                            var G__8819 = h5245;
                                            var G__8820 = i5246;
                                            var G__8821 = j5247;
                                            var G__8822 = k5248;
                                            var G__8823 = l5249;
                                            var G__8824 = m5250;
                                            var G__8825 = n5251;
                                            var G__8826 = o5252;
                                            var G__8827 = p5253;
                                            var G__8828 = q5254;
                                            var G__8829 = r5255;
                                            var G__8830 = s5256;
                                            return f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__8812, G__8813, G__8814, G__8815, G__8816, G__8817, G__8818, G__8819, G__8820, G__8821, G__8822, G__8823, G__8824, G__8825, G__8826, G__8827, G__8828, G__8829, G__8830) : f.call(null, G__8812, G__8813, G__8814, G__8815, G__8816, G__8817, G__8818, G__8819, G__8820, G__8821, G__8822, G__8823, G__8824, G__8825, G__8826, G__8827, G__8828, G__8829, G__8830);
                                          }
                                        } else {
                                          var t5257 = cljs.core._first(args__$20);
                                          var args__$21 = cljs.core._rest(args__$20);
                                          if (argc === 20) {
                                            if (f.cljs$core$IFn$_invoke$arity$20) {
                                              return f.cljs$core$IFn$_invoke$arity$20(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254, r5255, s5256, t5257);
                                            } else {
                                              var G__8831 = a5238;
                                              var G__8832 = b5239;
                                              var G__8833 = c5240;
                                              var G__8834 = d5241;
                                              var G__8835 = e5242;
                                              var G__8836 = f5243;
                                              var G__8837 = g5244;
                                              var G__8838 = h5245;
                                              var G__8839 = i5246;
                                              var G__8840 = j5247;
                                              var G__8841 = k5248;
                                              var G__8842 = l5249;
                                              var G__8843 = m5250;
                                              var G__8844 = n5251;
                                              var G__8845 = o5252;
                                              var G__8846 = p5253;
                                              var G__8847 = q5254;
                                              var G__8848 = r5255;
                                              var G__8849 = s5256;
                                              var G__8850 = t5257;
                                              return f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__8831, G__8832, G__8833, G__8834, G__8835, G__8836, G__8837, G__8838, G__8839, G__8840, G__8841, G__8842, G__8843, G__8844, G__8845, G__8846, G__8847, G__8848, G__8849, G__8850) : f.call(null, G__8831, G__8832, G__8833, G__8834, G__8835, G__8836, G__8837, G__8838, G__8839, G__8840, G__8841, G__8842, G__8843, G__8844, G__8845, G__8846, G__8847, G__8848, G__8849, G__8850);
                                            }
                                          } else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function cljs$core$apply() {
  var G__8858 = arguments.length;
  switch(G__8858) {
    case 2:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 5), 0);
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], argseq__5360__auto__);
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(args, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, args);
    } else {
      return f.cljs$lang$applyTo(args);
    }
  } else {
    return f.apply(f, cljs.core.to_array(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = function(f, x, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x, y, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = function(f, x, y, z, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x, y, z, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = function(f, a, b, c, d, args) {
  var arglist = cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(args)))));
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$lang$applyTo = function(seq8851) {
  var G__8852 = cljs.core.first(seq8851);
  var seq8851__$1 = cljs.core.next(seq8851);
  var G__8853 = cljs.core.first(seq8851__$1);
  var seq8851__$2 = cljs.core.next(seq8851__$1);
  var G__8854 = cljs.core.first(seq8851__$2);
  var seq8851__$3 = cljs.core.next(seq8851__$2);
  var G__8855 = cljs.core.first(seq8851__$3);
  var seq8851__$4 = cljs.core.next(seq8851__$3);
  var G__8856 = cljs.core.first(seq8851__$4);
  var seq8851__$5 = cljs.core.next(seq8851__$4);
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__8852, G__8853, G__8854, G__8855, G__8856, seq8851__$5);
};
cljs.core.apply.cljs$lang$maxFixedArity = 5;
cljs.core.vary_meta = function cljs$core$vary_meta() {
  var G__8868 = arguments.length;
  switch(G__8868) {
    case 2:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5360__auto__);
  }
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = function(obj, f) {
  return cljs.core.with_meta(obj, function() {
    var G__8869 = cljs.core.meta(obj);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8869) : f.call(null, G__8869);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = function(obj, f, a) {
  return cljs.core.with_meta(obj, function() {
    var G__8870 = cljs.core.meta(obj);
    var G__8871 = a;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8870, G__8871) : f.call(null, G__8870, G__8871);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = function(obj, f, a, b) {
  return cljs.core.with_meta(obj, function() {
    var G__8872 = cljs.core.meta(obj);
    var G__8873 = a;
    var G__8874 = b;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8872, G__8873, G__8874) : f.call(null, G__8872, G__8873, G__8874);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = function(obj, f, a, b, c) {
  return cljs.core.with_meta(obj, function() {
    var G__8875 = cljs.core.meta(obj);
    var G__8876 = a;
    var G__8877 = b;
    var G__8878 = c;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8875, G__8876, G__8877, G__8878) : f.call(null, G__8875, G__8876, G__8877, G__8878);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = function(obj, f, a, b, c, d) {
  return cljs.core.with_meta(obj, function() {
    var G__8879 = cljs.core.meta(obj);
    var G__8880 = a;
    var G__8881 = b;
    var G__8882 = c;
    var G__8883 = d;
    return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8879, G__8880, G__8881, G__8882, G__8883) : f.call(null, G__8879, G__8880, G__8881, G__8882, G__8883);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = function(obj, f, a, b, c, d, args) {
  return cljs.core.with_meta(obj, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.meta(obj), a, b, c, cljs.core.array_seq([d, args], 0)));
};
cljs.core.vary_meta.cljs$lang$applyTo = function(seq8860) {
  var G__8861 = cljs.core.first(seq8860);
  var seq8860__$1 = cljs.core.next(seq8860);
  var G__8862 = cljs.core.first(seq8860__$1);
  var seq8860__$2 = cljs.core.next(seq8860__$1);
  var G__8863 = cljs.core.first(seq8860__$2);
  var seq8860__$3 = cljs.core.next(seq8860__$2);
  var G__8864 = cljs.core.first(seq8860__$3);
  var seq8860__$4 = cljs.core.next(seq8860__$3);
  var G__8865 = cljs.core.first(seq8860__$4);
  var seq8860__$5 = cljs.core.next(seq8860__$4);
  var G__8866 = cljs.core.first(seq8860__$5);
  var seq8860__$6 = cljs.core.next(seq8860__$5);
  return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__8861, G__8862, G__8863, G__8864, G__8865, G__8866, seq8860__$6);
};
cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
cljs.core.not_EQ_ = function cljs$core$not_EQ_() {
  var G__8889 = arguments.length;
  switch(G__8889) {
    case 1:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return false;
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_, x, y, more));
};
cljs.core.not_EQ_.cljs$lang$applyTo = function(seq8885) {
  var G__8886 = cljs.core.first(seq8885);
  var seq8885__$1 = cljs.core.next(seq8885);
  var G__8887 = cljs.core.first(seq8885__$1);
  var seq8885__$2 = cljs.core.next(seq8885__$1);
  return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__8886, G__8887, seq8885__$2);
};
cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.not_empty = function cljs$core$not_empty(coll) {
  if (cljs.core.seq(coll)) {
    return coll;
  } else {
    return null;
  }
};
cljs.core.nil_iter = function cljs$core$nil_iter() {
  if (typeof cljs.core.t8894 !== "undefined") {
  } else {
    cljs.core.t8894 = function(nil_iter, meta8895) {
      this.nil_iter = nil_iter;
      this.meta8895 = meta8895;
      this.cljs$lang$protocol_mask$partition0$ = 393216;
      this.cljs$lang$protocol_mask$partition1$ = 0;
    };
    cljs.core.t8894.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_8896, meta8895__$1) {
      var self__ = this;
      var _8896__$1 = this;
      return new cljs.core.t8894(self__.nil_iter, meta8895__$1);
    };
    cljs.core.t8894.prototype.cljs$core$IMeta$_meta$arity$1 = function(_8896) {
      var self__ = this;
      var _8896__$1 = this;
      return self__.meta8895;
    };
    cljs.core.t8894.prototype.hasNext = function() {
      var self__ = this;
      var _ = this;
      return false;
    };
    cljs.core.t8894.prototype.next = function() {
      var self__ = this;
      var _ = this;
      return new Error("No such element");
    };
    cljs.core.t8894.prototype.remove = function() {
      var self__ = this;
      var _ = this;
      return new Error("Unsupported operation");
    };
    cljs.core.t8894.getBasis = function() {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "nil-iter", "nil-iter", 1101030523, null), new cljs.core.Symbol(null, "meta8895", "meta8895", -1160243745, null)], null);
    };
    cljs.core.t8894.cljs$lang$type = true;
    cljs.core.t8894.cljs$lang$ctorStr = "cljs.core/t8894";
    cljs.core.t8894.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
      return cljs.core._write(writer__4889__auto__, "cljs.core/t8894");
    };
    cljs.core.__GT_t8894 = function cljs$core$nil_iter_$___GT_t8894(nil_iter__$1, meta8895) {
      return new cljs.core.t8894(nil_iter__$1, meta8895);
    };
  }
  return new cljs.core.t8894(cljs$core$nil_iter, cljs.core.PersistentArrayMap.EMPTY);
};
cljs.core.StringIter = function(s, i) {
  this.s = s;
  this.i = i;
};
cljs.core.StringIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.s.length;
};
cljs.core.StringIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.s.charAt(self__.i);
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.StringIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.StringIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.StringIter.cljs$lang$type = true;
cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/StringIter");
};
cljs.core.__GT_StringIter = function cljs$core$__GT_StringIter(s, i) {
  return new cljs.core.StringIter(s, i);
};
cljs.core.string_iter = function cljs$core$string_iter(x) {
  return new cljs.core.StringIter(x, 0);
};
cljs.core.ArrayIter = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.ArrayIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.ArrayIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.ArrayIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.ArrayIter.cljs$lang$type = true;
cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayIter");
};
cljs.core.__GT_ArrayIter = function cljs$core$__GT_ArrayIter(arr, i) {
  return new cljs.core.ArrayIter(arr, i);
};
cljs.core.array_iter = function cljs$core$array_iter(x) {
  return new cljs.core.ArrayIter(x, 0);
};
cljs.core.INIT = {};
cljs.core.START = {};
cljs.core.SeqIter = function(_seq, _next) {
  this._seq = _seq;
  this._next = _next;
};
cljs.core.SeqIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__._seq === cljs.core.INIT) {
    self__._seq = cljs.core.START;
    self__._next = cljs.core.seq(self__._next);
  } else {
    if (self__._seq === self__._next) {
      self__._next = cljs.core.next(self__._seq);
    } else {
    }
  }
  return !(self__._next == null);
};
cljs.core.SeqIter.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.not(this$.hasNext())) {
    throw new Error("No such element");
  } else {
    self__._seq = self__._next;
    return cljs.core.first(self__._next);
  }
};
cljs.core.SeqIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.SeqIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "_seq", "_seq", -449557847, null), new cljs.core.Symbol(null, "_next", "_next", 101877036, null)], null);
};
cljs.core.SeqIter.cljs$lang$type = true;
cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";
cljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/SeqIter");
};
cljs.core.__GT_SeqIter = function cljs$core$__GT_SeqIter(_seq, _next) {
  return new cljs.core.SeqIter(_seq, _next);
};
cljs.core.seq_iter = function cljs$core$seq_iter(coll) {
  return new cljs.core.SeqIter(cljs.core.INIT, coll);
};
cljs.core.iter = function cljs$core$iter(coll) {
  if (coll == null) {
    return cljs.core.nil_iter();
  } else {
    if (typeof coll === "string") {
      return cljs.core.string_iter(coll);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return cljs.core.array_iter(coll);
      } else {
        if (cljs.core.truth_(cljs.core.iterable_QMARK_(coll))) {
          return cljs.core._iterator(coll);
        } else {
          if (cljs.core.seqable_QMARK_(coll)) {
            return cljs.core.seq_iter(coll);
          } else {
            throw new Error([cljs.core.str("Cannot create iterator from "), cljs.core.str(coll)].join(""));
          }
        }
      }
    }
  }
};
cljs.core.lazy_transformer = function cljs$core$lazy_transformer(stepper) {
  return new cljs.core.LazyTransformer(stepper, null, null, null);
};
cljs.core.Stepper = function(xform, iter) {
  this.xform = xform;
  this.iter = iter;
};
cljs.core.Stepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = !(lt.stepper == null);
      if (and__4297__auto__) {
        return self__.iter.hasNext();
      } else {
        return and__4297__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(function() {
        var G__8897 = lt;
        var G__8898 = self__.iter.next();
        return self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__8897, G__8898) : self__.xform.call(null, G__8897, G__8898);
      }())) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    var G__8899 = lt;
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__8899) : self__.xform.call(null, G__8899);
  }
};
cljs.core.Stepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null)], null);
};
cljs.core.Stepper.cljs$lang$type = true;
cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";
cljs.core.Stepper.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Stepper");
};
cljs.core.__GT_Stepper = function cljs$core$__GT_Stepper(xform, iter) {
  return new cljs.core.Stepper(xform, iter);
};
cljs.core.stepper = function cljs$core$stepper(xform, iter) {
  var stepfn = function() {
    var cljs$core$stepper_$_stepfn = null;
    var cljs$core$stepper_$_stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return result;
    };
    var cljs$core$stepper_$_stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepper_$_stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepper_$_stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepper_$_stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
    return cljs$core$stepper_$_stepfn;
  }();
  return new cljs.core.Stepper(function() {
    var G__8901 = stepfn;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8901) : xform.call(null, G__8901);
  }(), iter);
};
cljs.core.MultiStepper = function(xform, iters, nexts) {
  this.xform = xform;
  this.iters = iters;
  this.nexts = nexts;
};
cljs.core.MultiStepper.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var iters__$1 = cljs.core.seq(self__.iters);
  while (true) {
    if (!(iters__$1 == null)) {
      var iter = cljs.core.first(iters__$1);
      if (cljs.core.not(iter.hasNext())) {
        return false;
      } else {
        var G__8903 = cljs.core.next(iters__$1);
        iters__$1 = G__8903;
        continue;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.MultiStepper.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var n__5194__auto___8904 = self__.iters.length;
  var i_8905 = 0;
  while (true) {
    if (i_8905 < n__5194__auto___8904) {
      self__.nexts[i_8905] = self__.iters[i_8905].next();
      var G__8906 = i_8905 + 1;
      i_8905 = G__8906;
      continue;
    } else {
    }
    break;
  }
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts, 0);
};
cljs.core.MultiStepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = !(lt.stepper == null);
      if (and__4297__auto__) {
        return this$.hasNext();
      } else {
        return and__4297__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform, cljs.core.cons(lt, this$.next())))) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    var G__8902 = lt;
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__8902) : self__.xform.call(null, G__8902);
  }
};
cljs.core.MultiStepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iters", "iters", 719353031, null), new cljs.core.Symbol(null, "nexts", "nexts", -1683579407, null)], null);
};
cljs.core.MultiStepper.cljs$lang$type = true;
cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";
cljs.core.MultiStepper.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/MultiStepper");
};
cljs.core.__GT_MultiStepper = function cljs$core$__GT_MultiStepper(xform, iters, nexts) {
  return new cljs.core.MultiStepper(xform, iters, nexts);
};
cljs.core.multi_stepper = function cljs$core$multi_stepper() {
  var G__8908 = arguments.length;
  switch(G__8908) {
    case 2:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = function(xform, iters) {
  return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length));
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = function(xform, iters, nexts) {
  var stepfn = function() {
    var cljs$core$stepfn = null;
    var cljs$core$stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return lt;
    };
    var cljs$core$stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
    return cljs$core$stepfn;
  }();
  return new cljs.core.MultiStepper(function() {
    var G__8909 = stepfn;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8909) : xform.call(null, G__8909);
  }(), iters, nexts);
};
cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;
cljs.core.LazyTransformer = function(stepper, first, rest, meta) {
  this.stepper = stepper;
  this.first = first;
  this.rest = rest;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 31719628;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(this$, new_meta) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.LazyTransformer(self__.stepper, self__.first, self__.rest, new_meta);
};
cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, cljs.core._seq(this$__$1));
};
cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  var s = cljs.core._seq(this$__$1);
  if (!(s == null)) {
    return cljs.core.equiv_sequential(this$__$1, other);
  } else {
    return cljs.core.sequential_QMARK_(other) && cljs.core.seq(other) == null;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.hash_ordered_coll(this$__$1);
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    self__.stepper.step(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return this$__$1;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return self__.first;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core._seq(self__.rest);
  }
};
cljs.core.LazyTransformer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "stepper", "stepper", 1159163296, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.LazyTransformer.cljs$lang$type = true;
cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";
cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/LazyTransformer");
};
cljs.core.__GT_LazyTransformer = function cljs$core$__GT_LazyTransformer(stepper, first, rest, meta) {
  return new cljs.core.LazyTransformer(stepper, first, rest, meta);
};
cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.LazyTransformer.create = function(xform, coll) {
  return new cljs.core.LazyTransformer(cljs.core.stepper(xform, cljs.core.iter(coll)), null, null, null);
};
cljs.core.LazyTransformer.createMulti = function(xform, colls) {
  var iters = [];
  var seq__8911_8915 = cljs.core.seq(colls);
  var chunk__8912_8916 = null;
  var count__8913_8917 = 0;
  var i__8914_8918 = 0;
  while (true) {
    if (i__8914_8918 < count__8913_8917) {
      var coll_8919 = chunk__8912_8916.cljs$core$IIndexed$_nth$arity$2(null, i__8914_8918);
      iters.push(cljs.core.iter(coll_8919));
      var G__8920 = seq__8911_8915;
      var G__8921 = chunk__8912_8916;
      var G__8922 = count__8913_8917;
      var G__8923 = i__8914_8918 + 1;
      seq__8911_8915 = G__8920;
      chunk__8912_8916 = G__8921;
      count__8913_8917 = G__8922;
      i__8914_8918 = G__8923;
      continue;
    } else {
      var temp__4425__auto___8924 = cljs.core.seq(seq__8911_8915);
      if (temp__4425__auto___8924) {
        var seq__8911_8925__$1 = temp__4425__auto___8924;
        if (cljs.core.chunked_seq_QMARK_(seq__8911_8925__$1)) {
          var c__5094__auto___8926 = cljs.core.chunk_first(seq__8911_8925__$1);
          var G__8927 = cljs.core.chunk_rest(seq__8911_8925__$1);
          var G__8928 = c__5094__auto___8926;
          var G__8929 = cljs.core.count(c__5094__auto___8926);
          var G__8930 = 0;
          seq__8911_8915 = G__8927;
          chunk__8912_8916 = G__8928;
          count__8913_8917 = G__8929;
          i__8914_8918 = G__8930;
          continue;
        } else {
          var coll_8931 = cljs.core.first(seq__8911_8925__$1);
          iters.push(cljs.core.iter(coll_8931));
          var G__8932 = cljs.core.next(seq__8911_8925__$1);
          var G__8933 = null;
          var G__8934 = 0;
          var G__8935 = 0;
          seq__8911_8915 = G__8932;
          chunk__8912_8916 = G__8933;
          count__8913_8917 = G__8934;
          i__8914_8918 = G__8935;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length)), null, null, null);
};
cljs.core.sequence = function cljs$core$sequence() {
  var G__8940 = arguments.length;
  switch(G__8940) {
    case 1:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  if (cljs.core.seq_QMARK_(coll)) {
    return coll;
  } else {
    var or__4309__auto__ = cljs.core.seq(coll);
    if (or__4309__auto__) {
      return or__4309__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = function(xform, coll) {
  return cljs.core.LazyTransformer.create(xform, coll);
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = function(xform, coll, colls) {
  return cljs.core.LazyTransformer.createMulti(xform, cljs.core.to_array(cljs.core.cons(coll, colls)));
};
cljs.core.sequence.cljs$lang$applyTo = function(seq8936) {
  var G__8937 = cljs.core.first(seq8936);
  var seq8936__$1 = cljs.core.next(seq8936);
  var G__8938 = cljs.core.first(seq8936__$1);
  var seq8936__$2 = cljs.core.next(seq8936__$1);
  return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__8937, G__8938, seq8936__$2);
};
cljs.core.sequence.cljs$lang$maxFixedArity = 2;
cljs.core.every_QMARK_ = function cljs$core$every_QMARK_(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll) == null) {
      return true;
    } else {
      if (cljs.core.truth_(function() {
        var G__8943 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8943) : pred.call(null, G__8943);
      }())) {
        var G__8944 = pred;
        var G__8945 = cljs.core.next(coll);
        pred = G__8944;
        coll = G__8945;
        continue;
      } else {
        return false;
      }
    }
    break;
  }
};
cljs.core.not_every_QMARK_ = function cljs$core$not_every_QMARK_(pred, coll) {
  return !cljs.core.every_QMARK_(pred, coll);
};
cljs.core.some = function cljs$core$some(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll)) {
      var or__4309__auto__ = function() {
        var G__8949 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8949) : pred.call(null, G__8949);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var G__8950 = pred;
        var G__8951 = cljs.core.next(coll);
        pred = G__8950;
        coll = G__8951;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.not_any_QMARK_ = function cljs$core$not_any_QMARK_(pred, coll) {
  return cljs.core.not(cljs.core.some(pred, coll));
};
cljs.core.even_QMARK_ = function cljs$core$even_QMARK_(n) {
  if (cljs.core.integer_QMARK_(n)) {
    return (n & 1) === 0;
  } else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function cljs$core$odd_QMARK_(n) {
  return !cljs.core.even_QMARK_(n);
};
cljs.core.complement = function cljs$core$complement(f) {
  return function() {
    var G__8958 = null;
    var G__8958__0 = function() {
      return cljs.core.not(function() {
        return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
      }());
    };
    var G__8958__1 = function(x) {
      return cljs.core.not(function() {
        var G__8955 = x;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8955) : f.call(null, G__8955);
      }());
    };
    var G__8958__2 = function(x, y) {
      return cljs.core.not(function() {
        var G__8956 = x;
        var G__8957 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8956, G__8957) : f.call(null, G__8956, G__8957);
      }());
    };
    var G__8958__3 = function() {
      var G__8959__delegate = function(x, y, zs) {
        return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f, x, y, zs));
      };
      var G__8959 = function(x, y, var_args) {
        var zs = null;
        if (arguments.length > 2) {
          var G__8960__i = 0, G__8960__a = new Array(arguments.length - 2);
          while (G__8960__i < G__8960__a.length) {
            G__8960__a[G__8960__i] = arguments[G__8960__i + 2];
            ++G__8960__i;
          }
          zs = new cljs.core.IndexedSeq(G__8960__a, 0);
        }
        return G__8959__delegate.call(this, x, y, zs);
      };
      G__8959.cljs$lang$maxFixedArity = 2;
      G__8959.cljs$lang$applyTo = function(arglist__8961) {
        var x = cljs.core.first(arglist__8961);
        arglist__8961 = cljs.core.next(arglist__8961);
        var y = cljs.core.first(arglist__8961);
        var zs = cljs.core.rest(arglist__8961);
        return G__8959__delegate(x, y, zs);
      };
      G__8959.cljs$core$IFn$_invoke$arity$variadic = G__8959__delegate;
      return G__8959;
    }();
    G__8958 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__8958__0.call(this);
        case 1:
          return G__8958__1.call(this, x);
        case 2:
          return G__8958__2.call(this, x, y);
        default:
          var G__8962 = null;
          if (arguments.length > 2) {
            var G__8963__i = 0, G__8963__a = new Array(arguments.length - 2);
            while (G__8963__i < G__8963__a.length) {
              G__8963__a[G__8963__i] = arguments[G__8963__i + 2];
              ++G__8963__i;
            }
            G__8962 = new cljs.core.IndexedSeq(G__8963__a, 0);
          }
          return G__8958__3.cljs$core$IFn$_invoke$arity$variadic(x, y, G__8962);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__8958.cljs$lang$maxFixedArity = 2;
    G__8958.cljs$lang$applyTo = G__8958__3.cljs$lang$applyTo;
    G__8958.cljs$core$IFn$_invoke$arity$0 = G__8958__0;
    G__8958.cljs$core$IFn$_invoke$arity$1 = G__8958__1;
    G__8958.cljs$core$IFn$_invoke$arity$2 = G__8958__2;
    G__8958.cljs$core$IFn$_invoke$arity$variadic = G__8958__3.cljs$core$IFn$_invoke$arity$variadic;
    return G__8958;
  }();
};
cljs.core.constantly = function cljs$core$constantly(x) {
  return function() {
    var G__8964__delegate = function(args) {
      return x;
    };
    var G__8964 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__8965__i = 0, G__8965__a = new Array(arguments.length - 0);
        while (G__8965__i < G__8965__a.length) {
          G__8965__a[G__8965__i] = arguments[G__8965__i + 0];
          ++G__8965__i;
        }
        args = new cljs.core.IndexedSeq(G__8965__a, 0);
      }
      return G__8964__delegate.call(this, args);
    };
    G__8964.cljs$lang$maxFixedArity = 0;
    G__8964.cljs$lang$applyTo = function(arglist__8966) {
      var args = cljs.core.seq(arglist__8966);
      return G__8964__delegate(args);
    };
    G__8964.cljs$core$IFn$_invoke$arity$variadic = G__8964__delegate;
    return G__8964;
  }();
};
cljs.core.comp = function cljs$core$comp() {
  var G__8972 = arguments.length;
  switch(G__8972) {
    case 0:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.identity;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__9001 = null;
    var G__9001__0 = function() {
      var G__8973 = function() {
        return g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8973) : f.call(null, G__8973);
    };
    var G__9001__1 = function(x) {
      var G__8974 = function() {
        var G__8975 = x;
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8975) : g.call(null, G__8975);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8974) : f.call(null, G__8974);
    };
    var G__9001__2 = function(x, y) {
      var G__8976 = function() {
        var G__8977 = x;
        var G__8978 = y;
        return g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__8977, G__8978) : g.call(null, G__8977, G__8978);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8976) : f.call(null, G__8976);
    };
    var G__9001__3 = function(x, y, z) {
      var G__8979 = function() {
        var G__8980 = x;
        var G__8981 = y;
        var G__8982 = z;
        return g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__8980, G__8981, G__8982) : g.call(null, G__8980, G__8981, G__8982);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8979) : f.call(null, G__8979);
    };
    var G__9001__4 = function() {
      var G__9002__delegate = function(x, y, z, args) {
        var G__8983 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args);
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8983) : f.call(null, G__8983);
      };
      var G__9002 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9003__i = 0, G__9003__a = new Array(arguments.length - 3);
          while (G__9003__i < G__9003__a.length) {
            G__9003__a[G__9003__i] = arguments[G__9003__i + 3];
            ++G__9003__i;
          }
          args = new cljs.core.IndexedSeq(G__9003__a, 0);
        }
        return G__9002__delegate.call(this, x, y, z, args);
      };
      G__9002.cljs$lang$maxFixedArity = 3;
      G__9002.cljs$lang$applyTo = function(arglist__9004) {
        var x = cljs.core.first(arglist__9004);
        arglist__9004 = cljs.core.next(arglist__9004);
        var y = cljs.core.first(arglist__9004);
        arglist__9004 = cljs.core.next(arglist__9004);
        var z = cljs.core.first(arglist__9004);
        var args = cljs.core.rest(arglist__9004);
        return G__9002__delegate(x, y, z, args);
      };
      G__9002.cljs$core$IFn$_invoke$arity$variadic = G__9002__delegate;
      return G__9002;
    }();
    G__9001 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9001__0.call(this);
        case 1:
          return G__9001__1.call(this, x);
        case 2:
          return G__9001__2.call(this, x, y);
        case 3:
          return G__9001__3.call(this, x, y, z);
        default:
          var G__9005 = null;
          if (arguments.length > 3) {
            var G__9006__i = 0, G__9006__a = new Array(arguments.length - 3);
            while (G__9006__i < G__9006__a.length) {
              G__9006__a[G__9006__i] = arguments[G__9006__i + 3];
              ++G__9006__i;
            }
            G__9005 = new cljs.core.IndexedSeq(G__9006__a, 0);
          }
          return G__9001__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9005);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9001.cljs$lang$maxFixedArity = 3;
    G__9001.cljs$lang$applyTo = G__9001__4.cljs$lang$applyTo;
    G__9001.cljs$core$IFn$_invoke$arity$0 = G__9001__0;
    G__9001.cljs$core$IFn$_invoke$arity$1 = G__9001__1;
    G__9001.cljs$core$IFn$_invoke$arity$2 = G__9001__2;
    G__9001.cljs$core$IFn$_invoke$arity$3 = G__9001__3;
    G__9001.cljs$core$IFn$_invoke$arity$variadic = G__9001__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9001;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__9007 = null;
    var G__9007__0 = function() {
      var G__8984 = function() {
        var G__8985 = function() {
          return h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8985) : g.call(null, G__8985);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8984) : f.call(null, G__8984);
    };
    var G__9007__1 = function(x) {
      var G__8986 = function() {
        var G__8987 = function() {
          var G__8988 = x;
          return h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__8988) : h.call(null, G__8988);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8987) : g.call(null, G__8987);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8986) : f.call(null, G__8986);
    };
    var G__9007__2 = function(x, y) {
      var G__8989 = function() {
        var G__8990 = function() {
          var G__8991 = x;
          var G__8992 = y;
          return h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__8991, G__8992) : h.call(null, G__8991, G__8992);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8990) : g.call(null, G__8990);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8989) : f.call(null, G__8989);
    };
    var G__9007__3 = function(x, y, z) {
      var G__8993 = function() {
        var G__8994 = function() {
          var G__8995 = x;
          var G__8996 = y;
          var G__8997 = z;
          return h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__8995, G__8996, G__8997) : h.call(null, G__8995, G__8996, G__8997);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8994) : g.call(null, G__8994);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8993) : f.call(null, G__8993);
    };
    var G__9007__4 = function() {
      var G__9008__delegate = function(x, y, z, args) {
        var G__8998 = function() {
          var G__8999 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args);
          return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8999) : g.call(null, G__8999);
        }();
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8998) : f.call(null, G__8998);
      };
      var G__9008 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9009__i = 0, G__9009__a = new Array(arguments.length - 3);
          while (G__9009__i < G__9009__a.length) {
            G__9009__a[G__9009__i] = arguments[G__9009__i + 3];
            ++G__9009__i;
          }
          args = new cljs.core.IndexedSeq(G__9009__a, 0);
        }
        return G__9008__delegate.call(this, x, y, z, args);
      };
      G__9008.cljs$lang$maxFixedArity = 3;
      G__9008.cljs$lang$applyTo = function(arglist__9010) {
        var x = cljs.core.first(arglist__9010);
        arglist__9010 = cljs.core.next(arglist__9010);
        var y = cljs.core.first(arglist__9010);
        arglist__9010 = cljs.core.next(arglist__9010);
        var z = cljs.core.first(arglist__9010);
        var args = cljs.core.rest(arglist__9010);
        return G__9008__delegate(x, y, z, args);
      };
      G__9008.cljs$core$IFn$_invoke$arity$variadic = G__9008__delegate;
      return G__9008;
    }();
    G__9007 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9007__0.call(this);
        case 1:
          return G__9007__1.call(this, x);
        case 2:
          return G__9007__2.call(this, x, y);
        case 3:
          return G__9007__3.call(this, x, y, z);
        default:
          var G__9011 = null;
          if (arguments.length > 3) {
            var G__9012__i = 0, G__9012__a = new Array(arguments.length - 3);
            while (G__9012__i < G__9012__a.length) {
              G__9012__a[G__9012__i] = arguments[G__9012__i + 3];
              ++G__9012__i;
            }
            G__9011 = new cljs.core.IndexedSeq(G__9012__a, 0);
          }
          return G__9007__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9011);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9007.cljs$lang$maxFixedArity = 3;
    G__9007.cljs$lang$applyTo = G__9007__4.cljs$lang$applyTo;
    G__9007.cljs$core$IFn$_invoke$arity$0 = G__9007__0;
    G__9007.cljs$core$IFn$_invoke$arity$1 = G__9007__1;
    G__9007.cljs$core$IFn$_invoke$arity$2 = G__9007__2;
    G__9007.cljs$core$IFn$_invoke$arity$3 = G__9007__3;
    G__9007.cljs$core$IFn$_invoke$arity$variadic = G__9007__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9007;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = function(f1, f2, f3, fs) {
  var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1, f2, f3, fs));
  return function(fs__$1) {
    return function() {
      var G__9013__delegate = function(args) {
        var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1), args);
        var fs__$2 = cljs.core.next(fs__$1);
        while (true) {
          if (fs__$2) {
            var G__9014 = cljs.core.first(fs__$2).call(null, ret);
            var G__9015 = cljs.core.next(fs__$2);
            ret = G__9014;
            fs__$2 = G__9015;
            continue;
          } else {
            return ret;
          }
          break;
        }
      };
      var G__9013 = function(var_args) {
        var args = null;
        if (arguments.length > 0) {
          var G__9016__i = 0, G__9016__a = new Array(arguments.length - 0);
          while (G__9016__i < G__9016__a.length) {
            G__9016__a[G__9016__i] = arguments[G__9016__i + 0];
            ++G__9016__i;
          }
          args = new cljs.core.IndexedSeq(G__9016__a, 0);
        }
        return G__9013__delegate.call(this, args);
      };
      G__9013.cljs$lang$maxFixedArity = 0;
      G__9013.cljs$lang$applyTo = function(arglist__9017) {
        var args = cljs.core.seq(arglist__9017);
        return G__9013__delegate(args);
      };
      G__9013.cljs$core$IFn$_invoke$arity$variadic = G__9013__delegate;
      return G__9013;
    }();
  }(fs__$1);
};
cljs.core.comp.cljs$lang$applyTo = function(seq8967) {
  var G__8968 = cljs.core.first(seq8967);
  var seq8967__$1 = cljs.core.next(seq8967);
  var G__8969 = cljs.core.first(seq8967__$1);
  var seq8967__$2 = cljs.core.next(seq8967__$1);
  var G__8970 = cljs.core.first(seq8967__$2);
  var seq8967__$3 = cljs.core.next(seq8967__$2);
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__8968, G__8969, G__8970, seq8967__$3);
};
cljs.core.comp.cljs$lang$maxFixedArity = 3;
cljs.core.partial = function cljs$core$partial() {
  var G__9024 = arguments.length;
  switch(G__9024) {
    case 1:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = function(f, arg1) {
  return function() {
    var G__9068 = null;
    var G__9068__0 = function() {
      var G__9025 = arg1;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9025) : f.call(null, G__9025);
    };
    var G__9068__1 = function(x) {
      var G__9026 = arg1;
      var G__9027 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9026, G__9027) : f.call(null, G__9026, G__9027);
    };
    var G__9068__2 = function(x, y) {
      var G__9028 = arg1;
      var G__9029 = x;
      var G__9030 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9028, G__9029, G__9030) : f.call(null, G__9028, G__9029, G__9030);
    };
    var G__9068__3 = function(x, y, z) {
      var G__9031 = arg1;
      var G__9032 = x;
      var G__9033 = y;
      var G__9034 = z;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9031, G__9032, G__9033, G__9034) : f.call(null, G__9031, G__9032, G__9033, G__9034);
    };
    var G__9068__4 = function() {
      var G__9069__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, x, y, z, cljs.core.array_seq([args], 0));
      };
      var G__9069 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9070__i = 0, G__9070__a = new Array(arguments.length - 3);
          while (G__9070__i < G__9070__a.length) {
            G__9070__a[G__9070__i] = arguments[G__9070__i + 3];
            ++G__9070__i;
          }
          args = new cljs.core.IndexedSeq(G__9070__a, 0);
        }
        return G__9069__delegate.call(this, x, y, z, args);
      };
      G__9069.cljs$lang$maxFixedArity = 3;
      G__9069.cljs$lang$applyTo = function(arglist__9071) {
        var x = cljs.core.first(arglist__9071);
        arglist__9071 = cljs.core.next(arglist__9071);
        var y = cljs.core.first(arglist__9071);
        arglist__9071 = cljs.core.next(arglist__9071);
        var z = cljs.core.first(arglist__9071);
        var args = cljs.core.rest(arglist__9071);
        return G__9069__delegate(x, y, z, args);
      };
      G__9069.cljs$core$IFn$_invoke$arity$variadic = G__9069__delegate;
      return G__9069;
    }();
    G__9068 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9068__0.call(this);
        case 1:
          return G__9068__1.call(this, x);
        case 2:
          return G__9068__2.call(this, x, y);
        case 3:
          return G__9068__3.call(this, x, y, z);
        default:
          var G__9072 = null;
          if (arguments.length > 3) {
            var G__9073__i = 0, G__9073__a = new Array(arguments.length - 3);
            while (G__9073__i < G__9073__a.length) {
              G__9073__a[G__9073__i] = arguments[G__9073__i + 3];
              ++G__9073__i;
            }
            G__9072 = new cljs.core.IndexedSeq(G__9073__a, 0);
          }
          return G__9068__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9072);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9068.cljs$lang$maxFixedArity = 3;
    G__9068.cljs$lang$applyTo = G__9068__4.cljs$lang$applyTo;
    G__9068.cljs$core$IFn$_invoke$arity$0 = G__9068__0;
    G__9068.cljs$core$IFn$_invoke$arity$1 = G__9068__1;
    G__9068.cljs$core$IFn$_invoke$arity$2 = G__9068__2;
    G__9068.cljs$core$IFn$_invoke$arity$3 = G__9068__3;
    G__9068.cljs$core$IFn$_invoke$arity$variadic = G__9068__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9068;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = function(f, arg1, arg2) {
  return function() {
    var G__9074 = null;
    var G__9074__0 = function() {
      var G__9035 = arg1;
      var G__9036 = arg2;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9035, G__9036) : f.call(null, G__9035, G__9036);
    };
    var G__9074__1 = function(x) {
      var G__9037 = arg1;
      var G__9038 = arg2;
      var G__9039 = x;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9037, G__9038, G__9039) : f.call(null, G__9037, G__9038, G__9039);
    };
    var G__9074__2 = function(x, y) {
      var G__9040 = arg1;
      var G__9041 = arg2;
      var G__9042 = x;
      var G__9043 = y;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9040, G__9041, G__9042, G__9043) : f.call(null, G__9040, G__9041, G__9042, G__9043);
    };
    var G__9074__3 = function(x, y, z) {
      var G__9044 = arg1;
      var G__9045 = arg2;
      var G__9046 = x;
      var G__9047 = y;
      var G__9048 = z;
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9044, G__9045, G__9046, G__9047, G__9048) : f.call(null, G__9044, G__9045, G__9046, G__9047, G__9048);
    };
    var G__9074__4 = function() {
      var G__9075__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, x, y, cljs.core.array_seq([z, args], 0));
      };
      var G__9075 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9076__i = 0, G__9076__a = new Array(arguments.length - 3);
          while (G__9076__i < G__9076__a.length) {
            G__9076__a[G__9076__i] = arguments[G__9076__i + 3];
            ++G__9076__i;
          }
          args = new cljs.core.IndexedSeq(G__9076__a, 0);
        }
        return G__9075__delegate.call(this, x, y, z, args);
      };
      G__9075.cljs$lang$maxFixedArity = 3;
      G__9075.cljs$lang$applyTo = function(arglist__9077) {
        var x = cljs.core.first(arglist__9077);
        arglist__9077 = cljs.core.next(arglist__9077);
        var y = cljs.core.first(arglist__9077);
        arglist__9077 = cljs.core.next(arglist__9077);
        var z = cljs.core.first(arglist__9077);
        var args = cljs.core.rest(arglist__9077);
        return G__9075__delegate(x, y, z, args);
      };
      G__9075.cljs$core$IFn$_invoke$arity$variadic = G__9075__delegate;
      return G__9075;
    }();
    G__9074 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9074__0.call(this);
        case 1:
          return G__9074__1.call(this, x);
        case 2:
          return G__9074__2.call(this, x, y);
        case 3:
          return G__9074__3.call(this, x, y, z);
        default:
          var G__9078 = null;
          if (arguments.length > 3) {
            var G__9079__i = 0, G__9079__a = new Array(arguments.length - 3);
            while (G__9079__i < G__9079__a.length) {
              G__9079__a[G__9079__i] = arguments[G__9079__i + 3];
              ++G__9079__i;
            }
            G__9078 = new cljs.core.IndexedSeq(G__9079__a, 0);
          }
          return G__9074__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9078);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9074.cljs$lang$maxFixedArity = 3;
    G__9074.cljs$lang$applyTo = G__9074__4.cljs$lang$applyTo;
    G__9074.cljs$core$IFn$_invoke$arity$0 = G__9074__0;
    G__9074.cljs$core$IFn$_invoke$arity$1 = G__9074__1;
    G__9074.cljs$core$IFn$_invoke$arity$2 = G__9074__2;
    G__9074.cljs$core$IFn$_invoke$arity$3 = G__9074__3;
    G__9074.cljs$core$IFn$_invoke$arity$variadic = G__9074__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9074;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = function(f, arg1, arg2, arg3) {
  return function() {
    var G__9080 = null;
    var G__9080__0 = function() {
      var G__9049 = arg1;
      var G__9050 = arg2;
      var G__9051 = arg3;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9049, G__9050, G__9051) : f.call(null, G__9049, G__9050, G__9051);
    };
    var G__9080__1 = function(x) {
      var G__9052 = arg1;
      var G__9053 = arg2;
      var G__9054 = arg3;
      var G__9055 = x;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9052, G__9053, G__9054, G__9055) : f.call(null, G__9052, G__9053, G__9054, G__9055);
    };
    var G__9080__2 = function(x, y) {
      var G__9056 = arg1;
      var G__9057 = arg2;
      var G__9058 = arg3;
      var G__9059 = x;
      var G__9060 = y;
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9056, G__9057, G__9058, G__9059, G__9060) : f.call(null, G__9056, G__9057, G__9058, G__9059, G__9060);
    };
    var G__9080__3 = function(x, y, z) {
      var G__9061 = arg1;
      var G__9062 = arg2;
      var G__9063 = arg3;
      var G__9064 = x;
      var G__9065 = y;
      var G__9066 = z;
      return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__9061, G__9062, G__9063, G__9064, G__9065, G__9066) : f.call(null, G__9061, G__9062, G__9063, G__9064, G__9065, G__9066);
    };
    var G__9080__4 = function() {
      var G__9081__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, arg3, x, cljs.core.array_seq([y, z, args], 0));
      };
      var G__9081 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9082__i = 0, G__9082__a = new Array(arguments.length - 3);
          while (G__9082__i < G__9082__a.length) {
            G__9082__a[G__9082__i] = arguments[G__9082__i + 3];
            ++G__9082__i;
          }
          args = new cljs.core.IndexedSeq(G__9082__a, 0);
        }
        return G__9081__delegate.call(this, x, y, z, args);
      };
      G__9081.cljs$lang$maxFixedArity = 3;
      G__9081.cljs$lang$applyTo = function(arglist__9083) {
        var x = cljs.core.first(arglist__9083);
        arglist__9083 = cljs.core.next(arglist__9083);
        var y = cljs.core.first(arglist__9083);
        arglist__9083 = cljs.core.next(arglist__9083);
        var z = cljs.core.first(arglist__9083);
        var args = cljs.core.rest(arglist__9083);
        return G__9081__delegate(x, y, z, args);
      };
      G__9081.cljs$core$IFn$_invoke$arity$variadic = G__9081__delegate;
      return G__9081;
    }();
    G__9080 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9080__0.call(this);
        case 1:
          return G__9080__1.call(this, x);
        case 2:
          return G__9080__2.call(this, x, y);
        case 3:
          return G__9080__3.call(this, x, y, z);
        default:
          var G__9084 = null;
          if (arguments.length > 3) {
            var G__9085__i = 0, G__9085__a = new Array(arguments.length - 3);
            while (G__9085__i < G__9085__a.length) {
              G__9085__a[G__9085__i] = arguments[G__9085__i + 3];
              ++G__9085__i;
            }
            G__9084 = new cljs.core.IndexedSeq(G__9085__a, 0);
          }
          return G__9080__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9084);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9080.cljs$lang$maxFixedArity = 3;
    G__9080.cljs$lang$applyTo = G__9080__4.cljs$lang$applyTo;
    G__9080.cljs$core$IFn$_invoke$arity$0 = G__9080__0;
    G__9080.cljs$core$IFn$_invoke$arity$1 = G__9080__1;
    G__9080.cljs$core$IFn$_invoke$arity$2 = G__9080__2;
    G__9080.cljs$core$IFn$_invoke$arity$3 = G__9080__3;
    G__9080.cljs$core$IFn$_invoke$arity$variadic = G__9080__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9080;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = function(f, arg1, arg2, arg3, more) {
  return function() {
    var G__9086__delegate = function(args) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, arg1, arg2, arg3, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more, args));
    };
    var G__9086 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__9087__i = 0, G__9087__a = new Array(arguments.length - 0);
        while (G__9087__i < G__9087__a.length) {
          G__9087__a[G__9087__i] = arguments[G__9087__i + 0];
          ++G__9087__i;
        }
        args = new cljs.core.IndexedSeq(G__9087__a, 0);
      }
      return G__9086__delegate.call(this, args);
    };
    G__9086.cljs$lang$maxFixedArity = 0;
    G__9086.cljs$lang$applyTo = function(arglist__9088) {
      var args = cljs.core.seq(arglist__9088);
      return G__9086__delegate(args);
    };
    G__9086.cljs$core$IFn$_invoke$arity$variadic = G__9086__delegate;
    return G__9086;
  }();
};
cljs.core.partial.cljs$lang$applyTo = function(seq9018) {
  var G__9019 = cljs.core.first(seq9018);
  var seq9018__$1 = cljs.core.next(seq9018);
  var G__9020 = cljs.core.first(seq9018__$1);
  var seq9018__$2 = cljs.core.next(seq9018__$1);
  var G__9021 = cljs.core.first(seq9018__$2);
  var seq9018__$3 = cljs.core.next(seq9018__$2);
  var G__9022 = cljs.core.first(seq9018__$3);
  var seq9018__$4 = cljs.core.next(seq9018__$3);
  return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__9019, G__9020, G__9021, G__9022, seq9018__$4);
};
cljs.core.partial.cljs$lang$maxFixedArity = 4;
cljs.core.fnil = function cljs$core$fnil() {
  var G__9090 = arguments.length;
  switch(G__9090) {
    case 2:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = function(f, x) {
  return function() {
    var G__9108 = null;
    var G__9108__1 = function(a) {
      var G__9091 = a == null ? x : a;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9091) : f.call(null, G__9091);
    };
    var G__9108__2 = function(a, b) {
      var G__9092 = a == null ? x : a;
      var G__9093 = b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9092, G__9093) : f.call(null, G__9092, G__9093);
    };
    var G__9108__3 = function(a, b, c) {
      var G__9094 = a == null ? x : a;
      var G__9095 = b;
      var G__9096 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9094, G__9095, G__9096) : f.call(null, G__9094, G__9095, G__9096);
    };
    var G__9108__4 = function() {
      var G__9109__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b, c, ds);
      };
      var G__9109 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__9110__i = 0, G__9110__a = new Array(arguments.length - 3);
          while (G__9110__i < G__9110__a.length) {
            G__9110__a[G__9110__i] = arguments[G__9110__i + 3];
            ++G__9110__i;
          }
          ds = new cljs.core.IndexedSeq(G__9110__a, 0);
        }
        return G__9109__delegate.call(this, a, b, c, ds);
      };
      G__9109.cljs$lang$maxFixedArity = 3;
      G__9109.cljs$lang$applyTo = function(arglist__9111) {
        var a = cljs.core.first(arglist__9111);
        arglist__9111 = cljs.core.next(arglist__9111);
        var b = cljs.core.first(arglist__9111);
        arglist__9111 = cljs.core.next(arglist__9111);
        var c = cljs.core.first(arglist__9111);
        var ds = cljs.core.rest(arglist__9111);
        return G__9109__delegate(a, b, c, ds);
      };
      G__9109.cljs$core$IFn$_invoke$arity$variadic = G__9109__delegate;
      return G__9109;
    }();
    G__9108 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 1:
          return G__9108__1.call(this, a);
        case 2:
          return G__9108__2.call(this, a, b);
        case 3:
          return G__9108__3.call(this, a, b, c);
        default:
          var G__9112 = null;
          if (arguments.length > 3) {
            var G__9113__i = 0, G__9113__a = new Array(arguments.length - 3);
            while (G__9113__i < G__9113__a.length) {
              G__9113__a[G__9113__i] = arguments[G__9113__i + 3];
              ++G__9113__i;
            }
            G__9112 = new cljs.core.IndexedSeq(G__9113__a, 0);
          }
          return G__9108__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__9112);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9108.cljs$lang$maxFixedArity = 3;
    G__9108.cljs$lang$applyTo = G__9108__4.cljs$lang$applyTo;
    G__9108.cljs$core$IFn$_invoke$arity$1 = G__9108__1;
    G__9108.cljs$core$IFn$_invoke$arity$2 = G__9108__2;
    G__9108.cljs$core$IFn$_invoke$arity$3 = G__9108__3;
    G__9108.cljs$core$IFn$_invoke$arity$variadic = G__9108__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9108;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = function(f, x, y) {
  return function() {
    var G__9114 = null;
    var G__9114__2 = function(a, b) {
      var G__9097 = a == null ? x : a;
      var G__9098 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9097, G__9098) : f.call(null, G__9097, G__9098);
    };
    var G__9114__3 = function(a, b, c) {
      var G__9099 = a == null ? x : a;
      var G__9100 = b == null ? y : b;
      var G__9101 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9099, G__9100, G__9101) : f.call(null, G__9099, G__9100, G__9101);
    };
    var G__9114__4 = function() {
      var G__9115__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c, ds);
      };
      var G__9115 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__9116__i = 0, G__9116__a = new Array(arguments.length - 3);
          while (G__9116__i < G__9116__a.length) {
            G__9116__a[G__9116__i] = arguments[G__9116__i + 3];
            ++G__9116__i;
          }
          ds = new cljs.core.IndexedSeq(G__9116__a, 0);
        }
        return G__9115__delegate.call(this, a, b, c, ds);
      };
      G__9115.cljs$lang$maxFixedArity = 3;
      G__9115.cljs$lang$applyTo = function(arglist__9117) {
        var a = cljs.core.first(arglist__9117);
        arglist__9117 = cljs.core.next(arglist__9117);
        var b = cljs.core.first(arglist__9117);
        arglist__9117 = cljs.core.next(arglist__9117);
        var c = cljs.core.first(arglist__9117);
        var ds = cljs.core.rest(arglist__9117);
        return G__9115__delegate(a, b, c, ds);
      };
      G__9115.cljs$core$IFn$_invoke$arity$variadic = G__9115__delegate;
      return G__9115;
    }();
    G__9114 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__9114__2.call(this, a, b);
        case 3:
          return G__9114__3.call(this, a, b, c);
        default:
          var G__9118 = null;
          if (arguments.length > 3) {
            var G__9119__i = 0, G__9119__a = new Array(arguments.length - 3);
            while (G__9119__i < G__9119__a.length) {
              G__9119__a[G__9119__i] = arguments[G__9119__i + 3];
              ++G__9119__i;
            }
            G__9118 = new cljs.core.IndexedSeq(G__9119__a, 0);
          }
          return G__9114__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__9118);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9114.cljs$lang$maxFixedArity = 3;
    G__9114.cljs$lang$applyTo = G__9114__4.cljs$lang$applyTo;
    G__9114.cljs$core$IFn$_invoke$arity$2 = G__9114__2;
    G__9114.cljs$core$IFn$_invoke$arity$3 = G__9114__3;
    G__9114.cljs$core$IFn$_invoke$arity$variadic = G__9114__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9114;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, z) {
  return function() {
    var G__9120 = null;
    var G__9120__2 = function(a, b) {
      var G__9102 = a == null ? x : a;
      var G__9103 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9102, G__9103) : f.call(null, G__9102, G__9103);
    };
    var G__9120__3 = function(a, b, c) {
      var G__9104 = a == null ? x : a;
      var G__9105 = b == null ? y : b;
      var G__9106 = c == null ? z : c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9104, G__9105, G__9106) : f.call(null, G__9104, G__9105, G__9106);
    };
    var G__9120__4 = function() {
      var G__9121__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds);
      };
      var G__9121 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__9122__i = 0, G__9122__a = new Array(arguments.length - 3);
          while (G__9122__i < G__9122__a.length) {
            G__9122__a[G__9122__i] = arguments[G__9122__i + 3];
            ++G__9122__i;
          }
          ds = new cljs.core.IndexedSeq(G__9122__a, 0);
        }
        return G__9121__delegate.call(this, a, b, c, ds);
      };
      G__9121.cljs$lang$maxFixedArity = 3;
      G__9121.cljs$lang$applyTo = function(arglist__9123) {
        var a = cljs.core.first(arglist__9123);
        arglist__9123 = cljs.core.next(arglist__9123);
        var b = cljs.core.first(arglist__9123);
        arglist__9123 = cljs.core.next(arglist__9123);
        var c = cljs.core.first(arglist__9123);
        var ds = cljs.core.rest(arglist__9123);
        return G__9121__delegate(a, b, c, ds);
      };
      G__9121.cljs$core$IFn$_invoke$arity$variadic = G__9121__delegate;
      return G__9121;
    }();
    G__9120 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__9120__2.call(this, a, b);
        case 3:
          return G__9120__3.call(this, a, b, c);
        default:
          var G__9124 = null;
          if (arguments.length > 3) {
            var G__9125__i = 0, G__9125__a = new Array(arguments.length - 3);
            while (G__9125__i < G__9125__a.length) {
              G__9125__a[G__9125__i] = arguments[G__9125__i + 3];
              ++G__9125__i;
            }
            G__9124 = new cljs.core.IndexedSeq(G__9125__a, 0);
          }
          return G__9120__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__9124);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9120.cljs$lang$maxFixedArity = 3;
    G__9120.cljs$lang$applyTo = G__9120__4.cljs$lang$applyTo;
    G__9120.cljs$core$IFn$_invoke$arity$2 = G__9120__2;
    G__9120.cljs$core$IFn$_invoke$arity$3 = G__9120__3;
    G__9120.cljs$core$IFn$_invoke$arity$variadic = G__9120__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9120;
  }();
};
cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.map_indexed = function cljs$core$map_indexed() {
  var G__9127 = arguments.length;
  switch(G__9127) {
    case 1:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var i = function() {
      var G__9128 = -1;
      return cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__9128) : cljs.core.volatile_BANG_.call(null, G__9128);
    }();
    return function(i) {
      return function() {
        var G__9159 = null;
        var G__9159__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__9159__1 = function(result) {
          var G__9129 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9129) : rf.call(null, G__9129);
        };
        var G__9159__2 = function(result, input) {
          var G__9130 = result;
          var G__9131 = function() {
            var G__9132 = cljs.core._vreset_BANG_(i, cljs.core._deref(i) + 1);
            var G__9133 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9132, G__9133) : f.call(null, G__9132, G__9133);
          }();
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9130, G__9131) : rf.call(null, G__9130, G__9131);
        };
        G__9159 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__9159__0.call(this);
            case 1:
              return G__9159__1.call(this, result);
            case 2:
              return G__9159__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__9159.cljs$core$IFn$_invoke$arity$0 = G__9159__0;
        G__9159.cljs$core$IFn$_invoke$arity$1 = G__9159__1;
        G__9159.cljs$core$IFn$_invoke$arity$2 = G__9159__2;
        return G__9159;
      }();
    }(i);
  };
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var mapi = function cljs$core$mapi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4425__auto__ = cljs.core.seq(coll__$1);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__5194__auto___9160 = size;
          var i_9161 = 0;
          while (true) {
            if (i_9161 < n__5194__auto___9160) {
              cljs.core.chunk_append(b, function() {
                var G__9154 = idx + i_9161;
                var G__9155 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_9161);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9154, G__9155) : f.call(null, G__9154, G__9155);
              }());
              var G__9162 = i_9161 + 1;
              i_9161 = G__9162;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$mapi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          return cljs.core.cons(function() {
            var G__9156 = idx;
            var G__9157 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9156, G__9157) : f.call(null, G__9156, G__9157);
          }(), cljs$core$mapi(idx + 1, cljs.core.rest(s)));
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return mapi(0, coll);
};
cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.keep = function cljs$core$keep() {
  var G__9164 = arguments.length;
  switch(G__9164) {
    case 1:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__9172 = null;
      var G__9172__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__9172__1 = function(result) {
        var G__9165 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9165) : rf.call(null, G__9165);
      };
      var G__9172__2 = function(result, input) {
        var v = function() {
          var G__9166 = input;
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9166) : f.call(null, G__9166);
        }();
        if (v == null) {
          return result;
        } else {
          var G__9167 = result;
          var G__9168 = v;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9167, G__9168) : rf.call(null, G__9167, G__9168);
        }
      };
      G__9172 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__9172__0.call(this);
          case 1:
            return G__9172__1.call(this, result);
          case 2:
            return G__9172__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__9172.cljs$core$IFn$_invoke$arity$0 = G__9172__0;
      G__9172.cljs$core$IFn$_invoke$arity$1 = G__9172__1;
      G__9172.cljs$core$IFn$_invoke$arity$2 = G__9172__2;
      return G__9172;
    }();
  };
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5194__auto___9173 = size;
        var i_9174 = 0;
        while (true) {
          if (i_9174 < n__5194__auto___9173) {
            var x_9175 = function() {
              var G__9169 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_9174);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9169) : f.call(null, G__9169);
            }();
            if (x_9175 == null) {
            } else {
              cljs.core.chunk_append(b, x_9175);
            }
            var G__9176 = i_9174 + 1;
            i_9174 = G__9176;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        var x = function() {
          var G__9170 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9170) : f.call(null, G__9170);
        }();
        if (x == null) {
          return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s));
        } else {
          return cljs.core.cons(x, cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.keep.cljs$lang$maxFixedArity = 2;
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 16386;
  this.cljs$lang$protocol_mask$partition0$ = 6455296;
};
cljs.core.Atom.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return o__$1 === other;
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var self__ = this;
  var this$__$1 = this;
  var seq__9177 = cljs.core.seq(self__.watches);
  var chunk__9178 = null;
  var count__9179 = 0;
  var i__9180 = 0;
  while (true) {
    if (i__9180 < count__9179) {
      var vec__9181 = chunk__9178.cljs$core$IIndexed$_nth$arity$2(null, i__9180);
      var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9181, 0, null);
      var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9181, 1, null);
      var G__9182_9192 = key;
      var G__9183_9193 = this$__$1;
      var G__9184_9194 = oldval;
      var G__9185_9195 = newval;
      f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9182_9192, G__9183_9193, G__9184_9194, G__9185_9195) : f.call(null, G__9182_9192, G__9183_9193, G__9184_9194, G__9185_9195);
      var G__9196 = seq__9177;
      var G__9197 = chunk__9178;
      var G__9198 = count__9179;
      var G__9199 = i__9180 + 1;
      seq__9177 = G__9196;
      chunk__9178 = G__9197;
      count__9179 = G__9198;
      i__9180 = G__9199;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__9177);
      if (temp__4425__auto__) {
        var seq__9177__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__9177__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__9177__$1);
          var G__9200 = cljs.core.chunk_rest(seq__9177__$1);
          var G__9201 = c__5094__auto__;
          var G__9202 = cljs.core.count(c__5094__auto__);
          var G__9203 = 0;
          seq__9177 = G__9200;
          chunk__9178 = G__9201;
          count__9179 = G__9202;
          i__9180 = G__9203;
          continue;
        } else {
          var vec__9186 = cljs.core.first(seq__9177__$1);
          var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9186, 0, null);
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9186, 1, null);
          var G__9187_9204 = key;
          var G__9188_9205 = this$__$1;
          var G__9189_9206 = oldval;
          var G__9190_9207 = newval;
          f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9187_9204, G__9188_9205, G__9189_9206, G__9190_9207) : f.call(null, G__9187_9204, G__9188_9205, G__9189_9206, G__9190_9207);
          var G__9208 = cljs.core.next(seq__9177__$1);
          var G__9209 = null;
          var G__9210 = 0;
          var G__9211 = 0;
          seq__9177 = G__9208;
          chunk__9178 = G__9209;
          count__9179 = G__9210;
          i__9180 = G__9211;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var self__ = this;
  var this$__$1 = this;
  this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches, key, f);
  return this$__$1;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches, key);
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var G__9191 = this$__$1;
  return goog.getUid(G__9191);
};
cljs.core.Atom.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "validator", "validator", -325659154, null), new cljs.core.Symbol(null, "watches", "watches", 1367433992, null)], null);
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Atom");
};
cljs.core.__GT_Atom = function cljs$core$__GT_Atom(state, meta, validator, watches) {
  return new cljs.core.Atom(state, meta, validator, watches);
};
cljs.core.atom = function cljs$core$atom() {
  var G__9215 = arguments.length;
  switch(G__9215) {
    case 1:
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5360__auto__);
  }
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Atom(x, null, null, null);
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = function(x, p__9216) {
  var map__9217 = p__9216;
  var map__9217__$1 = cljs.core.seq_QMARK_(map__9217) ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map, map__9217) : map__9217;
  var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9217__$1, new cljs.core.Keyword(null, "meta", "meta", 1499536964));
  var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9217__$1, new cljs.core.Keyword(null, "validator", "validator", -1966190681));
  return new cljs.core.Atom(x, meta, validator, null);
};
cljs.core.atom.cljs$lang$applyTo = function(seq9212) {
  var G__9213 = cljs.core.first(seq9212);
  var seq9212__$1 = cljs.core.next(seq9212);
  return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__9213, seq9212__$1);
};
cljs.core.atom.cljs$lang$maxFixedArity = 1;
cljs.core.reset_BANG_ = function cljs$core$reset_BANG_(a, new_value) {
  if (a instanceof cljs.core.Atom) {
    var validate = a.validator;
    if (validate == null) {
    } else {
      if (cljs.core.truth_(function() {
        var G__9221 = new_value;
        return validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__9221) : validate.call(null, G__9221);
      }())) {
      } else {
        throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(function() {
          var G__9222 = cljs.core.list(new cljs.core.Symbol(null, "validate", "validate", 1439230700, null), new cljs.core.Symbol(null, "new-value", "new-value", -1567397401, null));
          return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__9222) : cljs.core.pr_str.call(null, G__9222);
        }())].join(""));
      }
    }
    var old_value = a.state;
    a.state = new_value;
    if (a.watches == null) {
    } else {
      cljs.core._notify_watches(a, old_value, new_value);
    }
    return new_value;
  } else {
    return cljs.core._reset_BANG_(a, new_value);
  }
};
cljs.core.swap_BANG_ = function cljs$core$swap_BANG_() {
  var G__9229 = arguments.length;
  switch(G__9229) {
    case 2:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__9230 = a.state;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9230) : f.call(null, G__9230);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a, f);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__9231 = a.state;
      var G__9232 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9231, G__9232) : f.call(null, G__9231, G__9232);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a, f, x);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__9233 = a.state;
      var G__9234 = x;
      var G__9235 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9233, G__9234, G__9235) : f.call(null, G__9233, G__9234, G__9235);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a, f, x, y);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a, f, x, y, more);
  }
};
cljs.core.swap_BANG_.cljs$lang$applyTo = function(seq9223) {
  var G__9224 = cljs.core.first(seq9223);
  var seq9223__$1 = cljs.core.next(seq9223);
  var G__9225 = cljs.core.first(seq9223__$1);
  var seq9223__$2 = cljs.core.next(seq9223__$1);
  var G__9226 = cljs.core.first(seq9223__$2);
  var seq9223__$3 = cljs.core.next(seq9223__$2);
  var G__9227 = cljs.core.first(seq9223__$3);
  var seq9223__$4 = cljs.core.next(seq9223__$3);
  return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9224, G__9225, G__9226, G__9227, seq9223__$4);
};
cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.compare_and_set_BANG_ = function cljs$core$compare_and_set_BANG_(a, oldval, newval) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null), oldval)) {
    cljs.core.reset_BANG_(a, newval);
    return true;
  } else {
    return false;
  }
};
cljs.core.set_validator_BANG_ = function cljs$core$set_validator_BANG_(iref, val) {
  return iref.validator = val;
};
cljs.core.get_validator = function cljs$core$get_validator(iref) {
  return iref.validator;
};
cljs.core.Volatile = function(state) {
  this.state = state;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;
cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = function(_, new_state) {
  var self__ = this;
  var ___$1 = this;
  return self__.state = new_state;
};
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Volatile.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null)], null);
};
cljs.core.Volatile.cljs$lang$type = true;
cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Volatile");
};
cljs.core.__GT_Volatile = function cljs$core$__GT_Volatile(state) {
  return new cljs.core.Volatile(state);
};
cljs.core.volatile_BANG_ = function cljs$core$volatile_BANG_(val) {
  return new cljs.core.Volatile(val);
};
cljs.core.volatile_QMARK_ = function cljs$core$volatile_QMARK_(x) {
  return x instanceof cljs.core.Volatile;
};
cljs.core.vreset_BANG_ = function cljs$core$vreset_BANG_(vol, newval) {
  return cljs.core._vreset_BANG_(vol, newval);
};
cljs.core.keep_indexed = function cljs$core$keep_indexed() {
  var G__9238 = arguments.length;
  switch(G__9238) {
    case 1:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__9273 = null;
        var G__9273__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__9273__1 = function(result) {
          var G__9239 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9239) : rf.call(null, G__9239);
        };
        var G__9273__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          var v = function() {
            var G__9240 = i;
            var G__9241 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9240, G__9241) : f.call(null, G__9240, G__9241);
          }();
          if (v == null) {
            return result;
          } else {
            var G__9242 = result;
            var G__9243 = v;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9242, G__9243) : rf.call(null, G__9242, G__9243);
          }
        };
        G__9273 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__9273__0.call(this);
            case 1:
              return G__9273__1.call(this, result);
            case 2:
              return G__9273__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__9273.cljs$core$IFn$_invoke$arity$0 = G__9273__0;
        G__9273.cljs$core$IFn$_invoke$arity$1 = G__9273__1;
        G__9273.cljs$core$IFn$_invoke$arity$2 = G__9273__2;
        return G__9273;
      }();
    }(ia);
  };
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var keepi = function cljs$core$keepi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4425__auto__ = cljs.core.seq(coll__$1);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__5194__auto___9274 = size;
          var i_9275 = 0;
          while (true) {
            if (i_9275 < n__5194__auto___9274) {
              var x_9276 = function() {
                var G__9268 = idx + i_9275;
                var G__9269 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_9275);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9268, G__9269) : f.call(null, G__9268, G__9269);
              }();
              if (x_9276 == null) {
              } else {
                cljs.core.chunk_append(b, x_9276);
              }
              var G__9277 = i_9275 + 1;
              i_9275 = G__9277;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$keepi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          var x = function() {
            var G__9270 = idx;
            var G__9271 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9270, G__9271) : f.call(null, G__9270, G__9271);
          }();
          if (x == null) {
            return cljs$core$keepi(idx + 1, cljs.core.rest(s));
          } else {
            return cljs.core.cons(x, cljs$core$keepi(idx + 1, cljs.core.rest(s)));
          }
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return keepi(0, coll);
};
cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.every_pred = function cljs$core$every_pred() {
  var G__9289 = arguments.length;
  switch(G__9289) {
    case 1:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$ep1 = null;
    var cljs$core$ep1__0 = function() {
      return true;
    };
    var cljs$core$ep1__1 = function(x) {
      return cljs.core.boolean$(function() {
        var G__9305 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9305) : p.call(null, G__9305);
      }());
    };
    var cljs$core$ep1__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__9307 = x;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9307) : p.call(null, G__9307);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var G__9308 = y;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9308) : p.call(null, G__9308);
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep1__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__9310 = x;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9310) : p.call(null, G__9310);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__9312 = y;
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9312) : p.call(null, G__9312);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var G__9313 = z;
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9313) : p.call(null, G__9313);
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep1__4 = function() {
      var G__9475__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4297__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4297__auto__)) {
            return cljs.core.every_QMARK_(p, args);
          } else {
            return and__4297__auto__;
          }
        }());
      };
      var G__9475 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9476__i = 0, G__9476__a = new Array(arguments.length - 3);
          while (G__9476__i < G__9476__a.length) {
            G__9476__a[G__9476__i] = arguments[G__9476__i + 3];
            ++G__9476__i;
          }
          args = new cljs.core.IndexedSeq(G__9476__a, 0);
        }
        return G__9475__delegate.call(this, x, y, z, args);
      };
      G__9475.cljs$lang$maxFixedArity = 3;
      G__9475.cljs$lang$applyTo = function(arglist__9477) {
        var x = cljs.core.first(arglist__9477);
        arglist__9477 = cljs.core.next(arglist__9477);
        var y = cljs.core.first(arglist__9477);
        arglist__9477 = cljs.core.next(arglist__9477);
        var z = cljs.core.first(arglist__9477);
        var args = cljs.core.rest(arglist__9477);
        return G__9475__delegate(x, y, z, args);
      };
      G__9475.cljs$core$IFn$_invoke$arity$variadic = G__9475__delegate;
      return G__9475;
    }();
    cljs$core$ep1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep1__0.call(this);
        case 1:
          return cljs$core$ep1__1.call(this, x);
        case 2:
          return cljs$core$ep1__2.call(this, x, y);
        case 3:
          return cljs$core$ep1__3.call(this, x, y, z);
        default:
          var G__9478 = null;
          if (arguments.length > 3) {
            var G__9479__i = 0, G__9479__a = new Array(arguments.length - 3);
            while (G__9479__i < G__9479__a.length) {
              G__9479__a[G__9479__i] = arguments[G__9479__i + 3];
              ++G__9479__i;
            }
            G__9478 = new cljs.core.IndexedSeq(G__9479__a, 0);
          }
          return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9478);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep1.cljs$lang$maxFixedArity = 3;
    cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep1;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$ep2 = null;
    var cljs$core$ep2__0 = function() {
      return true;
    };
    var cljs$core$ep2__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__9345 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9345) : p1.call(null, G__9345);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var G__9346 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9346) : p2.call(null, G__9346);
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep2__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__9348 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9348) : p1.call(null, G__9348);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__9350 = y;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9350) : p1.call(null, G__9350);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__9352 = x;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9352) : p2.call(null, G__9352);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var G__9353 = y;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9353) : p2.call(null, G__9353);
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep2__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__9355 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9355) : p1.call(null, G__9355);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__9357 = y;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9357) : p1.call(null, G__9357);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__9359 = z;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9359) : p1.call(null, G__9359);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var and__4297__auto____$3 = function() {
                var G__9361 = x;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9361) : p2.call(null, G__9361);
              }();
              if (cljs.core.truth_(and__4297__auto____$3)) {
                var and__4297__auto____$4 = function() {
                  var G__9363 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9363) : p2.call(null, G__9363);
                }();
                if (cljs.core.truth_(and__4297__auto____$4)) {
                  var G__9364 = z;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9364) : p2.call(null, G__9364);
                } else {
                  return and__4297__auto____$4;
                }
              } else {
                return and__4297__auto____$3;
              }
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep2__4 = function() {
      var G__9480__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4297__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4297__auto__)) {
            return cljs.core.every_QMARK_(function(and__4297__auto__) {
              return function(p1__9278_SHARP_) {
                var and__4297__auto____$1 = function() {
                  var G__9366 = p1__9278_SHARP_;
                  return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9366) : p1.call(null, G__9366);
                }();
                if (cljs.core.truth_(and__4297__auto____$1)) {
                  var G__9367 = p1__9278_SHARP_;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9367) : p2.call(null, G__9367);
                } else {
                  return and__4297__auto____$1;
                }
              };
            }(and__4297__auto__), args);
          } else {
            return and__4297__auto__;
          }
        }());
      };
      var G__9480 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9481__i = 0, G__9481__a = new Array(arguments.length - 3);
          while (G__9481__i < G__9481__a.length) {
            G__9481__a[G__9481__i] = arguments[G__9481__i + 3];
            ++G__9481__i;
          }
          args = new cljs.core.IndexedSeq(G__9481__a, 0);
        }
        return G__9480__delegate.call(this, x, y, z, args);
      };
      G__9480.cljs$lang$maxFixedArity = 3;
      G__9480.cljs$lang$applyTo = function(arglist__9482) {
        var x = cljs.core.first(arglist__9482);
        arglist__9482 = cljs.core.next(arglist__9482);
        var y = cljs.core.first(arglist__9482);
        arglist__9482 = cljs.core.next(arglist__9482);
        var z = cljs.core.first(arglist__9482);
        var args = cljs.core.rest(arglist__9482);
        return G__9480__delegate(x, y, z, args);
      };
      G__9480.cljs$core$IFn$_invoke$arity$variadic = G__9480__delegate;
      return G__9480;
    }();
    cljs$core$ep2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep2__0.call(this);
        case 1:
          return cljs$core$ep2__1.call(this, x);
        case 2:
          return cljs$core$ep2__2.call(this, x, y);
        case 3:
          return cljs$core$ep2__3.call(this, x, y, z);
        default:
          var G__9483 = null;
          if (arguments.length > 3) {
            var G__9484__i = 0, G__9484__a = new Array(arguments.length - 3);
            while (G__9484__i < G__9484__a.length) {
              G__9484__a[G__9484__i] = arguments[G__9484__i + 3];
              ++G__9484__i;
            }
            G__9483 = new cljs.core.IndexedSeq(G__9484__a, 0);
          }
          return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9483);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep2.cljs$lang$maxFixedArity = 3;
    cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep2;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$ep3 = null;
    var cljs$core$ep3__0 = function() {
      return true;
    };
    var cljs$core$ep3__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__9413 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9413) : p1.call(null, G__9413);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__9415 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9415) : p2.call(null, G__9415);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var G__9416 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9416) : p3.call(null, G__9416);
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep3__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__9418 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9418) : p1.call(null, G__9418);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__9420 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9420) : p2.call(null, G__9420);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__9422 = x;
              return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9422) : p3.call(null, G__9422);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var and__4297__auto____$3 = function() {
                var G__9424 = y;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9424) : p1.call(null, G__9424);
              }();
              if (cljs.core.truth_(and__4297__auto____$3)) {
                var and__4297__auto____$4 = function() {
                  var G__9426 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9426) : p2.call(null, G__9426);
                }();
                if (cljs.core.truth_(and__4297__auto____$4)) {
                  var G__9427 = y;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9427) : p3.call(null, G__9427);
                } else {
                  return and__4297__auto____$4;
                }
              } else {
                return and__4297__auto____$3;
              }
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep3__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__9429 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9429) : p1.call(null, G__9429);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__9431 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9431) : p2.call(null, G__9431);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__9433 = x;
              return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9433) : p3.call(null, G__9433);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var and__4297__auto____$3 = function() {
                var G__9435 = y;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9435) : p1.call(null, G__9435);
              }();
              if (cljs.core.truth_(and__4297__auto____$3)) {
                var and__4297__auto____$4 = function() {
                  var G__9437 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9437) : p2.call(null, G__9437);
                }();
                if (cljs.core.truth_(and__4297__auto____$4)) {
                  var and__4297__auto____$5 = function() {
                    var G__9439 = y;
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9439) : p3.call(null, G__9439);
                  }();
                  if (cljs.core.truth_(and__4297__auto____$5)) {
                    var and__4297__auto____$6 = function() {
                      var G__9441 = z;
                      return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9441) : p1.call(null, G__9441);
                    }();
                    if (cljs.core.truth_(and__4297__auto____$6)) {
                      var and__4297__auto____$7 = function() {
                        var G__9443 = z;
                        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9443) : p2.call(null, G__9443);
                      }();
                      if (cljs.core.truth_(and__4297__auto____$7)) {
                        var G__9444 = z;
                        return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9444) : p3.call(null, G__9444);
                      } else {
                        return and__4297__auto____$7;
                      }
                    } else {
                      return and__4297__auto____$6;
                    }
                  } else {
                    return and__4297__auto____$5;
                  }
                } else {
                  return and__4297__auto____$4;
                }
              } else {
                return and__4297__auto____$3;
              }
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep3__4 = function() {
      var G__9485__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4297__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4297__auto__)) {
            return cljs.core.every_QMARK_(function(and__4297__auto__) {
              return function(p1__9279_SHARP_) {
                var and__4297__auto____$1 = function() {
                  var G__9446 = p1__9279_SHARP_;
                  return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9446) : p1.call(null, G__9446);
                }();
                if (cljs.core.truth_(and__4297__auto____$1)) {
                  var and__4297__auto____$2 = function() {
                    var G__9448 = p1__9279_SHARP_;
                    return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9448) : p2.call(null, G__9448);
                  }();
                  if (cljs.core.truth_(and__4297__auto____$2)) {
                    var G__9449 = p1__9279_SHARP_;
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9449) : p3.call(null, G__9449);
                  } else {
                    return and__4297__auto____$2;
                  }
                } else {
                  return and__4297__auto____$1;
                }
              };
            }(and__4297__auto__), args);
          } else {
            return and__4297__auto__;
          }
        }());
      };
      var G__9485 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9486__i = 0, G__9486__a = new Array(arguments.length - 3);
          while (G__9486__i < G__9486__a.length) {
            G__9486__a[G__9486__i] = arguments[G__9486__i + 3];
            ++G__9486__i;
          }
          args = new cljs.core.IndexedSeq(G__9486__a, 0);
        }
        return G__9485__delegate.call(this, x, y, z, args);
      };
      G__9485.cljs$lang$maxFixedArity = 3;
      G__9485.cljs$lang$applyTo = function(arglist__9487) {
        var x = cljs.core.first(arglist__9487);
        arglist__9487 = cljs.core.next(arglist__9487);
        var y = cljs.core.first(arglist__9487);
        arglist__9487 = cljs.core.next(arglist__9487);
        var z = cljs.core.first(arglist__9487);
        var args = cljs.core.rest(arglist__9487);
        return G__9485__delegate(x, y, z, args);
      };
      G__9485.cljs$core$IFn$_invoke$arity$variadic = G__9485__delegate;
      return G__9485;
    }();
    cljs$core$ep3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep3__0.call(this);
        case 1:
          return cljs$core$ep3__1.call(this, x);
        case 2:
          return cljs$core$ep3__2.call(this, x, y);
        case 3:
          return cljs$core$ep3__3.call(this, x, y, z);
        default:
          var G__9488 = null;
          if (arguments.length > 3) {
            var G__9489__i = 0, G__9489__a = new Array(arguments.length - 3);
            while (G__9489__i < G__9489__a.length) {
              G__9489__a[G__9489__i] = arguments[G__9489__i + 3];
              ++G__9489__i;
            }
            G__9488 = new cljs.core.IndexedSeq(G__9489__a, 0);
          }
          return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9488);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep3.cljs$lang$maxFixedArity = 3;
    cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep3;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$epn = null;
      var cljs$core$epn__0 = function() {
        return true;
      };
      var cljs$core$epn__1 = function(x) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__9280_SHARP_) {
            var G__9465 = x;
            return p1__9280_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9280_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9465) : p1__9280_SHARP_.call(null, G__9465);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__2 = function(x, y) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__9281_SHARP_) {
            var and__4297__auto__ = function() {
              var G__9467 = x;
              return p1__9281_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9281_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9467) : p1__9281_SHARP_.call(null, G__9467);
            }();
            if (cljs.core.truth_(and__4297__auto__)) {
              var G__9468 = y;
              return p1__9281_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9281_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9468) : p1__9281_SHARP_.call(null, G__9468);
            } else {
              return and__4297__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__3 = function(x, y, z) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__9282_SHARP_) {
            var and__4297__auto__ = function() {
              var G__9470 = x;
              return p1__9282_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9282_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9470) : p1__9282_SHARP_.call(null, G__9470);
            }();
            if (cljs.core.truth_(and__4297__auto__)) {
              var and__4297__auto____$1 = function() {
                var G__9472 = y;
                return p1__9282_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9282_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9472) : p1__9282_SHARP_.call(null, G__9472);
              }();
              if (cljs.core.truth_(and__4297__auto____$1)) {
                var G__9473 = z;
                return p1__9282_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9282_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9473) : p1__9282_SHARP_.call(null, G__9473);
              } else {
                return and__4297__auto____$1;
              }
            } else {
              return and__4297__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__4 = function() {
        var G__9490__delegate = function(x, y, z, args) {
          return cljs.core.boolean$(function() {
            var and__4297__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x, y, z);
            if (cljs.core.truth_(and__4297__auto__)) {
              return cljs.core.every_QMARK_(function(and__4297__auto__, ps__$1) {
                return function(p1__9283_SHARP_) {
                  return cljs.core.every_QMARK_(p1__9283_SHARP_, args);
                };
              }(and__4297__auto__, ps__$1), ps__$1);
            } else {
              return and__4297__auto__;
            }
          }());
        };
        var G__9490 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__9491__i = 0, G__9491__a = new Array(arguments.length - 3);
            while (G__9491__i < G__9491__a.length) {
              G__9491__a[G__9491__i] = arguments[G__9491__i + 3];
              ++G__9491__i;
            }
            args = new cljs.core.IndexedSeq(G__9491__a, 0);
          }
          return G__9490__delegate.call(this, x, y, z, args);
        };
        G__9490.cljs$lang$maxFixedArity = 3;
        G__9490.cljs$lang$applyTo = function(arglist__9492) {
          var x = cljs.core.first(arglist__9492);
          arglist__9492 = cljs.core.next(arglist__9492);
          var y = cljs.core.first(arglist__9492);
          arglist__9492 = cljs.core.next(arglist__9492);
          var z = cljs.core.first(arglist__9492);
          var args = cljs.core.rest(arglist__9492);
          return G__9490__delegate(x, y, z, args);
        };
        G__9490.cljs$core$IFn$_invoke$arity$variadic = G__9490__delegate;
        return G__9490;
      }();
      cljs$core$epn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$epn__0.call(this);
          case 1:
            return cljs$core$epn__1.call(this, x);
          case 2:
            return cljs$core$epn__2.call(this, x, y);
          case 3:
            return cljs$core$epn__3.call(this, x, y, z);
          default:
            var G__9493 = null;
            if (arguments.length > 3) {
              var G__9494__i = 0, G__9494__a = new Array(arguments.length - 3);
              while (G__9494__i < G__9494__a.length) {
                G__9494__a[G__9494__i] = arguments[G__9494__i + 3];
                ++G__9494__i;
              }
              G__9493 = new cljs.core.IndexedSeq(G__9494__a, 0);
            }
            return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9493);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$epn.cljs$lang$maxFixedArity = 3;
      cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$epn;
    }();
  }(ps__$1);
};
cljs.core.every_pred.cljs$lang$applyTo = function(seq9284) {
  var G__9285 = cljs.core.first(seq9284);
  var seq9284__$1 = cljs.core.next(seq9284);
  var G__9286 = cljs.core.first(seq9284__$1);
  var seq9284__$2 = cljs.core.next(seq9284__$1);
  var G__9287 = cljs.core.first(seq9284__$2);
  var seq9284__$3 = cljs.core.next(seq9284__$2);
  return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__9285, G__9286, G__9287, seq9284__$3);
};
cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
cljs.core.some_fn = function cljs$core$some_fn() {
  var G__9506 = arguments.length;
  switch(G__9506) {
    case 1:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$sp1 = null;
    var cljs$core$sp1__0 = function() {
      return null;
    };
    var cljs$core$sp1__1 = function(x) {
      var G__9522 = x;
      return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9522) : p.call(null, G__9522);
    };
    var cljs$core$sp1__2 = function(x, y) {
      var or__4309__auto__ = function() {
        var G__9524 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9524) : p.call(null, G__9524);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var G__9525 = y;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9525) : p.call(null, G__9525);
      }
    };
    var cljs$core$sp1__3 = function(x, y, z) {
      var or__4309__auto__ = function() {
        var G__9527 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9527) : p.call(null, G__9527);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__9529 = y;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9529) : p.call(null, G__9529);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var G__9530 = z;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9530) : p.call(null, G__9530);
        }
      }
    };
    var cljs$core$sp1__4 = function() {
      var G__9692__delegate = function(x, y, z, args) {
        var or__4309__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.some(p, args);
        }
      };
      var G__9692 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9693__i = 0, G__9693__a = new Array(arguments.length - 3);
          while (G__9693__i < G__9693__a.length) {
            G__9693__a[G__9693__i] = arguments[G__9693__i + 3];
            ++G__9693__i;
          }
          args = new cljs.core.IndexedSeq(G__9693__a, 0);
        }
        return G__9692__delegate.call(this, x, y, z, args);
      };
      G__9692.cljs$lang$maxFixedArity = 3;
      G__9692.cljs$lang$applyTo = function(arglist__9694) {
        var x = cljs.core.first(arglist__9694);
        arglist__9694 = cljs.core.next(arglist__9694);
        var y = cljs.core.first(arglist__9694);
        arglist__9694 = cljs.core.next(arglist__9694);
        var z = cljs.core.first(arglist__9694);
        var args = cljs.core.rest(arglist__9694);
        return G__9692__delegate(x, y, z, args);
      };
      G__9692.cljs$core$IFn$_invoke$arity$variadic = G__9692__delegate;
      return G__9692;
    }();
    cljs$core$sp1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp1__0.call(this);
        case 1:
          return cljs$core$sp1__1.call(this, x);
        case 2:
          return cljs$core$sp1__2.call(this, x, y);
        case 3:
          return cljs$core$sp1__3.call(this, x, y, z);
        default:
          var G__9695 = null;
          if (arguments.length > 3) {
            var G__9696__i = 0, G__9696__a = new Array(arguments.length - 3);
            while (G__9696__i < G__9696__a.length) {
              G__9696__a[G__9696__i] = arguments[G__9696__i + 3];
              ++G__9696__i;
            }
            G__9695 = new cljs.core.IndexedSeq(G__9696__a, 0);
          }
          return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9695);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp1.cljs$lang$maxFixedArity = 3;
    cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp1;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$sp2 = null;
    var cljs$core$sp2__0 = function() {
      return null;
    };
    var cljs$core$sp2__1 = function(x) {
      var or__4309__auto__ = function() {
        var G__9562 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9562) : p1.call(null, G__9562);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var G__9563 = x;
        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9563) : p2.call(null, G__9563);
      }
    };
    var cljs$core$sp2__2 = function(x, y) {
      var or__4309__auto__ = function() {
        var G__9565 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9565) : p1.call(null, G__9565);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__9567 = y;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9567) : p1.call(null, G__9567);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__9569 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9569) : p2.call(null, G__9569);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var G__9570 = y;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9570) : p2.call(null, G__9570);
          }
        }
      }
    };
    var cljs$core$sp2__3 = function(x, y, z) {
      var or__4309__auto__ = function() {
        var G__9572 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9572) : p1.call(null, G__9572);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__9574 = y;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9574) : p1.call(null, G__9574);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__9576 = z;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9576) : p1.call(null, G__9576);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var or__4309__auto____$3 = function() {
              var G__9578 = x;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9578) : p2.call(null, G__9578);
            }();
            if (cljs.core.truth_(or__4309__auto____$3)) {
              return or__4309__auto____$3;
            } else {
              var or__4309__auto____$4 = function() {
                var G__9580 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9580) : p2.call(null, G__9580);
              }();
              if (cljs.core.truth_(or__4309__auto____$4)) {
                return or__4309__auto____$4;
              } else {
                var G__9581 = z;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9581) : p2.call(null, G__9581);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp2__4 = function() {
      var G__9697__delegate = function(x, y, z, args) {
        var or__4309__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.some(function(or__4309__auto__) {
            return function(p1__9495_SHARP_) {
              var or__4309__auto____$1 = function() {
                var G__9583 = p1__9495_SHARP_;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9583) : p1.call(null, G__9583);
              }();
              if (cljs.core.truth_(or__4309__auto____$1)) {
                return or__4309__auto____$1;
              } else {
                var G__9584 = p1__9495_SHARP_;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9584) : p2.call(null, G__9584);
              }
            };
          }(or__4309__auto__), args);
        }
      };
      var G__9697 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9698__i = 0, G__9698__a = new Array(arguments.length - 3);
          while (G__9698__i < G__9698__a.length) {
            G__9698__a[G__9698__i] = arguments[G__9698__i + 3];
            ++G__9698__i;
          }
          args = new cljs.core.IndexedSeq(G__9698__a, 0);
        }
        return G__9697__delegate.call(this, x, y, z, args);
      };
      G__9697.cljs$lang$maxFixedArity = 3;
      G__9697.cljs$lang$applyTo = function(arglist__9699) {
        var x = cljs.core.first(arglist__9699);
        arglist__9699 = cljs.core.next(arglist__9699);
        var y = cljs.core.first(arglist__9699);
        arglist__9699 = cljs.core.next(arglist__9699);
        var z = cljs.core.first(arglist__9699);
        var args = cljs.core.rest(arglist__9699);
        return G__9697__delegate(x, y, z, args);
      };
      G__9697.cljs$core$IFn$_invoke$arity$variadic = G__9697__delegate;
      return G__9697;
    }();
    cljs$core$sp2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp2__0.call(this);
        case 1:
          return cljs$core$sp2__1.call(this, x);
        case 2:
          return cljs$core$sp2__2.call(this, x, y);
        case 3:
          return cljs$core$sp2__3.call(this, x, y, z);
        default:
          var G__9700 = null;
          if (arguments.length > 3) {
            var G__9701__i = 0, G__9701__a = new Array(arguments.length - 3);
            while (G__9701__i < G__9701__a.length) {
              G__9701__a[G__9701__i] = arguments[G__9701__i + 3];
              ++G__9701__i;
            }
            G__9700 = new cljs.core.IndexedSeq(G__9701__a, 0);
          }
          return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9700);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp2.cljs$lang$maxFixedArity = 3;
    cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp2;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$sp3 = null;
    var cljs$core$sp3__0 = function() {
      return null;
    };
    var cljs$core$sp3__1 = function(x) {
      var or__4309__auto__ = function() {
        var G__9630 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9630) : p1.call(null, G__9630);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__9632 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9632) : p2.call(null, G__9632);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var G__9633 = x;
          return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9633) : p3.call(null, G__9633);
        }
      }
    };
    var cljs$core$sp3__2 = function(x, y) {
      var or__4309__auto__ = function() {
        var G__9635 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9635) : p1.call(null, G__9635);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__9637 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9637) : p2.call(null, G__9637);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__9639 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9639) : p3.call(null, G__9639);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var or__4309__auto____$3 = function() {
              var G__9641 = y;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9641) : p1.call(null, G__9641);
            }();
            if (cljs.core.truth_(or__4309__auto____$3)) {
              return or__4309__auto____$3;
            } else {
              var or__4309__auto____$4 = function() {
                var G__9643 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9643) : p2.call(null, G__9643);
              }();
              if (cljs.core.truth_(or__4309__auto____$4)) {
                return or__4309__auto____$4;
              } else {
                var G__9644 = y;
                return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9644) : p3.call(null, G__9644);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__3 = function(x, y, z) {
      var or__4309__auto__ = function() {
        var G__9646 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9646) : p1.call(null, G__9646);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__9648 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9648) : p2.call(null, G__9648);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__9650 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9650) : p3.call(null, G__9650);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var or__4309__auto____$3 = function() {
              var G__9652 = y;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9652) : p1.call(null, G__9652);
            }();
            if (cljs.core.truth_(or__4309__auto____$3)) {
              return or__4309__auto____$3;
            } else {
              var or__4309__auto____$4 = function() {
                var G__9654 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9654) : p2.call(null, G__9654);
              }();
              if (cljs.core.truth_(or__4309__auto____$4)) {
                return or__4309__auto____$4;
              } else {
                var or__4309__auto____$5 = function() {
                  var G__9656 = y;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9656) : p3.call(null, G__9656);
                }();
                if (cljs.core.truth_(or__4309__auto____$5)) {
                  return or__4309__auto____$5;
                } else {
                  var or__4309__auto____$6 = function() {
                    var G__9658 = z;
                    return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9658) : p1.call(null, G__9658);
                  }();
                  if (cljs.core.truth_(or__4309__auto____$6)) {
                    return or__4309__auto____$6;
                  } else {
                    var or__4309__auto____$7 = function() {
                      var G__9660 = z;
                      return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9660) : p2.call(null, G__9660);
                    }();
                    if (cljs.core.truth_(or__4309__auto____$7)) {
                      return or__4309__auto____$7;
                    } else {
                      var G__9661 = z;
                      return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9661) : p3.call(null, G__9661);
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__4 = function() {
      var G__9702__delegate = function(x, y, z, args) {
        var or__4309__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.some(function(or__4309__auto__) {
            return function(p1__9496_SHARP_) {
              var or__4309__auto____$1 = function() {
                var G__9663 = p1__9496_SHARP_;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9663) : p1.call(null, G__9663);
              }();
              if (cljs.core.truth_(or__4309__auto____$1)) {
                return or__4309__auto____$1;
              } else {
                var or__4309__auto____$2 = function() {
                  var G__9665 = p1__9496_SHARP_;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9665) : p2.call(null, G__9665);
                }();
                if (cljs.core.truth_(or__4309__auto____$2)) {
                  return or__4309__auto____$2;
                } else {
                  var G__9666 = p1__9496_SHARP_;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9666) : p3.call(null, G__9666);
                }
              }
            };
          }(or__4309__auto__), args);
        }
      };
      var G__9702 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9703__i = 0, G__9703__a = new Array(arguments.length - 3);
          while (G__9703__i < G__9703__a.length) {
            G__9703__a[G__9703__i] = arguments[G__9703__i + 3];
            ++G__9703__i;
          }
          args = new cljs.core.IndexedSeq(G__9703__a, 0);
        }
        return G__9702__delegate.call(this, x, y, z, args);
      };
      G__9702.cljs$lang$maxFixedArity = 3;
      G__9702.cljs$lang$applyTo = function(arglist__9704) {
        var x = cljs.core.first(arglist__9704);
        arglist__9704 = cljs.core.next(arglist__9704);
        var y = cljs.core.first(arglist__9704);
        arglist__9704 = cljs.core.next(arglist__9704);
        var z = cljs.core.first(arglist__9704);
        var args = cljs.core.rest(arglist__9704);
        return G__9702__delegate(x, y, z, args);
      };
      G__9702.cljs$core$IFn$_invoke$arity$variadic = G__9702__delegate;
      return G__9702;
    }();
    cljs$core$sp3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp3__0.call(this);
        case 1:
          return cljs$core$sp3__1.call(this, x);
        case 2:
          return cljs$core$sp3__2.call(this, x, y);
        case 3:
          return cljs$core$sp3__3.call(this, x, y, z);
        default:
          var G__9705 = null;
          if (arguments.length > 3) {
            var G__9706__i = 0, G__9706__a = new Array(arguments.length - 3);
            while (G__9706__i < G__9706__a.length) {
              G__9706__a[G__9706__i] = arguments[G__9706__i + 3];
              ++G__9706__i;
            }
            G__9705 = new cljs.core.IndexedSeq(G__9706__a, 0);
          }
          return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9705);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp3.cljs$lang$maxFixedArity = 3;
    cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp3;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$spn = null;
      var cljs$core$spn__0 = function() {
        return null;
      };
      var cljs$core$spn__1 = function(x) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__9497_SHARP_) {
            var G__9682 = x;
            return p1__9497_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9497_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9682) : p1__9497_SHARP_.call(null, G__9682);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__2 = function(x, y) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__9498_SHARP_) {
            var or__4309__auto__ = function() {
              var G__9684 = x;
              return p1__9498_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9498_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9684) : p1__9498_SHARP_.call(null, G__9684);
            }();
            if (cljs.core.truth_(or__4309__auto__)) {
              return or__4309__auto__;
            } else {
              var G__9685 = y;
              return p1__9498_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9498_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9685) : p1__9498_SHARP_.call(null, G__9685);
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__3 = function(x, y, z) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__9499_SHARP_) {
            var or__4309__auto__ = function() {
              var G__9687 = x;
              return p1__9499_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9499_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9687) : p1__9499_SHARP_.call(null, G__9687);
            }();
            if (cljs.core.truth_(or__4309__auto__)) {
              return or__4309__auto__;
            } else {
              var or__4309__auto____$1 = function() {
                var G__9689 = y;
                return p1__9499_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9499_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9689) : p1__9499_SHARP_.call(null, G__9689);
              }();
              if (cljs.core.truth_(or__4309__auto____$1)) {
                return or__4309__auto____$1;
              } else {
                var G__9690 = z;
                return p1__9499_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9499_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9690) : p1__9499_SHARP_.call(null, G__9690);
              }
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__4 = function() {
        var G__9707__delegate = function(x, y, z, args) {
          var or__4309__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(or__4309__auto__)) {
            return or__4309__auto__;
          } else {
            return cljs.core.some(function(or__4309__auto__, ps__$1) {
              return function(p1__9500_SHARP_) {
                return cljs.core.some(p1__9500_SHARP_, args);
              };
            }(or__4309__auto__, ps__$1), ps__$1);
          }
        };
        var G__9707 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__9708__i = 0, G__9708__a = new Array(arguments.length - 3);
            while (G__9708__i < G__9708__a.length) {
              G__9708__a[G__9708__i] = arguments[G__9708__i + 3];
              ++G__9708__i;
            }
            args = new cljs.core.IndexedSeq(G__9708__a, 0);
          }
          return G__9707__delegate.call(this, x, y, z, args);
        };
        G__9707.cljs$lang$maxFixedArity = 3;
        G__9707.cljs$lang$applyTo = function(arglist__9709) {
          var x = cljs.core.first(arglist__9709);
          arglist__9709 = cljs.core.next(arglist__9709);
          var y = cljs.core.first(arglist__9709);
          arglist__9709 = cljs.core.next(arglist__9709);
          var z = cljs.core.first(arglist__9709);
          var args = cljs.core.rest(arglist__9709);
          return G__9707__delegate(x, y, z, args);
        };
        G__9707.cljs$core$IFn$_invoke$arity$variadic = G__9707__delegate;
        return G__9707;
      }();
      cljs$core$spn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$spn__0.call(this);
          case 1:
            return cljs$core$spn__1.call(this, x);
          case 2:
            return cljs$core$spn__2.call(this, x, y);
          case 3:
            return cljs$core$spn__3.call(this, x, y, z);
          default:
            var G__9710 = null;
            if (arguments.length > 3) {
              var G__9711__i = 0, G__9711__a = new Array(arguments.length - 3);
              while (G__9711__i < G__9711__a.length) {
                G__9711__a[G__9711__i] = arguments[G__9711__i + 3];
                ++G__9711__i;
              }
              G__9710 = new cljs.core.IndexedSeq(G__9711__a, 0);
            }
            return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9710);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$spn.cljs$lang$maxFixedArity = 3;
      cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$spn;
    }();
  }(ps__$1);
};
cljs.core.some_fn.cljs$lang$applyTo = function(seq9501) {
  var G__9502 = cljs.core.first(seq9501);
  var seq9501__$1 = cljs.core.next(seq9501);
  var G__9503 = cljs.core.first(seq9501__$1);
  var seq9501__$2 = cljs.core.next(seq9501__$1);
  var G__9504 = cljs.core.first(seq9501__$2);
  var seq9501__$3 = cljs.core.next(seq9501__$2);
  return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__9502, G__9503, G__9504, seq9501__$3);
};
cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
cljs.core.map = function cljs$core$map() {
  var G__9719 = arguments.length;
  switch(G__9719) {
    case 1:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.map.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__9735 = null;
      var G__9735__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__9735__1 = function(result) {
        var G__9720 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9720) : rf.call(null, G__9720);
      };
      var G__9735__2 = function(result, input) {
        var G__9721 = result;
        var G__9722 = function() {
          var G__9723 = input;
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9723) : f.call(null, G__9723);
        }();
        return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9721, G__9722) : rf.call(null, G__9721, G__9722);
      };
      var G__9735__3 = function() {
        var G__9736__delegate = function(result, input, inputs) {
          var G__9724 = result;
          var G__9725 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f, input, inputs);
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9724, G__9725) : rf.call(null, G__9724, G__9725);
        };
        var G__9736 = function(result, input, var_args) {
          var inputs = null;
          if (arguments.length > 2) {
            var G__9737__i = 0, G__9737__a = new Array(arguments.length - 2);
            while (G__9737__i < G__9737__a.length) {
              G__9737__a[G__9737__i] = arguments[G__9737__i + 2];
              ++G__9737__i;
            }
            inputs = new cljs.core.IndexedSeq(G__9737__a, 0);
          }
          return G__9736__delegate.call(this, result, input, inputs);
        };
        G__9736.cljs$lang$maxFixedArity = 2;
        G__9736.cljs$lang$applyTo = function(arglist__9738) {
          var result = cljs.core.first(arglist__9738);
          arglist__9738 = cljs.core.next(arglist__9738);
          var input = cljs.core.first(arglist__9738);
          var inputs = cljs.core.rest(arglist__9738);
          return G__9736__delegate(result, input, inputs);
        };
        G__9736.cljs$core$IFn$_invoke$arity$variadic = G__9736__delegate;
        return G__9736;
      }();
      G__9735 = function(result, input, var_args) {
        var inputs = var_args;
        switch(arguments.length) {
          case 0:
            return G__9735__0.call(this);
          case 1:
            return G__9735__1.call(this, result);
          case 2:
            return G__9735__2.call(this, result, input);
          default:
            var G__9739 = null;
            if (arguments.length > 2) {
              var G__9740__i = 0, G__9740__a = new Array(arguments.length - 2);
              while (G__9740__i < G__9740__a.length) {
                G__9740__a[G__9740__i] = arguments[G__9740__i + 2];
                ++G__9740__i;
              }
              G__9739 = new cljs.core.IndexedSeq(G__9740__a, 0);
            }
            return G__9735__3.cljs$core$IFn$_invoke$arity$variadic(result, input, G__9739);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__9735.cljs$lang$maxFixedArity = 2;
      G__9735.cljs$lang$applyTo = G__9735__3.cljs$lang$applyTo;
      G__9735.cljs$core$IFn$_invoke$arity$0 = G__9735__0;
      G__9735.cljs$core$IFn$_invoke$arity$1 = G__9735__1;
      G__9735.cljs$core$IFn$_invoke$arity$2 = G__9735__2;
      G__9735.cljs$core$IFn$_invoke$arity$variadic = G__9735__3.cljs$core$IFn$_invoke$arity$variadic;
      return G__9735;
    }();
  };
};
cljs.core.map.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5194__auto___9741 = size;
        var i_9742 = 0;
        while (true) {
          if (i_9742 < n__5194__auto___9741) {
            cljs.core.chunk_append(b, function() {
              var G__9726 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_9742);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9726) : f.call(null, G__9726);
            }());
            var G__9743 = i_9742 + 1;
            i_9742 = G__9743;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        return cljs.core.cons(function() {
          var G__9727 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9727) : f.call(null, G__9727);
        }(), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(function() {
        var G__9728 = cljs.core.first(s1);
        var G__9729 = cljs.core.first(s2);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9728, G__9729) : f.call(null, G__9728, G__9729);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, cljs.core.rest(s1), cljs.core.rest(s2)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    var s3 = cljs.core.seq(c3);
    if (s1 && s2 && s3) {
      return cljs.core.cons(function() {
        var G__9730 = cljs.core.first(s1);
        var G__9731 = cljs.core.first(s2);
        var G__9732 = cljs.core.first(s3);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9730, G__9731, G__9732) : f.call(null, G__9730, G__9731, G__9732);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, cljs.core.rest(s1), cljs.core.rest(s2), cljs.core.rest(s3)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  var step = function cljs$core$step(cs) {
    return new cljs.core.LazySeq(null, function() {
      var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cs);
      if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
        return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
      } else {
        return null;
      }
    }, null, null);
  };
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step) {
    return function(p1__9712_SHARP_) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f, p1__9712_SHARP_);
    };
  }(step), step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c3, cljs.core.array_seq([c2, c1], 0))));
};
cljs.core.map.cljs$lang$applyTo = function(seq9713) {
  var G__9714 = cljs.core.first(seq9713);
  var seq9713__$1 = cljs.core.next(seq9713);
  var G__9715 = cljs.core.first(seq9713__$1);
  var seq9713__$2 = cljs.core.next(seq9713__$1);
  var G__9716 = cljs.core.first(seq9713__$2);
  var seq9713__$3 = cljs.core.next(seq9713__$2);
  var G__9717 = cljs.core.first(seq9713__$3);
  var seq9713__$4 = cljs.core.next(seq9713__$3);
  return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__9714, G__9715, G__9716, G__9717, seq9713__$4);
};
cljs.core.map.cljs$lang$maxFixedArity = 4;
cljs.core.take = function cljs$core$take() {
  var G__9745 = arguments.length;
  switch(G__9745) {
    case 1:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__9750 = null;
        var G__9750__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__9750__1 = function(result) {
          var G__9746 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9746) : rf.call(null, G__9746);
        };
        var G__9750__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          var nn = cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          var result__$1 = n__$1 > 0 ? function() {
            var G__9747 = result;
            var G__9748 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9747, G__9748) : rf.call(null, G__9747, G__9748);
          }() : result;
          if (!(nn > 0)) {
            return cljs.core.ensure_reduced(result__$1);
          } else {
            return result__$1;
          }
        };
        G__9750 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__9750__0.call(this);
            case 1:
              return G__9750__1.call(this, result);
            case 2:
              return G__9750__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__9750.cljs$core$IFn$_invoke$arity$0 = G__9750__0;
        G__9750.cljs$core$IFn$_invoke$arity$1 = G__9750__1;
        G__9750.cljs$core$IFn$_invoke$arity$2 = G__9750__2;
        return G__9750;
      }();
    }(na);
  };
};
cljs.core.take.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return new cljs.core.LazySeq(null, function() {
    if (n > 0) {
      var temp__4425__auto__ = cljs.core.seq(coll);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        return cljs.core.cons(cljs.core.first(s), cljs.core.take.cljs$core$IFn$_invoke$arity$2(n - 1, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take.cljs$lang$maxFixedArity = 2;
cljs.core.drop = function cljs$core$drop() {
  var G__9752 = arguments.length;
  switch(G__9752) {
    case 1:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__9757 = null;
        var G__9757__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__9757__1 = function(result) {
          var G__9753 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9753) : rf.call(null, G__9753);
        };
        var G__9757__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          if (n__$1 > 0) {
            return result;
          } else {
            var G__9754 = result;
            var G__9755 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9754, G__9755) : rf.call(null, G__9754, G__9755);
          }
        };
        G__9757 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__9757__0.call(this);
            case 1:
              return G__9757__1.call(this, result);
            case 2:
              return G__9757__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__9757.cljs$core$IFn$_invoke$arity$0 = G__9757__0;
        G__9757.cljs$core$IFn$_invoke$arity$1 = G__9757__1;
        G__9757.cljs$core$IFn$_invoke$arity$2 = G__9757__2;
        return G__9757;
      }();
    }(na);
  };
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  var step = function(n__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (n__$1 > 0 && s) {
        var G__9758 = n__$1 - 1;
        var G__9759 = cljs.core.rest(s);
        n__$1 = G__9758;
        coll__$1 = G__9759;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(n, coll);
    };
  }(step), null, null);
};
cljs.core.drop.cljs$lang$maxFixedArity = 2;
cljs.core.drop_last = function cljs$core$drop_last() {
  var G__9761 = arguments.length;
  switch(G__9761) {
    case 1:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = function(s) {
  return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1, s);
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = function(n, s) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x, _) {
    return x;
  }, s, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s));
};
cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
cljs.core.take_last = function cljs$core$take_last(n, coll) {
  var s = cljs.core.seq(coll);
  var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll));
  while (true) {
    if (lead) {
      var G__9763 = cljs.core.next(s);
      var G__9764 = cljs.core.next(lead);
      s = G__9763;
      lead = G__9764;
      continue;
    } else {
      return s;
    }
    break;
  }
};
cljs.core.drop_while = function cljs$core$drop_while() {
  var G__9766 = arguments.length;
  switch(G__9766) {
    case 1:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    var da = cljs.core.volatile_BANG_(true);
    return function(da) {
      return function() {
        var G__9774 = null;
        var G__9774__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__9774__1 = function(result) {
          var G__9767 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9767) : rf.call(null, G__9767);
        };
        var G__9774__2 = function(result, input) {
          var drop_QMARK_ = cljs.core.deref(da);
          if (cljs.core.truth_(function() {
            var and__4297__auto__ = drop_QMARK_;
            if (cljs.core.truth_(and__4297__auto__)) {
              var G__9768 = input;
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9768) : pred.call(null, G__9768);
            } else {
              return and__4297__auto__;
            }
          }())) {
            return result;
          } else {
            cljs.core.vreset_BANG_(da, null);
            var G__9769 = result;
            var G__9770 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9769, G__9770) : rf.call(null, G__9769, G__9770);
          }
        };
        G__9774 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__9774__0.call(this);
            case 1:
              return G__9774__1.call(this, result);
            case 2:
              return G__9774__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__9774.cljs$core$IFn$_invoke$arity$0 = G__9774__0;
        G__9774.cljs$core$IFn$_invoke$arity$1 = G__9774__1;
        G__9774.cljs$core$IFn$_invoke$arity$2 = G__9774__2;
        return G__9774;
      }();
    }(da);
  };
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  var step = function(pred__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (cljs.core.truth_(function() {
        var and__4297__auto__ = s;
        if (and__4297__auto__) {
          var G__9772 = cljs.core.first(s);
          return pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__9772) : pred__$1.call(null, G__9772);
        } else {
          return and__4297__auto__;
        }
      }())) {
        var G__9775 = pred__$1;
        var G__9776 = cljs.core.rest(s);
        pred__$1 = G__9775;
        coll__$1 = G__9776;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(pred, coll);
    };
  }(step), null, null);
};
cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
cljs.core.cycle = function cljs$core$cycle(coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s, cljs$core$cycle(s));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.split_at = function cljs$core$split_at(n, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, coll), cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll)], null);
};
cljs.core.repeat = function cljs$core$repeat() {
  var G__9779 = arguments.length;
  switch(G__9779) {
    case 1:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(x, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
  }, null, null);
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = function(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeat.cljs$lang$maxFixedArity = 2;
cljs.core.replicate = function cljs$core$replicate(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeatedly = function cljs$core$repeatedly() {
  var G__9782 = arguments.length;
  switch(G__9782) {
    case 1:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    }(), cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
  }, null, null);
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = function(n, f) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
};
cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
cljs.core.iterate = function cljs$core$iterate(f, x) {
  return cljs.core.cons(x, new cljs.core.LazySeq(null, function() {
    return cljs$core$iterate(f, function() {
      var G__9787 = x;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9787) : f.call(null, G__9787);
    }());
  }, null, null));
};
cljs.core.interleave = function cljs$core$interleave() {
  var G__9792 = arguments.length;
  switch(G__9792) {
    case 2:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = function(c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(cljs.core.first(s1), cljs.core.cons(cljs.core.first(s2), cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1), cljs.core.rest(s2))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = function(c1, c2, colls) {
  return new cljs.core.LazySeq(null, function() {
    var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c2, cljs.core.array_seq([c1], 0)));
    if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$lang$applyTo = function(seq9788) {
  var G__9789 = cljs.core.first(seq9788);
  var seq9788__$1 = cljs.core.next(seq9788);
  var G__9790 = cljs.core.first(seq9788__$1);
  var seq9788__$2 = cljs.core.next(seq9788__$1);
  return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__9789, G__9790, seq9788__$2);
};
cljs.core.interleave.cljs$lang$maxFixedArity = 2;
cljs.core.interpose = function cljs$core$interpose() {
  var G__9795 = arguments.length;
  switch(G__9795) {
    case 1:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = function(sep) {
  return function(rf) {
    var started = cljs.core.volatile_BANG_(false);
    return function(started) {
      return function() {
        var G__9804 = null;
        var G__9804__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__9804__1 = function(result) {
          var G__9796 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9796) : rf.call(null, G__9796);
        };
        var G__9804__2 = function(result, input) {
          if (cljs.core.truth_(cljs.core.deref(started))) {
            var sepr = function() {
              var G__9797 = result;
              var G__9798 = sep;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9797, G__9798) : rf.call(null, G__9797, G__9798);
            }();
            if (cljs.core.reduced_QMARK_(sepr)) {
              return sepr;
            } else {
              var G__9799 = sepr;
              var G__9800 = input;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9799, G__9800) : rf.call(null, G__9799, G__9800);
            }
          } else {
            cljs.core.vreset_BANG_(started, true);
            var G__9801 = result;
            var G__9802 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9801, G__9802) : rf.call(null, G__9801, G__9802);
          }
        };
        G__9804 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__9804__0.call(this);
            case 1:
              return G__9804__1.call(this, result);
            case 2:
              return G__9804__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__9804.cljs$core$IFn$_invoke$arity$0 = G__9804__0;
        G__9804.cljs$core$IFn$_invoke$arity$1 = G__9804__1;
        G__9804.cljs$core$IFn$_invoke$arity$2 = G__9804__2;
        return G__9804;
      }();
    }(started);
  };
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = function(sep, coll) {
  return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1, cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep), coll));
};
cljs.core.interpose.cljs$lang$maxFixedArity = 2;
cljs.core.flatten1 = function cljs$core$flatten1(colls) {
  var cat = function cljs$core$flatten1_$_cat(coll, colls__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4423__auto__ = cljs.core.seq(coll);
      if (temp__4423__auto__) {
        var coll__$1 = temp__4423__auto__;
        return cljs.core.cons(cljs.core.first(coll__$1), cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1), colls__$1));
      } else {
        if (cljs.core.seq(colls__$1)) {
          return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1), cljs.core.rest(colls__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(null, colls);
};
cljs.core.mapcat = function cljs$core$mapcat() {
  var G__9816 = arguments.length;
  switch(G__9816) {
    case 1:
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5360__auto__);
  }
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f), cljs.core.cat);
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = function(f, colls) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat, cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map, f, colls));
};
cljs.core.mapcat.cljs$lang$applyTo = function(seq9813) {
  var G__9814 = cljs.core.first(seq9813);
  var seq9813__$1 = cljs.core.next(seq9813);
  return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__9814, seq9813__$1);
};
cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
cljs.core.filter = function cljs$core$filter() {
  var G__9819 = arguments.length;
  switch(G__9819) {
    case 1:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__9827 = null;
      var G__9827__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__9827__1 = function(result) {
        var G__9820 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9820) : rf.call(null, G__9820);
      };
      var G__9827__2 = function(result, input) {
        if (cljs.core.truth_(function() {
          var G__9821 = input;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9821) : pred.call(null, G__9821);
        }())) {
          var G__9822 = result;
          var G__9823 = input;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9822, G__9823) : rf.call(null, G__9822, G__9823);
        } else {
          return result;
        }
      };
      G__9827 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__9827__0.call(this);
          case 1:
            return G__9827__1.call(this, result);
          case 2:
            return G__9827__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__9827.cljs$core$IFn$_invoke$arity$0 = G__9827__0;
      G__9827.cljs$core$IFn$_invoke$arity$1 = G__9827__1;
      G__9827.cljs$core$IFn$_invoke$arity$2 = G__9827__2;
      return G__9827;
    }();
  };
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5194__auto___9828 = size;
        var i_9829 = 0;
        while (true) {
          if (i_9829 < n__5194__auto___9828) {
            if (cljs.core.truth_(function() {
              var G__9824 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_9829);
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9824) : pred.call(null, G__9824);
            }())) {
              cljs.core.chunk_append(b, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_9829));
            } else {
            }
            var G__9830 = i_9829 + 1;
            i_9829 = G__9830;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.chunk_rest(s)));
      } else {
        var f = cljs.core.first(s);
        var r = cljs.core.rest(s);
        if (cljs.core.truth_(function() {
          var G__9825 = f;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9825) : pred.call(null, G__9825);
        }())) {
          return cljs.core.cons(f, cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r));
        } else {
          return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r);
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.filter.cljs$lang$maxFixedArity = 2;
cljs.core.remove = function cljs$core$remove() {
  var G__9832 = arguments.length;
  switch(G__9832) {
    case 1:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred), coll);
};
cljs.core.remove.cljs$lang$maxFixedArity = 2;
cljs.core.tree_seq = function cljs$core$tree_seq(branch_QMARK_, children, root) {
  var walk = function cljs$core$tree_seq_$_walk(node) {
    return new cljs.core.LazySeq(null, function() {
      return cljs.core.cons(node, cljs.core.truth_(function() {
        var G__9840 = node;
        return branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__9840) : branch_QMARK_.call(null, G__9840);
      }()) ? cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk, cljs.core.array_seq([function() {
        var G__9841 = node;
        return children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__9841) : children.call(null, G__9841);
      }()], 0)) : null);
    }, null, null);
  };
  return walk(root);
};
cljs.core.flatten = function cljs$core$flatten(x) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__9842_SHARP_) {
    return !cljs.core.sequential_QMARK_(p1__9842_SHARP_);
  }, cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_, cljs.core.seq, x)));
};
cljs.core.into = function cljs$core$into() {
  var G__9844 = arguments.length;
  switch(G__9844) {
    case 2:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$2 = function(to, from) {
  if (!(to == null)) {
    if (function() {
      var G__9845 = to;
      if (G__9845) {
        var bit__4976__auto__ = G__9845.cljs$lang$protocol_mask$partition1$ & 4;
        if (bit__4976__auto__ || G__9845.cljs$core$IEditableCollection$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
    } else {
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, to, from);
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, from);
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$3 = function(to, xform, from) {
  if (function() {
    var G__9846 = to;
    if (G__9846) {
      var bit__4976__auto__ = G__9846.cljs$lang$protocol_mask$partition1$ & 4;
      if (bit__4976__auto__ || G__9846.cljs$core$IEditableCollection$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
  } else {
    return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj, to, from);
  }
};
cljs.core.into.cljs$lang$maxFixedArity = 3;
cljs.core.mapv = function cljs$core$mapv() {
  var G__9854 = arguments.length;
  switch(G__9854) {
    case 2:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, function() {
      var G__9855 = o;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9855) : f.call(null, G__9855);
    }());
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, c1, c2));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, c1, c2, c3));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map, f, c1, c2, c3, cljs.core.array_seq([colls], 0)));
};
cljs.core.mapv.cljs$lang$applyTo = function(seq9848) {
  var G__9849 = cljs.core.first(seq9848);
  var seq9848__$1 = cljs.core.next(seq9848);
  var G__9850 = cljs.core.first(seq9848__$1);
  var seq9848__$2 = cljs.core.next(seq9848__$1);
  var G__9851 = cljs.core.first(seq9848__$2);
  var seq9848__$3 = cljs.core.next(seq9848__$2);
  var G__9852 = cljs.core.first(seq9848__$3);
  var seq9848__$4 = cljs.core.next(seq9848__$3);
  return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__9849, G__9850, G__9851, G__9852, seq9848__$4);
};
cljs.core.mapv.cljs$lang$maxFixedArity = 4;
cljs.core.filterv = function cljs$core$filterv(pred, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    if (cljs.core.truth_(function() {
      var G__9858 = o;
      return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9858) : pred.call(null, G__9858);
    }())) {
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, o);
    } else {
      return v;
    }
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.partition = function cljs$core$partition() {
  var G__9860 = arguments.length;
  switch(G__9860) {
    case 2:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = function(n, step, pad, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n, step, pad, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return cljs.core._conj(cljs.core.List.EMPTY, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p, pad)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$lang$maxFixedArity = 4;
cljs.core.get_in = function cljs$core$get_in() {
  var G__9863 = arguments.length;
  switch(G__9863) {
    case 2:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = function(m, ks) {
  return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m, ks, null);
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = function(m, ks, not_found) {
  var sentinel = cljs.core.lookup_sentinel;
  var m__$1 = m;
  var ks__$1 = cljs.core.seq(ks);
  while (true) {
    if (ks__$1) {
      if (!function() {
        var G__9864 = m__$1;
        if (G__9864) {
          var bit__4983__auto__ = G__9864.cljs$lang$protocol_mask$partition0$ & 256;
          if (bit__4983__auto__ || G__9864.cljs$core$ILookup$) {
            return true;
          } else {
            if (!G__9864.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, G__9864);
            } else {
              return false;
            }
          }
        } else {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, G__9864);
        }
      }()) {
        return not_found;
      } else {
        var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1, cljs.core.first(ks__$1), sentinel);
        if (sentinel === m__$2) {
          return not_found;
        } else {
          var G__9866 = sentinel;
          var G__9867 = m__$2;
          var G__9868 = cljs.core.next(ks__$1);
          sentinel = G__9866;
          m__$1 = G__9867;
          ks__$1 = G__9868;
          continue;
        }
      }
    } else {
      return m__$1;
    }
    break;
  }
};
cljs.core.get_in.cljs$lang$maxFixedArity = 3;
cljs.core.assoc_in = function cljs$core$assoc_in(m, p__9869, v) {
  var vec__9874 = p__9869;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9874, 0, null);
  var ks = cljs.core.nthnext(vec__9874, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, v));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
  }
};
cljs.core.update_in = function cljs$core$update_in() {
  var G__9883 = arguments.length;
  switch(G__9883) {
    case 3:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5360__auto__);
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = function(m, p__9884, f) {
  var vec__9885 = p__9884;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9885, 0, null);
  var ks = cljs.core.nthnext(vec__9885, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__9886 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9886) : f.call(null, G__9886);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = function(m, p__9887, f, a) {
  var vec__9888 = p__9887;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9888, 0, null);
  var ks = cljs.core.nthnext(vec__9888, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__9889 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__9890 = a;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9889, G__9890) : f.call(null, G__9889, G__9890);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = function(m, p__9891, f, a, b) {
  var vec__9892 = p__9891;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9892, 0, null);
  var ks = cljs.core.nthnext(vec__9892, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__9893 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__9894 = a;
      var G__9895 = b;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9893, G__9894, G__9895) : f.call(null, G__9893, G__9894, G__9895);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = function(m, p__9896, f, a, b, c) {
  var vec__9897 = p__9896;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9897, 0, null);
  var ks = cljs.core.nthnext(vec__9897, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b, c));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__9898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__9899 = a;
      var G__9900 = b;
      var G__9901 = c;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9898, G__9899, G__9900, G__9901) : f.call(null, G__9898, G__9899, G__9900, G__9901);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = function(m, p__9902, f, a, b, c, args) {
  var vec__9903 = p__9902;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9903, 0, null);
  var ks = cljs.core.nthnext(vec__9903, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, cljs.core.array_seq([b, c, args], 0)));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), a, b, c, cljs.core.array_seq([args], 0)));
  }
};
cljs.core.update_in.cljs$lang$applyTo = function(seq9875) {
  var G__9876 = cljs.core.first(seq9875);
  var seq9875__$1 = cljs.core.next(seq9875);
  var G__9877 = cljs.core.first(seq9875__$1);
  var seq9875__$2 = cljs.core.next(seq9875__$1);
  var G__9878 = cljs.core.first(seq9875__$2);
  var seq9875__$3 = cljs.core.next(seq9875__$2);
  var G__9879 = cljs.core.first(seq9875__$3);
  var seq9875__$4 = cljs.core.next(seq9875__$3);
  var G__9880 = cljs.core.first(seq9875__$4);
  var seq9875__$5 = cljs.core.next(seq9875__$4);
  var G__9881 = cljs.core.first(seq9875__$5);
  var seq9875__$6 = cljs.core.next(seq9875__$5);
  return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__9876, G__9877, G__9878, G__9879, G__9880, G__9881, seq9875__$6);
};
cljs.core.update_in.cljs$lang$maxFixedArity = 6;
cljs.core.update = function cljs$core$update() {
  var G__9913 = arguments.length;
  switch(G__9913) {
    case 3:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5360__auto__);
  }
};
cljs.core.update.cljs$core$IFn$_invoke$arity$3 = function(m, k, f) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__9914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9914) : f.call(null, G__9914);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$4 = function(m, k, f, x) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__9915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__9916 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9915, G__9916) : f.call(null, G__9915, G__9916);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$5 = function(m, k, f, x, y) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__9917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__9918 = x;
    var G__9919 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9917, G__9918, G__9919) : f.call(null, G__9917, G__9918, G__9919);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$6 = function(m, k, f, x, y, z) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__9920 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__9921 = x;
    var G__9922 = y;
    var G__9923 = z;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9920, G__9921, G__9922, G__9923) : f.call(null, G__9920, G__9921, G__9922, G__9923);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = function(m, k, f, x, y, z, more) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), x, y, z, cljs.core.array_seq([more], 0)));
};
cljs.core.update.cljs$lang$applyTo = function(seq9905) {
  var G__9906 = cljs.core.first(seq9905);
  var seq9905__$1 = cljs.core.next(seq9905);
  var G__9907 = cljs.core.first(seq9905__$1);
  var seq9905__$2 = cljs.core.next(seq9905__$1);
  var G__9908 = cljs.core.first(seq9905__$2);
  var seq9905__$3 = cljs.core.next(seq9905__$2);
  var G__9909 = cljs.core.first(seq9905__$3);
  var seq9905__$4 = cljs.core.next(seq9905__$3);
  var G__9910 = cljs.core.first(seq9905__$4);
  var seq9905__$5 = cljs.core.next(seq9905__$4);
  var G__9911 = cljs.core.first(seq9905__$5);
  var seq9905__$6 = cljs.core.next(seq9905__$5);
  return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__9906, G__9907, G__9908, G__9909, G__9910, G__9911, seq9905__$6);
};
cljs.core.update.cljs$lang$maxFixedArity = 6;
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr;
};
cljs.core.VectorNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/VectorNode");
};
cljs.core.__GT_VectorNode = function cljs$core$__GT_VectorNode(edit, arr) {
  return new cljs.core.VectorNode(edit, arr);
};
cljs.core.pv_fresh_node = function cljs$core$pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
};
cljs.core.pv_aget = function cljs$core$pv_aget(node, idx) {
  return node.arr[idx];
};
cljs.core.pv_aset = function cljs$core$pv_aset(node, idx, val) {
  return node.arr[idx] = val;
};
cljs.core.pv_clone_node = function cljs$core$pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone(node.arr));
};
cljs.core.tail_off = function cljs$core$tail_off(pv) {
  var cnt = pv.cnt;
  if (cnt < 32) {
    return 0;
  } else {
    return cnt - 1 >>> 5 << 5;
  }
};
cljs.core.new_path = function cljs$core$new_path(edit, level, node) {
  var ll = level;
  var ret = node;
  while (true) {
    if (ll === 0) {
      return ret;
    } else {
      var embed = ret;
      var r = cljs.core.pv_fresh_node(edit);
      var _ = cljs.core.pv_aset(r, 0, embed);
      var G__9925 = ll - 5;
      var G__9926 = r;
      ll = G__9925;
      ret = G__9926;
      continue;
    }
    break;
  }
};
cljs.core.push_tail = function cljs$core$push_tail(pv, level, parent, tailnode) {
  var ret = cljs.core.pv_clone_node(parent);
  var subidx = pv.cnt - 1 >>> level & 31;
  if (5 === level) {
    cljs.core.pv_aset(ret, subidx, tailnode);
    return ret;
  } else {
    var child = cljs.core.pv_aget(parent, subidx);
    if (!(child == null)) {
      var node_to_insert = cljs$core$push_tail(pv, level - 5, child, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    } else {
      var node_to_insert = cljs.core.new_path(null, level - 5, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    }
  }
};
cljs.core.vector_index_out_of_bounds = function cljs$core$vector_index_out_of_bounds(i, cnt) {
  throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(cnt)].join(""));
};
cljs.core.first_array_for_longvec = function cljs$core$first_array_for_longvec(pv) {
  var node = pv.root;
  var level = pv.shift;
  while (true) {
    if (level > 0) {
      var G__9931 = cljs.core.pv_aget(node, 0);
      var G__9932 = level - 5;
      node = G__9931;
      level = G__9932;
      continue;
    } else {
      return node.arr;
    }
    break;
  }
};
cljs.core.unchecked_array_for = function cljs$core$unchecked_array_for(pv, i) {
  if (i >= cljs.core.tail_off(pv)) {
    return pv.tail;
  } else {
    var node = pv.root;
    var level = pv.shift;
    while (true) {
      if (level > 0) {
        var G__9933 = cljs.core.pv_aget(node, i >>> level & 31);
        var G__9934 = level - 5;
        node = G__9933;
        level = G__9934;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.array_for = function cljs$core$array_for(pv, i) {
  if (0 <= i && i < pv.cnt) {
    return cljs.core.unchecked_array_for(pv, i);
  } else {
    return cljs.core.vector_index_out_of_bounds(i, pv.cnt);
  }
};
cljs.core.do_assoc = function cljs$core$do_assoc(pv, level, node, i, val) {
  var ret = cljs.core.pv_clone_node(node);
  if (level === 0) {
    cljs.core.pv_aset(ret, i & 31, val);
    return ret;
  } else {
    var subidx = i >>> level & 31;
    cljs.core.pv_aset(ret, subidx, cljs$core$do_assoc(pv, level - 5, cljs.core.pv_aget(node, subidx), i, val));
    return ret;
  }
};
cljs.core.pop_tail = function cljs$core$pop_tail(pv, level, node) {
  var subidx = pv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$pop_tail(pv, level - 5, cljs.core.pv_aget(node, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, new_child);
      return ret;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, null);
      return ret;
    }
  }
};
cljs.core.RangedIterator = function(i, base, arr, v, start, end) {
  this.i = i;
  this.base = base;
  this.arr = arr;
  this.v = v;
  this.start = start;
  this.end = end;
};
cljs.core.RangedIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return self__.i < self__.end;
};
cljs.core.RangedIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (self__.i - self__.base === 32) {
    self__.arr = cljs.core.unchecked_array_for(self__.v, self__.i);
    self__.base = self__.base + 32;
  } else {
  }
  var ret = self__.arr[self__.i & 31];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.RangedIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "base", "base", 1825810849, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.RangedIterator.cljs$lang$type = true;
cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RangedIterator");
};
cljs.core.__GT_RangedIterator = function cljs$core$__GT_RangedIterator(i, base, arr, v, start, end) {
  return new cljs.core.RangedIterator(i, base, arr, v, start, end);
};
cljs.core.ranged_iterator = function cljs$core$ranged_iterator(v, start, end) {
  var i = start;
  return new cljs.core.RangedIterator(i, i - i % 32, start < cljs.core.count(v) ? cljs.core.unchecked_array_for(v, i) : null, v, start, end);
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167668511;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentVector.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentVector.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__9944 = init__$2;
              var G__9945 = j + i;
              var G__9946 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9944, G__9945, G__9946) : f.call(null, G__9944, G__9945, G__9946);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__9957 = j + 1;
              var G__9958 = init__$3;
              j = G__9957;
              init__$2 = G__9958;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__9947 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9947) : cljs.core.deref.call(null, G__9947);
      } else {
        var G__9959 = i + len;
        var G__9960 = init__$2;
        i = G__9959;
        init__$1 = G__9960;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_for(coll__$1, n)[n & 31];
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core.unchecked_array_for(coll__$1, n)[n & 31];
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    if (cljs.core.tail_off(coll__$1) <= n) {
      var new_tail = cljs.core.aclone(self__.tail);
      new_tail[n & 31] = val;
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, new_tail, null);
    } else {
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, cljs.core.do_assoc(coll__$1, self__.shift, self__.root, n, val), self__.tail, null);
    }
  } else {
    if (n === self__.cnt) {
      return cljs.core._conj(coll__$1, val);
    } else {
      throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds  [0,"), cljs.core.str(self__.cnt), cljs.core.str("]")].join(""));
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.ranged_iterator(this$__$1, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 0);
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 1);
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, self__.cnt - 1);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    throw new Error("Can't pop empty vector");
  } else {
    if (1 === self__.cnt) {
      return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
    } else {
      if (1 < self__.cnt - cljs.core.tail_off(coll__$1)) {
        return new cljs.core.PersistentVector(self__.meta, self__.cnt - 1, self__.shift, self__.root, self__.tail.slice(0, -1), null);
      } else {
        var new_tail = cljs.core.unchecked_array_for(coll__$1, self__.cnt - 2);
        var nr = cljs.core.pop_tail(coll__$1, self__.shift, self__.root);
        var new_root = nr == null ? cljs.core.PersistentVector.EMPTY_NODE : nr;
        var cnt_1 = self__.cnt - 1;
        if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift - 5, cljs.core.pv_aget(new_root, 0), new_tail, null);
        } else {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift, new_root, new_tail, null);
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return new cljs.core.RSeq(coll__$1, self__.cnt - 1, null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (other instanceof cljs.core.PersistentVector) {
    if (self__.cnt === cljs.core.count(other)) {
      var me_iter = cljs.core._iterator(coll__$1);
      var you_iter = cljs.core._iterator(other);
      while (true) {
        if (cljs.core.truth_(me_iter.hasNext())) {
          var x = me_iter.next();
          var y = you_iter.next();
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
            continue;
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_sequential(coll__$1, other);
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientVector(self__.cnt, self__.shift, function() {
    var G__9948 = self__.root;
    return cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__9948) : cljs.core.tv_editable_root.call(null, G__9948);
  }(), function() {
    var G__9949 = self__.tail;
    return cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__9949) : cljs.core.tv_editable_tail.call(null, G__9949);
  }());
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var self__ = this;
  var v__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1, f);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__9950 = init__$2;
              var G__9951 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9950, G__9951) : f.call(null, G__9950, G__9951);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__9961 = j + 1;
              var G__9962 = init__$3;
              j = G__9961;
              init__$2 = G__9962;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__9952 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9952) : cljs.core.deref.call(null, G__9952);
      } else {
        var G__9963 = i + len;
        var G__9964 = init__$2;
        i = G__9963;
        init__$1 = G__9964;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._assoc_n(coll__$1, k, v);
  } else {
    throw new Error("Vector's key for assoc must be a number.");
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    return null;
  } else {
    if (self__.cnt <= 32) {
      return new cljs.core.IndexedSeq(self__.tail, 0);
    } else {
      var G__9953 = coll__$1;
      var G__9954 = cljs.core.first_array_for_longvec(coll__$1);
      var G__9955 = 0;
      var G__9956 = 0;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9953, G__9954, G__9955, G__9956) : cljs.core.chunked_seq.call(null, G__9953, G__9954, G__9955, G__9956);
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(meta__$1, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt - cljs.core.tail_off(coll__$1) < 32) {
    var len = self__.tail.length;
    var new_tail = new Array(len + 1);
    var n__5194__auto___9965 = len;
    var i_9966 = 0;
    while (true) {
      if (i_9966 < n__5194__auto___9965) {
        new_tail[i_9966] = self__.tail[i_9966];
        var G__9967 = i_9966 + 1;
        i_9966 = G__9967;
        continue;
      } else {
      }
      break;
    }
    new_tail[len] = o;
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, self__.shift, self__.root, new_tail, null);
  } else {
    var root_overflow_QMARK_ = self__.cnt >>> 5 > 1 << self__.shift;
    var new_shift = root_overflow_QMARK_ ? self__.shift + 5 : self__.shift;
    var new_root = root_overflow_QMARK_ ? function() {
      var n_r = cljs.core.pv_fresh_node(null);
      cljs.core.pv_aset(n_r, 0, self__.root);
      cljs.core.pv_aset(n_r, 1, cljs.core.new_path(null, self__.shift, new cljs.core.VectorNode(null, self__.tail)));
      return n_r;
    }() : cljs.core.push_tail(coll__$1, self__.shift, self__.root, new cljs.core.VectorNode(null, self__.tail));
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, new_shift, new_root, [o], null);
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__9968 = null;
  var G__9968__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__9968__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__9968 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9968__2.call(this, self__, k);
      case 3:
        return G__9968__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9968.cljs$core$IFn$_invoke$arity$2 = G__9968__2;
  G__9968.cljs$core$IFn$_invoke$arity$3 = G__9968__3;
  return G__9968;
}();
cljs.core.PersistentVector.prototype.apply = function(self__, args9943) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args9943)));
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.PersistentVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";
cljs.core.PersistentVector.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentVector");
};
cljs.core.__GT_PersistentVector = function cljs$core$__GT_PersistentVector(meta, cnt, shift, root, tail, __hash) {
  return new cljs.core.PersistentVector(meta, cnt, shift, root, tail, __hash);
};
cljs.core.PersistentVector.EMPTY_NODE = new cljs.core.VectorNode(null, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l = xs.length;
  var xs__$1 = no_clone ? xs : cljs.core.aclone(xs);
  if (l < 32) {
    return new cljs.core.PersistentVector(null, l, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__$1, null);
  } else {
    var node = xs__$1.slice(0, 32);
    var v = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node, null);
    var i = 32;
    var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
    while (true) {
      if (i < l) {
        var G__9969 = i + 1;
        var G__9970 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out, xs__$1[i]);
        i = G__9969;
        out = G__9970;
        continue;
      } else {
        return cljs.core.persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.vec = function cljs$core$vec(coll) {
  if (cljs.core.array_QMARK_(coll)) {
    return cljs.core.PersistentVector.fromArray(coll, true);
  } else {
    return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core._as_transient(cljs.core.PersistentVector.EMPTY), coll));
  }
};
cljs.core.vector = function cljs$core$vector() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = function(args) {
  if (args instanceof cljs.core.IndexedSeq && args.i === 0) {
    return cljs.core.PersistentVector.fromArray(args.arr, true);
  } else {
    return cljs.core.vec(args);
  }
};
cljs.core.vector.cljs$lang$maxFixedArity = 0;
cljs.core.vector.cljs$lang$applyTo = function(seq9971) {
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9971));
};
cljs.core.ChunkedSeq = function(vec, node, i, off, meta, __hash) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375020;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__9972 = self__.vec;
      var G__9973 = self__.node;
      var G__9974 = self__.i;
      var G__9975 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9972, G__9973, G__9974, G__9975) : cljs.core.chunked_seq.call(null, G__9972, G__9973, G__9974, G__9975);
    }();
    if (s == null) {
      return null;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_next(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(function() {
    var G__9976 = self__.vec;
    var G__9977 = self__.i + self__.off;
    var G__9978 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9976, G__9977, G__9978) : cljs.core.subvec.call(null, G__9976, G__9977, G__9978);
  }(), f);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(function() {
    var G__9979 = self__.vec;
    var G__9980 = self__.i + self__.off;
    var G__9981 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9979, G__9980, G__9981) : cljs.core.subvec.call(null, G__9979, G__9980, G__9981);
  }(), f, start);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.node[self__.off];
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__9982 = self__.vec;
      var G__9983 = self__.node;
      var G__9984 = self__.i;
      var G__9985 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9982, G__9983, G__9984, G__9985) : cljs.core.chunked_seq.call(null, G__9982, G__9983, G__9984, G__9985);
    }();
    if (s == null) {
      return cljs.core.List.EMPTY;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_rest(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node, self__.off);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__9986 = self__.vec;
    var G__9987 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__9988 = end;
    var G__9989 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9986, G__9987, G__9988, G__9989) : cljs.core.chunked_seq.call(null, G__9986, G__9987, G__9988, G__9989);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  var G__9990 = self__.vec;
  var G__9991 = self__.node;
  var G__9992 = self__.i;
  var G__9993 = self__.off;
  var G__9994 = m;
  return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__9990, G__9991, G__9992, G__9993, G__9994) : cljs.core.chunked_seq.call(null, G__9990, G__9991, G__9992, G__9993, G__9994);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__9995 = self__.vec;
    var G__9996 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__9997 = end;
    var G__9998 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9995, G__9996, G__9997, G__9998) : cljs.core.chunked_seq.call(null, G__9995, G__9996, G__9997, G__9998);
  } else {
    return null;
  }
};
cljs.core.ChunkedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "vec", "vec", 982683596, null), new cljs.core.Symbol(null, "node", "node", -2073234571, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";
cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ChunkedSeq");
};
cljs.core.__GT_ChunkedSeq = function cljs$core$__GT_ChunkedSeq(vec, node, i, off, meta, __hash) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, __hash);
};
cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.chunked_seq = function cljs$core$chunked_seq() {
  var G__10000 = arguments.length;
  switch(G__10000) {
    case 3:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = function(vec, i, off) {
  return new cljs.core.ChunkedSeq(vec, cljs.core.array_for(vec, i), i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = function(vec, node, i, off) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = function(vec, node, i, off, meta) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, null);
};
cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Subvec.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Subvec.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var i = self__.start;
  var j = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.end) {
      var init__$2 = function() {
        var G__10003 = init__$1;
        var G__10004 = j;
        var G__10005 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10003, G__10004, G__10005) : f.call(null, G__10003, G__10004, G__10005);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__10006 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10006) : cljs.core.deref.call(null, G__10006);
      } else {
        var G__10028 = i + 1;
        var G__10029 = j + 1;
        var G__10030 = init__$2;
        i = G__10028;
        j = G__10029;
        init__$1 = G__10030;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return cljs.core.vector_index_out_of_bounds(n, self__.end - self__.start);
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.start + n);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return not_found;
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v, self__.start + n, not_found);
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  var v_pos = self__.start + n;
  var G__10007 = self__.meta;
  var G__10008 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v, v_pos, val);
  var G__10009 = self__.start;
  var G__10010 = function() {
    var x__4621__auto__ = self__.end;
    var y__4622__auto__ = v_pos + 1;
    return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
  }();
  var G__10011 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10007, G__10008, G__10009, G__10010, G__10011) : cljs.core.build_subvec.call(null, G__10007, G__10008, G__10009, G__10010, G__10011);
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Subvec(self__.meta, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.end - self__.start;
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.end - 1);
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.start === self__.end) {
    throw new Error("Can't pop empty vector");
  } else {
    var G__10012 = self__.meta;
    var G__10013 = self__.v;
    var G__10014 = self__.start;
    var G__10015 = self__.end - 1;
    var G__10016 = null;
    return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10012, G__10013, G__10014, G__10015, G__10016) : cljs.core.build_subvec.call(null, G__10012, G__10013, G__10014, G__10015, G__10016);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.start === self__.end)) {
    return new cljs.core.RSeq(coll__$1, self__.end - self__.start - 1, null);
  } else {
    return null;
  }
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, start__$1);
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n(coll__$1, key, val);
  } else {
    throw new Error("Subvec's key for assoc must be a number.");
  }
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var subvec_seq = function(coll__$1) {
    return function cljs$core$subvec_seq(i) {
      if (i === self__.end) {
        return null;
      } else {
        return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i), new cljs.core.LazySeq(null, function(coll__$1) {
          return function() {
            return cljs$core$subvec_seq(i + 1);
          };
        }(coll__$1), null, null));
      }
    };
  }(coll__$1);
  return subvec_seq(self__.start);
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  var G__10018 = meta__$1;
  var G__10019 = self__.v;
  var G__10020 = self__.start;
  var G__10021 = self__.end;
  var G__10022 = self__.__hash;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10018, G__10019, G__10020, G__10021, G__10022) : cljs.core.build_subvec.call(null, G__10018, G__10019, G__10020, G__10021, G__10022);
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__10023 = self__.meta;
  var G__10024 = cljs.core._assoc_n(self__.v, self__.end, o);
  var G__10025 = self__.start;
  var G__10026 = self__.end + 1;
  var G__10027 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10023, G__10024, G__10025, G__10026, G__10027) : cljs.core.build_subvec.call(null, G__10023, G__10024, G__10025, G__10026, G__10027);
};
cljs.core.Subvec.prototype.call = function() {
  var G__10031 = null;
  var G__10031__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__10031__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__10031 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10031__2.call(this, self__, k);
      case 3:
        return G__10031__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10031.cljs$core$IFn$_invoke$arity$2 = G__10031__2;
  G__10031.cljs$core$IFn$_invoke$arity$3 = G__10031__3;
  return G__10031;
}();
cljs.core.Subvec.prototype.apply = function(self__, args10002) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10002)));
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.Subvec.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";
cljs.core.Subvec.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Subvec");
};
cljs.core.__GT_Subvec = function cljs$core$__GT_Subvec(meta, v, start, end, __hash) {
  return new cljs.core.Subvec(meta, v, start, end, __hash);
};
cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.build_subvec = function cljs$core$build_subvec(meta, v, start, end, __hash) {
  while (true) {
    if (v instanceof cljs.core.Subvec) {
      var G__10032 = meta;
      var G__10033 = v.v;
      var G__10034 = v.start + start;
      var G__10035 = v.start + end;
      var G__10036 = __hash;
      meta = G__10032;
      v = G__10033;
      start = G__10034;
      end = G__10035;
      __hash = G__10036;
      continue;
    } else {
      var c = cljs.core.count(v);
      if (start < 0 || end < 0 || start > c || end > c) {
        throw new Error("Index out of bounds");
      } else {
      }
      return new cljs.core.Subvec(meta, v, start, end, __hash);
    }
    break;
  }
};
cljs.core.subvec = function cljs$core$subvec() {
  var G__10038 = arguments.length;
  switch(G__10038) {
    case 2:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = function(v, start) {
  return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v, start, cljs.core.count(v));
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = function(v, start, end) {
  return cljs.core.build_subvec(null, v, start, end, null);
};
cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = function cljs$core$tv_ensure_editable(edit, node) {
  if (edit === node.edit) {
    return node;
  } else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone(node.arr));
  }
};
cljs.core.tv_editable_root = function cljs$core$tv_editable_root(node) {
  return new cljs.core.VectorNode(function() {
    var obj10043 = {};
    return obj10043;
  }(), cljs.core.aclone(node.arr));
};
cljs.core.tv_editable_tail = function cljs$core$tv_editable_tail(tl) {
  var ret = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
  cljs.core.array_copy(tl, 0, ret, 0, tl.length);
  return ret;
};
cljs.core.tv_push_tail = function cljs$core$tv_push_tail(tv, level, parent, tail_node) {
  var ret = cljs.core.tv_ensure_editable(tv.root.edit, parent);
  var subidx = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset(ret, subidx, level === 5 ? tail_node : function() {
    var child = cljs.core.pv_aget(ret, subidx);
    if (!(child == null)) {
      return cljs$core$tv_push_tail(tv, level - 5, child, tail_node);
    } else {
      return cljs.core.new_path(tv.root.edit, level - 5, tail_node);
    }
  }());
  return ret;
};
cljs.core.tv_pop_tail = function cljs$core$tv_pop_tail(tv, level, node) {
  var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit, node);
  var subidx = tv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$tv_pop_tail(tv, level - 5, cljs.core.pv_aget(node__$1, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, new_child);
      return node__$1;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, null);
      return node__$1;
    }
  }
};
cljs.core.unchecked_editable_array_for = function cljs$core$unchecked_editable_array_for(tv, i) {
  if (i >= cljs.core.tail_off(tv)) {
    return tv.tail;
  } else {
    var root = tv.root;
    var node = root;
    var level = tv.shift;
    while (true) {
      if (level > 0) {
        var G__10051 = cljs.core.tv_ensure_editable(root.edit, cljs.core.pv_aget(node, i >>> level & 31));
        var G__10052 = level - 5;
        node = G__10051;
        level = G__10052;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition1$ = 88;
  this.cljs$lang$protocol_mask$partition0$ = 275;
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt - cljs.core.tail_off(tcoll__$1) < 32) {
      self__.tail[self__.cnt & 31] = o;
      self__.cnt = self__.cnt + 1;
      return tcoll__$1;
    } else {
      var tail_node = new cljs.core.VectorNode(self__.root.edit, self__.tail);
      var new_tail = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      new_tail[0] = o;
      self__.tail = new_tail;
      if (self__.cnt >>> 5 > 1 << self__.shift) {
        var new_root_array = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var new_shift = self__.shift + 5;
        new_root_array[0] = self__.root;
        new_root_array[1] = cljs.core.new_path(self__.root.edit, self__.shift, tail_node);
        self__.root = new cljs.core.VectorNode(self__.root.edit, new_root_array);
        self__.shift = new_shift;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      } else {
        var new_root = cljs.core.tv_push_tail(tcoll__$1, self__.shift, self__.root, tail_node);
        self__.root = new_root;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    self__.root.edit = null;
    var len = self__.cnt - cljs.core.tail_off(tcoll__$1);
    var trimmed_tail = new Array(len);
    cljs.core.array_copy(self__.tail, 0, trimmed_tail, 0, len);
    return new cljs.core.PersistentVector(null, self__.cnt, self__.shift, self__.root, trimmed_tail, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n_BANG_(tcoll__$1, key, val);
  } else {
    throw new Error("TransientVector's key for assoc! must be a number.");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (0 <= n && n < self__.cnt) {
      if (cljs.core.tail_off(tcoll__$1) <= n) {
        self__.tail[n & 31] = val;
        return tcoll__$1;
      } else {
        var new_root = function(tcoll__$1) {
          return function cljs$core$go(level, node) {
            var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit, node);
            if (level === 0) {
              cljs.core.pv_aset(node__$1, n & 31, val);
              return node__$1;
            } else {
              var subidx = n >>> level & 31;
              cljs.core.pv_aset(node__$1, subidx, cljs$core$go(level - 5, cljs.core.pv_aget(node__$1, subidx)));
              return node__$1;
            }
          };
        }(tcoll__$1).call(null, self__.shift, self__.root);
        self__.root = new_root;
        return tcoll__$1;
      }
    } else {
      if (n === self__.cnt) {
        return cljs.core._conj_BANG_(tcoll__$1, val);
      } else {
        throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(self__.cnt)].join(""));
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt === 0) {
      throw new Error("Can't pop empty vector");
    } else {
      if (1 === self__.cnt) {
        self__.cnt = 0;
        return tcoll__$1;
      } else {
        if ((self__.cnt - 1 & 31) > 0) {
          self__.cnt = self__.cnt - 1;
          return tcoll__$1;
        } else {
          var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1, self__.cnt - 2);
          var new_root = function() {
            var nr = cljs.core.tv_pop_tail(tcoll__$1, self__.shift, self__.root);
            if (!(nr == null)) {
              return nr;
            } else {
              return new cljs.core.VectorNode(self__.root.edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
            }
          }();
          if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
            var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit, cljs.core.pv_aget(new_root, 0));
            self__.root = new_root__$1;
            self__.shift = self__.shift - 5;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          } else {
            self__.root = new_root;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          }
        }
      }
    }
  } else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return self__.cnt;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return cljs.core.array_for(coll__$1, n)[n & 31];
  } else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, n);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.call = function() {
  var G__10056 = null;
  var G__10056__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10056__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10056 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10056__2.call(this, self__, k);
      case 3:
        return G__10056__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10056.cljs$core$IFn$_invoke$arity$2 = G__10056__2;
  G__10056.cljs$core$IFn$_invoke$arity$3 = G__10056__3;
  return G__10056;
}();
cljs.core.TransientVector.prototype.apply = function(self__, args10053) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10053)));
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.TransientVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null)], null);
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";
cljs.core.TransientVector.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientVector");
};
cljs.core.__GT_TransientVector = function cljs$core$__GT_TransientVector(cnt, shift, root, tail) {
  return new cljs.core.TransientVector(cnt, shift, root, tail);
};
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850572;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueueSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__4423__auto__ = cljs.core.next(self__.front);
  if (temp__4423__auto__) {
    var f1 = temp__4423__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (self__.rear == null) {
      return cljs.core._empty(coll__$1);
    } else {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueSeq(meta__$1, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentQueueSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentQueueSeq");
};
cljs.core.__GT_PersistentQueueSeq = function cljs$core$__GT_PersistentQueueSeq(meta, front, rear, __hash) {
  return new cljs.core.PersistentQueueSeq(meta, front, rear, __hash);
};
cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31858766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueue.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(self__.meta, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    var temp__4423__auto__ = cljs.core.next(self__.front);
    if (temp__4423__auto__) {
      var f1 = temp__4423__auto__;
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, f1, self__.rear, null);
    } else {
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, cljs.core.seq(self__.rear), cljs.core.PersistentVector.EMPTY, null);
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY, self__.meta);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.rest(cljs.core.seq(coll__$1));
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var rear__$1 = cljs.core.seq(self__.rear);
  if (cljs.core.truth_(function() {
    var or__4309__auto__ = self__.front;
    if (cljs.core.truth_(or__4309__auto__)) {
      return or__4309__auto__;
    } else {
      return rear__$1;
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, self__.front, cljs.core.seq(rear__$1), null);
  } else {
    return null;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(meta__$1, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, self__.front, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
      var or__4309__auto__ = self__.rear;
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        return cljs.core.PersistentVector.EMPTY;
      }
    }(), o), null);
  } else {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front, o), cljs.core.PersistentVector.EMPTY, null);
  }
};
cljs.core.PersistentQueue.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";
cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentQueue");
};
cljs.core.__GT_PersistentQueue = function cljs$core$__GT_PersistentQueue(meta, count, front, rear, __hash) {
  return new cljs.core.PersistentQueue(meta, count, front, rear, __hash);
};
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, cljs.core.empty_ordered_hash);
cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NeverEquiv.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return false;
};
cljs.core.NeverEquiv.getBasis = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";
cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/NeverEquiv");
};
cljs.core.__GT_NeverEquiv = function cljs$core$__GT_NeverEquiv() {
  return new cljs.core.NeverEquiv;
};
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function cljs$core$equiv_map(x, y) {
  return cljs.core.boolean$(cljs.core.map_QMARK_(y) ? cljs.core.count(x) === cljs.core.count(y) ? cljs.core.every_QMARK_(cljs.core.identity, cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(xkv) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, cljs.core.first(xkv), cljs.core.never_equiv), cljs.core.second(xkv));
  }, x)) : null : null);
};
cljs.core.scan_array = function cljs$core$scan_array(incr, k, array) {
  var len = array.length;
  var i = 0;
  while (true) {
    if (i < len) {
      if (k === array[i]) {
        return i;
      } else {
        var G__10057 = i + incr;
        i = G__10057;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.obj_map_compare_keys = function cljs$core$obj_map_compare_keys(a, b) {
  var a__$1 = cljs.core.hash(a);
  var b__$1 = cljs.core.hash(b);
  if (a__$1 < b__$1) {
    return -1;
  } else {
    if (a__$1 > b__$1) {
      return 1;
    } else {
      return 0;
    }
  }
};
cljs.core.obj_map__GT_hash_map = function cljs$core$obj_map__GT_hash_map(m, k, v) {
  var ks = m.keys;
  var len = ks.length;
  var so = m.strobj;
  var mm = cljs.core.meta(m);
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var k__$1 = ks[i];
      var G__10058 = i + 1;
      var G__10059 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k__$1, so[k__$1]);
      i = G__10058;
      out = G__10059;
      continue;
    } else {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k, v)), mm);
    }
    break;
  }
};
cljs.core.obj_clone = function cljs$core$obj_clone(obj, ks) {
  var new_obj = function() {
    var obj10063 = {};
    return obj10063;
  }();
  var l = ks.length;
  var i_10064 = 0;
  while (true) {
    if (i_10064 < l) {
      var k_10065 = ks[i_10064];
      new_obj[k_10065] = obj[k_10065];
      var G__10066 = i_10064 + 1;
      i_10064 = G__10066;
      continue;
    } else {
    }
    break;
  }
  return new_obj;
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 4;
};
cljs.core.ObjMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ObjMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4297__auto__ = function() {
      var G__10070 = k;
      return goog.isString(G__10070);
    }();
    if (cljs.core.truth_(and__4297__auto__)) {
      return !(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4297__auto__;
    }
  }())) {
    return self__.strobj[k];
  } else {
    return not_found;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.keys.length;
  var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
  var init__$1 = init;
  while (true) {
    if (cljs.core.seq(keys__$1)) {
      var k = cljs.core.first(keys__$1);
      var init__$2 = function() {
        var G__10071 = init__$1;
        var G__10072 = k;
        var G__10073 = self__.strobj[k];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10071, G__10072, G__10073) : f.call(null, G__10071, G__10072, G__10073);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__10074 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10074) : cljs.core.deref.call(null, G__10074);
      } else {
        var G__10080 = cljs.core.rest(keys__$1);
        var G__10081 = init__$2;
        keys__$1 = G__10080;
        init__$1 = G__10081;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.keys.length;
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1));
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.ObjMap.EMPTY, self__.meta);
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4297__auto__ = function() {
      var G__10076 = k;
      return goog.isString(G__10076);
    }();
    if (cljs.core.truth_(and__4297__auto__)) {
      return !(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4297__auto__;
    }
  }())) {
    var new_keys = cljs.core.aclone(self__.keys);
    var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
    new_keys.splice(cljs.core.scan_array(1, k, new_keys), 1);
    delete new_strobj[k];
    return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
  } else {
    return coll__$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var G__10077 = k;
    return goog.isString(G__10077);
  }())) {
    if (self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD || self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD) {
      return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
    } else {
      if (!(cljs.core.scan_array(1, k, self__.keys) == null)) {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        new_strobj[k] = v;
        return new cljs.core.ObjMap(self__.meta, self__.keys, new_strobj, self__.update_count + 1, null);
      } else {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        var new_keys = cljs.core.aclone(self__.keys);
        new_strobj[k] = v;
        new_keys.push(k);
        return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
      }
    }
  } else {
    return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4297__auto__ = function() {
      var G__10079 = k;
      return goog.isString(G__10079);
    }();
    if (cljs.core.truth_(and__4297__auto__)) {
      return !(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4297__auto__;
    }
  }())) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.keys.length > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(coll__$1) {
      return function(p1__10067_SHARP_) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10067_SHARP_, self__.strobj[p1__10067_SHARP_]], null);
      };
    }(coll__$1), self__.keys.sort(cljs.core.obj_map_compare_keys));
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ObjMap(meta__$1, self__.keys, self__.strobj, self__.update_count, self__.__hash);
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, coll__$1, entry);
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__10082 = null;
  var G__10082__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10082__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10082 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10082__2.call(this, self__, k);
      case 3:
        return G__10082__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10082.cljs$core$IFn$_invoke$arity$2 = G__10082__2;
  G__10082.cljs$core$IFn$_invoke$arity$3 = G__10082__3;
  return G__10082;
}();
cljs.core.ObjMap.prototype.apply = function(self__, args10068) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10068)));
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.ObjMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "keys", "keys", -1586012071, null), new cljs.core.Symbol(null, "strobj", "strobj", 1088091283, null), new cljs.core.Symbol(null, "update-count", "update-count", -411982269, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";
cljs.core.ObjMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ObjMap");
};
cljs.core.__GT_ObjMap = function cljs$core$__GT_ObjMap(meta, keys, strobj, update_count, __hash) {
  return new cljs.core.ObjMap(meta, keys, strobj, update_count, __hash);
};
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], function() {
  var obj10084 = {};
  return obj10084;
}(), 0, cljs.core.empty_unordered_hash);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 8;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null);
};
cljs.core.ES6EntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6EntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var vec__10085 = cljs.core.first(self__.s);
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10085, 0, null);
    var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10085, 1, null);
    self__.s = cljs.core.next(self__.s);
    return {"value":[k, v], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6EntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null)], null);
};
cljs.core.ES6EntriesIterator.cljs$lang$type = true;
cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";
cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6EntriesIterator");
};
cljs.core.__GT_ES6EntriesIterator = function cljs$core$__GT_ES6EntriesIterator(s) {
  return new cljs.core.ES6EntriesIterator(s);
};
cljs.core.es6_entries_iterator = function cljs$core$es6_entries_iterator(coll) {
  return new cljs.core.ES6EntriesIterator(cljs.core.seq(coll));
};
cljs.core.ES6SetEntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6SetEntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":[x, x], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6SetEntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null)], null);
};
cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6SetEntriesIterator");
};
cljs.core.__GT_ES6SetEntriesIterator = function cljs$core$__GT_ES6SetEntriesIterator(s) {
  return new cljs.core.ES6SetEntriesIterator(s);
};
cljs.core.es6_set_entries_iterator = function cljs$core$es6_set_entries_iterator(coll) {
  return new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll));
};
cljs.core.array_index_of_nil_QMARK_ = function cljs$core$array_index_of_nil_QMARK_(arr) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] == null) {
        return i;
      } else {
        var G__10086 = i + 2;
        i = G__10086;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_keyword_QMARK_ = function cljs$core$array_index_of_keyword_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.fqn;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (function() {
        var k_SINGLEQUOTE_ = arr[i];
        return k_SINGLEQUOTE_ instanceof cljs.core.Keyword && kstr === k_SINGLEQUOTE_.fqn;
      }()) {
        return i;
      } else {
        var G__10087 = i + 2;
        i = G__10087;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_symbol_QMARK_ = function cljs$core$array_index_of_symbol_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.str;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (function() {
        var k_SINGLEQUOTE_ = arr[i];
        return k_SINGLEQUOTE_ instanceof cljs.core.Symbol && kstr === k_SINGLEQUOTE_.str;
      }()) {
        return i;
      } else {
        var G__10088 = i + 2;
        i = G__10088;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_identical_QMARK_ = function cljs$core$array_index_of_identical_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (k === arr[i]) {
        return i;
      } else {
        var G__10089 = i + 2;
        i = G__10089;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_equiv_QMARK_ = function cljs$core$array_index_of_equiv_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, arr[i])) {
        return i;
      } else {
        var G__10090 = i + 2;
        i = G__10090;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of = function cljs$core$array_index_of(arr, k) {
  if (k instanceof cljs.core.Keyword) {
    return cljs.core.array_index_of_keyword_QMARK_(arr, k);
  } else {
    if (cljs.core.truth_(function() {
      var or__4309__auto__ = function() {
        var G__10094 = k;
        return goog.isString(G__10094);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        return typeof k === "number";
      }
    }())) {
      return cljs.core.array_index_of_identical_QMARK_(arr, k);
    } else {
      if (k instanceof cljs.core.Symbol) {
        return cljs.core.array_index_of_symbol_QMARK_(arr, k);
      } else {
        if (k == null) {
          return cljs.core.array_index_of_nil_QMARK_(arr);
        } else {
          return cljs.core.array_index_of_equiv_QMARK_(arr, k);
        }
      }
    }
  }
};
cljs.core.array_map_index_of = function cljs$core$array_map_index_of(m, k) {
  return cljs.core.array_index_of(m.arr, k);
};
cljs.core.array_extend_kv = function cljs$core$array_extend_kv(arr, k, v) {
  var l = arr.length;
  var narr = new Array(l + 2);
  var i_10095 = 0;
  while (true) {
    if (i_10095 < l) {
      narr[i_10095] = arr[i_10095];
      var G__10096 = i_10095 + 1;
      i_10095 = G__10096;
      continue;
    } else {
    }
    break;
  }
  narr[l] = k;
  narr[l + 1] = v;
  return narr;
};
cljs.core.array_map_extend_kv = function cljs$core$array_map_extend_kv(m, k, v) {
  return cljs.core.array_extend_kv(m.arr, k, v);
};
cljs.core.PersistentArrayMapSeq = function(arr, i, _meta) {
  this.arr = arr;
  this.i = i;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentArrayMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return (self__.arr.length - self__.i) / 2;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i, new_meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentArrayMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentArrayMapSeq");
};
cljs.core.__GT_PersistentArrayMapSeq = function cljs$core$__GT_PersistentArrayMapSeq(arr, i, _meta) {
  return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
};
cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.persistent_array_map_seq = function cljs$core$persistent_array_map_seq(arr, i, _meta) {
  if (i <= arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapIterator = function(arr, i, cnt) {
  this.arr = arr;
  this.i = i;
  this.cnt = cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
  self__.i = self__.i + 2;
  return ret;
};
cljs.core.PersistentArrayMapIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null)], null);
};
cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentArrayMapIterator");
};
cljs.core.__GT_PersistentArrayMapIterator = function cljs$core$__GT_PersistentArrayMapIterator(arr, i, cnt) {
  return new cljs.core.PersistentArrayMapIterator(arr, i, cnt);
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16647951;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__10098 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__10098) : cljs.core.keys.call(null, G__10098);
  }());
};
cljs.core.PersistentArrayMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentArrayMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__10099 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__10099) : cljs.core.vals.call(null, G__10099);
  }());
};
cljs.core.PersistentArrayMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentArrayMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__10100 = cljs.core.seq(coll);
  var chunk__10101 = null;
  var count__10102 = 0;
  var i__10103 = 0;
  while (true) {
    if (i__10103 < count__10102) {
      var vec__10104 = chunk__10101.cljs$core$IIndexed$_nth$arity$2(null, i__10103);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10104, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10104, 1, null);
      var G__10105_10118 = v;
      var G__10106_10119 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10105_10118, G__10106_10119) : f.call(null, G__10105_10118, G__10106_10119);
      var G__10120 = seq__10100;
      var G__10121 = chunk__10101;
      var G__10122 = count__10102;
      var G__10123 = i__10103 + 1;
      seq__10100 = G__10120;
      chunk__10101 = G__10121;
      count__10102 = G__10122;
      i__10103 = G__10123;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__10100);
      if (temp__4425__auto__) {
        var seq__10100__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__10100__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__10100__$1);
          var G__10124 = cljs.core.chunk_rest(seq__10100__$1);
          var G__10125 = c__5094__auto__;
          var G__10126 = cljs.core.count(c__5094__auto__);
          var G__10127 = 0;
          seq__10100 = G__10124;
          chunk__10101 = G__10125;
          count__10102 = G__10126;
          i__10103 = G__10127;
          continue;
        } else {
          var vec__10107 = cljs.core.first(seq__10100__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10107, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10107, 1, null);
          var G__10108_10128 = v;
          var G__10109_10129 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10108_10128, G__10109_10129) : f.call(null, G__10108_10128, G__10109_10129);
          var G__10130 = cljs.core.next(seq__10100__$1);
          var G__10131 = null;
          var G__10132 = 0;
          var G__10133 = 0;
          seq__10100 = G__10130;
          chunk__10101 = G__10131;
          count__10102 = G__10132;
          i__10103 = G__10133;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return not_found;
  } else {
    return self__.arr[idx + 1];
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var G__10110 = init__$1;
        var G__10111 = self__.arr[i];
        var G__10112 = self__.arr[i + 1];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10110, G__10111, G__10112) : f.call(null, G__10110, G__10111, G__10112);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__10113 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10113) : cljs.core.deref.call(null, G__10113);
      } else {
        var G__10134 = i + 2;
        var G__10135 = init__$2;
        i = G__10134;
        init__$1 = G__10135;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.PersistentArrayMapIterator(self__.arr, 0, self__.cnt * 2);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (function() {
    var G__10114 = other;
    if (G__10114) {
      var bit__4976__auto__ = G__10114.cljs$lang$protocol_mask$partition0$ & 1024;
      if (bit__4976__auto__ || G__10114.cljs$core$IMap$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    var alen = self__.arr.length;
    var other__$1 = other;
    if (self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null)) {
      var i = 0;
      while (true) {
        if (i < alen) {
          var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, self__.arr[i], cljs.core.lookup_sentinel);
          if (!(v === cljs.core.lookup_sentinel)) {
            if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[i + 1], v)) {
              var G__10136 = i + 2;
              i = G__10136;
              continue;
            } else {
              return false;
            }
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_map(coll__$1, other);
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientArrayMap(function() {
    var obj10116 = {};
    return obj10116;
  }(), self__.arr.length, cljs.core.aclone(self__.arr));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY, self__.meta);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx >= 0) {
    var len = self__.arr.length;
    var new_len = len - 2;
    if (new_len === 0) {
      return cljs.core._empty(coll__$1);
    } else {
      var new_arr = new Array(new_len);
      var s = 0;
      var d = 0;
      while (true) {
        if (s >= len) {
          return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt - 1, new_arr, null);
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, self__.arr[s])) {
            var G__10137 = s + 2;
            var G__10138 = d;
            s = G__10137;
            d = G__10138;
            continue;
          } else {
            new_arr[d] = self__.arr[s];
            new_arr[d + 1] = self__.arr[s + 1];
            var G__10139 = s + 2;
            var G__10140 = d + 2;
            s = G__10139;
            d = G__10140;
            continue;
          }
        }
        break;
      }
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    if (self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      var arr__$1 = cljs.core.array_map_extend_kv(coll__$1, k, v);
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt + 1, arr__$1, null);
    } else {
      return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1), k, v), self__.meta);
    }
  } else {
    if (v === self__.arr[idx + 1]) {
      return coll__$1;
    } else {
      var arr__$1 = function() {
        var G__10117 = cljs.core.aclone(self__.arr);
        G__10117[idx + 1] = v;
        return G__10117;
      }();
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, arr__$1, null);
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(cljs.core.array_map_index_of(coll__$1, k) === -1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.persistent_array_map_seq(self__.arr, 0, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMap(meta__$1, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__10141 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__10142 = cljs.core.next(es);
          ret = G__10141;
          es = G__10142;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__10143 = null;
  var G__10143__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10143__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10143 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10143__2.call(this, self__, k);
      case 3:
        return G__10143__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10143.cljs$core$IFn$_invoke$arity$2 = G__10143__2;
  G__10143.cljs$core$IFn$_invoke$arity$3 = G__10143__3;
  return G__10143;
}();
cljs.core.PersistentArrayMap.prototype.apply = function(self__, args10097) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10097)));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";
cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentArrayMap");
};
cljs.core.__GT_PersistentArrayMap = function cljs$core$__GT_PersistentArrayMap(meta, cnt, arr, __hash) {
  return new cljs.core.PersistentArrayMap(meta, cnt, arr, __hash);
};
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], cljs.core.empty_unordered_hash);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 8;
cljs.core.PersistentArrayMap.fromArray = function(arr, no_clone, no_check) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var arr__$2 = no_check ? arr__$1 : function() {
    var ret = [];
    var i_10144 = 0;
    while (true) {
      if (i_10144 < arr__$1.length) {
        var k_10145 = arr__$1[i_10144];
        var v_10146 = arr__$1[i_10144 + 1];
        var idx_10147 = cljs.core.array_index_of(ret, k_10145);
        if (idx_10147 === -1) {
          ret.push(k_10145);
          ret.push(v_10146);
        } else {
        }
        var G__10148 = i_10144 + 2;
        i_10144 = G__10148;
        continue;
      } else {
      }
      break;
    }
    return ret;
  }();
  var arr__$3 = function() {
    var cnt = arr__$2.length / 2;
    return new cljs.core.PersistentArrayMap(null, cnt, arr__$2, null);
  }();
  return arr__$3;
};
cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    return cljs.core.quot(self__.len, 2);
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, k, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, k);
    if (idx === -1) {
      return not_found;
    } else {
      return self__.arr[idx + 1];
    }
  } else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    if (function() {
      var G__10149 = o;
      if (G__10149) {
        var bit__4983__auto__ = G__10149.cljs$lang$protocol_mask$partition0$ & 2048;
        if (bit__4983__auto__ || G__10149.cljs$core$IMapEntry$) {
          return true;
        } else {
          if (!G__10149.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__10149);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__10149);
      }
    }()) {
      return cljs.core._assoc_BANG_(tcoll__$1, function() {
        var G__10150 = o;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10150) : cljs.core.key.call(null, G__10150);
      }(), function() {
        var G__10151 = o;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__10151) : cljs.core.val.call(null, G__10151);
      }());
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$2 = tcoll__$1;
      while (true) {
        var temp__4423__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          var G__10157 = cljs.core.next(es);
          var G__10158 = cljs.core._assoc_BANG_(tcoll__$2, function() {
            var G__10152 = e;
            return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10152) : cljs.core.key.call(null, G__10152);
          }(), function() {
            var G__10153 = e;
            return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__10153) : cljs.core.val.call(null, G__10153);
          }());
          es = G__10157;
          tcoll__$2 = G__10158;
          continue;
        } else {
          return tcoll__$2;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    self__.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot(self__.len, 2), self__.arr, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx === -1) {
      if (self__.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        self__.len = self__.len + 2;
        self__.arr.push(key);
        self__.arr.push(val);
        return tcoll__$1;
      } else {
        return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(function() {
          var G__10154 = self__.len;
          var G__10155 = self__.arr;
          return cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__10154, G__10155) : cljs.core.array__GT_transient_hash_map.call(null, G__10154, G__10155);
        }(), key, val);
      }
    } else {
      if (val === self__.arr[idx + 1]) {
        return tcoll__$1;
      } else {
        self__.arr[idx + 1] = val;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx >= 0) {
      self__.arr[idx] = self__.arr[self__.len - 2];
      self__.arr[idx + 1] = self__.arr[self__.len - 1];
      var G__10156_10159 = self__.arr;
      G__10156_10159.pop();
      G__10156_10159.pop();
      self__.len = self__.len - 2;
    } else {
    }
    return tcoll__$1;
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "editable?", "editable?", -164945806, null), new cljs.core.Symbol(null, "len", "len", -1230778691, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";
cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientArrayMap");
};
cljs.core.__GT_TransientArrayMap = function cljs$core$__GT_TransientArrayMap(editable_QMARK_, len, arr) {
  return new cljs.core.TransientArrayMap(editable_QMARK_, len, arr);
};
cljs.core.array__GT_transient_hash_map = function cljs$core$array__GT_transient_hash_map(len, arr) {
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i = 0;
  while (true) {
    if (i < len) {
      var G__10160 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, arr[i], arr[i + 1]);
      var G__10161 = i + 2;
      out = G__10160;
      i = G__10161;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.Box = function(val) {
  this.val = val;
};
cljs.core.Box.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";
cljs.core.Box.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Box");
};
cljs.core.__GT_Box = function cljs$core$__GT_Box(val) {
  return new cljs.core.Box(val);
};
cljs.core.key_test = function cljs$core$key_test(key, other) {
  if (key === other) {
    return true;
  } else {
    if (cljs.core.keyword_identical_QMARK_(key, other)) {
      return true;
    } else {
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key, other);
    }
  }
};
cljs.core.mask = function cljs$core$mask(hash, shift) {
  return hash >>> shift & 31;
};
cljs.core.clone_and_set = function cljs$core$clone_and_set() {
  var G__10163 = arguments.length;
  switch(G__10163) {
    case 3:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = function(arr, i, a) {
  var G__10164 = cljs.core.aclone(arr);
  G__10164[i] = a;
  return G__10164;
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = function(arr, i, a, j, b) {
  var G__10165 = cljs.core.aclone(arr);
  G__10165[i] = a;
  G__10165[j] = b;
  return G__10165;
};
cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = function cljs$core$remove_pair(arr, i) {
  var new_arr = new Array(arr.length - 2);
  cljs.core.array_copy(arr, 0, new_arr, 0, 2 * i);
  cljs.core.array_copy(arr, 2 * (i + 1), new_arr, 2 * i, new_arr.length - 2 * i);
  return new_arr;
};
cljs.core.bitmap_indexed_node_index = function cljs$core$bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count(bitmap & bit - 1);
};
cljs.core.bitpos = function cljs$core$bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31);
};
cljs.core.edit_and_set = function cljs$core$edit_and_set() {
  var G__10168 = arguments.length;
  switch(G__10168) {
    case 4:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 6:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = function(inode, edit, i, a) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  return editable;
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = function(inode, edit, i, a, j, b) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  editable.arr[j] = b;
  return editable;
};
cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = function cljs$core$inode_kv_reduce(arr, f, init) {
  var len = arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var k = arr[i];
        if (!(k == null)) {
          var G__10174 = init__$1;
          var G__10175 = k;
          var G__10176 = arr[i + 1];
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10174, G__10175, G__10176) : f.call(null, G__10174, G__10175, G__10176);
        } else {
          var node = arr[i + 1];
          if (!(node == null)) {
            return node.kv_reduce(f, init__$1);
          } else {
            return init__$1;
          }
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__10177 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10177) : cljs.core.deref.call(null, G__10177);
      } else {
        var G__10178 = i + 2;
        var G__10179 = init__$2;
        i = G__10178;
        init__$1 = G__10179;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr;
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var n = cljs.core.bit_count(self__.bitmap);
    var new_arr = new Array(n < 0 ? 4 : 2 * (n + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * n);
    return new cljs.core.BitmapIndexedNode(e, self__.bitmap, new_arr);
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return inode.edit_and_remove_pair(edit__$1, bit, idx);
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        removed_leaf_QMARK_[0] = true;
        return inode.edit_and_remove_pair(edit__$1, bit, idx);
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var self__ = this;
  var inode = this;
  if (self__.bitmap === bit) {
    return null;
  } else {
    var editable = inode.ensure_editable(e);
    var earr = editable.arr;
    var len = earr.length;
    editable.bitmap = bit ^ editable.bitmap;
    cljs.core.array_copy(earr, 2 * (i + 1), earr, 2 * i, len - 2 * (i + 1));
    earr[len - 2] = null;
    earr[len - 1] = null;
    return editable;
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__10180 = self__.arr;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__10180) : cljs.core.create_inode_seq.call(null, G__10180);
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_lookup(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return val_or_node;
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (2 * n < self__.arr.length) {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward(earr, 2 * idx, earr, 2 * (idx + 1), 2 * (n - idx));
      earr[2 * idx] = key;
      earr[2 * idx + 1] = val;
      editable.bitmap = editable.bitmap | bit;
      return editable;
    } else {
      if (n >= 16) {
        var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var jdx = hash >>> shift & 31;
        nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i_10194 = 0;
        var j_10195 = 0;
        while (true) {
          if (i_10194 < 32) {
            if ((self__.bitmap >>> i_10194 & 1) === 0) {
              var G__10196 = i_10194 + 1;
              var G__10197 = j_10195;
              i_10194 = G__10196;
              j_10195 = G__10197;
              continue;
            } else {
              nodes[i_10194] = !(self__.arr[j_10195] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, cljs.core.hash(self__.arr[j_10195]), self__.arr[j_10195], self__.arr[j_10195 + 1], added_leaf_QMARK_) : self__.arr[j_10195 + 1];
              var G__10198 = i_10194 + 1;
              var G__10199 = j_10195 + 2;
              i_10194 = G__10198;
              j_10195 = G__10199;
              continue;
            }
          } else {
          }
          break;
        }
        return new cljs.core.ArrayNode(edit__$1, n + 1, nodes);
      } else {
        var new_arr = new Array(2 * (n + 4));
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
        new_arr[2 * idx] = key;
        new_arr[2 * idx + 1] = val;
        cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
        added_leaf_QMARK_.val = true;
        var editable = inode.ensure_editable(edit__$1);
        editable.arr = new_arr;
        editable.bitmap = editable.bitmap | bit;
        return editable;
      }
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, val);
        }
      } else {
        added_leaf_QMARK_.val = true;
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * idx, null, 2 * idx + 1, function() {
          var G__10181 = edit__$1;
          var G__10182 = shift + 5;
          var G__10183 = key_or_nil;
          var G__10184 = val_or_node;
          var G__10185 = hash;
          var G__10186 = key;
          var G__10187 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__10181, G__10182, G__10183, G__10184, G__10185, G__10186, G__10187) : cljs.core.create_node.call(null, G__10181, G__10182, G__10183, G__10184, G__10185, G__10186, G__10187);
        }());
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (n >= 16) {
      var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      var jdx = hash >>> shift & 31;
      nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i_10200 = 0;
      var j_10201 = 0;
      while (true) {
        if (i_10200 < 32) {
          if ((self__.bitmap >>> i_10200 & 1) === 0) {
            var G__10202 = i_10200 + 1;
            var G__10203 = j_10201;
            i_10200 = G__10202;
            j_10201 = G__10203;
            continue;
          } else {
            nodes[i_10200] = !(self__.arr[j_10201] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash(self__.arr[j_10201]), self__.arr[j_10201], self__.arr[j_10201 + 1], added_leaf_QMARK_) : self__.arr[j_10201 + 1];
            var G__10204 = i_10200 + 1;
            var G__10205 = j_10201 + 2;
            i_10200 = G__10204;
            j_10201 = G__10205;
            continue;
          }
        } else {
        }
        break;
      }
      return new cljs.core.ArrayNode(null, n + 1, nodes);
    } else {
      var new_arr = new Array(2 * (n + 1));
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
      new_arr[2 * idx] = key;
      new_arr[2 * idx + 1] = val;
      cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, self__.bitmap | bit, new_arr);
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, val));
        }
      } else {
        added_leaf_QMARK_.val = true;
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr, 2 * idx, null, 2 * idx + 1, function() {
          var G__10188 = shift + 5;
          var G__10189 = key_or_nil;
          var G__10190 = val_or_node;
          var G__10191 = hash;
          var G__10192 = key;
          var G__10193 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__10188, G__10189, G__10190, G__10191, G__10192, G__10193) : cljs.core.create_node.call(null, G__10188, G__10189, G__10190, G__10191, G__10192, G__10193);
        }()));
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_find(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil, val_or_node], null);
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without(shift + 5, hash, key);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "bitmap", "bitmap", 501334601, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/BitmapIndexedNode");
};
cljs.core.__GT_BitmapIndexedNode = function cljs$core$__GT_BitmapIndexedNode(edit, bitmap, arr) {
  return new cljs.core.BitmapIndexedNode(edit, bitmap, arr);
};
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, []);
cljs.core.pack_array_node = function cljs$core$pack_array_node(array_node, edit, idx) {
  var arr = array_node.arr;
  var len = arr.length;
  var new_arr = new Array(2 * (array_node.cnt - 1));
  var i = 0;
  var j = 1;
  var bitmap = 0;
  while (true) {
    if (i < len) {
      if (!(i === idx) && !(arr[i] == null)) {
        new_arr[j] = arr[i];
        var G__10206 = i + 1;
        var G__10207 = j + 2;
        var G__10208 = bitmap | 1 << i;
        i = G__10206;
        j = G__10207;
        bitmap = G__10208;
        continue;
      } else {
        var G__10209 = i + 1;
        var G__10210 = j;
        var G__10211 = bitmap;
        i = G__10209;
        j = G__10210;
        bitmap = G__10211;
        continue;
      }
    } else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap, new_arr);
    }
    break;
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    return new cljs.core.ArrayNode(e, self__.cnt, cljs.core.aclone(self__.arr));
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return inode;
  } else {
    var n = node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, edit__$1, idx);
        } else {
          var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
          editable.cnt = editable.cnt - 1;
          return editable;
        }
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
      }
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__10212 = self__.arr;
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__10212) : cljs.core.create_array_node_seq.call(null, G__10212);
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var node = self__.arr[i];
      if (!(node == null)) {
        var init__$2 = node.kv_reduce(f, init__$1);
        if (cljs.core.reduced_QMARK_(init__$2)) {
          var G__10213 = init__$2;
          return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10213) : cljs.core.deref.call(null, G__10213);
        } else {
          var G__10214 = i + 1;
          var G__10215 = init__$2;
          i = G__10214;
          init__$1 = G__10215;
          continue;
        }
      } else {
        var G__10216 = i + 1;
        var G__10217 = init__$1;
        i = G__10216;
        init__$1 = G__10217;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_lookup(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable.cnt = editable.cnt + 1;
    return editable;
  } else {
    var n = node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
    }
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return new cljs.core.ArrayNode(null, self__.cnt + 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)));
  } else {
    var n = node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
    }
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_find(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    var n = node.inode_without(shift + 5, hash, key);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, null, idx);
        } else {
          return new cljs.core.ArrayNode(null, self__.cnt - 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
        }
      } else {
        return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
      }
    }
  } else {
    return inode;
  }
};
cljs.core.ArrayNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";
cljs.core.ArrayNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayNode");
};
cljs.core.__GT_ArrayNode = function cljs$core$__GT_ArrayNode(edit, cnt, arr) {
  return new cljs.core.ArrayNode(edit, cnt, arr);
};
cljs.core.hash_collision_node_find_index = function cljs$core$hash_collision_node_find_index(arr, cnt, key) {
  var lim = 2 * cnt;
  var i = 0;
  while (true) {
    if (i < lim) {
      if (cljs.core.key_test(key, arr[i])) {
        return i;
      } else {
        var G__10218 = i + 2;
        i = G__10218;
        continue;
      }
    } else {
      return -1;
    }
    break;
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var new_arr = new Array(2 * (self__.cnt + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * self__.cnt);
    return new cljs.core.HashCollisionNode(e, self__.collision_hash, self__.cnt, new_arr);
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    removed_leaf_QMARK_[0] = true;
    if (self__.cnt === 1) {
      return null;
    } else {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      earr[idx] = earr[2 * self__.cnt - 2];
      earr[idx + 1] = earr[2 * self__.cnt - 1];
      earr[2 * self__.cnt - 1] = null;
      earr[2 * self__.cnt - 2] = null;
      editable.cnt = editable.cnt - 1;
      return editable;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__10219 = self__.arr;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__10219) : cljs.core.create_inode_seq.call(null, G__10219);
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return self__.arr[idx + 1];
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      if (self__.arr.length > 2 * self__.cnt) {
        var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * self__.cnt, key, 2 * self__.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable.cnt = editable.cnt + 1;
        return editable;
      } else {
        var len = self__.arr.length;
        var new_arr = new Array(len + 2);
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
        new_arr[len] = key;
        new_arr[len + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode.ensure_editable_array(edit__$1, self__.cnt + 1, new_arr);
      }
    } else {
      if (self__.arr[idx + 1] === val) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx + 1, val);
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(edit__$1, 1 << (self__.collision_hash >>> shift & 31), [null, inode, null, null])).inode_assoc_BANG_(edit__$1, shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      var len = 2 * self__.cnt;
      var new_arr = new Array(len + 2);
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
      new_arr[len] = key;
      new_arr[len + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt + 1, new_arr);
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[idx], val)) {
        return inode;
      } else {
        return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx + 1, val));
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(null, 1 << (self__.collision_hash >>> shift & 31), [null, inode])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    self__.arr = array;
    self__.cnt = count;
    return inode;
  } else {
    return new cljs.core.HashCollisionNode(self__.edit, self__.collision_hash, count, array);
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[idx], self__.arr[idx + 1]], null);
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    if (self__.cnt === 1) {
      return null;
    } else {
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt - 1, cljs.core.remove_pair(self__.arr, cljs.core.quot(idx, 2)));
    }
  }
};
cljs.core.HashCollisionNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "collision-hash", "collision-hash", -35831342, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";
cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/HashCollisionNode");
};
cljs.core.__GT_HashCollisionNode = function cljs$core$__GT_HashCollisionNode(edit, collision_hash, cnt, arr) {
  return new cljs.core.HashCollisionNode(edit, collision_hash, cnt, arr);
};
cljs.core.create_node = function cljs$core$create_node() {
  var G__10221 = arguments.length;
  switch(G__10221) {
    case 6:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = function(shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$lang$maxFixedArity = 7;
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.NodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.nodes[self__.i], self__.nodes[self__.i + 1]], null);
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    var G__10223 = self__.nodes;
    var G__10224 = self__.i + 2;
    var G__10225 = null;
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__10223, G__10224, G__10225) : cljs.core.create_inode_seq.call(null, G__10223, G__10224, G__10225);
  } else {
    var G__10226 = self__.nodes;
    var G__10227 = self__.i;
    var G__10228 = cljs.core.next(self__.s);
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__10226, G__10227, G__10228) : cljs.core.create_inode_seq.call(null, G__10226, G__10227, G__10228);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.NodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";
cljs.core.NodeSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/NodeSeq");
};
cljs.core.__GT_NodeSeq = function cljs$core$__GT_NodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.NodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.create_inode_seq = function cljs$core$create_inode_seq() {
  var G__10230 = arguments.length;
  switch(G__10230) {
    case 1:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 3:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes, 0, null);
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = function(nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        if (!(nodes[j] == null)) {
          return new cljs.core.NodeSeq(null, nodes, j, null, null);
        } else {
          var temp__4423__auto__ = nodes[j + 1];
          if (cljs.core.truth_(temp__4423__auto__)) {
            var node = temp__4423__auto__;
            var temp__4423__auto____$1 = node.inode_seq();
            if (cljs.core.truth_(temp__4423__auto____$1)) {
              var node_seq = temp__4423__auto____$1;
              return new cljs.core.NodeSeq(null, nodes, j + 2, node_seq, null);
            } else {
              var G__10232 = j + 2;
              j = G__10232;
              continue;
            }
          } else {
            var G__10233 = j + 2;
            j = G__10233;
            continue;
          }
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.NodeSeq(null, nodes, i, s, null);
  }
};
cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ArrayNodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.s);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__10234 = null;
  var G__10235 = self__.nodes;
  var G__10236 = self__.i;
  var G__10237 = cljs.core.next(self__.s);
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__10234, G__10235, G__10236, G__10237) : cljs.core.create_array_node_seq.call(null, G__10234, G__10235, G__10236, G__10237);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ArrayNodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayNodeSeq");
};
cljs.core.__GT_ArrayNodeSeq = function cljs$core$__GT_ArrayNodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.create_array_node_seq = function cljs$core$create_array_node_seq() {
  var G__10239 = arguments.length;
  switch(G__10239) {
    case 1:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 4:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null, nodes, 0, null);
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = function(meta, nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        var temp__4423__auto__ = nodes[j];
        if (cljs.core.truth_(temp__4423__auto__)) {
          var nj = temp__4423__auto__;
          var temp__4423__auto____$1 = nj.inode_seq();
          if (cljs.core.truth_(temp__4423__auto____$1)) {
            var ns = temp__4423__auto____$1;
            return new cljs.core.ArrayNodeSeq(meta, nodes, j + 1, ns, null);
          } else {
            var G__10241 = j + 1;
            j = G__10241;
            continue;
          }
        } else {
          var G__10242 = j + 1;
          j = G__10242;
          continue;
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null);
  }
};
cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__10244 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__10244) : cljs.core.keys.call(null, G__10244);
  }());
};
cljs.core.PersistentHashMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__10245 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__10245) : cljs.core.vals.call(null, G__10245);
  }());
};
cljs.core.PersistentHashMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__10246 = cljs.core.seq(coll);
  var chunk__10247 = null;
  var count__10248 = 0;
  var i__10249 = 0;
  while (true) {
    if (i__10249 < count__10248) {
      var vec__10250 = chunk__10247.cljs$core$IIndexed$_nth$arity$2(null, i__10249);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10250, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10250, 1, null);
      var G__10251_10262 = v;
      var G__10252_10263 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10251_10262, G__10252_10263) : f.call(null, G__10251_10262, G__10252_10263);
      var G__10264 = seq__10246;
      var G__10265 = chunk__10247;
      var G__10266 = count__10248;
      var G__10267 = i__10249 + 1;
      seq__10246 = G__10264;
      chunk__10247 = G__10265;
      count__10248 = G__10266;
      i__10249 = G__10267;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__10246);
      if (temp__4425__auto__) {
        var seq__10246__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__10246__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__10246__$1);
          var G__10268 = cljs.core.chunk_rest(seq__10246__$1);
          var G__10269 = c__5094__auto__;
          var G__10270 = cljs.core.count(c__5094__auto__);
          var G__10271 = 0;
          seq__10246 = G__10268;
          chunk__10247 = G__10269;
          count__10248 = G__10270;
          i__10249 = G__10271;
          continue;
        } else {
          var vec__10253 = cljs.core.first(seq__10246__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10253, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10253, 1, null);
          var G__10254_10272 = v;
          var G__10255_10273 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10254_10272, G__10255_10273) : f.call(null, G__10254_10272, G__10255_10273);
          var G__10274 = cljs.core.next(seq__10246__$1);
          var G__10275 = null;
          var G__10276 = 0;
          var G__10277 = 0;
          seq__10246 = G__10274;
          chunk__10247 = G__10275;
          count__10248 = G__10276;
          i__10249 = G__10277;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var init__$1 = self__.has_nil_QMARK_ ? function() {
    var G__10256 = init;
    var G__10257 = null;
    var G__10258 = self__.nil_val;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10256, G__10257, G__10258) : f.call(null, G__10256, G__10257, G__10258);
  }() : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    var G__10259 = init__$1;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10259) : cljs.core.deref.call(null, G__10259);
  } else {
    if (!(self__.root == null)) {
      return self__.root.kv_reduce(f, init__$1);
    } else {
      return init__$1;
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashMap(self__.meta, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashMap(function() {
    var obj10261 = {};
    return obj10261;
  }(), self__.root, self__.cnt, self__.has_nil_QMARK_, self__.nil_val);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY, self__.meta);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, self__.root, false, null, null);
    } else {
      return coll__$1;
    }
  } else {
    if (self__.root == null) {
      return coll__$1;
    } else {
      var new_root = self__.root.inode_without(0, cljs.core.hash(k), k);
      if (new_root === self__.root) {
        return coll__$1;
      } else {
        return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_ && v === self__.nil_val) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, self__.has_nil_QMARK_ ? self__.cnt : self__.cnt + 1, self__.root, true, v, null);
    }
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    var new_root = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc(0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
    if (new_root === self__.root) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, added_leaf_QMARK_.val ? self__.cnt + 1 : self__.cnt, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    return self__.has_nil_QMARK_;
  } else {
    if (self__.root == null) {
      return false;
    } else {
      return !(self__.root.inode_lookup(0, cljs.core.hash(k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var s = !(self__.root == null) ? self__.root.inode_seq() : null;
    if (self__.has_nil_QMARK_) {
      return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null), s);
    } else {
      return s;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashMap(meta__$1, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__10278 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__10279 = cljs.core.next(es);
          ret = G__10278;
          es = G__10279;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__10280 = null;
  var G__10280__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10280__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10280 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10280__2.call(this, self__, k);
      case 3:
        return G__10280__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10280.cljs$core$IFn$_invoke$arity$2 = G__10280__2;
  G__10280.cljs$core$IFn$_invoke$arity$3 = G__10280__3;
  return G__10280;
}();
cljs.core.PersistentHashMap.prototype.apply = function(self__, args10243) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10243)));
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";
cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentHashMap");
};
cljs.core.__GT_PersistentHashMap = function cljs$core$__GT_PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  return new cljs.core.PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash);
};
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashMap.fromArray = function(arr, no_clone) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var len = arr__$1.length;
  var i = 0;
  var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__10281 = i + 2;
      var G__10282 = cljs.core._assoc_BANG_(ret, arr__$1[i], arr__$1[i + 1]);
      i = G__10281;
      ret = G__10282;
      continue;
    } else {
      return cljs.core._persistent_BANG_(ret);
    }
    break;
  }
};
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len = ks.length;
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__10283 = i + 1;
      var G__10284 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, ks[i], vs[i]);
      i = G__10283;
      out = G__10284;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (function() {
      var G__10285 = o;
      if (G__10285) {
        var bit__4983__auto__ = G__10285.cljs$lang$protocol_mask$partition0$ & 2048;
        if (bit__4983__auto__ || G__10285.cljs$core$IMapEntry$) {
          return true;
        } else {
          if (!G__10285.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__10285);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__10285);
      }
    }()) {
      return tcoll.assoc_BANG_(function() {
        var G__10286 = o;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10286) : cljs.core.key.call(null, G__10286);
      }(), function() {
        var G__10287 = o;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__10287) : cljs.core.val.call(null, G__10287);
      }());
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$1 = tcoll;
      while (true) {
        var temp__4423__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          var G__10290 = cljs.core.next(es);
          var G__10291 = tcoll__$1.assoc_BANG_(function() {
            var G__10288 = e;
            return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10288) : cljs.core.key.call(null, G__10288);
          }(), function() {
            var G__10289 = e;
            return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__10289) : cljs.core.val.call(null, G__10289);
          }());
          es = G__10290;
          tcoll__$1 = G__10291;
          continue;
        } else {
          return tcoll__$1;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.nil_val === v) {
      } else {
        self__.nil_val = v;
      }
      if (self__.has_nil_QMARK_) {
      } else {
        self__.count = self__.count + 1;
        self__.has_nil_QMARK_ = true;
      }
      return tcoll;
    } else {
      var added_leaf_QMARK_ = new cljs.core.Box(false);
      var node = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc_BANG_(self__.edit, 0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
      if (node === self__.root) {
      } else {
        self__.root = node;
      }
      if (added_leaf_QMARK_.val) {
        self__.count = self__.count + 1;
      } else {
      }
      return tcoll;
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.has_nil_QMARK_) {
        self__.has_nil_QMARK_ = false;
        self__.nil_val = null;
        self__.count = self__.count - 1;
        return tcoll;
      } else {
        return tcoll;
      }
    } else {
      if (self__.root == null) {
        return tcoll;
      } else {
        var removed_leaf_QMARK_ = new cljs.core.Box(false);
        var node = self__.root.inode_without_BANG_(self__.edit, 0, cljs.core.hash(k), k, removed_leaf_QMARK_);
        if (node === self__.root) {
        } else {
          self__.root = node;
        }
        if (cljs.core.truth_(removed_leaf_QMARK_[0])) {
          self__.count = self__.count - 1;
        } else {
        }
        return tcoll;
      }
    }
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    self__.edit = null;
    return new cljs.core.PersistentHashMap(null, self__.count, self__.root, self__.has_nil_QMARK_, self__.nil_val, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.edit) {
    return self__.count;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return null;
    }
  } else {
    if (self__.root == null) {
      return null;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.conj_BANG_(val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.persistent_BANG_();
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.assoc_BANG_(key, val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.without_BANG_(key);
};
cljs.core.TransientHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null)], null);
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";
cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientHashMap");
};
cljs.core.__GT_TransientHashMap = function cljs$core$__GT_TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val) {
  return new cljs.core.TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val);
};
cljs.core.tree_map_seq_push = function cljs$core$tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t = node;
  var stack__$1 = stack;
  while (true) {
    if (!(t == null)) {
      var G__10292 = ascending_QMARK_ ? t.left : t.right;
      var G__10293 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1, t);
      t = G__10292;
      stack__$1 = G__10293;
      continue;
    } else {
      return stack__$1;
    }
    break;
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374862;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt < 0) {
    return cljs.core.count(cljs.core.next(coll__$1)) + 1;
  } else {
    return self__.cnt;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.peek(self__.stack);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var t = cljs.core.first(self__.stack);
  var next_stack = cljs.core.tree_map_seq_push(self__.ascending_QMARK_ ? t.right : t.left, cljs.core.next(self__.stack), self__.ascending_QMARK_);
  if (!(next_stack == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack, self__.ascending_QMARK_, self__.cnt - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMapSeq(meta__$1, self__.stack, self__.ascending_QMARK_, self__.cnt, self__.__hash);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentTreeMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "stack", "stack", 847125597, null), new cljs.core.Symbol(null, "ascending?", "ascending?", -1938452653, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentTreeMapSeq");
};
cljs.core.__GT_PersistentTreeMapSeq = function cljs$core$__GT_PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash) {
  return new cljs.core.PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash);
};
cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.create_tree_map_seq = function cljs$core$create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push(tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null);
};
cljs.core.balance_left = function cljs$core$balance_left(key, val, ins, right) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null);
    } else {
      if (ins.right instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, ins, right, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, ins, right, null);
  }
};
cljs.core.balance_right = function cljs$core$balance_right(key, val, left, ins) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null);
    } else {
      if (ins.left instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, left, ins, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, left, ins, null);
  }
};
cljs.core.balance_left_del = function cljs$core$balance_left_del(key, val, del, right) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null);
  } else {
    if (right instanceof cljs.core.BlackNode) {
      return cljs.core.balance_right(key, val, del, right.redden());
    } else {
      if (right instanceof cljs.core.RedNode && right.left instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right(right.key, right.val, right.left.right, right.right.redden()), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.balance_right_del = function cljs$core$balance_right_del(key, val, left, del) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null);
  } else {
    if (left instanceof cljs.core.BlackNode) {
      return cljs.core.balance_left(key, val, left.redden(), del);
    } else {
      if (left instanceof cljs.core.RedNode && left.right instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left(left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function cljs$core$tree_map_kv_reduce(node, f, init) {
  var init__$1 = !(node.left == null) ? cljs$core$tree_map_kv_reduce(node.left, f, init) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    var G__10306 = init__$1;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10306) : cljs.core.deref.call(null, G__10306);
  } else {
    var init__$2 = function() {
      var G__10307 = init__$1;
      var G__10308 = node.key;
      var G__10309 = node.val;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10307, G__10308, G__10309) : f.call(null, G__10307, G__10308, G__10309);
    }();
    if (cljs.core.reduced_QMARK_(init__$2)) {
      var G__10310 = init__$2;
      return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10310) : cljs.core.deref.call(null, G__10310);
    } else {
      var init__$3 = !(node.right == null) ? cljs$core$tree_map_kv_reduce(node.right, f, init__$2) : init__$2;
      if (cljs.core.reduced_QMARK_(init__$3)) {
        var G__10311 = init__$3;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10311) : cljs.core.deref.call(null, G__10311);
      } else {
        return init__$3;
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_right(node);
};
cljs.core.BlackNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.BlackNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return node;
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_left(node);
};
cljs.core.BlackNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
};
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_left_del(self__.key, self__.val, del, self__.right);
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_right_del(self__.key, self__.val, self__.left, del);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY, self__.val), self__.key);
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.BlackNode.prototype.call = function() {
  var G__10313 = null;
  var G__10313__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10313__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10313 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10313__2.call(this, self__, k);
      case 3:
        return G__10313__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10313.cljs$core$IFn$_invoke$arity$2 = G__10313__2;
  G__10313.cljs$core$IFn$_invoke$arity$3 = G__10313__3;
  return G__10313;
}();
cljs.core.BlackNode.prototype.apply = function(self__, args10312) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10312)));
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.BlackNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";
cljs.core.BlackNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/BlackNode");
};
cljs.core.__GT_BlackNode = function cljs$core$__GT_BlackNode(key, val, left, right, __hash) {
  return new cljs.core.BlackNode(key, val, left, right, __hash);
};
cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, ins, null);
};
cljs.core.RedNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, ins, self__.right, null);
};
cljs.core.RedNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.left instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, self__.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, self__.right, parent.right, null), null);
  } else {
    if (self__.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.right.key, self__.right.val, new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, self__.right.right, parent.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
    }
  }
};
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.right instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left, null), self__.right.blacken(), null);
  } else {
    if (self__.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.left.key, self__.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left.left, null), new cljs.core.BlackNode(self__.key, self__.val, self__.left.right, self__.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
    }
  }
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, del, self__.right, null);
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, del, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY, self__.val), self__.key);
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.RedNode.prototype.call = function() {
  var G__10315 = null;
  var G__10315__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10315__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10315 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10315__2.call(this, self__, k);
      case 3:
        return G__10315__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10315.cljs$core$IFn$_invoke$arity$2 = G__10315__2;
  G__10315.cljs$core$IFn$_invoke$arity$3 = G__10315__3;
  return G__10315;
}();
cljs.core.RedNode.prototype.apply = function(self__, args10314) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10314)));
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.RedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";
cljs.core.RedNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RedNode");
};
cljs.core.__GT_RedNode = function cljs$core$__GT_RedNode(key, val, left, right, __hash) {
  return new cljs.core.RedNode(key, val, left, right, __hash);
};
cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.tree_map_add = function cljs$core$tree_map_add(comp, tree, k, v, found) {
  if (tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null);
  } else {
    var c = function() {
      var G__10328 = k;
      var G__10329 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__10328, G__10329) : comp.call(null, G__10328, G__10329);
    }();
    if (c === 0) {
      found[0] = tree;
      return null;
    } else {
      if (c < 0) {
        var ins = cljs$core$tree_map_add(comp, tree.left, k, v, found);
        if (!(ins == null)) {
          return tree.add_left(ins);
        } else {
          return null;
        }
      } else {
        var ins = cljs$core$tree_map_add(comp, tree.right, k, v, found);
        if (!(ins == null)) {
          return tree.add_right(ins);
        } else {
          return null;
        }
      }
    }
  }
};
cljs.core.tree_map_append = function cljs$core$tree_map_append(left, right) {
  if (left == null) {
    return right;
  } else {
    if (right == null) {
      return left;
    } else {
      if (left instanceof cljs.core.RedNode) {
        if (right instanceof cljs.core.RedNode) {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.RedNode(left.key, left.val, left.left, app.left, null), new cljs.core.RedNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app, right.right, null), null);
          }
        } else {
          return new cljs.core.RedNode(left.key, left.val, left.left, cljs$core$tree_map_append(left.right, right), null);
        }
      } else {
        if (right instanceof cljs.core.RedNode) {
          return new cljs.core.RedNode(right.key, right.val, cljs$core$tree_map_append(left, right.left), right.right, null);
        } else {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.BlackNode(left.key, left.val, left.left, app.left, null), new cljs.core.BlackNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return cljs.core.balance_left_del(left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app, right.right, null));
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function cljs$core$tree_map_remove(comp, tree, k, found) {
  if (!(tree == null)) {
    var c = function() {
      var G__10348 = k;
      var G__10349 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__10348, G__10349) : comp.call(null, G__10348, G__10349);
    }();
    if (c === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append(tree.left, tree.right);
    } else {
      if (c < 0) {
        var del = cljs$core$tree_map_remove(comp, tree.left, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.left instanceof cljs.core.BlackNode) {
            return cljs.core.balance_left_del(tree.key, tree.val, del, tree.right);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, del, tree.right, null);
          }
        } else {
          return null;
        }
      } else {
        var del = cljs$core$tree_map_remove(comp, tree.right, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.right instanceof cljs.core.BlackNode) {
            return cljs.core.balance_right_del(tree.key, tree.val, tree.left, del);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, tree.left, del, null);
          }
        } else {
          return null;
        }
      }
    }
  } else {
    return null;
  }
};
cljs.core.tree_map_replace = function cljs$core$tree_map_replace(comp, tree, k, v) {
  var tk = tree.key;
  var c = function() {
    var G__10360 = k;
    var G__10361 = tk;
    return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__10360, G__10361) : comp.call(null, G__10360, G__10361);
  }();
  if (c === 0) {
    return tree.replace(tk, v, tree.left, tree.right);
  } else {
    if (c < 0) {
      return tree.replace(tk, tree.val, cljs$core$tree_map_replace(comp, tree.left, k, v), tree.right);
    } else {
      return tree.replace(tk, tree.val, tree.left, cljs$core$tree_map_replace(comp, tree.right, k, v));
    }
  }
};
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 418776847;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__10363 = cljs.core.seq(coll);
  var chunk__10364 = null;
  var count__10365 = 0;
  var i__10366 = 0;
  while (true) {
    if (i__10366 < count__10365) {
      var vec__10367 = chunk__10364.cljs$core$IIndexed$_nth$arity$2(null, i__10366);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10367, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10367, 1, null);
      var G__10368_10380 = v;
      var G__10369_10381 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10368_10380, G__10369_10381) : f.call(null, G__10368_10380, G__10369_10381);
      var G__10382 = seq__10363;
      var G__10383 = chunk__10364;
      var G__10384 = count__10365;
      var G__10385 = i__10366 + 1;
      seq__10363 = G__10382;
      chunk__10364 = G__10383;
      count__10365 = G__10384;
      i__10366 = G__10385;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__10363);
      if (temp__4425__auto__) {
        var seq__10363__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__10363__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__10363__$1);
          var G__10386 = cljs.core.chunk_rest(seq__10363__$1);
          var G__10387 = c__5094__auto__;
          var G__10388 = cljs.core.count(c__5094__auto__);
          var G__10389 = 0;
          seq__10363 = G__10386;
          chunk__10364 = G__10387;
          count__10365 = G__10388;
          i__10366 = G__10389;
          continue;
        } else {
          var vec__10370 = cljs.core.first(seq__10363__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10370, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10370, 1, null);
          var G__10371_10390 = v;
          var G__10372_10391 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10371_10390, G__10372_10391) : f.call(null, G__10371_10390, G__10372_10391);
          var G__10392 = cljs.core.next(seq__10363__$1);
          var G__10393 = null;
          var G__10394 = 0;
          var G__10395 = 0;
          seq__10363 = G__10392;
          chunk__10364 = G__10393;
          count__10365 = G__10394;
          i__10366 = G__10395;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__10373 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__10373) : cljs.core.keys.call(null, G__10373);
  }());
};
cljs.core.PersistentTreeMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__10374 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__10374) : cljs.core.vals.call(null, G__10374);
  }());
};
cljs.core.PersistentTreeMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var self__ = this;
  var coll = this;
  var t = self__.tree;
  while (true) {
    if (!(t == null)) {
      var c = function() {
        var G__10375 = k;
        var G__10376 = t.key;
        return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__10375, G__10376) : self__.comp.call(null, G__10375, G__10376);
      }();
      if (c === 0) {
        return t;
      } else {
        if (c < 0) {
          var G__10396 = t.left;
          t = G__10396;
          continue;
        } else {
          var G__10397 = t.right;
          t = G__10397;
          continue;
        }
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var n = coll__$1.entry_at(k);
  if (!(n == null)) {
    return n.val;
  } else {
    return not_found;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.tree == null)) {
    return cljs.core.tree_map_kv_reduce(self__.tree, f, init);
  } else {
    return init;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, self__.meta, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, false, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, 0);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_remove(self__.comp, self__.tree, k, found);
  if (t == null) {
    if (cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0) == null) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt - 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_add(self__.comp, self__.tree, k, v, found);
  if (t == null) {
    var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0);
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v, found_node.val)) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, cljs.core.tree_map_replace(self__.comp, self__.tree, k, v), self__.cnt, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt + 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(coll__$1.entry_at(k) == null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, true, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, meta__$1, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__10398 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__10399 = cljs.core.next(es);
          ret = G__10398;
          es = G__10399;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__10400 = null;
  var G__10400__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10400__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10400 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10400__2.call(this, self__, k);
      case 3:
        return G__10400__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10400.cljs$core$IFn$_invoke$arity$2 = G__10400__2;
  G__10400.cljs$core$IFn$_invoke$arity$3 = G__10400__3;
  return G__10400;
}();
cljs.core.PersistentTreeMap.prototype.apply = function(self__, args10362) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10362)));
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, ascending_QMARK_, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var stack = null;
    var t = self__.tree;
    while (true) {
      if (!(t == null)) {
        var c = function() {
          var G__10377 = k;
          var G__10378 = t.key;
          return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__10377, G__10378) : self__.comp.call(null, G__10377, G__10378);
        }();
        if (c === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t), ascending_QMARK_, -1, null);
        } else {
          if (cljs.core.truth_(ascending_QMARK_)) {
            if (c < 0) {
              var G__10401 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__10402 = t.left;
              stack = G__10401;
              t = G__10402;
              continue;
            } else {
              var G__10403 = stack;
              var G__10404 = t.right;
              stack = G__10403;
              t = G__10404;
              continue;
            }
          } else {
            if (c > 0) {
              var G__10405 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__10406 = t.right;
              stack = G__10405;
              t = G__10406;
              continue;
            } else {
              var G__10407 = stack;
              var G__10408 = t.left;
              stack = G__10407;
              t = G__10408;
              continue;
            }
          }
        }
      } else {
        if (stack == null) {
          return null;
        } else {
          return new cljs.core.PersistentTreeMapSeq(null, stack, ascending_QMARK_, -1, null);
        }
      }
      break;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  var G__10379 = entry;
  return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10379) : cljs.core.key.call(null, G__10379);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.comp;
};
cljs.core.PersistentTreeMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "comp", "comp", -1462482139, null), new cljs.core.Symbol(null, "tree", "tree", 1444219499, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";
cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentTreeMap");
};
cljs.core.__GT_PersistentTreeMap = function cljs$core$__GT_PersistentTreeMap(comp, tree, cnt, meta, __hash) {
  return new cljs.core.PersistentTreeMap(comp, tree, cnt, meta, __hash);
};
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.hash_map = function cljs$core$hash_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (in$) {
      var G__10410 = cljs.core.nnext(in$);
      var G__10411 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__10410;
      out = G__10411;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.hash_map.cljs$lang$maxFixedArity = 0;
cljs.core.hash_map.cljs$lang$applyTo = function(seq10409) {
  return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10409));
};
cljs.core.array_map = function cljs$core$array_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var arr = keyvals instanceof cljs.core.IndexedSeq && keyvals.i === 0 ? keyvals.arr : cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals);
  return cljs.core.PersistentArrayMap.fromArray(arr, true, false);
};
cljs.core.array_map.cljs$lang$maxFixedArity = 0;
cljs.core.array_map.cljs$lang$applyTo = function(seq10412) {
  return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10412));
};
cljs.core.obj_map = function cljs$core$obj_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var ks = [];
  var obj = function() {
    var obj10415 = {};
    return obj10415;
  }();
  var kvs = cljs.core.seq(keyvals);
  while (true) {
    if (kvs) {
      ks.push(cljs.core.first(kvs));
      obj[cljs.core.first(kvs)] = cljs.core.second(kvs);
      var G__10416 = cljs.core.nnext(kvs);
      kvs = G__10416;
      continue;
    } else {
      return cljs.core.ObjMap.fromObject(ks, obj);
    }
    break;
  }
};
cljs.core.obj_map.cljs$lang$maxFixedArity = 0;
cljs.core.obj_map.cljs$lang$applyTo = function(seq10413) {
  return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10413));
};
cljs.core.sorted_map = function cljs$core$sorted_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = cljs.core.PersistentTreeMap.EMPTY;
  while (true) {
    if (in$) {
      var G__10418 = cljs.core.nnext(in$);
      var G__10419 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__10418;
      out = G__10419;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.sorted_map.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_map.cljs$lang$applyTo = function(seq10417) {
  return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10417));
};
cljs.core.sorted_map_by = function cljs$core$sorted_map_by() {
  var argseq__5349__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5349__auto__);
};
cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = function(comparator, keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator), null, 0, null, 0);
  while (true) {
    if (in$) {
      var G__10422 = cljs.core.nnext(in$);
      var G__10423 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__10422;
      out = G__10423;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.sorted_map_by.cljs$lang$maxFixedArity = 1;
cljs.core.sorted_map_by.cljs$lang$applyTo = function(seq10420) {
  var G__10421 = cljs.core.first(seq10420);
  var seq10420__$1 = cljs.core.next(seq10420);
  return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__10421, seq10420__$1);
};
cljs.core.KeySeq = function(mseq, _meta) {
  this.mseq = mseq;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.KeySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.KeySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__10424 = self__.mseq;
    if (G__10424) {
      var bit__4983__auto__ = G__10424.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__10424.cljs$core$INext$) {
        return true;
      } else {
        if (!G__10424.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__10424);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__10424);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (nseq == null) {
    return null;
  } else {
    return new cljs.core.KeySeq(nseq, self__._meta);
  }
};
cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
  return me.cljs$core$IMapEntry$_key$arity$1(null);
};
cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__10425 = self__.mseq;
    if (G__10425) {
      var bit__4983__auto__ = G__10425.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__10425.cljs$core$INext$) {
        return true;
      } else {
        if (!G__10425.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__10425);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__10425);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (!(nseq == null)) {
    return new cljs.core.KeySeq(nseq, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.KeySeq(self__.mseq, new_meta);
};
cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.KeySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "mseq", "mseq", 1602647196, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.KeySeq.cljs$lang$type = true;
cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";
cljs.core.KeySeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/KeySeq");
};
cljs.core.__GT_KeySeq = function cljs$core$__GT_KeySeq(mseq, _meta) {
  return new cljs.core.KeySeq(mseq, _meta);
};
cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.keys = function cljs$core$keys(hash_map) {
  var temp__4425__auto__ = cljs.core.seq(hash_map);
  if (temp__4425__auto__) {
    var mseq = temp__4425__auto__;
    return new cljs.core.KeySeq(mseq, null);
  } else {
    return null;
  }
};
cljs.core.key = function cljs$core$key(map_entry) {
  return cljs.core._key(map_entry);
};
cljs.core.ValSeq = function(mseq, _meta) {
  this.mseq = mseq;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ValSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ValSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__10426 = self__.mseq;
    if (G__10426) {
      var bit__4983__auto__ = G__10426.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__10426.cljs$core$INext$) {
        return true;
      } else {
        if (!G__10426.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__10426);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__10426);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (nseq == null) {
    return null;
  } else {
    return new cljs.core.ValSeq(nseq, self__._meta);
  }
};
cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
  return me.cljs$core$IMapEntry$_val$arity$1(null);
};
cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__10427 = self__.mseq;
    if (G__10427) {
      var bit__4983__auto__ = G__10427.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__10427.cljs$core$INext$) {
        return true;
      } else {
        if (!G__10427.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__10427);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__10427);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (!(nseq == null)) {
    return new cljs.core.ValSeq(nseq, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ValSeq(self__.mseq, new_meta);
};
cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ValSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "mseq", "mseq", 1602647196, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.ValSeq.cljs$lang$type = true;
cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";
cljs.core.ValSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ValSeq");
};
cljs.core.__GT_ValSeq = function cljs$core$__GT_ValSeq(mseq, _meta) {
  return new cljs.core.ValSeq(mseq, _meta);
};
cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.vals = function cljs$core$vals(hash_map) {
  var temp__4425__auto__ = cljs.core.seq(hash_map);
  if (temp__4425__auto__) {
    var mseq = temp__4425__auto__;
    return new cljs.core.ValSeq(mseq, null);
  } else {
    return null;
  }
};
cljs.core.val = function cljs$core$val(map_entry) {
  return cljs.core._val(map_entry);
};
cljs.core.merge = function cljs$core$merge() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = function(maps) {
  if (cljs.core.truth_(cljs.core.some(cljs.core.identity, maps))) {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(function(p1__10428_SHARP_, p2__10429_SHARP_) {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
        var or__4309__auto__ = p1__10428_SHARP_;
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.PersistentArrayMap.EMPTY;
        }
      }(), p2__10429_SHARP_);
    }, maps);
  } else {
    return null;
  }
};
cljs.core.merge.cljs$lang$maxFixedArity = 0;
cljs.core.merge.cljs$lang$applyTo = function(seq10430) {
  return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10430));
};
cljs.core.merge_with = function cljs$core$merge_with() {
  var argseq__5349__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5349__auto__);
};
cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = function(f, maps) {
  if (cljs.core.truth_(cljs.core.some(cljs.core.identity, maps))) {
    var merge_entry = function(m, e) {
      var k = cljs.core.first(e);
      var v = cljs.core.second(e);
      if (cljs.core.contains_QMARK_(m, k)) {
        return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
          var G__10433 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
          var G__10434 = v;
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10433, G__10434) : f.call(null, G__10433, G__10434);
        }());
      } else {
        return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
      }
    };
    var merge2 = function(merge_entry) {
      return function(m1, m2) {
        return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry, function() {
          var or__4309__auto__ = m1;
          if (cljs.core.truth_(or__4309__auto__)) {
            return or__4309__auto__;
          } else {
            return cljs.core.PersistentArrayMap.EMPTY;
          }
        }(), cljs.core.seq(m2));
      };
    }(merge_entry);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2, maps);
  } else {
    return null;
  }
};
cljs.core.merge_with.cljs$lang$maxFixedArity = 1;
cljs.core.merge_with.cljs$lang$applyTo = function(seq10431) {
  var G__10432 = cljs.core.first(seq10431);
  var seq10431__$1 = cljs.core.next(seq10431);
  return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__10432, seq10431__$1);
};
cljs.core.select_keys = function cljs$core$select_keys(map, keyseq) {
  var ret = cljs.core.PersistentArrayMap.EMPTY;
  var keys = cljs.core.seq(keyseq);
  while (true) {
    if (keys) {
      var key = cljs.core.first(keys);
      var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map, key, new cljs.core.Keyword("cljs.core", "not-found", "cljs.core/not-found", -1572889185));
      var G__10435 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry, new cljs.core.Keyword("cljs.core", "not-found", "cljs.core/not-found", -1572889185)) ? cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret, key, entry) : ret;
      var G__10436 = cljs.core.next(keys);
      ret = G__10435;
      keys = G__10436;
      continue;
    } else {
      return cljs.core.with_meta(ret, cljs.core.meta(map));
    }
    break;
  }
};
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 15077647;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashSet.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashSet.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashSet.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__10439 = cljs.core.seq(coll);
  var chunk__10440 = null;
  var count__10441 = 0;
  var i__10442 = 0;
  while (true) {
    if (i__10442 < count__10441) {
      var vec__10443 = chunk__10440.cljs$core$IIndexed$_nth$arity$2(null, i__10442);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10443, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10443, 1, null);
      var G__10444_10449 = v;
      var G__10445_10450 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10444_10449, G__10445_10450) : f.call(null, G__10444_10449, G__10445_10450);
      var G__10451 = seq__10439;
      var G__10452 = chunk__10440;
      var G__10453 = count__10441;
      var G__10454 = i__10442 + 1;
      seq__10439 = G__10451;
      chunk__10440 = G__10452;
      count__10441 = G__10453;
      i__10442 = G__10454;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__10439);
      if (temp__4425__auto__) {
        var seq__10439__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__10439__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__10439__$1);
          var G__10455 = cljs.core.chunk_rest(seq__10439__$1);
          var G__10456 = c__5094__auto__;
          var G__10457 = cljs.core.count(c__5094__auto__);
          var G__10458 = 0;
          seq__10439 = G__10455;
          chunk__10440 = G__10456;
          count__10441 = G__10457;
          i__10442 = G__10458;
          continue;
        } else {
          var vec__10446 = cljs.core.first(seq__10439__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10446, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10446, 1, null);
          var G__10447_10459 = v;
          var G__10448_10460 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10447_10459, G__10448_10460) : f.call(null, G__10447_10459, G__10448_10460);
          var G__10461 = cljs.core.next(seq__10439__$1);
          var G__10462 = null;
          var G__10463 = 0;
          var G__10464 = 0;
          seq__10439 = G__10461;
          chunk__10440 = G__10462;
          count__10441 = G__10463;
          i__10442 = G__10464;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, v, null);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._contains_key_QMARK_(self__.hash_map, v)) {
    return v;
  } else {
    return not_found;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, self__.hash_map, self__.__hash);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._count(self__.hash_map);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.set_QMARK_(other) && cljs.core.count(coll__$1) === cljs.core.count(other) && cljs.core.every_QMARK_(function(coll__$1) {
    return function(p1__10437_SHARP_) {
      return cljs.core.contains_QMARK_(coll__$1, p1__10437_SHARP_);
    };
  }(coll__$1), other);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map));
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY, self__.meta);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, cljs.core._dissoc(self__.hash_map, v), null);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.keys(self__.hash_map);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(meta__$1, self__.hash_map, self__.__hash);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map, o, null), null);
};
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__10465 = null;
  var G__10465__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10465__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10465 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10465__2.call(this, self__, k);
      case 3:
        return G__10465__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10465.cljs$core$IFn$_invoke$arity$2 = G__10465__2;
  G__10465.cljs$core$IFn$_invoke$arity$3 = G__10465__3;
  return G__10465;
}();
cljs.core.PersistentHashSet.prototype.apply = function(self__, args10438) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10438)));
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashSet.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "hash-map", "hash-map", -439030950, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";
cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentHashSet");
};
cljs.core.__GT_PersistentHashSet = function cljs$core$__GT_PersistentHashSet(meta, hash_map, __hash) {
  return new cljs.core.PersistentHashSet(meta, hash_map, __hash);
};
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.PersistentArrayMap.EMPTY, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashSet.fromArray = function(items, no_clone) {
  var len = items.length;
  if (len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
    var arr = no_clone ? items : cljs.core.aclone(items);
    var i = 0;
    var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
    while (true) {
      if (i < len) {
        var G__10466 = i + 1;
        var G__10467 = cljs.core._assoc_BANG_(out, items[i], null);
        i = G__10466;
        out = G__10467;
        continue;
      } else {
        return new cljs.core.PersistentHashSet(null, cljs.core._persistent_BANG_(out), null);
      }
      break;
    }
  } else {
    var i = 0;
    var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
    while (true) {
      if (i < len) {
        var G__10468 = i + 1;
        var G__10469 = cljs.core._conj_BANG_(out, items[i]);
        i = G__10468;
        out = G__10469;
        continue;
      } else {
        return cljs.core._persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition1$ = 136;
  this.cljs$lang$protocol_mask$partition0$ = 259;
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map, o, null);
  return tcoll__$1;
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_(self__.transient_map), null);
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var self__ = this;
  var tcoll__$1 = this;
  self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map, v);
  return tcoll__$1;
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core.count(self__.transient_map);
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, v, null);
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found;
  } else {
    return v;
  }
};
cljs.core.TransientHashSet.prototype.call = function() {
  var G__10471 = null;
  var G__10471__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null;
    } else {
      return k;
    }
  };
  var G__10471__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found;
    } else {
      return k;
    }
  };
  G__10471 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10471__2.call(this, self__, k);
      case 3:
        return G__10471__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10471.cljs$core$IFn$_invoke$arity$2 = G__10471__2;
  G__10471.cljs$core$IFn$_invoke$arity$3 = G__10471__3;
  return G__10471;
}();
cljs.core.TransientHashSet.prototype.apply = function(self__, args10470) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10470)));
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var tcoll = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return null;
  } else {
    return k;
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var tcoll = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found;
  } else {
    return k;
  }
};
cljs.core.TransientHashSet.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "transient-map", "transient-map", 351764893, null)], null);
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";
cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientHashSet");
};
cljs.core.__GT_TransientHashSet = function cljs$core$__GT_TransientHashSet(transient_map) {
  return new cljs.core.TransientHashSet(transient_map);
};
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 417730831;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeSet.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeSet.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentTreeSet.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__10474 = cljs.core.seq(coll);
  var chunk__10475 = null;
  var count__10476 = 0;
  var i__10477 = 0;
  while (true) {
    if (i__10477 < count__10476) {
      var vec__10478 = chunk__10475.cljs$core$IIndexed$_nth$arity$2(null, i__10477);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10478, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10478, 1, null);
      var G__10479_10484 = v;
      var G__10480_10485 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10479_10484, G__10480_10485) : f.call(null, G__10479_10484, G__10480_10485);
      var G__10486 = seq__10474;
      var G__10487 = chunk__10475;
      var G__10488 = count__10476;
      var G__10489 = i__10477 + 1;
      seq__10474 = G__10486;
      chunk__10475 = G__10487;
      count__10476 = G__10488;
      i__10477 = G__10489;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__10474);
      if (temp__4425__auto__) {
        var seq__10474__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__10474__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__10474__$1);
          var G__10490 = cljs.core.chunk_rest(seq__10474__$1);
          var G__10491 = c__5094__auto__;
          var G__10492 = cljs.core.count(c__5094__auto__);
          var G__10493 = 0;
          seq__10474 = G__10490;
          chunk__10475 = G__10491;
          count__10476 = G__10492;
          i__10477 = G__10493;
          continue;
        } else {
          var vec__10481 = cljs.core.first(seq__10474__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10481, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10481, 1, null);
          var G__10482_10494 = v;
          var G__10483_10495 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10482_10494, G__10483_10495) : f.call(null, G__10482_10494, G__10483_10495);
          var G__10496 = cljs.core.next(seq__10474__$1);
          var G__10497 = null;
          var G__10498 = 0;
          var G__10499 = 0;
          seq__10474 = G__10496;
          chunk__10475 = G__10497;
          count__10476 = G__10498;
          i__10477 = G__10499;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, v, null);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var n = self__.tree_map.entry_at(v);
  if (!(n == null)) {
    return n.key;
  } else {
    return not_found;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, self__.tree_map, self__.__hash);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.count(self__.tree_map);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.count(self__.tree_map) > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core.rseq(self__.tree_map));
  } else {
    return null;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.set_QMARK_(other) && cljs.core.count(coll__$1) === cljs.core.count(other) && cljs.core.every_QMARK_(function(coll__$1) {
    return function(p1__10472_SHARP_) {
      return cljs.core.contains_QMARK_(coll__$1, p1__10472_SHARP_);
    };
  }(coll__$1), other);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core._empty(self__.tree_map), 0);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map, v), null);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.keys(self__.tree_map);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(meta__$1, self__.tree_map, self__.__hash);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map, o, null), null);
};
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__10500 = null;
  var G__10500__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10500__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10500 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10500__2.call(this, self__, k);
      case 3:
        return G__10500__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10500.cljs$core$IFn$_invoke$arity$2 = G__10500__2;
  G__10500.cljs$core$IFn$_invoke$arity$3 = G__10500__3;
  return G__10500;
}();
cljs.core.PersistentTreeSet.prototype.apply = function(self__, args10473) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10473)));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core._sorted_seq(self__.tree_map, ascending_QMARK_));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core._sorted_seq_from(self__.tree_map, k, ascending_QMARK_));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  return entry;
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._comparator(self__.tree_map);
};
cljs.core.PersistentTreeSet.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "tree-map", "tree-map", 1373073049, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";
cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentTreeSet");
};
cljs.core.__GT_PersistentTreeSet = function cljs$core$__GT_PersistentTreeSet(meta, tree_map, __hash) {
  return new cljs.core.PersistentTreeSet(meta, tree_map, __hash);
};
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.PersistentTreeMap.EMPTY, cljs.core.empty_unordered_hash);
cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.set_from_indexed_seq = function cljs$core$set_from_indexed_seq(iseq) {
  var arr = iseq.arr;
  var ret = function() {
    var a__5188__auto__ = arr;
    var i = 0;
    var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
    while (true) {
      if (i < a__5188__auto__.length) {
        var G__10501 = i + 1;
        var G__10502 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, arr[i]);
        i = G__10501;
        res = G__10502;
        continue;
      } else {
        return res;
      }
      break;
    }
  }();
  return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
};
cljs.core.set = function cljs$core$set(coll) {
  var in$ = cljs.core.seq(coll);
  if (in$ == null) {
    return cljs.core.PersistentHashSet.EMPTY;
  } else {
    if (in$ instanceof cljs.core.IndexedSeq && in$.i === 0) {
      return cljs.core.set_from_indexed_seq(in$);
    } else {
      var in$__$1 = in$;
      var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
      while (true) {
        if (!(in$__$1 == null)) {
          var G__10503 = cljs.core.next(in$__$1);
          var G__10504 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, in$__$1.cljs$core$ISeq$_first$arity$1(null));
          in$__$1 = G__10503;
          out = G__10504;
          continue;
        } else {
          return cljs.core.persistent_BANG_(out);
        }
        break;
      }
    }
  }
};
cljs.core.hash_set = function cljs$core$hash_set() {
  var G__10507 = arguments.length;
  switch(G__10507) {
    case 0:
      return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0);
      return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5360__auto__);
  }
};
cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentHashSet.EMPTY;
};
cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = function(keys) {
  return cljs.core.set(keys);
};
cljs.core.hash_set.cljs$lang$applyTo = function(seq10505) {
  return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10505));
};
cljs.core.hash_set.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_set = function cljs$core$sorted_set() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = function(keys) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys);
};
cljs.core.sorted_set.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_set.cljs$lang$applyTo = function(seq10509) {
  return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10509));
};
cljs.core.sorted_set_by = function cljs$core$sorted_set_by() {
  var argseq__5349__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5349__auto__);
};
cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = function(comparator, keys) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by(comparator), 0), keys);
};
cljs.core.sorted_set_by.cljs$lang$maxFixedArity = 1;
cljs.core.sorted_set_by.cljs$lang$applyTo = function(seq10510) {
  var G__10511 = cljs.core.first(seq10510);
  var seq10510__$1 = cljs.core.next(seq10510);
  return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__10511, seq10510__$1);
};
cljs.core.replace = function cljs$core$replace() {
  var G__10515 = arguments.length;
  switch(G__10515) {
    case 1:
      return cljs.core.replace.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.replace.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = function(smap) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$1(function(p1__10512_SHARP_) {
    var temp__4423__auto__ = cljs.core.find(smap, p1__10512_SHARP_);
    if (cljs.core.truth_(temp__4423__auto__)) {
      var e = temp__4423__auto__;
      return cljs.core.val(e);
    } else {
      return p1__10512_SHARP_;
    }
  });
};
cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = function(smap, coll) {
  if (cljs.core.vector_QMARK_(coll)) {
    var n = cljs.core.count(coll);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(n) {
      return function(v, i) {
        var temp__4423__auto__ = cljs.core.find(smap, cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v, i));
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v, i, cljs.core.second(e));
        } else {
          return v;
        }
      };
    }(n), coll, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.iterate(cljs.core.inc, 0)));
  } else {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(p1__10513_SHARP_) {
      var temp__4423__auto__ = cljs.core.find(smap, p1__10513_SHARP_);
      if (cljs.core.truth_(temp__4423__auto__)) {
        var e = temp__4423__auto__;
        return cljs.core.second(e);
      } else {
        return p1__10513_SHARP_;
      }
    }, coll);
  }
};
cljs.core.replace.cljs$lang$maxFixedArity = 2;
cljs.core.distinct = function cljs$core$distinct() {
  var G__10518 = arguments.length;
  switch(G__10518) {
    case 0:
      return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = function() {
  return function(rf) {
    var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
    return function(seen) {
      return function() {
        var G__10530 = null;
        var G__10530__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10530__1 = function(result) {
          var G__10519 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10519) : rf.call(null, G__10519);
        };
        var G__10530__2 = function(result, input) {
          if (cljs.core.contains_QMARK_(function() {
            var G__10520 = seen;
            return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10520) : cljs.core.deref.call(null, G__10520);
          }(), input)) {
            return result;
          } else {
            cljs.core._vreset_BANG_(seen, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen), input));
            var G__10521 = result;
            var G__10522 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10521, G__10522) : rf.call(null, G__10521, G__10522);
          }
        };
        G__10530 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10530__0.call(this);
            case 1:
              return G__10530__1.call(this, result);
            case 2:
              return G__10530__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10530.cljs$core$IFn$_invoke$arity$0 = G__10530__0;
        G__10530.cljs$core$IFn$_invoke$arity$1 = G__10530__1;
        G__10530.cljs$core$IFn$_invoke$arity$2 = G__10530__2;
        return G__10530;
      }();
    }(seen);
  };
};
cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var step = function cljs$core$step(xs, seen) {
    return new cljs.core.LazySeq(null, function() {
      return function(p__10527, seen__$1) {
        while (true) {
          var vec__10528 = p__10527;
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10528, 0, null);
          var xs__$1 = vec__10528;
          var temp__4425__auto__ = cljs.core.seq(xs__$1);
          if (temp__4425__auto__) {
            var s = temp__4425__auto__;
            if (cljs.core.contains_QMARK_(seen__$1, f)) {
              var G__10531 = cljs.core.rest(s);
              var G__10532 = seen__$1;
              p__10527 = G__10531;
              seen__$1 = G__10532;
              continue;
            } else {
              return cljs.core.cons(f, cljs$core$step(cljs.core.rest(s), cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1, f)));
            }
          } else {
            return null;
          }
          break;
        }
      }.call(null, xs, seen);
    }, null, null);
  };
  return step(coll, cljs.core.PersistentHashSet.EMPTY);
};
cljs.core.distinct.cljs$lang$maxFixedArity = 1;
cljs.core.butlast = function cljs$core$butlast(s) {
  var ret = cljs.core.PersistentVector.EMPTY;
  var s__$1 = s;
  while (true) {
    if (cljs.core.next(s__$1)) {
      var G__10533 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret, cljs.core.first(s__$1));
      var G__10534 = cljs.core.next(s__$1);
      ret = G__10533;
      s__$1 = G__10534;
      continue;
    } else {
      return cljs.core.seq(ret);
    }
    break;
  }
};
cljs.core.name = function cljs$core$name(x) {
  if (function() {
    var G__10536 = x;
    if (G__10536) {
      var bit__4976__auto__ = G__10536.cljs$lang$protocol_mask$partition1$ & 4096;
      if (bit__4976__auto__ || G__10536.cljs$core$INamed$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return x.cljs$core$INamed$_name$arity$1(null);
  } else {
    if (typeof x === "string") {
      return x;
    } else {
      throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
    }
  }
};
cljs.core.zipmap = function cljs$core$zipmap(keys, vals) {
  var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
  var ks = cljs.core.seq(keys);
  var vs = cljs.core.seq(vals);
  while (true) {
    if (ks && vs) {
      var G__10537 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map, cljs.core.first(ks), cljs.core.first(vs));
      var G__10538 = cljs.core.next(ks);
      var G__10539 = cljs.core.next(vs);
      map = G__10537;
      ks = G__10538;
      vs = G__10539;
      continue;
    } else {
      return cljs.core.persistent_BANG_(map);
    }
    break;
  }
};
cljs.core.max_key = function cljs$core$max_key() {
  var G__10547 = arguments.length;
  switch(G__10547) {
    case 2:
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = function(k, x) {
  return x;
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = function(k, x, y) {
  if (function() {
    var G__10548 = x;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__10548) : k.call(null, G__10548);
  }() > function() {
    var G__10549 = y;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__10549) : k.call(null, G__10549);
  }()) {
    return x;
  } else {
    return y;
  }
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = function(k, x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(p1__10540_SHARP_, p2__10541_SHARP_) {
    return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k, p1__10540_SHARP_, p2__10541_SHARP_);
  }, cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k, x, y), more);
};
cljs.core.max_key.cljs$lang$applyTo = function(seq10542) {
  var G__10543 = cljs.core.first(seq10542);
  var seq10542__$1 = cljs.core.next(seq10542);
  var G__10544 = cljs.core.first(seq10542__$1);
  var seq10542__$2 = cljs.core.next(seq10542__$1);
  var G__10545 = cljs.core.first(seq10542__$2);
  var seq10542__$3 = cljs.core.next(seq10542__$2);
  return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__10543, G__10544, G__10545, seq10542__$3);
};
cljs.core.max_key.cljs$lang$maxFixedArity = 3;
cljs.core.min_key = function cljs$core$min_key() {
  var G__10558 = arguments.length;
  switch(G__10558) {
    case 2:
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = function(k, x) {
  return x;
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = function(k, x, y) {
  if (function() {
    var G__10559 = x;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__10559) : k.call(null, G__10559);
  }() < function() {
    var G__10560 = y;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__10560) : k.call(null, G__10560);
  }()) {
    return x;
  } else {
    return y;
  }
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = function(k, x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(p1__10551_SHARP_, p2__10552_SHARP_) {
    return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k, p1__10551_SHARP_, p2__10552_SHARP_);
  }, cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k, x, y), more);
};
cljs.core.min_key.cljs$lang$applyTo = function(seq10553) {
  var G__10554 = cljs.core.first(seq10553);
  var seq10553__$1 = cljs.core.next(seq10553);
  var G__10555 = cljs.core.first(seq10553__$1);
  var seq10553__$2 = cljs.core.next(seq10553__$1);
  var G__10556 = cljs.core.first(seq10553__$2);
  var seq10553__$3 = cljs.core.next(seq10553__$2);
  return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__10554, G__10555, G__10556, seq10553__$3);
};
cljs.core.min_key.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayList = function(arr) {
  this.arr = arr;
};
cljs.core.ArrayList.prototype.add = function(x) {
  var self__ = this;
  var _ = this;
  return self__.arr.push(x);
};
cljs.core.ArrayList.prototype.size = function() {
  var self__ = this;
  var _ = this;
  return self__.arr.length;
};
cljs.core.ArrayList.prototype.clear = function() {
  var self__ = this;
  var _ = this;
  return self__.arr = [];
};
cljs.core.ArrayList.prototype.isEmpty = function() {
  var self__ = this;
  var _ = this;
  return self__.arr.length === 0;
};
cljs.core.ArrayList.prototype.toArray = function() {
  var self__ = this;
  var _ = this;
  return self__.arr;
};
cljs.core.ArrayList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.ArrayList.cljs$lang$type = true;
cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";
cljs.core.ArrayList.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayList");
};
cljs.core.__GT_ArrayList = function cljs$core$__GT_ArrayList(arr) {
  return new cljs.core.ArrayList(arr);
};
cljs.core.array_list = function cljs$core$array_list() {
  return new cljs.core.ArrayList([]);
};
cljs.core.partition_all = function cljs$core$partition_all() {
  var G__10563 = arguments.length;
  switch(G__10563) {
    case 1:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var a = cljs.core.array_list();
    return function(a) {
      return function() {
        var G__10570 = null;
        var G__10570__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10570__1 = function(result) {
          var result__$1 = cljs.core.truth_(a.isEmpty()) ? result : function() {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            return cljs.core.unreduced(function() {
              var G__10564 = result;
              var G__10565 = v;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10564, G__10565) : rf.call(null, G__10564, G__10565);
            }());
          }();
          var G__10566 = result__$1;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10566) : rf.call(null, G__10566);
        };
        var G__10570__2 = function(result, input) {
          a.add(input);
          if (n === a.size()) {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            var G__10567 = result;
            var G__10568 = v;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10567, G__10568) : rf.call(null, G__10567, G__10568);
          } else {
            return result;
          }
        };
        G__10570 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10570__0.call(this);
            case 1:
              return G__10570__1.call(this, result);
            case 2:
              return G__10570__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10570.cljs$core$IFn$_invoke$arity$0 = G__10570__0;
        G__10570.cljs$core$IFn$_invoke$arity$1 = G__10570__1;
        G__10570.cljs$core$IFn$_invoke$arity$2 = G__10570__2;
        return G__10570;
      }();
    }(a);
  };
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s), cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition_all.cljs$lang$maxFixedArity = 3;
cljs.core.take_while = function cljs$core$take_while() {
  var G__10572 = arguments.length;
  switch(G__10572) {
    case 1:
      return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__10579 = null;
      var G__10579__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__10579__1 = function(result) {
        var G__10573 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10573) : rf.call(null, G__10573);
      };
      var G__10579__2 = function(result, input) {
        if (cljs.core.truth_(function() {
          var G__10574 = input;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10574) : pred.call(null, G__10574);
        }())) {
          var G__10575 = result;
          var G__10576 = input;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10575, G__10576) : rf.call(null, G__10575, G__10576);
        } else {
          return cljs.core.reduced(result);
        }
      };
      G__10579 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__10579__0.call(this);
          case 1:
            return G__10579__1.call(this, result);
          case 2:
            return G__10579__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__10579.cljs$core$IFn$_invoke$arity$0 = G__10579__0;
      G__10579.cljs$core$IFn$_invoke$arity$1 = G__10579__1;
      G__10579.cljs$core$IFn$_invoke$arity$2 = G__10579__2;
      return G__10579;
    }();
  };
};
cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.truth_(function() {
        var G__10577 = cljs.core.first(s);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10577) : pred.call(null, G__10577);
      }())) {
        return cljs.core.cons(cljs.core.first(s), cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take_while.cljs$lang$maxFixedArity = 2;
cljs.core.mk_bound_fn = function cljs$core$mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp = cljs.core._comparator(sc);
    var G__10584 = function() {
      var G__10586 = cljs.core._entry_key(sc, e);
      var G__10587 = key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__10586, G__10587) : comp.call(null, G__10586, G__10587);
    }();
    var G__10585 = 0;
    return test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__10584, G__10585) : test.call(null, G__10584, G__10585);
  };
};
cljs.core.subseq = function cljs$core$subseq() {
  var G__10589 = arguments.length;
  switch(G__10589) {
    case 3:
      return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = function(sc, test, key) {
  var include = cljs.core.mk_bound_fn(sc, test, key);
  if (cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_, cljs.core._GT__EQ_], true).call(null, test))) {
    var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, key, true);
    if (cljs.core.truth_(temp__4425__auto__)) {
      var vec__10590 = temp__4425__auto__;
      var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10590, 0, null);
      var s = vec__10590;
      if (cljs.core.truth_(function() {
        var G__10591 = e;
        return include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__10591) : include.call(null, G__10591);
      }())) {
        return s;
      } else {
        return cljs.core.next(s);
      }
    } else {
      return null;
    }
  } else {
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include, cljs.core._sorted_seq(sc, true));
  }
};
cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = function(sc, start_test, start_key, end_test, end_key) {
  var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, start_key, true);
  if (cljs.core.truth_(temp__4425__auto__)) {
    var vec__10592 = temp__4425__auto__;
    var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10592, 0, null);
    var s = vec__10592;
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn(sc, start_test, start_key).call(null, e)) ? s : cljs.core.next(s));
  } else {
    return null;
  }
};
cljs.core.subseq.cljs$lang$maxFixedArity = 5;
cljs.core.rsubseq = function cljs$core$rsubseq() {
  var G__10595 = arguments.length;
  switch(G__10595) {
    case 3:
      return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = function(sc, test, key) {
  var include = cljs.core.mk_bound_fn(sc, test, key);
  if (cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_, cljs.core._LT__EQ_], true).call(null, test))) {
    var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, key, false);
    if (cljs.core.truth_(temp__4425__auto__)) {
      var vec__10596 = temp__4425__auto__;
      var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10596, 0, null);
      var s = vec__10596;
      if (cljs.core.truth_(function() {
        var G__10597 = e;
        return include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__10597) : include.call(null, G__10597);
      }())) {
        return s;
      } else {
        return cljs.core.next(s);
      }
    } else {
      return null;
    }
  } else {
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include, cljs.core._sorted_seq(sc, false));
  }
};
cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = function(sc, start_test, start_key, end_test, end_key) {
  var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, end_key, false);
  if (cljs.core.truth_(temp__4425__auto__)) {
    var vec__10598 = temp__4425__auto__;
    var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10598, 0, null);
    var s = vec__10598;
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn(sc, end_test, end_key).call(null, e)) ? s : cljs.core.next(s));
  } else {
    return null;
  }
};
cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;
cljs.core.RangeIterator = function(i, end, step) {
  this.i = i;
  this.end = end;
  this.step = step;
};
cljs.core.RangeIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__.step > 0) {
    return self__.i < self__.end;
  } else {
    return self__.i > self__.end;
  }
};
cljs.core.RangeIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.i;
  self__.i = self__.i + self__.step;
  return ret;
};
cljs.core.RangeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.Symbol(null, "step", "step", -1365547645, null)], null);
};
cljs.core.RangeIterator.cljs$lang$type = true;
cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";
cljs.core.RangeIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RangeIterator");
};
cljs.core.__GT_RangeIterator = function cljs$core$__GT_RangeIterator(i, end, step) {
  return new cljs.core.RangeIterator(i, end, step);
};
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375006;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Range.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Range.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var self__ = this;
  var rng__$1 = this;
  if (n < cljs.core._count(rng__$1)) {
    return self__.start + n * self__.step;
  } else {
    if (self__.start > self__.end && self__.step === 0) {
      return self__.start;
    } else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var self__ = this;
  var rng__$1 = this;
  if (n < cljs.core._count(rng__$1)) {
    return self__.start + n * self__.step;
  } else {
    if (self__.start > self__.end && self__.step === 0) {
      return self__.start;
    } else {
      return not_found;
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIterable$ = true;
cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RangeIterator(self__.start, self__.end, self__.step);
};
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  return self__.meta;
};
cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Range(self__.meta, self__.start, self__.end, self__.step, self__.__hash);
};
cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (self__.step > 0) {
    if (self__.start + self__.step < self__.end) {
      return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
    } else {
      return null;
    }
  } else {
    if (self__.start + self__.step > self__.end) {
      return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
    } else {
      return null;
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (cljs.core.not(cljs.core._seq(rng__$1))) {
    return 0;
  } else {
    var G__10600 = (self__.end - self__.start) / self__.step;
    return Math.ceil(G__10600);
  }
};
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.equiv_sequential(rng__$1, other);
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1, f);
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, init) {
  var self__ = this;
  var rng__$1 = this;
  var i = self__.start;
  var ret = init;
  while (true) {
    if (self__.step > 0 ? i < self__.end : i > self__.end) {
      var ret__$1 = function() {
        var G__10601 = ret;
        var G__10602 = i;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10601, G__10602) : f.call(null, G__10601, G__10602);
      }();
      if (cljs.core.reduced_QMARK_(ret__$1)) {
        var G__10603 = ret__$1;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10603) : cljs.core.deref.call(null, G__10603);
      } else {
        var G__10604 = i + self__.step;
        var G__10605 = ret__$1;
        i = G__10604;
        ret = G__10605;
        continue;
      }
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (cljs.core._seq(rng__$1) == null) {
    return null;
  } else {
    return self__.start;
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (!(cljs.core._seq(rng__$1) == null)) {
    return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (self__.step > 0) {
    if (self__.start < self__.end) {
      return rng__$1;
    } else {
      return null;
    }
  } else {
    if (self__.start > self__.end) {
      return rng__$1;
    } else {
      return null;
    }
  }
};
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta__$1) {
  var self__ = this;
  var rng__$1 = this;
  return new cljs.core.Range(meta__$1, self__.start, self__.end, self__.step, self__.__hash);
};
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.cons(o, rng__$1);
};
cljs.core.Range.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.Symbol(null, "step", "step", -1365547645, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";
cljs.core.Range.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Range");
};
cljs.core.__GT_Range = function cljs$core$__GT_Range(meta, start, end, step, __hash) {
  return new cljs.core.Range(meta, start, end, step, __hash);
};
cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.range = function cljs$core$range() {
  var G__10607 = arguments.length;
  switch(G__10607) {
    case 0:
      return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.range.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.range.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.range.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.range.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.range.cljs$core$IFn$_invoke$arity$3(0, Number.MAX_VALUE, 1);
};
cljs.core.range.cljs$core$IFn$_invoke$arity$1 = function(end) {
  return cljs.core.range.cljs$core$IFn$_invoke$arity$3(0, end, 1);
};
cljs.core.range.cljs$core$IFn$_invoke$arity$2 = function(start, end) {
  return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start, end, 1);
};
cljs.core.range.cljs$core$IFn$_invoke$arity$3 = function(start, end, step) {
  return new cljs.core.Range(null, start, end, step, null);
};
cljs.core.range.cljs$lang$maxFixedArity = 3;
cljs.core.take_nth = function cljs$core$take_nth() {
  var G__10610 = arguments.length;
  switch(G__10610) {
    case 1:
      return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__10615 = null;
        var G__10615__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10615__1 = function(result) {
          var G__10611 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10611) : rf.call(null, G__10611);
        };
        var G__10615__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          if (cljs.core.rem(i, n) === 0) {
            var G__10612 = result;
            var G__10613 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10612, G__10613) : rf.call(null, G__10612, G__10613);
          } else {
            return result;
          }
        };
        G__10615 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10615__0.call(this);
            case 1:
              return G__10615__1.call(this, result);
            case 2:
              return G__10615__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10615.cljs$core$IFn$_invoke$arity$0 = G__10615__0;
        G__10615.cljs$core$IFn$_invoke$arity$1 = G__10615__1;
        G__10615.cljs$core$IFn$_invoke$arity$2 = G__10615__2;
        return G__10615;
      }();
    }(ia);
  };
};
cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      return cljs.core.cons(cljs.core.first(s), cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take_nth.cljs$lang$maxFixedArity = 2;
cljs.core.split_with = function cljs$core$split_with(pred, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred, coll), cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred, coll)], null);
};
cljs.core.partition_by = function cljs$core$partition_by() {
  var G__10618 = arguments.length