(ns sam-diff.core
  (:require [sam-diff.levenshtein.core :as levenshtein]))


(defn- current-stack-trace []
  (.getStackTrace (Thread/currentThread)))

(defn- is-repl-stack-element [stack-element]
  (and (= "clojure.main$repl" (.getClassName  stack-element))
       (= "doInvoke"          (.getMethodName stack-element))))

(defn- is-in-repl []
  (some is-repl-stack-element (current-stack-trace)))

(defn diff [a b]
  (try
    (levenshtein/diff a b (if (is-in-repl) {:format :colour} {}))
    (catch StackOverflowError t
      (str "Too complex to take the difference" t))
    (catch Throwable t
      (str "Error calculating the difference" t))))







