(ns sam-diff.optimised.meyer-string
  (:require [sam-diff.formatter.string :as formatter])
  (:import [rachbowyer MeyerString MeyerString$MeyerStringDiffInfo MeyerString$EditType MeyerString$EditInstruction]))

(defn edit-distance
  [a b]
  (MeyerString/editDistance a b))

(defn bidirectional-edit-distance
  [a b]
  (MeyerString/bidirectionalEditDistance a b))

(defn- post-process [^MeyerString$MeyerStringDiffInfo diff-info a b]
  (loop [^MeyerString$EditInstruction [f & r] (.getEditInstructions diff-info)
         result {:inserted {}
                 :deleted {}
                 :levenshtein (.getDistance diff-info)
                 :type :string
                 :a a}]
    (if (nil? f)
      result
      (recur r
             (let [x (.getX f)
                   y (.getY f)
                   t (.getType f)]
               (cond
                 (= t MeyerString$EditType/DELETE)
                 (assoc-in result [:deleted  (- (count a) x)] (.charAt a (dec x)))

                 (= t MeyerString$EditType/INSERT)
                 (update-in result [:inserted  (- (count a) x)]
                            #(conj (or % []) (.charAt b (dec y))))))))))

(defn raw-diff
  "Convenience method"
  [a b]
  (some-> (MeyerString/diff a b) (post-process a b)))


(defn diff
  "Convenience method"
  [a b]
  (let [diff-info (MeyerString/diff a b)]
    (some-> diff-info
            (post-process a b)
            (formatter/frmt {}))))




