;;; Copyright ©️ Rachel Bowyer 2022, 2023. All rights reserved.
;;;
;;; This program and the accompanying materials
;;; are made available under the terms of the Eclipse Public License v2.0
;;; which accompanies this distribution, and is available at
;;; https://www.eclipse.org/legal/epl-2.0/
;;;
;;; This Source Code may also be made available under the following
;;; Secondary Licenses when the conditions for such availability set forth
;;; in the Eclipse Public License, v. 2.0 are satisfied: GNU General Public
;;; License as published by the Free Software Foundation, either version 2
;;; of the License, or (at your option) any later version, with the GNU
;;; Classpath Exception which is available at
;;; https://www.gnu.org/software/classpath/license.html.


(ns info.bowyer.sam-diff.core
  (:require [info.bowyer.sam-diff.optimised.core :as optimised]))


(defn- current-stack-trace []
  (.getStackTrace (Thread/currentThread)))

(defn- is-repl-stack-element [stack-element]
  (and (= "clojure.main$repl" (.getClassName  stack-element))
       (= "doInvoke"          (.getMethodName stack-element))))

(defn- is-in-repl []
  (some is-repl-stack-element (current-stack-trace)))

(defn diff [a b]
  (try
    (optimised/diff a b (if (is-in-repl) {:format :colour} {}))
    (catch StackOverflowError t
      (str "Too complex to take the difference" t))
    (catch Throwable t
      (str "Error calculating the difference" t))))







