;;; Copyright ©️ Rachel Bowyer 2022, 2023. All rights reserved.
;;;
;;; This program and the accompanying materials
;;; are made available under the terms of the Eclipse Public License v2.0
;;; which accompanies this distribution, and is available at
;;; https://www.eclipse.org/legal/epl-2.0/
;;;
;;; This Source Code may also be made available under the following
;;; Secondary Licenses when the conditions for such availability set forth
;;; in the Eclipse Public License, v. 2.0 are satisfied: GNU General Public
;;; License as published by the Free Software Foundation, either version 2
;;; of the License, or (at your option) any later version, with the GNU
;;; Classpath Exception which is available at
;;; https://www.gnu.org/software/classpath/license.html.


(ns info.bowyer.sam-diff.levenshtein.classify)

(defn classify
  [v]
  (cond
    (nil? v)        :nil
    (char? v)       :atom
    (string? v)     :string
    (number? v)     :number
    (keyword? v)    :keyword
    (symbol? v)     :symbol
    (map? v)        :map
    (set? v)        :set
    (seq? v)        :seq
    (vector? v)     :seq
    :else           :atom))

