;;; Copyright ©️ Rachel Bowyer 2022, 2023. All rights reserved.
;;;
;;; This program and the accompanying materials
;;; are made available under the terms of the Eclipse Public License v2.0
;;; which accompanies this distribution, and is available at
;;; https://www.eclipse.org/legal/epl-2.0/
;;;
;;; This Source Code may also be made available under the following
;;; Secondary Licenses when the conditions for such availability set forth
;;; in the Eclipse Public License, v. 2.0 are satisfied: GNU General Public
;;; License as published by the Free Software Foundation, either version 2
;;; of the License, or (at your option) any later version, with the GNU
;;; Classpath Exception which is available at
;;; https://www.gnu.org/software/classpath/license.html.


(ns info.bowyer.sam-diff.optimised.core
  (:require
    [info.bowyer.sam-diff.formatter.short-form :as short-form]
    [info.bowyer.sam-diff.optimised.atom]
    [info.bowyer.sam-diff.optimised.dijkstra-non-atomic-list]
    [info.bowyer.sam-diff.optimised.map]
    [info.bowyer.sam-diff.optimised.meyer-string]
    [info.bowyer.sam-diff.optimised.post-process :refer [post-process]]
    [info.bowyer.sam-diff.optimised.set])
  (:import [info.bowyer.sam_diff_java Main]))


;; todo - Remove not=
;; todo - use some-> as can be null
;; todo - clean up import

(defn diff
  [a b opts]
  (when (not= a b)
    (let [diff-info (Main/diff a b)
          processed-diff-info (post-process diff-info)]
      (short-form/frmt processed-diff-info opts))))
