;;; Copyright ©️ Rachel Bowyer 2022, 2023. All rights reserved.
;;;
;;; This program and the accompanying materials
;;; are made available under the terms of the Eclipse Public License v2.0
;;; which accompanies this distribution, and is available at
;;; https://www.eclipse.org/legal/epl-2.0/
;;;
;;; This Source Code may also be made available under the following
;;; Secondary Licenses when the conditions for such availability set forth
;;; in the Eclipse Public License, v. 2.0 are satisfied: GNU General Public
;;; License as published by the Free Software Foundation, either version 2
;;; of the License, or (at your option) any later version, with the GNU
;;; Classpath Exception which is available at
;;; https://www.gnu.org/software/classpath/license.html.


(ns info.bowyer.sam-diff.optimised.dijkstra-non-atomic-list
  (:require [info.bowyer.sam-diff.optimised.post-process :refer [post-process]])
  (:import [info.bowyer.sam_diff_java DiffInfo Type
            DijkstraNonAtomicList$DijkstraNonAtomicListDiffInfo
            DijkstraNonAtomicList$Direction DijkstraNonAtomicList$QueueElement]))

(defmethod post-process Type/DijkstraNonAtomicList
  [^DijkstraNonAtomicList$DijkstraNonAtomicListDiffInfo diff-info]
  (let [a                   (.getA diff-info)
        b                   (.getB diff-info)
        a-vec               (vec a)
        b-vec               (vec b)
        h                   (.getHead diff-info)
        normalize-index     (fn [idx] (- (count a) idx))
        init-result         {:a           a
                             :deleted     {}
                             :inserted    {}
                             :modified    {}
                             :type        :seq
                             :levenshtein (.getDistance h)}]
    (loop [^DijkstraNonAtomicList$QueueElement queue-element h
           result init-result]
      (if (nil? queue-element)
        result
        (let [x (.getX queue-element)

              y (.getY queue-element)

              ^DijkstraNonAtomicList$Direction direction
                (.getDirection queue-element)

              ^DiffInfo diff-info (.getDiffInfo queue-element)

              ^DijkstraNonAtomicList$QueueElement next-queue-element
                (.previousElement queue-element)

              new-result
                (condp = direction
                  DijkstraNonAtomicList$Direction/diagonal
                  (cond-> result
                          (some? diff-info)
                          (assoc-in [:modified (normalize-index x)]
                                    (post-process diff-info)))

                  DijkstraNonAtomicList$Direction/horizontal
                  (assoc-in result
                            [:deleted (normalize-index x)]
                            (get a-vec (dec x)))

                  DijkstraNonAtomicList$Direction/vertical
                  (update-in result
                             [:inserted (normalize-index x)]
                             #(cons (get b-vec (dec y)) (or % '()) ))

                  DijkstraNonAtomicList$Direction/start
                  result)]
          (recur next-queue-element new-result))))))

