;;; Copyright ©️ Rachel Bowyer 2022, 2023. All rights reserved.
;;;
;;; This program and the accompanying materials
;;; are made available under the terms of the Eclipse Public License v2.0
;;; which accompanies this distribution, and is available at
;;; https://www.eclipse.org/legal/epl-2.0/
;;;
;;; This Source Code may also be made available under the following
;;; Secondary Licenses when the conditions for such availability set forth
;;; in the Eclipse Public License, v. 2.0 are satisfied: GNU General Public
;;; License as published by the Free Software Foundation, either version 2
;;; of the License, or (at your option) any later version, with the GNU
;;; Classpath Exception which is available at
;;; https://www.gnu.org/software/classpath/license.html.


(ns info.bowyer.sam-diff.optimised.set
  (:require [info.bowyer.sam-diff.optimised.post-process :refer [post-process]])
  (:import
    [info.bowyer.sam_diff_java SetDiff$SetDiffInfo Type]
    [java.util HashSet]))


(defn- hash-set->clojure-set
  [^HashSet hs]
  (reduce (fn [acc k] (conj acc k)) #{} hs))


(defmethod post-process Type/Set [^SetDiff$SetDiffInfo diff-info]
  {:a           (.getA diff-info)
   :type        :set
   :deleted     (hash-set->clojure-set (.getDeleted diff-info))
   :inserted    (hash-set->clojure-set (.getInserted diff-info))
   :levenshtein (.getDistance diff-info)})