# Teepee

"Need to add lock for multi-thread"


A library inspired by and designed to complement James Reeve's nifty library hash-p.

In Clojure it is common to nest forms. For example,

    (/ (+ 1 1) 3)

Although, compact and easy to read, this code is difficult to debug in Cursive. It struggles
debugging this type of code as break points can only be placed on lines not Clojure forms.

`hash-p`, offers a solution. By (ab)using tag literals, it gives a probe that can be quickly 
add or removed for debugging purposes. For example,

     (/ #p (+ 1 1) 3)

allows printing out the nested expression giving the following output

    #p[info.bowyer.teepee.core/eval21887:1] (+ 1 1) => 2

However, #p does not work in the thread first and thread last macros, which is
where teepee steps in.




## Usage




## Alternatives

Be sure to check put the excellent Debugx, which also seeks to solve the same problems.
Debugx has a different philosophy. Debugx mainly offers a range of functions that 
are designed to stay in your code. Then when your code is deployed to Production,
it is linked to some empty stubs to avoid a runtime overhead.

In contrast, hashp and teepee offers a lightweight approach. The probes are designed
to be added temporarily for debugging. Using tagged literals means that no require
is needed and minimal keystrokes are needed to add the probe. Once debugging is
complete, the probe is easily removed.

Debugx does have some tagged literals, but they seem to have been added as an afterthought.
Also, unlike hashpp (and teepee) debugx does not have syntax highlighting.

I love there are two Clojure libraries solving the same problem in different ways
and I use both libraries according to my needs.



## Acknowledgements

Teepee logo courtesy of ChatGPT


## License

Copyright © 2024 Rachel Bowyer

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
