(ns leiningen.new.insilica
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "insilica"))

(defn insilica
  "Creates the project template."
  [name & opts]
  (do
    (when (= name "insilica")
      (main/abort
       (str "Cannot name the project \"insilica\".")))
    (let [data {:name name
                :sanitized (name-to-path name)}]
      (main/info (str "Generating CLJS web project from template.\n\n"
                      "To finish project setup:\n\n"
                      "* Change into your '" name "' directory.\n"
                      "* Make sure you have 'gulp' installed globally ('sudo npm install -g gulp')\n"
                      "* Run 'sh setup.sh'. For Semantic UI install, choose all default options.\n"))
      (->files data
               [".gitignore" (render "gitignore" data)]
               ["README.md" (render "README.md" data)]
               ["project.clj" (render "project.clj" data)]
               ["package.json" (render "package.json" data)]
               ["setup.sh" (render "setup.sh" data)]
               ["src/cljs/{{sanitized}}/main.cljs" (render "src/cljs/main.cljs" data)]
               ["src/cljs/{{sanitized}}/base.cljs" (render "src/cljs/base.cljs" data)]
               ["src/cljs/{{sanitized}}/ajax.cljs" (render "src/cljs/ajax.cljs" data)]
               ["src/cljs/{{sanitized}}/routes.cljs" (render "src/cljs/routes.cljs" data)]
               ["src/cljs/{{sanitized}}/ui/core.cljs" (render "src/cljs/ui/core.cljs" data)]
               ["src/clj/figwheel.clj" (render "src/clj/figwheel.clj" data)]
               ["resources/public/index.html" (render "index.html" data)]
               ["resources/public/css/style.css" (render "style.css" data)]))))
