// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('cljs.core.async');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__27020__auto__ = v;
if(cljs.core.truth_(and__27020__auto__)){
return (v > (0));
} else {
return and__27020__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__33116_SHARP_,p2__33115_SHARP_){
var vec__33120 = clojure.string.split.call(null,p2__33115_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__33120,(0),null);
var v = cljs.core.nth.call(null,vec__33120,(1),null);
return cljs.core.assoc.call(null,p1__33116_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode.call(null,[cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__33123_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__33123_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__33124){
var vec__33128 = p__33124;
var k = cljs.core.nth.call(null,vec__33128,(0),null);
var v = cljs.core.nth.call(null,vec__33128,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__33131_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__33131_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__27020__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__27020__auto__){
var and__27020__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__27020__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__27020__auto____$1;
}
} else {
return and__27020__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__6745__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6745__auto__)){
var params = temp__6745__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__33132_SHARP_){
return cljs_http.client.decode_body.call(null,p1__33132_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33139 = arguments.length;
var i__28249__auto___33140 = (0);
while(true){
if((i__28249__auto___33140 < len__28248__auto___33139)){
args__28255__auto__.push((arguments[i__28249__auto___33140]));

var G__33141 = (i__28249__auto___33140 + (1));
i__28249__auto___33140 = G__33141;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__33135){
var vec__33136 = p__33135;
var default_headers = cljs.core.nth.call(null,vec__33136,(0),null);
return ((function (vec__33136,default_headers){
return (function (request){
var temp__6745__auto__ = (function (){var or__27032__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__27032__auto__)){
return or__27032__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__6745__auto__)){
var default_headers__$1 = temp__6745__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__33136,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq33133){
var G__33134 = cljs.core.first.call(null,seq33133);
var seq33133__$1 = cljs.core.next.call(null,seq33133);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__33134,seq33133__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33148 = arguments.length;
var i__28249__auto___33149 = (0);
while(true){
if((i__28249__auto___33149 < len__28248__auto___33148)){
args__28255__auto__.push((arguments[i__28249__auto___33149]));

var G__33150 = (i__28249__auto___33149 + (1));
i__28249__auto___33149 = G__33150;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__33144){
var vec__33145 = p__33144;
var accept = cljs.core.nth.call(null,vec__33145,(0),null);
return ((function (vec__33145,accept){
return (function (request){
var temp__6745__auto__ = (function (){var or__27032__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__27032__auto__)){
return or__27032__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__6745__auto__)){
var accept__$1 = temp__6745__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__33145,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq33142){
var G__33143 = cljs.core.first.call(null,seq33142);
var seq33142__$1 = cljs.core.next.call(null,seq33142);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__33143,seq33142__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33157 = arguments.length;
var i__28249__auto___33158 = (0);
while(true){
if((i__28249__auto___33158 < len__28248__auto___33157)){
args__28255__auto__.push((arguments[i__28249__auto___33158]));

var G__33159 = (i__28249__auto___33158 + (1));
i__28249__auto___33158 = G__33159;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__33153){
var vec__33154 = p__33153;
var content_type = cljs.core.nth.call(null,vec__33154,(0),null);
return ((function (vec__33154,content_type){
return (function (request){
var temp__6745__auto__ = (function (){var or__27032__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__27032__auto__)){
return or__27032__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__6745__auto__)){
var content_type__$1 = temp__6745__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__33154,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq33151){
var G__33152 = cljs.core.first.call(null,seq33151);
var seq33151__$1 = cljs.core.next.call(null,seq33151);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__33152,seq33151__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__6745__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6745__auto__)){
var params = temp__6745__auto__;
var map__33162 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__33162__$1 = ((((!((map__33162 == null)))?((((map__33162.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33162.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33162):map__33162);
var encoding = cljs.core.get.call(null,map__33162__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__33162__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__33168 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__33168__$1 = ((((!((map__33168 == null)))?((((map__33168.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33168.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33168):map__33168);
var decoding = cljs.core.get.call(null,map__33168__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__33168__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__33168,map__33168__$1,decoding,decoding_opts){
return (function (p1__33164_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__33164_SHARP_,decoding,decoding_opts);
});})(map__33168,map__33168__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__33168,map__33168__$1,decoding,decoding_opts,transit_decode){
return (function (p1__33165_SHARP_){
return cljs_http.client.decode_body.call(null,p1__33165_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__33168,map__33168__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__6745__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6745__auto__)){
var params = temp__6745__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__33170_SHARP_){
return cljs_http.client.decode_body.call(null,p1__33170_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__33174){
var map__33175 = p__33174;
var map__33175__$1 = ((((!((map__33175 == null)))?((((map__33175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33175.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33175):map__33175);
var req = map__33175__$1;
var query_params = cljs.core.get.call(null,map__33175__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__33180){
var map__33181 = p__33180;
var map__33181__$1 = ((((!((map__33181 == null)))?((((map__33181.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33181.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33181):map__33181);
var request = map__33181__$1;
var form_params = cljs.core.get.call(null,map__33181__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__33181__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__33181__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__27020__auto__ = form_params;
if(cljs.core.truth_(and__27020__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__27020__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__33193_33203 = cljs.core.seq.call(null,params);
var chunk__33194_33204 = null;
var count__33195_33205 = (0);
var i__33196_33206 = (0);
while(true){
if((i__33196_33206 < count__33195_33205)){
var vec__33197_33207 = cljs.core._nth.call(null,chunk__33194_33204,i__33196_33206);
var k_33208 = cljs.core.nth.call(null,vec__33197_33207,(0),null);
var v_33209 = cljs.core.nth.call(null,vec__33197_33207,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_33209)){
form_data.append(cljs.core.name.call(null,k_33208),cljs.core.first.call(null,v_33209),cljs.core.second.call(null,v_33209));
} else {
form_data.append(cljs.core.name.call(null,k_33208),v_33209);
}

var G__33210 = seq__33193_33203;
var G__33211 = chunk__33194_33204;
var G__33212 = count__33195_33205;
var G__33213 = (i__33196_33206 + (1));
seq__33193_33203 = G__33210;
chunk__33194_33204 = G__33211;
count__33195_33205 = G__33212;
i__33196_33206 = G__33213;
continue;
} else {
var temp__6747__auto___33214 = cljs.core.seq.call(null,seq__33193_33203);
if(temp__6747__auto___33214){
var seq__33193_33215__$1 = temp__6747__auto___33214;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33193_33215__$1)){
var c__27938__auto___33216 = cljs.core.chunk_first.call(null,seq__33193_33215__$1);
var G__33217 = cljs.core.chunk_rest.call(null,seq__33193_33215__$1);
var G__33218 = c__27938__auto___33216;
var G__33219 = cljs.core.count.call(null,c__27938__auto___33216);
var G__33220 = (0);
seq__33193_33203 = G__33217;
chunk__33194_33204 = G__33218;
count__33195_33205 = G__33219;
i__33196_33206 = G__33220;
continue;
} else {
var vec__33200_33221 = cljs.core.first.call(null,seq__33193_33215__$1);
var k_33222 = cljs.core.nth.call(null,vec__33200_33221,(0),null);
var v_33223 = cljs.core.nth.call(null,vec__33200_33221,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_33223)){
form_data.append(cljs.core.name.call(null,k_33222),cljs.core.first.call(null,v_33223),cljs.core.second.call(null,v_33223));
} else {
form_data.append(cljs.core.name.call(null,k_33222),v_33223);
}

var G__33224 = cljs.core.next.call(null,seq__33193_33215__$1);
var G__33225 = null;
var G__33226 = (0);
var G__33227 = (0);
seq__33193_33203 = G__33224;
chunk__33194_33204 = G__33225;
count__33195_33205 = G__33226;
i__33196_33206 = G__33227;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__33231){
var map__33232 = p__33231;
var map__33232__$1 = ((((!((map__33232 == null)))?((((map__33232.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33232.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33232):map__33232);
var request = map__33232__$1;
var multipart_params = cljs.core.get.call(null,map__33232__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__33232__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__27020__auto__ = multipart_params;
if(cljs.core.truth_(and__27020__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__27020__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__6745__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__6745__auto__)){
var m = temp__6745__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__33234_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__33234_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__33239){
var map__33240 = p__33239;
var map__33240__$1 = ((((!((map__33240 == null)))?((((map__33240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33240.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33240):map__33240);
var req = map__33240__$1;
var query_params = cljs.core.get.call(null,map__33240__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__6745__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__6745__auto__)){
var spec = temp__6745__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__6745__auto__,map__33240,map__33240__$1,req,query_params){
return (function (p1__33235_SHARP_){
return cljs.core.merge.call(null,p1__33235_SHARP_,query_params);
});})(spec,temp__6745__auto__,map__33240,map__33240__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33248 = arguments.length;
var i__28249__auto___33249 = (0);
while(true){
if((i__28249__auto___33249 < len__28248__auto___33248)){
args__28255__auto__.push((arguments[i__28249__auto___33249]));

var G__33250 = (i__28249__auto___33249 + (1));
i__28249__auto___33249 = G__33250;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__33244){
var vec__33245 = p__33244;
var credentials = cljs.core.nth.call(null,vec__33245,(0),null);
return ((function (vec__33245,credentials){
return (function (req){
var credentials__$1 = (function (){var or__27032__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__27032__auto__)){
return or__27032__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__33245,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq33242){
var G__33243 = cljs.core.first.call(null,seq33242);
var seq33242__$1 = cljs.core.next.call(null,seq33242);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__33243,seq33242__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__6745__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__6745__auto__)){
var oauth_token = temp__6745__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__6745__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6745__auto__)){
var custom_channel = temp__6745__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33257 = arguments.length;
var i__28249__auto___33258 = (0);
while(true){
if((i__28249__auto___33258 < len__28248__auto___33257)){
args__28255__auto__.push((arguments[i__28249__auto___33258]));

var G__33259 = (i__28249__auto___33258 + (1));
i__28249__auto___33258 = G__33259;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33253){
var vec__33254 = p__33253;
var req = cljs.core.nth.call(null,vec__33254,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq33251){
var G__33252 = cljs.core.first.call(null,seq33251);
var seq33251__$1 = cljs.core.next.call(null,seq33251);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__33252,seq33251__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33266 = arguments.length;
var i__28249__auto___33267 = (0);
while(true){
if((i__28249__auto___33267 < len__28248__auto___33266)){
args__28255__auto__.push((arguments[i__28249__auto___33267]));

var G__33268 = (i__28249__auto___33267 + (1));
i__28249__auto___33267 = G__33268;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33262){
var vec__33263 = p__33262;
var req = cljs.core.nth.call(null,vec__33263,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq33260){
var G__33261 = cljs.core.first.call(null,seq33260);
var seq33260__$1 = cljs.core.next.call(null,seq33260);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__33261,seq33260__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33275 = arguments.length;
var i__28249__auto___33276 = (0);
while(true){
if((i__28249__auto___33276 < len__28248__auto___33275)){
args__28255__auto__.push((arguments[i__28249__auto___33276]));

var G__33277 = (i__28249__auto___33276 + (1));
i__28249__auto___33276 = G__33277;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33271){
var vec__33272 = p__33271;
var req = cljs.core.nth.call(null,vec__33272,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq33269){
var G__33270 = cljs.core.first.call(null,seq33269);
var seq33269__$1 = cljs.core.next.call(null,seq33269);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__33270,seq33269__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33284 = arguments.length;
var i__28249__auto___33285 = (0);
while(true){
if((i__28249__auto___33285 < len__28248__auto___33284)){
args__28255__auto__.push((arguments[i__28249__auto___33285]));

var G__33286 = (i__28249__auto___33285 + (1));
i__28249__auto___33285 = G__33286;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33280){
var vec__33281 = p__33280;
var req = cljs.core.nth.call(null,vec__33281,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq33278){
var G__33279 = cljs.core.first.call(null,seq33278);
var seq33278__$1 = cljs.core.next.call(null,seq33278);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__33279,seq33278__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33293 = arguments.length;
var i__28249__auto___33294 = (0);
while(true){
if((i__28249__auto___33294 < len__28248__auto___33293)){
args__28255__auto__.push((arguments[i__28249__auto___33294]));

var G__33295 = (i__28249__auto___33294 + (1));
i__28249__auto___33294 = G__33295;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33289){
var vec__33290 = p__33289;
var req = cljs.core.nth.call(null,vec__33290,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq33287){
var G__33288 = cljs.core.first.call(null,seq33287);
var seq33287__$1 = cljs.core.next.call(null,seq33287);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__33288,seq33287__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33302 = arguments.length;
var i__28249__auto___33303 = (0);
while(true){
if((i__28249__auto___33303 < len__28248__auto___33302)){
args__28255__auto__.push((arguments[i__28249__auto___33303]));

var G__33304 = (i__28249__auto___33303 + (1));
i__28249__auto___33303 = G__33304;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33298){
var vec__33299 = p__33298;
var req = cljs.core.nth.call(null,vec__33299,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq33296){
var G__33297 = cljs.core.first.call(null,seq33296);
var seq33296__$1 = cljs.core.next.call(null,seq33296);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__33297,seq33296__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33311 = arguments.length;
var i__28249__auto___33312 = (0);
while(true){
if((i__28249__auto___33312 < len__28248__auto___33311)){
args__28255__auto__.push((arguments[i__28249__auto___33312]));

var G__33313 = (i__28249__auto___33312 + (1));
i__28249__auto___33312 = G__33313;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33307){
var vec__33308 = p__33307;
var req = cljs.core.nth.call(null,vec__33308,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq33305){
var G__33306 = cljs.core.first.call(null,seq33305);
var seq33305__$1 = cljs.core.next.call(null,seq33305);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__33306,seq33305__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33320 = arguments.length;
var i__28249__auto___33321 = (0);
while(true){
if((i__28249__auto___33321 < len__28248__auto___33320)){
args__28255__auto__.push((arguments[i__28249__auto___33321]));

var G__33322 = (i__28249__auto___33321 + (1));
i__28249__auto___33321 = G__33322;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33316){
var vec__33317 = p__33316;
var req = cljs.core.nth.call(null,vec__33317,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq33314){
var G__33315 = cljs.core.first.call(null,seq33314);
var seq33314__$1 = cljs.core.next.call(null,seq33314);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__33315,seq33314__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__28255__auto__ = [];
var len__28248__auto___33329 = arguments.length;
var i__28249__auto___33330 = (0);
while(true){
if((i__28249__auto___33330 < len__28248__auto___33329)){
args__28255__auto__.push((arguments[i__28249__auto___33330]));

var G__33331 = (i__28249__auto___33330 + (1));
i__28249__auto___33330 = G__33331;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33325){
var vec__33326 = p__33325;
var req = cljs.core.nth.call(null,vec__33326,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq33323){
var G__33324 = cljs.core.first.call(null,seq33323);
var seq33323__$1 = cljs.core.next.call(null,seq33323);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__33324,seq33323__$1);
});


//# sourceMappingURL=client.js.map