// Compiled by ClojureScript 1.9.293 {}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement.call(null,cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return cljs.core.some_QMARK_.call(null,cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([needle], true),haystack));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str(val),cljs.core.str(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.call(null,cljs.core.sorted_set,clojure.string.split.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",""));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__28175 = url;
var G__28175__$1 = (cljs.core.truth_(imcljs.internal.utils.missing_http_QMARK__.call(null,url))?[cljs.core.str("http://"),cljs.core.str(G__28175)].join(''):G__28175);
if(cljs.core.truth_(imcljs.internal.utils.missing_service_QMARK__.call(null,url))){
return imcljs.internal.utils.append_.call(null,"/service",G__28175__$1);
} else {
return G__28175__$1;
}
});

//# sourceMappingURL=utils.js.map