// Compiled by ClojureScript 1.9.293 {}
goog.provide('imcljs.path');
goog.require('cljs.core');
goog.require('imcljs.internal.utils');
goog.require('clojure.string');
/**
 * Split a string path into a vector of keywords.
 *   (split-path `Gene.organism.shortName`)
 *   => [:Gene :organism :shortName]
 */
imcljs.path.split_path = (function imcljs$path$split_path(path_str){
return cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,path_str,"."));
});
/**
 * Join a vector path of keywords to a string.
 *   (join-path [:Gene :organism :shortName])
 *   => Gene.organism.shortName
 */
imcljs.path.join_path = (function imcljs$path$join_path(path_str){
return clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.core.name,path_str));
});
/**
 * Given a model and a class, return its attributes, references and collections.
 */
imcljs.path.properties = (function imcljs$path$properties(model,class_kw){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_type = (function imcljs$path$referenced_type(model,field_kw,class_kw){
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw)));
});
/**
 * Given a model, a reference/collection, and a class,
 *   return the superclass of the reference/collection.
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.referenced_class = (function imcljs$path$referenced_class(model,field_kw,class_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_type,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__28180){
var vec__28181 = p__28180;
var _ = cljs.core.nth.call(null,vec__28181,(0),null);
var map__28184 = cljs.core.nth.call(null,vec__28181,(1),null);
var map__28184__$1 = ((((!((map__28184 == null)))?((((map__28184.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28184.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28184):map__28184);
var extends$ = cljs.core.get.call(null,map__28184__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_values = (function imcljs$path$referenced_values(model,field_kw,class_kw){
return cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw);
});
/**
 * Given a model and a field, return that field from the data model.
 *   A field can be a reference, a collection, or an attribute
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.class_value = (function imcljs$path$class_value(model,class_kw,field_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_values,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__28192){
var vec__28193 = p__28192;
var _ = cljs.core.nth.call(null,vec__28193,(0),null);
var map__28196 = cljs.core.nth.call(null,vec__28193,(1),null);
var map__28196__$1 = ((((!((map__28196 == null)))?((((map__28196.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28196.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28196):map__28196);
var extends$ = cljs.core.get.call(null,map__28196__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Return a vector representing each part of path.
 *   If any part of the path is unresolvable then a nil is returned.
 *   (walk im-model `Gene.organism.shortName`)
 *   => [{:name `Gene`, :collections {...}, :attributes {...}}
 *    {:name `Organism`, :collections {...} :attributes {...}
 *    {:name `shortName`, :type `java.lang.String`}]
 */
imcljs.path.walk = (function imcljs$path$walk(var_args){
var args28198 = [];
var len__28114__auto___28208 = arguments.length;
var i__28115__auto___28209 = (0);
while(true){
if((i__28115__auto___28209 < len__28114__auto___28208)){
args28198.push((arguments[i__28115__auto___28209]));

var G__28210 = (i__28115__auto___28209 + (1));
i__28115__auto___28209 = G__28210;
continue;
} else {
}
break;
}

var G__28200 = args28198.length;
switch (G__28200) {
case 2:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28198.length)].join('')));

}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):path);
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,p))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p)], null))], null);
} else {
return imcljs.path.walk.call(null,model,p,cljs.core.PersistentVector.EMPTY);
}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$3 = (function (model,p__28201,trail){
while(true){
var vec__28202 = p__28201;
var seq__28203 = cljs.core.seq.call(null,vec__28202);
var first__28204 = cljs.core.first.call(null,seq__28203);
var seq__28203__$1 = cljs.core.next.call(null,seq__28203);
var class_kw = first__28204;
var vec__28205 = seq__28203__$1;
var seq__28206 = cljs.core.seq.call(null,vec__28205);
var first__28207 = cljs.core.first.call(null,seq__28206);
var seq__28206__$1 = cljs.core.next.call(null,seq__28206);
var path = first__28207;
var remaining = seq__28206__$1;
var cv = imcljs.path.class_value.call(null,model,class_kw,path);
if(remaining){
if(cljs.core.contains_QMARK_.call(null,cv,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030))){
var G__28212 = model;
var G__28213 = cljs.core.cons.call(null,cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cv)),remaining);
var G__28214 = cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)));
model = G__28212;
p__28201 = G__28213;
trail = G__28214;
continue;
} else {
return null;
}
} else {
return cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),((cljs.core.contains_QMARK_.call(null,cv,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030)))?cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cv))], null)):cv));
}
break;
}
});

imcljs.path.walk.cljs$lang$maxFixedArity = 3;

/**
 * Return the java type of a path representing an attribute.
 *   (attribute-type im-model `Gene.organism.shortName`)
 *   => java.lang.String
 */
imcljs.path.data_type = (function imcljs$path$data_type(model,path){
return new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,imcljs.path.walk.call(null,model,path)));
});
/**
 * Returns the class represented by the path.
 *   (class im-model `Gene.homologues.homologue.symbol`)
 *   => :Gene
 */
imcljs.path.class$ = (function imcljs$path$class(model,path){
var l = cljs.core.last.call(null,cljs.core.take_while.call(null,(function (p1__28215_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__28215_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path)));
return cljs.core.keyword.call(null,(function (){var or__26898__auto__ = new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(l);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(l));
}
})());
});
/**
 * Returns all relationships (references and collections) for a given string path.
 */
imcljs.path.relationships = (function imcljs$path$relationships(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
/**
 * Returns all attributes for a given string path.
 */
imcljs.path.attributes = (function imcljs$path$attributes(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604)], null)));
});
/**
 * Returns true if path is a class.
 *   (class im-model `Gene.diseases`)
 *   => true
 *   (class im-model `Gene.diseases.name`)
 *   => false
 */
imcljs.path.class_QMARK_ = (function imcljs$path$class_QMARK_(model,path){
var walked = imcljs.path.walk.call(null,model,path);
return !(cljs.core.contains_QMARK_.call(null,cljs.core.last.call(null,walked),new cljs.core.Keyword(null,"type","type",1174270348)));
});
/**
 * Returns a path string trimmed to the last class
 *   (trim-to-last-class im-model `Gene.homologues.homologue.symbol`)
 *   => Gene.homologues.homologue
 */
imcljs.path.trim_to_last_class = (function imcljs$path$trim_to_last_class(model,path){
var done = cljs.core.take_while.call(null,(function (p1__28216_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__28216_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path));
return imcljs.path.join_path.call(null,cljs.core.take.call(null,cljs.core.count.call(null,done),imcljs.path.split_path.call(null,path)));
});
/**
 * Returns a path as a strong
 */
imcljs.path.friendly = (function imcljs$path$friendly(var_args){
var args__28121__auto__ = [];
var len__28114__auto___28224 = arguments.length;
var i__28115__auto___28225 = (0);
while(true){
if((i__28115__auto___28225 < len__28114__auto___28224)){
args__28121__auto__.push((arguments[i__28115__auto___28225]));

var G__28226 = (i__28115__auto___28225 + (1));
i__28115__auto___28225 = G__28226;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((2) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((2)),(0),null)):null);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__28122__auto__);
});

imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,p__28220){
var vec__28221 = p__28220;
var exclude_root_QMARK_ = cljs.core.nth.call(null,vec__28221,(0),null);
return cljs.core.reduce.call(null,((function (vec__28221,exclude_root_QMARK_){
return (function (total,next){
return [cljs.core.str(total),cljs.core.str((cljs.core.truth_(total)?" > ":null)),cljs.core.str((function (){var or__26898__auto__ = new cljs.core.Keyword(null,"displayName","displayName",-809144601).cljs$core$IFn$_invoke$arity$1(next);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(next);
}
})())].join('');
});})(vec__28221,exclude_root_QMARK_))
,null,(cljs.core.truth_(exclude_root_QMARK_)?cljs.core.rest.call(null,imcljs.path.walk.call(null,model,path)):imcljs.path.walk.call(null,model,path)));
});

imcljs.path.friendly.cljs$lang$maxFixedArity = (2);

imcljs.path.friendly.cljs$lang$applyTo = (function (seq28217){
var G__28218 = cljs.core.first.call(null,seq28217);
var seq28217__$1 = cljs.core.next.call(null,seq28217);
var G__28219 = cljs.core.first.call(null,seq28217__$1);
var seq28217__$2 = cljs.core.next.call(null,seq28217__$1);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic(G__28218,G__28219,seq28217__$2);
});

imcljs.path.one_of_QMARK_ = (function imcljs$path$one_of_QMARK_(col,value){
return cljs.core.some_QMARK_.call(null,cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([value], true),col));
});
/**
 * Returns subclasses of the class
 */
imcljs.path.subclasses = (function imcljs$path$subclasses(model,path){
var path_class = imcljs.path.class$.call(null,model,path);
return cljs.core.not_empty.call(null,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,((function (path_class){
return (function (p__28231){
var vec__28232 = p__28231;
var _ = cljs.core.nth.call(null,vec__28232,(0),null);
var properties = cljs.core.nth.call(null,vec__28232,(1),null);
return imcljs.path.one_of_QMARK_.call(null,new cljs.core.Keyword(null,"extends","extends",-954903259).cljs$core$IFn$_invoke$arity$1(properties),cljs.core.name.call(null,path_class));
});})(path_class))
,new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model))));
});

//# sourceMappingURL=path.js.map