// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args31965 = [];
var len__28114__auto___31971 = arguments.length;
var i__28115__auto___31972 = (0);
while(true){
if((i__28115__auto___31972 < len__28114__auto___31971)){
args31965.push((arguments[i__28115__auto___31972]));

var G__31973 = (i__28115__auto___31972 + (1));
i__28115__auto___31972 = G__31973;
continue;
} else {
}
break;
}

var G__31967 = args31965.length;
switch (G__31967) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31965.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31968 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31968 = (function (f,blockable,meta31969){
this.f = f;
this.blockable = blockable;
this.meta31969 = meta31969;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31968.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31970,meta31969__$1){
var self__ = this;
var _31970__$1 = this;
return (new cljs.core.async.t_cljs$core$async31968(self__.f,self__.blockable,meta31969__$1));
});

cljs.core.async.t_cljs$core$async31968.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31970){
var self__ = this;
var _31970__$1 = this;
return self__.meta31969;
});

cljs.core.async.t_cljs$core$async31968.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31968.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31968.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31968.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31968.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31969","meta31969",-1898415112,null)], null);
});

cljs.core.async.t_cljs$core$async31968.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31968.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31968";

cljs.core.async.t_cljs$core$async31968.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async31968");
});

cljs.core.async.__GT_t_cljs$core$async31968 = (function cljs$core$async$__GT_t_cljs$core$async31968(f__$1,blockable__$1,meta31969){
return (new cljs.core.async.t_cljs$core$async31968(f__$1,blockable__$1,meta31969));
});

}

return (new cljs.core.async.t_cljs$core$async31968(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args31977 = [];
var len__28114__auto___31980 = arguments.length;
var i__28115__auto___31981 = (0);
while(true){
if((i__28115__auto___31981 < len__28114__auto___31980)){
args31977.push((arguments[i__28115__auto___31981]));

var G__31982 = (i__28115__auto___31981 + (1));
i__28115__auto___31981 = G__31982;
continue;
} else {
}
break;
}

var G__31979 = args31977.length;
switch (G__31979) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31977.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args31984 = [];
var len__28114__auto___31987 = arguments.length;
var i__28115__auto___31988 = (0);
while(true){
if((i__28115__auto___31988 < len__28114__auto___31987)){
args31984.push((arguments[i__28115__auto___31988]));

var G__31989 = (i__28115__auto___31988 + (1));
i__28115__auto___31988 = G__31989;
continue;
} else {
}
break;
}

var G__31986 = args31984.length;
switch (G__31986) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31984.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args31991 = [];
var len__28114__auto___31994 = arguments.length;
var i__28115__auto___31995 = (0);
while(true){
if((i__28115__auto___31995 < len__28114__auto___31994)){
args31991.push((arguments[i__28115__auto___31995]));

var G__31996 = (i__28115__auto___31995 + (1));
i__28115__auto___31995 = G__31996;
continue;
} else {
}
break;
}

var G__31993 = args31991.length;
switch (G__31993) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31991.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_31998 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_31998);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_31998,ret){
return (function (){
return fn1.call(null,val_31998);
});})(val_31998,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args31999 = [];
var len__28114__auto___32002 = arguments.length;
var i__28115__auto___32003 = (0);
while(true){
if((i__28115__auto___32003 < len__28114__auto___32002)){
args31999.push((arguments[i__28115__auto___32003]));

var G__32004 = (i__28115__auto___32003 + (1));
i__28115__auto___32003 = G__32004;
continue;
} else {
}
break;
}

var G__32001 = args31999.length;
switch (G__32001) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31999.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6745__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6745__auto__)){
var ret = temp__6745__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6745__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6745__auto__)){
var retb = temp__6745__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6745__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6745__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__27914__auto___32006 = n;
var x_32007 = (0);
while(true){
if((x_32007 < n__27914__auto___32006)){
(a[x_32007] = (0));

var G__32008 = (x_32007 + (1));
x_32007 = G__32008;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__32009 = (i + (1));
i = G__32009;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async32013 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32013 = (function (flag,meta32014){
this.flag = flag;
this.meta32014 = meta32014;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32013.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_32015,meta32014__$1){
var self__ = this;
var _32015__$1 = this;
return (new cljs.core.async.t_cljs$core$async32013(self__.flag,meta32014__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async32013.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_32015){
var self__ = this;
var _32015__$1 = this;
return self__.meta32014;
});})(flag))
;

cljs.core.async.t_cljs$core$async32013.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32013.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async32013.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async32013.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async32013.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta32014","meta32014",1244719551,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async32013.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32013.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32013";

cljs.core.async.t_cljs$core$async32013.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async32013");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async32013 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async32013(flag__$1,meta32014){
return (new cljs.core.async.t_cljs$core$async32013(flag__$1,meta32014));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async32013(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async32019 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32019 = (function (flag,cb,meta32020){
this.flag = flag;
this.cb = cb;
this.meta32020 = meta32020;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32019.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32021,meta32020__$1){
var self__ = this;
var _32021__$1 = this;
return (new cljs.core.async.t_cljs$core$async32019(self__.flag,self__.cb,meta32020__$1));
});

cljs.core.async.t_cljs$core$async32019.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32021){
var self__ = this;
var _32021__$1 = this;
return self__.meta32020;
});

cljs.core.async.t_cljs$core$async32019.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32019.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async32019.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async32019.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async32019.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta32020","meta32020",-1171060138,null)], null);
});

cljs.core.async.t_cljs$core$async32019.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32019.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32019";

cljs.core.async.t_cljs$core$async32019.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async32019");
});

cljs.core.async.__GT_t_cljs$core$async32019 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async32019(flag__$1,cb__$1,meta32020){
return (new cljs.core.async.t_cljs$core$async32019(flag__$1,cb__$1,meta32020));
});

}

return (new cljs.core.async.t_cljs$core$async32019(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__32022_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32022_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__32023_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32023_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__26898__auto__ = wport;
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return port;
}
})()], null));
} else {
var G__32024 = (i + (1));
i = G__32024;
continue;
}
} else {
return null;
}
break;
}
})();
var or__26898__auto__ = ret;
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6747__auto__ = (function (){var and__26886__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__26886__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__26886__auto__;
}
})();
if(cljs.core.truth_(temp__6747__auto__)){
var got = temp__6747__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__28121__auto__ = [];
var len__28114__auto___32030 = arguments.length;
var i__28115__auto___32031 = (0);
while(true){
if((i__28115__auto___32031 < len__28114__auto___32030)){
args__28121__auto__.push((arguments[i__28115__auto___32031]));

var G__32032 = (i__28115__auto___32031 + (1));
i__28115__auto___32031 = G__32032;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__32027){
var map__32028 = p__32027;
var map__32028__$1 = ((((!((map__32028 == null)))?((((map__32028.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32028.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32028):map__32028);
var opts = map__32028__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq32025){
var G__32026 = cljs.core.first.call(null,seq32025);
var seq32025__$1 = cljs.core.next.call(null,seq32025);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32026,seq32025__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args32033 = [];
var len__28114__auto___32083 = arguments.length;
var i__28115__auto___32084 = (0);
while(true){
if((i__28115__auto___32084 < len__28114__auto___32083)){
args32033.push((arguments[i__28115__auto___32084]));

var G__32085 = (i__28115__auto___32084 + (1));
i__28115__auto___32084 = G__32085;
continue;
} else {
}
break;
}

var G__32035 = args32033.length;
switch (G__32035) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32033.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__31906__auto___32087 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___32087){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___32087){
return (function (state_32059){
var state_val_32060 = (state_32059[(1)]);
if((state_val_32060 === (7))){
var inst_32055 = (state_32059[(2)]);
var state_32059__$1 = state_32059;
var statearr_32061_32088 = state_32059__$1;
(statearr_32061_32088[(2)] = inst_32055);

(statearr_32061_32088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (1))){
var state_32059__$1 = state_32059;
var statearr_32062_32089 = state_32059__$1;
(statearr_32062_32089[(2)] = null);

(statearr_32062_32089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (4))){
var inst_32038 = (state_32059[(7)]);
var inst_32038__$1 = (state_32059[(2)]);
var inst_32039 = (inst_32038__$1 == null);
var state_32059__$1 = (function (){var statearr_32063 = state_32059;
(statearr_32063[(7)] = inst_32038__$1);

return statearr_32063;
})();
if(cljs.core.truth_(inst_32039)){
var statearr_32064_32090 = state_32059__$1;
(statearr_32064_32090[(1)] = (5));

} else {
var statearr_32065_32091 = state_32059__$1;
(statearr_32065_32091[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (13))){
var state_32059__$1 = state_32059;
var statearr_32066_32092 = state_32059__$1;
(statearr_32066_32092[(2)] = null);

(statearr_32066_32092[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (6))){
var inst_32038 = (state_32059[(7)]);
var state_32059__$1 = state_32059;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32059__$1,(11),to,inst_32038);
} else {
if((state_val_32060 === (3))){
var inst_32057 = (state_32059[(2)]);
var state_32059__$1 = state_32059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32059__$1,inst_32057);
} else {
if((state_val_32060 === (12))){
var state_32059__$1 = state_32059;
var statearr_32067_32093 = state_32059__$1;
(statearr_32067_32093[(2)] = null);

(statearr_32067_32093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (2))){
var state_32059__$1 = state_32059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32059__$1,(4),from);
} else {
if((state_val_32060 === (11))){
var inst_32048 = (state_32059[(2)]);
var state_32059__$1 = state_32059;
if(cljs.core.truth_(inst_32048)){
var statearr_32068_32094 = state_32059__$1;
(statearr_32068_32094[(1)] = (12));

} else {
var statearr_32069_32095 = state_32059__$1;
(statearr_32069_32095[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (9))){
var state_32059__$1 = state_32059;
var statearr_32070_32096 = state_32059__$1;
(statearr_32070_32096[(2)] = null);

(statearr_32070_32096[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (5))){
var state_32059__$1 = state_32059;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32071_32097 = state_32059__$1;
(statearr_32071_32097[(1)] = (8));

} else {
var statearr_32072_32098 = state_32059__$1;
(statearr_32072_32098[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (14))){
var inst_32053 = (state_32059[(2)]);
var state_32059__$1 = state_32059;
var statearr_32073_32099 = state_32059__$1;
(statearr_32073_32099[(2)] = inst_32053);

(statearr_32073_32099[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (10))){
var inst_32045 = (state_32059[(2)]);
var state_32059__$1 = state_32059;
var statearr_32074_32100 = state_32059__$1;
(statearr_32074_32100[(2)] = inst_32045);

(statearr_32074_32100[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32060 === (8))){
var inst_32042 = cljs.core.async.close_BANG_.call(null,to);
var state_32059__$1 = state_32059;
var statearr_32075_32101 = state_32059__$1;
(statearr_32075_32101[(2)] = inst_32042);

(statearr_32075_32101[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___32087))
;
return ((function (switch__31792__auto__,c__31906__auto___32087){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_32079 = [null,null,null,null,null,null,null,null];
(statearr_32079[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_32079[(1)] = (1));

return statearr_32079;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_32059){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32080){if((e32080 instanceof Object)){
var ex__31796__auto__ = e32080;
var statearr_32081_32102 = state_32059;
(statearr_32081_32102[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32059);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32080;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32103 = state_32059;
state_32059 = G__32103;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_32059){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_32059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___32087))
})();
var state__31908__auto__ = (function (){var statearr_32082 = f__31907__auto__.call(null);
(statearr_32082[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___32087);

return statearr_32082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___32087))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__32291){
var vec__32292 = p__32291;
var v = cljs.core.nth.call(null,vec__32292,(0),null);
var p = cljs.core.nth.call(null,vec__32292,(1),null);
var job = vec__32292;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__31906__auto___32478 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___32478,res,vec__32292,v,p,job,jobs,results){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___32478,res,vec__32292,v,p,job,jobs,results){
return (function (state_32299){
var state_val_32300 = (state_32299[(1)]);
if((state_val_32300 === (1))){
var state_32299__$1 = state_32299;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32299__$1,(2),res,v);
} else {
if((state_val_32300 === (2))){
var inst_32296 = (state_32299[(2)]);
var inst_32297 = cljs.core.async.close_BANG_.call(null,res);
var state_32299__$1 = (function (){var statearr_32301 = state_32299;
(statearr_32301[(7)] = inst_32296);

return statearr_32301;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32299__$1,inst_32297);
} else {
return null;
}
}
});})(c__31906__auto___32478,res,vec__32292,v,p,job,jobs,results))
;
return ((function (switch__31792__auto__,c__31906__auto___32478,res,vec__32292,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0 = (function (){
var statearr_32305 = [null,null,null,null,null,null,null,null];
(statearr_32305[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__);

(statearr_32305[(1)] = (1));

return statearr_32305;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1 = (function (state_32299){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32306){if((e32306 instanceof Object)){
var ex__31796__auto__ = e32306;
var statearr_32307_32479 = state_32299;
(statearr_32307_32479[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32299);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32480 = state_32299;
state_32299 = G__32480;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = function(state_32299){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1.call(this,state_32299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___32478,res,vec__32292,v,p,job,jobs,results))
})();
var state__31908__auto__ = (function (){var statearr_32308 = f__31907__auto__.call(null);
(statearr_32308[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___32478);

return statearr_32308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___32478,res,vec__32292,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__32309){
var vec__32310 = p__32309;
var v = cljs.core.nth.call(null,vec__32310,(0),null);
var p = cljs.core.nth.call(null,vec__32310,(1),null);
var job = vec__32310;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__27914__auto___32481 = n;
var __32482 = (0);
while(true){
if((__32482 < n__27914__auto___32481)){
var G__32313_32483 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__32313_32483) {
case "compute":
var c__31906__auto___32485 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__32482,c__31906__auto___32485,G__32313_32483,n__27914__auto___32481,jobs,results,process,async){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (__32482,c__31906__auto___32485,G__32313_32483,n__27914__auto___32481,jobs,results,process,async){
return (function (state_32326){
var state_val_32327 = (state_32326[(1)]);
if((state_val_32327 === (1))){
var state_32326__$1 = state_32326;
var statearr_32328_32486 = state_32326__$1;
(statearr_32328_32486[(2)] = null);

(statearr_32328_32486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (2))){
var state_32326__$1 = state_32326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32326__$1,(4),jobs);
} else {
if((state_val_32327 === (3))){
var inst_32324 = (state_32326[(2)]);
var state_32326__$1 = state_32326;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32326__$1,inst_32324);
} else {
if((state_val_32327 === (4))){
var inst_32316 = (state_32326[(2)]);
var inst_32317 = process.call(null,inst_32316);
var state_32326__$1 = state_32326;
if(cljs.core.truth_(inst_32317)){
var statearr_32329_32487 = state_32326__$1;
(statearr_32329_32487[(1)] = (5));

} else {
var statearr_32330_32488 = state_32326__$1;
(statearr_32330_32488[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (5))){
var state_32326__$1 = state_32326;
var statearr_32331_32489 = state_32326__$1;
(statearr_32331_32489[(2)] = null);

(statearr_32331_32489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (6))){
var state_32326__$1 = state_32326;
var statearr_32332_32490 = state_32326__$1;
(statearr_32332_32490[(2)] = null);

(statearr_32332_32490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (7))){
var inst_32322 = (state_32326[(2)]);
var state_32326__$1 = state_32326;
var statearr_32333_32491 = state_32326__$1;
(statearr_32333_32491[(2)] = inst_32322);

(statearr_32333_32491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32482,c__31906__auto___32485,G__32313_32483,n__27914__auto___32481,jobs,results,process,async))
;
return ((function (__32482,switch__31792__auto__,c__31906__auto___32485,G__32313_32483,n__27914__auto___32481,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0 = (function (){
var statearr_32337 = [null,null,null,null,null,null,null];
(statearr_32337[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__);

(statearr_32337[(1)] = (1));

return statearr_32337;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1 = (function (state_32326){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32326);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32338){if((e32338 instanceof Object)){
var ex__31796__auto__ = e32338;
var statearr_32339_32492 = state_32326;
(statearr_32339_32492[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32326);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32338;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32493 = state_32326;
state_32326 = G__32493;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = function(state_32326){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1.call(this,state_32326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__;
})()
;})(__32482,switch__31792__auto__,c__31906__auto___32485,G__32313_32483,n__27914__auto___32481,jobs,results,process,async))
})();
var state__31908__auto__ = (function (){var statearr_32340 = f__31907__auto__.call(null);
(statearr_32340[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___32485);

return statearr_32340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(__32482,c__31906__auto___32485,G__32313_32483,n__27914__auto___32481,jobs,results,process,async))
);


break;
case "async":
var c__31906__auto___32494 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__32482,c__31906__auto___32494,G__32313_32483,n__27914__auto___32481,jobs,results,process,async){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (__32482,c__31906__auto___32494,G__32313_32483,n__27914__auto___32481,jobs,results,process,async){
return (function (state_32353){
var state_val_32354 = (state_32353[(1)]);
if((state_val_32354 === (1))){
var state_32353__$1 = state_32353;
var statearr_32355_32495 = state_32353__$1;
(statearr_32355_32495[(2)] = null);

(statearr_32355_32495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (2))){
var state_32353__$1 = state_32353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32353__$1,(4),jobs);
} else {
if((state_val_32354 === (3))){
var inst_32351 = (state_32353[(2)]);
var state_32353__$1 = state_32353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32353__$1,inst_32351);
} else {
if((state_val_32354 === (4))){
var inst_32343 = (state_32353[(2)]);
var inst_32344 = async.call(null,inst_32343);
var state_32353__$1 = state_32353;
if(cljs.core.truth_(inst_32344)){
var statearr_32356_32496 = state_32353__$1;
(statearr_32356_32496[(1)] = (5));

} else {
var statearr_32357_32497 = state_32353__$1;
(statearr_32357_32497[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (5))){
var state_32353__$1 = state_32353;
var statearr_32358_32498 = state_32353__$1;
(statearr_32358_32498[(2)] = null);

(statearr_32358_32498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (6))){
var state_32353__$1 = state_32353;
var statearr_32359_32499 = state_32353__$1;
(statearr_32359_32499[(2)] = null);

(statearr_32359_32499[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (7))){
var inst_32349 = (state_32353[(2)]);
var state_32353__$1 = state_32353;
var statearr_32360_32500 = state_32353__$1;
(statearr_32360_32500[(2)] = inst_32349);

(statearr_32360_32500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32482,c__31906__auto___32494,G__32313_32483,n__27914__auto___32481,jobs,results,process,async))
;
return ((function (__32482,switch__31792__auto__,c__31906__auto___32494,G__32313_32483,n__27914__auto___32481,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0 = (function (){
var statearr_32364 = [null,null,null,null,null,null,null];
(statearr_32364[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__);

(statearr_32364[(1)] = (1));

return statearr_32364;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1 = (function (state_32353){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32365){if((e32365 instanceof Object)){
var ex__31796__auto__ = e32365;
var statearr_32366_32501 = state_32353;
(statearr_32366_32501[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32353);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32365;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32502 = state_32353;
state_32353 = G__32502;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = function(state_32353){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1.call(this,state_32353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__;
})()
;})(__32482,switch__31792__auto__,c__31906__auto___32494,G__32313_32483,n__27914__auto___32481,jobs,results,process,async))
})();
var state__31908__auto__ = (function (){var statearr_32367 = f__31907__auto__.call(null);
(statearr_32367[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___32494);

return statearr_32367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(__32482,c__31906__auto___32494,G__32313_32483,n__27914__auto___32481,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__32503 = (__32482 + (1));
__32482 = G__32503;
continue;
} else {
}
break;
}

var c__31906__auto___32504 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___32504,jobs,results,process,async){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___32504,jobs,results,process,async){
return (function (state_32389){
var state_val_32390 = (state_32389[(1)]);
if((state_val_32390 === (1))){
var state_32389__$1 = state_32389;
var statearr_32391_32505 = state_32389__$1;
(statearr_32391_32505[(2)] = null);

(statearr_32391_32505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32390 === (2))){
var state_32389__$1 = state_32389;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32389__$1,(4),from);
} else {
if((state_val_32390 === (3))){
var inst_32387 = (state_32389[(2)]);
var state_32389__$1 = state_32389;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32389__$1,inst_32387);
} else {
if((state_val_32390 === (4))){
var inst_32370 = (state_32389[(7)]);
var inst_32370__$1 = (state_32389[(2)]);
var inst_32371 = (inst_32370__$1 == null);
var state_32389__$1 = (function (){var statearr_32392 = state_32389;
(statearr_32392[(7)] = inst_32370__$1);

return statearr_32392;
})();
if(cljs.core.truth_(inst_32371)){
var statearr_32393_32506 = state_32389__$1;
(statearr_32393_32506[(1)] = (5));

} else {
var statearr_32394_32507 = state_32389__$1;
(statearr_32394_32507[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32390 === (5))){
var inst_32373 = cljs.core.async.close_BANG_.call(null,jobs);
var state_32389__$1 = state_32389;
var statearr_32395_32508 = state_32389__$1;
(statearr_32395_32508[(2)] = inst_32373);

(statearr_32395_32508[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32390 === (6))){
var inst_32370 = (state_32389[(7)]);
var inst_32375 = (state_32389[(8)]);
var inst_32375__$1 = cljs.core.async.chan.call(null,(1));
var inst_32376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32377 = [inst_32370,inst_32375__$1];
var inst_32378 = (new cljs.core.PersistentVector(null,2,(5),inst_32376,inst_32377,null));
var state_32389__$1 = (function (){var statearr_32396 = state_32389;
(statearr_32396[(8)] = inst_32375__$1);

return statearr_32396;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32389__$1,(8),jobs,inst_32378);
} else {
if((state_val_32390 === (7))){
var inst_32385 = (state_32389[(2)]);
var state_32389__$1 = state_32389;
var statearr_32397_32509 = state_32389__$1;
(statearr_32397_32509[(2)] = inst_32385);

(statearr_32397_32509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32390 === (8))){
var inst_32375 = (state_32389[(8)]);
var inst_32380 = (state_32389[(2)]);
var state_32389__$1 = (function (){var statearr_32398 = state_32389;
(statearr_32398[(9)] = inst_32380);

return statearr_32398;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32389__$1,(9),results,inst_32375);
} else {
if((state_val_32390 === (9))){
var inst_32382 = (state_32389[(2)]);
var state_32389__$1 = (function (){var statearr_32399 = state_32389;
(statearr_32399[(10)] = inst_32382);

return statearr_32399;
})();
var statearr_32400_32510 = state_32389__$1;
(statearr_32400_32510[(2)] = null);

(statearr_32400_32510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___32504,jobs,results,process,async))
;
return ((function (switch__31792__auto__,c__31906__auto___32504,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0 = (function (){
var statearr_32404 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32404[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__);

(statearr_32404[(1)] = (1));

return statearr_32404;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1 = (function (state_32389){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32389);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32405){if((e32405 instanceof Object)){
var ex__31796__auto__ = e32405;
var statearr_32406_32511 = state_32389;
(statearr_32406_32511[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32389);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32405;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32512 = state_32389;
state_32389 = G__32512;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = function(state_32389){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1.call(this,state_32389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___32504,jobs,results,process,async))
})();
var state__31908__auto__ = (function (){var statearr_32407 = f__31907__auto__.call(null);
(statearr_32407[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___32504);

return statearr_32407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___32504,jobs,results,process,async))
);


var c__31906__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto__,jobs,results,process,async){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto__,jobs,results,process,async){
return (function (state_32445){
var state_val_32446 = (state_32445[(1)]);
if((state_val_32446 === (7))){
var inst_32441 = (state_32445[(2)]);
var state_32445__$1 = state_32445;
var statearr_32447_32513 = state_32445__$1;
(statearr_32447_32513[(2)] = inst_32441);

(statearr_32447_32513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (20))){
var state_32445__$1 = state_32445;
var statearr_32448_32514 = state_32445__$1;
(statearr_32448_32514[(2)] = null);

(statearr_32448_32514[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (1))){
var state_32445__$1 = state_32445;
var statearr_32449_32515 = state_32445__$1;
(statearr_32449_32515[(2)] = null);

(statearr_32449_32515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (4))){
var inst_32410 = (state_32445[(7)]);
var inst_32410__$1 = (state_32445[(2)]);
var inst_32411 = (inst_32410__$1 == null);
var state_32445__$1 = (function (){var statearr_32450 = state_32445;
(statearr_32450[(7)] = inst_32410__$1);

return statearr_32450;
})();
if(cljs.core.truth_(inst_32411)){
var statearr_32451_32516 = state_32445__$1;
(statearr_32451_32516[(1)] = (5));

} else {
var statearr_32452_32517 = state_32445__$1;
(statearr_32452_32517[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (15))){
var inst_32423 = (state_32445[(8)]);
var state_32445__$1 = state_32445;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32445__$1,(18),to,inst_32423);
} else {
if((state_val_32446 === (21))){
var inst_32436 = (state_32445[(2)]);
var state_32445__$1 = state_32445;
var statearr_32453_32518 = state_32445__$1;
(statearr_32453_32518[(2)] = inst_32436);

(statearr_32453_32518[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (13))){
var inst_32438 = (state_32445[(2)]);
var state_32445__$1 = (function (){var statearr_32454 = state_32445;
(statearr_32454[(9)] = inst_32438);

return statearr_32454;
})();
var statearr_32455_32519 = state_32445__$1;
(statearr_32455_32519[(2)] = null);

(statearr_32455_32519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (6))){
var inst_32410 = (state_32445[(7)]);
var state_32445__$1 = state_32445;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32445__$1,(11),inst_32410);
} else {
if((state_val_32446 === (17))){
var inst_32431 = (state_32445[(2)]);
var state_32445__$1 = state_32445;
if(cljs.core.truth_(inst_32431)){
var statearr_32456_32520 = state_32445__$1;
(statearr_32456_32520[(1)] = (19));

} else {
var statearr_32457_32521 = state_32445__$1;
(statearr_32457_32521[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (3))){
var inst_32443 = (state_32445[(2)]);
var state_32445__$1 = state_32445;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32445__$1,inst_32443);
} else {
if((state_val_32446 === (12))){
var inst_32420 = (state_32445[(10)]);
var state_32445__$1 = state_32445;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32445__$1,(14),inst_32420);
} else {
if((state_val_32446 === (2))){
var state_32445__$1 = state_32445;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32445__$1,(4),results);
} else {
if((state_val_32446 === (19))){
var state_32445__$1 = state_32445;
var statearr_32458_32522 = state_32445__$1;
(statearr_32458_32522[(2)] = null);

(statearr_32458_32522[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (11))){
var inst_32420 = (state_32445[(2)]);
var state_32445__$1 = (function (){var statearr_32459 = state_32445;
(statearr_32459[(10)] = inst_32420);

return statearr_32459;
})();
var statearr_32460_32523 = state_32445__$1;
(statearr_32460_32523[(2)] = null);

(statearr_32460_32523[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (9))){
var state_32445__$1 = state_32445;
var statearr_32461_32524 = state_32445__$1;
(statearr_32461_32524[(2)] = null);

(statearr_32461_32524[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (5))){
var state_32445__$1 = state_32445;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32462_32525 = state_32445__$1;
(statearr_32462_32525[(1)] = (8));

} else {
var statearr_32463_32526 = state_32445__$1;
(statearr_32463_32526[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (14))){
var inst_32425 = (state_32445[(11)]);
var inst_32423 = (state_32445[(8)]);
var inst_32423__$1 = (state_32445[(2)]);
var inst_32424 = (inst_32423__$1 == null);
var inst_32425__$1 = cljs.core.not.call(null,inst_32424);
var state_32445__$1 = (function (){var statearr_32464 = state_32445;
(statearr_32464[(11)] = inst_32425__$1);

(statearr_32464[(8)] = inst_32423__$1);

return statearr_32464;
})();
if(inst_32425__$1){
var statearr_32465_32527 = state_32445__$1;
(statearr_32465_32527[(1)] = (15));

} else {
var statearr_32466_32528 = state_32445__$1;
(statearr_32466_32528[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (16))){
var inst_32425 = (state_32445[(11)]);
var state_32445__$1 = state_32445;
var statearr_32467_32529 = state_32445__$1;
(statearr_32467_32529[(2)] = inst_32425);

(statearr_32467_32529[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (10))){
var inst_32417 = (state_32445[(2)]);
var state_32445__$1 = state_32445;
var statearr_32468_32530 = state_32445__$1;
(statearr_32468_32530[(2)] = inst_32417);

(statearr_32468_32530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (18))){
var inst_32428 = (state_32445[(2)]);
var state_32445__$1 = state_32445;
var statearr_32469_32531 = state_32445__$1;
(statearr_32469_32531[(2)] = inst_32428);

(statearr_32469_32531[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32446 === (8))){
var inst_32414 = cljs.core.async.close_BANG_.call(null,to);
var state_32445__$1 = state_32445;
var statearr_32470_32532 = state_32445__$1;
(statearr_32470_32532[(2)] = inst_32414);

(statearr_32470_32532[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto__,jobs,results,process,async))
;
return ((function (switch__31792__auto__,c__31906__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0 = (function (){
var statearr_32474 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32474[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__);

(statearr_32474[(1)] = (1));

return statearr_32474;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1 = (function (state_32445){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32475){if((e32475 instanceof Object)){
var ex__31796__auto__ = e32475;
var statearr_32476_32533 = state_32445;
(statearr_32476_32533[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32445);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32475;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32534 = state_32445;
state_32445 = G__32534;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__ = function(state_32445){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1.call(this,state_32445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31793__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto__,jobs,results,process,async))
})();
var state__31908__auto__ = (function (){var statearr_32477 = f__31907__auto__.call(null);
(statearr_32477[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto__);

return statearr_32477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto__,jobs,results,process,async))
);

return c__31906__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args32535 = [];
var len__28114__auto___32538 = arguments.length;
var i__28115__auto___32539 = (0);
while(true){
if((i__28115__auto___32539 < len__28114__auto___32538)){
args32535.push((arguments[i__28115__auto___32539]));

var G__32540 = (i__28115__auto___32539 + (1));
i__28115__auto___32539 = G__32540;
continue;
} else {
}
break;
}

var G__32537 = args32535.length;
switch (G__32537) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32535.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args32542 = [];
var len__28114__auto___32545 = arguments.length;
var i__28115__auto___32546 = (0);
while(true){
if((i__28115__auto___32546 < len__28114__auto___32545)){
args32542.push((arguments[i__28115__auto___32546]));

var G__32547 = (i__28115__auto___32546 + (1));
i__28115__auto___32546 = G__32547;
continue;
} else {
}
break;
}

var G__32544 = args32542.length;
switch (G__32544) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32542.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args32549 = [];
var len__28114__auto___32602 = arguments.length;
var i__28115__auto___32603 = (0);
while(true){
if((i__28115__auto___32603 < len__28114__auto___32602)){
args32549.push((arguments[i__28115__auto___32603]));

var G__32604 = (i__28115__auto___32603 + (1));
i__28115__auto___32603 = G__32604;
continue;
} else {
}
break;
}

var G__32551 = args32549.length;
switch (G__32551) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32549.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__31906__auto___32606 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___32606,tc,fc){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___32606,tc,fc){
return (function (state_32577){
var state_val_32578 = (state_32577[(1)]);
if((state_val_32578 === (7))){
var inst_32573 = (state_32577[(2)]);
var state_32577__$1 = state_32577;
var statearr_32579_32607 = state_32577__$1;
(statearr_32579_32607[(2)] = inst_32573);

(statearr_32579_32607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (1))){
var state_32577__$1 = state_32577;
var statearr_32580_32608 = state_32577__$1;
(statearr_32580_32608[(2)] = null);

(statearr_32580_32608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (4))){
var inst_32554 = (state_32577[(7)]);
var inst_32554__$1 = (state_32577[(2)]);
var inst_32555 = (inst_32554__$1 == null);
var state_32577__$1 = (function (){var statearr_32581 = state_32577;
(statearr_32581[(7)] = inst_32554__$1);

return statearr_32581;
})();
if(cljs.core.truth_(inst_32555)){
var statearr_32582_32609 = state_32577__$1;
(statearr_32582_32609[(1)] = (5));

} else {
var statearr_32583_32610 = state_32577__$1;
(statearr_32583_32610[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (13))){
var state_32577__$1 = state_32577;
var statearr_32584_32611 = state_32577__$1;
(statearr_32584_32611[(2)] = null);

(statearr_32584_32611[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (6))){
var inst_32554 = (state_32577[(7)]);
var inst_32560 = p.call(null,inst_32554);
var state_32577__$1 = state_32577;
if(cljs.core.truth_(inst_32560)){
var statearr_32585_32612 = state_32577__$1;
(statearr_32585_32612[(1)] = (9));

} else {
var statearr_32586_32613 = state_32577__$1;
(statearr_32586_32613[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (3))){
var inst_32575 = (state_32577[(2)]);
var state_32577__$1 = state_32577;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32577__$1,inst_32575);
} else {
if((state_val_32578 === (12))){
var state_32577__$1 = state_32577;
var statearr_32587_32614 = state_32577__$1;
(statearr_32587_32614[(2)] = null);

(statearr_32587_32614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (2))){
var state_32577__$1 = state_32577;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32577__$1,(4),ch);
} else {
if((state_val_32578 === (11))){
var inst_32554 = (state_32577[(7)]);
var inst_32564 = (state_32577[(2)]);
var state_32577__$1 = state_32577;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32577__$1,(8),inst_32564,inst_32554);
} else {
if((state_val_32578 === (9))){
var state_32577__$1 = state_32577;
var statearr_32588_32615 = state_32577__$1;
(statearr_32588_32615[(2)] = tc);

(statearr_32588_32615[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (5))){
var inst_32557 = cljs.core.async.close_BANG_.call(null,tc);
var inst_32558 = cljs.core.async.close_BANG_.call(null,fc);
var state_32577__$1 = (function (){var statearr_32589 = state_32577;
(statearr_32589[(8)] = inst_32557);

return statearr_32589;
})();
var statearr_32590_32616 = state_32577__$1;
(statearr_32590_32616[(2)] = inst_32558);

(statearr_32590_32616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (14))){
var inst_32571 = (state_32577[(2)]);
var state_32577__$1 = state_32577;
var statearr_32591_32617 = state_32577__$1;
(statearr_32591_32617[(2)] = inst_32571);

(statearr_32591_32617[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (10))){
var state_32577__$1 = state_32577;
var statearr_32592_32618 = state_32577__$1;
(statearr_32592_32618[(2)] = fc);

(statearr_32592_32618[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32578 === (8))){
var inst_32566 = (state_32577[(2)]);
var state_32577__$1 = state_32577;
if(cljs.core.truth_(inst_32566)){
var statearr_32593_32619 = state_32577__$1;
(statearr_32593_32619[(1)] = (12));

} else {
var statearr_32594_32620 = state_32577__$1;
(statearr_32594_32620[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___32606,tc,fc))
;
return ((function (switch__31792__auto__,c__31906__auto___32606,tc,fc){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_32598 = [null,null,null,null,null,null,null,null,null];
(statearr_32598[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_32598[(1)] = (1));

return statearr_32598;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_32577){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32577);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32599){if((e32599 instanceof Object)){
var ex__31796__auto__ = e32599;
var statearr_32600_32621 = state_32577;
(statearr_32600_32621[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32577);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32599;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32622 = state_32577;
state_32577 = G__32622;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_32577){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_32577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___32606,tc,fc))
})();
var state__31908__auto__ = (function (){var statearr_32601 = f__31907__auto__.call(null);
(statearr_32601[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___32606);

return statearr_32601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___32606,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__31906__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto__){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto__){
return (function (state_32686){
var state_val_32687 = (state_32686[(1)]);
if((state_val_32687 === (7))){
var inst_32682 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
var statearr_32688_32709 = state_32686__$1;
(statearr_32688_32709[(2)] = inst_32682);

(statearr_32688_32709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (1))){
var inst_32666 = init;
var state_32686__$1 = (function (){var statearr_32689 = state_32686;
(statearr_32689[(7)] = inst_32666);

return statearr_32689;
})();
var statearr_32690_32710 = state_32686__$1;
(statearr_32690_32710[(2)] = null);

(statearr_32690_32710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (4))){
var inst_32669 = (state_32686[(8)]);
var inst_32669__$1 = (state_32686[(2)]);
var inst_32670 = (inst_32669__$1 == null);
var state_32686__$1 = (function (){var statearr_32691 = state_32686;
(statearr_32691[(8)] = inst_32669__$1);

return statearr_32691;
})();
if(cljs.core.truth_(inst_32670)){
var statearr_32692_32711 = state_32686__$1;
(statearr_32692_32711[(1)] = (5));

} else {
var statearr_32693_32712 = state_32686__$1;
(statearr_32693_32712[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (6))){
var inst_32666 = (state_32686[(7)]);
var inst_32669 = (state_32686[(8)]);
var inst_32673 = (state_32686[(9)]);
var inst_32673__$1 = f.call(null,inst_32666,inst_32669);
var inst_32674 = cljs.core.reduced_QMARK_.call(null,inst_32673__$1);
var state_32686__$1 = (function (){var statearr_32694 = state_32686;
(statearr_32694[(9)] = inst_32673__$1);

return statearr_32694;
})();
if(inst_32674){
var statearr_32695_32713 = state_32686__$1;
(statearr_32695_32713[(1)] = (8));

} else {
var statearr_32696_32714 = state_32686__$1;
(statearr_32696_32714[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (3))){
var inst_32684 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32686__$1,inst_32684);
} else {
if((state_val_32687 === (2))){
var state_32686__$1 = state_32686;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32686__$1,(4),ch);
} else {
if((state_val_32687 === (9))){
var inst_32673 = (state_32686[(9)]);
var inst_32666 = inst_32673;
var state_32686__$1 = (function (){var statearr_32697 = state_32686;
(statearr_32697[(7)] = inst_32666);

return statearr_32697;
})();
var statearr_32698_32715 = state_32686__$1;
(statearr_32698_32715[(2)] = null);

(statearr_32698_32715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (5))){
var inst_32666 = (state_32686[(7)]);
var state_32686__$1 = state_32686;
var statearr_32699_32716 = state_32686__$1;
(statearr_32699_32716[(2)] = inst_32666);

(statearr_32699_32716[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (10))){
var inst_32680 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
var statearr_32700_32717 = state_32686__$1;
(statearr_32700_32717[(2)] = inst_32680);

(statearr_32700_32717[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (8))){
var inst_32673 = (state_32686[(9)]);
var inst_32676 = cljs.core.deref.call(null,inst_32673);
var state_32686__$1 = state_32686;
var statearr_32701_32718 = state_32686__$1;
(statearr_32701_32718[(2)] = inst_32676);

(statearr_32701_32718[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto__))
;
return ((function (switch__31792__auto__,c__31906__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__31793__auto__ = null;
var cljs$core$async$reduce_$_state_machine__31793__auto____0 = (function (){
var statearr_32705 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32705[(0)] = cljs$core$async$reduce_$_state_machine__31793__auto__);

(statearr_32705[(1)] = (1));

return statearr_32705;
});
var cljs$core$async$reduce_$_state_machine__31793__auto____1 = (function (state_32686){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32686);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32706){if((e32706 instanceof Object)){
var ex__31796__auto__ = e32706;
var statearr_32707_32719 = state_32686;
(statearr_32707_32719[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32686);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32706;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32720 = state_32686;
state_32686 = G__32720;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__31793__auto__ = function(state_32686){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__31793__auto____1.call(this,state_32686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__31793__auto____0;
cljs$core$async$reduce_$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__31793__auto____1;
return cljs$core$async$reduce_$_state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto__))
})();
var state__31908__auto__ = (function (){var statearr_32708 = f__31907__auto__.call(null);
(statearr_32708[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto__);

return statearr_32708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto__))
);

return c__31906__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__31906__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto__,f__$1){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto__,f__$1){
return (function (state_32740){
var state_val_32741 = (state_32740[(1)]);
if((state_val_32741 === (1))){
var inst_32735 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_32740__$1 = state_32740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32740__$1,(2),inst_32735);
} else {
if((state_val_32741 === (2))){
var inst_32737 = (state_32740[(2)]);
var inst_32738 = f__$1.call(null,inst_32737);
var state_32740__$1 = state_32740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32740__$1,inst_32738);
} else {
return null;
}
}
});})(c__31906__auto__,f__$1))
;
return ((function (switch__31792__auto__,c__31906__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__31793__auto__ = null;
var cljs$core$async$transduce_$_state_machine__31793__auto____0 = (function (){
var statearr_32745 = [null,null,null,null,null,null,null];
(statearr_32745[(0)] = cljs$core$async$transduce_$_state_machine__31793__auto__);

(statearr_32745[(1)] = (1));

return statearr_32745;
});
var cljs$core$async$transduce_$_state_machine__31793__auto____1 = (function (state_32740){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32746){if((e32746 instanceof Object)){
var ex__31796__auto__ = e32746;
var statearr_32747_32749 = state_32740;
(statearr_32747_32749[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32740);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32746;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32750 = state_32740;
state_32740 = G__32750;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__31793__auto__ = function(state_32740){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__31793__auto____1.call(this,state_32740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__31793__auto____0;
cljs$core$async$transduce_$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__31793__auto____1;
return cljs$core$async$transduce_$_state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto__,f__$1))
})();
var state__31908__auto__ = (function (){var statearr_32748 = f__31907__auto__.call(null);
(statearr_32748[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto__);

return statearr_32748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto__,f__$1))
);

return c__31906__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args32751 = [];
var len__28114__auto___32803 = arguments.length;
var i__28115__auto___32804 = (0);
while(true){
if((i__28115__auto___32804 < len__28114__auto___32803)){
args32751.push((arguments[i__28115__auto___32804]));

var G__32805 = (i__28115__auto___32804 + (1));
i__28115__auto___32804 = G__32805;
continue;
} else {
}
break;
}

var G__32753 = args32751.length;
switch (G__32753) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32751.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__31906__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto__){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto__){
return (function (state_32778){
var state_val_32779 = (state_32778[(1)]);
if((state_val_32779 === (7))){
var inst_32760 = (state_32778[(2)]);
var state_32778__$1 = state_32778;
var statearr_32780_32807 = state_32778__$1;
(statearr_32780_32807[(2)] = inst_32760);

(statearr_32780_32807[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (1))){
var inst_32754 = cljs.core.seq.call(null,coll);
var inst_32755 = inst_32754;
var state_32778__$1 = (function (){var statearr_32781 = state_32778;
(statearr_32781[(7)] = inst_32755);

return statearr_32781;
})();
var statearr_32782_32808 = state_32778__$1;
(statearr_32782_32808[(2)] = null);

(statearr_32782_32808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (4))){
var inst_32755 = (state_32778[(7)]);
var inst_32758 = cljs.core.first.call(null,inst_32755);
var state_32778__$1 = state_32778;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32778__$1,(7),ch,inst_32758);
} else {
if((state_val_32779 === (13))){
var inst_32772 = (state_32778[(2)]);
var state_32778__$1 = state_32778;
var statearr_32783_32809 = state_32778__$1;
(statearr_32783_32809[(2)] = inst_32772);

(statearr_32783_32809[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (6))){
var inst_32763 = (state_32778[(2)]);
var state_32778__$1 = state_32778;
if(cljs.core.truth_(inst_32763)){
var statearr_32784_32810 = state_32778__$1;
(statearr_32784_32810[(1)] = (8));

} else {
var statearr_32785_32811 = state_32778__$1;
(statearr_32785_32811[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (3))){
var inst_32776 = (state_32778[(2)]);
var state_32778__$1 = state_32778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32778__$1,inst_32776);
} else {
if((state_val_32779 === (12))){
var state_32778__$1 = state_32778;
var statearr_32786_32812 = state_32778__$1;
(statearr_32786_32812[(2)] = null);

(statearr_32786_32812[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (2))){
var inst_32755 = (state_32778[(7)]);
var state_32778__$1 = state_32778;
if(cljs.core.truth_(inst_32755)){
var statearr_32787_32813 = state_32778__$1;
(statearr_32787_32813[(1)] = (4));

} else {
var statearr_32788_32814 = state_32778__$1;
(statearr_32788_32814[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (11))){
var inst_32769 = cljs.core.async.close_BANG_.call(null,ch);
var state_32778__$1 = state_32778;
var statearr_32789_32815 = state_32778__$1;
(statearr_32789_32815[(2)] = inst_32769);

(statearr_32789_32815[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (9))){
var state_32778__$1 = state_32778;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32790_32816 = state_32778__$1;
(statearr_32790_32816[(1)] = (11));

} else {
var statearr_32791_32817 = state_32778__$1;
(statearr_32791_32817[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (5))){
var inst_32755 = (state_32778[(7)]);
var state_32778__$1 = state_32778;
var statearr_32792_32818 = state_32778__$1;
(statearr_32792_32818[(2)] = inst_32755);

(statearr_32792_32818[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (10))){
var inst_32774 = (state_32778[(2)]);
var state_32778__$1 = state_32778;
var statearr_32793_32819 = state_32778__$1;
(statearr_32793_32819[(2)] = inst_32774);

(statearr_32793_32819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32779 === (8))){
var inst_32755 = (state_32778[(7)]);
var inst_32765 = cljs.core.next.call(null,inst_32755);
var inst_32755__$1 = inst_32765;
var state_32778__$1 = (function (){var statearr_32794 = state_32778;
(statearr_32794[(7)] = inst_32755__$1);

return statearr_32794;
})();
var statearr_32795_32820 = state_32778__$1;
(statearr_32795_32820[(2)] = null);

(statearr_32795_32820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto__))
;
return ((function (switch__31792__auto__,c__31906__auto__){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_32799 = [null,null,null,null,null,null,null,null];
(statearr_32799[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_32799[(1)] = (1));

return statearr_32799;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_32778){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_32778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e32800){if((e32800 instanceof Object)){
var ex__31796__auto__ = e32800;
var statearr_32801_32821 = state_32778;
(statearr_32801_32821[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32800;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32822 = state_32778;
state_32778 = G__32822;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_32778){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_32778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto__))
})();
var state__31908__auto__ = (function (){var statearr_32802 = f__31907__auto__.call(null);
(statearr_32802[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto__);

return statearr_32802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto__))
);

return c__31906__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27611__auto__ = (((_ == null))?null:_);
var m__27612__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,_);
} else {
var m__27612__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27612__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,ch);
} else {
var m__27612__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m);
} else {
var m__27612__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33048 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33048 = (function (ch,cs,meta33049){
this.ch = ch;
this.cs = cs;
this.meta33049 = meta33049;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33048.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_33050,meta33049__$1){
var self__ = this;
var _33050__$1 = this;
return (new cljs.core.async.t_cljs$core$async33048(self__.ch,self__.cs,meta33049__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async33048.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_33050){
var self__ = this;
var _33050__$1 = this;
return self__.meta33049;
});})(cs))
;

cljs.core.async.t_cljs$core$async33048.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33048.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async33048.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33048.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async33048.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async33048.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async33048.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta33049","meta33049",1378390778,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async33048.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33048.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33048";

cljs.core.async.t_cljs$core$async33048.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async33048");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async33048 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async33048(ch__$1,cs__$1,meta33049){
return (new cljs.core.async.t_cljs$core$async33048(ch__$1,cs__$1,meta33049));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async33048(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__31906__auto___33273 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___33273,cs,m,dchan,dctr,done){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___33273,cs,m,dchan,dctr,done){
return (function (state_33185){
var state_val_33186 = (state_33185[(1)]);
if((state_val_33186 === (7))){
var inst_33181 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
var statearr_33187_33274 = state_33185__$1;
(statearr_33187_33274[(2)] = inst_33181);

(statearr_33187_33274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (20))){
var inst_33084 = (state_33185[(7)]);
var inst_33096 = cljs.core.first.call(null,inst_33084);
var inst_33097 = cljs.core.nth.call(null,inst_33096,(0),null);
var inst_33098 = cljs.core.nth.call(null,inst_33096,(1),null);
var state_33185__$1 = (function (){var statearr_33188 = state_33185;
(statearr_33188[(8)] = inst_33097);

return statearr_33188;
})();
if(cljs.core.truth_(inst_33098)){
var statearr_33189_33275 = state_33185__$1;
(statearr_33189_33275[(1)] = (22));

} else {
var statearr_33190_33276 = state_33185__$1;
(statearr_33190_33276[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (27))){
var inst_33128 = (state_33185[(9)]);
var inst_33133 = (state_33185[(10)]);
var inst_33126 = (state_33185[(11)]);
var inst_33053 = (state_33185[(12)]);
var inst_33133__$1 = cljs.core._nth.call(null,inst_33126,inst_33128);
var inst_33134 = cljs.core.async.put_BANG_.call(null,inst_33133__$1,inst_33053,done);
var state_33185__$1 = (function (){var statearr_33191 = state_33185;
(statearr_33191[(10)] = inst_33133__$1);

return statearr_33191;
})();
if(cljs.core.truth_(inst_33134)){
var statearr_33192_33277 = state_33185__$1;
(statearr_33192_33277[(1)] = (30));

} else {
var statearr_33193_33278 = state_33185__$1;
(statearr_33193_33278[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (1))){
var state_33185__$1 = state_33185;
var statearr_33194_33279 = state_33185__$1;
(statearr_33194_33279[(2)] = null);

(statearr_33194_33279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (24))){
var inst_33084 = (state_33185[(7)]);
var inst_33103 = (state_33185[(2)]);
var inst_33104 = cljs.core.next.call(null,inst_33084);
var inst_33062 = inst_33104;
var inst_33063 = null;
var inst_33064 = (0);
var inst_33065 = (0);
var state_33185__$1 = (function (){var statearr_33195 = state_33185;
(statearr_33195[(13)] = inst_33065);

(statearr_33195[(14)] = inst_33063);

(statearr_33195[(15)] = inst_33103);

(statearr_33195[(16)] = inst_33064);

(statearr_33195[(17)] = inst_33062);

return statearr_33195;
})();
var statearr_33196_33280 = state_33185__$1;
(statearr_33196_33280[(2)] = null);

(statearr_33196_33280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (39))){
var state_33185__$1 = state_33185;
var statearr_33200_33281 = state_33185__$1;
(statearr_33200_33281[(2)] = null);

(statearr_33200_33281[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (4))){
var inst_33053 = (state_33185[(12)]);
var inst_33053__$1 = (state_33185[(2)]);
var inst_33054 = (inst_33053__$1 == null);
var state_33185__$1 = (function (){var statearr_33201 = state_33185;
(statearr_33201[(12)] = inst_33053__$1);

return statearr_33201;
})();
if(cljs.core.truth_(inst_33054)){
var statearr_33202_33282 = state_33185__$1;
(statearr_33202_33282[(1)] = (5));

} else {
var statearr_33203_33283 = state_33185__$1;
(statearr_33203_33283[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (15))){
var inst_33065 = (state_33185[(13)]);
var inst_33063 = (state_33185[(14)]);
var inst_33064 = (state_33185[(16)]);
var inst_33062 = (state_33185[(17)]);
var inst_33080 = (state_33185[(2)]);
var inst_33081 = (inst_33065 + (1));
var tmp33197 = inst_33063;
var tmp33198 = inst_33064;
var tmp33199 = inst_33062;
var inst_33062__$1 = tmp33199;
var inst_33063__$1 = tmp33197;
var inst_33064__$1 = tmp33198;
var inst_33065__$1 = inst_33081;
var state_33185__$1 = (function (){var statearr_33204 = state_33185;
(statearr_33204[(13)] = inst_33065__$1);

(statearr_33204[(14)] = inst_33063__$1);

(statearr_33204[(16)] = inst_33064__$1);

(statearr_33204[(18)] = inst_33080);

(statearr_33204[(17)] = inst_33062__$1);

return statearr_33204;
})();
var statearr_33205_33284 = state_33185__$1;
(statearr_33205_33284[(2)] = null);

(statearr_33205_33284[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (21))){
var inst_33107 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
var statearr_33209_33285 = state_33185__$1;
(statearr_33209_33285[(2)] = inst_33107);

(statearr_33209_33285[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (31))){
var inst_33133 = (state_33185[(10)]);
var inst_33137 = done.call(null,null);
var inst_33138 = cljs.core.async.untap_STAR_.call(null,m,inst_33133);
var state_33185__$1 = (function (){var statearr_33210 = state_33185;
(statearr_33210[(19)] = inst_33137);

return statearr_33210;
})();
var statearr_33211_33286 = state_33185__$1;
(statearr_33211_33286[(2)] = inst_33138);

(statearr_33211_33286[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (32))){
var inst_33128 = (state_33185[(9)]);
var inst_33126 = (state_33185[(11)]);
var inst_33125 = (state_33185[(20)]);
var inst_33127 = (state_33185[(21)]);
var inst_33140 = (state_33185[(2)]);
var inst_33141 = (inst_33128 + (1));
var tmp33206 = inst_33126;
var tmp33207 = inst_33125;
var tmp33208 = inst_33127;
var inst_33125__$1 = tmp33207;
var inst_33126__$1 = tmp33206;
var inst_33127__$1 = tmp33208;
var inst_33128__$1 = inst_33141;
var state_33185__$1 = (function (){var statearr_33212 = state_33185;
(statearr_33212[(9)] = inst_33128__$1);

(statearr_33212[(22)] = inst_33140);

(statearr_33212[(11)] = inst_33126__$1);

(statearr_33212[(20)] = inst_33125__$1);

(statearr_33212[(21)] = inst_33127__$1);

return statearr_33212;
})();
var statearr_33213_33287 = state_33185__$1;
(statearr_33213_33287[(2)] = null);

(statearr_33213_33287[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (40))){
var inst_33153 = (state_33185[(23)]);
var inst_33157 = done.call(null,null);
var inst_33158 = cljs.core.async.untap_STAR_.call(null,m,inst_33153);
var state_33185__$1 = (function (){var statearr_33214 = state_33185;
(statearr_33214[(24)] = inst_33157);

return statearr_33214;
})();
var statearr_33215_33288 = state_33185__$1;
(statearr_33215_33288[(2)] = inst_33158);

(statearr_33215_33288[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (33))){
var inst_33144 = (state_33185[(25)]);
var inst_33146 = cljs.core.chunked_seq_QMARK_.call(null,inst_33144);
var state_33185__$1 = state_33185;
if(inst_33146){
var statearr_33216_33289 = state_33185__$1;
(statearr_33216_33289[(1)] = (36));

} else {
var statearr_33217_33290 = state_33185__$1;
(statearr_33217_33290[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (13))){
var inst_33074 = (state_33185[(26)]);
var inst_33077 = cljs.core.async.close_BANG_.call(null,inst_33074);
var state_33185__$1 = state_33185;
var statearr_33218_33291 = state_33185__$1;
(statearr_33218_33291[(2)] = inst_33077);

(statearr_33218_33291[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (22))){
var inst_33097 = (state_33185[(8)]);
var inst_33100 = cljs.core.async.close_BANG_.call(null,inst_33097);
var state_33185__$1 = state_33185;
var statearr_33219_33292 = state_33185__$1;
(statearr_33219_33292[(2)] = inst_33100);

(statearr_33219_33292[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (36))){
var inst_33144 = (state_33185[(25)]);
var inst_33148 = cljs.core.chunk_first.call(null,inst_33144);
var inst_33149 = cljs.core.chunk_rest.call(null,inst_33144);
var inst_33150 = cljs.core.count.call(null,inst_33148);
var inst_33125 = inst_33149;
var inst_33126 = inst_33148;
var inst_33127 = inst_33150;
var inst_33128 = (0);
var state_33185__$1 = (function (){var statearr_33220 = state_33185;
(statearr_33220[(9)] = inst_33128);

(statearr_33220[(11)] = inst_33126);

(statearr_33220[(20)] = inst_33125);

(statearr_33220[(21)] = inst_33127);

return statearr_33220;
})();
var statearr_33221_33293 = state_33185__$1;
(statearr_33221_33293[(2)] = null);

(statearr_33221_33293[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (41))){
var inst_33144 = (state_33185[(25)]);
var inst_33160 = (state_33185[(2)]);
var inst_33161 = cljs.core.next.call(null,inst_33144);
var inst_33125 = inst_33161;
var inst_33126 = null;
var inst_33127 = (0);
var inst_33128 = (0);
var state_33185__$1 = (function (){var statearr_33222 = state_33185;
(statearr_33222[(9)] = inst_33128);

(statearr_33222[(11)] = inst_33126);

(statearr_33222[(20)] = inst_33125);

(statearr_33222[(27)] = inst_33160);

(statearr_33222[(21)] = inst_33127);

return statearr_33222;
})();
var statearr_33223_33294 = state_33185__$1;
(statearr_33223_33294[(2)] = null);

(statearr_33223_33294[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (43))){
var state_33185__$1 = state_33185;
var statearr_33224_33295 = state_33185__$1;
(statearr_33224_33295[(2)] = null);

(statearr_33224_33295[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (29))){
var inst_33169 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
var statearr_33225_33296 = state_33185__$1;
(statearr_33225_33296[(2)] = inst_33169);

(statearr_33225_33296[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (44))){
var inst_33178 = (state_33185[(2)]);
var state_33185__$1 = (function (){var statearr_33226 = state_33185;
(statearr_33226[(28)] = inst_33178);

return statearr_33226;
})();
var statearr_33227_33297 = state_33185__$1;
(statearr_33227_33297[(2)] = null);

(statearr_33227_33297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (6))){
var inst_33117 = (state_33185[(29)]);
var inst_33116 = cljs.core.deref.call(null,cs);
var inst_33117__$1 = cljs.core.keys.call(null,inst_33116);
var inst_33118 = cljs.core.count.call(null,inst_33117__$1);
var inst_33119 = cljs.core.reset_BANG_.call(null,dctr,inst_33118);
var inst_33124 = cljs.core.seq.call(null,inst_33117__$1);
var inst_33125 = inst_33124;
var inst_33126 = null;
var inst_33127 = (0);
var inst_33128 = (0);
var state_33185__$1 = (function (){var statearr_33228 = state_33185;
(statearr_33228[(29)] = inst_33117__$1);

(statearr_33228[(30)] = inst_33119);

(statearr_33228[(9)] = inst_33128);

(statearr_33228[(11)] = inst_33126);

(statearr_33228[(20)] = inst_33125);

(statearr_33228[(21)] = inst_33127);

return statearr_33228;
})();
var statearr_33229_33298 = state_33185__$1;
(statearr_33229_33298[(2)] = null);

(statearr_33229_33298[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (28))){
var inst_33144 = (state_33185[(25)]);
var inst_33125 = (state_33185[(20)]);
var inst_33144__$1 = cljs.core.seq.call(null,inst_33125);
var state_33185__$1 = (function (){var statearr_33230 = state_33185;
(statearr_33230[(25)] = inst_33144__$1);

return statearr_33230;
})();
if(inst_33144__$1){
var statearr_33231_33299 = state_33185__$1;
(statearr_33231_33299[(1)] = (33));

} else {
var statearr_33232_33300 = state_33185__$1;
(statearr_33232_33300[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (25))){
var inst_33128 = (state_33185[(9)]);
var inst_33127 = (state_33185[(21)]);
var inst_33130 = (inst_33128 < inst_33127);
var inst_33131 = inst_33130;
var state_33185__$1 = state_33185;
if(cljs.core.truth_(inst_33131)){
var statearr_33233_33301 = state_33185__$1;
(statearr_33233_33301[(1)] = (27));

} else {
var statearr_33234_33302 = state_33185__$1;
(statearr_33234_33302[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (34))){
var state_33185__$1 = state_33185;
var statearr_33235_33303 = state_33185__$1;
(statearr_33235_33303[(2)] = null);

(statearr_33235_33303[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (17))){
var state_33185__$1 = state_33185;
var statearr_33236_33304 = state_33185__$1;
(statearr_33236_33304[(2)] = null);

(statearr_33236_33304[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (3))){
var inst_33183 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33185__$1,inst_33183);
} else {
if((state_val_33186 === (12))){
var inst_33112 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
var statearr_33237_33305 = state_33185__$1;
(statearr_33237_33305[(2)] = inst_33112);

(statearr_33237_33305[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (2))){
var state_33185__$1 = state_33185;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33185__$1,(4),ch);
} else {
if((state_val_33186 === (23))){
var state_33185__$1 = state_33185;
var statearr_33238_33306 = state_33185__$1;
(statearr_33238_33306[(2)] = null);

(statearr_33238_33306[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (35))){
var inst_33167 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
var statearr_33239_33307 = state_33185__$1;
(statearr_33239_33307[(2)] = inst_33167);

(statearr_33239_33307[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (19))){
var inst_33084 = (state_33185[(7)]);
var inst_33088 = cljs.core.chunk_first.call(null,inst_33084);
var inst_33089 = cljs.core.chunk_rest.call(null,inst_33084);
var inst_33090 = cljs.core.count.call(null,inst_33088);
var inst_33062 = inst_33089;
var inst_33063 = inst_33088;
var inst_33064 = inst_33090;
var inst_33065 = (0);
var state_33185__$1 = (function (){var statearr_33240 = state_33185;
(statearr_33240[(13)] = inst_33065);

(statearr_33240[(14)] = inst_33063);

(statearr_33240[(16)] = inst_33064);

(statearr_33240[(17)] = inst_33062);

return statearr_33240;
})();
var statearr_33241_33308 = state_33185__$1;
(statearr_33241_33308[(2)] = null);

(statearr_33241_33308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (11))){
var inst_33084 = (state_33185[(7)]);
var inst_33062 = (state_33185[(17)]);
var inst_33084__$1 = cljs.core.seq.call(null,inst_33062);
var state_33185__$1 = (function (){var statearr_33242 = state_33185;
(statearr_33242[(7)] = inst_33084__$1);

return statearr_33242;
})();
if(inst_33084__$1){
var statearr_33243_33309 = state_33185__$1;
(statearr_33243_33309[(1)] = (16));

} else {
var statearr_33244_33310 = state_33185__$1;
(statearr_33244_33310[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (9))){
var inst_33114 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
var statearr_33245_33311 = state_33185__$1;
(statearr_33245_33311[(2)] = inst_33114);

(statearr_33245_33311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (5))){
var inst_33060 = cljs.core.deref.call(null,cs);
var inst_33061 = cljs.core.seq.call(null,inst_33060);
var inst_33062 = inst_33061;
var inst_33063 = null;
var inst_33064 = (0);
var inst_33065 = (0);
var state_33185__$1 = (function (){var statearr_33246 = state_33185;
(statearr_33246[(13)] = inst_33065);

(statearr_33246[(14)] = inst_33063);

(statearr_33246[(16)] = inst_33064);

(statearr_33246[(17)] = inst_33062);

return statearr_33246;
})();
var statearr_33247_33312 = state_33185__$1;
(statearr_33247_33312[(2)] = null);

(statearr_33247_33312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (14))){
var state_33185__$1 = state_33185;
var statearr_33248_33313 = state_33185__$1;
(statearr_33248_33313[(2)] = null);

(statearr_33248_33313[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (45))){
var inst_33175 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
var statearr_33249_33314 = state_33185__$1;
(statearr_33249_33314[(2)] = inst_33175);

(statearr_33249_33314[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (26))){
var inst_33117 = (state_33185[(29)]);
var inst_33171 = (state_33185[(2)]);
var inst_33172 = cljs.core.seq.call(null,inst_33117);
var state_33185__$1 = (function (){var statearr_33250 = state_33185;
(statearr_33250[(31)] = inst_33171);

return statearr_33250;
})();
if(inst_33172){
var statearr_33251_33315 = state_33185__$1;
(statearr_33251_33315[(1)] = (42));

} else {
var statearr_33252_33316 = state_33185__$1;
(statearr_33252_33316[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (16))){
var inst_33084 = (state_33185[(7)]);
var inst_33086 = cljs.core.chunked_seq_QMARK_.call(null,inst_33084);
var state_33185__$1 = state_33185;
if(inst_33086){
var statearr_33253_33317 = state_33185__$1;
(statearr_33253_33317[(1)] = (19));

} else {
var statearr_33254_33318 = state_33185__$1;
(statearr_33254_33318[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (38))){
var inst_33164 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
var statearr_33255_33319 = state_33185__$1;
(statearr_33255_33319[(2)] = inst_33164);

(statearr_33255_33319[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (30))){
var state_33185__$1 = state_33185;
var statearr_33256_33320 = state_33185__$1;
(statearr_33256_33320[(2)] = null);

(statearr_33256_33320[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (10))){
var inst_33065 = (state_33185[(13)]);
var inst_33063 = (state_33185[(14)]);
var inst_33073 = cljs.core._nth.call(null,inst_33063,inst_33065);
var inst_33074 = cljs.core.nth.call(null,inst_33073,(0),null);
var inst_33075 = cljs.core.nth.call(null,inst_33073,(1),null);
var state_33185__$1 = (function (){var statearr_33257 = state_33185;
(statearr_33257[(26)] = inst_33074);

return statearr_33257;
})();
if(cljs.core.truth_(inst_33075)){
var statearr_33258_33321 = state_33185__$1;
(statearr_33258_33321[(1)] = (13));

} else {
var statearr_33259_33322 = state_33185__$1;
(statearr_33259_33322[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (18))){
var inst_33110 = (state_33185[(2)]);
var state_33185__$1 = state_33185;
var statearr_33260_33323 = state_33185__$1;
(statearr_33260_33323[(2)] = inst_33110);

(statearr_33260_33323[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (42))){
var state_33185__$1 = state_33185;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33185__$1,(45),dchan);
} else {
if((state_val_33186 === (37))){
var inst_33144 = (state_33185[(25)]);
var inst_33153 = (state_33185[(23)]);
var inst_33053 = (state_33185[(12)]);
var inst_33153__$1 = cljs.core.first.call(null,inst_33144);
var inst_33154 = cljs.core.async.put_BANG_.call(null,inst_33153__$1,inst_33053,done);
var state_33185__$1 = (function (){var statearr_33261 = state_33185;
(statearr_33261[(23)] = inst_33153__$1);

return statearr_33261;
})();
if(cljs.core.truth_(inst_33154)){
var statearr_33262_33324 = state_33185__$1;
(statearr_33262_33324[(1)] = (39));

} else {
var statearr_33263_33325 = state_33185__$1;
(statearr_33263_33325[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33186 === (8))){
var inst_33065 = (state_33185[(13)]);
var inst_33064 = (state_33185[(16)]);
var inst_33067 = (inst_33065 < inst_33064);
var inst_33068 = inst_33067;
var state_33185__$1 = state_33185;
if(cljs.core.truth_(inst_33068)){
var statearr_33264_33326 = state_33185__$1;
(statearr_33264_33326[(1)] = (10));

} else {
var statearr_33265_33327 = state_33185__$1;
(statearr_33265_33327[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___33273,cs,m,dchan,dctr,done))
;
return ((function (switch__31792__auto__,c__31906__auto___33273,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__31793__auto__ = null;
var cljs$core$async$mult_$_state_machine__31793__auto____0 = (function (){
var statearr_33269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33269[(0)] = cljs$core$async$mult_$_state_machine__31793__auto__);

(statearr_33269[(1)] = (1));

return statearr_33269;
});
var cljs$core$async$mult_$_state_machine__31793__auto____1 = (function (state_33185){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_33185);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e33270){if((e33270 instanceof Object)){
var ex__31796__auto__ = e33270;
var statearr_33271_33328 = state_33185;
(statearr_33271_33328[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33185);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33329 = state_33185;
state_33185 = G__33329;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__31793__auto__ = function(state_33185){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__31793__auto____1.call(this,state_33185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__31793__auto____0;
cljs$core$async$mult_$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__31793__auto____1;
return cljs$core$async$mult_$_state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___33273,cs,m,dchan,dctr,done))
})();
var state__31908__auto__ = (function (){var statearr_33272 = f__31907__auto__.call(null);
(statearr_33272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___33273);

return statearr_33272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___33273,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args33330 = [];
var len__28114__auto___33333 = arguments.length;
var i__28115__auto___33334 = (0);
while(true){
if((i__28115__auto___33334 < len__28114__auto___33333)){
args33330.push((arguments[i__28115__auto___33334]));

var G__33335 = (i__28115__auto___33334 + (1));
i__28115__auto___33334 = G__33335;
continue;
} else {
}
break;
}

var G__33332 = args33330.length;
switch (G__33332) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33330.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,ch);
} else {
var m__27612__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,ch);
} else {
var m__27612__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m);
} else {
var m__27612__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,state_map);
} else {
var m__27612__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,mode);
} else {
var m__27612__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__28121__auto__ = [];
var len__28114__auto___33347 = arguments.length;
var i__28115__auto___33348 = (0);
while(true){
if((i__28115__auto___33348 < len__28114__auto___33347)){
args__28121__auto__.push((arguments[i__28115__auto___33348]));

var G__33349 = (i__28115__auto___33348 + (1));
i__28115__auto___33348 = G__33349;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((3) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__28122__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__33341){
var map__33342 = p__33341;
var map__33342__$1 = ((((!((map__33342 == null)))?((((map__33342.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33342.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33342):map__33342);
var opts = map__33342__$1;
var statearr_33344_33350 = state;
(statearr_33344_33350[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6747__auto__ = cljs.core.async.do_alts.call(null,((function (map__33342,map__33342__$1,opts){
return (function (val){
var statearr_33345_33351 = state;
(statearr_33345_33351[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__33342,map__33342__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6747__auto__)){
var cb = temp__6747__auto__;
var statearr_33346_33352 = state;
(statearr_33346_33352[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq33337){
var G__33338 = cljs.core.first.call(null,seq33337);
var seq33337__$1 = cljs.core.next.call(null,seq33337);
var G__33339 = cljs.core.first.call(null,seq33337__$1);
var seq33337__$2 = cljs.core.next.call(null,seq33337__$1);
var G__33340 = cljs.core.first.call(null,seq33337__$2);
var seq33337__$3 = cljs.core.next.call(null,seq33337__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33338,G__33339,G__33340,seq33337__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33520 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33520 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta33521){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta33521 = meta33521;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33522,meta33521__$1){
var self__ = this;
var _33522__$1 = this;
return (new cljs.core.async.t_cljs$core$async33520(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta33521__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33522){
var self__ = this;
var _33522__$1 = this;
return self__.meta33521;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33520.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta33521","meta33521",924038588,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33520.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33520.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33520";

cljs.core.async.t_cljs$core$async33520.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async33520");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async33520 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async33520(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33521){
return (new cljs.core.async.t_cljs$core$async33520(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33521));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async33520(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31906__auto___33687 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___33687,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___33687,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33624){
var state_val_33625 = (state_33624[(1)]);
if((state_val_33625 === (7))){
var inst_33539 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
var statearr_33626_33688 = state_33624__$1;
(statearr_33626_33688[(2)] = inst_33539);

(statearr_33626_33688[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (20))){
var inst_33551 = (state_33624[(7)]);
var state_33624__$1 = state_33624;
var statearr_33627_33689 = state_33624__$1;
(statearr_33627_33689[(2)] = inst_33551);

(statearr_33627_33689[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (27))){
var state_33624__$1 = state_33624;
var statearr_33628_33690 = state_33624__$1;
(statearr_33628_33690[(2)] = null);

(statearr_33628_33690[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (1))){
var inst_33526 = (state_33624[(8)]);
var inst_33526__$1 = calc_state.call(null);
var inst_33528 = (inst_33526__$1 == null);
var inst_33529 = cljs.core.not.call(null,inst_33528);
var state_33624__$1 = (function (){var statearr_33629 = state_33624;
(statearr_33629[(8)] = inst_33526__$1);

return statearr_33629;
})();
if(inst_33529){
var statearr_33630_33691 = state_33624__$1;
(statearr_33630_33691[(1)] = (2));

} else {
var statearr_33631_33692 = state_33624__$1;
(statearr_33631_33692[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (24))){
var inst_33584 = (state_33624[(9)]);
var inst_33575 = (state_33624[(10)]);
var inst_33598 = (state_33624[(11)]);
var inst_33598__$1 = inst_33575.call(null,inst_33584);
var state_33624__$1 = (function (){var statearr_33632 = state_33624;
(statearr_33632[(11)] = inst_33598__$1);

return statearr_33632;
})();
if(cljs.core.truth_(inst_33598__$1)){
var statearr_33633_33693 = state_33624__$1;
(statearr_33633_33693[(1)] = (29));

} else {
var statearr_33634_33694 = state_33624__$1;
(statearr_33634_33694[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (4))){
var inst_33542 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
if(cljs.core.truth_(inst_33542)){
var statearr_33635_33695 = state_33624__$1;
(statearr_33635_33695[(1)] = (8));

} else {
var statearr_33636_33696 = state_33624__$1;
(statearr_33636_33696[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (15))){
var inst_33569 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
if(cljs.core.truth_(inst_33569)){
var statearr_33637_33697 = state_33624__$1;
(statearr_33637_33697[(1)] = (19));

} else {
var statearr_33638_33698 = state_33624__$1;
(statearr_33638_33698[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (21))){
var inst_33574 = (state_33624[(12)]);
var inst_33574__$1 = (state_33624[(2)]);
var inst_33575 = cljs.core.get.call(null,inst_33574__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_33576 = cljs.core.get.call(null,inst_33574__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_33577 = cljs.core.get.call(null,inst_33574__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_33624__$1 = (function (){var statearr_33639 = state_33624;
(statearr_33639[(12)] = inst_33574__$1);

(statearr_33639[(10)] = inst_33575);

(statearr_33639[(13)] = inst_33576);

return statearr_33639;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_33624__$1,(22),inst_33577);
} else {
if((state_val_33625 === (31))){
var inst_33606 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
if(cljs.core.truth_(inst_33606)){
var statearr_33640_33699 = state_33624__$1;
(statearr_33640_33699[(1)] = (32));

} else {
var statearr_33641_33700 = state_33624__$1;
(statearr_33641_33700[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (32))){
var inst_33583 = (state_33624[(14)]);
var state_33624__$1 = state_33624;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33624__$1,(35),out,inst_33583);
} else {
if((state_val_33625 === (33))){
var inst_33574 = (state_33624[(12)]);
var inst_33551 = inst_33574;
var state_33624__$1 = (function (){var statearr_33642 = state_33624;
(statearr_33642[(7)] = inst_33551);

return statearr_33642;
})();
var statearr_33643_33701 = state_33624__$1;
(statearr_33643_33701[(2)] = null);

(statearr_33643_33701[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (13))){
var inst_33551 = (state_33624[(7)]);
var inst_33558 = inst_33551.cljs$lang$protocol_mask$partition0$;
var inst_33559 = (inst_33558 & (64));
var inst_33560 = inst_33551.cljs$core$ISeq$;
var inst_33561 = (cljs.core.PROTOCOL_SENTINEL === inst_33560);
var inst_33562 = (inst_33559) || (inst_33561);
var state_33624__$1 = state_33624;
if(cljs.core.truth_(inst_33562)){
var statearr_33644_33702 = state_33624__$1;
(statearr_33644_33702[(1)] = (16));

} else {
var statearr_33645_33703 = state_33624__$1;
(statearr_33645_33703[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (22))){
var inst_33583 = (state_33624[(14)]);
var inst_33584 = (state_33624[(9)]);
var inst_33582 = (state_33624[(2)]);
var inst_33583__$1 = cljs.core.nth.call(null,inst_33582,(0),null);
var inst_33584__$1 = cljs.core.nth.call(null,inst_33582,(1),null);
var inst_33585 = (inst_33583__$1 == null);
var inst_33586 = cljs.core._EQ_.call(null,inst_33584__$1,change);
var inst_33587 = (inst_33585) || (inst_33586);
var state_33624__$1 = (function (){var statearr_33646 = state_33624;
(statearr_33646[(14)] = inst_33583__$1);

(statearr_33646[(9)] = inst_33584__$1);

return statearr_33646;
})();
if(cljs.core.truth_(inst_33587)){
var statearr_33647_33704 = state_33624__$1;
(statearr_33647_33704[(1)] = (23));

} else {
var statearr_33648_33705 = state_33624__$1;
(statearr_33648_33705[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (36))){
var inst_33574 = (state_33624[(12)]);
var inst_33551 = inst_33574;
var state_33624__$1 = (function (){var statearr_33649 = state_33624;
(statearr_33649[(7)] = inst_33551);

return statearr_33649;
})();
var statearr_33650_33706 = state_33624__$1;
(statearr_33650_33706[(2)] = null);

(statearr_33650_33706[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (29))){
var inst_33598 = (state_33624[(11)]);
var state_33624__$1 = state_33624;
var statearr_33651_33707 = state_33624__$1;
(statearr_33651_33707[(2)] = inst_33598);

(statearr_33651_33707[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (6))){
var state_33624__$1 = state_33624;
var statearr_33652_33708 = state_33624__$1;
(statearr_33652_33708[(2)] = false);

(statearr_33652_33708[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (28))){
var inst_33594 = (state_33624[(2)]);
var inst_33595 = calc_state.call(null);
var inst_33551 = inst_33595;
var state_33624__$1 = (function (){var statearr_33653 = state_33624;
(statearr_33653[(7)] = inst_33551);

(statearr_33653[(15)] = inst_33594);

return statearr_33653;
})();
var statearr_33654_33709 = state_33624__$1;
(statearr_33654_33709[(2)] = null);

(statearr_33654_33709[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (25))){
var inst_33620 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
var statearr_33655_33710 = state_33624__$1;
(statearr_33655_33710[(2)] = inst_33620);

(statearr_33655_33710[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (34))){
var inst_33618 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
var statearr_33656_33711 = state_33624__$1;
(statearr_33656_33711[(2)] = inst_33618);

(statearr_33656_33711[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (17))){
var state_33624__$1 = state_33624;
var statearr_33657_33712 = state_33624__$1;
(statearr_33657_33712[(2)] = false);

(statearr_33657_33712[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (3))){
var state_33624__$1 = state_33624;
var statearr_33658_33713 = state_33624__$1;
(statearr_33658_33713[(2)] = false);

(statearr_33658_33713[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (12))){
var inst_33622 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33624__$1,inst_33622);
} else {
if((state_val_33625 === (2))){
var inst_33526 = (state_33624[(8)]);
var inst_33531 = inst_33526.cljs$lang$protocol_mask$partition0$;
var inst_33532 = (inst_33531 & (64));
var inst_33533 = inst_33526.cljs$core$ISeq$;
var inst_33534 = (cljs.core.PROTOCOL_SENTINEL === inst_33533);
var inst_33535 = (inst_33532) || (inst_33534);
var state_33624__$1 = state_33624;
if(cljs.core.truth_(inst_33535)){
var statearr_33659_33714 = state_33624__$1;
(statearr_33659_33714[(1)] = (5));

} else {
var statearr_33660_33715 = state_33624__$1;
(statearr_33660_33715[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (23))){
var inst_33583 = (state_33624[(14)]);
var inst_33589 = (inst_33583 == null);
var state_33624__$1 = state_33624;
if(cljs.core.truth_(inst_33589)){
var statearr_33661_33716 = state_33624__$1;
(statearr_33661_33716[(1)] = (26));

} else {
var statearr_33662_33717 = state_33624__$1;
(statearr_33662_33717[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (35))){
var inst_33609 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
if(cljs.core.truth_(inst_33609)){
var statearr_33663_33718 = state_33624__$1;
(statearr_33663_33718[(1)] = (36));

} else {
var statearr_33664_33719 = state_33624__$1;
(statearr_33664_33719[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (19))){
var inst_33551 = (state_33624[(7)]);
var inst_33571 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33551);
var state_33624__$1 = state_33624;
var statearr_33665_33720 = state_33624__$1;
(statearr_33665_33720[(2)] = inst_33571);

(statearr_33665_33720[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (11))){
var inst_33551 = (state_33624[(7)]);
var inst_33555 = (inst_33551 == null);
var inst_33556 = cljs.core.not.call(null,inst_33555);
var state_33624__$1 = state_33624;
if(inst_33556){
var statearr_33666_33721 = state_33624__$1;
(statearr_33666_33721[(1)] = (13));

} else {
var statearr_33667_33722 = state_33624__$1;
(statearr_33667_33722[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (9))){
var inst_33526 = (state_33624[(8)]);
var state_33624__$1 = state_33624;
var statearr_33668_33723 = state_33624__$1;
(statearr_33668_33723[(2)] = inst_33526);

(statearr_33668_33723[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (5))){
var state_33624__$1 = state_33624;
var statearr_33669_33724 = state_33624__$1;
(statearr_33669_33724[(2)] = true);

(statearr_33669_33724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (14))){
var state_33624__$1 = state_33624;
var statearr_33670_33725 = state_33624__$1;
(statearr_33670_33725[(2)] = false);

(statearr_33670_33725[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (26))){
var inst_33584 = (state_33624[(9)]);
var inst_33591 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_33584);
var state_33624__$1 = state_33624;
var statearr_33671_33726 = state_33624__$1;
(statearr_33671_33726[(2)] = inst_33591);

(statearr_33671_33726[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (16))){
var state_33624__$1 = state_33624;
var statearr_33672_33727 = state_33624__$1;
(statearr_33672_33727[(2)] = true);

(statearr_33672_33727[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (38))){
var inst_33614 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
var statearr_33673_33728 = state_33624__$1;
(statearr_33673_33728[(2)] = inst_33614);

(statearr_33673_33728[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (30))){
var inst_33584 = (state_33624[(9)]);
var inst_33575 = (state_33624[(10)]);
var inst_33576 = (state_33624[(13)]);
var inst_33601 = cljs.core.empty_QMARK_.call(null,inst_33575);
var inst_33602 = inst_33576.call(null,inst_33584);
var inst_33603 = cljs.core.not.call(null,inst_33602);
var inst_33604 = (inst_33601) && (inst_33603);
var state_33624__$1 = state_33624;
var statearr_33674_33729 = state_33624__$1;
(statearr_33674_33729[(2)] = inst_33604);

(statearr_33674_33729[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (10))){
var inst_33526 = (state_33624[(8)]);
var inst_33547 = (state_33624[(2)]);
var inst_33548 = cljs.core.get.call(null,inst_33547,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_33549 = cljs.core.get.call(null,inst_33547,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_33550 = cljs.core.get.call(null,inst_33547,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_33551 = inst_33526;
var state_33624__$1 = (function (){var statearr_33675 = state_33624;
(statearr_33675[(16)] = inst_33548);

(statearr_33675[(17)] = inst_33549);

(statearr_33675[(7)] = inst_33551);

(statearr_33675[(18)] = inst_33550);

return statearr_33675;
})();
var statearr_33676_33730 = state_33624__$1;
(statearr_33676_33730[(2)] = null);

(statearr_33676_33730[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (18))){
var inst_33566 = (state_33624[(2)]);
var state_33624__$1 = state_33624;
var statearr_33677_33731 = state_33624__$1;
(statearr_33677_33731[(2)] = inst_33566);

(statearr_33677_33731[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (37))){
var state_33624__$1 = state_33624;
var statearr_33678_33732 = state_33624__$1;
(statearr_33678_33732[(2)] = null);

(statearr_33678_33732[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33625 === (8))){
var inst_33526 = (state_33624[(8)]);
var inst_33544 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33526);
var state_33624__$1 = state_33624;
var statearr_33679_33733 = state_33624__$1;
(statearr_33679_33733[(2)] = inst_33544);

(statearr_33679_33733[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___33687,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__31792__auto__,c__31906__auto___33687,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__31793__auto__ = null;
var cljs$core$async$mix_$_state_machine__31793__auto____0 = (function (){
var statearr_33683 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33683[(0)] = cljs$core$async$mix_$_state_machine__31793__auto__);

(statearr_33683[(1)] = (1));

return statearr_33683;
});
var cljs$core$async$mix_$_state_machine__31793__auto____1 = (function (state_33624){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_33624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e33684){if((e33684 instanceof Object)){
var ex__31796__auto__ = e33684;
var statearr_33685_33734 = state_33624;
(statearr_33685_33734[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33624);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33684;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33735 = state_33624;
state_33624 = G__33735;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__31793__auto__ = function(state_33624){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__31793__auto____1.call(this,state_33624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__31793__auto____0;
cljs$core$async$mix_$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__31793__auto____1;
return cljs$core$async$mix_$_state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___33687,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__31908__auto__ = (function (){var statearr_33686 = f__31907__auto__.call(null);
(statearr_33686[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___33687);

return statearr_33686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___33687,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27611__auto__ = (((p == null))?null:p);
var m__27612__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27612__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27611__auto__ = (((p == null))?null:p);
var m__27612__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,p,v,ch);
} else {
var m__27612__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args33736 = [];
var len__28114__auto___33739 = arguments.length;
var i__28115__auto___33740 = (0);
while(true){
if((i__28115__auto___33740 < len__28114__auto___33739)){
args33736.push((arguments[i__28115__auto___33740]));

var G__33741 = (i__28115__auto___33740 + (1));
i__28115__auto___33740 = G__33741;
continue;
} else {
}
break;
}

var G__33738 = args33736.length;
switch (G__33738) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33736.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27611__auto__ = (((p == null))?null:p);
var m__27612__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,p);
} else {
var m__27612__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27611__auto__ = (((p == null))?null:p);
var m__27612__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,p,v);
} else {
var m__27612__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args33744 = [];
var len__28114__auto___33869 = arguments.length;
var i__28115__auto___33870 = (0);
while(true){
if((i__28115__auto___33870 < len__28114__auto___33869)){
args33744.push((arguments[i__28115__auto___33870]));

var G__33871 = (i__28115__auto___33870 + (1));
i__28115__auto___33870 = G__33871;
continue;
} else {
}
break;
}

var G__33746 = args33744.length;
switch (G__33746) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33744.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__26898__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__26898__auto__,mults){
return (function (p1__33743_SHARP_){
if(cljs.core.truth_(p1__33743_SHARP_.call(null,topic))){
return p1__33743_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__33743_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__26898__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async33747 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33747 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33748){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33748 = meta33748;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33747.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33749,meta33748__$1){
var self__ = this;
var _33749__$1 = this;
return (new cljs.core.async.t_cljs$core$async33747(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33748__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33747.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33749){
var self__ = this;
var _33749__$1 = this;
return self__.meta33748;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33747.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33747.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33747.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33747.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33747.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6747__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6747__auto__)){
var m = temp__6747__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33747.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33747.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33747.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta33748","meta33748",-2049632537,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33747.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33747.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33747";

cljs.core.async.t_cljs$core$async33747.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async33747");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async33747 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async33747(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33748){
return (new cljs.core.async.t_cljs$core$async33747(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33748));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async33747(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31906__auto___33873 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___33873,mults,ensure_mult,p){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___33873,mults,ensure_mult,p){
return (function (state_33821){
var state_val_33822 = (state_33821[(1)]);
if((state_val_33822 === (7))){
var inst_33817 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
var statearr_33823_33874 = state_33821__$1;
(statearr_33823_33874[(2)] = inst_33817);

(statearr_33823_33874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (20))){
var state_33821__$1 = state_33821;
var statearr_33824_33875 = state_33821__$1;
(statearr_33824_33875[(2)] = null);

(statearr_33824_33875[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (1))){
var state_33821__$1 = state_33821;
var statearr_33825_33876 = state_33821__$1;
(statearr_33825_33876[(2)] = null);

(statearr_33825_33876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (24))){
var inst_33800 = (state_33821[(7)]);
var inst_33809 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_33800);
var state_33821__$1 = state_33821;
var statearr_33826_33877 = state_33821__$1;
(statearr_33826_33877[(2)] = inst_33809);

(statearr_33826_33877[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (4))){
var inst_33752 = (state_33821[(8)]);
var inst_33752__$1 = (state_33821[(2)]);
var inst_33753 = (inst_33752__$1 == null);
var state_33821__$1 = (function (){var statearr_33827 = state_33821;
(statearr_33827[(8)] = inst_33752__$1);

return statearr_33827;
})();
if(cljs.core.truth_(inst_33753)){
var statearr_33828_33878 = state_33821__$1;
(statearr_33828_33878[(1)] = (5));

} else {
var statearr_33829_33879 = state_33821__$1;
(statearr_33829_33879[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (15))){
var inst_33794 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
var statearr_33830_33880 = state_33821__$1;
(statearr_33830_33880[(2)] = inst_33794);

(statearr_33830_33880[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (21))){
var inst_33814 = (state_33821[(2)]);
var state_33821__$1 = (function (){var statearr_33831 = state_33821;
(statearr_33831[(9)] = inst_33814);

return statearr_33831;
})();
var statearr_33832_33881 = state_33821__$1;
(statearr_33832_33881[(2)] = null);

(statearr_33832_33881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (13))){
var inst_33776 = (state_33821[(10)]);
var inst_33778 = cljs.core.chunked_seq_QMARK_.call(null,inst_33776);
var state_33821__$1 = state_33821;
if(inst_33778){
var statearr_33833_33882 = state_33821__$1;
(statearr_33833_33882[(1)] = (16));

} else {
var statearr_33834_33883 = state_33821__$1;
(statearr_33834_33883[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (22))){
var inst_33806 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
if(cljs.core.truth_(inst_33806)){
var statearr_33835_33884 = state_33821__$1;
(statearr_33835_33884[(1)] = (23));

} else {
var statearr_33836_33885 = state_33821__$1;
(statearr_33836_33885[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (6))){
var inst_33802 = (state_33821[(11)]);
var inst_33752 = (state_33821[(8)]);
var inst_33800 = (state_33821[(7)]);
var inst_33800__$1 = topic_fn.call(null,inst_33752);
var inst_33801 = cljs.core.deref.call(null,mults);
var inst_33802__$1 = cljs.core.get.call(null,inst_33801,inst_33800__$1);
var state_33821__$1 = (function (){var statearr_33837 = state_33821;
(statearr_33837[(11)] = inst_33802__$1);

(statearr_33837[(7)] = inst_33800__$1);

return statearr_33837;
})();
if(cljs.core.truth_(inst_33802__$1)){
var statearr_33838_33886 = state_33821__$1;
(statearr_33838_33886[(1)] = (19));

} else {
var statearr_33839_33887 = state_33821__$1;
(statearr_33839_33887[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (25))){
var inst_33811 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
var statearr_33840_33888 = state_33821__$1;
(statearr_33840_33888[(2)] = inst_33811);

(statearr_33840_33888[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (17))){
var inst_33776 = (state_33821[(10)]);
var inst_33785 = cljs.core.first.call(null,inst_33776);
var inst_33786 = cljs.core.async.muxch_STAR_.call(null,inst_33785);
var inst_33787 = cljs.core.async.close_BANG_.call(null,inst_33786);
var inst_33788 = cljs.core.next.call(null,inst_33776);
var inst_33762 = inst_33788;
var inst_33763 = null;
var inst_33764 = (0);
var inst_33765 = (0);
var state_33821__$1 = (function (){var statearr_33841 = state_33821;
(statearr_33841[(12)] = inst_33763);

(statearr_33841[(13)] = inst_33762);

(statearr_33841[(14)] = inst_33765);

(statearr_33841[(15)] = inst_33764);

(statearr_33841[(16)] = inst_33787);

return statearr_33841;
})();
var statearr_33842_33889 = state_33821__$1;
(statearr_33842_33889[(2)] = null);

(statearr_33842_33889[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (3))){
var inst_33819 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33821__$1,inst_33819);
} else {
if((state_val_33822 === (12))){
var inst_33796 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
var statearr_33843_33890 = state_33821__$1;
(statearr_33843_33890[(2)] = inst_33796);

(statearr_33843_33890[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (2))){
var state_33821__$1 = state_33821;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33821__$1,(4),ch);
} else {
if((state_val_33822 === (23))){
var state_33821__$1 = state_33821;
var statearr_33844_33891 = state_33821__$1;
(statearr_33844_33891[(2)] = null);

(statearr_33844_33891[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (19))){
var inst_33802 = (state_33821[(11)]);
var inst_33752 = (state_33821[(8)]);
var inst_33804 = cljs.core.async.muxch_STAR_.call(null,inst_33802);
var state_33821__$1 = state_33821;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33821__$1,(22),inst_33804,inst_33752);
} else {
if((state_val_33822 === (11))){
var inst_33762 = (state_33821[(13)]);
var inst_33776 = (state_33821[(10)]);
var inst_33776__$1 = cljs.core.seq.call(null,inst_33762);
var state_33821__$1 = (function (){var statearr_33845 = state_33821;
(statearr_33845[(10)] = inst_33776__$1);

return statearr_33845;
})();
if(inst_33776__$1){
var statearr_33846_33892 = state_33821__$1;
(statearr_33846_33892[(1)] = (13));

} else {
var statearr_33847_33893 = state_33821__$1;
(statearr_33847_33893[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (9))){
var inst_33798 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
var statearr_33848_33894 = state_33821__$1;
(statearr_33848_33894[(2)] = inst_33798);

(statearr_33848_33894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (5))){
var inst_33759 = cljs.core.deref.call(null,mults);
var inst_33760 = cljs.core.vals.call(null,inst_33759);
var inst_33761 = cljs.core.seq.call(null,inst_33760);
var inst_33762 = inst_33761;
var inst_33763 = null;
var inst_33764 = (0);
var inst_33765 = (0);
var state_33821__$1 = (function (){var statearr_33849 = state_33821;
(statearr_33849[(12)] = inst_33763);

(statearr_33849[(13)] = inst_33762);

(statearr_33849[(14)] = inst_33765);

(statearr_33849[(15)] = inst_33764);

return statearr_33849;
})();
var statearr_33850_33895 = state_33821__$1;
(statearr_33850_33895[(2)] = null);

(statearr_33850_33895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (14))){
var state_33821__$1 = state_33821;
var statearr_33854_33896 = state_33821__$1;
(statearr_33854_33896[(2)] = null);

(statearr_33854_33896[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (16))){
var inst_33776 = (state_33821[(10)]);
var inst_33780 = cljs.core.chunk_first.call(null,inst_33776);
var inst_33781 = cljs.core.chunk_rest.call(null,inst_33776);
var inst_33782 = cljs.core.count.call(null,inst_33780);
var inst_33762 = inst_33781;
var inst_33763 = inst_33780;
var inst_33764 = inst_33782;
var inst_33765 = (0);
var state_33821__$1 = (function (){var statearr_33855 = state_33821;
(statearr_33855[(12)] = inst_33763);

(statearr_33855[(13)] = inst_33762);

(statearr_33855[(14)] = inst_33765);

(statearr_33855[(15)] = inst_33764);

return statearr_33855;
})();
var statearr_33856_33897 = state_33821__$1;
(statearr_33856_33897[(2)] = null);

(statearr_33856_33897[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (10))){
var inst_33763 = (state_33821[(12)]);
var inst_33762 = (state_33821[(13)]);
var inst_33765 = (state_33821[(14)]);
var inst_33764 = (state_33821[(15)]);
var inst_33770 = cljs.core._nth.call(null,inst_33763,inst_33765);
var inst_33771 = cljs.core.async.muxch_STAR_.call(null,inst_33770);
var inst_33772 = cljs.core.async.close_BANG_.call(null,inst_33771);
var inst_33773 = (inst_33765 + (1));
var tmp33851 = inst_33763;
var tmp33852 = inst_33762;
var tmp33853 = inst_33764;
var inst_33762__$1 = tmp33852;
var inst_33763__$1 = tmp33851;
var inst_33764__$1 = tmp33853;
var inst_33765__$1 = inst_33773;
var state_33821__$1 = (function (){var statearr_33857 = state_33821;
(statearr_33857[(12)] = inst_33763__$1);

(statearr_33857[(13)] = inst_33762__$1);

(statearr_33857[(17)] = inst_33772);

(statearr_33857[(14)] = inst_33765__$1);

(statearr_33857[(15)] = inst_33764__$1);

return statearr_33857;
})();
var statearr_33858_33898 = state_33821__$1;
(statearr_33858_33898[(2)] = null);

(statearr_33858_33898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (18))){
var inst_33791 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
var statearr_33859_33899 = state_33821__$1;
(statearr_33859_33899[(2)] = inst_33791);

(statearr_33859_33899[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (8))){
var inst_33765 = (state_33821[(14)]);
var inst_33764 = (state_33821[(15)]);
var inst_33767 = (inst_33765 < inst_33764);
var inst_33768 = inst_33767;
var state_33821__$1 = state_33821;
if(cljs.core.truth_(inst_33768)){
var statearr_33860_33900 = state_33821__$1;
(statearr_33860_33900[(1)] = (10));

} else {
var statearr_33861_33901 = state_33821__$1;
(statearr_33861_33901[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___33873,mults,ensure_mult,p))
;
return ((function (switch__31792__auto__,c__31906__auto___33873,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_33865 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33865[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_33865[(1)] = (1));

return statearr_33865;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_33821){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_33821);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e33866){if((e33866 instanceof Object)){
var ex__31796__auto__ = e33866;
var statearr_33867_33902 = state_33821;
(statearr_33867_33902[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33821);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33866;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33903 = state_33821;
state_33821 = G__33903;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_33821){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_33821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___33873,mults,ensure_mult,p))
})();
var state__31908__auto__ = (function (){var statearr_33868 = f__31907__auto__.call(null);
(statearr_33868[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___33873);

return statearr_33868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___33873,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args33904 = [];
var len__28114__auto___33907 = arguments.length;
var i__28115__auto___33908 = (0);
while(true){
if((i__28115__auto___33908 < len__28114__auto___33907)){
args33904.push((arguments[i__28115__auto___33908]));

var G__33909 = (i__28115__auto___33908 + (1));
i__28115__auto___33908 = G__33909;
continue;
} else {
}
break;
}

var G__33906 = args33904.length;
switch (G__33906) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33904.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args33911 = [];
var len__28114__auto___33914 = arguments.length;
var i__28115__auto___33915 = (0);
while(true){
if((i__28115__auto___33915 < len__28114__auto___33914)){
args33911.push((arguments[i__28115__auto___33915]));

var G__33916 = (i__28115__auto___33915 + (1));
i__28115__auto___33915 = G__33916;
continue;
} else {
}
break;
}

var G__33913 = args33911.length;
switch (G__33913) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33911.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args33918 = [];
var len__28114__auto___33989 = arguments.length;
var i__28115__auto___33990 = (0);
while(true){
if((i__28115__auto___33990 < len__28114__auto___33989)){
args33918.push((arguments[i__28115__auto___33990]));

var G__33991 = (i__28115__auto___33990 + (1));
i__28115__auto___33990 = G__33991;
continue;
} else {
}
break;
}

var G__33920 = args33918.length;
switch (G__33920) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33918.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__31906__auto___33993 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___33993,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___33993,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33959){
var state_val_33960 = (state_33959[(1)]);
if((state_val_33960 === (7))){
var state_33959__$1 = state_33959;
var statearr_33961_33994 = state_33959__$1;
(statearr_33961_33994[(2)] = null);

(statearr_33961_33994[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (1))){
var state_33959__$1 = state_33959;
var statearr_33962_33995 = state_33959__$1;
(statearr_33962_33995[(2)] = null);

(statearr_33962_33995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (4))){
var inst_33923 = (state_33959[(7)]);
var inst_33925 = (inst_33923 < cnt);
var state_33959__$1 = state_33959;
if(cljs.core.truth_(inst_33925)){
var statearr_33963_33996 = state_33959__$1;
(statearr_33963_33996[(1)] = (6));

} else {
var statearr_33964_33997 = state_33959__$1;
(statearr_33964_33997[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (15))){
var inst_33955 = (state_33959[(2)]);
var state_33959__$1 = state_33959;
var statearr_33965_33998 = state_33959__$1;
(statearr_33965_33998[(2)] = inst_33955);

(statearr_33965_33998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (13))){
var inst_33948 = cljs.core.async.close_BANG_.call(null,out);
var state_33959__$1 = state_33959;
var statearr_33966_33999 = state_33959__$1;
(statearr_33966_33999[(2)] = inst_33948);

(statearr_33966_33999[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (6))){
var state_33959__$1 = state_33959;
var statearr_33967_34000 = state_33959__$1;
(statearr_33967_34000[(2)] = null);

(statearr_33967_34000[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (3))){
var inst_33957 = (state_33959[(2)]);
var state_33959__$1 = state_33959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33959__$1,inst_33957);
} else {
if((state_val_33960 === (12))){
var inst_33945 = (state_33959[(8)]);
var inst_33945__$1 = (state_33959[(2)]);
var inst_33946 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_33945__$1);
var state_33959__$1 = (function (){var statearr_33968 = state_33959;
(statearr_33968[(8)] = inst_33945__$1);

return statearr_33968;
})();
if(cljs.core.truth_(inst_33946)){
var statearr_33969_34001 = state_33959__$1;
(statearr_33969_34001[(1)] = (13));

} else {
var statearr_33970_34002 = state_33959__$1;
(statearr_33970_34002[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (2))){
var inst_33922 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_33923 = (0);
var state_33959__$1 = (function (){var statearr_33971 = state_33959;
(statearr_33971[(7)] = inst_33923);

(statearr_33971[(9)] = inst_33922);

return statearr_33971;
})();
var statearr_33972_34003 = state_33959__$1;
(statearr_33972_34003[(2)] = null);

(statearr_33972_34003[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (11))){
var inst_33923 = (state_33959[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_33959,(10),Object,null,(9));
var inst_33932 = chs__$1.call(null,inst_33923);
var inst_33933 = done.call(null,inst_33923);
var inst_33934 = cljs.core.async.take_BANG_.call(null,inst_33932,inst_33933);
var state_33959__$1 = state_33959;
var statearr_33973_34004 = state_33959__$1;
(statearr_33973_34004[(2)] = inst_33934);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33959__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (9))){
var inst_33923 = (state_33959[(7)]);
var inst_33936 = (state_33959[(2)]);
var inst_33937 = (inst_33923 + (1));
var inst_33923__$1 = inst_33937;
var state_33959__$1 = (function (){var statearr_33974 = state_33959;
(statearr_33974[(7)] = inst_33923__$1);

(statearr_33974[(10)] = inst_33936);

return statearr_33974;
})();
var statearr_33975_34005 = state_33959__$1;
(statearr_33975_34005[(2)] = null);

(statearr_33975_34005[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (5))){
var inst_33943 = (state_33959[(2)]);
var state_33959__$1 = (function (){var statearr_33976 = state_33959;
(statearr_33976[(11)] = inst_33943);

return statearr_33976;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33959__$1,(12),dchan);
} else {
if((state_val_33960 === (14))){
var inst_33945 = (state_33959[(8)]);
var inst_33950 = cljs.core.apply.call(null,f,inst_33945);
var state_33959__$1 = state_33959;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33959__$1,(16),out,inst_33950);
} else {
if((state_val_33960 === (16))){
var inst_33952 = (state_33959[(2)]);
var state_33959__$1 = (function (){var statearr_33977 = state_33959;
(statearr_33977[(12)] = inst_33952);

return statearr_33977;
})();
var statearr_33978_34006 = state_33959__$1;
(statearr_33978_34006[(2)] = null);

(statearr_33978_34006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (10))){
var inst_33927 = (state_33959[(2)]);
var inst_33928 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_33959__$1 = (function (){var statearr_33979 = state_33959;
(statearr_33979[(13)] = inst_33927);

return statearr_33979;
})();
var statearr_33980_34007 = state_33959__$1;
(statearr_33980_34007[(2)] = inst_33928);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33959__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33960 === (8))){
var inst_33941 = (state_33959[(2)]);
var state_33959__$1 = state_33959;
var statearr_33981_34008 = state_33959__$1;
(statearr_33981_34008[(2)] = inst_33941);

(statearr_33981_34008[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___33993,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__31792__auto__,c__31906__auto___33993,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_33985 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33985[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_33985[(1)] = (1));

return statearr_33985;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_33959){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_33959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e33986){if((e33986 instanceof Object)){
var ex__31796__auto__ = e33986;
var statearr_33987_34009 = state_33959;
(statearr_33987_34009[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33959);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33986;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34010 = state_33959;
state_33959 = G__34010;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_33959){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_33959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___33993,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__31908__auto__ = (function (){var statearr_33988 = f__31907__auto__.call(null);
(statearr_33988[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___33993);

return statearr_33988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___33993,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args34012 = [];
var len__28114__auto___34070 = arguments.length;
var i__28115__auto___34071 = (0);
while(true){
if((i__28115__auto___34071 < len__28114__auto___34070)){
args34012.push((arguments[i__28115__auto___34071]));

var G__34072 = (i__28115__auto___34071 + (1));
i__28115__auto___34071 = G__34072;
continue;
} else {
}
break;
}

var G__34014 = args34012.length;
switch (G__34014) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34012.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31906__auto___34074 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___34074,out){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___34074,out){
return (function (state_34046){
var state_val_34047 = (state_34046[(1)]);
if((state_val_34047 === (7))){
var inst_34025 = (state_34046[(7)]);
var inst_34026 = (state_34046[(8)]);
var inst_34025__$1 = (state_34046[(2)]);
var inst_34026__$1 = cljs.core.nth.call(null,inst_34025__$1,(0),null);
var inst_34027 = cljs.core.nth.call(null,inst_34025__$1,(1),null);
var inst_34028 = (inst_34026__$1 == null);
var state_34046__$1 = (function (){var statearr_34048 = state_34046;
(statearr_34048[(9)] = inst_34027);

(statearr_34048[(7)] = inst_34025__$1);

(statearr_34048[(8)] = inst_34026__$1);

return statearr_34048;
})();
if(cljs.core.truth_(inst_34028)){
var statearr_34049_34075 = state_34046__$1;
(statearr_34049_34075[(1)] = (8));

} else {
var statearr_34050_34076 = state_34046__$1;
(statearr_34050_34076[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (1))){
var inst_34015 = cljs.core.vec.call(null,chs);
var inst_34016 = inst_34015;
var state_34046__$1 = (function (){var statearr_34051 = state_34046;
(statearr_34051[(10)] = inst_34016);

return statearr_34051;
})();
var statearr_34052_34077 = state_34046__$1;
(statearr_34052_34077[(2)] = null);

(statearr_34052_34077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (4))){
var inst_34016 = (state_34046[(10)]);
var state_34046__$1 = state_34046;
return cljs.core.async.ioc_alts_BANG_.call(null,state_34046__$1,(7),inst_34016);
} else {
if((state_val_34047 === (6))){
var inst_34042 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
var statearr_34053_34078 = state_34046__$1;
(statearr_34053_34078[(2)] = inst_34042);

(statearr_34053_34078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (3))){
var inst_34044 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34046__$1,inst_34044);
} else {
if((state_val_34047 === (2))){
var inst_34016 = (state_34046[(10)]);
var inst_34018 = cljs.core.count.call(null,inst_34016);
var inst_34019 = (inst_34018 > (0));
var state_34046__$1 = state_34046;
if(cljs.core.truth_(inst_34019)){
var statearr_34055_34079 = state_34046__$1;
(statearr_34055_34079[(1)] = (4));

} else {
var statearr_34056_34080 = state_34046__$1;
(statearr_34056_34080[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (11))){
var inst_34016 = (state_34046[(10)]);
var inst_34035 = (state_34046[(2)]);
var tmp34054 = inst_34016;
var inst_34016__$1 = tmp34054;
var state_34046__$1 = (function (){var statearr_34057 = state_34046;
(statearr_34057[(11)] = inst_34035);

(statearr_34057[(10)] = inst_34016__$1);

return statearr_34057;
})();
var statearr_34058_34081 = state_34046__$1;
(statearr_34058_34081[(2)] = null);

(statearr_34058_34081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (9))){
var inst_34026 = (state_34046[(8)]);
var state_34046__$1 = state_34046;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34046__$1,(11),out,inst_34026);
} else {
if((state_val_34047 === (5))){
var inst_34040 = cljs.core.async.close_BANG_.call(null,out);
var state_34046__$1 = state_34046;
var statearr_34059_34082 = state_34046__$1;
(statearr_34059_34082[(2)] = inst_34040);

(statearr_34059_34082[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (10))){
var inst_34038 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
var statearr_34060_34083 = state_34046__$1;
(statearr_34060_34083[(2)] = inst_34038);

(statearr_34060_34083[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (8))){
var inst_34016 = (state_34046[(10)]);
var inst_34027 = (state_34046[(9)]);
var inst_34025 = (state_34046[(7)]);
var inst_34026 = (state_34046[(8)]);
var inst_34030 = (function (){var cs = inst_34016;
var vec__34021 = inst_34025;
var v = inst_34026;
var c = inst_34027;
return ((function (cs,vec__34021,v,c,inst_34016,inst_34027,inst_34025,inst_34026,state_val_34047,c__31906__auto___34074,out){
return (function (p1__34011_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__34011_SHARP_);
});
;})(cs,vec__34021,v,c,inst_34016,inst_34027,inst_34025,inst_34026,state_val_34047,c__31906__auto___34074,out))
})();
var inst_34031 = cljs.core.filterv.call(null,inst_34030,inst_34016);
var inst_34016__$1 = inst_34031;
var state_34046__$1 = (function (){var statearr_34061 = state_34046;
(statearr_34061[(10)] = inst_34016__$1);

return statearr_34061;
})();
var statearr_34062_34084 = state_34046__$1;
(statearr_34062_34084[(2)] = null);

(statearr_34062_34084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___34074,out))
;
return ((function (switch__31792__auto__,c__31906__auto___34074,out){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_34066 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34066[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_34066[(1)] = (1));

return statearr_34066;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_34046){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_34046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e34067){if((e34067 instanceof Object)){
var ex__31796__auto__ = e34067;
var statearr_34068_34085 = state_34046;
(statearr_34068_34085[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34046);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34067;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34086 = state_34046;
state_34046 = G__34086;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_34046){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_34046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___34074,out))
})();
var state__31908__auto__ = (function (){var statearr_34069 = f__31907__auto__.call(null);
(statearr_34069[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___34074);

return statearr_34069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___34074,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args34087 = [];
var len__28114__auto___34136 = arguments.length;
var i__28115__auto___34137 = (0);
while(true){
if((i__28115__auto___34137 < len__28114__auto___34136)){
args34087.push((arguments[i__28115__auto___34137]));

var G__34138 = (i__28115__auto___34137 + (1));
i__28115__auto___34137 = G__34138;
continue;
} else {
}
break;
}

var G__34089 = args34087.length;
switch (G__34089) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34087.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31906__auto___34140 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___34140,out){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___34140,out){
return (function (state_34113){
var state_val_34114 = (state_34113[(1)]);
if((state_val_34114 === (7))){
var inst_34095 = (state_34113[(7)]);
var inst_34095__$1 = (state_34113[(2)]);
var inst_34096 = (inst_34095__$1 == null);
var inst_34097 = cljs.core.not.call(null,inst_34096);
var state_34113__$1 = (function (){var statearr_34115 = state_34113;
(statearr_34115[(7)] = inst_34095__$1);

return statearr_34115;
})();
if(inst_34097){
var statearr_34116_34141 = state_34113__$1;
(statearr_34116_34141[(1)] = (8));

} else {
var statearr_34117_34142 = state_34113__$1;
(statearr_34117_34142[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34114 === (1))){
var inst_34090 = (0);
var state_34113__$1 = (function (){var statearr_34118 = state_34113;
(statearr_34118[(8)] = inst_34090);

return statearr_34118;
})();
var statearr_34119_34143 = state_34113__$1;
(statearr_34119_34143[(2)] = null);

(statearr_34119_34143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34114 === (4))){
var state_34113__$1 = state_34113;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34113__$1,(7),ch);
} else {
if((state_val_34114 === (6))){
var inst_34108 = (state_34113[(2)]);
var state_34113__$1 = state_34113;
var statearr_34120_34144 = state_34113__$1;
(statearr_34120_34144[(2)] = inst_34108);

(statearr_34120_34144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34114 === (3))){
var inst_34110 = (state_34113[(2)]);
var inst_34111 = cljs.core.async.close_BANG_.call(null,out);
var state_34113__$1 = (function (){var statearr_34121 = state_34113;
(statearr_34121[(9)] = inst_34110);

return statearr_34121;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34113__$1,inst_34111);
} else {
if((state_val_34114 === (2))){
var inst_34090 = (state_34113[(8)]);
var inst_34092 = (inst_34090 < n);
var state_34113__$1 = state_34113;
if(cljs.core.truth_(inst_34092)){
var statearr_34122_34145 = state_34113__$1;
(statearr_34122_34145[(1)] = (4));

} else {
var statearr_34123_34146 = state_34113__$1;
(statearr_34123_34146[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34114 === (11))){
var inst_34090 = (state_34113[(8)]);
var inst_34100 = (state_34113[(2)]);
var inst_34101 = (inst_34090 + (1));
var inst_34090__$1 = inst_34101;
var state_34113__$1 = (function (){var statearr_34124 = state_34113;
(statearr_34124[(10)] = inst_34100);

(statearr_34124[(8)] = inst_34090__$1);

return statearr_34124;
})();
var statearr_34125_34147 = state_34113__$1;
(statearr_34125_34147[(2)] = null);

(statearr_34125_34147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34114 === (9))){
var state_34113__$1 = state_34113;
var statearr_34126_34148 = state_34113__$1;
(statearr_34126_34148[(2)] = null);

(statearr_34126_34148[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34114 === (5))){
var state_34113__$1 = state_34113;
var statearr_34127_34149 = state_34113__$1;
(statearr_34127_34149[(2)] = null);

(statearr_34127_34149[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34114 === (10))){
var inst_34105 = (state_34113[(2)]);
var state_34113__$1 = state_34113;
var statearr_34128_34150 = state_34113__$1;
(statearr_34128_34150[(2)] = inst_34105);

(statearr_34128_34150[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34114 === (8))){
var inst_34095 = (state_34113[(7)]);
var state_34113__$1 = state_34113;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34113__$1,(11),out,inst_34095);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___34140,out))
;
return ((function (switch__31792__auto__,c__31906__auto___34140,out){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_34132 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34132[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_34132[(1)] = (1));

return statearr_34132;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_34113){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_34113);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e34133){if((e34133 instanceof Object)){
var ex__31796__auto__ = e34133;
var statearr_34134_34151 = state_34113;
(statearr_34134_34151[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34113);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34133;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34152 = state_34113;
state_34113 = G__34152;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_34113){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_34113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___34140,out))
})();
var state__31908__auto__ = (function (){var statearr_34135 = f__31907__auto__.call(null);
(statearr_34135[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___34140);

return statearr_34135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___34140,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34160 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34160 = (function (f,ch,meta34161){
this.f = f;
this.ch = ch;
this.meta34161 = meta34161;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34160.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34162,meta34161__$1){
var self__ = this;
var _34162__$1 = this;
return (new cljs.core.async.t_cljs$core$async34160(self__.f,self__.ch,meta34161__$1));
});

cljs.core.async.t_cljs$core$async34160.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34162){
var self__ = this;
var _34162__$1 = this;
return self__.meta34161;
});

cljs.core.async.t_cljs$core$async34160.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34160.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async34160.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async34160.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34160.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async34163 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34163 = (function (f,ch,meta34161,_,fn1,meta34164){
this.f = f;
this.ch = ch;
this.meta34161 = meta34161;
this._ = _;
this.fn1 = fn1;
this.meta34164 = meta34164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_34165,meta34164__$1){
var self__ = this;
var _34165__$1 = this;
return (new cljs.core.async.t_cljs$core$async34163(self__.f,self__.ch,self__.meta34161,self__._,self__.fn1,meta34164__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async34163.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_34165){
var self__ = this;
var _34165__$1 = this;
return self__.meta34164;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34163.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34163.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34163.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34163.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__34153_SHARP_){
return f1.call(null,(((p1__34153_SHARP_ == null))?null:self__.f.call(null,p1__34153_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async34163.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta34161","meta34161",1925764649,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async34160","cljs.core.async/t_cljs$core$async34160",-1033867862,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta34164","meta34164",-1868565816,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34163.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34163.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34163";

cljs.core.async.t_cljs$core$async34163.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async34163");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async34163 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34163(f__$1,ch__$1,meta34161__$1,___$2,fn1__$1,meta34164){
return (new cljs.core.async.t_cljs$core$async34163(f__$1,ch__$1,meta34161__$1,___$2,fn1__$1,meta34164));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async34163(self__.f,self__.ch,self__.meta34161,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__26886__auto__ = ret;
if(cljs.core.truth_(and__26886__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__26886__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async34160.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34160.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async34160.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta34161","meta34161",1925764649,null)], null);
});

cljs.core.async.t_cljs$core$async34160.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34160.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34160";

cljs.core.async.t_cljs$core$async34160.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async34160");
});

cljs.core.async.__GT_t_cljs$core$async34160 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34160(f__$1,ch__$1,meta34161){
return (new cljs.core.async.t_cljs$core$async34160(f__$1,ch__$1,meta34161));
});

}

return (new cljs.core.async.t_cljs$core$async34160(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34169 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34169 = (function (f,ch,meta34170){
this.f = f;
this.ch = ch;
this.meta34170 = meta34170;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34169.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34171,meta34170__$1){
var self__ = this;
var _34171__$1 = this;
return (new cljs.core.async.t_cljs$core$async34169(self__.f,self__.ch,meta34170__$1));
});

cljs.core.async.t_cljs$core$async34169.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34171){
var self__ = this;
var _34171__$1 = this;
return self__.meta34170;
});

cljs.core.async.t_cljs$core$async34169.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34169.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async34169.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34169.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34169.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34169.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async34169.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta34170","meta34170",-630624044,null)], null);
});

cljs.core.async.t_cljs$core$async34169.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34169.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34169";

cljs.core.async.t_cljs$core$async34169.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async34169");
});

cljs.core.async.__GT_t_cljs$core$async34169 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async34169(f__$1,ch__$1,meta34170){
return (new cljs.core.async.t_cljs$core$async34169(f__$1,ch__$1,meta34170));
});

}

return (new cljs.core.async.t_cljs$core$async34169(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async34175 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34175 = (function (p,ch,meta34176){
this.p = p;
this.ch = ch;
this.meta34176 = meta34176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34177,meta34176__$1){
var self__ = this;
var _34177__$1 = this;
return (new cljs.core.async.t_cljs$core$async34175(self__.p,self__.ch,meta34176__$1));
});

cljs.core.async.t_cljs$core$async34175.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34177){
var self__ = this;
var _34177__$1 = this;
return self__.meta34176;
});

cljs.core.async.t_cljs$core$async34175.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34175.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async34175.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async34175.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34175.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34175.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34175.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async34175.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta34176","meta34176",-1987563637,null)], null);
});

cljs.core.async.t_cljs$core$async34175.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34175.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34175";

cljs.core.async.t_cljs$core$async34175.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async34175");
});

cljs.core.async.__GT_t_cljs$core$async34175 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async34175(p__$1,ch__$1,meta34176){
return (new cljs.core.async.t_cljs$core$async34175(p__$1,ch__$1,meta34176));
});

}

return (new cljs.core.async.t_cljs$core$async34175(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args34178 = [];
var len__28114__auto___34222 = arguments.length;
var i__28115__auto___34223 = (0);
while(true){
if((i__28115__auto___34223 < len__28114__auto___34222)){
args34178.push((arguments[i__28115__auto___34223]));

var G__34224 = (i__28115__auto___34223 + (1));
i__28115__auto___34223 = G__34224;
continue;
} else {
}
break;
}

var G__34180 = args34178.length;
switch (G__34180) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34178.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31906__auto___34226 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___34226,out){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___34226,out){
return (function (state_34201){
var state_val_34202 = (state_34201[(1)]);
if((state_val_34202 === (7))){
var inst_34197 = (state_34201[(2)]);
var state_34201__$1 = state_34201;
var statearr_34203_34227 = state_34201__$1;
(statearr_34203_34227[(2)] = inst_34197);

(statearr_34203_34227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34202 === (1))){
var state_34201__$1 = state_34201;
var statearr_34204_34228 = state_34201__$1;
(statearr_34204_34228[(2)] = null);

(statearr_34204_34228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34202 === (4))){
var inst_34183 = (state_34201[(7)]);
var inst_34183__$1 = (state_34201[(2)]);
var inst_34184 = (inst_34183__$1 == null);
var state_34201__$1 = (function (){var statearr_34205 = state_34201;
(statearr_34205[(7)] = inst_34183__$1);

return statearr_34205;
})();
if(cljs.core.truth_(inst_34184)){
var statearr_34206_34229 = state_34201__$1;
(statearr_34206_34229[(1)] = (5));

} else {
var statearr_34207_34230 = state_34201__$1;
(statearr_34207_34230[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34202 === (6))){
var inst_34183 = (state_34201[(7)]);
var inst_34188 = p.call(null,inst_34183);
var state_34201__$1 = state_34201;
if(cljs.core.truth_(inst_34188)){
var statearr_34208_34231 = state_34201__$1;
(statearr_34208_34231[(1)] = (8));

} else {
var statearr_34209_34232 = state_34201__$1;
(statearr_34209_34232[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34202 === (3))){
var inst_34199 = (state_34201[(2)]);
var state_34201__$1 = state_34201;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34201__$1,inst_34199);
} else {
if((state_val_34202 === (2))){
var state_34201__$1 = state_34201;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34201__$1,(4),ch);
} else {
if((state_val_34202 === (11))){
var inst_34191 = (state_34201[(2)]);
var state_34201__$1 = state_34201;
var statearr_34210_34233 = state_34201__$1;
(statearr_34210_34233[(2)] = inst_34191);

(statearr_34210_34233[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34202 === (9))){
var state_34201__$1 = state_34201;
var statearr_34211_34234 = state_34201__$1;
(statearr_34211_34234[(2)] = null);

(statearr_34211_34234[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34202 === (5))){
var inst_34186 = cljs.core.async.close_BANG_.call(null,out);
var state_34201__$1 = state_34201;
var statearr_34212_34235 = state_34201__$1;
(statearr_34212_34235[(2)] = inst_34186);

(statearr_34212_34235[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34202 === (10))){
var inst_34194 = (state_34201[(2)]);
var state_34201__$1 = (function (){var statearr_34213 = state_34201;
(statearr_34213[(8)] = inst_34194);

return statearr_34213;
})();
var statearr_34214_34236 = state_34201__$1;
(statearr_34214_34236[(2)] = null);

(statearr_34214_34236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34202 === (8))){
var inst_34183 = (state_34201[(7)]);
var state_34201__$1 = state_34201;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34201__$1,(11),out,inst_34183);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___34226,out))
;
return ((function (switch__31792__auto__,c__31906__auto___34226,out){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_34218 = [null,null,null,null,null,null,null,null,null];
(statearr_34218[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_34218[(1)] = (1));

return statearr_34218;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_34201){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_34201);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e34219){if((e34219 instanceof Object)){
var ex__31796__auto__ = e34219;
var statearr_34220_34237 = state_34201;
(statearr_34220_34237[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34201);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34219;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34238 = state_34201;
state_34201 = G__34238;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_34201){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_34201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___34226,out))
})();
var state__31908__auto__ = (function (){var statearr_34221 = f__31907__auto__.call(null);
(statearr_34221[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___34226);

return statearr_34221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___34226,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args34239 = [];
var len__28114__auto___34242 = arguments.length;
var i__28115__auto___34243 = (0);
while(true){
if((i__28115__auto___34243 < len__28114__auto___34242)){
args34239.push((arguments[i__28115__auto___34243]));

var G__34244 = (i__28115__auto___34243 + (1));
i__28115__auto___34243 = G__34244;
continue;
} else {
}
break;
}

var G__34241 = args34239.length;
switch (G__34241) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34239.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__31906__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto__){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto__){
return (function (state_34411){
var state_val_34412 = (state_34411[(1)]);
if((state_val_34412 === (7))){
var inst_34407 = (state_34411[(2)]);
var state_34411__$1 = state_34411;
var statearr_34413_34454 = state_34411__$1;
(statearr_34413_34454[(2)] = inst_34407);

(statearr_34413_34454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (20))){
var inst_34377 = (state_34411[(7)]);
var inst_34388 = (state_34411[(2)]);
var inst_34389 = cljs.core.next.call(null,inst_34377);
var inst_34363 = inst_34389;
var inst_34364 = null;
var inst_34365 = (0);
var inst_34366 = (0);
var state_34411__$1 = (function (){var statearr_34414 = state_34411;
(statearr_34414[(8)] = inst_34364);

(statearr_34414[(9)] = inst_34388);

(statearr_34414[(10)] = inst_34365);

(statearr_34414[(11)] = inst_34366);

(statearr_34414[(12)] = inst_34363);

return statearr_34414;
})();
var statearr_34415_34455 = state_34411__$1;
(statearr_34415_34455[(2)] = null);

(statearr_34415_34455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (1))){
var state_34411__$1 = state_34411;
var statearr_34416_34456 = state_34411__$1;
(statearr_34416_34456[(2)] = null);

(statearr_34416_34456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (4))){
var inst_34352 = (state_34411[(13)]);
var inst_34352__$1 = (state_34411[(2)]);
var inst_34353 = (inst_34352__$1 == null);
var state_34411__$1 = (function (){var statearr_34417 = state_34411;
(statearr_34417[(13)] = inst_34352__$1);

return statearr_34417;
})();
if(cljs.core.truth_(inst_34353)){
var statearr_34418_34457 = state_34411__$1;
(statearr_34418_34457[(1)] = (5));

} else {
var statearr_34419_34458 = state_34411__$1;
(statearr_34419_34458[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (15))){
var state_34411__$1 = state_34411;
var statearr_34423_34459 = state_34411__$1;
(statearr_34423_34459[(2)] = null);

(statearr_34423_34459[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (21))){
var state_34411__$1 = state_34411;
var statearr_34424_34460 = state_34411__$1;
(statearr_34424_34460[(2)] = null);

(statearr_34424_34460[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (13))){
var inst_34364 = (state_34411[(8)]);
var inst_34365 = (state_34411[(10)]);
var inst_34366 = (state_34411[(11)]);
var inst_34363 = (state_34411[(12)]);
var inst_34373 = (state_34411[(2)]);
var inst_34374 = (inst_34366 + (1));
var tmp34420 = inst_34364;
var tmp34421 = inst_34365;
var tmp34422 = inst_34363;
var inst_34363__$1 = tmp34422;
var inst_34364__$1 = tmp34420;
var inst_34365__$1 = tmp34421;
var inst_34366__$1 = inst_34374;
var state_34411__$1 = (function (){var statearr_34425 = state_34411;
(statearr_34425[(8)] = inst_34364__$1);

(statearr_34425[(10)] = inst_34365__$1);

(statearr_34425[(14)] = inst_34373);

(statearr_34425[(11)] = inst_34366__$1);

(statearr_34425[(12)] = inst_34363__$1);

return statearr_34425;
})();
var statearr_34426_34461 = state_34411__$1;
(statearr_34426_34461[(2)] = null);

(statearr_34426_34461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (22))){
var state_34411__$1 = state_34411;
var statearr_34427_34462 = state_34411__$1;
(statearr_34427_34462[(2)] = null);

(statearr_34427_34462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (6))){
var inst_34352 = (state_34411[(13)]);
var inst_34361 = f.call(null,inst_34352);
var inst_34362 = cljs.core.seq.call(null,inst_34361);
var inst_34363 = inst_34362;
var inst_34364 = null;
var inst_34365 = (0);
var inst_34366 = (0);
var state_34411__$1 = (function (){var statearr_34428 = state_34411;
(statearr_34428[(8)] = inst_34364);

(statearr_34428[(10)] = inst_34365);

(statearr_34428[(11)] = inst_34366);

(statearr_34428[(12)] = inst_34363);

return statearr_34428;
})();
var statearr_34429_34463 = state_34411__$1;
(statearr_34429_34463[(2)] = null);

(statearr_34429_34463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (17))){
var inst_34377 = (state_34411[(7)]);
var inst_34381 = cljs.core.chunk_first.call(null,inst_34377);
var inst_34382 = cljs.core.chunk_rest.call(null,inst_34377);
var inst_34383 = cljs.core.count.call(null,inst_34381);
var inst_34363 = inst_34382;
var inst_34364 = inst_34381;
var inst_34365 = inst_34383;
var inst_34366 = (0);
var state_34411__$1 = (function (){var statearr_34430 = state_34411;
(statearr_34430[(8)] = inst_34364);

(statearr_34430[(10)] = inst_34365);

(statearr_34430[(11)] = inst_34366);

(statearr_34430[(12)] = inst_34363);

return statearr_34430;
})();
var statearr_34431_34464 = state_34411__$1;
(statearr_34431_34464[(2)] = null);

(statearr_34431_34464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (3))){
var inst_34409 = (state_34411[(2)]);
var state_34411__$1 = state_34411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34411__$1,inst_34409);
} else {
if((state_val_34412 === (12))){
var inst_34397 = (state_34411[(2)]);
var state_34411__$1 = state_34411;
var statearr_34432_34465 = state_34411__$1;
(statearr_34432_34465[(2)] = inst_34397);

(statearr_34432_34465[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (2))){
var state_34411__$1 = state_34411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34411__$1,(4),in$);
} else {
if((state_val_34412 === (23))){
var inst_34405 = (state_34411[(2)]);
var state_34411__$1 = state_34411;
var statearr_34433_34466 = state_34411__$1;
(statearr_34433_34466[(2)] = inst_34405);

(statearr_34433_34466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (19))){
var inst_34392 = (state_34411[(2)]);
var state_34411__$1 = state_34411;
var statearr_34434_34467 = state_34411__$1;
(statearr_34434_34467[(2)] = inst_34392);

(statearr_34434_34467[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (11))){
var inst_34377 = (state_34411[(7)]);
var inst_34363 = (state_34411[(12)]);
var inst_34377__$1 = cljs.core.seq.call(null,inst_34363);
var state_34411__$1 = (function (){var statearr_34435 = state_34411;
(statearr_34435[(7)] = inst_34377__$1);

return statearr_34435;
})();
if(inst_34377__$1){
var statearr_34436_34468 = state_34411__$1;
(statearr_34436_34468[(1)] = (14));

} else {
var statearr_34437_34469 = state_34411__$1;
(statearr_34437_34469[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (9))){
var inst_34399 = (state_34411[(2)]);
var inst_34400 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_34411__$1 = (function (){var statearr_34438 = state_34411;
(statearr_34438[(15)] = inst_34399);

return statearr_34438;
})();
if(cljs.core.truth_(inst_34400)){
var statearr_34439_34470 = state_34411__$1;
(statearr_34439_34470[(1)] = (21));

} else {
var statearr_34440_34471 = state_34411__$1;
(statearr_34440_34471[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (5))){
var inst_34355 = cljs.core.async.close_BANG_.call(null,out);
var state_34411__$1 = state_34411;
var statearr_34441_34472 = state_34411__$1;
(statearr_34441_34472[(2)] = inst_34355);

(statearr_34441_34472[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (14))){
var inst_34377 = (state_34411[(7)]);
var inst_34379 = cljs.core.chunked_seq_QMARK_.call(null,inst_34377);
var state_34411__$1 = state_34411;
if(inst_34379){
var statearr_34442_34473 = state_34411__$1;
(statearr_34442_34473[(1)] = (17));

} else {
var statearr_34443_34474 = state_34411__$1;
(statearr_34443_34474[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (16))){
var inst_34395 = (state_34411[(2)]);
var state_34411__$1 = state_34411;
var statearr_34444_34475 = state_34411__$1;
(statearr_34444_34475[(2)] = inst_34395);

(statearr_34444_34475[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34412 === (10))){
var inst_34364 = (state_34411[(8)]);
var inst_34366 = (state_34411[(11)]);
var inst_34371 = cljs.core._nth.call(null,inst_34364,inst_34366);
var state_34411__$1 = state_34411;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34411__$1,(13),out,inst_34371);
} else {
if((state_val_34412 === (18))){
var inst_34377 = (state_34411[(7)]);
var inst_34386 = cljs.core.first.call(null,inst_34377);
var state_34411__$1 = state_34411;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34411__$1,(20),out,inst_34386);
} else {
if((state_val_34412 === (8))){
var inst_34365 = (state_34411[(10)]);
var inst_34366 = (state_34411[(11)]);
var inst_34368 = (inst_34366 < inst_34365);
var inst_34369 = inst_34368;
var state_34411__$1 = state_34411;
if(cljs.core.truth_(inst_34369)){
var statearr_34445_34476 = state_34411__$1;
(statearr_34445_34476[(1)] = (10));

} else {
var statearr_34446_34477 = state_34411__$1;
(statearr_34446_34477[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto__))
;
return ((function (switch__31792__auto__,c__31906__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__31793__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__31793__auto____0 = (function (){
var statearr_34450 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34450[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__31793__auto__);

(statearr_34450[(1)] = (1));

return statearr_34450;
});
var cljs$core$async$mapcat_STAR__$_state_machine__31793__auto____1 = (function (state_34411){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_34411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e34451){if((e34451 instanceof Object)){
var ex__31796__auto__ = e34451;
var statearr_34452_34478 = state_34411;
(statearr_34452_34478[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34411);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34451;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34479 = state_34411;
state_34411 = G__34479;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__31793__auto__ = function(state_34411){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__31793__auto____1.call(this,state_34411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__31793__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__31793__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto__))
})();
var state__31908__auto__ = (function (){var statearr_34453 = f__31907__auto__.call(null);
(statearr_34453[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto__);

return statearr_34453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto__))
);

return c__31906__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args34480 = [];
var len__28114__auto___34483 = arguments.length;
var i__28115__auto___34484 = (0);
while(true){
if((i__28115__auto___34484 < len__28114__auto___34483)){
args34480.push((arguments[i__28115__auto___34484]));

var G__34485 = (i__28115__auto___34484 + (1));
i__28115__auto___34484 = G__34485;
continue;
} else {
}
break;
}

var G__34482 = args34480.length;
switch (G__34482) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34480.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args34487 = [];
var len__28114__auto___34490 = arguments.length;
var i__28115__auto___34491 = (0);
while(true){
if((i__28115__auto___34491 < len__28114__auto___34490)){
args34487.push((arguments[i__28115__auto___34491]));

var G__34492 = (i__28115__auto___34491 + (1));
i__28115__auto___34491 = G__34492;
continue;
} else {
}
break;
}

var G__34489 = args34487.length;
switch (G__34489) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34487.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args34494 = [];
var len__28114__auto___34545 = arguments.length;
var i__28115__auto___34546 = (0);
while(true){
if((i__28115__auto___34546 < len__28114__auto___34545)){
args34494.push((arguments[i__28115__auto___34546]));

var G__34547 = (i__28115__auto___34546 + (1));
i__28115__auto___34546 = G__34547;
continue;
} else {
}
break;
}

var G__34496 = args34494.length;
switch (G__34496) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34494.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31906__auto___34549 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___34549,out){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___34549,out){
return (function (state_34520){
var state_val_34521 = (state_34520[(1)]);
if((state_val_34521 === (7))){
var inst_34515 = (state_34520[(2)]);
var state_34520__$1 = state_34520;
var statearr_34522_34550 = state_34520__$1;
(statearr_34522_34550[(2)] = inst_34515);

(statearr_34522_34550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34521 === (1))){
var inst_34497 = null;
var state_34520__$1 = (function (){var statearr_34523 = state_34520;
(statearr_34523[(7)] = inst_34497);

return statearr_34523;
})();
var statearr_34524_34551 = state_34520__$1;
(statearr_34524_34551[(2)] = null);

(statearr_34524_34551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34521 === (4))){
var inst_34500 = (state_34520[(8)]);
var inst_34500__$1 = (state_34520[(2)]);
var inst_34501 = (inst_34500__$1 == null);
var inst_34502 = cljs.core.not.call(null,inst_34501);
var state_34520__$1 = (function (){var statearr_34525 = state_34520;
(statearr_34525[(8)] = inst_34500__$1);

return statearr_34525;
})();
if(inst_34502){
var statearr_34526_34552 = state_34520__$1;
(statearr_34526_34552[(1)] = (5));

} else {
var statearr_34527_34553 = state_34520__$1;
(statearr_34527_34553[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34521 === (6))){
var state_34520__$1 = state_34520;
var statearr_34528_34554 = state_34520__$1;
(statearr_34528_34554[(2)] = null);

(statearr_34528_34554[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34521 === (3))){
var inst_34517 = (state_34520[(2)]);
var inst_34518 = cljs.core.async.close_BANG_.call(null,out);
var state_34520__$1 = (function (){var statearr_34529 = state_34520;
(statearr_34529[(9)] = inst_34517);

return statearr_34529;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34520__$1,inst_34518);
} else {
if((state_val_34521 === (2))){
var state_34520__$1 = state_34520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34520__$1,(4),ch);
} else {
if((state_val_34521 === (11))){
var inst_34500 = (state_34520[(8)]);
var inst_34509 = (state_34520[(2)]);
var inst_34497 = inst_34500;
var state_34520__$1 = (function (){var statearr_34530 = state_34520;
(statearr_34530[(10)] = inst_34509);

(statearr_34530[(7)] = inst_34497);

return statearr_34530;
})();
var statearr_34531_34555 = state_34520__$1;
(statearr_34531_34555[(2)] = null);

(statearr_34531_34555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34521 === (9))){
var inst_34500 = (state_34520[(8)]);
var state_34520__$1 = state_34520;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34520__$1,(11),out,inst_34500);
} else {
if((state_val_34521 === (5))){
var inst_34497 = (state_34520[(7)]);
var inst_34500 = (state_34520[(8)]);
var inst_34504 = cljs.core._EQ_.call(null,inst_34500,inst_34497);
var state_34520__$1 = state_34520;
if(inst_34504){
var statearr_34533_34556 = state_34520__$1;
(statearr_34533_34556[(1)] = (8));

} else {
var statearr_34534_34557 = state_34520__$1;
(statearr_34534_34557[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34521 === (10))){
var inst_34512 = (state_34520[(2)]);
var state_34520__$1 = state_34520;
var statearr_34535_34558 = state_34520__$1;
(statearr_34535_34558[(2)] = inst_34512);

(statearr_34535_34558[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34521 === (8))){
var inst_34497 = (state_34520[(7)]);
var tmp34532 = inst_34497;
var inst_34497__$1 = tmp34532;
var state_34520__$1 = (function (){var statearr_34536 = state_34520;
(statearr_34536[(7)] = inst_34497__$1);

return statearr_34536;
})();
var statearr_34537_34559 = state_34520__$1;
(statearr_34537_34559[(2)] = null);

(statearr_34537_34559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___34549,out))
;
return ((function (switch__31792__auto__,c__31906__auto___34549,out){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_34541 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34541[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_34541[(1)] = (1));

return statearr_34541;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_34520){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_34520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e34542){if((e34542 instanceof Object)){
var ex__31796__auto__ = e34542;
var statearr_34543_34560 = state_34520;
(statearr_34543_34560[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34520);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34542;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34561 = state_34520;
state_34520 = G__34561;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_34520){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_34520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___34549,out))
})();
var state__31908__auto__ = (function (){var statearr_34544 = f__31907__auto__.call(null);
(statearr_34544[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___34549);

return statearr_34544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___34549,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args34562 = [];
var len__28114__auto___34632 = arguments.length;
var i__28115__auto___34633 = (0);
while(true){
if((i__28115__auto___34633 < len__28114__auto___34632)){
args34562.push((arguments[i__28115__auto___34633]));

var G__34634 = (i__28115__auto___34633 + (1));
i__28115__auto___34633 = G__34634;
continue;
} else {
}
break;
}

var G__34564 = args34562.length;
switch (G__34564) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34562.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31906__auto___34636 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___34636,out){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___34636,out){
return (function (state_34602){
var state_val_34603 = (state_34602[(1)]);
if((state_val_34603 === (7))){
var inst_34598 = (state_34602[(2)]);
var state_34602__$1 = state_34602;
var statearr_34604_34637 = state_34602__$1;
(statearr_34604_34637[(2)] = inst_34598);

(statearr_34604_34637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (1))){
var inst_34565 = (new Array(n));
var inst_34566 = inst_34565;
var inst_34567 = (0);
var state_34602__$1 = (function (){var statearr_34605 = state_34602;
(statearr_34605[(7)] = inst_34567);

(statearr_34605[(8)] = inst_34566);

return statearr_34605;
})();
var statearr_34606_34638 = state_34602__$1;
(statearr_34606_34638[(2)] = null);

(statearr_34606_34638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (4))){
var inst_34570 = (state_34602[(9)]);
var inst_34570__$1 = (state_34602[(2)]);
var inst_34571 = (inst_34570__$1 == null);
var inst_34572 = cljs.core.not.call(null,inst_34571);
var state_34602__$1 = (function (){var statearr_34607 = state_34602;
(statearr_34607[(9)] = inst_34570__$1);

return statearr_34607;
})();
if(inst_34572){
var statearr_34608_34639 = state_34602__$1;
(statearr_34608_34639[(1)] = (5));

} else {
var statearr_34609_34640 = state_34602__$1;
(statearr_34609_34640[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (15))){
var inst_34592 = (state_34602[(2)]);
var state_34602__$1 = state_34602;
var statearr_34610_34641 = state_34602__$1;
(statearr_34610_34641[(2)] = inst_34592);

(statearr_34610_34641[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (13))){
var state_34602__$1 = state_34602;
var statearr_34611_34642 = state_34602__$1;
(statearr_34611_34642[(2)] = null);

(statearr_34611_34642[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (6))){
var inst_34567 = (state_34602[(7)]);
var inst_34588 = (inst_34567 > (0));
var state_34602__$1 = state_34602;
if(cljs.core.truth_(inst_34588)){
var statearr_34612_34643 = state_34602__$1;
(statearr_34612_34643[(1)] = (12));

} else {
var statearr_34613_34644 = state_34602__$1;
(statearr_34613_34644[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (3))){
var inst_34600 = (state_34602[(2)]);
var state_34602__$1 = state_34602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34602__$1,inst_34600);
} else {
if((state_val_34603 === (12))){
var inst_34566 = (state_34602[(8)]);
var inst_34590 = cljs.core.vec.call(null,inst_34566);
var state_34602__$1 = state_34602;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34602__$1,(15),out,inst_34590);
} else {
if((state_val_34603 === (2))){
var state_34602__$1 = state_34602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34602__$1,(4),ch);
} else {
if((state_val_34603 === (11))){
var inst_34582 = (state_34602[(2)]);
var inst_34583 = (new Array(n));
var inst_34566 = inst_34583;
var inst_34567 = (0);
var state_34602__$1 = (function (){var statearr_34614 = state_34602;
(statearr_34614[(7)] = inst_34567);

(statearr_34614[(10)] = inst_34582);

(statearr_34614[(8)] = inst_34566);

return statearr_34614;
})();
var statearr_34615_34645 = state_34602__$1;
(statearr_34615_34645[(2)] = null);

(statearr_34615_34645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (9))){
var inst_34566 = (state_34602[(8)]);
var inst_34580 = cljs.core.vec.call(null,inst_34566);
var state_34602__$1 = state_34602;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34602__$1,(11),out,inst_34580);
} else {
if((state_val_34603 === (5))){
var inst_34567 = (state_34602[(7)]);
var inst_34570 = (state_34602[(9)]);
var inst_34566 = (state_34602[(8)]);
var inst_34575 = (state_34602[(11)]);
var inst_34574 = (inst_34566[inst_34567] = inst_34570);
var inst_34575__$1 = (inst_34567 + (1));
var inst_34576 = (inst_34575__$1 < n);
var state_34602__$1 = (function (){var statearr_34616 = state_34602;
(statearr_34616[(12)] = inst_34574);

(statearr_34616[(11)] = inst_34575__$1);

return statearr_34616;
})();
if(cljs.core.truth_(inst_34576)){
var statearr_34617_34646 = state_34602__$1;
(statearr_34617_34646[(1)] = (8));

} else {
var statearr_34618_34647 = state_34602__$1;
(statearr_34618_34647[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (14))){
var inst_34595 = (state_34602[(2)]);
var inst_34596 = cljs.core.async.close_BANG_.call(null,out);
var state_34602__$1 = (function (){var statearr_34620 = state_34602;
(statearr_34620[(13)] = inst_34595);

return statearr_34620;
})();
var statearr_34621_34648 = state_34602__$1;
(statearr_34621_34648[(2)] = inst_34596);

(statearr_34621_34648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (10))){
var inst_34586 = (state_34602[(2)]);
var state_34602__$1 = state_34602;
var statearr_34622_34649 = state_34602__$1;
(statearr_34622_34649[(2)] = inst_34586);

(statearr_34622_34649[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34603 === (8))){
var inst_34566 = (state_34602[(8)]);
var inst_34575 = (state_34602[(11)]);
var tmp34619 = inst_34566;
var inst_34566__$1 = tmp34619;
var inst_34567 = inst_34575;
var state_34602__$1 = (function (){var statearr_34623 = state_34602;
(statearr_34623[(7)] = inst_34567);

(statearr_34623[(8)] = inst_34566__$1);

return statearr_34623;
})();
var statearr_34624_34650 = state_34602__$1;
(statearr_34624_34650[(2)] = null);

(statearr_34624_34650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___34636,out))
;
return ((function (switch__31792__auto__,c__31906__auto___34636,out){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_34628 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34628[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_34628[(1)] = (1));

return statearr_34628;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_34602){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_34602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e34629){if((e34629 instanceof Object)){
var ex__31796__auto__ = e34629;
var statearr_34630_34651 = state_34602;
(statearr_34630_34651[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34602);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34629;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34652 = state_34602;
state_34602 = G__34652;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_34602){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_34602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___34636,out))
})();
var state__31908__auto__ = (function (){var statearr_34631 = f__31907__auto__.call(null);
(statearr_34631[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___34636);

return statearr_34631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___34636,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args34653 = [];
var len__28114__auto___34727 = arguments.length;
var i__28115__auto___34728 = (0);
while(true){
if((i__28115__auto___34728 < len__28114__auto___34727)){
args34653.push((arguments[i__28115__auto___34728]));

var G__34729 = (i__28115__auto___34728 + (1));
i__28115__auto___34728 = G__34729;
continue;
} else {
}
break;
}

var G__34655 = args34653.length;
switch (G__34655) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34653.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31906__auto___34731 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31906__auto___34731,out){
return (function (){
var f__31907__auto__ = (function (){var switch__31792__auto__ = ((function (c__31906__auto___34731,out){
return (function (state_34697){
var state_val_34698 = (state_34697[(1)]);
if((state_val_34698 === (7))){
var inst_34693 = (state_34697[(2)]);
var state_34697__$1 = state_34697;
var statearr_34699_34732 = state_34697__$1;
(statearr_34699_34732[(2)] = inst_34693);

(statearr_34699_34732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (1))){
var inst_34656 = [];
var inst_34657 = inst_34656;
var inst_34658 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_34697__$1 = (function (){var statearr_34700 = state_34697;
(statearr_34700[(7)] = inst_34657);

(statearr_34700[(8)] = inst_34658);

return statearr_34700;
})();
var statearr_34701_34733 = state_34697__$1;
(statearr_34701_34733[(2)] = null);

(statearr_34701_34733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (4))){
var inst_34661 = (state_34697[(9)]);
var inst_34661__$1 = (state_34697[(2)]);
var inst_34662 = (inst_34661__$1 == null);
var inst_34663 = cljs.core.not.call(null,inst_34662);
var state_34697__$1 = (function (){var statearr_34702 = state_34697;
(statearr_34702[(9)] = inst_34661__$1);

return statearr_34702;
})();
if(inst_34663){
var statearr_34703_34734 = state_34697__$1;
(statearr_34703_34734[(1)] = (5));

} else {
var statearr_34704_34735 = state_34697__$1;
(statearr_34704_34735[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (15))){
var inst_34687 = (state_34697[(2)]);
var state_34697__$1 = state_34697;
var statearr_34705_34736 = state_34697__$1;
(statearr_34705_34736[(2)] = inst_34687);

(statearr_34705_34736[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (13))){
var state_34697__$1 = state_34697;
var statearr_34706_34737 = state_34697__$1;
(statearr_34706_34737[(2)] = null);

(statearr_34706_34737[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (6))){
var inst_34657 = (state_34697[(7)]);
var inst_34682 = inst_34657.length;
var inst_34683 = (inst_34682 > (0));
var state_34697__$1 = state_34697;
if(cljs.core.truth_(inst_34683)){
var statearr_34707_34738 = state_34697__$1;
(statearr_34707_34738[(1)] = (12));

} else {
var statearr_34708_34739 = state_34697__$1;
(statearr_34708_34739[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (3))){
var inst_34695 = (state_34697[(2)]);
var state_34697__$1 = state_34697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34697__$1,inst_34695);
} else {
if((state_val_34698 === (12))){
var inst_34657 = (state_34697[(7)]);
var inst_34685 = cljs.core.vec.call(null,inst_34657);
var state_34697__$1 = state_34697;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34697__$1,(15),out,inst_34685);
} else {
if((state_val_34698 === (2))){
var state_34697__$1 = state_34697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34697__$1,(4),ch);
} else {
if((state_val_34698 === (11))){
var inst_34665 = (state_34697[(10)]);
var inst_34661 = (state_34697[(9)]);
var inst_34675 = (state_34697[(2)]);
var inst_34676 = [];
var inst_34677 = inst_34676.push(inst_34661);
var inst_34657 = inst_34676;
var inst_34658 = inst_34665;
var state_34697__$1 = (function (){var statearr_34709 = state_34697;
(statearr_34709[(11)] = inst_34677);

(statearr_34709[(12)] = inst_34675);

(statearr_34709[(7)] = inst_34657);

(statearr_34709[(8)] = inst_34658);

return statearr_34709;
})();
var statearr_34710_34740 = state_34697__$1;
(statearr_34710_34740[(2)] = null);

(statearr_34710_34740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (9))){
var inst_34657 = (state_34697[(7)]);
var inst_34673 = cljs.core.vec.call(null,inst_34657);
var state_34697__$1 = state_34697;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34697__$1,(11),out,inst_34673);
} else {
if((state_val_34698 === (5))){
var inst_34665 = (state_34697[(10)]);
var inst_34658 = (state_34697[(8)]);
var inst_34661 = (state_34697[(9)]);
var inst_34665__$1 = f.call(null,inst_34661);
var inst_34666 = cljs.core._EQ_.call(null,inst_34665__$1,inst_34658);
var inst_34667 = cljs.core.keyword_identical_QMARK_.call(null,inst_34658,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_34668 = (inst_34666) || (inst_34667);
var state_34697__$1 = (function (){var statearr_34711 = state_34697;
(statearr_34711[(10)] = inst_34665__$1);

return statearr_34711;
})();
if(cljs.core.truth_(inst_34668)){
var statearr_34712_34741 = state_34697__$1;
(statearr_34712_34741[(1)] = (8));

} else {
var statearr_34713_34742 = state_34697__$1;
(statearr_34713_34742[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (14))){
var inst_34690 = (state_34697[(2)]);
var inst_34691 = cljs.core.async.close_BANG_.call(null,out);
var state_34697__$1 = (function (){var statearr_34715 = state_34697;
(statearr_34715[(13)] = inst_34690);

return statearr_34715;
})();
var statearr_34716_34743 = state_34697__$1;
(statearr_34716_34743[(2)] = inst_34691);

(statearr_34716_34743[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (10))){
var inst_34680 = (state_34697[(2)]);
var state_34697__$1 = state_34697;
var statearr_34717_34744 = state_34697__$1;
(statearr_34717_34744[(2)] = inst_34680);

(statearr_34717_34744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34698 === (8))){
var inst_34665 = (state_34697[(10)]);
var inst_34657 = (state_34697[(7)]);
var inst_34661 = (state_34697[(9)]);
var inst_34670 = inst_34657.push(inst_34661);
var tmp34714 = inst_34657;
var inst_34657__$1 = tmp34714;
var inst_34658 = inst_34665;
var state_34697__$1 = (function (){var statearr_34718 = state_34697;
(statearr_34718[(7)] = inst_34657__$1);

(statearr_34718[(8)] = inst_34658);

(statearr_34718[(14)] = inst_34670);

return statearr_34718;
})();
var statearr_34719_34745 = state_34697__$1;
(statearr_34719_34745[(2)] = null);

(statearr_34719_34745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31906__auto___34731,out))
;
return ((function (switch__31792__auto__,c__31906__auto___34731,out){
return (function() {
var cljs$core$async$state_machine__31793__auto__ = null;
var cljs$core$async$state_machine__31793__auto____0 = (function (){
var statearr_34723 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34723[(0)] = cljs$core$async$state_machine__31793__auto__);

(statearr_34723[(1)] = (1));

return statearr_34723;
});
var cljs$core$async$state_machine__31793__auto____1 = (function (state_34697){
while(true){
var ret_value__31794__auto__ = (function (){try{while(true){
var result__31795__auto__ = switch__31792__auto__.call(null,state_34697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31795__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31795__auto__;
}
break;
}
}catch (e34724){if((e34724 instanceof Object)){
var ex__31796__auto__ = e34724;
var statearr_34725_34746 = state_34697;
(statearr_34725_34746[(5)] = ex__31796__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34697);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34724;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34747 = state_34697;
state_34697 = G__34747;
continue;
} else {
return ret_value__31794__auto__;
}
break;
}
});
cljs$core$async$state_machine__31793__auto__ = function(state_34697){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31793__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31793__auto____1.call(this,state_34697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31793__auto____0;
cljs$core$async$state_machine__31793__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31793__auto____1;
return cljs$core$async$state_machine__31793__auto__;
})()
;})(switch__31792__auto__,c__31906__auto___34731,out))
})();
var state__31908__auto__ = (function (){var statearr_34726 = f__31907__auto__.call(null);
(statearr_34726[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31906__auto___34731);

return statearr_34726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31908__auto__);
});})(c__31906__auto___34731,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map