// Compiled by ClojureScript 1.9.293 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
cljs.core.UUID.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.hash.call(null,this$__$1.toString());
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__30375_30379 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__30376_30380 = null;
var count__30377_30381 = (0);
var i__30378_30382 = (0);
while(true){
if((i__30378_30382 < count__30377_30381)){
var k_30383 = cljs.core._nth.call(null,chunk__30376_30380,i__30378_30382);
var v_30384 = (b[k_30383]);
(a[k_30383] = v_30384);

var G__30385 = seq__30375_30379;
var G__30386 = chunk__30376_30380;
var G__30387 = count__30377_30381;
var G__30388 = (i__30378_30382 + (1));
seq__30375_30379 = G__30385;
chunk__30376_30380 = G__30386;
count__30377_30381 = G__30387;
i__30378_30382 = G__30388;
continue;
} else {
var temp__6747__auto___30389 = cljs.core.seq.call(null,seq__30375_30379);
if(temp__6747__auto___30389){
var seq__30375_30390__$1 = temp__6747__auto___30389;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30375_30390__$1)){
var c__27804__auto___30391 = cljs.core.chunk_first.call(null,seq__30375_30390__$1);
var G__30392 = cljs.core.chunk_rest.call(null,seq__30375_30390__$1);
var G__30393 = c__27804__auto___30391;
var G__30394 = cljs.core.count.call(null,c__27804__auto___30391);
var G__30395 = (0);
seq__30375_30379 = G__30392;
chunk__30376_30380 = G__30393;
count__30377_30381 = G__30394;
i__30378_30382 = G__30395;
continue;
} else {
var k_30396 = cljs.core.first.call(null,seq__30375_30390__$1);
var v_30397 = (b[k_30396]);
(a[k_30396] = v_30397);

var G__30398 = cljs.core.next.call(null,seq__30375_30390__$1);
var G__30399 = null;
var G__30400 = (0);
var G__30401 = (0);
seq__30375_30379 = G__30398;
chunk__30376_30380 = G__30399;
count__30377_30381 = G__30400;
i__30378_30382 = G__30401;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args30402 = [];
var len__28114__auto___30405 = arguments.length;
var i__28115__auto___30406 = (0);
while(true){
if((i__28115__auto___30406 < len__28114__auto___30405)){
args30402.push((arguments[i__28115__auto___30406]));

var G__30407 = (i__28115__auto___30406 + (1));
i__28115__auto___30406 = G__30407;
continue;
} else {
}
break;
}

var G__30404 = args30402.length;
switch (G__30404) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30402.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__30409 = (i + (2));
var G__30410 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__30409;
ret = G__30410;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;

/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__30411_30415 = cljs.core.seq.call(null,v);
var chunk__30412_30416 = null;
var count__30413_30417 = (0);
var i__30414_30418 = (0);
while(true){
if((i__30414_30418 < count__30413_30417)){
var x_30419 = cljs.core._nth.call(null,chunk__30412_30416,i__30414_30418);
ret.push(x_30419);

var G__30420 = seq__30411_30415;
var G__30421 = chunk__30412_30416;
var G__30422 = count__30413_30417;
var G__30423 = (i__30414_30418 + (1));
seq__30411_30415 = G__30420;
chunk__30412_30416 = G__30421;
count__30413_30417 = G__30422;
i__30414_30418 = G__30423;
continue;
} else {
var temp__6747__auto___30424 = cljs.core.seq.call(null,seq__30411_30415);
if(temp__6747__auto___30424){
var seq__30411_30425__$1 = temp__6747__auto___30424;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30411_30425__$1)){
var c__27804__auto___30426 = cljs.core.chunk_first.call(null,seq__30411_30425__$1);
var G__30427 = cljs.core.chunk_rest.call(null,seq__30411_30425__$1);
var G__30428 = c__27804__auto___30426;
var G__30429 = cljs.core.count.call(null,c__27804__auto___30426);
var G__30430 = (0);
seq__30411_30415 = G__30427;
chunk__30412_30416 = G__30428;
count__30413_30417 = G__30429;
i__30414_30418 = G__30430;
continue;
} else {
var x_30431 = cljs.core.first.call(null,seq__30411_30425__$1);
ret.push(x_30431);

var G__30432 = cljs.core.next.call(null,seq__30411_30425__$1);
var G__30433 = null;
var G__30434 = (0);
var G__30435 = (0);
seq__30411_30415 = G__30432;
chunk__30412_30416 = G__30433;
count__30413_30417 = G__30434;
i__30414_30418 = G__30435;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__30436_30440 = cljs.core.seq.call(null,v);
var chunk__30437_30441 = null;
var count__30438_30442 = (0);
var i__30439_30443 = (0);
while(true){
if((i__30439_30443 < count__30438_30442)){
var x_30444 = cljs.core._nth.call(null,chunk__30437_30441,i__30439_30443);
ret.push(x_30444);

var G__30445 = seq__30436_30440;
var G__30446 = chunk__30437_30441;
var G__30447 = count__30438_30442;
var G__30448 = (i__30439_30443 + (1));
seq__30436_30440 = G__30445;
chunk__30437_30441 = G__30446;
count__30438_30442 = G__30447;
i__30439_30443 = G__30448;
continue;
} else {
var temp__6747__auto___30449 = cljs.core.seq.call(null,seq__30436_30440);
if(temp__6747__auto___30449){
var seq__30436_30450__$1 = temp__6747__auto___30449;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30436_30450__$1)){
var c__27804__auto___30451 = cljs.core.chunk_first.call(null,seq__30436_30450__$1);
var G__30452 = cljs.core.chunk_rest.call(null,seq__30436_30450__$1);
var G__30453 = c__27804__auto___30451;
var G__30454 = cljs.core.count.call(null,c__27804__auto___30451);
var G__30455 = (0);
seq__30436_30440 = G__30452;
chunk__30437_30441 = G__30453;
count__30438_30442 = G__30454;
i__30439_30443 = G__30455;
continue;
} else {
var x_30456 = cljs.core.first.call(null,seq__30436_30450__$1);
ret.push(x_30456);

var G__30457 = cljs.core.next.call(null,seq__30436_30450__$1);
var G__30458 = null;
var G__30459 = (0);
var G__30460 = (0);
seq__30436_30440 = G__30457;
chunk__30437_30441 = G__30458;
count__30438_30442 = G__30459;
i__30439_30443 = G__30460;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__30461_30465 = cljs.core.seq.call(null,v);
var chunk__30462_30466 = null;
var count__30463_30467 = (0);
var i__30464_30468 = (0);
while(true){
if((i__30464_30468 < count__30463_30467)){
var x_30469 = cljs.core._nth.call(null,chunk__30462_30466,i__30464_30468);
ret.push(x_30469);

var G__30470 = seq__30461_30465;
var G__30471 = chunk__30462_30466;
var G__30472 = count__30463_30467;
var G__30473 = (i__30464_30468 + (1));
seq__30461_30465 = G__30470;
chunk__30462_30466 = G__30471;
count__30463_30467 = G__30472;
i__30464_30468 = G__30473;
continue;
} else {
var temp__6747__auto___30474 = cljs.core.seq.call(null,seq__30461_30465);
if(temp__6747__auto___30474){
var seq__30461_30475__$1 = temp__6747__auto___30474;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30461_30475__$1)){
var c__27804__auto___30476 = cljs.core.chunk_first.call(null,seq__30461_30475__$1);
var G__30477 = cljs.core.chunk_rest.call(null,seq__30461_30475__$1);
var G__30478 = c__27804__auto___30476;
var G__30479 = cljs.core.count.call(null,c__27804__auto___30476);
var G__30480 = (0);
seq__30461_30465 = G__30477;
chunk__30462_30466 = G__30478;
count__30463_30467 = G__30479;
i__30464_30468 = G__30480;
continue;
} else {
var x_30481 = cljs.core.first.call(null,seq__30461_30475__$1);
ret.push(x_30481);

var G__30482 = cljs.core.next.call(null,seq__30461_30475__$1);
var G__30483 = null;
var G__30484 = (0);
var G__30485 = (0);
seq__30461_30465 = G__30482;
chunk__30462_30466 = G__30483;
count__30463_30467 = G__30484;
i__30464_30468 = G__30485;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args30486 = [];
var len__28114__auto___30501 = arguments.length;
var i__28115__auto___30502 = (0);
while(true){
if((i__28115__auto___30502 < len__28114__auto___30501)){
args30486.push((arguments[i__28115__auto___30502]));

var G__30503 = (i__28115__auto___30502 + (1));
i__28115__auto___30502 = G__30503;
continue;
} else {
}
break;
}

var G__30488 = args30486.length;
switch (G__30488) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30486.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__30489 = obj;
G__30489.push(kfn.call(null,k),vfn.call(null,v));

return G__30489;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x30490 = cljs.core.clone.call(null,handlers);
x30490.forEach = ((function (x30490,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__30491 = cljs.core.seq.call(null,coll);
var chunk__30492 = null;
var count__30493 = (0);
var i__30494 = (0);
while(true){
if((i__30494 < count__30493)){
var vec__30495 = cljs.core._nth.call(null,chunk__30492,i__30494);
var k = cljs.core.nth.call(null,vec__30495,(0),null);
var v = cljs.core.nth.call(null,vec__30495,(1),null);
f.call(null,v,k);

var G__30505 = seq__30491;
var G__30506 = chunk__30492;
var G__30507 = count__30493;
var G__30508 = (i__30494 + (1));
seq__30491 = G__30505;
chunk__30492 = G__30506;
count__30493 = G__30507;
i__30494 = G__30508;
continue;
} else {
var temp__6747__auto__ = cljs.core.seq.call(null,seq__30491);
if(temp__6747__auto__){
var seq__30491__$1 = temp__6747__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30491__$1)){
var c__27804__auto__ = cljs.core.chunk_first.call(null,seq__30491__$1);
var G__30509 = cljs.core.chunk_rest.call(null,seq__30491__$1);
var G__30510 = c__27804__auto__;
var G__30511 = cljs.core.count.call(null,c__27804__auto__);
var G__30512 = (0);
seq__30491 = G__30509;
chunk__30492 = G__30510;
count__30493 = G__30511;
i__30494 = G__30512;
continue;
} else {
var vec__30498 = cljs.core.first.call(null,seq__30491__$1);
var k = cljs.core.nth.call(null,vec__30498,(0),null);
var v = cljs.core.nth.call(null,vec__30498,(1),null);
f.call(null,v,k);

var G__30513 = cljs.core.next.call(null,seq__30491__$1);
var G__30514 = null;
var G__30515 = (0);
var G__30516 = (0);
seq__30491 = G__30513;
chunk__30492 = G__30514;
count__30493 = G__30515;
i__30494 = G__30516;
continue;
}
} else {
return null;
}
}
break;
}
});})(x30490,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x30490;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;

/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args30517 = [];
var len__28114__auto___30523 = arguments.length;
var i__28115__auto___30524 = (0);
while(true){
if((i__28115__auto___30524 < len__28114__auto___30523)){
args30517.push((arguments[i__28115__auto___30524]));

var G__30525 = (i__28115__auto___30524 + (1));
i__28115__auto___30524 = G__30525;
continue;
} else {
}
break;
}

var G__30519 = args30517.length;
switch (G__30519) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30517.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit30520 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit30520 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta30521){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta30521 = meta30521;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t_cognitect$transit30520.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30522,meta30521__$1){
var self__ = this;
var _30522__$1 = this;
return (new cognitect.transit.t_cognitect$transit30520(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta30521__$1));
});

cognitect.transit.t_cognitect$transit30520.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30522){
var self__ = this;
var _30522__$1 = this;
return self__.meta30521;
});

cognitect.transit.t_cognitect$transit30520.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit30520.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit30520.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit30520.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit30520.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta30521","meta30521",-324920850,null)], null);
});

cognitect.transit.t_cognitect$transit30520.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit30520.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit30520";

cognitect.transit.t_cognitect$transit30520.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/t_cognitect$transit30520");
});

cognitect.transit.__GT_t_cognitect$transit30520 = (function cognitect$transit$__GT_t_cognitect$transit30520(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta30521){
return (new cognitect.transit.t_cognitect$transit30520(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta30521));
});

}

return (new cognitect.transit.t_cognitect$transit30520(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;

/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__26898__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map