// Compiled by ClojureScript 1.9.293 {}
goog.provide('imcljs.path');
goog.require('cljs.core');
goog.require('imcljs.internal.utils');
goog.require('clojure.string');
/**
 * Split a string path into a vector of keywords.
 *   (split-path `Gene.organism.shortName`)
 *   => [:Gene :organism :shortName]
 */
imcljs.path.split_path = (function imcljs$path$split_path(path_str){
return cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,path_str,/\./));
});
/**
 * Join a vector path of keywords to a string.
 *   (join-path [:Gene :organism :shortName])
 *   => Gene.organism.shortName
 */
imcljs.path.join_path = (function imcljs$path$join_path(path_str){
return clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.core.name,path_str));
});
/**
 * Given a model and a class, return its attributes, references and collections.
 */
imcljs.path.properties = (function imcljs$path$properties(model,class_kw){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_type = (function imcljs$path$referenced_type(model,field_kw,class_kw){
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw)));
});
/**
 * Given a model, a reference/collection, and a class,
 *   return the superclass of the reference/collection.
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.referenced_class = (function imcljs$path$referenced_class(model,field_kw,class_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_type,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__28180){
var vec__28181 = p__28180;
var _ = cljs.core.nth.call(null,vec__28181,(0),null);
var map__28184 = cljs.core.nth.call(null,vec__28181,(1),null);
var map__28184__$1 = ((((!((map__28184 == null)))?((((map__28184.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28184.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28184):map__28184);
var extends$ = cljs.core.get.call(null,map__28184__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_values = (function imcljs$path$referenced_values(model,field_kw,class_kw){
return cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw);
});
/**
 * Given a model and a field, return that field from the data model.
 *   A field can be a reference, a collection, or an attribute
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.class_value = (function imcljs$path$class_value(model,class_kw,field_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_values,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__28192){
var vec__28193 = p__28192;
var _ = cljs.core.nth.call(null,vec__28193,(0),null);
var map__28196 = cljs.core.nth.call(null,vec__28193,(1),null);
var map__28196__$1 = ((((!((map__28196 == null)))?((((map__28196.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28196.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28196):map__28196);
var extends$ = cljs.core.get.call(null,map__28196__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Return a vector representing each part of path.
 *   If any part of the path is unresolvable then a nil is returned.
 *   (walk im-model `Gene.organism.shortName`)
 *   => [{:name `Gene`, :collections {...}, :attributes {...}}
 *    {:name `Organism`, :collections {...} :attributes {...}
 *    {:name `shortName`, :type `java.lang.String`}]
 */
imcljs.path.walk = (function imcljs$path$walk(var_args){
var args28198 = [];
var len__28114__auto___28208 = arguments.length;
var i__28115__auto___28209 = (0);
while(true){
if((i__28115__auto___28209 < len__28114__auto___28208)){
args28198.push((arguments[i__28115__auto___28209]));

var G__28210 = (i__28115__auto___28209 + (1));
i__28115__auto___28209 = G__28210;
continue;
} else {
}
break;
}

var G__28200 = args28198.length;
switch (G__28200) {
case 2:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28198.length)].join('')));

}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):path);
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,p))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p)], null))], null);
} else {
return imcljs.path.walk.call(null,model,p,cljs.core.PersistentVector.EMPTY);
}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$3 = (function (model,p__28201,trail){
while(true){
var vec__28202 = p__28201;
var seq__28203 = cljs.core.seq.call(null,vec__28202);
var first__28204 = cljs.core.first.call(null,seq__28203);
var seq__28203__$1 = cljs.core.next.call(null,seq__28203);
var class_kw = first__28204;
var vec__28205 = seq__28203__$1;
var seq__28206 = cljs.core.seq.call(null,vec__28205);
var first__28207 = cljs.core.first.call(null,seq__28206);
var seq__28206__$1 = cljs.core.next.call(null,seq__28206);
var path = first__28207;
var remaining = seq__28206__$1;
var cv = imcljs.path.class_value.call(null,model,class_kw,path);
if(remaining){
if(cljs.core.contains_QMARK_.call(null,cv,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030))){
var G__28212 = model;
var G__28213 = cljs.core.cons.call(null,cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cv)),remaining);
var G__28214 = cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)));
model = G__28212;
p__28201 = G__28213;
trail = G__28214;
continue;
} else {
return null;
}
} else {
return cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),((cljs.core.contains_QMARK_.call(null,cv,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030)))?cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cv))], null)):cv));
}
break;
}
});

imcljs.path.walk.cljs$lang$maxFixedArity = 3;

/**
 * Return the java type of a path representing an attribute.
 *   (attribute-type im-model `Gene.organism.shortName`)
 *   => java.lang.String
 */
imcljs.path.data_type = (function imcljs$path$data_type(model,path){
return new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,imcljs.path.walk.call(null,model,path)));
});
/**
 * Returns the class represented by the path.
 *   (class im-model `Gene.homologues.homologue.symbol`)
 *   => :Gene
 */
imcljs.path.class$ = (function imcljs$path$class(model,path){
var l = cljs.core.last.call(null,cljs.core.take_while.call(null,(function (p1__28215_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__28215_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path)));
return cljs.core.keyword.call(null,(function (){var or__26898__auto__ = new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(l);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(l));
}
})());
});
/**
 * Returns all relationships (references and collections) for a given string path.
 */
imcljs.path.relationships = (function imcljs$path$relationships(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
imcljs.path.mapify = (function imcljs$path$mapify(coll){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,coll);
});
/**
 * Returns a vector of friendly names representing the path
 *   ; TODO make this work with subclasses
 */
imcljs.path.display_name = (function imcljs$path$display_name(var_args){
var args28216 = [];
var len__28114__auto___28223 = arguments.length;
var i__28115__auto___28224 = (0);
while(true){
if((i__28115__auto___28224 < len__28114__auto___28223)){
args28216.push((arguments[i__28115__auto___28224]));

var G__28225 = (i__28115__auto___28224 + (1));
i__28115__auto___28224 = G__28225;
continue;
} else {
}
break;
}

var G__28218 = args28216.length;
switch (G__28218) {
case 2:
return imcljs.path.display_name.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.display_name.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28216.length)].join('')));

}
});

imcljs.path.display_name.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):path);
return imcljs.path.display_name.call(null,model,p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p),new cljs.core.Keyword(null,"displayName","displayName",-809144601)], null))], null));
});

imcljs.path.display_name.cljs$core$IFn$_invoke$arity$3 = (function (model,p__28219,collected){
while(true){
var vec__28220 = p__28219;
var seq__28221 = cljs.core.seq.call(null,vec__28220);
var first__28222 = cljs.core.first.call(null,seq__28221);
var seq__28221__$1 = cljs.core.next.call(null,seq__28221);
var head = first__28222;
var first__28222__$1 = cljs.core.first.call(null,seq__28221__$1);
var seq__28221__$2 = cljs.core.next.call(null,seq__28221__$1);
var next = first__28222__$1;
var tail = seq__28221__$2;
if(cljs.core.truth_(next)){
var props = imcljs.path.mapify.call(null,cljs.core.vals.call(null,cljs.core.select_keys.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),head], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null))));
var collected_and_this = cljs.core.conj.call(null,collected,cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"displayName","displayName",-809144601)], null)));
if(cljs.core.truth_(cljs.core.not_empty.call(null,tail))){
var G__28227 = model;
var G__28228 = cljs.core.conj.call(null,tail,cljs.core.keyword.call(null,cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030)], null))));
var G__28229 = collected_and_this;
model = G__28227;
p__28219 = G__28228;
collected = G__28229;
continue;
} else {
return collected_and_this;
}
} else {
return null;
}
break;
}
});

imcljs.path.display_name.cljs$lang$maxFixedArity = 3;

/**
 * Returns all attributes for a given string path.
 */
imcljs.path.attributes = (function imcljs$path$attributes(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604)], null)));
});
/**
 * Returns true if path is a class.
 *   (class im-model `Gene.diseases`)
 *   => true
 *   (class im-model `Gene.diseases.name`)
 *   => false
 */
imcljs.path.class_QMARK_ = (function imcljs$path$class_QMARK_(model,path){
var walked = imcljs.path.walk.call(null,model,path);
return !(cljs.core.contains_QMARK_.call(null,cljs.core.last.call(null,walked),new cljs.core.Keyword(null,"type","type",1174270348)));
});
/**
 * Returns a path string trimmed to the last class
 *   (trim-to-last-class im-model `Gene.homologues.homologue.symbol`)
 *   => Gene.homologues.homologue
 */
imcljs.path.trim_to_last_class = (function imcljs$path$trim_to_last_class(model,path){
var done = cljs.core.take_while.call(null,(function (p1__28230_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__28230_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path));
return imcljs.path.join_path.call(null,cljs.core.take.call(null,cljs.core.count.call(null,done),imcljs.path.split_path.call(null,path)));
});
/**
 * Returns a path adjusted to its last class
 *   (adjust-path-to-last-class im-model `Gene.organism.name`)
 *   => Organism.name
 */
imcljs.path.adjust_path_to_last_class = (function imcljs$path$adjust_path_to_last_class(model,path){
var attribute_QMARK_ = cljs.core.not.call(null,imcljs.path.class_QMARK_.call(null,model,path));
var walked = cljs.core.reverse.call(null,imcljs.path.walk.call(null,model,path));
if(attribute_QMARK_){
return [cljs.core.str(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(1)))),cljs.core.str("."),cljs.core.str(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))))].join('');
} else {
return [cljs.core.str(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))))].join('');
}
});
/**
 * Returns a path as a strong
 */
imcljs.path.friendly = (function imcljs$path$friendly(var_args){
var args__28121__auto__ = [];
var len__28114__auto___28238 = arguments.length;
var i__28115__auto___28239 = (0);
while(true){
if((i__28115__auto___28239 < len__28114__auto___28238)){
args__28121__auto__.push((arguments[i__28115__auto___28239]));

var G__28240 = (i__28115__auto___28239 + (1));
i__28115__auto___28239 = G__28240;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((2) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((2)),(0),null)):null);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__28122__auto__);
});

imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,p__28234){
var vec__28235 = p__28234;
var exclude_root_QMARK_ = cljs.core.nth.call(null,vec__28235,(0),null);
return cljs.core.reduce.call(null,((function (vec__28235,exclude_root_QMARK_){
return (function (total,next){
return [cljs.core.str(total),cljs.core.str((cljs.core.truth_(total)?" > ":null)),cljs.core.str((function (){var or__26898__auto__ = new cljs.core.Keyword(null,"displayName","displayName",-809144601).cljs$core$IFn$_invoke$arity$1(next);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(next);
}
})())].join('');
});})(vec__28235,exclude_root_QMARK_))
,null,(cljs.core.truth_(exclude_root_QMARK_)?cljs.core.rest.call(null,imcljs.path.walk.call(null,model,path)):imcljs.path.walk.call(null,model,path)));
});

imcljs.path.friendly.cljs$lang$maxFixedArity = (2);

imcljs.path.friendly.cljs$lang$applyTo = (function (seq28231){
var G__28232 = cljs.core.first.call(null,seq28231);
var seq28231__$1 = cljs.core.next.call(null,seq28231);
var G__28233 = cljs.core.first.call(null,seq28231__$1);
var seq28231__$2 = cljs.core.next.call(null,seq28231__$1);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic(G__28232,G__28233,seq28231__$2);
});

imcljs.path.one_of_QMARK_ = (function imcljs$path$one_of_QMARK_(col,value){
return cljs.core.some_QMARK_.call(null,cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([value], true),col));
});
/**
 * Returns subclasses of the class
 */
imcljs.path.subclasses = (function imcljs$path$subclasses(model,path){
var path_class = imcljs.path.class$.call(null,model,path);
return cljs.core.not_empty.call(null,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,((function (path_class){
return (function (p__28245){
var vec__28246 = p__28245;
var _ = cljs.core.nth.call(null,vec__28246,(0),null);
var properties = cljs.core.nth.call(null,vec__28246,(1),null);
return imcljs.path.one_of_QMARK_.call(null,new cljs.core.Keyword(null,"extends","extends",-954903259).cljs$core$IFn$_invoke$arity$1(properties),cljs.core.name.call(null,path_class));
});})(path_class))
,new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model))));
});

//# sourceMappingURL=path.js.map