// Compiled by ClojureScript 1.9.671 {}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement.call(null,cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return !((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),cljs.core.str.cljs$core$IFn$_invoke$arity$1(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.call(null,cljs.core.sorted_set,clojure.string.split.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",(new RegExp(""))));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__35008 = url;
var G__35008__$1 = (cljs.core.truth_(imcljs.internal.utils.missing_http_QMARK__.call(null,url))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1("http://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35008)].join(''):G__35008);
if(cljs.core.truth_(imcljs.internal.utils.missing_service_QMARK__.call(null,url))){
return imcljs.internal.utils.append_.call(null,"/service",G__35008__$1);
} else {
return G__35008__$1;
}
});

//# sourceMappingURL=utils.js.map