// Compiled by ClojureScript 1.9.293 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
cljs.core.UUID.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.hash.call(null,this$__$1.toString());
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__34573_34577 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__34574_34578 = null;
var count__34575_34579 = (0);
var i__34576_34580 = (0);
while(true){
if((i__34576_34580 < count__34575_34579)){
var k_34581 = cljs.core._nth.call(null,chunk__34574_34578,i__34576_34580);
var v_34582 = (b[k_34581]);
(a[k_34581] = v_34582);

var G__34583 = seq__34573_34577;
var G__34584 = chunk__34574_34578;
var G__34585 = count__34575_34579;
var G__34586 = (i__34576_34580 + (1));
seq__34573_34577 = G__34583;
chunk__34574_34578 = G__34584;
count__34575_34579 = G__34585;
i__34576_34580 = G__34586;
continue;
} else {
var temp__6747__auto___34587 = cljs.core.seq.call(null,seq__34573_34577);
if(temp__6747__auto___34587){
var seq__34573_34588__$1 = temp__6747__auto___34587;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34573_34588__$1)){
var c__27804__auto___34589 = cljs.core.chunk_first.call(null,seq__34573_34588__$1);
var G__34590 = cljs.core.chunk_rest.call(null,seq__34573_34588__$1);
var G__34591 = c__27804__auto___34589;
var G__34592 = cljs.core.count.call(null,c__27804__auto___34589);
var G__34593 = (0);
seq__34573_34577 = G__34590;
chunk__34574_34578 = G__34591;
count__34575_34579 = G__34592;
i__34576_34580 = G__34593;
continue;
} else {
var k_34594 = cljs.core.first.call(null,seq__34573_34588__$1);
var v_34595 = (b[k_34594]);
(a[k_34594] = v_34595);

var G__34596 = cljs.core.next.call(null,seq__34573_34588__$1);
var G__34597 = null;
var G__34598 = (0);
var G__34599 = (0);
seq__34573_34577 = G__34596;
chunk__34574_34578 = G__34597;
count__34575_34579 = G__34598;
i__34576_34580 = G__34599;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args34600 = [];
var len__28114__auto___34603 = arguments.length;
var i__28115__auto___34604 = (0);
while(true){
if((i__28115__auto___34604 < len__28114__auto___34603)){
args34600.push((arguments[i__28115__auto___34604]));

var G__34605 = (i__28115__auto___34604 + (1));
i__28115__auto___34604 = G__34605;
continue;
} else {
}
break;
}

var G__34602 = args34600.length;
switch (G__34602) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34600.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__34607 = (i + (2));
var G__34608 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__34607;
ret = G__34608;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;

/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__34609_34613 = cljs.core.seq.call(null,v);
var chunk__34610_34614 = null;
var count__34611_34615 = (0);
var i__34612_34616 = (0);
while(true){
if((i__34612_34616 < count__34611_34615)){
var x_34617 = cljs.core._nth.call(null,chunk__34610_34614,i__34612_34616);
ret.push(x_34617);

var G__34618 = seq__34609_34613;
var G__34619 = chunk__34610_34614;
var G__34620 = count__34611_34615;
var G__34621 = (i__34612_34616 + (1));
seq__34609_34613 = G__34618;
chunk__34610_34614 = G__34619;
count__34611_34615 = G__34620;
i__34612_34616 = G__34621;
continue;
} else {
var temp__6747__auto___34622 = cljs.core.seq.call(null,seq__34609_34613);
if(temp__6747__auto___34622){
var seq__34609_34623__$1 = temp__6747__auto___34622;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34609_34623__$1)){
var c__27804__auto___34624 = cljs.core.chunk_first.call(null,seq__34609_34623__$1);
var G__34625 = cljs.core.chunk_rest.call(null,seq__34609_34623__$1);
var G__34626 = c__27804__auto___34624;
var G__34627 = cljs.core.count.call(null,c__27804__auto___34624);
var G__34628 = (0);
seq__34609_34613 = G__34625;
chunk__34610_34614 = G__34626;
count__34611_34615 = G__34627;
i__34612_34616 = G__34628;
continue;
} else {
var x_34629 = cljs.core.first.call(null,seq__34609_34623__$1);
ret.push(x_34629);

var G__34630 = cljs.core.next.call(null,seq__34609_34623__$1);
var G__34631 = null;
var G__34632 = (0);
var G__34633 = (0);
seq__34609_34613 = G__34630;
chunk__34610_34614 = G__34631;
count__34611_34615 = G__34632;
i__34612_34616 = G__34633;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__34634_34638 = cljs.core.seq.call(null,v);
var chunk__34635_34639 = null;
var count__34636_34640 = (0);
var i__34637_34641 = (0);
while(true){
if((i__34637_34641 < count__34636_34640)){
var x_34642 = cljs.core._nth.call(null,chunk__34635_34639,i__34637_34641);
ret.push(x_34642);

var G__34643 = seq__34634_34638;
var G__34644 = chunk__34635_34639;
var G__34645 = count__34636_34640;
var G__34646 = (i__34637_34641 + (1));
seq__34634_34638 = G__34643;
chunk__34635_34639 = G__34644;
count__34636_34640 = G__34645;
i__34637_34641 = G__34646;
continue;
} else {
var temp__6747__auto___34647 = cljs.core.seq.call(null,seq__34634_34638);
if(temp__6747__auto___34647){
var seq__34634_34648__$1 = temp__6747__auto___34647;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34634_34648__$1)){
var c__27804__auto___34649 = cljs.core.chunk_first.call(null,seq__34634_34648__$1);
var G__34650 = cljs.core.chunk_rest.call(null,seq__34634_34648__$1);
var G__34651 = c__27804__auto___34649;
var G__34652 = cljs.core.count.call(null,c__27804__auto___34649);
var G__34653 = (0);
seq__34634_34638 = G__34650;
chunk__34635_34639 = G__34651;
count__34636_34640 = G__34652;
i__34637_34641 = G__34653;
continue;
} else {
var x_34654 = cljs.core.first.call(null,seq__34634_34648__$1);
ret.push(x_34654);

var G__34655 = cljs.core.next.call(null,seq__34634_34648__$1);
var G__34656 = null;
var G__34657 = (0);
var G__34658 = (0);
seq__34634_34638 = G__34655;
chunk__34635_34639 = G__34656;
count__34636_34640 = G__34657;
i__34637_34641 = G__34658;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__34659_34663 = cljs.core.seq.call(null,v);
var chunk__34660_34664 = null;
var count__34661_34665 = (0);
var i__34662_34666 = (0);
while(true){
if((i__34662_34666 < count__34661_34665)){
var x_34667 = cljs.core._nth.call(null,chunk__34660_34664,i__34662_34666);
ret.push(x_34667);

var G__34668 = seq__34659_34663;
var G__34669 = chunk__34660_34664;
var G__34670 = count__34661_34665;
var G__34671 = (i__34662_34666 + (1));
seq__34659_34663 = G__34668;
chunk__34660_34664 = G__34669;
count__34661_34665 = G__34670;
i__34662_34666 = G__34671;
continue;
} else {
var temp__6747__auto___34672 = cljs.core.seq.call(null,seq__34659_34663);
if(temp__6747__auto___34672){
var seq__34659_34673__$1 = temp__6747__auto___34672;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34659_34673__$1)){
var c__27804__auto___34674 = cljs.core.chunk_first.call(null,seq__34659_34673__$1);
var G__34675 = cljs.core.chunk_rest.call(null,seq__34659_34673__$1);
var G__34676 = c__27804__auto___34674;
var G__34677 = cljs.core.count.call(null,c__27804__auto___34674);
var G__34678 = (0);
seq__34659_34663 = G__34675;
chunk__34660_34664 = G__34676;
count__34661_34665 = G__34677;
i__34662_34666 = G__34678;
continue;
} else {
var x_34679 = cljs.core.first.call(null,seq__34659_34673__$1);
ret.push(x_34679);

var G__34680 = cljs.core.next.call(null,seq__34659_34673__$1);
var G__34681 = null;
var G__34682 = (0);
var G__34683 = (0);
seq__34659_34663 = G__34680;
chunk__34660_34664 = G__34681;
count__34661_34665 = G__34682;
i__34662_34666 = G__34683;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args34684 = [];
var len__28114__auto___34699 = arguments.length;
var i__28115__auto___34700 = (0);
while(true){
if((i__28115__auto___34700 < len__28114__auto___34699)){
args34684.push((arguments[i__28115__auto___34700]));

var G__34701 = (i__28115__auto___34700 + (1));
i__28115__auto___34700 = G__34701;
continue;
} else {
}
break;
}

var G__34686 = args34684.length;
switch (G__34686) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34684.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__34687 = obj;
G__34687.push(kfn.call(null,k),vfn.call(null,v));

return G__34687;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x34688 = cljs.core.clone.call(null,handlers);
x34688.forEach = ((function (x34688,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__34689 = cljs.core.seq.call(null,coll);
var chunk__34690 = null;
var count__34691 = (0);
var i__34692 = (0);
while(true){
if((i__34692 < count__34691)){
var vec__34693 = cljs.core._nth.call(null,chunk__34690,i__34692);
var k = cljs.core.nth.call(null,vec__34693,(0),null);
var v = cljs.core.nth.call(null,vec__34693,(1),null);
f.call(null,v,k);

var G__34703 = seq__34689;
var G__34704 = chunk__34690;
var G__34705 = count__34691;
var G__34706 = (i__34692 + (1));
seq__34689 = G__34703;
chunk__34690 = G__34704;
count__34691 = G__34705;
i__34692 = G__34706;
continue;
} else {
var temp__6747__auto__ = cljs.core.seq.call(null,seq__34689);
if(temp__6747__auto__){
var seq__34689__$1 = temp__6747__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34689__$1)){
var c__27804__auto__ = cljs.core.chunk_first.call(null,seq__34689__$1);
var G__34707 = cljs.core.chunk_rest.call(null,seq__34689__$1);
var G__34708 = c__27804__auto__;
var G__34709 = cljs.core.count.call(null,c__27804__auto__);
var G__34710 = (0);
seq__34689 = G__34707;
chunk__34690 = G__34708;
count__34691 = G__34709;
i__34692 = G__34710;
continue;
} else {
var vec__34696 = cljs.core.first.call(null,seq__34689__$1);
var k = cljs.core.nth.call(null,vec__34696,(0),null);
var v = cljs.core.nth.call(null,vec__34696,(1),null);
f.call(null,v,k);

var G__34711 = cljs.core.next.call(null,seq__34689__$1);
var G__34712 = null;
var G__34713 = (0);
var G__34714 = (0);
seq__34689 = G__34711;
chunk__34690 = G__34712;
count__34691 = G__34713;
i__34692 = G__34714;
continue;
}
} else {
return null;
}
}
break;
}
});})(x34688,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x34688;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;

/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args34715 = [];
var len__28114__auto___34721 = arguments.length;
var i__28115__auto___34722 = (0);
while(true){
if((i__28115__auto___34722 < len__28114__auto___34721)){
args34715.push((arguments[i__28115__auto___34722]));

var G__34723 = (i__28115__auto___34722 + (1));
i__28115__auto___34722 = G__34723;
continue;
} else {
}
break;
}

var G__34717 = args34715.length;
switch (G__34717) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34715.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit34718 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit34718 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta34719){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta34719 = meta34719;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t_cognitect$transit34718.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34720,meta34719__$1){
var self__ = this;
var _34720__$1 = this;
return (new cognitect.transit.t_cognitect$transit34718(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta34719__$1));
});

cognitect.transit.t_cognitect$transit34718.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34720){
var self__ = this;
var _34720__$1 = this;
return self__.meta34719;
});

cognitect.transit.t_cognitect$transit34718.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit34718.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit34718.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit34718.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit34718.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta34719","meta34719",-627202168,null)], null);
});

cognitect.transit.t_cognitect$transit34718.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit34718.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit34718";

cognitect.transit.t_cognitect$transit34718.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cognitect.transit/t_cognitect$transit34718");
});

cognitect.transit.__GT_t_cognitect$transit34718 = (function cognitect$transit$__GT_t_cognitect$transit34718(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta34719){
return (new cognitect.transit.t_cognitect$transit34718(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta34719));
});

}

return (new cognitect.transit.t_cognitect$transit34718(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;

/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__26898__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map