// Compiled by ClojureScript 1.9.671 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__28621__auto__ = v;
if(cljs.core.truth_(and__28621__auto__)){
return (v > (0));
} else {
return and__28621__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__35473_SHARP_,p2__35472_SHARP_){
var vec__35474 = clojure.string.split.call(null,p2__35472_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__35474,(0),null);
var v = cljs.core.nth.call(null,vec__35474,(1),null);
return cljs.core.assoc.call(null,p1__35473_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__35477_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__35477_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__35478){
var vec__35479 = p__35478;
var k = cljs.core.nth.call(null,vec__35479,(0),null);
var v = cljs.core.nth.call(null,vec__35479,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__35482_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35482_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__28621__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__28621__auto__){
var and__28621__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__28621__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("(?i)"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__28621__auto____$1;
}
} else {
return and__28621__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__5276__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5276__auto__)){
var params = temp__5276__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__35483_SHARP_){
return cljs_http.client.decode_body.call(null,p1__35483_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35490 = arguments.length;
var i__29867__auto___35491 = (0);
while(true){
if((i__29867__auto___35491 < len__29866__auto___35490)){
args__29873__auto__.push((arguments[i__29867__auto___35491]));

var G__35492 = (i__29867__auto___35491 + (1));
i__29867__auto___35491 = G__35492;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35486){
var vec__35487 = p__35486;
var default_headers = cljs.core.nth.call(null,vec__35487,(0),null);
return ((function (vec__35487,default_headers){
return (function (request){
var temp__5276__auto__ = (function (){var or__28633__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__5276__auto__)){
var default_headers__$1 = temp__5276__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__35487,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq35484){
var G__35485 = cljs.core.first.call(null,seq35484);
var seq35484__$1 = cljs.core.next.call(null,seq35484);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__35485,seq35484__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35499 = arguments.length;
var i__29867__auto___35500 = (0);
while(true){
if((i__29867__auto___35500 < len__29866__auto___35499)){
args__29873__auto__.push((arguments[i__29867__auto___35500]));

var G__35501 = (i__29867__auto___35500 + (1));
i__29867__auto___35500 = G__35501;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35495){
var vec__35496 = p__35495;
var accept = cljs.core.nth.call(null,vec__35496,(0),null);
return ((function (vec__35496,accept){
return (function (request){
var temp__5276__auto__ = (function (){var or__28633__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__5276__auto__)){
var accept__$1 = temp__5276__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__35496,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq35493){
var G__35494 = cljs.core.first.call(null,seq35493);
var seq35493__$1 = cljs.core.next.call(null,seq35493);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__35494,seq35493__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35508 = arguments.length;
var i__29867__auto___35509 = (0);
while(true){
if((i__29867__auto___35509 < len__29866__auto___35508)){
args__29873__auto__.push((arguments[i__29867__auto___35509]));

var G__35510 = (i__29867__auto___35509 + (1));
i__29867__auto___35509 = G__35510;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35504){
var vec__35505 = p__35504;
var content_type = cljs.core.nth.call(null,vec__35505,(0),null);
return ((function (vec__35505,content_type){
return (function (request){
var temp__5276__auto__ = (function (){var or__28633__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__5276__auto__)){
var content_type__$1 = temp__5276__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__35505,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq35502){
var G__35503 = cljs.core.first.call(null,seq35502);
var seq35502__$1 = cljs.core.next.call(null,seq35502);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__35503,seq35502__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__5276__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5276__auto__)){
var params = temp__5276__auto__;
var map__35511 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__35511__$1 = ((((!((map__35511 == null)))?((((map__35511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35511.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35511):map__35511);
var encoding = cljs.core.get.call(null,map__35511__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__35511__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__35515 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__35515__$1 = ((((!((map__35515 == null)))?((((map__35515.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35515.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35515):map__35515);
var decoding = cljs.core.get.call(null,map__35515__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__35515__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__35515,map__35515__$1,decoding,decoding_opts){
return (function (p1__35513_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__35513_SHARP_,decoding,decoding_opts);
});})(map__35515,map__35515__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__35515,map__35515__$1,decoding,decoding_opts,transit_decode){
return (function (p1__35514_SHARP_){
return cljs_http.client.decode_body.call(null,p1__35514_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__35515,map__35515__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__5276__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5276__auto__)){
var params = temp__5276__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__35517_SHARP_){
return cljs_http.client.decode_body.call(null,p1__35517_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__35518){
var map__35519 = p__35518;
var map__35519__$1 = ((((!((map__35519 == null)))?((((map__35519.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35519.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35519):map__35519);
var req = map__35519__$1;
var query_params = cljs.core.get.call(null,map__35519__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__35521){
var map__35522 = p__35521;
var map__35522__$1 = ((((!((map__35522 == null)))?((((map__35522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35522.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35522):map__35522);
var request = map__35522__$1;
var form_params = cljs.core.get.call(null,map__35522__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__35522__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__35522__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__28621__auto__ = form_params;
if(cljs.core.truth_(and__28621__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__28621__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__35524_35534 = cljs.core.seq.call(null,params);
var chunk__35525_35535 = null;
var count__35526_35536 = (0);
var i__35527_35537 = (0);
while(true){
if((i__35527_35537 < count__35526_35536)){
var vec__35528_35538 = cljs.core._nth.call(null,chunk__35525_35535,i__35527_35537);
var k_35539 = cljs.core.nth.call(null,vec__35528_35538,(0),null);
var v_35540 = cljs.core.nth.call(null,vec__35528_35538,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_35540)){
form_data.append(cljs.core.name.call(null,k_35539),cljs.core.first.call(null,v_35540),cljs.core.second.call(null,v_35540));
} else {
form_data.append(cljs.core.name.call(null,k_35539),v_35540);
}

var G__35541 = seq__35524_35534;
var G__35542 = chunk__35525_35535;
var G__35543 = count__35526_35536;
var G__35544 = (i__35527_35537 + (1));
seq__35524_35534 = G__35541;
chunk__35525_35535 = G__35542;
count__35526_35536 = G__35543;
i__35527_35537 = G__35544;
continue;
} else {
var temp__5278__auto___35545 = cljs.core.seq.call(null,seq__35524_35534);
if(temp__5278__auto___35545){
var seq__35524_35546__$1 = temp__5278__auto___35545;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35524_35546__$1)){
var c__29545__auto___35547 = cljs.core.chunk_first.call(null,seq__35524_35546__$1);
var G__35548 = cljs.core.chunk_rest.call(null,seq__35524_35546__$1);
var G__35549 = c__29545__auto___35547;
var G__35550 = cljs.core.count.call(null,c__29545__auto___35547);
var G__35551 = (0);
seq__35524_35534 = G__35548;
chunk__35525_35535 = G__35549;
count__35526_35536 = G__35550;
i__35527_35537 = G__35551;
continue;
} else {
var vec__35531_35552 = cljs.core.first.call(null,seq__35524_35546__$1);
var k_35553 = cljs.core.nth.call(null,vec__35531_35552,(0),null);
var v_35554 = cljs.core.nth.call(null,vec__35531_35552,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_35554)){
form_data.append(cljs.core.name.call(null,k_35553),cljs.core.first.call(null,v_35554),cljs.core.second.call(null,v_35554));
} else {
form_data.append(cljs.core.name.call(null,k_35553),v_35554);
}

var G__35555 = cljs.core.next.call(null,seq__35524_35546__$1);
var G__35556 = null;
var G__35557 = (0);
var G__35558 = (0);
seq__35524_35534 = G__35555;
chunk__35525_35535 = G__35556;
count__35526_35536 = G__35557;
i__35527_35537 = G__35558;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__35559){
var map__35560 = p__35559;
var map__35560__$1 = ((((!((map__35560 == null)))?((((map__35560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35560.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35560):map__35560);
var request = map__35560__$1;
var multipart_params = cljs.core.get.call(null,map__35560__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__35560__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__28621__auto__ = multipart_params;
if(cljs.core.truth_(and__28621__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__28621__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__5276__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__5276__auto__)){
var m = temp__5276__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__35562_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__35562_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__35564){
var map__35565 = p__35564;
var map__35565__$1 = ((((!((map__35565 == null)))?((((map__35565.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35565.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35565):map__35565);
var req = map__35565__$1;
var query_params = cljs.core.get.call(null,map__35565__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__5276__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__5276__auto__)){
var spec = temp__5276__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__5276__auto__,map__35565,map__35565__$1,req,query_params){
return (function (p1__35563_SHARP_){
return cljs.core.merge.call(null,p1__35563_SHARP_,query_params);
});})(spec,temp__5276__auto__,map__35565,map__35565__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35573 = arguments.length;
var i__29867__auto___35574 = (0);
while(true){
if((i__29867__auto___35574 < len__29866__auto___35573)){
args__29873__auto__.push((arguments[i__29867__auto___35574]));

var G__35575 = (i__29867__auto___35574 + (1));
i__29867__auto___35574 = G__35575;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35569){
var vec__35570 = p__35569;
var credentials = cljs.core.nth.call(null,vec__35570,(0),null);
return ((function (vec__35570,credentials){
return (function (req){
var credentials__$1 = (function (){var or__28633__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__35570,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq35567){
var G__35568 = cljs.core.first.call(null,seq35567);
var seq35567__$1 = cljs.core.next.call(null,seq35567);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__35568,seq35567__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__5276__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__5276__auto__)){
var oauth_token = temp__5276__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Bearer "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__5276__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5276__auto__)){
var custom_channel = temp__5276__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35582 = arguments.length;
var i__29867__auto___35583 = (0);
while(true){
if((i__29867__auto___35583 < len__29866__auto___35582)){
args__29873__auto__.push((arguments[i__29867__auto___35583]));

var G__35584 = (i__29867__auto___35583 + (1));
i__29867__auto___35583 = G__35584;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35578){
var vec__35579 = p__35578;
var req = cljs.core.nth.call(null,vec__35579,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq35576){
var G__35577 = cljs.core.first.call(null,seq35576);
var seq35576__$1 = cljs.core.next.call(null,seq35576);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__35577,seq35576__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35591 = arguments.length;
var i__29867__auto___35592 = (0);
while(true){
if((i__29867__auto___35592 < len__29866__auto___35591)){
args__29873__auto__.push((arguments[i__29867__auto___35592]));

var G__35593 = (i__29867__auto___35592 + (1));
i__29867__auto___35592 = G__35593;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35587){
var vec__35588 = p__35587;
var req = cljs.core.nth.call(null,vec__35588,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq35585){
var G__35586 = cljs.core.first.call(null,seq35585);
var seq35585__$1 = cljs.core.next.call(null,seq35585);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__35586,seq35585__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35600 = arguments.length;
var i__29867__auto___35601 = (0);
while(true){
if((i__29867__auto___35601 < len__29866__auto___35600)){
args__29873__auto__.push((arguments[i__29867__auto___35601]));

var G__35602 = (i__29867__auto___35601 + (1));
i__29867__auto___35601 = G__35602;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35596){
var vec__35597 = p__35596;
var req = cljs.core.nth.call(null,vec__35597,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq35594){
var G__35595 = cljs.core.first.call(null,seq35594);
var seq35594__$1 = cljs.core.next.call(null,seq35594);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__35595,seq35594__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35609 = arguments.length;
var i__29867__auto___35610 = (0);
while(true){
if((i__29867__auto___35610 < len__29866__auto___35609)){
args__29873__auto__.push((arguments[i__29867__auto___35610]));

var G__35611 = (i__29867__auto___35610 + (1));
i__29867__auto___35610 = G__35611;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35605){
var vec__35606 = p__35605;
var req = cljs.core.nth.call(null,vec__35606,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq35603){
var G__35604 = cljs.core.first.call(null,seq35603);
var seq35603__$1 = cljs.core.next.call(null,seq35603);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__35604,seq35603__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35618 = arguments.length;
var i__29867__auto___35619 = (0);
while(true){
if((i__29867__auto___35619 < len__29866__auto___35618)){
args__29873__auto__.push((arguments[i__29867__auto___35619]));

var G__35620 = (i__29867__auto___35619 + (1));
i__29867__auto___35619 = G__35620;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35614){
var vec__35615 = p__35614;
var req = cljs.core.nth.call(null,vec__35615,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq35612){
var G__35613 = cljs.core.first.call(null,seq35612);
var seq35612__$1 = cljs.core.next.call(null,seq35612);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__35613,seq35612__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35627 = arguments.length;
var i__29867__auto___35628 = (0);
while(true){
if((i__29867__auto___35628 < len__29866__auto___35627)){
args__29873__auto__.push((arguments[i__29867__auto___35628]));

var G__35629 = (i__29867__auto___35628 + (1));
i__29867__auto___35628 = G__35629;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35623){
var vec__35624 = p__35623;
var req = cljs.core.nth.call(null,vec__35624,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq35621){
var G__35622 = cljs.core.first.call(null,seq35621);
var seq35621__$1 = cljs.core.next.call(null,seq35621);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__35622,seq35621__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35636 = arguments.length;
var i__29867__auto___35637 = (0);
while(true){
if((i__29867__auto___35637 < len__29866__auto___35636)){
args__29873__auto__.push((arguments[i__29867__auto___35637]));

var G__35638 = (i__29867__auto___35637 + (1));
i__29867__auto___35637 = G__35638;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35632){
var vec__35633 = p__35632;
var req = cljs.core.nth.call(null,vec__35633,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq35630){
var G__35631 = cljs.core.first.call(null,seq35630);
var seq35630__$1 = cljs.core.next.call(null,seq35630);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__35631,seq35630__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35645 = arguments.length;
var i__29867__auto___35646 = (0);
while(true){
if((i__29867__auto___35646 < len__29866__auto___35645)){
args__29873__auto__.push((arguments[i__29867__auto___35646]));

var G__35647 = (i__29867__auto___35646 + (1));
i__29867__auto___35646 = G__35647;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35641){
var vec__35642 = p__35641;
var req = cljs.core.nth.call(null,vec__35642,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq35639){
var G__35640 = cljs.core.first.call(null,seq35639);
var seq35639__$1 = cljs.core.next.call(null,seq35639);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__35640,seq35639__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__29873__auto__ = [];
var len__29866__auto___35654 = arguments.length;
var i__29867__auto___35655 = (0);
while(true){
if((i__29867__auto___35655 < len__29866__auto___35654)){
args__29873__auto__.push((arguments[i__29867__auto___35655]));

var G__35656 = (i__29867__auto___35655 + (1));
i__29867__auto___35655 = G__35656;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35650){
var vec__35651 = p__35650;
var req = cljs.core.nth.call(null,vec__35651,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq35648){
var G__35649 = cljs.core.first.call(null,seq35648);
var seq35648__$1 = cljs.core.next.call(null,seq35648);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__35649,seq35648__$1);
});


//# sourceMappingURL=client.js.map