/*
 * Decompiled with CFR 0.152.
 */
package com.domain;

import com.domain.Range;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;

public class TimeRange
extends Range<Long>
implements Comparable<TimeRange> {
    private long offset = 0L;

    public TimeRange() {
    }

    public TimeRange(Long from, Long upto) {
        super(from, upto);
    }

    public static TimeRange max() {
        return TimeRange.of(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static TimeRange of(long from, long upto) {
        return TimeRange.of(from, upto, 0L);
    }

    public static TimeRange of(DateTime from, DateTime upto) {
        TimeRange timeRange = TimeRange.of(from.getMillis(), upto.getMillis(), 0L);
        timeRange.includeUpper(false);
        return timeRange;
    }

    public static TimeRange of(long from, long upto, long offset) {
        TimeRange timeRange = new TimeRange();
        timeRange.offset(offset).from(from).upto(upto).includeLower(true).includeUpper(true);
        return timeRange;
    }

    public static TimeRange of(long from, long upto, long offset, boolean includeLower, boolean includeUpper) {
        TimeRange timeRange = new TimeRange();
        timeRange.offset(offset).from(from).upto(upto).includeLower(includeLower).includeUpper(includeUpper);
        return timeRange;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public TimeRange offset(long offset) {
        this.setOffset(offset);
        return this;
    }

    @Override
    public int compareTo(TimeRange timeRange) {
        if (timeRange == null) {
            throw new IllegalArgumentException("Invalid Params");
        }
        int value = this.compare((Long)this.getFrom(), (Long)timeRange.getFrom());
        if (value == 0) {
            return this.compare((Long)this.getUpto(), (Long)timeRange.getUpto());
        }
        return value;
    }

    private int compare(Long value1, Long value2) {
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 != null && value2 == null) {
            return 1;
        }
        if (value1 == null) {
            return -1;
        }
        return value1.compareTo(value2);
    }

    public Iterable<TimeRange> breakDown(long interval) {
        return () -> new TimeRangeIterator(interval);
    }

    class TimeRangeIterator
    implements Iterator<TimeRange> {
        private long rangeStart;
        private final long start;
        private final long end;
        private final long interval;

        public TimeRangeIterator(long interval) {
            this.start = (Long)TimeRange.this.getFrom();
            this.end = (Long)TimeRange.this.getUpto();
            this.interval = interval;
            this.rangeStart = this.start;
        }

        @Override
        public boolean hasNext() {
            return this.rangeStart <= this.end;
        }

        @Override
        public TimeRange next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long rangeEnd = Math.min(this.rangeStart + this.interval - 1L, this.end);
            TimeRange range = TimeRange.of(this.rangeStart, rangeEnd);
            this.rangeStart = rangeEnd + 1L;
            return range;
        }
    }
}

