/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import com.collections.CollectionUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.inject.internal.Nullable;
import com.utils.PreConditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.WordUtils;

public final class StringUtils {
    public static final Set<Character> KEYBOARD_PUNCTUATION_SYMBOLS = ImmutableSet.of((Object)Character.valueOf('~'), (Object)Character.valueOf('!'), (Object)Character.valueOf('@'), (Object)Character.valueOf('#'), (Object)Character.valueOf('$'), (Object)Character.valueOf('%'), (Object[])new Character[]{Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('_'), Character.valueOf('+'), Character.valueOf('`'), Character.valueOf('-'), Character.valueOf('='), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\\'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf(';'), Character.valueOf('\''), Character.valueOf(':'), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?')});
    public static final Predicate<String> STRING_NOT_BLANK = new Predicate<String>(){

        public boolean apply(@Nullable String s) {
            return StringUtils.isNotBlank(s);
        }
    };
    private static final String EMPTY = "";

    public static String cleanKeyboardPunctuations(String input) {
        StringBuilder sb = new StringBuilder();
        for (char ch : input.toCharArray()) {
            if (KEYBOARD_PUNCTUATION_SYMBOLS.contains(Character.valueOf(ch))) continue;
            sb.append(ch);
        }
        input = sb.toString();
        return input;
    }

    public static boolean isNotBlank(String value) {
        return !StringUtils.isBlank(value);
    }

    public static boolean isBlank(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String blankIfNull(String stringToCheck) {
        if (stringToCheck == null) {
            stringToCheck = EMPTY;
        }
        return stringToCheck;
    }

    public static String nullIfBlank(String stringToCheck) {
        if (StringUtils.isBlank(stringToCheck)) {
            return null;
        }
        return stringToCheck;
    }

    public static String lowercaseFirstCharacter(String input) {
        if (StringUtils.isNotBlank(input)) {
            return Character.toLowerCase(input.charAt(0)) + input.substring(1);
        }
        return input;
    }

    public static String uppercaseFirstCharacter(String input) {
        if (StringUtils.isNotBlank(input)) {
            return Character.toUpperCase(input.charAt(0)) + input.substring(1);
        }
        return input;
    }

    public static String upperCaseFirstCharacterLowerCaseOthers(String input) {
        if (StringUtils.isNotBlank(input)) {
            return Character.toUpperCase(input.charAt(0)) + input.substring(1).toLowerCase();
        }
        return input;
    }

    public static String capitalize(String sentence, char ... separaters) {
        for (char separater : separaters) {
            sentence = sentence.replace(separater, ' ');
        }
        return WordUtils.capitalizeFully((String)sentence);
    }

    public static List<String> tokenize(String input, TokenType ... tokenTypes) {
        String[] split;
        PreConditions.positiveInt(tokenTypes.length);
        ArrayList<String> rv = new ArrayList<String>();
        for (String s : split = input.split(StringUtils.getSplitRegex(tokenTypes))) {
            if (!StringUtils.isNotBlank(s = s.trim())) continue;
            rv.add(s);
        }
        return rv;
    }

    private static String getSplitRegex(TokenType[] tokenTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (TokenType tokenType : tokenTypes) {
            builder.append(tokenType.pattern);
        }
        builder.append("+]");
        return builder.toString();
    }

    public static int countAlphaNumericCharacters(String text) {
        char[] chars;
        if (StringUtils.isBlank(text)) {
            return 0;
        }
        int count = 0;
        for (char character : chars = text.toCharArray()) {
            if (!Character.isLetterOrDigit(character)) continue;
            ++count;
        }
        return count;
    }

    public static boolean containsAnyPunctuations(String text) {
        char[] chars;
        if (StringUtils.isBlank(text)) {
            return false;
        }
        for (char character : chars = text.toCharArray()) {
            if (!StringUtils.isPunctuation(character)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String input, List<String> stringsToCheck) {
        for (String stringToCheck : stringsToCheck) {
            if (!org.apache.commons.lang.StringUtils.contains((String)input, (String)stringToCheck)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(String input, List<String> stringsToCheck) {
        for (String stringToCheck : stringsToCheck) {
            if (!org.apache.commons.lang.StringUtils.containsIgnoreCase((String)input, (String)stringToCheck)) continue;
            return true;
        }
        return false;
    }

    public static String join(String delimiter, String ... elements) {
        if (CollectionUtils.isEmpty(elements)) {
            return EMPTY;
        }
        return org.apache.commons.lang.StringUtils.join((Object[])elements, (String)delimiter);
    }

    public static String join(List<String> input, TokenType tokenType) {
        if (CollectionUtils.isEmpty(input) || tokenType == null) {
            return null;
        }
        return org.apache.commons.lang.StringUtils.join((Object[])input.toArray(new String[0]), (String)tokenType.pattern);
    }

    public static boolean isPunctuation(char c) {
        return KEYBOARD_PUNCTUATION_SYMBOLS.contains(Character.valueOf(c));
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static void replace(Set<String> strings) {
        String[] stringsArray = strings.toArray(new String[0]);
        for (int i = 0; i < stringsArray.length; ++i) {
            stringsArray[i] = stringsArray[i].toLowerCase();
        }
        strings.clear();
        strings.addAll(Arrays.asList(stringsArray));
    }

    public static boolean equalsWithBlankCheck(String str1, String str2) {
        return StringUtils.blankIfNull(str1).equals(StringUtils.blankIfNull(str2));
    }

    public static boolean endsWith(String str, Collection<String> suffixes) {
        if (StringUtils.isBlank(str) || CollectionUtils.isEmpty(suffixes)) {
            return false;
        }
        for (String suffix : CollectionUtils.nullAndBlankSafeValueSet(suffixes)) {
            if (!str.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static enum TokenType {
        WHITESPACE("\\s"),
        COMMA(","),
        COLON(":"),
        UNDER_SCORE("_"),
        DOT("."),
        PLUS("+"),
        MINUS("-"),
        NEW_LINE("\n");

        private final String pattern;

        private TokenType(String pattern) {
            this.pattern = pattern;
        }
    }
}

