/*
 * Decompiled with CFR 0.152.
 */
package io.appform.core.hystrix;

import com.netflix.hystrix.HystrixCommand;
import io.appform.core.hystrix.HandlerAdapter;
import java.util.Map;
import org.slf4j.MDC;

public class GenericHystrixCommand<ReturnType> {
    public static final String TRACE_ID = "TRACE-ID";
    private final HystrixCommand.Setter setter;
    private final String traceId;

    public GenericHystrixCommand(HystrixCommand.Setter setter, String traceId) {
        this.setter = setter;
        this.traceId = traceId;
    }

    public HystrixCommand<ReturnType> executor(final HandlerAdapter<ReturnType> function) throws Exception {
        final Map parentMDCContext = MDC.getCopyOfContextMap();
        return new HystrixCommand<ReturnType>(this.setter){

            protected ReturnType run() throws Exception {
                try {
                    if (parentMDCContext != null) {
                        MDC.setContextMap((Map)parentMDCContext);
                    }
                    MDC.put((String)GenericHystrixCommand.TRACE_ID, (String)GenericHystrixCommand.this.traceId);
                    Object t = function.run();
                    return t;
                }
                finally {
                    MDC.clear();
                }
            }
        };
    }
}

