/*
 * Decompiled with CFR 0.152.
 */
package io.appform.foxtrot.client.selectors;

import feign.Request;
import feign.RequestTemplate;
import feign.Target;
import io.appform.foxtrot.client.cluster.FoxtrotClusterMember;
import io.appform.foxtrot.client.cluster.IFoxtrotCluster;

public class FoxtrotTarget<T>
implements Target<T> {
    private final Class<T> type;
    private final String name;
    private final IFoxtrotCluster foxtrotCluster;

    public FoxtrotTarget(Class<T> type, String name, IFoxtrotCluster foxtrotCluster) {
        this.type = type;
        this.name = name;
        this.foxtrotCluster = foxtrotCluster;
    }

    public Class<T> type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        FoxtrotClusterMember member = this.foxtrotCluster.member();
        return String.format("http://%s:%d", member.getHost(), member.getPort());
    }

    public Request apply(RequestTemplate input) {
        FoxtrotClusterMember member = this.foxtrotCluster.member();
        String url = String.format("http://%s:%d", member.getHost(), member.getPort());
        input.insert(0, (CharSequence)url);
        return input.request();
    }
}

