/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import io.appform.hope.core.Value;
import io.appform.hope.core.functions.FunctionImplementation;
import io.appform.hope.core.functions.HopeFunction;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRegistry {
    private static final Logger log = LoggerFactory.getLogger(FunctionRegistry.class);
    private final Map<String, FunctionMeta> knownFunctions = new HashMap<String, FunctionMeta>();
    private volatile boolean discoveredAlready = false;

    public synchronized void discover(List<String> packages) {
        if (this.discoveredAlready) {
            return;
        }
        ImmutableList packageUrls = new ImmutableList.Builder().addAll((Iterable)ClasspathHelper.forPackage((String)"io.appform.hope.core.functions.impl", (ClassLoader[])new ClassLoader[0])).addAll((Iterable)packages.stream().flatMap(packagePath -> ClasspathHelper.forPackage((String)packagePath, (ClassLoader[])new ClassLoader[0]).stream()).collect(Collectors.toList())).build();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls((Collection)packageUrls).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{"io.appform.hope.core.functions.impl"})));
        log.info("Type scanning complete");
        Set classes = reflections.getSubTypesOf(HopeFunction.class);
        classes.stream().filter(type -> type.getAnnotation(FunctionImplementation.class) != null).forEach(this::register);
        this.discoveredAlready = true;
    }

    public void register(Class<? extends HopeFunction> clazz) {
        FunctionImplementation annotation = clazz.getAnnotation(FunctionImplementation.class);
        Preconditions.checkNotNull((Object)annotation, (Object)(clazz.getSimpleName() + " is not annotated with FucntionImplementation"));
        List<Class<?>> paramTypes = FunctionRegistry.paramTypes(clazz);
        boolean arrayValue = paramTypes.stream().anyMatch(Class::isArray);
        Preconditions.checkArgument((!arrayValue || paramTypes.size() == 1 ? 1 : 0) != 0, (Object)"For (Value... ) vararg func only one param is allowed.");
        String functionName = annotation.value();
        Preconditions.checkArgument((!this.knownFunctions.containsKey(functionName) ? 1 : 0) != 0, (Object)("Function '" + functionName + "' is already registered"));
        this.knownFunctions.put(functionName, FunctionMeta.builder().paramTypes(paramTypes).arrayValue(arrayValue).functionClass(clazz).build());
        log.debug("Registered function: {}", (Object)functionName);
    }

    public Optional<FunctionMeta> find(String name) {
        return Optional.ofNullable(this.knownFunctions.getOrDefault(name, null));
    }

    private static List<Class<?>> paramTypes(Class<? extends HopeFunction> type) {
        Constructor<?>[] declaredConstructors = type.getDeclaredConstructors();
        FunctionImplementation annotation = type.getAnnotation(FunctionImplementation.class);
        Preconditions.checkArgument((declaredConstructors != null && declaredConstructors.length == 1 ? 1 : 0) != 0, (Object)("Function " + annotation.value() + " must have only one constructor"));
        Class<?>[] declaredParamTypes = declaredConstructors[0].getParameterTypes();
        List<Class<?>> paramTypes = Arrays.stream(declaredParamTypes).filter(parameterType -> parameterType.isArray() ? parameterType.getComponentType().isAssignableFrom(Value.class) : parameterType.isAssignableFrom(Value.class)).collect(Collectors.toList());
        Preconditions.checkArgument((paramTypes.size() == declaredParamTypes.length ? 1 : 0) != 0, (Object)("Non value parameter types declared for constructor in function '" + annotation.value() + "'. Param types: " + Arrays.stream(declaredParamTypes).map(Class::getSimpleName).collect(Collectors.toList())));
        return paramTypes;
    }

    public static class FunctionMeta {
        private final List<Class<?>> paramTypes;
        private final boolean arrayValue;
        private final Class<? extends HopeFunction> functionClass;

        @ConstructorProperties(value={"paramTypes", "arrayValue", "functionClass"})
        FunctionMeta(List<Class<?>> paramTypes, boolean arrayValue, Class<? extends HopeFunction> functionClass) {
            this.paramTypes = paramTypes;
            this.arrayValue = arrayValue;
            this.functionClass = functionClass;
        }

        public static FunctionMetaBuilder builder() {
            return new FunctionMetaBuilder();
        }

        public List<Class<?>> getParamTypes() {
            return this.paramTypes;
        }

        public boolean isArrayValue() {
            return this.arrayValue;
        }

        public Class<? extends HopeFunction> getFunctionClass() {
            return this.functionClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionMeta)) {
                return false;
            }
            FunctionMeta other = (FunctionMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Class<?>> this$paramTypes = this.getParamTypes();
            List<Class<?>> other$paramTypes = other.getParamTypes();
            if (this$paramTypes == null ? other$paramTypes != null : !((Object)this$paramTypes).equals(other$paramTypes)) {
                return false;
            }
            if (this.isArrayValue() != other.isArrayValue()) {
                return false;
            }
            Class<? extends HopeFunction> this$functionClass = this.getFunctionClass();
            Class<? extends HopeFunction> other$functionClass = other.getFunctionClass();
            return !(this$functionClass == null ? other$functionClass != null : !this$functionClass.equals(other$functionClass));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Class<?>> $paramTypes = this.getParamTypes();
            result = result * 59 + ($paramTypes == null ? 43 : ((Object)$paramTypes).hashCode());
            result = result * 59 + (this.isArrayValue() ? 79 : 97);
            Class<? extends HopeFunction> $functionClass = this.getFunctionClass();
            result = result * 59 + ($functionClass == null ? 43 : $functionClass.hashCode());
            return result;
        }

        public String toString() {
            return "FunctionRegistry.FunctionMeta(paramTypes=" + this.getParamTypes() + ", arrayValue=" + this.isArrayValue() + ", functionClass=" + this.getFunctionClass() + ")";
        }

        public static class FunctionMetaBuilder {
            private List<Class<?>> paramTypes;
            private boolean arrayValue;
            private Class<? extends HopeFunction> functionClass;

            FunctionMetaBuilder() {
            }

            public FunctionMetaBuilder paramTypes(List<Class<?>> paramTypes) {
                this.paramTypes = paramTypes;
                return this;
            }

            public FunctionMetaBuilder arrayValue(boolean arrayValue) {
                this.arrayValue = arrayValue;
                return this;
            }

            public FunctionMetaBuilder functionClass(Class<? extends HopeFunction> functionClass) {
                this.functionClass = functionClass;
                return this;
            }

            public FunctionMeta build() {
                return new FunctionMeta(this.paramTypes, this.arrayValue, this.functionClass);
            }

            public String toString() {
                return "FunctionRegistry.FunctionMeta.FunctionMetaBuilder(paramTypes=" + this.paramTypes + ", arrayValue=" + this.arrayValue + ", functionClass=" + this.functionClass + ")";
            }
        }
    }
}

