/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.functions.impl.str;

import io.appform.hope.core.Value;
import io.appform.hope.core.functions.FunctionImplementation;
import io.appform.hope.core.functions.HopeFunction;
import io.appform.hope.core.utils.Converters;
import io.appform.hope.core.values.StringValue;
import io.appform.hope.core.visitors.Evaluator;

@FunctionImplementation(value="str.substr")
public class SubStr
extends HopeFunction {
    private final Value arg;
    private final Value start;
    private final Value end;

    public SubStr(Value arg, Value start, Value end) {
        this.arg = arg;
        this.start = start;
        this.end = end;
    }

    public Value apply(Evaluator.EvaluationContext evaluationContext) {
        int startIndex = Converters.numericValue(evaluationContext, this.start, 0).intValue();
        int endIndex = Converters.numericValue(evaluationContext, this.end, 0).intValue();
        String argValue = Converters.stringValue(evaluationContext, this.arg, "");
        return new StringValue(argValue.substring(startIndex, endIndex));
    }
}

