/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.common.base.Strings;
import com.jayway.jsonpath.Predicate;
import io.appform.hope.core.TreeNode;
import io.appform.hope.core.Value;
import io.appform.hope.core.VisitorAdapter;
import io.appform.hope.core.exceptions.errorstrategy.ErrorHandlingStrategy;
import io.appform.hope.core.functions.FunctionRegistry;
import io.appform.hope.core.functions.HopeFunction;
import io.appform.hope.core.values.ArrayValue;
import io.appform.hope.core.values.BooleanValue;
import io.appform.hope.core.values.FunctionValue;
import io.appform.hope.core.values.JsonPathValue;
import io.appform.hope.core.values.NumericValue;
import io.appform.hope.core.values.ObjectValue;
import io.appform.hope.core.values.StringValue;
import io.appform.hope.core.visitors.Evaluator;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Converters {
    private static final Logger log = LoggerFactory.getLogger(Converters.class);

    private Converters() {
    }

    public static String stringValue(final Evaluator.EvaluationContext evaluationContext, TreeNode node, final String defaultValue) {
        ErrorHandlingStrategy errorHandlingStrategy = evaluationContext.getEvaluator().getErrorHandlingStrategy();
        return node.accept(new VisitorAdapter<String>(() -> errorHandlingStrategy.handleIllegalEval("String value eval", defaultValue)){

            @Override
            public String visit(JsonPathValue jsonPathValue) {
                return (String)Converters.extractNodeValue(jsonPathValue, evaluationContext, JsonNodeType.STRING, JsonNode::asText, defaultValue);
            }

            @Override
            public String visit(StringValue stringValue) {
                String value = (String)stringValue.getValue();
                if (null == value) {
                    JsonPathValue pathValue = stringValue.getPathValue();
                    if (null != pathValue) {
                        return pathValue.accept(this);
                    }
                    FunctionValue functionValue = stringValue.getFunction();
                    if (null != functionValue) {
                        return functionValue.accept(this);
                    }
                }
                return value;
            }

            @Override
            public String visit(FunctionValue functionValue) {
                return Converters.stringValue(evaluationContext, Converters.function(functionValue).apply(evaluationContext), defaultValue);
            }
        });
    }

    public static Number numericValue(final Evaluator.EvaluationContext evaluationContext, TreeNode node, final Number defaultValue) {
        ErrorHandlingStrategy errorHandlingStrategy = evaluationContext.getEvaluator().getErrorHandlingStrategy();
        return node.accept(new VisitorAdapter<Number>(() -> errorHandlingStrategy.handleIllegalEval("Number eval", defaultValue)){

            @Override
            public Number visit(JsonPathValue jsonPathValue) {
                return (Number)Converters.extractNodeValue(jsonPathValue, evaluationContext, JsonNodeType.NUMBER, JsonNode::asDouble, defaultValue);
            }

            @Override
            public Number visit(NumericValue numericValue) {
                Number value = (Number)numericValue.getValue();
                if (null == value) {
                    JsonPathValue pathValue = numericValue.getPathValue();
                    if (null != pathValue) {
                        return pathValue.accept(this);
                    }
                    FunctionValue functionValue = numericValue.getFunction();
                    if (null != functionValue) {
                        return functionValue.accept(this);
                    }
                }
                return value;
            }

            @Override
            public Number visit(FunctionValue functionValue) {
                return Converters.numericValue(evaluationContext, Converters.function(functionValue).apply(evaluationContext), defaultValue);
            }
        });
    }

    public static Boolean booleanValue(final Evaluator.EvaluationContext evaluationContext, TreeNode node, final boolean defaultValue) {
        ErrorHandlingStrategy errorHandlingStrategy = evaluationContext.getEvaluator().getErrorHandlingStrategy();
        return node.accept(new VisitorAdapter<Boolean>(() -> errorHandlingStrategy.handleIllegalEval("Boolean eval", defaultValue)){

            @Override
            public Boolean visit(JsonPathValue jsonPathValue) {
                return (Boolean)Converters.extractNodeValue(jsonPathValue, evaluationContext, JsonNodeType.BOOLEAN, JsonNode::asBoolean, defaultValue);
            }

            @Override
            public Boolean visit(BooleanValue booleanValue) {
                Boolean value = (Boolean)booleanValue.getValue();
                if (null == value) {
                    JsonPathValue pathValue = booleanValue.getPathValue();
                    if (null != pathValue) {
                        return pathValue.accept(this);
                    }
                    FunctionValue functionValue = booleanValue.getFunction();
                    if (null != functionValue) {
                        return functionValue.accept(this);
                    }
                }
                return value;
            }

            @Override
            public Boolean visit(FunctionValue functionValue) {
                return Converters.booleanValue(evaluationContext, Converters.function(functionValue).apply(evaluationContext), defaultValue);
            }
        });
    }

    public static List<Value> explodeArray(final Evaluator.EvaluationContext evaluationContext, TreeNode node, final List<Value> defaultValue) {
        final ErrorHandlingStrategy errorHandlingStrategy = evaluationContext.getEvaluator().getErrorHandlingStrategy();
        return node.accept(new VisitorAdapter<List<Value>>(() -> defaultValue){

            @Override
            public List<Value> visit(JsonPathValue jsonPathValue) {
                JsonNode value = (JsonNode)evaluationContext.getJsonContext().read(jsonPathValue.getPath(), new Predicate[0]);
                if (value.isArray()) {
                    return StreamSupport.stream(Spliterators.spliteratorUnknownSize(((ArrayNode)ArrayNode.class.cast(value)).elements(), 16), false).map(x$0 -> Converters.jsonNodeToValue(x$0)).collect(Collectors.toList());
                }
                return errorHandlingStrategy.handleTypeMismatch(jsonPathValue.getPath(), JsonNodeType.ARRAY.name(), value.getNodeType().name(), defaultValue);
            }

            @Override
            public List<Value> visit(ArrayValue arrayValue) {
                List value = (List)arrayValue.getValue();
                if (null == value) {
                    JsonPathValue pathValue = arrayValue.getPathValue();
                    if (null != pathValue) {
                        return pathValue.accept(this);
                    }
                    FunctionValue functionValue = arrayValue.getFunction();
                    if (null != functionValue) {
                        return functionValue.accept(this);
                    }
                }
                return value;
            }

            @Override
            public List<Value> visit(FunctionValue functionValue) {
                return Converters.explodeArray(evaluationContext, Converters.function(functionValue).apply(evaluationContext), defaultValue);
            }
        });
    }

    public static List<Object> flattenArray(Evaluator.EvaluationContext evaluationContext, Value value, Object defaultValue) {
        return Converters.arrayToObjectList(evaluationContext, Converters.explodeArray(evaluationContext, value, Collections.emptyList()), defaultValue);
    }

    public static String jsonPathValue(final Evaluator.EvaluationContext evaluationContext, TreeNode node, final String defaultValue) {
        return node.accept(new VisitorAdapter<String>(() -> defaultValue){

            @Override
            public String visit(JsonPathValue jsonPathValue) {
                String path = jsonPathValue.getPath();
                if (Strings.isNullOrEmpty((String)path)) {
                    FunctionValue functionValue = jsonPathValue.getFunction();
                    return functionValue.accept(this);
                }
                return path;
            }

            @Override
            public String visit(FunctionValue functionValue) {
                return Converters.jsonPathValue(evaluationContext, Converters.function(functionValue).apply(evaluationContext), defaultValue);
            }
        });
    }

    public static Object objectValue(final Evaluator.EvaluationContext evaluationContext, TreeNode node, final Object defaultValue) {
        final ErrorHandlingStrategy errorHandlingStrategy = evaluationContext.getEvaluator().getErrorHandlingStrategy();
        return node.accept(new VisitorAdapter<Object>(() -> errorHandlingStrategy.handleIllegalEval("Object eval", defaultValue)){

            @Override
            public Object visit(JsonPathValue jsonPathValue) {
                JsonNode value = Converters.nodeForJsonPath(jsonPathValue, evaluationContext);
                if (null != value && !value.isNull() && !value.isMissingNode()) {
                    if (value.isTextual()) {
                        return value.asText();
                    }
                    if (value.isBoolean()) {
                        return value.asBoolean();
                    }
                    if (value.isNumber()) {
                        return value.asDouble();
                    }
                    if (value.isPojo()) {
                        return value.isPojo();
                    }
                }
                return errorHandlingStrategy.handleMissingValue(jsonPathValue.getPath(), defaultValue);
            }

            @Override
            public Object visit(ObjectValue objectValue) {
                return objectValue.getValue();
            }

            @Override
            public Object visit(NumericValue numericValue) {
                return Converters.numericValue(evaluationContext, numericValue, 0);
            }

            @Override
            public Object visit(StringValue stringValue) {
                return Converters.stringValue(evaluationContext, stringValue, "");
            }

            @Override
            public Object visit(BooleanValue booleanValue) {
                return Converters.booleanValue(evaluationContext, booleanValue, false);
            }

            @Override
            public Object visit(FunctionValue functionValue) {
                return Converters.objectValue(evaluationContext, Converters.function(functionValue).apply(evaluationContext), defaultValue);
            }
        });
    }

    private static HopeFunction function(FunctionValue functionValue) {
        List<Value> parameters = functionValue.getParameters();
        return Converters.createFunction(functionValue.getName(), functionValue.getSelectedConstructor(), parameters);
    }

    private static HopeFunction createFunction(String name, FunctionRegistry.ConstructorMeta selectedConstructor, List<Value> parameters) {
        try {
            Constructor<? extends HopeFunction> constructor = selectedConstructor.getConstructor();
            log.info("Found constructor: {}", constructor);
            if (selectedConstructor.isHasVariableArgs()) {
                return constructor.newInstance(new Object[]{parameters.toArray(new Value[parameters.size()])});
            }
            return constructor.newInstance(parameters.toArray(new Object[parameters.size()]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create instance of function: '" + name + "'", e);
        }
    }

    private static Value jsonNodeToValue(JsonNode node) {
        if (node.isTextual()) {
            return new StringValue(node.asText());
        }
        if (node.isBoolean()) {
            return new BooleanValue(node.asBoolean());
        }
        if (node.isNumber()) {
            return new NumericValue(node.doubleValue());
        }
        if (node.isPojo()) {
            return new ObjectValue(node);
        }
        if (node.isArray()) {
            return new ArrayValue(StreamSupport.stream(Spliterators.spliteratorUnknownSize(((ArrayNode)ArrayNode.class.cast(node)).elements(), 16), false).map(child -> Converters.jsonNodeToValue(node)).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException(node.getNodeType().name() + " is not supported");
    }

    private static JsonNode nodeForJsonPath(JsonPathValue jsonPathValue, Evaluator.EvaluationContext evaluationContext) {
        JsonNode value;
        String path = jsonPathValue.getPath();
        JsonNode existing = evaluationContext.getJsonPathEvalCache().getOrDefault(path, null);
        if (null == existing) {
            value = (JsonNode)evaluationContext.getJsonContext().read(path, new Predicate[0]);
            evaluationContext.getJsonPathEvalCache().put(path, value);
        } else {
            value = existing;
        }
        return value;
    }

    private static <T> T extractNodeValue(JsonPathValue jsonPathValue, Evaluator.EvaluationContext evaluationContext, JsonNodeType expectedType, Function<JsonNode, T> extractor, T defaultValue) {
        JsonNode value = Converters.nodeForJsonPath(jsonPathValue, evaluationContext);
        ErrorHandlingStrategy errorHandlingStrategy = evaluationContext.getEvaluator().getErrorHandlingStrategy();
        if (null == value || value.isNull() || value.isMissingNode()) {
            return errorHandlingStrategy.handleMissingValue(jsonPathValue.getPath(), defaultValue);
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType != expectedType) {
            return errorHandlingStrategy.handleTypeMismatch(jsonPathValue.getPath(), expectedType.name(), nodeType.name(), defaultValue);
        }
        return extractor.apply(value);
    }

    private static List<Object> arrayToObjectList(Evaluator.EvaluationContext evaluationContext, List<Value> values, Object defaultValue) {
        return values.stream().map(value -> Converters.objectValue(evaluationContext, value, defaultValue)).collect(Collectors.toList());
    }
}

