/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import io.appform.hope.core.Value;
import io.appform.hope.core.functions.FunctionImplementation;
import io.appform.hope.core.functions.HopeFunction;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRegistry {
    private static final Logger log = LoggerFactory.getLogger(FunctionRegistry.class);
    private final Map<String, FunctionMeta> knownFunctions = new HashMap<String, FunctionMeta>();
    private volatile boolean discoveredAlready = false;

    public synchronized void discover(List<String> packages) {
        if (this.discoveredAlready) {
            return;
        }
        ImmutableList packageUrls = new ImmutableList.Builder().addAll((Iterable)ClasspathHelper.forPackage((String)"io.appform.hope.core.functions.impl", (ClassLoader[])new ClassLoader[0])).addAll((Iterable)packages.stream().flatMap(packagePath -> ClasspathHelper.forPackage((String)packagePath, (ClassLoader[])new ClassLoader[0]).stream()).collect(Collectors.toList())).build();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls((Collection)packageUrls).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{"io.appform.hope.core.functions.impl"})));
        log.info("Type scanning complete");
        Set classes = reflections.getSubTypesOf(HopeFunction.class);
        classes.stream().filter(type -> type.getAnnotation(FunctionImplementation.class) != null).forEach(this::register);
        this.discoveredAlready = true;
    }

    public void register(Class<? extends HopeFunction> clazz) {
        FunctionImplementation annotation = clazz.getAnnotation(FunctionImplementation.class);
        Preconditions.checkNotNull((Object)annotation, (Object)(clazz.getSimpleName() + " is not annotated with FucntionImplementation"));
        List<ConstructorMeta> constructors = FunctionRegistry.constructors(clazz);
        String functionName = annotation.value();
        Preconditions.checkArgument((!this.knownFunctions.containsKey(functionName) ? 1 : 0) != 0, (Object)("Function '" + functionName + "' is already registered"));
        Preconditions.checkArgument((constructors.stream().noneMatch(ConstructorMeta::isHasVariableArgs) || constructors.size() == 1 ? 1 : 0) != 0, (Object)("Illegal declaration for: " + functionName + ".Functions with variant args can have only one implementation. Overloads are not allowed"));
        Preconditions.checkArgument((constructors.stream().distinct().count() == (long)constructors.size() ? 1 : 0) != 0, (Object)("Function " + functionName + " has multiple constructors (overloads) with same number of params. This means it cannot be resolved at runtime."));
        this.knownFunctions.put(functionName, FunctionMeta.builder().constructors(constructors).build());
        log.debug("Registered function: {}", (Object)functionName);
    }

    public Optional<FunctionMeta> find(String name) {
        return Optional.ofNullable(this.knownFunctions.getOrDefault(name, null));
    }

    private static List<ConstructorMeta> constructors(Class<? extends HopeFunction> type) {
        Constructor<?>[] declaredConstructors = type.getDeclaredConstructors();
        FunctionImplementation annotation = type.getAnnotation(FunctionImplementation.class);
        return Arrays.stream(declaredConstructors).map(declaredConstructor -> {
            Class<?>[] declaredParamTypes = declaredConstructor.getParameterTypes();
            List<Class<?>> paramTypes = Arrays.stream(declaredParamTypes).filter(parameterType -> parameterType.isArray() ? parameterType.getComponentType().isAssignableFrom(Value.class) : parameterType.isAssignableFrom(Value.class)).collect(Collectors.toList());
            Preconditions.checkArgument((paramTypes.size() == declaredParamTypes.length ? 1 : 0) != 0, (Object)("Non value parameter types declared for constructor in function '" + annotation.value() + "'. Param types: " + Arrays.stream(declaredParamTypes).map(Class::getSimpleName).collect(Collectors.toList())));
            boolean variantArgs = paramTypes.stream().anyMatch(Class::isArray);
            Preconditions.checkArgument((!variantArgs || paramTypes.size() == 1 ? 1 : 0) != 0, (Object)"For (Value... ) vararg func only one param is allowed.");
            return ConstructorMeta.builder().paramTypes(paramTypes).hasVariableArgs(variantArgs).constructor((Constructor<? extends HopeFunction>)declaredConstructor).build();
        }).collect(Collectors.toList());
    }

    public static class FunctionMeta {
        private final List<ConstructorMeta> constructors;

        @ConstructorProperties(value={"constructors"})
        FunctionMeta(List<ConstructorMeta> constructors) {
            this.constructors = constructors;
        }

        public static FunctionMetaBuilder builder() {
            return new FunctionMetaBuilder();
        }

        public List<ConstructorMeta> getConstructors() {
            return this.constructors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionMeta)) {
                return false;
            }
            FunctionMeta other = (FunctionMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ConstructorMeta> this$constructors = this.getConstructors();
            List<ConstructorMeta> other$constructors = other.getConstructors();
            return !(this$constructors == null ? other$constructors != null : !((Object)this$constructors).equals(other$constructors));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ConstructorMeta> $constructors = this.getConstructors();
            result = result * 59 + ($constructors == null ? 43 : ((Object)$constructors).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionRegistry.FunctionMeta(constructors=" + this.getConstructors() + ")";
        }

        public static class FunctionMetaBuilder {
            private List<ConstructorMeta> constructors;

            FunctionMetaBuilder() {
            }

            public FunctionMetaBuilder constructors(List<ConstructorMeta> constructors) {
                this.constructors = constructors;
                return this;
            }

            public FunctionMeta build() {
                return new FunctionMeta(this.constructors);
            }

            public String toString() {
                return "FunctionRegistry.FunctionMeta.FunctionMetaBuilder(constructors=" + this.constructors + ")";
            }
        }
    }

    public static class ConstructorMeta {
        private final List<Class<?>> paramTypes;
        private final boolean hasVariableArgs;
        private final Constructor<? extends HopeFunction> constructor;

        @ConstructorProperties(value={"paramTypes", "hasVariableArgs", "constructor"})
        ConstructorMeta(List<Class<?>> paramTypes, boolean hasVariableArgs, Constructor<? extends HopeFunction> constructor) {
            this.paramTypes = paramTypes;
            this.hasVariableArgs = hasVariableArgs;
            this.constructor = constructor;
        }

        public static ConstructorMetaBuilder builder() {
            return new ConstructorMetaBuilder();
        }

        public List<Class<?>> getParamTypes() {
            return this.paramTypes;
        }

        public boolean isHasVariableArgs() {
            return this.hasVariableArgs;
        }

        public Constructor<? extends HopeFunction> getConstructor() {
            return this.constructor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstructorMeta)) {
                return false;
            }
            ConstructorMeta other = (ConstructorMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Class<?>> this$paramTypes = this.getParamTypes();
            List<Class<?>> other$paramTypes = other.getParamTypes();
            if (this$paramTypes == null ? other$paramTypes != null : !((Object)this$paramTypes).equals(other$paramTypes)) {
                return false;
            }
            if (this.isHasVariableArgs() != other.isHasVariableArgs()) {
                return false;
            }
            Constructor<? extends HopeFunction> this$constructor = this.getConstructor();
            Constructor<? extends HopeFunction> other$constructor = other.getConstructor();
            return !(this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConstructorMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Class<?>> $paramTypes = this.getParamTypes();
            result = result * 59 + ($paramTypes == null ? 43 : ((Object)$paramTypes).hashCode());
            result = result * 59 + (this.isHasVariableArgs() ? 79 : 97);
            Constructor<? extends HopeFunction> $constructor = this.getConstructor();
            result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionRegistry.ConstructorMeta(paramTypes=" + this.getParamTypes() + ", hasVariableArgs=" + this.isHasVariableArgs() + ", constructor=" + this.getConstructor() + ")";
        }

        public static class ConstructorMetaBuilder {
            private List<Class<?>> paramTypes;
            private boolean hasVariableArgs;
            private Constructor<? extends HopeFunction> constructor;

            ConstructorMetaBuilder() {
            }

            public ConstructorMetaBuilder paramTypes(List<Class<?>> paramTypes) {
                this.paramTypes = paramTypes;
                return this;
            }

            public ConstructorMetaBuilder hasVariableArgs(boolean hasVariableArgs) {
                this.hasVariableArgs = hasVariableArgs;
                return this;
            }

            public ConstructorMetaBuilder constructor(Constructor<? extends HopeFunction> constructor) {
                this.constructor = constructor;
                return this;
            }

            public ConstructorMeta build() {
                return new ConstructorMeta(this.paramTypes, this.hasVariableArgs, this.constructor);
            }

            public String toString() {
                return "FunctionRegistry.ConstructorMeta.ConstructorMetaBuilder(paramTypes=" + this.paramTypes + ", hasVariableArgs=" + this.hasVariableArgs + ", constructor=" + this.constructor + ")";
            }
        }
    }
}

