/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.functions.impl.str;

import com.google.common.base.Strings;
import io.appform.hope.core.Value;
import io.appform.hope.core.functions.FunctionImplementation;
import io.appform.hope.core.functions.HopeFunction;
import io.appform.hope.core.utils.Converters;
import io.appform.hope.core.utils.FunctionHelpers;
import io.appform.hope.core.values.BooleanValue;
import io.appform.hope.core.visitors.Evaluator;

@FunctionImplementation(value="str.match")
public class Match
extends HopeFunction<BooleanValue> {
    private final Value regex;
    private final Value str;

    public Match(Value regex, Value str) {
        this.regex = regex;
        this.str = str;
    }

    @Override
    public BooleanValue apply(Evaluator.EvaluationContext evaluationContext) {
        String regexValue = Converters.stringValue(evaluationContext, this.regex, "");
        String target = Converters.stringValue(evaluationContext, this.str, "");
        FunctionHelpers.checkArgument(evaluationContext, !Strings.isNullOrEmpty((String)regexValue), "Regex is empty");
        return new BooleanValue(target.matches(regexValue));
    }
}

