/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.visitors;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import io.appform.hope.core.Evaluatable;
import io.appform.hope.core.VisitorAdapter;
import io.appform.hope.core.combiners.AndCombiner;
import io.appform.hope.core.combiners.OrCombiner;
import io.appform.hope.core.exceptions.errorstrategy.DefaultErrorHandlingStrategy;
import io.appform.hope.core.exceptions.errorstrategy.ErrorHandlingStrategy;
import io.appform.hope.core.operators.And;
import io.appform.hope.core.operators.Equals;
import io.appform.hope.core.operators.Greater;
import io.appform.hope.core.operators.GreaterEquals;
import io.appform.hope.core.operators.Lesser;
import io.appform.hope.core.operators.LesserEquals;
import io.appform.hope.core.operators.Not;
import io.appform.hope.core.operators.NotEquals;
import io.appform.hope.core.operators.Or;
import io.appform.hope.core.utils.Converters;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Evaluator {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final ParseContext parseContext;
    private final ErrorHandlingStrategy errorHandlingStrategy;

    public Evaluator() {
        this(new DefaultErrorHandlingStrategy());
    }

    public Evaluator(ErrorHandlingStrategy errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
        this.parseContext = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    }

    public boolean evaluate(Evaluatable evaluatable, JsonNode node) {
        return evaluatable.accept(new LogicEvaluator(new EvaluationContext(this.parseContext.parse((Object)node), this)));
    }

    public ErrorHandlingStrategy getErrorHandlingStrategy() {
        return this.errorHandlingStrategy;
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class LogicEvaluator
    extends VisitorAdapter<Boolean> {
        private final EvaluationContext evaluationContext;

        public LogicEvaluator(EvaluationContext evaluationContext) {
            super(() -> true);
            this.evaluationContext = evaluationContext;
        }

        public boolean evaluate(Evaluatable evaluatable) {
            return evaluatable.accept(this);
        }

        @Override
        public Boolean visit(AndCombiner andCombiner) {
            return andCombiner.getExpressions().stream().allMatch(expression -> expression.accept(new LogicEvaluator(this.evaluationContext)));
        }

        @Override
        public Boolean visit(OrCombiner orCombiner) {
            return orCombiner.getExpressions().stream().anyMatch(expression -> expression.accept(new LogicEvaluator(this.evaluationContext)));
        }

        @Override
        public Boolean visit(Equals equals) {
            Object lhs = Converters.objectValue(this.evaluationContext, equals.getLhs(), null);
            Object rhs = Converters.objectValue(this.evaluationContext, equals.getRhs(), null);
            return Objects.equals(lhs, rhs);
        }

        @Override
        public Boolean visit(NotEquals notEquals) {
            Object rhs;
            Object lhs = Converters.objectValue(this.evaluationContext, notEquals.getLhs(), null);
            return !Objects.equals(lhs, rhs = Converters.objectValue(this.evaluationContext, notEquals.getRhs(), null));
        }

        @Override
        public Boolean visit(Greater greater) {
            Number lhs = Converters.numericValue(this.evaluationContext, greater.getLhs(), 0);
            Number rhs = Converters.numericValue(this.evaluationContext, greater.getRhs(), 0);
            return lhs.doubleValue() > rhs.doubleValue();
        }

        @Override
        public Boolean visit(GreaterEquals greaterEquals) {
            Number lhs = Converters.numericValue(this.evaluationContext, greaterEquals.getLhs(), 0);
            Number rhs = Converters.numericValue(this.evaluationContext, greaterEquals.getRhs(), 0);
            return lhs.doubleValue() >= rhs.doubleValue();
        }

        @Override
        public Boolean visit(Lesser lesser) {
            Number lhs = Converters.numericValue(this.evaluationContext, lesser.getLhs(), 0);
            Number rhs = Converters.numericValue(this.evaluationContext, lesser.getRhs(), 0);
            return lhs.doubleValue() < rhs.doubleValue();
        }

        @Override
        public Boolean visit(LesserEquals lesserEquals) {
            Number lhs = Converters.numericValue(this.evaluationContext, lesserEquals.getLhs(), 0);
            Number rhs = Converters.numericValue(this.evaluationContext, lesserEquals.getRhs(), 0);
            return lhs.doubleValue() <= rhs.doubleValue();
        }

        @Override
        public Boolean visit(And and) {
            boolean lhs = Converters.booleanValue(this.evaluationContext, and.getLhs(), false);
            boolean rhs = Converters.booleanValue(this.evaluationContext, and.getRhs(), false);
            return lhs && rhs;
        }

        @Override
        public Boolean visit(Or or) {
            boolean lhs = Converters.booleanValue(this.evaluationContext, or.getLhs(), false);
            boolean rhs = Converters.booleanValue(this.evaluationContext, or.getRhs(), false);
            return lhs || rhs;
        }

        @Override
        public Boolean visit(Not not) {
            boolean operand = Converters.booleanValue(this.evaluationContext, not.getOperand(), false);
            return !operand;
        }
    }

    public static class EvaluationContext {
        private final DocumentContext jsonContext;
        private final Evaluator evaluator;
        private final Map<String, JsonNode> jsonPathEvalCache = new HashMap<String, JsonNode>(128);

        @ConstructorProperties(value={"jsonContext", "evaluator"})
        EvaluationContext(DocumentContext jsonContext, Evaluator evaluator) {
            this.jsonContext = jsonContext;
            this.evaluator = evaluator;
        }

        public static EvaluationContextBuilder builder() {
            return new EvaluationContextBuilder();
        }

        public DocumentContext getJsonContext() {
            return this.jsonContext;
        }

        public Evaluator getEvaluator() {
            return this.evaluator;
        }

        public Map<String, JsonNode> getJsonPathEvalCache() {
            return this.jsonPathEvalCache;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EvaluationContext)) {
                return false;
            }
            EvaluationContext other = (EvaluationContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DocumentContext this$jsonContext = this.getJsonContext();
            DocumentContext other$jsonContext = other.getJsonContext();
            if (this$jsonContext == null ? other$jsonContext != null : !this$jsonContext.equals(other$jsonContext)) {
                return false;
            }
            Evaluator this$evaluator = this.getEvaluator();
            Evaluator other$evaluator = other.getEvaluator();
            if (this$evaluator == null ? other$evaluator != null : !this$evaluator.equals(other$evaluator)) {
                return false;
            }
            Map<String, JsonNode> this$jsonPathEvalCache = this.getJsonPathEvalCache();
            Map<String, JsonNode> other$jsonPathEvalCache = other.getJsonPathEvalCache();
            return !(this$jsonPathEvalCache == null ? other$jsonPathEvalCache != null : !((Object)this$jsonPathEvalCache).equals(other$jsonPathEvalCache));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EvaluationContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DocumentContext $jsonContext = this.getJsonContext();
            result = result * 59 + ($jsonContext == null ? 43 : $jsonContext.hashCode());
            Evaluator $evaluator = this.getEvaluator();
            result = result * 59 + ($evaluator == null ? 43 : $evaluator.hashCode());
            Map<String, JsonNode> $jsonPathEvalCache = this.getJsonPathEvalCache();
            result = result * 59 + ($jsonPathEvalCache == null ? 43 : ((Object)$jsonPathEvalCache).hashCode());
            return result;
        }

        public String toString() {
            return "Evaluator.EvaluationContext(jsonContext=" + this.getJsonContext() + ", evaluator=" + this.getEvaluator() + ", jsonPathEvalCache=" + this.getJsonPathEvalCache() + ")";
        }

        public static class EvaluationContextBuilder {
            private DocumentContext jsonContext;
            private Evaluator evaluator;

            EvaluationContextBuilder() {
            }

            public EvaluationContextBuilder jsonContext(DocumentContext jsonContext) {
                this.jsonContext = jsonContext;
                return this;
            }

            public EvaluationContextBuilder evaluator(Evaluator evaluator) {
                this.evaluator = evaluator;
                return this;
            }

            public EvaluationContext build() {
                return new EvaluationContext(this.jsonContext, this.evaluator);
            }

            public String toString() {
                return "Evaluator.EvaluationContext.EvaluationContextBuilder(jsonContext=" + this.jsonContext + ", evaluator=" + this.evaluator + ")";
            }
        }
    }
}

