/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.lang.utils;

import com.google.common.base.Preconditions;
import io.appform.hope.core.Value;
import io.appform.hope.core.functions.FunctionRegistry;
import io.appform.hope.core.values.FunctionValue;
import java.util.List;
import java.util.stream.Collectors;

public class TypeUtils {
    private TypeUtils() {
    }

    public static FunctionValue function(FunctionRegistry functionRegistry, String name, List<Value> values) {
        FunctionRegistry.FunctionMeta functionMeta = functionRegistry.find(name).orElse(null);
        if (null == functionMeta) {
            throw new IllegalArgumentException("Unknown function '" + name + "'");
        }
        List constructors = functionMeta.getConstructors();
        if (constructors.stream().anyMatch(FunctionRegistry.ConstructorMeta::isHasVariableArgs)) {
            return new FunctionValue(name, values, (FunctionRegistry.ConstructorMeta)constructors.get(0));
        }
        int numProvidedParams = values.size();
        List matchingConstructors = constructors.stream().filter(constructorMeta -> constructorMeta.getParamTypes().size() == numProvidedParams).collect(Collectors.toList());
        Preconditions.checkArgument((!matchingConstructors.isEmpty() ? 1 : 0) != 0, (Object)String.format("No matching function named %s that accepts %d params.", name, numProvidedParams));
        Preconditions.checkArgument((matchingConstructors.size() == 1 ? 1 : 0) != 0, (Object)("Function " + name + " seems to have more than one matching overload. Cannot resolve."));
        return new FunctionValue(name, values, (FunctionRegistry.ConstructorMeta)matchingConstructors.get(0));
    }
}

