/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.appform.jsonrules.Expression;
import io.appform.jsonrules.ExpressionEvaluationContext;

public class Rule {
    private final Expression expression;

    public Rule(Expression expression) {
        this.expression = expression;
    }

    public static Rule create(String json, ObjectMapper mapper) throws Exception {
        return new Rule((Expression)mapper.readValue(json, Expression.class));
    }

    public boolean matches(JsonNode node) {
        return this.expression.evaluate(ExpressionEvaluationContext.builder().node(node).build());
    }

    public String representation(ObjectMapper mapper) throws Exception {
        return mapper.writeValueAsString((Object)this.expression);
    }
}

