/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.equality;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.utils.ComparisonUtils;

public class EqualsExpression
extends JsonPathBasedExpression {
    private Object value;

    public EqualsExpression() {
        super(ExpressionType.equals);
    }

    public EqualsExpression(String path, Object value) {
        super(ExpressionType.equals, path);
        this.value = value;
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        return ComparisonUtils.compare(evaluatedNode, this.value) == 0;
    }

    public static EqualsExpressionBuilder builder() {
        return new EqualsExpressionBuilder();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsExpression)) {
            return false;
        }
        EqualsExpression other = (EqualsExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EqualsExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EqualsExpression(super=" + super.toString() + ", value=" + this.getValue() + ")";
    }

    public static class EqualsExpressionBuilder {
        private String path;
        private Object value;

        EqualsExpressionBuilder() {
        }

        public EqualsExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public EqualsExpressionBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public EqualsExpression build() {
            return new EqualsExpression(this.path, this.value);
        }

        public String toString() {
            return "EqualsExpression.EqualsExpressionBuilder(path=" + this.path + ", value=" + this.value + ")";
        }
    }
}

