/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.numeric;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;

public abstract class NumericJsonPathBasedExpression
extends JsonPathBasedExpression {
    private Number value;

    protected NumericJsonPathBasedExpression(ExpressionType type) {
        super(type);
    }

    protected NumericJsonPathBasedExpression(ExpressionType type, String path, Number value) {
        super(type, path);
        this.value = value;
    }

    @Override
    protected final boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (null == evaluatedNode || !evaluatedNode.isNumber()) {
            return false;
        }
        int comparisonResult = 0;
        if (evaluatedNode.isIntegralNumber()) {
            comparisonResult = Long.compare(evaluatedNode.asLong(), this.value.longValue());
        } else if (evaluatedNode.isFloatingPointNumber()) {
            comparisonResult = Double.compare(evaluatedNode.asDouble(), this.value.doubleValue());
        }
        return this.evaluate(context, comparisonResult);
    }

    protected abstract boolean evaluate(ExpressionEvaluationContext var1, int var2);

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumericJsonPathBasedExpression)) {
            return false;
        }
        NumericJsonPathBasedExpression other = (NumericJsonPathBasedExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Number this$value = this.getValue();
        Number other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NumericJsonPathBasedExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Number $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NumericJsonPathBasedExpression(super=" + super.toString() + ", value=" + this.getValue() + ")";
    }
}

