/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.equality;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.utils.ComparisonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InExpression
extends JsonPathBasedExpression {
    private List<Object> values;

    public InExpression() {
        super(ExpressionType.in);
    }

    public InExpression(String path, List<Object> values) {
        super(ExpressionType.in, path);
        this.values = values;
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        return null != this.values && !ComparisonUtils.isNodeMissingOrNull(evaluatedNode) && this.values.stream().anyMatch(value -> ComparisonUtils.compare(evaluatedNode, value) == 0);
    }

    public static InExpressionBuilder builder() {
        return new InExpressionBuilder();
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InExpression)) {
            return false;
        }
        InExpression other = (InExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Object> this$values = this.getValues();
        List<Object> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<Object> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "InExpression(super=" + super.toString() + ", values=" + this.getValues() + ")";
    }

    public static class InExpressionBuilder {
        private String path;
        private ArrayList<Object> values;

        InExpressionBuilder() {
        }

        public InExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public InExpressionBuilder value(Object value) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
            return this;
        }

        public InExpressionBuilder values(Collection<? extends Object> values) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.addAll(values);
            return this;
        }

        public InExpression build() {
            List<Object> values;
            switch (this.values == null ? 0 : this.values.size()) {
                case 0: {
                    values = Collections.emptyList();
                    break;
                }
                case 1: {
                    values = Collections.singletonList(this.values.get(0));
                    break;
                }
                default: {
                    values = Collections.unmodifiableList(new ArrayList<Object>(this.values));
                }
            }
            return new InExpression(this.path, values);
        }

        public String toString() {
            return "InExpression.InExpressionBuilder(path=" + this.path + ", values=" + this.values + ")";
        }
    }
}

