/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.meta;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.utils.ComparisonUtils;

public class NotExistsExpression
extends JsonPathBasedExpression {
    public NotExistsExpression() {
        super(ExpressionType.not_exists);
    }

    public NotExistsExpression(String path) {
        super(ExpressionType.not_exists, path);
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        return ComparisonUtils.isNodeMissingOrNull(evaluatedNode);
    }

    public static NotExistsExpressionBuilder builder() {
        return new NotExistsExpressionBuilder();
    }

    public static class NotExistsExpressionBuilder {
        private String path;

        NotExistsExpressionBuilder() {
        }

        public NotExistsExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public NotExistsExpression build() {
            return new NotExistsExpression(this.path);
        }

        public String toString() {
            return "NotExistsExpression.NotExistsExpressionBuilder(path=" + this.path + ")";
        }
    }
}

