/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.appform.jsonrules.Expression;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.preoperation.PreOperation;

public abstract class JsonPathBasedExpression
extends Expression {
    private String path;
    private PreOperation<?> preoperation;
    private static final ObjectMapper mapper = new ObjectMapper();

    protected JsonPathBasedExpression(ExpressionType type) {
        super(type);
    }

    protected JsonPathBasedExpression(ExpressionType type, String path, PreOperation<?> preoperation) {
        this(type);
        this.path = path;
        this.preoperation = preoperation;
    }

    @Override
    public final boolean evaluate(ExpressionEvaluationContext context) {
        JsonNode evaluatedNode = context.getNode().at(this.path);
        if (this.preoperation != null) {
            Object computedValue = this.preoperation.compute(evaluatedNode);
            evaluatedNode = mapper.valueToTree(computedValue);
        }
        return this.evaluate(context, this.path, evaluatedNode);
    }

    protected abstract boolean evaluate(ExpressionEvaluationContext var1, String var2, JsonNode var3);

    public String getPath() {
        return this.path;
    }

    public PreOperation<?> getPreoperation() {
        return this.preoperation;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPreoperation(PreOperation<?> preoperation) {
        this.preoperation = preoperation;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonPathBasedExpression)) {
            return false;
        }
        JsonPathBasedExpression other = (JsonPathBasedExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        PreOperation<?> this$preoperation = this.getPreoperation();
        PreOperation<?> other$preoperation = other.getPreoperation();
        return !(this$preoperation == null ? other$preoperation != null : !((Object)this$preoperation).equals(other$preoperation));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JsonPathBasedExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        PreOperation<?> $preoperation = this.getPreoperation();
        result = result * 59 + ($preoperation == null ? 43 : ((Object)$preoperation).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "JsonPathBasedExpression(super=" + super.toString() + ", path=" + this.getPath() + ", preoperation=" + this.getPreoperation() + ")";
    }
}

