/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.meta;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.utils.ComparisonUtils;

public class ExistsExpression
extends JsonPathBasedExpression {
    public ExistsExpression() {
        super(ExpressionType.exists);
    }

    public ExistsExpression(String path, PreOperation<?> preoperation) {
        super(ExpressionType.exists, path, preoperation);
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        return !ComparisonUtils.isNodeMissingOrNull(evaluatedNode);
    }

    public static ExistsExpressionBuilder builder() {
        return new ExistsExpressionBuilder();
    }

    public static class ExistsExpressionBuilder {
        private String path;
        private PreOperation<?> preoperation;

        ExistsExpressionBuilder() {
        }

        public ExistsExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ExistsExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public ExistsExpression build() {
            return new ExistsExpression(this.path, this.preoperation);
        }

        public String toString() {
            return "ExistsExpression.ExistsExpressionBuilder(path=" + this.path + ", preoperation=" + this.preoperation + ")";
        }
    }
}

