/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.string;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;

public class EmptyExpression
extends JsonPathBasedExpression {
    public EmptyExpression() {
        super(ExpressionType.empty);
    }

    public EmptyExpression(String path, PreOperation<?> preoperation) {
        super(ExpressionType.empty, path, preoperation);
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (!evaluatedNode.isTextual()) {
            return false;
        }
        String data = evaluatedNode.asText();
        return null == data || data.isEmpty();
    }

    public static EmptyExpressionBuilder builder() {
        return new EmptyExpressionBuilder();
    }

    public static class EmptyExpressionBuilder {
        private String path;
        private PreOperation<?> preoperation;

        EmptyExpressionBuilder() {
        }

        public EmptyExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public EmptyExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public EmptyExpression build() {
            return new EmptyExpression(this.path, this.preoperation);
        }

        public String toString() {
            return "EmptyExpression.EmptyExpressionBuilder(path=" + this.path + ", preoperation=" + this.preoperation + ")";
        }
    }
}

